/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.datasources.v2.V2SessionCatalog;
import org.apache.spark.sql.execution.datasources.v2.V2SessionCatalogBaseSuite;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005]3A\u0001C\u0005\u00011!)Q\u0004\u0001C\u0001=!)\u0001\u0005\u0001C)C!)\u0001\u0006\u0001C)C!9\u0011\u0006\u0001b\u0001\n\u0013Q\u0003BB\u001a\u0001A\u0003%1\u0006C\u00035\u0001\u0011%Q\u0007C\u0003L\u0001\u0011%AJ\u0001\u000eWeM+7o]5p]\u000e\u000bG/\u00197pOR\u000b'\r\\3Tk&$XM\u0003\u0002\u000b\u0017\u0005\u0011aO\r\u0006\u0003\u00195\t1\u0002Z1uCN|WO]2fg*\u0011abD\u0001\nKb,7-\u001e;j_:T!\u0001E\t\u0002\u0007M\fHN\u0003\u0002\u0013'\u0005)1\u000f]1sW*\u0011A#F\u0001\u0007CB\f7\r[3\u000b\u0003Y\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\r\u0011\u0005iYR\"A\u0005\n\u0005qI!!\u0007,3'\u0016\u001c8/[8o\u0007\u0006$\u0018\r\\8h\u0005\u0006\u001cXmU;ji\u0016\fa\u0001P5oSRtD#A\u0010\u0011\u0005i\u0001\u0011!\u00032fM>\u0014X-\u00117m)\u0005\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#\u0001B+oSR\f\u0001\"\u00194uKJ\fE\u000e\\\u0001\ri\u0016\u001cH/\u00133f]RtUm^\u000b\u0002WA\u0011A&M\u0007\u0002[)\u0011afL\u0001\bG\u0006$\u0018\r\\8h\u0015\t\u0001t\"A\u0005d_:tWm\u0019;pe&\u0011!'\f\u0002\u000b\u0013\u0012,g\u000e^5gS\u0016\u0014\u0018!\u0004;fgRLE-\u001a8u\u001d\u0016<\b%\u0001\u0010nC.,\u0017+^1mS\u001aLW\r\u001a)bi\"<\u0016\u000e\u001e5XCJ,\u0007n\\;tKR\u0011aG\u0010\t\u0003oqj\u0011\u0001\u000f\u0006\u0003si\n1A\\3u\u0015\u0005Y\u0014\u0001\u00026bm\u0006L!!\u0010\u001d\u0003\u0007U\u0013\u0016\nC\u0003@\r\u0001\u0007\u0001)\u0001\u0003qCRD\u0007CA!I\u001d\t\u0011e\t\u0005\u0002DI5\tAI\u0003\u0002F/\u00051AH]8pizJ!a\u0012\u0013\u0002\rA\u0013X\rZ3g\u0013\tI%J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000f\u0012\nqCZ5mi\u0016\u0014hK\r+bE2,\u0007K]8qKJ$\u0018.Z:\u0015\u00055\u0003\u0006\u0003B!O\u0001\u0002K!a\u0014&\u0003\u00075\u000b\u0007\u000fC\u0003R\u000f\u0001\u0007!+\u0001\u0006qe>\u0004XM\u001d;jKN\u0004Ba\u0015,A\u00016\tAK\u0003\u0002Vu\u0005!Q\u000f^5m\u0013\tyE\u000b")
public class V2SessionCatalogTableSuite
extends V2SessionCatalogBaseSuite {
    private final Identifier testIdentNew;

    @Override
    public void beforeAll() {
        SharedSparkSession.beforeAll$(this);
        V2SessionCatalog catalog = this.newCatalog();
        catalog.createNamespace((String[])((Object[])new String[]{"db"}), this.emptyProps());
        catalog.createNamespace((String[])((Object[])new String[]{"db2"}), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"location"), (Object)"file:///db2.db")}))).asJava());
        catalog.createNamespace((String[])((Object[])new String[]{"ns"}), this.emptyProps());
        catalog.createNamespace((String[])((Object[])new String[]{"ns2"}), this.emptyProps());
    }

    @Override
    public void afterAll() {
        V2SessionCatalog catalog = this.newCatalog();
        catalog.dropNamespace((String[])((Object[])new String[]{"db"}), true);
        catalog.dropNamespace((String[])((Object[])new String[]{"db2"}), true);
        catalog.dropNamespace((String[])((Object[])new String[]{"ns"}), true);
        catalog.dropNamespace((String[])((Object[])new String[]{"ns2"}), true);
        SharedSparkSession.afterAll$(this);
    }

    private Identifier testIdentNew() {
        return this.testIdentNew;
    }

    private URI makeQualifiedPathWithWarehouse(String path) {
        Path p = new Path(this.spark().sessionState().conf().warehousePath(), path);
        FileSystem fs = p.getFileSystem(this.spark().sessionState().newHadoopConf());
        return fs.makeQualified(p).toUri();
    }

    private scala.collection.immutable.Map<String, String> filterV2TableProperties(java.util.Map<String, String> properties) {
        return ((IterableOnceOps)((IterableOps)((IterableOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(properties).asScala()).filter((Function1 & Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)V2SessionCatalogTableSuite.$anonfun$filterV2TableProperties$1(kv)))).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)V2SessionCatalogTableSuite.$anonfun$filterV2TableProperties$2(x$1)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ boolean $anonfun$filterV2TableProperties$1(Tuple2 kv) {
        return !CatalogV2Util$.MODULE$.TABLE_RESERVED_PROPERTIES().contains(kv._1());
    }

    public static final /* synthetic */ boolean $anonfun$filterV2TableProperties$2(Tuple2 x$1) {
        return !((String)x$1._1()).startsWith("option.");
    }

    public V2SessionCatalogTableSuite() {
        this.after((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> {
            this.newCatalog().dropTable(this.testIdent());
            return this.newCatalog().dropTable(this.testIdentNew());
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.testIdentNew = Identifier.of((String[])this.testNs(), (String)"test_table_new");
        this.test("listTables", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Identifier ident1 = Identifier.of((String[])((String[])((Object[])new String[]{"ns"})), (String)"test_table_1");
            Identifier ident2 = Identifier.of((String[])((String[])((Object[])new String[]{"ns"})), (String)"test_table_2");
            Identifier ident3 = Identifier.of((String[])((String[])((Object[])new String[]{"ns2"})), (String)"test_table_1");
            Object $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])catalog.listTables((String[])((Object[])new String[]{"ns"})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            catalog.createTable(ident1, this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Set $org_scalatest_assert_macro_left2 = Predef$.MODULE$.wrapRefArray((Object[])catalog.listTables((String[])((Object[])new String[]{"ns"}))).toSet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident1}));
            Set set = $org_scalatest_assert_macro_left2;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            Object $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])catalog.listTables((String[])((Object[])new String[]{"ns2"})));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left3), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            catalog.createTable(ident3, this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            catalog.createTable(ident2, this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Set $org_scalatest_assert_macro_left4 = Predef$.MODULE$.wrapRefArray((Object[])catalog.listTables((String[])((Object[])new String[]{"ns"}))).toSet();
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident1, ident2}));
            Set set3 = $org_scalatest_assert_macro_left4;
            Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            Set $org_scalatest_assert_macro_left5 = Predef$.MODULE$.wrapRefArray((Object[])catalog.listTables((String[])((Object[])new String[]{"ns2"}))).toSet();
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident3}));
            Set set5 = $org_scalatest_assert_macro_left5;
            Set set6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right3, !(set5 != null ? !set5.equals(set6) : set6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            catalog.dropTable(ident1);
            Set $org_scalatest_assert_macro_left6 = Predef$.MODULE$.wrapRefArray((Object[])catalog.listTables((String[])((Object[])new String[]{"ns"}))).toSet();
            Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident2}));
            Set set7 = $org_scalatest_assert_macro_left6;
            Set set8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right4, !(set7 != null ? !set7.equals(set8) : set8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            catalog.dropTable(ident2);
            Object $org_scalatest_assert_macro_left7 = Predef$.MODULE$.refArrayOps((Object[])catalog.listTables((String[])((Object[])new String[]{"ns"})));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left7), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
            Set $org_scalatest_assert_macro_left8 = Predef$.MODULE$.wrapRefArray((Object[])catalog.listTables((String[])((Object[])new String[]{"ns2"}))).toSet();
            Set $org_scalatest_assert_macro_right5 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident3}));
            Set set9 = $org_scalatest_assert_macro_left8;
            Set set10 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right5, !(set9 != null ? !set9.equals(set10) : set10 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            return catalog.dropTable(ident3);
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.test("createTable", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Seq parsed;
            V2SessionCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Seq $org_scalatest_assert_macro_left = parsed = CatalystSqlParser$.MODULE$.parseMultipartIdentifier(table.name());
            Seq $org_scalatest_assert_macro_right = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"db", "test_table"}));
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            StructType $org_scalatest_assert_macro_left2 = table.schema();
            StructType $org_scalatest_assert_macro_right2 = this.schema();
            StructType structType = $org_scalatest_assert_macro_left2;
            StructType structType2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            scala.collection.immutable.Map<String, String> $org_scalatest_assert_macro_left3 = this.filterV2TableProperties(table.properties());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.immutable.Map<String, String> map = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !map.equals((Object)map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        this.test("createTable: with properties", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Seq parsed;
            V2SessionCatalog catalog = this.newCatalog();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("property", "value");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), properties);
            Seq $org_scalatest_assert_macro_left = parsed = CatalystSqlParser$.MODULE$.parseMultipartIdentifier(table.name());
            Seq $org_scalatest_assert_macro_right = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"db", "test_table"}));
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            StructType $org_scalatest_assert_macro_left2 = table.schema();
            StructType $org_scalatest_assert_macro_right2 = this.schema();
            StructType structType = $org_scalatest_assert_macro_left2;
            StructType structType2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            java.util.Map $org_scalatest_assert_macro_left3 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.filterV2TableProperties(table.properties())).asJava();
            HashMap<String, String> $org_scalatest_assert_macro_right3 = properties;
            java.util.Map map = $org_scalatest_assert_macro_left3;
            HashMap<String, String> hashMap = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", $org_scalatest_assert_macro_right3, !(map != null ? !((Object)map).equals(hashMap) : hashMap != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        this.test("createTable: table already exists", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            TableAlreadyExistsException exc = (TableAlreadyExistsException)this.intercept((Function0 & Serializable)() -> catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps()), ClassTag$.MODULE$.apply(TableAlreadyExistsException.class), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
            String $org_scalatest_assert_macro_left = exc.message();
            String $org_scalatest_assert_macro_right = table.name();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            String $org_scalatest_assert_macro_left2 = exc.message();
            String $org_scalatest_assert_macro_right2 = "already exists";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        this.test("createTable: location", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            HashMap<String, String> properties = new HashMap<String, String>();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            V1Table t1 = (V1Table)catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), properties);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(t1.catalogTable().location());
            URI $org_scalatest_assert_macro_right = this.spark().sessionState().catalog().defaultTablePath(CatalogV2Implicits$.MODULE$.IdentifierHelper(this.testIdent()).asTableIdentifier());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            catalog.dropTable(this.testIdent());
            properties.put("location", "relative/path");
            V1Table t2 = (V1Table)catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), properties);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(t2.catalogTable().location());
            URI $org_scalatest_assert_macro_right2 = this.makeQualifiedPathWithWarehouse("db.db/relative/path");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
            catalog.dropTable(this.testIdent());
            properties.put("location", "/absolute/path");
            V1Table t3 = (V1Table)catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), properties);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(t3.catalogTable().location().toString());
            String $org_scalatest_assert_macro_right3 = "file:///absolute/path";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
            catalog.dropTable(this.testIdent());
            properties.put("location", "file:/absolute/path");
            V1Table t4 = (V1Table)catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), properties);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(t4.catalogTable().location().toString());
            String $org_scalatest_assert_macro_right4 = "file:/absolute/path";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
            return catalog.dropTable(this.testIdent());
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
        this.test("tableExists", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
            catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
            catalog.dropTable(this.testIdent());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
        this.test("loadTable", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Table loaded = catalog.loadTable(this.testIdent());
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = loaded.name();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
            StructType $org_scalatest_assert_macro_left2 = table.schema();
            StructType $org_scalatest_assert_macro_right2 = loaded.schema();
            StructType structType = $org_scalatest_assert_macro_left2;
            StructType structType2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right3 = loaded.properties();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        this.test("loadTable: table does not exist", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            NoSuchTableException exc = (NoSuchTableException)this.intercept((Function0 & Serializable)() -> catalog.loadTable(this.testIdent()), ClassTag$.MODULE$.apply(NoSuchTableException.class), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
            String $org_scalatest_assert_macro_left = exc.message();
            String $org_scalatest_assert_macro_right = "Table or view 'test_table' not found in database 'db'";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
        this.test("invalidateTable", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            catalog.invalidateTable(this.testIdent());
            Table loaded = catalog.loadTable(this.testIdent());
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = loaded.name();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
            StructType $org_scalatest_assert_macro_left2 = table.schema();
            StructType $org_scalatest_assert_macro_right2 = loaded.schema();
            StructType structType = $org_scalatest_assert_macro_left2;
            StructType structType2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right3 = loaded.properties();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
        this.test("invalidateTable: table does not exist", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)catalog.tableExists(this.testIdent())));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
            catalog.invalidateTable(this.testIdent());
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
        this.test("alterTable: add property", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            scala.collection.immutable.Map<String, String> $org_scalatest_assert_macro_left = this.filterV2TableProperties(table.properties());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.immutable.Map<String, String> map = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals((Object)map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.setProperty((String)"prop-1", (String)"1")}));
            scala.collection.immutable.Map<String, String> $org_scalatest_assert_macro_left2 = this.filterV2TableProperties(updated.properties());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.immutable.Map<String, String> map3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Map map4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals((Object)map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
            Table loaded = catalog.loadTable(this.testIdent());
            scala.collection.immutable.Map<String, String> $org_scalatest_assert_macro_left3 = this.filterV2TableProperties(loaded.properties());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.immutable.Map<String, String> map5 = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Map map6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map5 != null ? !map5.equals((Object)map6) : map6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
            scala.collection.immutable.Map<String, String> $org_scalatest_assert_macro_left4 = this.filterV2TableProperties(table.properties());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.immutable.Map<String, String> map7 = $org_scalatest_assert_macro_left4;
            scala.collection.immutable.Map map8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map7 != null ? !map7.equals((Object)map8) : map8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        this.test("alterTable: add property to existing", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("prop-1", "1");
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), properties);
            scala.collection.immutable.Map<String, String> $org_scalatest_assert_macro_left = this.filterV2TableProperties(table.properties());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.immutable.Map<String, String> map = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals((Object)map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.setProperty((String)"prop-2", (String)"2")}));
            scala.collection.immutable.Map<String, String> $org_scalatest_assert_macro_left2 = this.filterV2TableProperties(updated.properties());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-2"), (Object)"2")}));
            scala.collection.immutable.Map<String, String> map3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Map map4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals((Object)map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
            Table loaded = catalog.loadTable(this.testIdent());
            scala.collection.immutable.Map<String, String> $org_scalatest_assert_macro_left3 = this.filterV2TableProperties(loaded.properties());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-2"), (Object)"2")}));
            scala.collection.immutable.Map<String, String> map5 = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Map map6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map5 != null ? !map5.equals((Object)map6) : map6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
            scala.collection.immutable.Map<String, String> $org_scalatest_assert_macro_left4 = this.filterV2TableProperties(table.properties());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.immutable.Map<String, String> map7 = $org_scalatest_assert_macro_left4;
            scala.collection.immutable.Map map8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map7 != null ? !map7.equals((Object)map8) : map8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
        this.test("alterTable: remove existing property", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("prop-1", "1");
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), properties);
            scala.collection.immutable.Map<String, String> $org_scalatest_assert_macro_left = this.filterV2TableProperties(table.properties());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.immutable.Map<String, String> map = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals((Object)map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.removeProperty((String)"prop-1")}));
            scala.collection.immutable.Map<String, String> $org_scalatest_assert_macro_left2 = this.filterV2TableProperties(updated.properties());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.immutable.Map<String, String> map3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Map map4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals((Object)map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
            Table loaded = catalog.loadTable(this.testIdent());
            scala.collection.immutable.Map<String, String> $org_scalatest_assert_macro_left3 = this.filterV2TableProperties(loaded.properties());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.immutable.Map<String, String> map5 = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Map map6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map5 != null ? !map5.equals((Object)map6) : map6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 308));
            scala.collection.immutable.Map<String, String> $org_scalatest_assert_macro_left4 = this.filterV2TableProperties(table.properties());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.immutable.Map<String, String> map7 = $org_scalatest_assert_macro_left4;
            scala.collection.immutable.Map map8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map7 != null ? !map7.equals((Object)map8) : map8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        this.test("alterTable: remove missing property", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            scala.collection.immutable.Map<String, String> $org_scalatest_assert_macro_left = this.filterV2TableProperties(table.properties());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.immutable.Map<String, String> map = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals((Object)map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.removeProperty((String)"prop-1")}));
            scala.collection.immutable.Map<String, String> $org_scalatest_assert_macro_left2 = this.filterV2TableProperties(updated.properties());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.immutable.Map<String, String> map3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Map map4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals((Object)map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
            Table loaded = catalog.loadTable(this.testIdent());
            scala.collection.immutable.Map<String, String> $org_scalatest_assert_macro_left3 = this.filterV2TableProperties(loaded.properties());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.immutable.Map<String, String> map5 = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Map map6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map5 != null ? !map5.equals((Object)map6) : map6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
            scala.collection.immutable.Map<String, String> $org_scalatest_assert_macro_left4 = this.filterV2TableProperties(table.properties());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.immutable.Map<String, String> map7 = $org_scalatest_assert_macro_left4;
            scala.collection.immutable.Map map8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map7 != null ? !map7.equals((Object)map8) : map8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
        this.test("alterTable: add top-level column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"ts"})), (DataType)TimestampType$.MODULE$)}));
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = this.schema().add("ts", (DataType)TimestampType$.MODULE$);
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 329));
        this.test("alterTable: add required column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"ts"})), (DataType)TimestampType$.MODULE$, (boolean)false)}));
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = this.schema().add("ts", (DataType)TimestampType$.MODULE$, false);
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
        this.test("alterTable: add column with comment", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"ts"})), (DataType)TimestampType$.MODULE$, (boolean)false, (String)"comment text")}));
            StructField field = new StructField("ts", (DataType)TimestampType$.MODULE$, false, StructField$.MODULE$.apply$default$4()).withComment("comment text");
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = this.schema().add(field);
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
        this.test("alterTable: add nested column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType tableSchema = this.schema().add("point", (DataType)pointStruct);
            Table table = catalog.createTable(this.testIdent(), tableSchema, (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = tableSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"point", "z"})), (DataType)DoubleType$.MODULE$)}));
            StructType expectedSchema = this.schema().add("point", (DataType)pointStruct.add("z", (DataType)DoubleType$.MODULE$));
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
        this.test("alterTable: add column to primitive field fails", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"data", "ts"})), (DataType)TimestampType$.MODULE$)})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "Not a struct";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "data";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
            StructType $org_scalatest_assert_macro_left4 = catalog.loadTable(this.testIdent()).schema();
            StructType $org_scalatest_assert_macro_right4 = this.schema();
            StructType structType3 = $org_scalatest_assert_macro_left4;
            StructType structType4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
        this.test("alterTable: add field to missing column fails", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"missing_col", "new_field"})), (DataType)StringType$.MODULE$)})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "missing_col";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "Cannot find";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 417));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
        this.test("alterTable: update column data type", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnType((String[])((String[])((Object[])new String[]{"id"})), (DataType)LongType$.MODULE$)}));
            StructType expectedSchema = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 430));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
        this.test("alterTable: update column nullability", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            StructType originalSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$, false).add("data", (DataType)StringType$.MODULE$);
            Table table = catalog.createTable(this.testIdent(), originalSchema, (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = originalSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnNullability((String[])((String[])((Object[])new String[]{"id"})), (boolean)true)}));
            StructType expectedSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 447));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 433));
        this.test("alterTable: update missing column fails", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 455));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnType((String[])((String[])((Object[])new String[]{"missing_col"})), (DataType)LongType$.MODULE$)})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 457));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "missing_col";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "Cannot find";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 463));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 450));
        this.test("alterTable: add comment", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 471));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnComment((String[])((String[])((Object[])new String[]{"id"})), (String)"comment text")}));
            StructType expectedSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$, true, "comment text").add("data", (DataType)StringType$.MODULE$);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 479));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 466));
        this.test("alterTable: replace comment", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 487));
            catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnComment((String[])((String[])((Object[])new String[]{"id"})), (String)"comment text")}));
            StructType expectedSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$, true, "replacement comment").add("data", (DataType)StringType$.MODULE$);
            Table updated = catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnComment((String[])((String[])((Object[])new String[]{"id"})), (String)"replacement comment")}));
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 498));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
        this.test("alterTable: add comment to missing column fails", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 506));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnComment((String[])((String[])((Object[])new String[]{"missing_col"})), (String)"comment")})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 508));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "missing_col";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 513));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "Cannot find";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 514));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
        this.test("alterTable: rename top-level column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 522));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.renameColumn((String[])((String[])((Object[])new String[]{"id"})), (String)"some_id")}));
            StructType expectedSchema = new StructType().add("some_id", (DataType)IntegerType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 528));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 517));
        this.test("alterTable: rename nested column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType tableSchema = this.schema().add("point", (DataType)pointStruct);
            Table table = catalog.createTable(this.testIdent(), tableSchema, (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = tableSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 539));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.renameColumn((String[])((String[])((Object[])new String[]{"point", "x"})), (String)"first")}));
            StructType newPointStruct = new StructType().add("first", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType expectedSchema = this.schema().add("point", (DataType)newPointStruct);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 547));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 531));
        this.test("alterTable: rename struct column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType tableSchema = this.schema().add("point", (DataType)pointStruct);
            Table table = catalog.createTable(this.testIdent(), tableSchema, (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = tableSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 558));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.renameColumn((String[])((String[])((Object[])new String[]{"point"})), (String)"p")}));
            StructType newPointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType expectedSchema = this.schema().add("p", (DataType)newPointStruct);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 566));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 550));
        this.test("alterTable: rename missing column fails", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 574));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.renameColumn((String[])((String[])((Object[])new String[]{"missing_col"})), (String)"new_name")})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 576));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "missing_col";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 581));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "Cannot find";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 582));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 569));
        this.test("alterTable: multiple changes", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType tableSchema = this.schema().add("point", (DataType)pointStruct);
            Table table = catalog.createTable(this.testIdent(), tableSchema, (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = tableSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 593));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.renameColumn((String[])((String[])((Object[])new String[]{"point", "x"})), (String)"first"), TableChange.renameColumn((String[])((String[])((Object[])new String[]{"point", "y"})), (String)"second")}));
            StructType newPointStruct = new StructType().add("first", (DataType)DoubleType$.MODULE$).add("second", (DataType)DoubleType$.MODULE$);
            StructType expectedSchema = this.schema().add("point", (DataType)newPointStruct);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 602));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 585));
        this.test("alterTable: delete top-level column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 610));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.deleteColumn((String[])((String[])((Object[])new String[]{"id"})), (Boolean)Predef$.MODULE$.boolean2Boolean(false))}));
            StructType expectedSchema = new StructType().add("data", (DataType)StringType$.MODULE$);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 616));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 605));
        this.test("alterTable: delete nested column", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType tableSchema = this.schema().add("point", (DataType)pointStruct);
            Table table = catalog.createTable(this.testIdent(), tableSchema, (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = tableSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 627));
            Table updated = catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.deleteColumn((String[])((String[])((Object[])new String[]{"point", "y"})), (Boolean)Predef$.MODULE$.boolean2Boolean(false))}));
            StructType newPointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$);
            StructType expectedSchema = this.schema().add("point", (DataType)newPointStruct);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 635));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 619));
        this.test("alterTable: delete missing column fails", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = this.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 643));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.deleteColumn((String[])((String[])((Object[])new String[]{"missing_col"})), (Boolean)Predef$.MODULE$.boolean2Boolean(false))})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 645));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "missing_col";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 649));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "Cannot find";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 650));
            catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.deleteColumn((String[])((String[])((Object[])new String[]{"missing_col"})), (Boolean)Predef$.MODULE$.boolean2Boolean(true))}));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right4 = this.schema();
            StructType structType3 = $org_scalatest_assert_macro_left4;
            StructType structType4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 654));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
        this.test("alterTable: delete missing nested column fails", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            StructType tableSchema = this.schema().add("point", (DataType)pointStruct);
            Table table = catalog.createTable(this.testIdent(), tableSchema, (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = tableSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 665));
            IllegalArgumentException exc = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.deleteColumn((String[])((String[])((Object[])new String[]{"point", "z"})), (Boolean)Predef$.MODULE$.boolean2Boolean(false))})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 667));
            String $org_scalatest_assert_macro_left2 = exc.getMessage();
            String $org_scalatest_assert_macro_right2 = "z";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 671));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = "Cannot find";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 672));
            catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.deleteColumn((String[])((String[])((Object[])new String[]{"point", "z"})), (Boolean)Predef$.MODULE$.boolean2Boolean(true))}));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right4 = tableSchema;
            StructType structType3 = $org_scalatest_assert_macro_left4;
            StructType structType4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 676));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 657));
        this.test("alterTable: table does not exist", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            NoSuchTableException exc = (NoSuchTableException)this.intercept((Function0 & Serializable)() -> catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.setProperty((String)"prop", (String)"val")})), ClassTag$.MODULE$.apply(NoSuchTableException.class), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 682));
            String $org_scalatest_assert_macro_left = exc.message();
            String $org_scalatest_assert_macro_right = CatalogV2Implicits$.MODULE$.IdentifierHelper(this.testIdent()).quoted();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 686));
            String $org_scalatest_assert_macro_left2 = exc.message();
            String $org_scalatest_assert_macro_right2 = "not found";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 687));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 679));
        this.test("alterTable: location", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 692));
            V1Table t1 = (V1Table)catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(t1.catalogTable().location());
            URI $org_scalatest_assert_macro_right = this.spark().sessionState().catalog().defaultTablePath(CatalogV2Implicits$.MODULE$.IdentifierHelper(this.testIdent()).asTableIdentifier());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 696));
            V1Table t2 = (V1Table)catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.setProperty((String)"location", (String)"relative/path")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(t2.catalogTable().location());
            URI $org_scalatest_assert_macro_right2 = this.makeQualifiedPathWithWarehouse("db.db/relative/path");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 702));
            V1Table t3 = (V1Table)catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.setProperty((String)"location", (String)"/absolute/path")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(t3.catalogTable().location().toString());
            String $org_scalatest_assert_macro_right3 = "file:///absolute/path";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 707));
            V1Table t4 = (V1Table)catalog.alterTable(this.testIdent(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.setProperty((String)"location", (String)"file:/absolute/path")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(t4.catalogTable().location().toString());
            String $org_scalatest_assert_macro_right4 = "file:/absolute/path";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 712));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 690));
        this.test("dropTable", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 718));
            catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 722));
            boolean wasDropped = catalog.dropTable(this.testIdent());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(wasDropped, "wasDropped", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 726));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 727));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 715));
        this.test("dropTable: table does not exist", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 733));
            boolean wasDropped = catalog.dropTable(this.testIdent());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(wasDropped, "wasDropped", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 737));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 738));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 730));
        this.test("renameTable", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 744));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdentNew()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdentNew)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 745));
            catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 749));
            catalog.renameTable(this.testIdent(), this.testIdentNew());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 752));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdentNew()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdentNew)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 753));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 741));
        this.test("renameTable: fail if table does not exist", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            NoSuchTableException exc = (NoSuchTableException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.renameTable(this.testIdent(), this.testIdentNew()), ClassTag$.MODULE$.apply(NoSuchTableException.class), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 759));
            String $org_scalatest_assert_macro_left = exc.message();
            String $org_scalatest_assert_macro_right = "Table or view 'test_table' not found in database 'db'";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 763));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 756));
        this.test("renameTable: fail if new table name already exists", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 769));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdentNew()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdentNew)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 770));
            catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            catalog.createTable(this.testIdentNew(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 775));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdentNew()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdentNew)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 776));
            TableAlreadyExistsException exc = (TableAlreadyExistsException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.renameTable(this.testIdent(), this.testIdentNew()), ClassTag$.MODULE$.apply(TableAlreadyExistsException.class), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 778));
            String $org_scalatest_assert_macro_left = exc.message();
            String $org_scalatest_assert_macro_right = CatalogV2Implicits$.MODULE$.IdentifierHelper(this.testIdentNew()).quoted();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 782));
            String $org_scalatest_assert_macro_left2 = exc.message();
            String $org_scalatest_assert_macro_right2 = "already exists";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 783));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 766));
        this.test("renameTable: fail if db does not match for old and new table names", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            V2SessionCatalog catalog = this.newCatalog();
            Identifier testIdentNewOtherDb = Identifier.of((String[])((String[])((Object[])new String[]{"db2"})), (String)"test_table_new");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 790));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(testIdentNewOtherDb), "catalog.tableExists(testIdentNewOtherDb)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 791));
            catalog.createTable(this.testIdent(), this.schema(), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), this.emptyProps());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(V2SessionCatalogTableSuite.this.testIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 795));
            AnalysisException exc = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.renameTable(this.testIdent(), testIdentNewOtherDb), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 797))));
            String $org_scalatest_assert_macro_left = exc.message();
            String $org_scalatest_assert_macro_right = CatalogV2Implicits$.MODULE$.NamespaceHelper(this.testIdent().namespace()).quoted();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 801));
            String $org_scalatest_assert_macro_left2 = exc.message();
            String $org_scalatest_assert_macro_right2 = CatalogV2Implicits$.MODULE$.NamespaceHelper(testIdentNewOtherDb.namespace()).quoted();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 802));
            String $org_scalatest_assert_macro_left3 = exc.message();
            String $org_scalatest_assert_macro_right3 = "RENAME TABLE source and destination databases do not match";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 803));
        }, new Position("V2SessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 786));
    }
}

