/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import com.univocity.parsers.csv.CsvParser;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.spark.input.PortableDataStream;
import org.apache.spark.input.StreamInputFormat;
import org.apache.spark.rdd.BinaryFileRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker;
import org.apache.spark.sql.catalyst.csv.CSVInferSchema;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityParser;
import org.apache.spark.sql.catalyst.csv.UnivocityParser$;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.csv.CSVDataSource;
import org.apache.spark.sql.execution.datasources.csv.CSVUtils$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class MultiLineCSVDataSource$
extends CSVDataSource {
    public static final MultiLineCSVDataSource$ MODULE$ = new MultiLineCSVDataSource$();
    private static final boolean isSplitable = false;

    @Override
    public boolean isSplitable() {
        return isSplitable;
    }

    @Override
    public Iterator<InternalRow> readFile(Configuration conf, PartitionedFile file, UnivocityParser parser, CSVHeaderChecker headerChecker, StructType requiredSchema) {
        return UnivocityParser$.MODULE$.parseStream(CodecStreams$.MODULE$.createInputStreamWithCloseResource(conf, new Path(new URI(file.filePath()))), parser, headerChecker, requiredSchema);
    }

    @Override
    public StructType infer(SparkSession sparkSession, Seq<FileStatus> inputPaths, CSVOptions parsedOptions) {
        StructType structType;
        RDD<PortableDataStream> csv = this.createBaseRdd(sparkSession, inputPaths, parsedOptions);
        Option option = ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])csv.flatMap((Function1 & Serializable)lines -> {
            Path path = new Path(lines.getPath());
            return UnivocityParser$.MODULE$.tokenizeStream(CodecStreams$.MODULE$.createInputStreamWithCloseResource(lines.getConfiguration(), path), false, new CsvParser(parsedOptions.asParserSettings()), parsedOptions.charset());
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).take(1)));
        if (option instanceof Some) {
            Some some = (Some)option;
            String[] firstRow = (String[])some.value();
            boolean caseSensitive = sparkSession.sessionState().conf().caseSensitiveAnalysis();
            String[] header = CSVUtils$.MODULE$.makeSafeHeader(firstRow, caseSensitive, parsedOptions);
            RDD tokenRDD = csv.flatMap((Function1 & Serializable)lines -> UnivocityParser$.MODULE$.tokenizeStream(CodecStreams$.MODULE$.createInputStreamWithCloseResource(lines.getConfiguration(), new Path(lines.getPath())), parsedOptions.headerFlag(), new CsvParser(parsedOptions.asParserSettings()), parsedOptions.charset()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
            RDD<String[]> sampled = CSVUtils$.MODULE$.sample((RDD<String[]>)tokenRDD, parsedOptions);
            structType = (StructType)SQLExecution$.MODULE$.withSQLConfPropagated(sparkSession, (Function0 & Serializable)() -> new CSVInferSchema(parsedOptions).infer(sampled, header));
        } else if (None$.MODULE$.equals(option)) {
            structType = StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil());
        } else {
            throw new MatchError((Object)option);
        }
        return structType;
    }

    private RDD<PortableDataStream> createBaseRdd(SparkSession sparkSession, Seq<FileStatus> inputPaths, CSVOptions options) {
        Seq paths = (Seq)inputPaths.map((Function1 & Serializable)x$5 -> x$5.getPath());
        String name = paths.mkString(",");
        Job job = Job.getInstance((Configuration)sparkSession.sessionState().newHadoopConfWithOptions((Map<String, String>)options.parameters()));
        FileInputFormat.setInputPaths((Job)job, (Path[])((Path[])paths.toArray(ClassTag$.MODULE$.apply(Path.class))));
        Configuration conf = job.getConfiguration();
        BinaryFileRDD rdd = new BinaryFileRDD(sparkSession.sparkContext(), StreamInputFormat.class, String.class, PortableDataStream.class, conf, sparkSession.sparkContext().defaultMinPartitions());
        return RDD$.MODULE$.rddToPairRDDFunctions(rdd.setName(new StringBuilder(9).append("CSVFile: ").append(name).toString()), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(PortableDataStream.class), (Ordering)Ordering.String$.MODULE$).values();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MultiLineCSVDataSource$.class);
    }

    private MultiLineCSVDataSource$() {
    }
}

