/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.index.TableIndex;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.aggregate.Avg;
import org.apache.spark.sql.connector.expressions.aggregate.Count;
import org.apache.spark.sql.connector.expressions.aggregate.CountStar;
import org.apache.spark.sql.connector.expressions.aggregate.Max;
import org.apache.spark.sql.connector.expressions.aggregate.Min;
import org.apache.spark.sql.connector.expressions.aggregate.Sum;
import org.apache.spark.sql.connector.util.V2ExpressionSQLBuilder;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.datasources.jdbc.connection.ConnectionProvider$;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MetadataBuilder;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0005\rmf!B\u00181\u0003\u0003Y\u0004\"\u0002+\u0001\t\u0003)\u0006\"\u0002-\u0001\r\u0003I\u0006\"B4\u0001\t\u0003A\u0007bBA\u0001\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003#\u0001A\u0011AA\n\u0011\u001d\t\t\u0006\u0001C\u0001\u0003'Bq!!\u0017\u0001\t\u0003\tY\u0006C\u0004\u0002b\u0001!\t!a\u0019\t\u000f\u00055\u0004\u0001\"\u0001\u0002p!9\u0011Q\u000e\u0001\u0005\u0002\u0005e\u0004\"CAE\u0001E\u0005I\u0011AAF\u0011\u001d\ty\n\u0001C\u0001\u0003CC\u0001\"a.\u0001\t#\u0001\u0014\u0011\u0018\u0005\b\u0003\u0003\u0004A\u0011AAb\r\u001d\ty\r\u0001\u00011\u0003#Da\u0001V\b\u0005\u0002\u0005\r\bbBAu\u001f\u0011\u0005\u00131\u001e\u0005\b\u0005\u001fyA\u0011\tB\t\u0011\u001d\u0011ib\u0004C!\u0005?AqA!\u000b\u0010\t\u0003\u0012Y\u0003C\u0004\u0003<\u0001!\tA!\u0010\t\u000f\t\r\u0003\u0001\"\u0001\u0003F!9!Q\u000b\u0001\u0005\u0002\t]\u0003b\u0002B6\u0001\u0011\u0005!Q\u000e\u0005\b\u0005\u0003\u0003A\u0011\u0001BB\u0011\u001d\u0011i\t\u0001C\u0001\u0005\u001fCqAa&\u0001\t\u0003\u0011I\nC\u0004\u0003\u001c\u0002!\tA!(\t\u000f\t\u001d\u0006\u0001\"\u0001\u0003*\"9!\u0011\u001a\u0001\u0005\u0002\t-\u0007b\u0002Bk\u0001\u0011\u0005!q\u001b\u0005\b\u0005G\u0004A\u0011\u0001Bs\u0011\u001d\u0011Y\u000f\u0001C\u0001\u0005[DqAa>\u0001\t\u0003\u0011I\u0010C\u0004\u0004\u0004\u0001!\ta!\u0002\t\u000f\r-\u0001\u0001\"\u0001\u0004\u000e!911\u0003\u0001\u0005\u0002\rU\u0001bBB\r\u0001\u0011\u000511\u0004\u0005\b\u0007C\u0001A\u0011AB\u0012\u0011\u001d\u0019\t\u0005\u0001C\u0001\u0007\u0007Bqa!\u0014\u0001\t\u0003\u0019y\u0005C\u0004\u0004V\u0001!\taa\u0016\t\u000f\r5\u0004\u0001\"\u0001\u0004p!91q\u0011\u0001\u0005\u0002\r%\u0005bBBN\u0001\u0011\u00051Q\u0014\u0005\b\u0007?\u0003A\u0011ABQ\u0005-QEMY2ES\u0006dWm\u0019;\u000b\u0005E\u0012\u0014\u0001\u00026eE\u000eT!a\r\u001b\u0002\u0007M\fHN\u0003\u00026m\u0005)1\u000f]1sW*\u0011q\u0007O\u0001\u0007CB\f7\r[3\u000b\u0003e\n1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u001fC\u001dB\u0011Q\bQ\u0007\u0002})\tq(A\u0003tG\u0006d\u0017-\u0003\u0002B}\t1\u0011I\\=SK\u001a\u0004\"aQ&\u000f\u0005\u0011KeBA#I\u001b\u00051%BA$;\u0003\u0019a$o\\8u}%\tq(\u0003\u0002K}\u00059\u0001/Y2lC\u001e,\u0017B\u0001'N\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tQe\b\u0005\u0002P%6\t\u0001K\u0003\u0002Ri\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002T!\n9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001W!\t9\u0006!D\u00011\u0003%\u0019\u0017M\u001c%b]\u0012dW\r\u0006\u0002[;B\u0011QhW\u0005\u00039z\u0012qAQ8pY\u0016\fg\u000eC\u0003_\u0005\u0001\u0007q,A\u0002ve2\u0004\"\u0001\u00193\u000f\u0005\u0005\u0014\u0007CA#?\u0013\t\u0019g(\u0001\u0004Qe\u0016$WMZ\u0005\u0003K\u001a\u0014aa\u0015;sS:<'BA2?\u0003=9W\r^\"bi\u0006d\u0017p\u001d;UsB,G#B5sof\\\bcA\u001fkY&\u00111N\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00055\u0004X\"\u00018\u000b\u0005=\u0014\u0014!\u0002;za\u0016\u001c\u0018BA9o\u0005!!\u0015\r^1UsB,\u0007\"B:\u0004\u0001\u0004!\u0018aB:rYRK\b/\u001a\t\u0003{UL!A\u001e \u0003\u0007%sG\u000fC\u0003y\u0007\u0001\u0007q,\u0001\u0005usB,g*Y7f\u0011\u0015Q8\u00011\u0001u\u0003\u0011\u0019\u0018N_3\t\u000bq\u001c\u0001\u0019A?\u0002\u00055$\u0007CA7\u007f\u0013\tyhNA\bNKR\fG-\u0019;b\u0005VLG\u000eZ3s\u0003-9W\r\u001e&E\u0005\u000e#\u0016\u0010]3\u0015\t\u0005\u0015\u0011Q\u0002\t\u0005{)\f9\u0001E\u0002X\u0003\u0013I1!a\u00031\u0005!QEMY2UsB,\u0007BBA\b\t\u0001\u0007A.\u0001\u0002ei\u000692M]3bi\u0016\u001cuN\u001c8fGRLwN\u001c$bGR|'/\u001f\u000b\u0005\u0003+\tI\u0003\u0005\u0004>\u0003/!\u00181D\u0005\u0004\u00033q$!\u0003$v]\u000e$\u0018n\u001c82!\u0011\ti\"!\n\u000e\u0005\u0005}!bA\u001a\u0002\")\u0011\u00111E\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002(\u0005}!AC\"p]:,7\r^5p]\"9\u00111F\u0003A\u0002\u00055\u0012aB8qi&|gn\u001d\t\u0005\u0003_\tY$\u0004\u0002\u00022)\u0019\u0011'a\r\u000b\t\u0005U\u0012qG\u0001\fI\u0006$\u0018m]8ve\u000e,7OC\u0002\u0002:I\n\u0011\"\u001a=fGV$\u0018n\u001c8\n\t\u0005u\u0012\u0011\u0007\u0002\f\u0015\u0012\u00135i\u00149uS>t7\u000fK\u0003\u0006\u0003\u0003\ni\u0005\u0005\u0003\u0002D\u0005%SBAA#\u0015\r\t9\u0005N\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA&\u0003\u000b\u0012QaU5oG\u0016\f#!a\u0014\u0002\u000bMr3G\f\u0019\u0002\u001fE,x\u000e^3JI\u0016tG/\u001b4jKJ$2aXA+\u0011\u0019\t9F\u0002a\u0001?\u000691m\u001c7OC6,\u0017aE4fiR\u000b'\r\\3Fq&\u001cHo])vKJLHcA0\u0002^!1\u0011qL\u0004A\u0002}\u000bQ\u0001^1cY\u0016\fabZ3u'\u000eDW-\\1Rk\u0016\u0014\u0018\u0010F\u0002`\u0003KBa!a\u0018\t\u0001\u0004y\u0006&\u0002\u0005\u0002B\u0005%\u0014EAA6\u0003\u0015\u0011d&\r\u00181\u0003A9W\r\u001e+sk:\u001c\u0017\r^3Rk\u0016\u0014\u0018\u0010F\u0002`\u0003cBa!a\u0018\n\u0001\u0004y\u0006&B\u0005\u0002B\u0005U\u0014EAA<\u0003\u0015\u0011df\r\u00181)\u0015y\u00161PA?\u0011\u0019\tyF\u0003a\u0001?\"I\u0011q\u0010\u0006\u0011\u0002\u0003\u0007\u0011\u0011Q\u0001\bG\u0006\u001c8-\u00193f!\ri$N\u0017\u0015\u0006\u0015\u0005\u0005\u0013QQ\u0011\u0003\u0003\u000f\u000bQA\r\u00185]A\n!dZ3u)J,hnY1uKF+XM]=%I\u00164\u0017-\u001e7uII*\"!!$+\t\u0005\u0005\u0015qR\u0016\u0003\u0003#\u0003B!a%\u0002\u001c6\u0011\u0011Q\u0013\u0006\u0005\u0003/\u000bI*A\u0005v]\u000eDWmY6fI*\u0019\u0011q\t \n\t\u0005u\u0015Q\u0013\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u00032fM>\u0014XMR3uG\"$b!a)\u0002*\u00065\u0006cA\u001f\u0002&&\u0019\u0011q\u0015 \u0003\tUs\u0017\u000e\u001e\u0005\b\u0003Wc\u0001\u0019AA\u000e\u0003)\u0019wN\u001c8fGRLwN\u001c\u0005\b\u0003_c\u0001\u0019AAY\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0006A\u0006MvlX\u0005\u0004\u0003k3'aA'ba\u0006IQm]2ba\u0016\u001c\u0016\u000f\u001c\u000b\u0004?\u0006m\u0006BBA_\u001b\u0001\u0007q,A\u0003wC2,X\rK\u0003\u000e\u0003\u0003\n)(\u0001\u0007d_6\u0004\u0018\u000e\\3WC2,X\r\u0006\u0003\u0002F\u0006-\u0007cA\u001f\u0002H&\u0019\u0011\u0011\u001a \u0003\u0007\u0005s\u0017\u0010C\u0004\u0002>:\u0001\r!!2)\u000b9\t\t%!\u001e\u0003\u001d)#%iQ*R\u0019\n+\u0018\u000e\u001c3feN\u0019q\"a5\u0011\t\u0005U\u0017q\\\u0007\u0003\u0003/TA!!7\u0002\\\u0006!Q\u000f^5m\u0015\r\tiNM\u0001\nG>tg.Z2u_JLA!!9\u0002X\n1bKM#yaJ,7o]5p]N\u000bFJQ;jY\u0012,'\u000f\u0006\u0002\u0002fB\u0019\u0011q]\b\u000e\u0003\u0001\tAB^5tSRd\u0015\u000e^3sC2$2aXAw\u0011\u001d\ty/\u0005a\u0001\u0003c\fq\u0001\\5uKJ\fG\u000e\r\u0003\u0002t\n\r\u0001CBA{\u0003w\fy0\u0004\u0002\u0002x*!\u0011\u0011`An\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\u0005u\u0018q\u001f\u0002\b\u0019&$XM]1m!\u0011\u0011\tAa\u0001\r\u0001\u0011a!QAAw\u0003\u0003\u0005\tQ!\u0001\u0003\b\t\u0019q\fJ\u0019\u0012\t\t%\u0011Q\u0019\t\u0004{\t-\u0011b\u0001B\u0007}\t9aj\u001c;iS:<\u0017a\u0005<jg&$h*Y7fIJ+g-\u001a:f]\u000e,GcA0\u0003\u0014!9!Q\u0003\nA\u0002\t]\u0011\u0001\u00038b[\u0016$'+\u001a4\u0011\t\u0005U(\u0011D\u0005\u0005\u00057\t9P\u0001\bOC6,GMU3gKJ,gnY3\u0002\u0013YL7/\u001b;DCN$H#B0\u0003\"\t\u0015\u0002B\u0002B\u0012'\u0001\u0007q,A\u0001m\u0011\u0019\u00119c\u0005a\u0001Y\u0006AA-\u0019;b)f\u0004X-\u0001\twSNLGoU)M\rVt7\r^5p]R)qL!\f\u00032!1!q\u0006\u000bA\u0002}\u000b\u0001BZ;oG:\u000bW.\u001a\u0005\b\u0005g!\u0002\u0019\u0001B\u001b\u0003\u0019Ig\u000e];ugB!QHa\u000e`\u0013\r\u0011ID\u0010\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0014SN\u001cV\u000f\u001d9peR,GMR;oGRLwN\u001c\u000b\u00045\n}\u0002B\u0002B\u0018+\u0001\u0007q\fK\u0003\u0016\u0003\u0003\ni%A\td_6\u0004\u0018\u000e\\3FqB\u0014Xm]:j_:$BAa\u0012\u0003JA\u0019QH[0\t\u000f\t-c\u00031\u0001\u0003N\u0005!Q\r\u001f9s!\u0011\t)Pa\u0014\n\t\tE\u0013q\u001f\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007&\u0002\f\u0002B\u00055\u0013\u0001E2p[BLG.Z!hOJ,w-\u0019;f)\u0011\u00119E!\u0017\t\u000f\tms\u00031\u0001\u0003^\u0005Y\u0011mZ4Gk:\u001cG/[8o!\u0011\u0011yF!\u001a\u000e\u0005\t\u0005$\u0002\u0002B2\u0003o\f\u0011\"Y4he\u0016<\u0017\r^3\n\t\t\u001d$\u0011\r\u0002\u000e\u0003\u001e<'/Z4bi\u00164UO\\2)\u000b]\t\t%!\u0014\u0002\u0019\r\u0014X-\u0019;f'\u000eDW-\\1\u0015\u0011\u0005\r&q\u000eB=\u0005{BqA!\u001d\u0019\u0001\u0004\u0011\u0019(A\u0005ti\u0006$X-\\3oiB!\u0011Q\u0004B;\u0013\u0011\u00119(a\b\u0003\u0013M#\u0018\r^3nK:$\bB\u0002B>1\u0001\u0007q,\u0001\u0004tG\",W.\u0019\u0005\u0007\u0005\u007fB\u0002\u0019A0\u0002\u000f\r|W.\\3oi\u0006i1o\u00195f[\u0006\u001cX\t_5tiN$rA\u0017BC\u0005\u0013\u0013Y\tC\u0004\u0003\bf\u0001\r!a\u0007\u0002\t\r|gN\u001c\u0005\b\u0003WI\u0002\u0019AA\u0017\u0011\u0019\u0011Y(\u0007a\u0001?\u0006YA.[:u'\u000eDW-\\1t)\u0019\u0011\tJa%\u0003\u0016B)QHa\u000e\u00036!9!q\u0011\u000eA\u0002\u0005m\u0001bBA\u00165\u0001\u0007\u0011QF\u0001\u0019SN\u001c\u0015m]2bI&tw\r\u0016:v]\u000e\fG/\u001a+bE2,GCAAA\u0003-\u0011XM\\1nKR\u000b'\r\\3\u0015\u000b}\u0013yJa)\t\r\t\u0005F\u00041\u0001`\u0003!yG\u000e\u001a+bE2,\u0007B\u0002BS9\u0001\u0007q,\u0001\u0005oK^$\u0016M\u00197f\u0003)\tG\u000e^3s)\u0006\u0014G.\u001a\u000b\t\u0005k\u0011YKa,\u0003F\"1!QV\u000fA\u0002}\u000b\u0011\u0002^1cY\u0016t\u0015-\\3\t\u000f\tEV\u00041\u0001\u00034\u000691\r[1oO\u0016\u001c\b#B\"\u00036\ne\u0016b\u0001B\\\u001b\n\u00191+Z9\u0011\t\tm&\u0011Y\u0007\u0003\u0005{SAAa0\u0002\\\u000691-\u0019;bY><\u0017\u0002\u0002Bb\u0005{\u00131\u0002V1cY\u0016\u001c\u0005.\u00198hK\"1!qY\u000fA\u0002Q\fa\u0002\u001a2NC*|'OV3sg&|g.A\thKR\fE\rZ\"pYVlg.U;fef$ra\u0018Bg\u0005\u001f\u0014\u0019\u000e\u0003\u0004\u0003.z\u0001\ra\u0018\u0005\u0007\u0005#t\u0002\u0019A0\u0002\u0015\r|G.^7o\u001d\u0006lW\r\u0003\u0004\u0003(y\u0001\raX\u0001\u0015O\u0016$(+\u001a8b[\u0016\u001cu\u000e\\;n]F+XM]=\u0015\u0013}\u0013INa7\u0003^\n\u0005\bB\u0002BW?\u0001\u0007q\f\u0003\u0004\u0003R~\u0001\ra\u0018\u0005\u0007\u0005?|\u0002\u0019A0\u0002\u000f9,wOT1nK\"1!qY\u0010A\u0002Q\fAcZ3u\t\u0016dW\r^3D_2,XN\\)vKJLH#B0\u0003h\n%\bB\u0002BWA\u0001\u0007q\f\u0003\u0004\u0003R\u0002\u0002\raX\u0001\u0019O\u0016$X\u000b\u001d3bi\u0016\u001cu\u000e\\;n]RK\b/Z)vKJLHcB0\u0003p\nE(1\u001f\u0005\u0007\u0005[\u000b\u0003\u0019A0\t\r\tE\u0017\u00051\u0001`\u0011\u0019\u0011)0\ta\u0001?\u0006Ya.Z<ECR\fG+\u001f9f\u0003}9W\r^+qI\u0006$XmQ8mk6tg*\u001e7mC\nLG.\u001b;z#V,'/\u001f\u000b\b?\nm(Q B\u0000\u0011\u0019\u0011iK\ta\u0001?\"1!\u0011\u001b\u0012A\u0002}Caa!\u0001#\u0001\u0004Q\u0016AC5t\u001dVdG.\u00192mK\u0006!r-\u001a;UC\ndWmQ8n[\u0016tG/U;fef$RaXB\u0004\u0007\u0013Aa!a\u0018$\u0001\u0004y\u0006B\u0002B@G\u0001\u0007q,A\u000bhKR\u001c6\r[3nC\u000e{W.\\3oiF+XM]=\u0015\u000b}\u001bya!\u0005\t\r\tmD\u00051\u0001`\u0011\u0019\u0011y\b\na\u0001?\u0006A\"/Z7pm\u0016\u001c6\r[3nC\u000e{W.\\3oiF+XM]=\u0015\u0007}\u001b9\u0002\u0003\u0004\u0003|\u0015\u0002\raX\u0001\u000bIJ|\u0007oU2iK6\fG#B0\u0004\u001e\r}\u0001B\u0002B>M\u0001\u0007q\f\u0003\u0004\u0002\u0000\u0019\u0002\rAW\u0001\fGJ,\u0017\r^3J]\u0012,\u0007\u0010F\u0006`\u0007K\u0019Ica\u000b\u00042\r}\u0002BBB\u0014O\u0001\u0007q,A\u0005j]\u0012,\u0007PT1nK\"1!QV\u0014A\u0002}Cqa!\f(\u0001\u0004\u0019y#A\u0004d_2,XN\\:\u0011\u000bu\u00129Da\u0006\t\u000f\rMr\u00051\u0001\u00046\u0005\t2m\u001c7v[:\u001c\bK]8qKJ$\u0018.Z:\u0011\u0011\r]21\bB\f\u0007{i!a!\u000f\u000b\t\u0005e\u0017\u0011E\u0005\u0005\u0003k\u001bI\u0004\u0005\u0004\u00048\rmrl\u0018\u0005\b\u0003_;\u0003\u0019AB\u001f\u0003-Ig\u000eZ3y\u000bbL7\u000f^:\u0015\u0013i\u001b)ea\u0012\u0004J\r-\u0003b\u0002BDQ\u0001\u0007\u00111\u0004\u0005\u0007\u0007OA\u0003\u0019A0\t\r\t5\u0006\u00061\u0001`\u0011\u001d\tY\u0003\u000ba\u0001\u0003[\t\u0011\u0002\u001a:pa&sG-\u001a=\u0015\u000b}\u001b\tfa\u0015\t\r\r\u001d\u0012\u00061\u0001`\u0011\u0019\u0011i+\u000ba\u0001?\u0006YA.[:u\u0013:$W\r_3t)!\u0019Ifa\u001a\u0004j\r-\u0004#B\u001f\u00038\rm\u0003\u0003BB/\u0007Gj!aa\u0018\u000b\t\r\u0005$QX\u0001\u0006S:$W\r_\u0005\u0005\u0007K\u001ayF\u0001\u0006UC\ndW-\u00138eKbDqAa\"+\u0001\u0004\tY\u0002\u0003\u0004\u0003.*\u0002\ra\u0018\u0005\b\u0003WQ\u0003\u0019AA\u0017\u0003E\u0019G.Y:tS\u001aLX\t_2faRLwN\u001c\u000b\u0007\u0007c\u001aIh! \u0011\t\rM4QO\u0007\u0002e%\u00191q\u000f\u001a\u0003#\u0005s\u0017\r\\=tSN,\u0005pY3qi&|g\u000e\u0003\u0004\u0004|-\u0002\raX\u0001\b[\u0016\u001c8/Y4f\u0011\u001d\u0019yh\u000ba\u0001\u0007\u0003\u000b\u0011!\u001a\t\u0004\u0007\u000e\r\u0015bABC\u001b\nIA\u000b\u001b:po\u0006\u0014G.Z\u0001\u000fO\u0016$H*[7ji\u000ec\u0017-^:f)\ry61\u0012\u0005\b\u0007\u001bc\u0003\u0019ABH\u0003\u0015a\u0017.\\5u!\u0011\u0019\tja&\u000e\u0005\rM%\u0002BBK\u0003C\tA\u0001\\1oO&!1\u0011TBJ\u0005\u001dIe\u000e^3hKJ\f1c];qa>\u0014Ho\u001d+bE2,7+Y7qY\u0016,\u0012AW\u0001\u000fO\u0016$H+\u00192mKN\u000bW\u000e\u001d7f)\ry61\u0015\u0005\b\u0007Ks\u0003\u0019ABT\u0003\u0019\u0019\u0018-\u001c9mKB!1\u0011VBX\u001b\t\u0019YK\u0003\u0003\u0004.\u0006M\u0012A\u0001<3\u0013\u0011\u0019\tla+\u0003\u001fQ\u000b'\r\\3TC6\u0004H.Z%oM>D3\u0001AB[!\u0011\t\u0019ea.\n\t\re\u0016Q\t\u0002\r\t\u00164X\r\\8qKJ\f\u0005/\u001b")
public abstract class JdbcDialect
implements Serializable,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public abstract boolean canHandle(String var1);

    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        return None$.MODULE$;
    }

    public Option<JdbcType> getJDBCType(DataType dt) {
        return None$.MODULE$;
    }

    public Function1<Object, Connection> createConnectionFactory(JDBCOptions options) {
        String driverClass = options.driverClass();
        return (Function1 & Serializable)partitionId -> JdbcDialect.$anonfun$createConnectionFactory$1(driverClass, options, BoxesRunTime.unboxToInt((Object)partitionId));
    }

    public String quoteIdentifier(String colName) {
        return new StringBuilder(2).append("\"").append(colName).append("\"").toString();
    }

    public String getTableExistsQuery(String table) {
        return new StringBuilder(24).append("SELECT * FROM ").append(table).append(" WHERE 1=0").toString();
    }

    public String getSchemaQuery(String table) {
        return new StringBuilder(24).append("SELECT * FROM ").append(table).append(" WHERE 1=0").toString();
    }

    public String getTruncateQuery(String table) {
        return this.getTruncateQuery(table, this.isCascadingTruncateTable());
    }

    public String getTruncateQuery(String table, Option<Object> cascade) {
        return new StringBuilder(15).append("TRUNCATE TABLE ").append(table).toString();
    }

    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    public void beforeFetch(Connection connection, scala.collection.immutable.Map<String, String> properties) {
    }

    public String escapeSql(String value) {
        return value == null ? null : StringUtils.replace((String)value, (String)"'", (String)"''");
    }

    public Object compileValue(Object value2) {
        Object object;
        Object object2 = value2;
        if (object2 instanceof String) {
            String string = (String)object2;
            object = new StringBuilder(2).append("'").append(this.escapeSql(string)).append("'").toString();
        } else if (object2 instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object2;
            object = new StringBuilder(2).append("'").append(timestamp).append("'").toString();
        } else if (object2 instanceof Instant) {
            Instant instant = (Instant)object2;
            TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.getFractionFormatter(DateTimeUtils$.MODULE$.getZoneId(SQLConf$.MODULE$.get().sessionLocalTimeZone()));
            object = new StringBuilder(2).append("'").append(timestampFormatter.format(instant)).append("'").toString();
        } else if (object2 instanceof Date) {
            Date date = (Date)object2;
            object = new StringBuilder(2).append("'").append(date).append("'").toString();
        } else if (object2 instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object2;
            object = new StringBuilder(2).append("'").append(DateFormatter$.MODULE$.apply().format(localDate)).append("'").toString();
        } else if (object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object2;
            object = Predef$.MODULE$.genericWrapArray(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)objectArray), (Function1 & Serializable)value -> this.compileValue(value), ClassTag$.MODULE$.Any())).mkString(", ");
        } else {
            object = value2;
        }
        return object;
    }

    public boolean isSupportedFunction(String funcName) {
        return false;
    }

    public Option<String> compileExpression(Expression expr) {
        Some some;
        JDBCSQLBuilder jdbcSQLBuilder = new JDBCSQLBuilder();
        try {
            some = new Some((Object)jdbcSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", e);
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    public Option<String> compileAggregate(AggregateFunc aggFunction) {
        Option option;
        AggregateFunc aggregateFunc = aggFunction;
        if (aggregateFunc instanceof Min) {
            Min min = (Min)aggregateFunc;
            option = this.compileExpression(min.column()).map((Function1 & Serializable)v -> new StringBuilder(5).append("MIN(").append((String)v).append(")").toString());
        } else if (aggregateFunc instanceof Max) {
            Max max = (Max)aggregateFunc;
            option = this.compileExpression(max.column()).map((Function1 & Serializable)v -> new StringBuilder(5).append("MAX(").append((String)v).append(")").toString());
        } else if (aggregateFunc instanceof Count) {
            Count count = (Count)aggregateFunc;
            String distinct = count.isDistinct() ? "DISTINCT " : "";
            option = this.compileExpression(count.column()).map((Function1 & Serializable)v -> new StringBuilder(7).append("COUNT(").append(distinct).append((String)v).append(")").toString());
        } else if (aggregateFunc instanceof Sum) {
            Sum sum = (Sum)aggregateFunc;
            String distinct = sum.isDistinct() ? "DISTINCT " : "";
            option = this.compileExpression(sum.column()).map((Function1 & Serializable)v -> new StringBuilder(5).append("SUM(").append(distinct).append((String)v).append(")").toString());
        } else if (aggregateFunc instanceof CountStar) {
            option = new Some((Object)"COUNT(*)");
        } else if (aggregateFunc instanceof Avg) {
            Avg avg = (Avg)aggregateFunc;
            String distinct = avg.isDistinct() ? "DISTINCT " : "";
            option = this.compileExpression(avg.column()).map((Function1 & Serializable)v -> new StringBuilder(5).append("AVG(").append(distinct).append((String)v).append(")").toString());
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    public void createSchema(Statement statement, String schema, String comment) {
        block0: {
            String schemaCommentQuery = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(comment)) ? this.getSchemaCommentQuery(schema, comment) : comment;
            statement.executeUpdate(new StringBuilder(14).append("CREATE SCHEMA ").append(this.quoteIdentifier(schema)).toString());
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(comment))) break block0;
            statement.executeUpdate(schemaCommentQuery);
        }
    }

    public boolean schemasExists(Connection conn, JDBCOptions options, String schema) {
        ResultSet rs = conn.getMetaData().getSchemas(null, schema);
        while (rs.next()) {
            String string = rs.getString(1);
            String string2 = schema;
            if (string != null ? !string.equals(string2) : string2 != null) continue;
            return true;
        }
        return false;
    }

    public String[][] listSchemas(Connection conn, JDBCOptions options) {
        ArrayBuilder schemaBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        ResultSet rs = conn.getMetaData().getSchemas();
        while (rs.next()) {
            schemaBuilder.$plus$eq((Object)new String[]{rs.getString(1)});
        }
        return (String[][])schemaBuilder.result();
    }

    public Option<Object> isCascadingTruncateTable() {
        return None$.MODULE$;
    }

    public String renameTable(String oldTable, String newTable) {
        return new StringBuilder(23).append("ALTER TABLE ").append(oldTable).append(" RENAME TO ").append(newTable).toString();
    }

    public String[] alterTable(String tableName, Seq<TableChange> changes, int dbMajorVersion) {
        ArrayBuilder updateClause = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(String.class));
        changes.foreach((Function1 & Serializable)change -> {
            TableChange.UpdateColumnNullability updateColumnNullability;
            TableChange.UpdateColumnType updateColumnType;
            TableChange.DeleteColumn deleteColumn;
            TableChange.RenameColumn renameColumn;
            ArrayBuilder arrayBuilder;
            TableChange.AddColumn addColumn;
            TableChange tableChange = change;
            if (tableChange instanceof TableChange.AddColumn && (addColumn = (TableChange.AddColumn)tableChange).fieldNames().length == 1) {
                String dataType = JdbcUtils$.MODULE$.getJdbcType(addColumn.dataType(), this).databaseTypeDefinition();
                String[] name = addColumn.fieldNames();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getAddColumnQuery(tableName, name[0], dataType));
            } else if (tableChange instanceof TableChange.RenameColumn && (renameColumn = (TableChange.RenameColumn)tableChange).fieldNames().length == 1) {
                String[] name = renameColumn.fieldNames();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getRenameColumnQuery(tableName, name[0], renameColumn.newName(), dbMajorVersion));
            } else if (tableChange instanceof TableChange.DeleteColumn && (deleteColumn = (TableChange.DeleteColumn)tableChange).fieldNames().length == 1) {
                String[] name = deleteColumn.fieldNames();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getDeleteColumnQuery(tableName, name[0]));
            } else if (tableChange instanceof TableChange.UpdateColumnType && (updateColumnType = (TableChange.UpdateColumnType)tableChange).fieldNames().length == 1) {
                String[] name = updateColumnType.fieldNames();
                String dataType = JdbcUtils$.MODULE$.getJdbcType(updateColumnType.newDataType(), this).databaseTypeDefinition();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getUpdateColumnTypeQuery(tableName, name[0], dataType));
            } else if (tableChange instanceof TableChange.UpdateColumnNullability && (updateColumnNullability = (TableChange.UpdateColumnNullability)tableChange).fieldNames().length == 1) {
                String[] name = updateColumnNullability.fieldNames();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getUpdateColumnNullabilityQuery(tableName, name[0], updateColumnNullability.nullable()));
            } else {
                throw QueryCompilationErrors$.MODULE$.unsupportedTableChangeInJDBCCatalogError(change);
            }
            return arrayBuilder;
        });
        return (String[])updateClause.result();
    }

    public String getAddColumnQuery(String tableName, String columnName, String dataType) {
        return new StringBuilder(25).append("ALTER TABLE ").append(tableName).append(" ADD COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(dataType).toString();
    }

    public String getRenameColumnQuery(String tableName, String columnName, String newName, int dbMajorVersion) {
        return new StringBuilder(0).append(new StringBuilder(30).append("ALTER TABLE ").append(tableName).append(" RENAME COLUMN ").append(this.quoteIdentifier(columnName)).append(" TO").toString()).append(new StringBuilder(1).append(" ").append(this.quoteIdentifier(newName)).toString()).toString();
    }

    public String getDeleteColumnQuery(String tableName, String columnName) {
        return new StringBuilder(25).append("ALTER TABLE ").append(tableName).append(" DROP COLUMN ").append(this.quoteIdentifier(columnName)).toString();
    }

    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return new StringBuilder(27).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(newDataType).toString();
    }

    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "NULL" : "NOT NULL";
        return new StringBuilder(31).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" SET ").append(nullable).toString();
    }

    public String getTableCommentQuery(String table, String comment) {
        return new StringBuilder(23).append("COMMENT ON TABLE ").append(table).append(" IS '").append(comment).append("'").toString();
    }

    public String getSchemaCommentQuery(String schema, String comment) {
        return new StringBuilder(24).append("COMMENT ON SCHEMA ").append(this.quoteIdentifier(schema)).append(" IS '").append(comment).append("'").toString();
    }

    public String removeSchemaCommentQuery(String schema) {
        return new StringBuilder(26).append("COMMENT ON SCHEMA ").append(this.quoteIdentifier(schema)).append(" IS NULL").toString();
    }

    public String dropSchema(String schema, boolean cascade) {
        return cascade ? new StringBuilder(20).append("DROP SCHEMA ").append(this.quoteIdentifier(schema)).append(" CASCADE").toString() : new StringBuilder(12).append("DROP SCHEMA ").append(this.quoteIdentifier(schema)).toString();
    }

    public String createIndex(String indexName, String tableName, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        throw new UnsupportedOperationException("createIndex is not supported");
    }

    public boolean indexExists(Connection conn, String indexName, String tableName, JDBCOptions options) {
        throw new UnsupportedOperationException("indexExists is not supported");
    }

    public String dropIndex(String indexName, String tableName) {
        throw new UnsupportedOperationException("dropIndex is not supported");
    }

    public TableIndex[] listIndexes(Connection conn, String tableName, JDBCOptions options) {
        throw new UnsupportedOperationException("listIndexes is not supported");
    }

    public AnalysisException classifyException(String message, Throwable e) {
        String x$1 = message;
        Some x$2 = new Some((Object)e);
        Option x$3 = AnalysisException$.MODULE$.$lessinit$greater$default$2();
        Option x$4 = AnalysisException$.MODULE$.$lessinit$greater$default$3();
        Option x$5 = AnalysisException$.MODULE$.$lessinit$greater$default$4();
        Option x$6 = AnalysisException$.MODULE$.$lessinit$greater$default$6();
        String[] x$7 = AnalysisException$.MODULE$.$lessinit$greater$default$7();
        return new AnalysisException(x$1, x$3, x$4, x$5, (Option)x$2, x$6, x$7);
    }

    public String getLimitClause(Integer limit) {
        return Predef$.MODULE$.Integer2int(limit) > 0 ? new StringBuilder(6).append("LIMIT ").append(limit).toString() : "";
    }

    public boolean supportsTableSample() {
        return false;
    }

    public String getTableSample(TableSampleInfo sample) {
        throw new UnsupportedOperationException("TableSample is not supported by this data source");
    }

    public static final /* synthetic */ Connection $anonfun$createConnectionFactory$1(String driverClass$1, JDBCOptions options$1, int partitionId) {
        DriverRegistry$.MODULE$.register(driverClass$1);
        Driver driver = DriverRegistry$.MODULE$.get(driverClass$1);
        Connection connection = ConnectionProvider$.MODULE$.create(driver, (scala.collection.immutable.Map<String, String>)options$1.parameters(), options$1.connectionProviderName());
        Predef$.MODULE$.require(connection != null, (Function0 & Serializable)() -> new StringBuilder(60).append("The driver could not open a JDBC connection. Check the URL: ").append(options$1.url()).toString());
        return connection;
    }

    public JdbcDialect() {
        Logging.$init$((Logging)this);
    }

    public class JDBCSQLBuilder
    extends V2ExpressionSQLBuilder {
        public String visitLiteral(Literal<?> literal) {
            return this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().compileValue(CatalystTypeConverters$.MODULE$.convertToScala(literal.value(), literal.dataType())).toString();
        }

        public String visitNamedReference(NamedReference namedRef) {
            if (namedRef.fieldNames().length > 1) {
                throw QueryCompilationErrors$.MODULE$.commandNotSupportNestedColumnError("Filter push down", namedRef.toString());
            }
            return this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().quoteIdentifier((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])namedRef.fieldNames())));
        }

        public String visitCast(String l, DataType dataType) {
            String databaseTypeDefinition = (String)this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().getJDBCType(dataType).map((Function1 & Serializable)x$1 -> x$1.databaseTypeDefinition()).getOrElse((Function0 & Serializable)() -> dataType.typeName());
            return new StringBuilder(10).append("CAST(").append(l).append(" AS ").append(databaseTypeDefinition).append(")").toString();
        }

        public String visitSQLFunction(String funcName, String[] inputs) {
            if (!this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction(funcName)) {
                throw new UnsupportedOperationException(new StringBuilder(28).append(this.getClass().getSimpleName()).append(" does not support function: ").append(funcName).toString());
            }
            return new StringBuilder(2).append(funcName).append("(").append(Predef$.MODULE$.wrapRefArray((Object[])inputs).mkString(", ")).append(")").toString();
        }

        public /* synthetic */ JdbcDialect org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer() {
            return JdbcDialect.this;
        }

        public JDBCSQLBuilder() {
            if (JdbcDialect.this == null) {
                throw null;
            }
        }
    }
}

