/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.UUID;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.QueryPlanningTracker;
import org.apache.spark.sql.catalyst.QueryPlanningTracker$;
import org.apache.spark.sql.catalyst.analysis.UnsupportedOperationChecker$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.QueryPlan$;
import org.apache.spark.sql.catalyst.plans.logical.AppendData;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.CommandResult;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OverwriteByExpression;
import org.apache.spark.sql.catalyst.plans.logical.OverwritePartitionsDynamic;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.StringUtils;
import org.apache.spark.sql.execution.CodegenMode$;
import org.apache.spark.sql.execution.CollectMetricsExec$;
import org.apache.spark.sql.execution.CommandExecutionMode$;
import org.apache.spark.sql.execution.CostMode$;
import org.apache.spark.sql.execution.ExplainMode;
import org.apache.spark.sql.execution.ExplainUtils$;
import org.apache.spark.sql.execution.ExtendedMode$;
import org.apache.spark.sql.execution.FormattedMode$;
import org.apache.spark.sql.execution.QueryExecution$;
import org.apache.spark.sql.execution.QueryExecution$debug$;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SQLExecutionRDD;
import org.apache.spark.sql.execution.SimpleMode$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.SparkPlanner;
import org.apache.spark.sql.execution.adaptive.AdaptiveExecutionContext;
import org.apache.spark.sql.execution.adaptive.InsertAdaptiveSparkPlan;
import org.apache.spark.sql.execution.debug.package$;
import org.apache.spark.sql.execution.streaming.IncrementalExecution;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005\r\u001dc\u0001\u0002!B\u00011C\u0001\"\u0017\u0001\u0003\u0006\u0004%\tA\u0017\u0005\t?\u0002\u0011\t\u0011)A\u00057\"A\u0001\r\u0001BC\u0002\u0013\u0005\u0011\r\u0003\u0005l\u0001\t\u0005\t\u0015!\u0003c\u0011!a\u0007A!b\u0001\n\u0003i\u0007\u0002\u0003:\u0001\u0005\u0003\u0005\u000b\u0011\u00028\t\u0011M\u0004!Q1A\u0005\u0002QD\u0001B \u0001\u0003\u0002\u0003\u0006I!\u001e\u0005\u0007\u007f\u0002!\t!!\u0001\t\u0013\u00055\u0001A1A\u0005\u0002\u0005=\u0001\u0002CA\f\u0001\u0001\u0006I!!\u0005\t\u000f\u0005e\u0001\u0001\"\u0005\u0002\u001c!9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0002bBA\u0017\u0001\u0011\u0005\u0011Q\u0005\u0005\n\u0003_\u0001\u0001R1A\u0005\u0002\u0005D\u0011\"!\r\u0001\u0011\u000b\u0007I\u0011A1\t\u000f\u0005M\u0002\u0001\"\u0003\u00026!9\u0011q\u000b\u0001\u0005\n\u0005e\u0003\"CA0\u0001!\u0015\r\u0011\"\u0001b\u0011\u001d\t\t\u0007\u0001C\u0001\u0003KA\u0011\"a\u0019\u0001\u0011\u000b\u0007I\u0011A1\t\u000f\u0005\u0015\u0004\u0001\"\u0003\u0002&!Q\u0011q\r\u0001\t\u0006\u0004%\t!!\u001b\t\u0015\u0005E\u0004\u0001#b\u0001\n\u0003\tI\u0007\u0003\u0006\u0002t\u0001A)\u0019!C\u0001\u0003kBq!!#\u0001\t\u0003\tY\tC\u0004\u0002\u001a\u0002!\t\"a'\t\u000f\u0005m\u0006\u0001\"\u0005\u0002>\"9\u0011q\u001d\u0001\u0005\u0002\u0005%\bbBAt\u0001\u0011%\u00111\u001e\u0005\b\u0005\u0017\u0001A\u0011\u0001B\u0007\u0011\u001d\u0011Y\u0001\u0001C\u0005\u0005/AqAa\b\u0001\t\u0013\u0011\t\u0003C\u0004\u0003(\u0001!\tE!\u000b\t\u000f\t\u001d\u0002\u0001\"\u0003\u0003,!9!\u0011\u0007\u0001\u0005\u0002\u0005%\bb\u0002B\u0019\u0001\u0011%!1\u0007\u0005\b\u0005s\u0001A\u0011\u0002B\u001e\u000f\u001d\u0011\t\u0005\u0001E\u0001\u0005\u00072qAa\u0012\u0001\u0011\u0003\u0011I\u0005\u0003\u0004\u0000Q\u0011\u0005!1\n\u0005\b\u0005\u001bBC\u0011AA\u0013\u0011\u001d\u0011y\u0005\u000bC\u0001\u0005#BqA!\u001b)\t\u0003\u0011Y\u0007C\u0005\u0003~!\n\n\u0011\"\u0001\u0003\u0000!I!Q\u0013\u0015\u0012\u0002\u0013\u0005!qS\u0004\b\u00057\u000b\u0005\u0012\u0001BO\r\u0019\u0001\u0015\t#\u0001\u0003 \"1q\u0010\rC\u0001\u0005CC\u0011Ba)1\u0005\u0004%IA!*\t\u0011\t}\u0006\u0007)A\u0005\u0005OCqA!11\t\u0013\ty\u0001\u0003\u0005\u0002\u001aB\"\t!\u0011Bb\u0011)\u0011i\u000eMI\u0001\n\u0003\t%q\u001c\u0005\t\u0005G\u0004D\u0011A!\u0003f\"9!Q\u001e\u0019\u0005\u0002\t=\bb\u0002B|a\u0011\u0005!\u0011 \u0005\b\u0005o\u0004D\u0011\u0001B\u0000\u0011\u001d\u00119\u0010\rC\u0001\u0007\u000bA\u0001ba\u00061\t\u0003\u00195\u0011\u0004\u0005\t\u0007S\u0001D\u0011A\"\u0004,!I11\b\u0019\u0012\u0002\u0013\u00051Q\b\u0005\n\u0007\u0003\u0002\u0014\u0013!C\u0001\u0007\u0007\u0012a\"U;fef,\u00050Z2vi&|gN\u0003\u0002C\u0007\u0006IQ\r_3dkRLwN\u001c\u0006\u0003\t\u0016\u000b1a]9m\u0015\t1u)A\u0003ta\u0006\u00148N\u0003\u0002I\u0013\u00061\u0011\r]1dQ\u0016T\u0011AS\u0001\u0004_J<7\u0001A\n\u0004\u00015\u001b\u0006C\u0001(R\u001b\u0005y%\"\u0001)\u0002\u000bM\u001c\u0017\r\\1\n\u0005I{%AB!osJ+g\r\u0005\u0002U/6\tQK\u0003\u0002W\u000b\u0006A\u0011N\u001c;fe:\fG.\u0003\u0002Y+\n9Aj\\4hS:<\u0017\u0001D:qCJ\\7+Z:tS>tW#A.\u0011\u0005qkV\"A\"\n\u0005y\u001b%\u0001D*qCJ\\7+Z:tS>t\u0017!D:qCJ\\7+Z:tS>t\u0007%A\u0004m_\u001eL7-\u00197\u0016\u0003\t\u0004\"aY5\u000e\u0003\u0011T!\u0001Y3\u000b\u0005\u0019<\u0017!\u00029mC:\u001c(B\u00015D\u0003!\u0019\u0017\r^1msN$\u0018B\u00016e\u0005-aunZ5dC2\u0004F.\u00198\u0002\u00111|w-[2bY\u0002\nq\u0001\u001e:bG.,'/F\u0001o!\ty\u0007/D\u0001h\u0013\t\txM\u0001\u000bRk\u0016\u0014\u0018\u0010\u00157b]:Lgn\u001a+sC\u000e\\WM]\u0001\tiJ\f7m[3sA\u0005!Qn\u001c3f+\u0005)\bC\u0001<{\u001d\t9\b0D\u0001B\u0013\tI\u0018)\u0001\u000bD_6l\u0017M\u001c3Fq\u0016\u001cW\u000f^5p]6{G-Z\u0005\u0003wr\u0014QAV1mk\u0016L!!`(\u0003\u0017\u0015sW/\\3sCRLwN\\\u0001\u0006[>$W\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015\u0005\r\u0011QAA\u0004\u0003\u0013\tY\u0001\u0005\u0002x\u0001!)\u0011,\u0003a\u00017\")\u0001-\u0003a\u0001E\"9A.\u0003I\u0001\u0002\u0004q\u0007bB:\n!\u0003\u0005\r!^\u0001\u0003S\u0012,\"!!\u0005\u0011\u00079\u000b\u0019\"C\u0002\u0002\u0016=\u0013A\u0001T8oO\u0006\u0019\u0011\u000e\u001a\u0011\u0002\u000fAd\u0017M\u001c8feV\u0011\u0011Q\u0004\t\u0004o\u0006}\u0011bAA\u0011\u0003\na1\u000b]1sWBc\u0017M\u001c8fe\u0006q\u0011m]:feR\fe.\u00197zu\u0016$GCAA\u0014!\rq\u0015\u0011F\u0005\u0004\u0003Wy%\u0001B+oSR\fq\"Y:tKJ$8+\u001e9q_J$X\rZ\u0001\tC:\fG.\u001f>fI\u0006y1m\\7nC:$W\t_3dkR,G-\u0001\u000bd_6l\u0017M\u001c3Fq\u0016\u001cW\u000f^5p]:\u000bW.\u001a\u000b\u0005\u0003o\ti\u0005\u0005\u0003\u0002:\u0005\u001dc\u0002BA\u001e\u0003\u0007\u00022!!\u0010P\u001b\t\tyDC\u0002\u0002B-\u000ba\u0001\u0010:p_Rt\u0014bAA#\u001f\u00061\u0001K]3eK\u001aLA!!\u0013\u0002L\t11\u000b\u001e:j]\u001eT1!!\u0012P\u0011\u001d\ty%\u0005a\u0001\u0003#\nqaY8n[\u0006tG\rE\u0002d\u0003'J1!!\u0016e\u0005\u001d\u0019u.\\7b]\u0012\fa#Z1hKJd\u00170\u0012=fGV$XmQ8n[\u0006tGm\u001d\u000b\u0004E\u0006m\u0003BBA/%\u0001\u0007!-A\u0001q\u000399\u0018\u000e\u001e5DC\u000eDW\r\u001a#bi\u0006\fQ#Y:tKJ$8i\\7nC:$W\t_3dkR,G-A\u0007paRLW.\u001b>fIBc\u0017M\\\u0001\u0010CN\u001cXM\u001d;PaRLW.\u001b>fI\u0006I1\u000f]1sWBc\u0017M\\\u000b\u0003\u0003W\u00022a^A7\u0013\r\ty'\u0011\u0002\n'B\f'o\u001b)mC:\fA\"\u001a=fGV$X\r\u001a)mC:\fQ\u0001^8SI\u0012,\"!a\u001e\u0011\r\u0005e\u0014qPAB\u001b\t\tYHC\u0002\u0002~\u0015\u000b1A\u001d3e\u0013\u0011\t\t)a\u001f\u0003\u0007I#E\tE\u0002p\u0003\u000bK1!a\"h\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u001f=\u00147/\u001a:wK\u0012lU\r\u001e:jGN,\"!!$\u0011\u0011\u0005e\u0012qRA\u001c\u0003'KA!!%\u0002L\t\u0019Q*\u00199\u0011\u0007q\u000b)*C\u0002\u0002\u0018\u000e\u00131AU8x\u00031\u0001(/\u001a9be\u0006$\u0018n\u001c8t+\t\ti\n\u0005\u0004\u0002 \u0006%\u0016q\u0016\b\u0005\u0003C\u000b)K\u0004\u0003\u0002>\u0005\r\u0016\"\u0001)\n\u0007\u0005\u001dv*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005-\u0016Q\u0016\u0002\u0004'\u0016\f(bAAT\u001fB1\u0011\u0011WA\\\u0003Wj!!a-\u000b\u0007\u0005Uv-A\u0003sk2,7/\u0003\u0003\u0002:\u0006M&\u0001\u0002*vY\u0016\fA\"\u001a=fGV$X\r\u00155bg\u0016,B!a0\u0002HR!\u0011\u0011YAr)\u0011\t\u0019-!7\u0011\t\u0005\u0015\u0017q\u0019\u0007\u0001\t\u001d\tI\r\bb\u0001\u0003\u0017\u0014\u0011\u0001V\t\u0005\u0003\u001b\f\u0019\u000eE\u0002O\u0003\u001fL1!!5P\u0005\u001dqu\u000e\u001e5j]\u001e\u00042ATAk\u0013\r\t9n\u0014\u0002\u0004\u0003:L\b\u0002CAn9\u0011\u0005\r!!8\u0002\u000b\tdwnY6\u0011\u000b9\u000by.a1\n\u0007\u0005\u0005xJ\u0001\u0005=Eft\u0017-\\3?\u0011\u001d\t)\u000f\ba\u0001\u0003o\tQ\u0001\u001d5bg\u0016\fAb]5na2,7\u000b\u001e:j]\u001e,\"!a\u000e\u0015\u0011\u0005\u001d\u0012Q^A|\u0005\u0003Aq!a<\u001f\u0001\u0004\t\t0A\u0005g_Jl\u0017\r\u001e;fIB\u0019a*a=\n\u0007\u0005UxJA\u0004C_>dW-\u00198\t\u000f\u0005eh\u00041\u0001\u0002|\u0006IQ.\u0019=GS\u0016dGm\u001d\t\u0004\u001d\u0006u\u0018bAA\u0000\u001f\n\u0019\u0011J\u001c;\t\u000f\t\ra\u00041\u0001\u0003\u0006\u00051\u0011\r\u001d9f]\u0012\u0004rA\u0014B\u0004\u0003o\t9#C\u0002\u0003\n=\u0013\u0011BR;oGRLwN\\\u0019\u0002\u001b\u0015D\b\u000f\\1j]N#(/\u001b8h)\u0011\t9Da\u0004\t\rM|\u0002\u0019\u0001B\t!\r9(1C\u0005\u0004\u0005+\t%aC#ya2\f\u0017N\\'pI\u0016$\u0002\"a\n\u0003\u001a\tm!Q\u0004\u0005\u0007g\u0002\u0002\rA!\u0005\t\u000f\u0005e\b\u00051\u0001\u0002|\"9!1\u0001\u0011A\u0002\t\u0015\u0011AC<sSR,\u0007\u000b\\1ogR1\u0011q\u0005B\u0012\u0005KAqAa\u0001\"\u0001\u0004\u0011)\u0001C\u0004\u0002z\u0006\u0002\r!a?\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u000e\u0015\r\u0005\u001d\"Q\u0006B\u0018\u0011\u001d\tIp\ta\u0001\u0003wDqAa\u0001$\u0001\u0004\u0011)!A\btiJLgnZ,ji\"\u001cF/\u0019;t)\u0019\t9C!\u000e\u00038!9\u0011\u0011`\u0013A\u0002\u0005m\bb\u0002B\u0002K\u0001\u0007!QA\u0001\u000eo&$\bNU3eC\u000e$\u0018n\u001c8\u0015\t\u0005]\"Q\b\u0005\b\u0005\u007f1\u0003\u0019AA\u001c\u0003\u001diWm]:bO\u0016\fQ\u0001Z3ck\u001e\u00042A!\u0012)\u001b\u0005\u0001!!\u00023fEV<7C\u0001\u0015N)\t\u0011\u0019%A\u0004d_\u0012,w-\u001a8\u0002\u0019\r|G-Z4f]R{7+Z9\u0015\u0005\tM\u0003CBAP\u0003S\u0013)\u0006E\u0005O\u0005/\n9$a\u000e\u0003\\%\u0019!\u0011L(\u0003\rQ+\b\u000f\\34!\u0011\u0011iF!\u001a\u000e\u0005\t}#\u0002\u0002B'\u0005CR1Aa\u0019h\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\t\u001d$q\f\u0002\u000e\u0005f$XmQ8eKN#\u0018\r^:\u0002\rQ|g)\u001b7f)!\t9C!\u001c\u0003r\tM\u0004b\u0002B8Y\u0001\u0007\u0011qG\u0001\u0005a\u0006$\b\u000eC\u0005\u0002z2\u0002\n\u00111\u0001\u0002|\"I!Q\u000f\u0017\u0011\u0002\u0003\u0007!qO\u0001\fKb\u0004H.Y5o\u001b>$W\rE\u0003O\u0005s\n9$C\u0002\u0003|=\u0013aa\u00149uS>t\u0017\u0001\u0005;p\r&dW\r\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\tI\u000b\u0003\u0002|\n\r5F\u0001BC!\u0011\u00119I!%\u000e\u0005\t%%\u0002\u0002BF\u0005\u001b\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t=u*\u0001\u0006b]:|G/\u0019;j_:LAAa%\u0003\n\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002!Q|g)\u001b7fI\u0011,g-Y;mi\u0012\u001aTC\u0001BMU\u0011\u00119Ha!\u0002\u001dE+XM]=Fq\u0016\u001cW\u000f^5p]B\u0011q\u000fM\n\u0003a5#\"A!(\u0002!}sW\r\u001f;Fq\u0016\u001cW\u000f^5p]&#WC\u0001BT!\u0011\u0011IKa/\u000e\u0005\t-&\u0002\u0002BW\u0005_\u000ba!\u0019;p[&\u001c'\u0002\u0002BY\u0005g\u000b!bY8oGV\u0014(/\u001a8u\u0015\u0011\u0011)La.\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0005s\u000bAA[1wC&!!Q\u0018BV\u0005)\tEo\\7jG2{gnZ\u0001\u0012?:,\u0007\u0010^#yK\u000e,H/[8o\u0013\u0012\u0004\u0013a\u00048fqR,\u00050Z2vi&|g.\u00133\u0015\u0011\u0005u%Q\u0019Bd\u00053DQ!W\u001bA\u0002mC\u0011B!36!\u0003\u0005\rAa3\u0002+\u0005$\u0017\r\u001d;jm\u0016,\u00050Z2vi&|gNU;mKB)aJ!\u001f\u0003NB!!q\u001aBk\u001b\t\u0011\tNC\u0002\u0003T\u0006\u000b\u0001\"\u00193baRLg/Z\u0005\u0005\u0005/\u0014\tNA\fJ]N,'\u000f^!eCB$\u0018N^3Ta\u0006\u00148\u000e\u00157b]\"9!1\\\u001bA\u0002\u0005E\u0018\u0001C:vEF,XM]=\u0002-A\u0014X\r]1sCRLwN\\:%I\u00164\u0017-\u001e7uII*\"A!9+\t\t-'1Q\u0001\u0014aJ,\u0007/\u0019:f\r>\u0014X\t_3dkRLwN\u001c\u000b\u0007\u0003W\u00129O!;\t\u000f\u0005eu\u00071\u0001\u0002\u001e\"9!1^\u001cA\u0002\u0005-\u0014\u0001\u00029mC:\fqb\u0019:fCR,7\u000b]1sWBc\u0017M\u001c\u000b\t\u0003W\u0012\tPa=\u0003v\")\u0011\f\u000fa\u00017\"9\u0011\u0011\u0004\u001dA\u0002\u0005u\u0001B\u0002Bvq\u0001\u0007!-A\nqe\u0016\u0004\u0018M]3Fq\u0016\u001cW\u000f^3e!2\fg\u000e\u0006\u0004\u0002l\tm(Q \u0005\u0006\rf\u0002\ra\u0017\u0005\b\u0005WL\u0004\u0019AA6)\u0019\tYg!\u0001\u0004\u0004!)aI\u000fa\u00017\"1!1\u001e\u001eA\u0002\t$\u0002\"a\u001b\u0004\b\r-1Q\u0002\u0005\u0007\u0007\u0013Y\u0004\u0019A.\u0002\u000fM,7o]5p]\"1!1^\u001eA\u0002\tDqaa\u0004<\u0001\u0004\u0019\t\"A\u0004d_:$X\r\u001f;\u0011\t\t=71C\u0005\u0005\u0007+\u0011\tN\u0001\rBI\u0006\u0004H/\u001b<f\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fq\u0002^8J]R,'O\\1m\u000bJ\u0014xN\u001d\u000b\u0007\u00077\u0019\tc!\n\u0011\t\u0005}5QD\u0005\u0005\u0007?\tiKA\u0005UQJ|w/\u00192mK\"911\u0005\u001fA\u0002\u0005]\u0012aA7tO\"91q\u0005\u001fA\u0002\rm\u0011!A3\u0002#]LG\u000f[%oi\u0016\u0014h.\u00197FeJ|'/\u0006\u0003\u0004.\rMB\u0003BB\u0018\u0007s!Ba!\r\u00046A!\u0011QYB\u001a\t\u001d\tI-\u0010b\u0001\u0003\u0017D\u0001\"a7>\t\u0003\u00071q\u0007\t\u0006\u001d\u0006}7\u0011\u0007\u0005\b\u0007Gi\u0004\u0019AA\u001c\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u00111q\b\u0016\u0004]\n\r\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0004F)\u001aQOa!")
public class QueryExecution
implements Logging {
    private LogicalPlan analyzed;
    private LogicalPlan commandExecuted;
    private LogicalPlan withCachedData;
    private LogicalPlan optimizedPlan;
    private SparkPlan sparkPlan;
    private SparkPlan executedPlan;
    private RDD<InternalRow> toRdd;
    private volatile QueryExecution$debug$ debug$module;
    private final SparkSession sparkSession;
    private final LogicalPlan logical;
    private final QueryPlanningTracker tracker;
    private final Enumeration.Value mode;
    private final long id;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static Enumeration.Value $lessinit$greater$default$4() {
        return QueryExecution$.MODULE$.$lessinit$greater$default$4();
    }

    public static QueryPlanningTracker $lessinit$greater$default$3() {
        return QueryExecution$.MODULE$.$lessinit$greater$default$3();
    }

    public static SparkPlan prepareExecutedPlan(SparkSession session, LogicalPlan plan, AdaptiveExecutionContext context) {
        return QueryExecution$.MODULE$.prepareExecutedPlan(session, plan, context);
    }

    public static SparkPlan prepareExecutedPlan(SparkSession spark, LogicalPlan plan) {
        return QueryExecution$.MODULE$.prepareExecutedPlan(spark, plan);
    }

    public static SparkPlan prepareExecutedPlan(SparkSession spark, SparkPlan plan) {
        return QueryExecution$.MODULE$.prepareExecutedPlan(spark, plan);
    }

    public static SparkPlan createSparkPlan(SparkSession sparkSession, SparkPlanner planner, LogicalPlan plan) {
        return QueryExecution$.MODULE$.createSparkPlan(sparkSession, planner, plan);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public QueryExecution$debug$ debug() {
        if (this.debug$module == null) {
            this.debug$lzycompute$1();
        }
        return this.debug$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    public LogicalPlan logical() {
        return this.logical;
    }

    public QueryPlanningTracker tracker() {
        return this.tracker;
    }

    public Enumeration.Value mode() {
        return this.mode;
    }

    public long id() {
        return this.id;
    }

    public SparkPlanner planner() {
        return this.sparkSession().sessionState().planner();
    }

    public void assertAnalyzed() {
        this.analyzed();
    }

    public void assertSupported() {
        block0: {
            if (!this.sparkSession().sessionState().conf().isUnsupportedOperationCheckEnabled()) break block0;
            UnsupportedOperationChecker$.MODULE$.checkForBatch(this.analyzed());
        }
    }

    private LogicalPlan analyzed$lzycompute() {
        QueryExecution queryExecution = this;
        synchronized (queryExecution) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.analyzed = (LogicalPlan)this.executePhase(QueryPlanningTracker$.MODULE$.ANALYSIS(), (Function0 & Serializable)() -> this.sparkSession().sessionState().analyzer().executeAndCheck(this.logical(), this.tracker()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.analyzed;
    }

    public LogicalPlan analyzed() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.analyzed$lzycompute() : this.analyzed;
    }

    private LogicalPlan commandExecuted$lzycompute() {
        QueryExecution queryExecution = this;
        synchronized (queryExecution) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                LogicalPlan logicalPlan2;
                Enumeration.Value value = this.mode();
                Enumeration.Value value2 = CommandExecutionMode$.MODULE$.NON_ROOT();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    logicalPlan2 = (LogicalPlan)this.analyzed().mapChildren((Function1 & Serializable)p -> this.eagerlyExecuteCommands((LogicalPlan)p));
                } else {
                    Enumeration.Value value4 = CommandExecutionMode$.MODULE$.ALL();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        logicalPlan2 = this.eagerlyExecuteCommands(this.analyzed());
                    } else {
                        Enumeration.Value value6 = CommandExecutionMode$.MODULE$.SKIP();
                        Enumeration.Value value7 = value;
                        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                            logicalPlan2 = this.analyzed();
                        } else {
                            throw new MatchError((Object)value);
                        }
                    }
                }
                this.commandExecuted = logicalPlan2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.commandExecuted;
    }

    public LogicalPlan commandExecuted() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.commandExecuted$lzycompute() : this.commandExecuted;
    }

    public String org$apache$spark$sql$execution$QueryExecution$$commandExecutionName(Command command) {
        Command command2 = command;
        String string = command2 instanceof CreateTableAsSelect ? "create" : (command2 instanceof ReplaceTableAsSelect ? "replace" : (command2 instanceof AppendData ? "append" : (command2 instanceof OverwriteByExpression ? "overwrite" : (command2 instanceof OverwritePartitionsDynamic ? "overwritePartitions" : "command"))));
        return string;
    }

    private LogicalPlan eagerlyExecuteCommands(LogicalPlan p) {
        return (LogicalPlan)p.transformDown((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ QueryExecution $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Command) {
                    Command command = (Command)A1;
                    QueryExecution qe = this.$outer.sparkSession().sessionState().executePlan((LogicalPlan)command, CommandExecutionMode$.MODULE$.NON_ROOT());
                    InternalRow[] result = (InternalRow[])SQLExecution$.MODULE$.withNewExecutionId(qe, (Option<String>)new Some((Object)this.$outer.org$apache$spark$sql$execution$QueryExecution$$commandExecutionName(command)), (Function0 & Serializable)() -> qe.executedPlan().executeCollect());
                    object = new CommandResult((Seq<Attribute>)qe.analyzed().output(), qe.commandExecuted(), qe.executedPlan(), (Seq<InternalRow>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)result));
                } else {
                    object = A1;
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 instanceof Command ? true : true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.execution.QueryExecution )}, serializedLambda);
            }
        });
    }

    private LogicalPlan withCachedData$lzycompute() {
        QueryExecution queryExecution = this;
        synchronized (queryExecution) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.withCachedData = (LogicalPlan)this.sparkSession().withActive((Function0 & Serializable)() -> {
                    this.assertAnalyzed();
                    this.assertSupported();
                    return this.sparkSession().sharedState().cacheManager().useCachedData(this.commandExecuted().clone());
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.withCachedData;
    }

    public LogicalPlan withCachedData() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.withCachedData$lzycompute() : this.withCachedData;
    }

    public void assertCommandExecuted() {
        this.commandExecuted();
    }

    private LogicalPlan optimizedPlan$lzycompute() {
        QueryExecution queryExecution = this;
        synchronized (queryExecution) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.assertCommandExecuted();
                this.optimizedPlan = (LogicalPlan)this.executePhase(QueryPlanningTracker$.MODULE$.OPTIMIZATION(), (Function0 & Serializable)() -> {
                    void var1_1;
                    LogicalPlan plan = (LogicalPlan)this.sparkSession().sessionState().optimizer().executeAndTrack((TreeNode)this.withCachedData().clone(), this.tracker());
                    plan.setAnalyzed();
                    return var1_1;
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.optimizedPlan;
    }

    public LogicalPlan optimizedPlan() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.optimizedPlan$lzycompute() : this.optimizedPlan;
    }

    private void assertOptimized() {
        this.optimizedPlan();
    }

    private SparkPlan sparkPlan$lzycompute() {
        QueryExecution queryExecution = this;
        synchronized (queryExecution) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.assertOptimized();
                this.sparkPlan = (SparkPlan)this.executePhase(QueryPlanningTracker$.MODULE$.PLANNING(), (Function0 & Serializable)() -> QueryExecution$.MODULE$.createSparkPlan(this.sparkSession(), this.planner(), this.optimizedPlan().clone()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.sparkPlan;
    }

    public SparkPlan sparkPlan() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.sparkPlan$lzycompute() : this.sparkPlan;
    }

    private SparkPlan executedPlan$lzycompute() {
        QueryExecution queryExecution = this;
        synchronized (queryExecution) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.assertOptimized();
                this.executedPlan = (SparkPlan)this.executePhase(QueryPlanningTracker$.MODULE$.PLANNING(), (Function0 & Serializable)() -> QueryExecution$.MODULE$.prepareForExecution(this.preparations(), (SparkPlan)this.sparkPlan().clone()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.executedPlan;
    }

    public SparkPlan executedPlan() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.executedPlan$lzycompute() : this.executedPlan;
    }

    private RDD<InternalRow> toRdd$lzycompute() {
        QueryExecution queryExecution = this;
        synchronized (queryExecution) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.toRdd = new SQLExecutionRDD(this.executedPlan().execute(), this.sparkSession().sessionState().conf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.toRdd;
    }

    public RDD<InternalRow> toRdd() {
        return (byte)(this.bitmap$0 & 0x40) == 0 ? this.toRdd$lzycompute() : this.toRdd;
    }

    public Map<String, Row> observedMetrics() {
        return CollectMetricsExec$.MODULE$.collect(this.executedPlan());
    }

    public Seq<Rule<SparkPlan>> preparations() {
        return QueryExecution$.MODULE$.preparations(this.sparkSession(), (Option<InsertAdaptiveSparkPlan>)Option$.MODULE$.apply((Object)new InsertAdaptiveSparkPlan(new AdaptiveExecutionContext(this.sparkSession(), this))), false);
    }

    public <T> T executePhase(String phase, Function0<T> block) {
        return this.sparkSession().withActive((Function0 & Serializable)() -> QueryExecution$.MODULE$.withInternalError(new StringBuilder(51).append("The Spark SQL phase ").append(phase).append(" failed with an internal error.").toString(), (Function0 & Serializable)() -> this.tracker().measurePhase(phase, block)));
    }

    public String simpleString() {
        StringUtils.PlanStringConcat concat = new StringUtils.PlanStringConcat();
        this.simpleString(false, SQLConf$.MODULE$.get().maxToStringFields(), (Function1<String, BoxedUnit>)(Function1 & Serializable)s -> {
            concat.append(s);
            return BoxedUnit.UNIT;
        });
        return this.withRedaction(concat.toString());
    }

    private void simpleString(boolean formatted, int maxFields, Function1<String, BoxedUnit> append) {
        Object object;
        append.apply((Object)"== Physical Plan ==\n");
        if (formatted) {
            try {
                ExplainUtils$.MODULE$.processPlan(this.executedPlan(), append);
                object = BoxedUnit.UNIT;
            }
            catch (AnalysisException e) {
                object = append.apply((Object)e.toString());
            }
            catch (IllegalArgumentException e) {
                object = append.apply((Object)e.toString());
            }
        } else {
            QueryPlan$.MODULE$.append((Function0 & Serializable)() -> this.executedPlan(), append, false, false, maxFields, QueryPlan$.MODULE$.append$default$6());
            object = BoxedUnit.UNIT;
        }
        append.apply((Object)"\n");
    }

    public String explainString(ExplainMode mode) {
        StringUtils.PlanStringConcat concat = new StringUtils.PlanStringConcat();
        this.org$apache$spark$sql$execution$QueryExecution$$explainString(mode, SQLConf$.MODULE$.get().maxToStringFields(), (Function1<String, BoxedUnit>)(Function1 & Serializable)s -> {
            concat.append(s);
            return BoxedUnit.UNIT;
        });
        return this.withRedaction(concat.toString());
    }

    public void org$apache$spark$sql$execution$QueryExecution$$explainString(ExplainMode mode, int maxFields, Function1<String, BoxedUnit> append) {
        QueryExecution queryExecution = this.logical().isStreaming() ? new IncrementalExecution(this.sparkSession(), this.logical(), OutputMode.Append(), "<unknown>", UUID.randomUUID(), UUID.randomUUID(), 0L, new OffsetSeqMetadata(0L, 0L, OffsetSeqMetadata$.MODULE$.apply$default$3())) : this;
        ExplainMode explainMode = mode;
        if (SimpleMode$.MODULE$.equals(explainMode)) {
            queryExecution.simpleString(false, maxFields, append);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ExtendedMode$.MODULE$.equals(explainMode)) {
            queryExecution.toString(maxFields, append);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (CodegenMode$.MODULE$.equals(explainMode)) {
            BoxedUnit boxedUnit;
            try {
                package$.MODULE$.writeCodegen(append, queryExecution.executedPlan());
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (AnalysisException e) {
                boxedUnit = (BoxedUnit)append.apply((Object)e.toString());
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (CostMode$.MODULE$.equals(explainMode)) {
            queryExecution.stringWithStats(maxFields, append);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (FormattedMode$.MODULE$.equals(explainMode)) {
            queryExecution.simpleString(true, maxFields, append);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)explainMode);
        }
    }

    private void writePlans(Function1<String, BoxedUnit> append, int maxFields) {
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(true, false);
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        boolean verbose = sp2._1$mcZ$sp();
        boolean addSuffix = sp2._2$mcZ$sp();
        Tuple2.mcZZ.sp sp3 = new Tuple2.mcZZ.sp(verbose, addSuffix);
        Tuple2.mcZZ.sp sp4 = sp3;
        boolean verbose2 = sp4._1$mcZ$sp();
        boolean addSuffix2 = sp4._2$mcZ$sp();
        append.apply((Object)"== Parsed Logical Plan ==\n");
        QueryPlan$.MODULE$.append((Function0 & Serializable)() -> this.logical(), append, verbose2, addSuffix2, maxFields, QueryPlan$.MODULE$.append$default$6());
        append.apply((Object)"\n== Analyzed Logical Plan ==\n");
        try {
            Object object;
            if (this.analyzed().output().nonEmpty()) {
                append.apply((Object)org.apache.spark.sql.catalyst.util.package$.MODULE$.truncatedString((Seq)this.analyzed().output().map((Function1 & Serializable)o -> new StringBuilder(2).append(o.name()).append(": ").append(o.dataType().simpleString()).toString()), ", ", maxFields));
                object = append.apply((Object)"\n");
            } else {
                object = BoxedUnit.UNIT;
            }
            QueryPlan$.MODULE$.append((Function0 & Serializable)() -> this.analyzed(), append, verbose2, addSuffix2, maxFields, QueryPlan$.MODULE$.append$default$6());
            append.apply((Object)"\n== Optimized Logical Plan ==\n");
            QueryPlan$.MODULE$.append((Function0 & Serializable)() -> this.optimizedPlan(), append, verbose2, addSuffix2, maxFields, QueryPlan$.MODULE$.append$default$6());
            append.apply((Object)"\n== Physical Plan ==\n");
            QueryPlan$.MODULE$.append((Function0 & Serializable)() -> this.executedPlan(), append, verbose2, addSuffix2, maxFields, QueryPlan$.MODULE$.append$default$6());
        }
        catch (AnalysisException e) {
            append.apply((Object)e.toString());
        }
    }

    public String toString() {
        StringUtils.PlanStringConcat concat = new StringUtils.PlanStringConcat();
        this.toString(SQLConf$.MODULE$.get().maxToStringFields(), (Function1<String, BoxedUnit>)(Function1 & Serializable)s -> {
            concat.append(s);
            return BoxedUnit.UNIT;
        });
        return this.withRedaction(this.withRedaction(concat.toString()));
    }

    private void toString(int maxFields, Function1<String, BoxedUnit> append) {
        this.writePlans(append, maxFields);
    }

    public String stringWithStats() {
        StringUtils.PlanStringConcat concat = new StringUtils.PlanStringConcat();
        this.stringWithStats(SQLConf$.MODULE$.get().maxToStringFields(), (Function1<String, BoxedUnit>)(Function1 & Serializable)s -> {
            concat.append(s);
            return BoxedUnit.UNIT;
        });
        return this.withRedaction(concat.toString());
    }

    private void stringWithStats(int maxFields, Function1<String, BoxedUnit> append) {
        Object object;
        try {
            object = this.optimizedPlan().collectWithSubqueries((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Statistics statistics = A1.stats();
                    return (B1)statistics;
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan2 = x1;
                    boolean bl = true;
                    return bl;
                }
            });
        }
        catch (AnalysisException e) {
            object = append.apply((Object)new StringBuilder(1).append(e.toString()).append("\n").toString());
        }
        append.apply((Object)"== Optimized Logical Plan ==\n");
        QueryPlan$.MODULE$.append((Function0 & Serializable)() -> this.optimizedPlan(), append, true, true, maxFields, QueryPlan$.MODULE$.append$default$6());
        append.apply((Object)"\n== Physical Plan ==\n");
        QueryPlan$.MODULE$.append((Function0 & Serializable)() -> this.executedPlan(), append, true, false, maxFields, QueryPlan$.MODULE$.append$default$6());
        append.apply((Object)"\n");
    }

    private String withRedaction(String message) {
        return Utils$.MODULE$.redact(this.sparkSession().sessionState().conf().stringRedactionPattern(), message);
    }

    private final void debug$lzycompute$1() {
        QueryExecution queryExecution = this;
        synchronized (queryExecution) {
            if (this.debug$module == null) {
                this.debug$module = new QueryExecution$debug$(this);
            }
        }
    }

    public QueryExecution(SparkSession sparkSession, LogicalPlan logical, QueryPlanningTracker tracker, Enumeration.Value mode) {
        this.sparkSession = sparkSession;
        this.logical = logical;
        this.tracker = tracker;
        this.mode = mode;
        Logging.$init$((Logging)this);
        this.id = QueryExecution$.MODULE$.org$apache$spark$sql$execution$QueryExecution$$nextExecutionId();
    }
}

