/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression$;
import org.apache.spark.sql.catalyst.planning.PhysicalOperation$;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.FilterEstimation;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.datasources.CatalogFileIndex;
import org.apache.spark.sql.execution.datasources.DataSourceStrategy$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.PruneFileSourcePartitions$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class PruneFileSourcePartitions$
extends Rule<LogicalPlan> {
    public static final PruneFileSourcePartitions$ MODULE$ = new PruneFileSourcePartitions$();

    public Project org$apache$spark$sql$execution$datasources$PruneFileSourcePartitions$$rebuildPhysicalOperation(Seq<NamedExpression> projects, Seq<Expression> filters, LeafNode relation) {
        LogicalPlan logicalPlan2;
        if (filters.nonEmpty()) {
            Expression filterExpression = (Expression)filters.reduceLeft((Function2)And$.MODULE$);
            logicalPlan2 = new Filter(filterExpression, (LogicalPlan)relation);
        } else {
            logicalPlan2 = (LogicalPlan)relation;
        }
        LogicalPlan withFilter = logicalPlan2;
        return new Project(projects, withFilter);
    }

    public LogicalPlan apply(LogicalPlan plan) {
        return (LogicalPlan)plan.transformDown((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                Option option;
                A1 A1 = x1;
                if (A1 != null && !(option = PhysicalOperation$.MODULE$.unapply(A1)).isEmpty()) {
                    LogicalRelation logicalRelation;
                    BaseRelation fsRelation;
                    Seq projects = (Seq)((Tuple3)option.get())._1();
                    Seq filters = (Seq)((Tuple3)option.get())._2();
                    LogicalPlan logicalRelation2 = (LogicalPlan)((Tuple3)option.get())._3();
                    if (logicalRelation2 instanceof LogicalRelation && (fsRelation = (logicalRelation = (LogicalRelation)logicalRelation2).relation()) instanceof HadoopFsRelation) {
                        HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)fsRelation;
                        FileIndex catalogFileIndex = hadoopFsRelation.location();
                        StructType partitionSchema = hadoopFsRelation.partitionSchema();
                        if (catalogFileIndex instanceof CatalogFileIndex) {
                            CatalogFileIndex catalogFileIndex2 = (CatalogFileIndex)catalogFileIndex;
                            if (filters.nonEmpty() && hadoopFsRelation.partitionSchema().nonEmpty()) {
                                Object object2;
                                Seq partitionKeyFilters;
                                Seq<Expression> normalizedFilters = DataSourceStrategy$.MODULE$.normalizeExprs((Seq<Expression>)((Seq)filters.filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)anonfun.apply.1.$anonfun$applyOrElse$1(f)))), logicalRelation.output());
                                Tuple2<Seq<Expression>, Seq<Expression>> tuple2 = DataSourceUtils$.MODULE$.getPartitionFiltersAndDataFilters(partitionSchema, normalizedFilters);
                                if (tuple2 == null) throw new MatchError(tuple2);
                                Seq seq = partitionKeyFilters = (Seq)tuple2._1();
                                Seq partitionKeyFilters2 = seq;
                                if (partitionKeyFilters2.nonEmpty()) {
                                    InMemoryFileIndex prunedFileIndex = catalogFileIndex2.filterPartitions((Seq<Expression>)partitionKeyFilters2);
                                    HadoopFsRelation prunedFsRelation = hadoopFsRelation.copy(prunedFileIndex, hadoopFsRelation.copy$default$2(), hadoopFsRelation.copy$default$3(), hadoopFsRelation.copy$default$4(), hadoopFsRelation.copy$default$5(), hadoopFsRelation.copy$default$6(), hadoopFsRelation.sparkSession());
                                    Option filteredStats = new FilterEstimation(new Filter((Expression)partitionKeyFilters2.reduce((Function2)And$.MODULE$), (LogicalPlan)logicalRelation)).estimate();
                                    Option colStats = filteredStats.map((Function1 & Serializable)x$1 -> (Map)x$1.attributeStats().map((Function1 & Serializable)x0$1 -> {
                                        Tuple2 tuple2 = x0$1;
                                        if (tuple2 == null) {
                                            throw new MatchError((Object)tuple2);
                                        }
                                        Attribute attr = (Attribute)tuple2._1();
                                        ColumnStat colStat = (ColumnStat)tuple2._2();
                                        Tuple2 tuple22 = new Tuple2((Object)attr.name(), (Object)colStat.toCatalogColumnStat(attr.name(), attr.dataType()));
                                        return tuple22;
                                    }));
                                    Option withStats = logicalRelation.catalogTable().map((Function1 & Serializable)x$2 -> {
                                        Some x$1 = new Some((Object)new CatalogStatistics(package$.MODULE$.BigInt().apply(prunedFileIndex.sizeInBytes()), filteredStats.flatMap((Function1 & Serializable)x$3 -> x$3.rowCount()), (Map)colStats.getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty())));
                                        TableIdentifier x$22 = x$2.copy$default$1();
                                        CatalogTableType x$32 = x$2.copy$default$2();
                                        CatalogStorageFormat x$4 = x$2.copy$default$3();
                                        StructType x$5 = x$2.copy$default$4();
                                        Option x$6 = x$2.copy$default$5();
                                        Seq x$7 = x$2.copy$default$6();
                                        Option x$8 = x$2.copy$default$7();
                                        String x$9 = x$2.copy$default$8();
                                        long x$10 = x$2.copy$default$9();
                                        long x$11 = x$2.copy$default$10();
                                        String x$12 = x$2.copy$default$11();
                                        Map x$13 = x$2.copy$default$12();
                                        Option x$14 = x$2.copy$default$14();
                                        Option x$15 = x$2.copy$default$15();
                                        Seq x$16 = x$2.copy$default$16();
                                        boolean x$17 = x$2.copy$default$17();
                                        boolean x$18 = x$2.copy$default$18();
                                        Map x$19 = x$2.copy$default$19();
                                        Option x$20 = x$2.copy$default$20();
                                        return x$2.copy(x$22, x$32, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option)x$1, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
                                    });
                                    HadoopFsRelation x$21 = prunedFsRelation;
                                    Option x$22 = withStats;
                                    Seq<AttributeReference> x$23 = logicalRelation.copy$default$2();
                                    boolean x$24 = logicalRelation.copy$default$4();
                                    LogicalRelation prunedLogicalRelation = logicalRelation.copy(x$21, x$23, (Option<CatalogTable>)x$22, x$24);
                                    object2 = PruneFileSourcePartitions$.MODULE$.org$apache$spark$sql$execution$datasources$PruneFileSourcePartitions$$rebuildPhysicalOperation((Seq<NamedExpression>)projects, (Seq<Expression>)filters, prunedLogicalRelation);
                                } else {
                                    object2 = A1;
                                }
                                object = object2;
                                return (B1)object;
                            }
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                if (logicalPlan2 == null) return false;
                Option option = PhysicalOperation$.MODULE$.unapply(logicalPlan2);
                if (option.isEmpty()) return false;
                Seq filters = (Seq)((Tuple3)option.get())._2();
                LogicalPlan logicalRelation = (LogicalPlan)((Tuple3)option.get())._3();
                if (!(logicalRelation instanceof LogicalRelation)) return false;
                LogicalRelation logicalRelation2 = (LogicalRelation)logicalRelation;
                BaseRelation fsRelation = logicalRelation2.relation();
                if (!(fsRelation instanceof HadoopFsRelation)) return false;
                HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)fsRelation;
                FileIndex catalogFileIndex = hadoopFsRelation.location();
                if (!(catalogFileIndex instanceof CatalogFileIndex)) return false;
                if (!filters.nonEmpty()) return false;
                if (!hadoopFsRelation.partitionSchema().nonEmpty()) return false;
                return true;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$1(Expression f) {
                return f.deterministic() && !SubqueryExpression$.MODULE$.hasSubquery(f);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.catalyst.expressions.Expression ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.plans.logical.Statistics ), $anonfun$applyOrElse$3(scala.Tuple2 ), $anonfun$applyOrElse$4(org.apache.spark.sql.execution.datasources.InMemoryFileIndex scala.Option scala.Option org.apache.spark.sql.catalyst.catalog.CatalogTable ), $anonfun$applyOrElse$5(org.apache.spark.sql.catalyst.plans.logical.Statistics ), $anonfun$applyOrElse$6()}, serializedLambda);
            }
        });
    }

    private PruneFileSourcePartitions$() {
    }
}

