/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.IndexAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchIndexException;
import org.apache.spark.sql.catalyst.analysis.NonEmptyNamespaceException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class PostgresDialect$
extends JdbcDialect
implements SQLConfHelper {
    public static final PostgresDialect$ MODULE$ = new PostgresDialect$();
    private static final Set<String> supportedAggregateFunctions;
    private static final Set<String> supportedFunctions;

    static {
        SQLConfHelper.$init$((SQLConfHelper)MODULE$);
        supportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG", "VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP", "COVAR_POP", "COVAR_SAMP", "CORR", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXY"}));
        supportedFunctions = MODULE$.supportedAggregateFunctions();
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:postgresql");
    }

    private Set<String> supportedAggregateFunctions() {
        return supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        Some some;
        if (sqlType == 7) {
            some = new Some((Object)FloatType$.MODULE$);
            return some;
        }
        if (sqlType == 5) {
            some = new Some((Object)ShortType$.MODULE$);
            return some;
        }
        if (sqlType == -7) {
            String string = typeName;
            String string2 = "bit";
            if (!(string != null ? !string.equals(string2) : string2 != null) && size != 1) {
                some = new Some((Object)BinaryType$.MODULE$);
                return some;
            }
        }
        if (sqlType == 8) {
            String string = typeName;
            String string3 = "money";
            if (!(string != null ? !string.equals(string3) : string3 != null)) {
                some = new Some((Object)StringType$.MODULE$);
                return some;
            }
        }
        if (sqlType == 1111) {
            some = new Some((Object)StringType$.MODULE$);
            return some;
        }
        if (sqlType == 2003) {
            int scale = (int)md.build().getLong("scale");
            some = this.toCatalystType(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(typeName), 1), size, scale).map((Function1 & Serializable)x$1 -> ArrayType$.MODULE$.apply(x$1));
            return some;
        }
        some = None$.MODULE$;
        return some;
    }

    private Option<DataType> toCatalystType(String typeName, int precision, int scale) {
        None$ none$;
        block50: {
            block47: {
                block49: {
                    block51: {
                        block48: {
                            String string = typeName;
                            switch (string == null ? 0 : string.hashCode()) {
                                case -2080719092: {
                                    if (!"pg_snapshot".equals(string)) break block47;
                                    break block48;
                                }
                                case -2000413939: {
                                    if (!"numeric".equals(string)) break block47;
                                    break block49;
                                }
                                case -1534143358: {
                                    if (!"tsvector".equals(string)) break block47;
                                    break block48;
                                }
                                case -1382823772: {
                                    if (!"bpchar".equals(string)) break block47;
                                    break block48;
                                }
                                case -1360216880: {
                                    if (!"circle".equals(string)) break block47;
                                    break block48;
                                }
                                case -1271649960: {
                                    if (!"float4".equals(string)) break block47;
                                    none$ = new Some((Object)FloatType$.MODULE$);
                                    break block50;
                                }
                                case -1271649956: {
                                    if (!"float8".equals(string)) break block47;
                                    none$ = new Some((Object)DoubleType$.MODULE$);
                                    break block50;
                                }
                                case -1023458903: {
                                    if (!"tsquery".equals(string)) break block47;
                                    break block48;
                                }
                                case -990442113: {
                                    if (!"pg_lsn".equals(string)) break block47;
                                    break block48;
                                }
                                case -873668077: {
                                    if (!"timetz".equals(string)) break block47;
                                    break block51;
                                }
                                case -823652218: {
                                    if (!"varbit".equals(string)) break block47;
                                    break block48;
                                }
                                case -397519558: {
                                    if (!"polygon".equals(string)) break block47;
                                    break block48;
                                }
                                case -191744392: {
                                    if (!"macaddr8".equals(string)) break block47;
                                    break block48;
                                }
                                case 97549: {
                                    if (!"bit".equals(string)) break block47;
                                    none$ = new Some((Object)BinaryType$.MODULE$);
                                    break block50;
                                }
                                case 97739: {
                                    if (!"box".equals(string)) break block47;
                                    break block48;
                                }
                                case 110026: {
                                    if ("oid".equals(string)) {
                                        break;
                                    }
                                    break block47;
                                }
                                case 118807: {
                                    if (!"xml".equals(string)) break block47;
                                    break block48;
                                }
                                case 3029738: {
                                    if (!"bool".equals(string)) break block47;
                                    none$ = new Some((Object)BooleanType$.MODULE$);
                                    break block50;
                                }
                                case 3052374: {
                                    if (!"char".equals(string)) break block47;
                                    break block48;
                                }
                                case 3053428: {
                                    if (!"cidr".equals(string)) break block47;
                                    break block48;
                                }
                                case 3076014: {
                                    if (!"date".equals(string)) break block47;
                                    none$ = new Some((Object)DateType$.MODULE$);
                                    break block50;
                                }
                                case 3237012: {
                                    if (!"inet".equals(string)) break block47;
                                    break block48;
                                }
                                case 3237411: {
                                    if (!"int2".equals(string)) break block47;
                                    none$ = new Some((Object)ShortType$.MODULE$);
                                    break block50;
                                }
                                case 3237413: {
                                    if (!"int4".equals(string)) break block47;
                                    none$ = new Some((Object)IntegerType$.MODULE$);
                                    break block50;
                                }
                                case 3237417: {
                                    if ("int8".equals(string)) {
                                        break;
                                    }
                                    break block47;
                                }
                                case 3271912: {
                                    if (!"json".equals(string)) break block47;
                                    break block48;
                                }
                                case 3321844: {
                                    if (!"line".equals(string)) break block47;
                                    break block48;
                                }
                                case 3331177: {
                                    if (!"lseg".equals(string)) break block47;
                                    break block48;
                                }
                                case 3433509: {
                                    if (!"path".equals(string)) break block47;
                                    break block48;
                                }
                                case 3556653: {
                                    if (!"text".equals(string)) break block47;
                                    break block48;
                                }
                                case 3560141: {
                                    if (!"time".equals(string)) break block47;
                                    break block51;
                                }
                                case 3601339: {
                                    if (!"uuid".equals(string)) break block47;
                                    break block48;
                                }
                                case 55126294: {
                                    if (!"timestamp".equals(string)) break block47;
                                    break block51;
                                }
                                case 94224473: {
                                    if (!"bytea".equals(string)) break block47;
                                    none$ = new Some((Object)BinaryType$.MODULE$);
                                    break block50;
                                }
                                case 101429370: {
                                    if (!"jsonb".equals(string)) break block47;
                                    break block48;
                                }
                                case 104079552: {
                                    if (!"money".equals(string)) break block47;
                                    none$ = None$.MODULE$;
                                    break block50;
                                }
                                case 106845584: {
                                    if (!"point".equals(string)) break block47;
                                    break block48;
                                }
                                case 236613373: {
                                    if (!"varchar".equals(string)) break block47;
                                    break block48;
                                }
                                case 570418373: {
                                    if (!"interval".equals(string)) break block47;
                                    break block48;
                                }
                                case 825098688: {
                                    if (!"macaddr".equals(string)) break block47;
                                    break block48;
                                }
                                case 1132592996: {
                                    if (!"txid_snapshot".equals(string)) break block47;
                                    break block48;
                                }
                                case 1436764700: {
                                    if (!"timestamptz".equals(string)) break block47;
                                    break block51;
                                }
                                case 1542263633: {
                                    if (!"decimal".equals(string)) break block47;
                                    break block49;
                                }
                                default: {
                                    break block47;
                                }
                            }
                            none$ = new Some((Object)LongType$.MODULE$);
                            break block50;
                        }
                        none$ = new Some((Object)StringType$.MODULE$);
                        break block50;
                    }
                    none$ = new Some((Object)TimestampType$.MODULE$);
                    break block50;
                }
                none$ = precision > 0 ? new Some((Object)DecimalType$.MODULE$.bounded(precision, scale)) : new Some((Object)DecimalType$.MODULE$.SYSTEM_DEFAULT());
                break block50;
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        Object object;
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("TEXT", 1));
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("BYTEA", -2));
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("BOOLEAN", 16));
        } else if (FloatType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("FLOAT4", 6));
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("FLOAT8", 8));
        } else {
            boolean bl = ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType);
            if (bl) {
                object = new Some((Object)new JdbcType("SMALLINT", 5));
            } else if (dataType instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)dataType;
                object = new Some((Object)new JdbcType(new StringBuilder(10).append("NUMERIC(").append(decimalType.precision()).append(",").append(decimalType.scale()).append(")").toString(), 2));
            } else {
                ArrayType arrayType;
                DataType et;
                object = dataType instanceof ArrayType && (et = (arrayType = (ArrayType)dataType).elementType()) instanceof AtomicType ? this.getJDBCType(et).map((Function1 & Serializable)x$2 -> x$2.databaseTypeDefinition()).orElse((Function0 & Serializable)() -> JdbcUtils$.MODULE$.getCommonJDBCType(et).map((Function1 & Serializable)x$3 -> x$3.databaseTypeDefinition())).map((Function1 & Serializable)typeName -> new JdbcType(new StringBuilder(2).append((String)typeName).append("[]").toString(), 2003)) : None$.MODULE$;
            }
        }
        return object;
    }

    @Override
    public String getTableExistsQuery(String table) {
        return new StringBuilder(22).append("SELECT 1 FROM ").append(table).append(" LIMIT 1").toString();
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        Some some;
        boolean bl;
        Option<Object> option = cascade;
        String string = option instanceof Some && (bl = BoxesRunTime.unboxToBoolean((Object)(some = (Some)option).value())) ? new StringBuilder(28).append("TRUNCATE TABLE ONLY ").append(table).append(" CASCADE").toString() : new StringBuilder(20).append("TRUNCATE TABLE ONLY ").append(table).toString();
        return string;
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public void beforeFetch(Connection connection, scala.collection.immutable.Map<String, String> properties) {
        block0: {
            super.beforeFetch(connection, properties);
            if (StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)properties.getOrElse((Object)JDBCOptions$.MODULE$.JDBC_BATCH_FETCH_SIZE(), (Function0 & Serializable)() -> "0"))) <= 0) break block0;
            connection.setAutoCommit(false);
        }
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return new StringBuilder(32).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" TYPE ").append(newDataType).toString();
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "DROP NOT NULL" : "SET NOT NULL";
        return new StringBuilder(27).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(nullable).toString();
    }

    @Override
    public boolean supportsTableSample() {
        return true;
    }

    @Override
    public String getTableSample(TableSampleInfo sample) {
        return new StringBuilder(21).append("TABLESAMPLE BERNOULLI").append(new StringBuilder(17).append(" (").append((sample.upperBound() - sample.lowerBound()) * (double)100).append(") REPEATABLE (").append(sample.seed()).append(")").toString()).toString();
    }

    @Override
    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        String[] columnList = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)col -> MODULE$.quoteIdentifier((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])col.fieldNames()))), ClassTag$.MODULE$.apply(String.class));
        String indexProperties = "";
        Tuple2<String, String[]> tuple2 = JdbcUtils$.MODULE$.processIndexProperties(properties, "postgresql");
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String indexType = (String)tuple2._1();
        String[] indexPropertyList = (String[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)indexType, (Object)indexPropertyList);
        Tuple2 tuple23 = tuple22;
        String indexType2 = (String)tuple23._1();
        String[] indexPropertyList2 = (String[])tuple23._2();
        if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])indexPropertyList2))) {
            indexProperties = new StringBuilder(7).append("WITH (").append(Predef$.MODULE$.wrapRefArray((Object[])indexPropertyList2).mkString(", ")).append(")").toString();
        }
        return new StringBuilder(0).append(new StringBuilder(17).append("CREATE INDEX ").append(this.quoteIdentifier(indexName)).append(" ON ").append(this.quoteIdentifier(tableIdent.name())).toString()).append(new StringBuilder(5).append(" ").append(indexType2).append(" (").append(Predef$.MODULE$.wrapRefArray((Object[])columnList).mkString(", ")).append(") ").append(indexProperties).toString()).toString();
    }

    @Override
    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        String sql = new StringBuilder(0).append(new StringBuilder(49).append("SELECT * FROM pg_indexes WHERE tablename = '").append(tableIdent.name()).append("' AND").toString()).append(new StringBuilder(15).append(" indexname = '").append(indexName).append("'").toString()).toString();
        return JdbcUtils$.MODULE$.checkIfIndexExists(conn, sql, options);
    }

    @Override
    public String dropIndex(String indexName, Identifier tableIdent) {
        return new StringBuilder(11).append("DROP INDEX ").append(this.quoteIdentifier(indexName)).toString();
    }

    @Override
    public AnalysisException classifyException(String message, Throwable e) {
        AnalysisException analysisException;
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            AnalysisException analysisException2;
            SQLException sQLException = (SQLException)throwable;
            String string = sQLException.getSQLState();
            switch (string == null ? 0 : string.hashCode()) {
                case 48220673: {
                    if (!"2BP01".equals(string)) break;
                    throw new NonEmptyNamespaceException(message, (Option)new Some((Object)e));
                }
                case 49567037: {
                    if (!"42704".equals(string)) break;
                    Regex regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?s)Failed to drop index (.*) in (.*)"));
                    String indexName = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)message).get()).group(1);
                    String tableName = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)message).get()).group(2);
                    throw new NoSuchIndexException(indexName, tableName, (Option)new Some((Object)e));
                }
                case 49591065: {
                    if (!"42P07".equals(string)) break;
                    Regex regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?s)Failed to create index (.*) in (.*)"));
                    String indexName = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)message).get()).group(1);
                    String tableName = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)message).get()).group(2);
                    throw new IndexAlreadyExistsException(indexName, tableName, (Option)new Some((Object)e));
                }
            }
            analysisException = analysisException2 = super.classifyException(message, e);
        } else {
            if (throwable instanceof UnsupportedOperationException) {
                UnsupportedOperationException unsupportedOperationException = (UnsupportedOperationException)throwable;
                throw unsupportedOperationException;
            }
            analysisException = super.classifyException(message, e);
        }
        return analysisException;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PostgresDialect$.class);
    }

    private PostgresDialect$() {
    }
}

