/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.AnsiTypeCoercion$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.TransformExpression;
import org.apache.spark.sql.catalyst.expressions.V2ExpressionUtils$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.RebalancePartitions;
import org.apache.spark.sql.catalyst.plans.logical.RepartitionByExpression;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.connector.catalog.FunctionCatalog;
import org.apache.spark.sql.connector.catalog.functions.BoundFunction;
import org.apache.spark.sql.connector.catalog.functions.ScalarFunction;
import org.apache.spark.sql.connector.distributions.ClusteredDistribution;
import org.apache.spark.sql.connector.distributions.Distribution;
import org.apache.spark.sql.connector.distributions.OrderedDistribution;
import org.apache.spark.sql.connector.distributions.UnspecifiedDistribution;
import org.apache.spark.sql.connector.write.RequiresDistributionAndOrdering;
import org.apache.spark.sql.connector.write.Write;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.v2.DistributionAndOrderingUtils$TypeCoercionExecutor$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class DistributionAndOrderingUtils$ {
    public static final DistributionAndOrderingUtils$ MODULE$ = new DistributionAndOrderingUtils$();

    public LogicalPlan prepareQuery(Write write, LogicalPlan query, Option<FunctionCatalog> funCatalogOpt) {
        LogicalPlan logicalPlan2;
        Write write2 = write;
        if (write2 instanceof RequiresDistributionAndOrdering) {
            Object object;
            Seq seq;
            RequiresDistributionAndOrdering requiresDistributionAndOrdering = (RequiresDistributionAndOrdering)write2;
            int numPartitions = requiresDistributionAndOrdering.requiredNumPartitions();
            Distribution distribution = requiresDistributionAndOrdering.requiredDistribution();
            if (distribution instanceof OrderedDistribution) {
                OrderedDistribution orderedDistribution = (OrderedDistribution)distribution;
                seq = (Seq)V2ExpressionUtils$.MODULE$.toCatalystOrdering(orderedDistribution.ordering(), query, funCatalogOpt).map((Function1 & Serializable)e -> (SortOrder)MODULE$.resolveTransformExpression((Expression)e));
            } else if (distribution instanceof ClusteredDistribution) {
                ClusteredDistribution clusteredDistribution = (ClusteredDistribution)distribution;
                seq = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])clusteredDistribution.clustering()), (Function1 & Serializable)e -> V2ExpressionUtils$.MODULE$.toCatalyst(e, query, funCatalogOpt), ClassTag$.MODULE$.apply(Expression.class))), (Function1 & Serializable)e -> MODULE$.resolveTransformExpression((Expression)e), ClassTag$.MODULE$.apply(Expression.class))));
            } else if (distribution instanceof UnspecifiedDistribution) {
                seq = (Seq)package$.MODULE$.Seq().empty();
            } else {
                throw new MatchError((Object)distribution);
            }
            Seq distribution2 = seq;
            if (distribution2.nonEmpty()) {
                None$ optNumPartitions;
                Object object2 = optNumPartitions = numPartitions > 0 ? new Some((Object)BoxesRunTime.boxToInteger((int)numPartitions)) : None$.MODULE$;
                object = requiresDistributionAndOrdering.distributionStrictlyRequired() ? new RepartitionByExpression(distribution2, query, (Option)optNumPartitions) : new RebalancePartitions(distribution2, query, (Option)optNumPartitions);
            } else {
                if (numPartitions > 0) {
                    throw QueryCompilationErrors$.MODULE$.numberOfPartitionsNotAllowedWithUnspecifiedDistributionError();
                }
                object = query;
            }
            LogicalPlan queryWithDistribution = object;
            Seq ordering2 = V2ExpressionUtils$.MODULE$.toCatalystOrdering(requiresDistributionAndOrdering.requiredOrdering(), query, funCatalogOpt);
            LogicalPlan queryWithDistributionAndOrdering = ordering2.nonEmpty() ? new Sort((Seq)ordering2.map((Function1 & Serializable)e -> (SortOrder)MODULE$.resolveTransformExpression((Expression)e)), false, queryWithDistribution) : queryWithDistribution;
            logicalPlan2 = (LogicalPlan)DistributionAndOrderingUtils$TypeCoercionExecutor$.MODULE$.execute((TreeNode)queryWithDistributionAndOrdering);
        } else {
            logicalPlan2 = query;
        }
        return logicalPlan2;
    }

    private Expression resolveTransformExpression(Expression expr) {
        return (Expression)expr.transform((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                boolean bl = false;
                TransformExpression transformExpression = null;
                A1 A1 = x1;
                if (A1 instanceof TransformExpression) {
                    bl = true;
                    transformExpression = (TransformExpression)A1;
                    BoundFunction scalarFunc = transformExpression.function();
                    Seq arguments = transformExpression.children();
                    Option option = transformExpression.numBucketsOpt();
                    if (scalarFunc instanceof ScalarFunction) {
                        ScalarFunction scalarFunction = (ScalarFunction)scalarFunc;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            int numBuckets = BoxesRunTime.unboxToInt((Object)some.value());
                            object = V2ExpressionUtils$.MODULE$.resolveScalarFunction(scalarFunction, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)numBuckets))})).$plus$plus((IterableOnce)arguments));
                            return (B1)object;
                        }
                    }
                }
                if (bl) {
                    BoundFunction scalarFunc = transformExpression.function();
                    Seq arguments = transformExpression.children();
                    Option option = transformExpression.numBucketsOpt();
                    if (scalarFunc instanceof ScalarFunction) {
                        ScalarFunction scalarFunction = (ScalarFunction)scalarFunc;
                        if (None$.MODULE$.equals(option)) {
                            object = V2ExpressionUtils$.MODULE$.resolveScalarFunction(scalarFunction, arguments);
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Expression x1) {
                boolean bl = false;
                TransformExpression transformExpression = null;
                Expression expression = x1;
                if (expression instanceof TransformExpression) {
                    bl = true;
                    transformExpression = (TransformExpression)expression;
                    BoundFunction scalarFunc = transformExpression.function();
                    Option option = transformExpression.numBucketsOpt();
                    if (scalarFunc instanceof ScalarFunction && option instanceof Some) {
                        return true;
                    }
                }
                if (!bl) return false;
                BoundFunction scalarFunc = transformExpression.function();
                Option option = transformExpression.numBucketsOpt();
                if (!(scalarFunc instanceof ScalarFunction)) return false;
                if (!None$.MODULE$.equals(option)) return false;
                return true;
            }
        });
    }

    public List<Rule<LogicalPlan>> org$apache$spark$sql$execution$datasources$v2$DistributionAndOrderingUtils$$typeCoercionRules() {
        return V2ExpressionUtils$.MODULE$.conf().ansiEnabled() ? AnsiTypeCoercion$.MODULE$.typeCoercionRules() : TypeCoercion$.MODULE$.typeCoercionRules();
    }

    private DistributionAndOrderingUtils$() {
    }
}

