/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLInsertTestSuite$;
import org.apache.spark.sql.catalyst.expressions.Hex$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000554q!\u0003\u0006\u0011\u0002\u0007\u00051\u0003C\u0003\u001f\u0001\u0011\u0005q\u0004C\u0003'\u0001\u0019\u0005q\u0005C\u00034\u0001\u0011EA\u0007C\u0004G\u0001E\u0005I\u0011C$\t\u000bI\u0003A\u0011C*\t\u000f\u0019\u0004\u0011\u0013!C\t\u000f\"9q\rAI\u0001\n#9\u0005\"\u00025\u0001\t#I'AE*R\u0019&s7/\u001a:u)\u0016\u001cHoU;ji\u0016T!a\u0003\u0007\u0002\u0007M\fHN\u0003\u0002\u000e\u001d\u0005)1\u000f]1sW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u000b\u0019!\t)b#D\u0001\u000b\u0013\t9\"BA\u0005Rk\u0016\u0014\u0018\u0010V3tiB\u0011\u0011\u0004H\u0007\u00025)\u00111DC\u0001\u0005i\u0016\u001cH/\u0003\u0002\u001e5\ta1+\u0015'UKN$X\u000b^5mg\u00061A%\u001b8ji\u0012\"\u0012\u0001\t\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0005+:LG/\u0001\u0004g_Jl\u0017\r^\u000b\u0002QA\u0011\u0011\u0006\r\b\u0003U9\u0002\"a\u000b\u0012\u000e\u00031R!!\f\n\u0002\rq\u0012xn\u001c;?\u0013\ty#%\u0001\u0004Qe\u0016$WMZ\u0005\u0003cI\u0012aa\u0015;sS:<'BA\u0018#\u0003-\u0019'/Z1uKR\u000b'\r\\3\u0015\u000b\u0001*tG\u0011#\t\u000bY\u001a\u0001\u0019\u0001\u0015\u0002\u000bQ\f'\r\\3\t\u000ba\u001a\u0001\u0019A\u001d\u0002\t\r|Gn\u001d\t\u0004u}BcBA\u001e>\u001d\tYC(C\u0001$\u0013\tq$%A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0001\u000b%aA*fc*\u0011aH\t\u0005\u0006\u0007\u000e\u0001\r!O\u0001\tG>dG+\u001f9fg\"9Qi\u0001I\u0001\u0002\u0004I\u0014\u0001\u00039beR\u001cu\u000e\\:\u0002+\r\u0014X-\u0019;f)\u0006\u0014G.\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\t\u0001J\u000b\u0002:\u0013.\n!\n\u0005\u0002L!6\tAJ\u0003\u0002N\u001d\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003\u001f\n\n!\"\u00198o_R\fG/[8o\u0013\t\tFJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pG\u0016\u001c8/\u00138tKJ$HC\u0002\u0011U-z{\u0016\rC\u0003V\u000b\u0001\u0007\u0001&A\u0005uC\ndWMT1nK\")q+\u0002a\u00011\u0006)\u0011N\u001c9viB\u0011\u0011l\u0017\b\u0003+iK!A\u0010\u0006\n\u0005qk&!\u0003#bi\u00064%/Y7f\u0015\tq$\u0002C\u00049\u000bA\u0005\t\u0019A\u001d\t\u000f\u0001,\u0001\u0013!a\u0001s\u0005q\u0001/\u0019:uSRLwN\\#yaJ\u001c\b\"\u00022\u0006\u0001\u0004\u0019\u0017!C8wKJ<(/\u001b;f!\t\tC-\u0003\u0002fE\t9!i\\8mK\u0006t\u0017a\u00069s_\u000e,7o]%og\u0016\u0014H\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003]\u0001(o\\2fgNLen]3si\u0012\"WMZ1vYR$C'A\u0006wKJLg-\u001f+bE2,Gc\u0001\u0011kW\")Q\u000b\u0003a\u0001Q!)A\u000e\u0003a\u00011\u0006AQ\r\u001f9fGR,G\r")
public interface SQLInsertTestSuite
extends SQLTestUtils {
    public String format();

    public static /* synthetic */ void createTable$(SQLInsertTestSuite $this, String table, Seq cols, Seq colTypes, Seq partCols) {
        $this.createTable(table, (Seq<String>)cols, (Seq<String>)colTypes, (Seq<String>)partCols);
    }

    default public void createTable(String table, Seq<String> cols, Seq<String> colTypes, Seq<String> partCols) {
        String values = ((IterableOnceOps)((IterableOps)cols.zip(colTypes)).map((Function1 & Serializable)tuple -> new StringBuilder(1).append((String)tuple._1()).append(" ").append(tuple._2()).toString())).mkString("(", ", ", ")");
        String partitionSpec = partCols.nonEmpty() ? partCols.mkString("PARTITIONED BY (", ",", ")") : "";
        this.sql().apply((Object)new StringBuilder(21).append("CREATE TABLE ").append(table).append(values).append(" USING ").append(this.format()).append(" ").append(partitionSpec).toString());
    }

    public static /* synthetic */ Seq createTable$default$4$(SQLInsertTestSuite $this) {
        return $this.createTable$default$4();
    }

    default public Seq<String> createTable$default$4() {
        return package$.MODULE$.Nil();
    }

    public static /* synthetic */ void processInsert$(SQLInsertTestSuite $this, String tableName, Dataset input, Seq cols, Seq partitionExprs, boolean overwrite) {
        $this.processInsert(tableName, (Dataset<Row>)input, (Seq<String>)cols, (Seq<String>)partitionExprs, overwrite);
    }

    default public void processInsert(String tableName, Dataset<Row> input, Seq<String> cols, Seq<String> partitionExprs, boolean overwrite) {
        String tmpView = "tmp_view";
        String columnList = cols.nonEmpty() ? cols.mkString("(", ",", ")") : "";
        String partitionList = partitionExprs.nonEmpty() ? partitionExprs.mkString("PARTITION (", ",", ")") : "";
        this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tmpView}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            input.createOrReplaceTempView(tmpView);
            String overwriteStr = overwrite ? "OVERWRITE" : "INTO";
            this.sql().apply((Object)new StringBuilder(31).append("INSERT ").append(overwriteStr).append(" TABLE ").append(tableName).append(" ").append(partitionList).append(" ").append(columnList).append(" SELECT * FROM ").append(tmpView).toString());
        });
    }

    public static /* synthetic */ Seq processInsert$default$3$(SQLInsertTestSuite $this) {
        return $this.processInsert$default$3();
    }

    default public Seq<String> processInsert$default$3() {
        return package$.MODULE$.Nil();
    }

    public static /* synthetic */ Seq processInsert$default$4$(SQLInsertTestSuite $this) {
        return $this.processInsert$default$4();
    }

    default public Seq<String> processInsert$default$4() {
        return package$.MODULE$.Nil();
    }

    public static /* synthetic */ void verifyTable$(SQLInsertTestSuite $this, String tableName, Dataset expected) {
        $this.verifyTable(tableName, (Dataset<Row>)expected);
    }

    default public void verifyTable(String tableName, Dataset<Row> expected) {
        ((QueryTest)((Object)this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().table(tableName), expected);
    }

    public static /* synthetic */ void $anonfun$$init$$3(SQLInsertTestSuite $this, Dataset df$1, Seq cols$1, boolean m) {
        String x$1 = "t1";
        Dataset x$2 = df$1;
        Seq x$3 = cols$1;
        boolean x$4 = m;
        Seq<String> x$5 = $this.processInsert$default$4();
        $this.processInsert("t1", (Dataset<Row>)x$2, (Seq<String>)x$3, x$5, x$4);
        $this.verifyTable("t1", (Dataset<Row>)df$1);
    }

    public static /* synthetic */ void $anonfun$$init$$6(SQLInsertTestSuite $this, Dataset df$2, Seq cols$2, boolean m) {
        String x$6 = "t1";
        Dataset x$7 = df$2;
        Seq x$8 = cols$2;
        boolean x$9 = m;
        Seq<String> x$10 = $this.processInsert$default$4();
        $this.processInsert("t1", (Dataset<Row>)x$7, (Seq<String>)x$8, x$10, x$9);
        $this.verifyTable("t1", (Dataset<Row>)df$2);
    }

    public static /* synthetic */ void $anonfun$$init$$8(SQLInsertTestSuite $this, Dataset df$2, Seq cols$2, boolean m) {
        $this.processInsert("t1", (Dataset<Row>)df$2.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2"})), (Seq<String>)((Seq)cols$2.take(2)), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c3=3", "c4=4"}))), m);
        $this.verifyTable("t1", (Dataset<Row>)df$2);
    }

    public static /* synthetic */ boolean $anonfun$$init$$11(String x$1) {
        String string = x$1;
        String string2 = "c3";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static /* synthetic */ void $anonfun$$init$$10(SQLInsertTestSuite $this, Dataset df$2, Seq cols$2, boolean m) {
        $this.processInsert("t1", (Dataset<Row>)df$2.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c4"})), (Seq<String>)((Seq)cols$2.filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SQLInsertTestSuite.$anonfun$$init$$11(x$1)))), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c3=3", "c4"}))), m);
        $this.verifyTable("t1", (Dataset<Row>)df$2);
    }

    public static /* synthetic */ void $anonfun$$init$$14(SQLInsertTestSuite $this, Dataset df$3, Seq cols$3, boolean m) {
        String x$11 = "t1";
        Dataset x$12 = df$3;
        Seq x$13 = (Seq)cols$3.reverse();
        boolean x$14 = m;
        Seq<String> x$15 = $this.processInsert$default$4();
        $this.processInsert("t1", (Dataset<Row>)x$12, (Seq<String>)x$13, x$15, x$14);
        $this.verifyTable("t1", (Dataset<Row>)df$3.selectExpr((Seq)cols$3.reverse()));
    }

    public static /* synthetic */ void $anonfun$$init$$17(SQLInsertTestSuite $this, Dataset df$4, Seq cols$4, boolean m) {
        String x$16 = "t1";
        Dataset x$17 = df$4;
        Seq x$18 = (Seq)cols$4.reverse();
        boolean x$19 = m;
        Seq<String> x$20 = $this.processInsert$default$4();
        $this.processInsert("t1", (Dataset<Row>)x$17, (Seq<String>)x$18, x$20, x$19);
        $this.verifyTable("t1", (Dataset<Row>)df$4.selectExpr((Seq)cols$4.reverse()));
    }

    public static /* synthetic */ void $anonfun$$init$$19(SQLInsertTestSuite $this, Dataset df$4, Seq cols$4, boolean m) {
        $this.processInsert("t1", (Dataset<Row>)df$4.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2"})), (Seq<String>)((Seq)((SeqOps)cols$4.take(2)).reverse()), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c3=3", "c4=4"}))), m);
        $this.verifyTable("t1", (Dataset<Row>)df$4.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c2", "c1", "c3", "c4"})));
    }

    public static /* synthetic */ void $anonfun$$init$$21(SQLInsertTestSuite $this, Dataset df$4, boolean m) {
        $this.processInsert("t1", (Dataset<Row>)df$4.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c4"})), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c4", "c2", "c1"}))), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c3=3", "c4"}))), m);
        $this.verifyTable("t1", (Dataset<Row>)df$4.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c4", "c2", "c3", "c1"})));
    }

    private void test$1(Seq msgs$1) {
        this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Bool bool;
            Bool bool2;
            Seq cols = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c3"}));
            this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "long", "string"}))), this.createTable$default$4());
            AnalysisException e1 = (AnalysisException)((Object)((Object)((Assertions)this).intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"INSERT INTO t1 (c1, c2) values(1, 2, 3)"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190))));
            String $org_scalatest_assert_macro_left = e1.getMessage();
            String $org_scalatest_assert_macro_right = (String)msgs$1.apply(0);
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                bool2 = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
            } else {
                String $org_scalatest_assert_macro_left3 = e1.getMessage();
                String $org_scalatest_assert_macro_right2 = (String)msgs$1.apply(1);
                bool2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "||", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$bar$bar((Function0 & Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
            AnalysisException e2 = (AnalysisException)((Object)((Object)((Assertions)this).intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"INSERT INTO t1 (c1, c2, c3) values(1, 2)"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192))));
            String $org_scalatest_assert_macro_left4 = e2.getMessage();
            String $org_scalatest_assert_macro_right4 = (String)msgs$1.apply(0);
            Bool $org_scalatest_assert_macro_left5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left5.value()) {
                bool = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
            } else {
                String $org_scalatest_assert_macro_left6 = e2.getMessage();
                String $org_scalatest_assert_macro_right5 = (String)msgs$1.apply(1);
                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right6 = bool;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "||", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left5.$bar$bar((Function0 & Serializable)() -> $org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        });
    }

    private static boolean shouldThrowException$1(Enumeration.Value policy) {
        boolean bl;
        boolean bl2;
        Enumeration.Value value = policy;
        Enumeration.Value value2 = SQLConf.StoreAssignmentPolicy$.MODULE$.ANSI();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl2 = true;
        } else {
            Enumeration.Value value4 = SQLConf.StoreAssignmentPolicy$.MODULE$.STRICT();
            Enumeration.Value value5 = value;
            bl2 = !(value4 != null ? !value4.equals(value5) : value5 != null);
        }
        if (bl2) {
            bl = true;
        } else {
            Enumeration.Value value6 = SQLConf.StoreAssignmentPolicy$.MODULE$.LEGACY();
            Enumeration.Value value7 = value;
            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                bl = false;
            } else {
                throw new MatchError((Object)value);
            }
        }
        return bl;
    }

    public static /* synthetic */ void $anonfun$$init$$75(SQLInsertTestSuite $this, String query) {
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)query), (Seq<Row>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToInteger((int)10), "08"}))}))));
    }

    public static void $init$(SQLInsertTestSuite $this) {
        $this.test("insert with column list - follow table output order", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(SQLInsertTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_SQLInsertTestSuite$$typecreator10$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_SQLInsertTestSuite$$typecreator10$1(SQLInsertTestSuite $outer) {
                }
            }
            Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"3")})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_SQLInsertTestSuite$$typecreator10$1(null)))).toDF();
            Seq cols = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c3"}));
            $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "long", "string"}))), $this.createTable$default$4());
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)m -> {
                SQLInsertTestSuite.$anonfun$$init$$3($this, df, cols, BoxesRunTime.unboxToBoolean((Object)m));
                return BoxedUnit.UNIT;
            });
        }), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        $this.test("insert with column list - follow table output order + partitioned table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Seq cols = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c3", "c4"}));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(SQLInsertTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_SQLInsertTestSuite$$typecreator20$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
                }

                public Org_apache_spark_sql_SQLInsertTestSuite$$typecreator20$1(SQLInsertTestSuite $outer) {
                }
            }
            Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)4))})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_SQLInsertTestSuite$$typecreator20$1(null)))).toDF(cols);
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "int", "int", "int"}))), (Seq<String>)((Seq)cols.takeRight(2)));
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)m -> {
                    SQLInsertTestSuite.$anonfun$$init$$6($this, df, cols, BoxesRunTime.unboxToBoolean((Object)m));
                    return BoxedUnit.UNIT;
                });
            });
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "int", "int", "int"}))), (Seq<String>)((Seq)cols.takeRight(2)));
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)m -> {
                    SQLInsertTestSuite.$anonfun$$init$$8($this, df, cols, BoxesRunTime.unboxToBoolean((Object)m));
                    return BoxedUnit.UNIT;
                });
            });
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "int", "int", "int"}))), (Seq<String>)((Seq)cols.takeRight(2)));
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)m -> {
                    SQLInsertTestSuite.$anonfun$$init$$10($this, df, cols, BoxesRunTime.unboxToBoolean((Object)m));
                    return BoxedUnit.UNIT;
                });
            });
        }, new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        $this.test("insert with column list - table output reorder", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Seq cols = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c3"}));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(SQLInsertTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_SQLInsertTestSuite$$typecreator30$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_SQLInsertTestSuite$$typecreator30$1(SQLInsertTestSuite $outer) {
                }
            }
            Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3))})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_SQLInsertTestSuite$$typecreator30$1(null)))).toDF(cols);
            $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "int", "int"}))), $this.createTable$default$4());
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)m -> {
                SQLInsertTestSuite.$anonfun$$init$$14($this, df, cols, BoxesRunTime.unboxToBoolean((Object)m));
                return BoxedUnit.UNIT;
            });
        }), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        $this.test("insert with column list - table output reorder + partitioned table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Seq cols = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c3", "c4"}));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(SQLInsertTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_SQLInsertTestSuite$$typecreator40$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
                }

                public Org_apache_spark_sql_SQLInsertTestSuite$$typecreator40$1(SQLInsertTestSuite $outer) {
                }
            }
            Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)4))})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_SQLInsertTestSuite$$typecreator40$1(null)))).toDF(cols);
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "int", "int", "int"}))), (Seq<String>)((Seq)cols.takeRight(2)));
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)m -> {
                    SQLInsertTestSuite.$anonfun$$init$$17($this, df, cols, BoxesRunTime.unboxToBoolean((Object)m));
                    return BoxedUnit.UNIT;
                });
            });
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "int", "int", "int"}))), (Seq<String>)((Seq)cols.takeRight(2)));
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)m -> {
                    SQLInsertTestSuite.$anonfun$$init$$19($this, df, cols, BoxesRunTime.unboxToBoolean((Object)m));
                    return BoxedUnit.UNIT;
                });
            });
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "int", "int", "int"}))), (Seq<String>)((Seq)cols.takeRight(2)));
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)m -> {
                    SQLInsertTestSuite.$anonfun$$init$$21($this, df, BoxesRunTime.unboxToBoolean((Object)m));
                    return BoxedUnit.UNIT;
                });
            });
        }, new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
        $this.test("insert with column list - duplicated columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Seq cols = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c3"}));
            $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "long", "string"}))), $this.createTable$default$4());
            AnalysisException x$21 = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t1 (c1, c2, c2) values(1, 2, 3)"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160)))));
            String x$22 = "COLUMN_ALREADY_EXISTS";
            Map x$23 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)"`c2`")}));
            Option x$24 = ((SparkFunSuite)$this).checkError$default$3();
            boolean x$25 = ((SparkFunSuite)$this).checkError$default$5();
            QueryContext[] x$26 = ((SparkFunSuite)$this).checkError$default$6();
            ((SparkFunSuite)$this).checkError((SparkThrowable)x$21, "COLUMN_ALREADY_EXISTS", x$24, x$23, x$25, x$26);
        }), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        $this.test("insert with column list - invalid columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Seq cols = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c3"}));
            $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "long", "string"}))), $this.createTable$default$4());
            ((SparkFunSuite)$this).checkError((SparkThrowable)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t1 (c1, c2, c4) values(1, 2, 3)"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173)), "UNRESOLVED_COLUMN.WITH_SUGGESTION", (Option)None$.MODULE$, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)"`c4`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"proposal"), (Object)"`c1`, `c2`, `c3`")})), (QueryContext)((SparkFunSuite)$this).ExpectedContext().apply("INSERT INTO t1 (c1, c2, c4)", 0, 26));
        }), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        $this.test("insert with column list - mismatched column list size", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Seq msgs = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write to table due to mismatched user specified column size", "expected 3 columns but found"}));
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_DEFAULT_COLUMNS().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.test$1(msgs));
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_DEFAULT_COLUMNS().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.test$1(msgs));
        }, new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        $this.test("insert with column list - missing columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String v2Msg = "Cannot write incompatible data to table 'testcat.t1'";
            Seq cols = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c3", "c4"}));
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Bool bool;
                Bool bool2;
                Bool bool3;
                $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().fill(4, (Function0 & Serializable)() -> "int")), $this.createTable$default$4());
                AnalysisException e1 = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t1 values(1)"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210)))));
                String $org_scalatest_assert_macro_left = e1.getMessage();
                String $org_scalatest_assert_macro_right = "target table has 4 column(s) but the inserted data has 1";
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left2.value()) {
                    bool3 = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
                } else {
                    String $org_scalatest_assert_macro_left3 = e1.getMessage();
                    String $org_scalatest_assert_macro_right2 = "expected 4 columns but found 1";
                    bool3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right3 = bool3;
                Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "||", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$bar$bar((Function0 & Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left4.value()) {
                    bool2 = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
                } else {
                    String $org_scalatest_assert_macro_left5 = e1.getMessage();
                    String $org_scalatest_assert_macro_right4 = "not enough data columns";
                    bool2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right5 = bool2;
                Bool $org_scalatest_assert_macro_left6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "||", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left4.$bar$bar((Function0 & Serializable)() -> $org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left6.value()) {
                    bool = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
                } else {
                    String $org_scalatest_assert_macro_left7 = e1.getMessage();
                    String $org_scalatest_assert_macro_right6 = v2Msg;
                    bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left7.contains($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right7 = bool;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "||", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left6.$bar$bar((Function0 & Serializable)() -> $org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
            });
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Bool bool;
                Bool bool2;
                $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().fill(4, (Function0 & Serializable)() -> "int")), (Seq<String>)((Seq)cols.takeRight(2)));
                AnalysisException e1 = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t1 partition(c3=3, c4=4) values(1)"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219)))));
                String $org_scalatest_assert_macro_left = e1.getMessage();
                String $org_scalatest_assert_macro_right = "target table has 4 column(s) but the inserted data has 3";
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left2.value()) {
                    bool2 = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
                } else {
                    String $org_scalatest_assert_macro_left3 = e1.getMessage();
                    String $org_scalatest_assert_macro_right2 = "not enough data columns";
                    bool2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right3 = bool2;
                Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "||", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$bar$bar((Function0 & Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left4.value()) {
                    bool = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
                } else {
                    String $org_scalatest_assert_macro_left5 = e1.getMessage();
                    String $org_scalatest_assert_macro_right4 = v2Msg;
                    bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right5 = bool;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "||", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left4.$bar$bar((Function0 & Serializable)() -> $org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
            });
        }, new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        $this.test("SPARK-34223: static partition with null raise NPE", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)"CREATE TABLE t(i STRING, c string) USING PARQUET PARTITIONED BY (c)");
            $this.sql().apply((Object)"INSERT OVERWRITE t PARTITION (c=null) VALUES ('1')");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
        }), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
        $this.test("SPARK-33474: Support typed literals as partition spec values", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            String e;
            String binaryStr = "Spark SQL";
            String binaryHexStr = Hex$.MODULE$.hex(UTF8String.fromString((String)binaryStr).getBytes()).toString();
            $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          | CREATE TABLE t1(name STRING, part1 DATE, part2 TIMESTAMP, part3 BINARY,\n          |  part4 STRING, part5 STRING, part6 STRING, part7 STRING)\n          | USING PARQUET PARTITIONED BY (part1, part2, part3, part4, part5, part6, part7)\n         ")));
            $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(342).append("\n           | INSERT OVERWRITE t1 PARTITION(\n           | part1 = date'2019-01-01',\n           | part2 = timestamp'2019-01-01 11:11:11',\n           | part3 = X'").append(binaryHexStr).append("',\n           | part4 = 'p1',\n           | part5 = date'2019-01-01',\n           | part6 = timestamp'2019-01-01 11:11:11',\n           | part7 = X'").append(binaryHexStr).append("'\n           | ) VALUES('a')\n        ").toString())));
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          | SELECT\n          |   name,\n          |   CAST(part1 AS STRING),\n          |   CAST(part2 as STRING),\n          |   CAST(part3 as STRING),\n          |   part4,\n          |   part5,\n          |   part6,\n          |   part7\n          | FROM t1\n        "))), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a", "2019-01-01", "2019-01-01 11:11:11", "Spark SQL", "p1", "2019-01-01", "2019-01-01 11:11:11", "Spark SQL"})));
            String $org_scalatest_assert_macro_left = e = ((AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"CREATE TABLE t2(name STRING, part INTERVAL) USING PARQUET PARTITIONED BY (part)"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275)))))).getMessage();
            String $org_scalatest_assert_macro_right = "Cannot use interval";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        }), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
        $this.test("SPARK-34556: checking duplicate static partition columns should respect case sensitive conf", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)"CREATE TABLE t(i STRING, c string) USING PARQUET PARTITIONED BY (c)");
                AnalysisException e = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT OVERWRITE t PARTITION (c='2', C='3') VALUES (1)"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286)))));
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "Found duplicate keys `c`";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
            });
            if (!$this.format().startsWith("hive")) {
                $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    $this.sql().apply((Object)"CREATE TABLE t(i int, c string, C string) USING PARQUET PARTITIONED BY (c, C)");
                    $this.sql().apply((Object)"INSERT OVERWRITE t PARTITION (c='2', C='3') VALUES (1)");
                    ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", "3"})));
                }));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
        $this.test("SPARK-30844: static partition should also follow StoreAssignmentPolicy", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String string = $this.format();
            String string2 = "foo";
            Enumeration.ValueSet testingPolicies = !(string != null ? !string.equals(string2) : string2 != null) ? (Iterable)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{SQLConf.StoreAssignmentPolicy$.MODULE$.ANSI(), SQLConf.StoreAssignmentPolicy$.MODULE$.STRICT()})) : SQLConf.StoreAssignmentPolicy$.MODULE$.values();
            testingPolicies.foreach((Function1 & Serializable)policy -> {
                $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STORE_ASSIGNMENT_POLICY().key()), (Object)policy.toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    $this.sql().apply((Object)"create table t(a int, b string) using parquet partitioned by (a)");
                    if (SQLInsertTestSuite.shouldThrowException$1(policy)) {
                        String errorMsg;
                        String $org_scalatest_assert_macro_left = errorMsg = ((Throwable)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"insert into t partition(a='ansi') values('ansi')"), ClassTag$.MODULE$.apply(NumberFormatException.class), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324))).getMessage();
                        String $org_scalatest_assert_macro_right = "The value 'ansi' of the type \"STRING\" cannot be cast to \"INT\"";
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
                    } else {
                        $this.sql().apply((Object)"insert into t partition(a='ansi') values('ansi')");
                        Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"ansi", null}));
                        ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"select * from t"), (Seq<Row>)package$.MODULE$.Nil().$colon$colon((Object)row));
                    }
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
        $this.test("SPARK-38228: legacy store assignment should not fail on error under ANSI mode", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            String string = $this.format();
            String string2 = "foo";
            if (string == null ? string2 != null : !string.equals(string2)) {
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)ansiEnabled -> {
                    $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STORE_ASSIGNMENT_POLICY().key()), (Object)SQLConf.StoreAssignmentPolicy$.MODULE$.LEGACY().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)ansiEnabled)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                        $this.sql().apply((Object)"create table t(a int) using parquet");
                        $this.sql().apply((Object)"insert into t values('ansi')");
                        ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})));
                    }));
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
        $this.test("SPARK-41982: treat the partition field as string literal when keepPartitionSpecAsStringLiteral is enabled", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_KEEP_PARTITION_SPEC_AS_STRING_LITERAL().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)"create table t(i string, j int) using orc partitioned by (dt string)");
                $this.sql().apply((Object)"insert into t partition(dt=08) values('a', 10)");
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select * from t where dt='08'", "select * from t where dt=08"})).foreach((Function1 & Serializable)query -> {
                    SQLInsertTestSuite.$anonfun$$init$$75($this, query);
                    return BoxedUnit.UNIT;
                });
                AnalysisException e = (AnalysisException)((Object)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"alter table t drop partition(dt='8')"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367))))));
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "PARTITIONS_NOT_FOUND";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
            }));
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_KEEP_PARTITION_SPEC_AS_STRING_LITERAL().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)"create table t(i string, j int) using orc partitioned by (dt string)");
                $this.sql().apply((Object)"insert into t partition(dt=08) values('a', 10)");
                ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"select * from t where dt='08'"), (Dataset<Row>)((Dataset)$this.sql().apply((Object)"select * from t where dt='07'")));
                ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"select * from t where dt=08"), (Seq<Row>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToInteger((int)10), "8"}))}))));
                AnalysisException e = (AnalysisException)((Object)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"alter table t drop partition(dt='08')"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378))))));
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "PARTITIONS_NOT_FOUND";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
            }));
        }, new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
    }
}

