/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.connector.DatasourceV2SQLBase;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.SimpleScanSource;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEquals;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000552qa\u0001\u0003\u0011\u0002\u0007\u0005q\u0002C\u0003\u0019\u0001\u0011\u0005\u0011\u0004C\u0004!\u0001\t\u0007i\u0011C\u0011\u0003\u001f\u0011+G.\u001a;f\rJ|W\u000eV3tiNT!!\u0002\u0004\u0002\u0013\r|gN\\3di>\u0014(BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011c\u0001\u0001\u0011)A\u0011\u0011CE\u0007\u0002\r%\u00111C\u0002\u0002\n#V,'/\u001f+fgR\u0004\"!\u0006\f\u000e\u0003\u0011I!a\u0006\u0003\u0003'\u0011\u000bG/Y:pkJ\u001cWM\u0016\u001aT#2\u0013\u0015m]3\u0002\r\u0011Jg.\u001b;%)\u0005Q\u0002CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"\u0001B+oSR\f1cY1uC2|w-\u00118e\u001d\u0006lWm\u001d9bG\u0016,\u0012A\t\t\u0003G)r!\u0001\n\u0015\u0011\u0005\u0015bR\"\u0001\u0014\u000b\u0005\u001dr\u0011A\u0002\u001fs_>$h(\u0003\u0002*9\u00051\u0001K]3eK\u001aL!a\u000b\u0017\u0003\rM#(/\u001b8h\u0015\tIC\u0004")
public interface DeleteFromTests
extends DatasourceV2SQLBase {
    public String catalogAndNamespace();

    public static void $init$(DeleteFromTests $this) {
        $this.test("DeleteFrom with v2 filtering: basic - delete all", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = new StringBuilder(3).append($this.catalogAndNamespace()).append("tbl").toString();
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id bigint, data string, p int) USING foo PARTITIONED BY (id, p)").toString());
                $this.sql().apply((Object)new StringBuilder(60).append("INSERT INTO ").append(t).append(" VALUES (2L, 'a', 2), (2L, 'b', 3), (3L, 'c', 3)").toString());
                $this.sql().apply((Object)new StringBuilder(12).append("DELETE FROM ").append(t).toString());
                ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table(t), (Seq<Row>)((Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)));
            });
        }, new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        $this.test("DeleteFrom with v2 filtering: basic - delete with where clause", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = new StringBuilder(3).append($this.catalogAndNamespace()).append("tbl").toString();
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id bigint, data string, p int) USING foo PARTITIONED BY (id, p)").toString());
                $this.sql().apply((Object)new StringBuilder(60).append("INSERT INTO ").append(t).append(" VALUES (2L, 'a', 2), (2L, 'b', 3), (3L, 'c', 3)").toString());
                $this.sql().apply((Object)new StringBuilder(25).append("DELETE FROM ").append(t).append(" WHERE id = 2").toString());
                ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table(t), (Seq<Row>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c", BoxesRunTime.boxToInteger((int)3)}))}))));
            });
        }, new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        $this.test("DeleteFrom with v2 filtering: delete from aliased target table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = new StringBuilder(3).append($this.catalogAndNamespace()).append("tbl").toString();
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id bigint, data string, p int) USING foo PARTITIONED BY (id, p)").toString());
                $this.sql().apply((Object)new StringBuilder(60).append("INSERT INTO ").append(t).append(" VALUES (2L, 'a', 2), (2L, 'b', 3), (3L, 'c', 3)").toString());
                $this.sql().apply((Object)new StringBuilder(36).append("DELETE FROM ").append(t).append(" AS tbl WHERE tbl.id = 2").toString());
                ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table(t), (Seq<Row>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c", BoxesRunTime.boxToInteger((int)3)}))}))));
            });
        }, new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        $this.test("DeleteFrom with v2 filtering: normalize attribute names", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = new StringBuilder(3).append($this.catalogAndNamespace()).append("tbl").toString();
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id bigint, data string, p int) USING foo PARTITIONED BY (id, p)").toString());
                $this.sql().apply((Object)new StringBuilder(60).append("INSERT INTO ").append(t).append(" VALUES (2L, 'a', 2), (2L, 'b', 3), (3L, 'c', 3)").toString());
                $this.sql().apply((Object)new StringBuilder(36).append("DELETE FROM ").append(t).append(" AS tbl WHERE tbl.ID = 2").toString());
                ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table(t), (Seq<Row>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c", BoxesRunTime.boxToInteger((int)3)}))}))));
            });
        }, new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        $this.test("DeleteFrom with v2 filtering: fail if has subquery", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = new StringBuilder(3).append($this.catalogAndNamespace()).append("tbl").toString();
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id bigint, data string, p int) USING foo PARTITIONED BY (id, p)").toString());
                $this.sql().apply((Object)new StringBuilder(60).append("INSERT INTO ").append(t).append(" VALUES (2L, 'a', 2), (2L, 'b', 3), (3L, 'c', 3)").toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(42).append("DELETE FROM ").append(t).append(" WHERE id IN (SELECT id FROM ").append(t).append(")").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79)))));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)BoxesRunTime.boxToLong((long)$this.spark().table(t).count()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
                String $org_scalatest_assert_macro_left2 = exc.getMessage();
                String $org_scalatest_assert_macro_right2 = "Delete by condition with subquery is not supported";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            });
        }, new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        $this.test("DeleteFrom with v2 filtering: delete with unsupported predicates", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = new StringBuilder(3).append($this.catalogAndNamespace()).append("tbl").toString();
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(55).append("CREATE TABLE ").append(t).append(" (id bigint, data string, p int) USING foo").toString());
                $this.sql().apply((Object)new StringBuilder(60).append("INSERT INTO ").append(t).append(" VALUES (2L, 'a', 2), (2L, 'b', 3), (3L, 'c', 3)").toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(35).append("DELETE FROM ").append(t).append(" WHERE id > 3 AND p > 3").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93)))));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)BoxesRunTime.boxToLong((long)$this.spark().table(t).count()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
                String $org_scalatest_assert_macro_left2 = exc.getMessage();
                String $org_scalatest_assert_macro_right2 = new StringBuilder(25).append("Cannot delete from table ").append(t).toString();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            });
        }, new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        $this.test("DeleteFrom: DELETE is only supported with v2 tables", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            String v1Table = "tbl";
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{v1Table}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(0).append(new StringBuilder(13).append("CREATE TABLE ").append(v1Table).toString()).append(new StringBuilder(29).append(" USING ").append(SimpleScanSource.class.getName()).append(" OPTIONS (from=0,to=1)").toString()).toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(24).append("DELETE FROM ").append(v1Table).append(" WHERE i = 2").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109)))));
                ((SparkFunSuite)$this).checkError((SparkThrowable)exc, "UNSUPPORTED_FEATURE.TABLE_OPERATION", "0A000", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"`spark_catalog`.`default`.`tbl`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)"DELETE")})));
            });
        }, new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        $this.test("SPARK-33652: DeleteFrom should refresh caches referencing the table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t = new StringBuilder(3).append($this.catalogAndNamespace()).append("tbl").toString();
            String view = "view";
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{view}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id bigint, data string, p int) USING foo PARTITIONED BY (id, p)").toString());
                $this.sql().apply((Object)new StringBuilder(60).append("INSERT INTO ").append(t).append(" VALUES (2L, 'a', 2), (2L, 'b', 3), (3L, 'c', 3)").toString());
                $this.sql().apply((Object)new StringBuilder(35).append("CACHE TABLE view AS SELECT id FROM ").append(t).toString());
                long $org_scalatest_assert_macro_left = $this.spark().table(view).count();
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
                $this.sql().apply((Object)new StringBuilder(25).append("DELETE FROM ").append(t).append(" WHERE id = 2").toString());
                long $org_scalatest_assert_macro_left2 = $this.spark().table(view).count();
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            }));
        }, new Position("DeleteFromTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
    }
}

