/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector;

import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.expressions.DynamicPruningExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.connector.DeleteFromTableSuiteBase;
import org.apache.spark.sql.connector.GroupBasedDeleteFromTableSuite$;
import org.apache.spark.sql.execution.InSubqueryExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.v2.BatchScanExec;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00113A!\u0002\u0004\u0001#!)a\u0003\u0001C\u0001/!)\u0011\u0004\u0001C\u00055!)\u0011\u0005\u0001C\u0005E!)A\u0007\u0001C\u0005k\tqrI]8va\n\u000b7/\u001a3EK2,G/\u001a$s_6$\u0016M\u00197f'VLG/\u001a\u0006\u0003\u000f!\t\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0005%Q\u0011aA:rY*\u00111\u0002D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0015\u001b\u00051\u0011BA\u000b\u0007\u0005a!U\r\\3uK\u001a\u0013x.\u001c+bE2,7+^5uK\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003a\u0001\"a\u0005\u0001\u0002A\rDWmY6EK2,G/\u001a*v]RLW.Z$s_V\u0004h)\u001b7uKJLgn\u001a\u000b\u00027A\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t!QK\\5u\u0003i)\u00070Z2vi\u0016$U\r\\3uK\u0006sGm\u00115fG.\u001c6-\u00198t)\u0011Y2\u0005\r\u001a\t\u000b\u0011\u001a\u0001\u0019A\u0013\u0002\u000bE,XM]=\u0011\u0005\u0019jcBA\u0014,!\tAS$D\u0001*\u0015\tQ\u0003#\u0001\u0004=e>|GOP\u0005\u0003Yu\ta\u0001\u0015:fI\u00164\u0017B\u0001\u00180\u0005\u0019\u0019FO]5oO*\u0011A&\b\u0005\u0006c\r\u0001\r!J\u0001\u0012aJLW.\u0019:z'\u000e\fgnU2iK6\f\u0007\"B\u001a\u0004\u0001\u0004)\u0013!F4s_V\u0004h)\u001b7uKJ\u001c6-\u00198TG\",W.Y\u0001\u0018G\",7m\u001b*fa2\f7-\u001a3QCJ$\u0018\u000e^5p]N$\"a\u0007\u001c\t\u000b]\"\u0001\u0019\u0001\u001d\u0002%\u0015D\b/Z2uK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\t\u0004sy\neB\u0001\u001e=\u001d\tA3(C\u0001\u001f\u0013\tiT$A\u0004qC\u000e\\\u0017mZ3\n\u0005}\u0002%aA*fc*\u0011Q(\b\t\u00039\tK!aQ\u000f\u0003\u0007\u0005s\u0017\u0010")
public class GroupBasedDeleteFromTableSuite
extends DeleteFromTableSuiteBase {
    private void checkDeleteRuntimeGroupFiltering() {
        this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"deleted_id"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("id INT, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"id\": 1, \"salary\": 300, \"dep\": 'hr' }\n          |{ \"id\": 2, \"salary\": 150, \"dep\": 'software' }\n          |{ \"id\": 3, \"salary\": 120, \"dep\": 'hr' }\n          |")));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(GroupBasedDeleteFromTableSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_GroupBasedDeleteFromTableSuite$$typecreator10$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_connector_GroupBasedDeleteFromTableSuite$$typecreator10$2(GroupBasedDeleteFromTableSuite $outer) {
                }
            }
            Dataset deletedIdDF = this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{new Some((Object)BoxesRunTime.boxToInteger((int)1)), None$.MODULE$})), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_GroupBasedDeleteFromTableSuite$$typecreator10$2(null)))).toDF();
            deletedIdDF.createOrReplaceTempView("deleted_id");
            this.executeDeleteAndCheckScans(new StringBuilder(51).append("DELETE FROM ").append(this.tableNameAsString()).append(" WHERE id IN (SELECT * FROM deleted_id)").toString(), "id INT, salary INT, dep STRING, _partition STRING", "id INT, dep STRING");
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)150), "software"}));
            Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)120), "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)package$.MODULE$.Nil().$colon$colon((Object)row2).$colon$colon((Object)row));
            this.checkReplacedPartitions((Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hr"}))));
        });
    }

    private void executeDeleteAndCheckScans(String query, String primaryScanSchema, String groupFilterScanSchema) {
        DynamicPruningExpression dynamicPruningExpression;
        Expression child;
        Expression expression;
        SeqOps seqOps;
        SparkPlan executedPlan = this.executeAndKeepPlan((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.sql().apply((Object)query));
        BatchScanExec primaryScan = (BatchScanExec)this.collect(executedPlan, new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BatchScanExec batchScanExec;
                A1 A1 = x1;
                Object object = A1 instanceof BatchScanExec ? (batchScanExec = (BatchScanExec)A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan2 = x1;
                boolean bl = sparkPlan2 instanceof BatchScanExec;
                return bl;
            }
        }).head();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(primaryScan.schema().sameType((DataType)StructType$.MODULE$.fromDDL(primaryScanSchema)), "primaryScan.schema.sameType(org.apache.spark.sql.types.StructType.fromDDL(primaryScanSchema))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupBasedDeleteFromTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        Seq seq = primaryScan.runtimeFilters();
        if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) != 0 || !((expression = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof DynamicPruningExpression) || !((child = (dynamicPruningExpression = (DynamicPruningExpression)expression).child()) instanceof InSubqueryExec)) {
            throw this.fail("could not find group filter scan", new Position("GroupBasedDeleteFromTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        }
        InSubqueryExec inSubqueryExec = (InSubqueryExec)child;
        BatchScanExec groupFilterScan = (BatchScanExec)this.collect((SparkPlan)inSubqueryExec.plan(), new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                BatchScanExec batchScanExec;
                A1 A1 = x2;
                Object object = A1 instanceof BatchScanExec ? (batchScanExec = (BatchScanExec)A1) : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x2) {
                SparkPlan sparkPlan2 = x2;
                boolean bl = sparkPlan2 instanceof BatchScanExec;
                return bl;
            }
        }).head();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(groupFilterScan.schema().sameType((DataType)StructType$.MODULE$.fromDDL(groupFilterScanSchema)), "groupFilterScan.schema.sameType(org.apache.spark.sql.types.StructType.fromDDL(groupFilterScanSchema))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupBasedDeleteFromTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void checkReplacedPartitions(Seq<Object> expectedPartitions) {
        Seq actualPartitions;
        Seq $org_scalatest_assert_macro_left = actualPartitions = (Seq)this.table().replacedPartitions().map((Function1 & Serializable)x0$1 -> {
            SeqOps seqOps;
            Object object;
            Object partValue;
            SeqOps seqOps2;
            Seq seq = x0$1;
            if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0 && (partValue = SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0)) instanceof UTF8String) {
                UTF8String uTF8String = (UTF8String)partValue;
                object = uTF8String.toString();
            } else if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
                Object partValue2;
                object = partValue2 = SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            } else {
                throw this.fail(new StringBuilder(35).append("expected only one partition value: ").append(seq).toString(), new Position("GroupBasedDeleteFromTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            }
            return object;
        });
        Seq<Object> $org_scalatest_assert_macro_right = expectedPartitions;
        Seq seq = $org_scalatest_assert_macro_left;
        Seq<Object> seq2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", $org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"replaced partitions must match", Prettifier$.MODULE$.default(), new Position("GroupBasedDeleteFromTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
    }

    public GroupBasedDeleteFromTableSuite() {
        this.test("delete with IN predicate and runtime group filtering", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("id INT, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"id\": 1, \"salary\": 300, \"dep\": 'hr' }\n        |{ \"id\": 2, \"salary\": 150, \"dep\": 'software' }\n        |{ \"id\": 3, \"salary\": 120, \"dep\": 'hr' }\n        |")));
            this.executeDeleteAndCheckScans(new StringBuilder(44).append("DELETE FROM ").append(this.tableNameAsString()).append(" WHERE salary IN (300, 400, 500)").toString(), "id INT, salary INT, dep STRING, _partition STRING", "salary INT, dep STRING");
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)150), "software"}));
            Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)120), "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)package$.MODULE$.Nil().$colon$colon((Object)row2).$colon$colon((Object)row));
            this.checkReplacedPartitions((Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hr"}))));
        }, new Position("GroupBasedDeleteFromTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        this.test("delete with subqueries and runtime group filtering", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"deleted_id", "deleted_dep"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("id INT, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"id\": 1, \"salary\": 300, \"dep\": 'hr' }\n          |{ \"id\": 2, \"salary\": 150, \"dep\": 'software' }\n          |{ \"id\": 3, \"salary\": 120, \"dep\": 'hr' }\n          |{ \"id\": 4, \"salary\": 150, \"dep\": 'software' }\n          |")));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(GroupBasedDeleteFromTableSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_GroupBasedDeleteFromTableSuite$$typecreator10$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_connector_GroupBasedDeleteFromTableSuite$$typecreator10$1(GroupBasedDeleteFromTableSuite $outer) {
                }
            }
            Dataset deletedIdDF = this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{new Some((Object)BoxesRunTime.boxToInteger((int)2)), None$.MODULE$})), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_GroupBasedDeleteFromTableSuite$$typecreator10$1(null)))).toDF();
            deletedIdDF.createOrReplaceTempView("deleted_id");
            JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(GroupBasedDeleteFromTableSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_GroupBasedDeleteFromTableSuite$$typecreator20$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_connector_GroupBasedDeleteFromTableSuite$$typecreator20$1(GroupBasedDeleteFromTableSuite $outer) {
                }
            }
            Dataset deletedDepDF = this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{new Some((Object)"software"), None$.MODULE$})), this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_connector_GroupBasedDeleteFromTableSuite$$typecreator20$1(null)))).toDF();
            deletedDepDF.createOrReplaceTempView("deleted_dep");
            this.executeDeleteAndCheckScans(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(154).append("DELETE FROM ").append(this.tableNameAsString()).append("\n           |WHERE\n           | id IN (SELECT * FROM deleted_id)\n           | AND\n           | dep IN (SELECT * FROM deleted_dep)\n           |").toString())), "id INT, salary INT, dep STRING, _partition STRING", "id INT, dep STRING");
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)300), "hr"}));
            Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)120), "hr"}));
            Row row3 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)150), "software"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)package$.MODULE$.Nil().$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
            this.checkReplacedPartitions((Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"software"}))));
        }), new Position("GroupBasedDeleteFromTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        this.test("delete runtime group filtering (DPP enabled)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DYNAMIC_PARTITION_PRUNING_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.checkDeleteRuntimeGroupFiltering()), new Position("GroupBasedDeleteFromTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        this.test("delete runtime group filtering (DPP disabled)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DYNAMIC_PARTITION_PRUNING_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.checkDeleteRuntimeGroupFiltering()), new Position("GroupBasedDeleteFromTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("delete runtime group filtering (AQE enabled)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ADAPTIVE_EXECUTION_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.checkDeleteRuntimeGroupFiltering()), new Position("GroupBasedDeleteFromTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        this.test("delete runtime group filtering (AQE disabled)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ADAPTIVE_EXECUTION_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.checkDeleteRuntimeGroupFiltering()), new Position("GroupBasedDeleteFromTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
    }
}

