/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.execution.streaming.state.HDFSBackedStateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf$;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreId$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

public final class StateStoreBasicOperationsBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static final StateStoreBasicOperationsBenchmark$ MODULE$ = new StateStoreBasicOperationsBenchmark$();
    private static final StructType keySchema;
    private static final StructType valueSchema;
    private static final UnsafeProjection keyProjection;
    private static final UnsafeProjection valueProjection;
    private static SparkSession spark;
    private static String sparkHome;
    private static volatile boolean bitmap$0;

    static {
        SQLHelper.$init$((SQLHelper)MODULE$);
        SqlBasedBenchmark.$init$(MODULE$);
        keySchema = StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("key1", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("key2", (DataType)TimestampType$.MODULE$, true, StructField$.MODULE$.apply$default$4())})));
        valueSchema = StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("value", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4())})));
        keyProjection = UnsafeProjection$.MODULE$.create(MODULE$.keySchema());
        valueProjection = UnsafeProjection$.MODULE$.create(MODULE$.valueSchema());
    }

    @Override
    public SparkSession getSparkSession() {
        return SqlBasedBenchmark.getSparkSession$(this);
    }

    @Override
    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$(this, name, cardinality, f);
    }

    @Override
    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$(this, ds);
    }

    @Override
    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$(this, benchmark);
    }

    @Override
    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$(this, path, rowsNum, numCols);
    }

    @Override
    public void afterAll() {
        SqlBasedBenchmark.afterAll$(this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    @Override
    public SparkSession spark() {
        return spark;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        spark = x$1;
    }

    private String sparkHome$lzycompute() {
        StateStoreBasicOperationsBenchmark$ stateStoreBasicOperationsBenchmark$ = this;
        synchronized (stateStoreBasicOperationsBenchmark$) {
            if (!bitmap$0) {
                sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                bitmap$0 = true;
            }
        }
        return sparkHome;
    }

    public String sparkHome() {
        return !bitmap$0 ? this.sparkHome$lzycompute() : sparkHome;
    }

    private StructType keySchema() {
        return keySchema;
    }

    private StructType valueSchema() {
        return valueSchema;
    }

    private UnsafeProjection keyProjection() {
        return keyProjection;
    }

    private UnsafeProjection valueProjection() {
        return valueProjection;
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.runPutBenchmark();
        this.runDeleteBenchmark();
        this.runEvictBenchmark();
    }

    public final void skip(String benchmarkName, Function0<Object> func) {
        this.output().foreach((Function1 & Serializable)x$1 -> {
            x$1.write(new StringBuilder(11).append(benchmarkName).append(" is skipped").toString().getBytes());
            return BoxedUnit.UNIT;
        });
    }

    private void runPutBenchmark() {
        this.runBenchmark("put rows", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq numOfRows = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{10000}));
            Seq overwriteRates = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 75, 50, 25, 10, 5, 0}));
            numOfRows.foreach((Function1)(JFunction1.mcVI.sp & Serializable)numOfRow -> {
                Seq<Tuple2<UnsafeRow, UnsafeRow>> testData = MODULE$.constructRandomizedTestData(numOfRow, (List<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numOfRow).map((Function1)(JFunction1.mcJI.sp & Serializable)x$2 -> (long)x$2 * 1000L).toList(), 0);
                StateStoreProvider inMemoryProvider = MODULE$.newHDFSBackedStateStoreProvider();
                StateStoreProvider rocksDBProvider = MODULE$.newRocksDBStateProvider(MODULE$.newRocksDBStateProvider$default$1());
                StateStoreProvider rocksDBWithNoTrackProvider = MODULE$.newRocksDBStateProvider(false);
                long committedInMemoryVersion = MODULE$.loadInitialData(inMemoryProvider, testData);
                long committedRocksDBVersion = MODULE$.loadInitialData(rocksDBProvider, testData);
                long committedRocksDBWithNoTrackVersion = MODULE$.loadInitialData(rocksDBWithNoTrackProvider, testData);
                overwriteRates.foreach((Function1)(JFunction1.mcVI.sp & Serializable)overwriteRate -> {
                    int numOfRowsToOverwrite = numOfRow * overwriteRate / 100;
                    int numOfNewRows = numOfRow - numOfRowsToOverwrite;
                    Seq<Tuple2<UnsafeRow, UnsafeRow>> newRows = numOfNewRows > 0 ? MODULE$.constructRandomizedTestData(numOfNewRows, (List<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numOfNewRows).map((Function1)(JFunction1.mcJI.sp & Serializable)x$3 -> (long)x$3 * 1000L).toList(), 0) : (Seq<Tuple2<UnsafeRow, UnsafeRow>>)package$.MODULE$.Seq().empty();
                    Seq existingRows = numOfRowsToOverwrite > 0 ? (Seq)((IterableOps)Random$.MODULE$.shuffle((IterableOnce)testData, BuildFrom$.MODULE$.buildFromIterableOps())).take(numOfRowsToOverwrite) : (Seq)package$.MODULE$.Seq().empty();
                    Seq rowsToPut = (Seq)Random$.MODULE$.shuffle((IterableOnce)newRows.$plus$plus((IterableOnce)existingRows), BuildFrom$.MODULE$.buildFromIterableOps());
                    String x$1 = new StringBuilder(0).append(new StringBuilder(14).append("putting ").append(numOfRow).append(" rows ").toString()).append(new StringBuilder(28).append("(").append(numOfRowsToOverwrite).append(" rows to overwrite - rate ").append(overwriteRate).append(")").toString()).toString();
                    long x$2 = numOfRow;
                    int x$32 = 10000;
                    Option x$4 = MODULE$.output();
                    FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
                    FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
                    boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
                    Benchmark benchmark = new Benchmark(x$1, x$2, 10000, x$5, x$6, x$7, x$4);
                    StateStoreBasicOperationsBenchmark$.registerPutBenchmarkCase$1(benchmark, "In-memory", inMemoryProvider, committedInMemoryVersion, rowsToPut);
                    StateStoreBasicOperationsBenchmark$.registerPutBenchmarkCase$1(benchmark, "RocksDB (trackTotalNumberOfRows: true)", rocksDBProvider, committedRocksDBVersion, rowsToPut);
                    StateStoreBasicOperationsBenchmark$.registerPutBenchmarkCase$1(benchmark, "RocksDB (trackTotalNumberOfRows: false)", rocksDBWithNoTrackProvider, committedRocksDBWithNoTrackVersion, rowsToPut);
                    benchmark.run();
                });
                inMemoryProvider.close();
                rocksDBProvider.close();
                rocksDBWithNoTrackProvider.close();
            });
        });
    }

    private void runDeleteBenchmark() {
        this.runBenchmark("delete rows", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq numOfRows = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{10000}));
            Seq nonExistRates = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 75, 50, 25, 10, 5, 0}));
            numOfRows.foreach((Function1)(JFunction1.mcVI.sp & Serializable)numOfRow -> {
                Seq<Tuple2<UnsafeRow, UnsafeRow>> testData = MODULE$.constructRandomizedTestData(numOfRow, (List<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numOfRow).map((Function1)(JFunction1.mcJI.sp & Serializable)x$4 -> (long)x$4 * 1000L).toList(), 0);
                StateStoreProvider inMemoryProvider = MODULE$.newHDFSBackedStateStoreProvider();
                StateStoreProvider rocksDBProvider = MODULE$.newRocksDBStateProvider(MODULE$.newRocksDBStateProvider$default$1());
                StateStoreProvider rocksDBWithNoTrackProvider = MODULE$.newRocksDBStateProvider(false);
                long committedInMemoryVersion = MODULE$.loadInitialData(inMemoryProvider, testData);
                long committedRocksDBVersion = MODULE$.loadInitialData(rocksDBProvider, testData);
                long committedRocksDBWithNoTrackVersion = MODULE$.loadInitialData(rocksDBWithNoTrackProvider, testData);
                nonExistRates.foreach((Function1)(JFunction1.mcVI.sp & Serializable)nonExistRate -> {
                    int numOfRowsNonExist = numOfRow * nonExistRate / 100;
                    int numOfExistingRows = numOfRow - numOfRowsNonExist;
                    Seq<Tuple2<UnsafeRow, UnsafeRow>> nonExistingRows = numOfRowsNonExist > 0 ? MODULE$.constructRandomizedTestData(numOfRowsNonExist, (List<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(numOfRow + 1), numOfRow + numOfRowsNonExist).map((Function1)(JFunction1.mcJI.sp & Serializable)x$5 -> (long)x$5 * 1000L).toList(), 0) : (Seq<Tuple2<UnsafeRow, UnsafeRow>>)package$.MODULE$.Seq().empty();
                    Seq existingRows = numOfExistingRows > 0 ? (Seq)((IterableOps)Random$.MODULE$.shuffle((IterableOnce)testData, BuildFrom$.MODULE$.buildFromIterableOps())).take(numOfExistingRows) : (Seq)package$.MODULE$.Seq().empty();
                    Seq keysToDelete = (Seq)((IterableOps)Random$.MODULE$.shuffle((IterableOnce)nonExistingRows.$plus$plus((IterableOnce)existingRows), BuildFrom$.MODULE$.buildFromIterableOps())).map((Function1 & Serializable)x$6 -> (UnsafeRow)x$6._1());
                    String x$1 = new StringBuilder(0).append(new StringBuilder(23).append("trying to delete ").append(numOfRow).append(" rows ").toString()).append(new StringBuilder(10).append("from ").append(numOfRow).append(" rows").toString()).append(new StringBuilder(32).append("(").append(numOfRowsNonExist).append(" rows are non-existing - rate ").append(nonExistRate).append(")").toString()).toString();
                    long x$2 = numOfRow;
                    int x$3 = 10000;
                    Option x$4 = MODULE$.output();
                    FiniteDuration x$52 = Benchmark$.MODULE$.$lessinit$greater$default$4();
                    FiniteDuration x$62 = Benchmark$.MODULE$.$lessinit$greater$default$5();
                    boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
                    Benchmark benchmark = new Benchmark(x$1, x$2, 10000, x$52, x$62, x$7, x$4);
                    StateStoreBasicOperationsBenchmark$.registerDeleteBenchmarkCase$1(benchmark, "In-memory", inMemoryProvider, committedInMemoryVersion, keysToDelete);
                    StateStoreBasicOperationsBenchmark$.registerDeleteBenchmarkCase$1(benchmark, "RocksDB (trackTotalNumberOfRows: true)", rocksDBProvider, committedRocksDBVersion, keysToDelete);
                    StateStoreBasicOperationsBenchmark$.registerDeleteBenchmarkCase$1(benchmark, "RocksDB (trackTotalNumberOfRows: false)", rocksDBWithNoTrackProvider, committedRocksDBWithNoTrackVersion, keysToDelete);
                    benchmark.run();
                });
                inMemoryProvider.close();
                rocksDBProvider.close();
                rocksDBWithNoTrackProvider.close();
            });
        });
    }

    private void runEvictBenchmark() {
        this.runBenchmark("evict rows", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq numOfRows = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{10000}));
            Seq numOfEvictionRates = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 75, 50, 25, 10, 5, 0}));
            numOfRows.foreach((Function1)(JFunction1.mcVI.sp & Serializable)numOfRow -> {
                List timestampsInMicros = ((IterableOnceOps)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)numOfRow)).map((Function1)(JFunction1.mcJJ.sp & Serializable)ts -> ts * 1000L)).toList();
                Seq<Tuple2<UnsafeRow, UnsafeRow>> testData = MODULE$.constructRandomizedTestData(numOfRow, (List<Object>)timestampsInMicros, 0);
                StateStoreProvider inMemoryProvider = MODULE$.newHDFSBackedStateStoreProvider();
                StateStoreProvider rocksDBProvider = MODULE$.newRocksDBStateProvider(MODULE$.newRocksDBStateProvider$default$1());
                StateStoreProvider rocksDBWithNoTrackProvider = MODULE$.newRocksDBStateProvider(false);
                long committedInMemoryVersion = MODULE$.loadInitialData(inMemoryProvider, testData);
                long committedRocksDBVersion = MODULE$.loadInitialData(rocksDBProvider, testData);
                long committedRocksDBWithNoTrackVersion = MODULE$.loadInitialData(rocksDBWithNoTrackProvider, testData);
                numOfEvictionRates.foreach((Function1)(JFunction1.mcVI.sp & Serializable)numOfEvictionRate -> {
                    int numOfRowsToEvict = numOfRow * numOfEvictionRate / 100;
                    long maxTimestampToEvictInMillis = BoxesRunTime.unboxToLong((Object)timestampsInMicros.take(numOfRow * numOfEvictionRate / 100).lastOption().map((Function1)(JFunction1.mcJJ.sp & Serializable)x$7 -> x$7 / 1000L).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
                    String x$1 = new StringBuilder(0).append(new StringBuilder(15).append("evicting ").append(numOfRowsToEvict).append(" rows ").toString()).append(new StringBuilder(32).append("(maxTimestampToEvictInMillis: ").append(maxTimestampToEvictInMillis).append(") ").toString()).append(new StringBuilder(10).append("from ").append(numOfRow).append(" rows").toString()).toString();
                    long x$2 = numOfRow;
                    int x$3 = 10000;
                    Option x$4 = MODULE$.output();
                    FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
                    FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
                    boolean x$72 = Benchmark$.MODULE$.$lessinit$greater$default$6();
                    Benchmark benchmark = new Benchmark(x$1, x$2, 10000, x$5, x$6, x$72, x$4);
                    StateStoreBasicOperationsBenchmark$.registerEvictBenchmarkCase$1(benchmark, "In-memory", inMemoryProvider, committedInMemoryVersion, maxTimestampToEvictInMillis, numOfRowsToEvict);
                    StateStoreBasicOperationsBenchmark$.registerEvictBenchmarkCase$1(benchmark, "RocksDB (trackTotalNumberOfRows: true)", rocksDBProvider, committedRocksDBVersion, maxTimestampToEvictInMillis, numOfRowsToEvict);
                    StateStoreBasicOperationsBenchmark$.registerEvictBenchmarkCase$1(benchmark, "RocksDB (trackTotalNumberOfRows: false)", rocksDBWithNoTrackProvider, committedRocksDBWithNoTrackVersion, maxTimestampToEvictInMillis, numOfRowsToEvict);
                    benchmark.run();
                });
                inMemoryProvider.close();
                rocksDBProvider.close();
                rocksDBWithNoTrackProvider.close();
            });
        });
    }

    private Seq<UnsafeRow> getRows(StateStore store, Seq<UnsafeRow> keys) {
        return (Seq)keys.map((Function1 & Serializable)key -> store.get(key));
    }

    private long loadInitialData(StateStoreProvider provider, Seq<Tuple2<UnsafeRow, UnsafeRow>> data) {
        StateStore store = provider.getStore(0L);
        this.updateRows(store, data);
        return store.commit();
    }

    private void updateRows(StateStore store, Seq<Tuple2<UnsafeRow, UnsafeRow>> rows) {
        rows.foreach((Function1 & Serializable)x0$1 -> {
            StateStoreBasicOperationsBenchmark$.$anonfun$updateRows$1(store, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void deleteRows(StateStore store, Seq<UnsafeRow> rows) {
        rows.foreach((Function1 & Serializable)key -> {
            store.remove(key);
            return BoxedUnit.UNIT;
        });
    }

    private void evictAsFullScanAndRemove(StateStore store, long maxTimestampToEvictMillis, long expectedNumOfRows) {
        LongRef removedRows = LongRef.create((long)0L);
        store.iterator().foreach((Function1 & Serializable)r -> {
            StateStoreBasicOperationsBenchmark$.$anonfun$evictAsFullScanAndRemove$1(maxTimestampToEvictMillis, store, removedRows, r);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(removedRows.elem == expectedNumOfRows, (Function0 & Serializable)() -> new StringBuilder(19).append("expected: ").append(expectedNumOfRows).append(" actual: ").append(removedRows$1.elem).toString());
    }

    private Seq<Tuple2<UnsafeRow, UnsafeRow>> constructRandomizedTestData(int numRows, List<Object> timestamps, int minIdx) {
        Predef$.MODULE$.assert(numRows >= timestamps.length());
        Predef$.MODULE$.assert(numRows % timestamps.length() == 0);
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numRows).map((Function1 & Serializable)idx -> StateStoreBasicOperationsBenchmark$.$anonfun$constructRandomizedTestData$1(timestamps, minIdx, BoxesRunTime.unboxToInt((Object)idx)));
    }

    private int constructRandomizedTestData$default$3() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private StateStoreProvider newHDFSBackedStateStoreProvider() {
        void var2_2;
        StateStoreId storeId = new StateStoreId(this.newDir(), (long)Random$.MODULE$.nextInt(), 0, StateStoreId$.MODULE$.apply$default$4());
        HDFSBackedStateStoreProvider provider = new HDFSBackedStateStoreProvider();
        StateStoreConf storeConf = new StateStoreConf(new SQLConf(), StateStoreConf$.MODULE$.$lessinit$greater$default$2());
        provider.init(storeId, this.keySchema(), this.valueSchema(), 0, storeConf, new Configuration());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private StateStoreProvider newRocksDBStateProvider(boolean trackTotalNumberOfRows) {
        void var3_3;
        StateStoreId storeId = new StateStoreId(this.newDir(), (long)Random$.MODULE$.nextInt(), 0, StateStoreId$.MODULE$.apply$default$4());
        RocksDBStateStoreProvider provider = new RocksDBStateStoreProvider();
        SQLConf sqlConf = new SQLConf();
        sqlConf.setConfString("spark.sql.streaming.stateStore.rocksdb.trackTotalNumberOfRows", Boolean.toString(trackTotalNumberOfRows));
        StateStoreConf storeConf = new StateStoreConf(sqlConf, StateStoreConf$.MODULE$.$lessinit$greater$default$2());
        provider.init(storeId, this.keySchema(), this.valueSchema(), 0, storeConf, new Configuration());
        return var3_3;
    }

    private boolean newRocksDBStateProvider$default$1() {
        return true;
    }

    private String newDir() {
        return Utils$.MODULE$.createTempDir().toString();
    }

    public static final /* synthetic */ void $anonfun$runPutBenchmark$1(StateStoreProvider provider$1, long version$1, Seq rows$1, Benchmark.Timer timer) {
        StateStore store = provider$1.getStore(version$1);
        timer.startTiming();
        MODULE$.updateRows(store, (Seq<Tuple2<UnsafeRow, UnsafeRow>>)rows$1);
        timer.stopTiming();
        store.abort();
    }

    private static final void registerPutBenchmarkCase$1(Benchmark benchmark, String testName, StateStoreProvider provider, long version, Seq rows) {
        benchmark.addTimerCase(testName, benchmark.addTimerCase$default$2(), (Function1 & Serializable)timer -> {
            StateStoreBasicOperationsBenchmark$.$anonfun$runPutBenchmark$1(provider, version, rows, timer);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$runDeleteBenchmark$1(StateStoreProvider provider$2, long version$2, Seq keys$1, Benchmark.Timer timer) {
        StateStore store = provider$2.getStore(version$2);
        timer.startTiming();
        MODULE$.deleteRows(store, (Seq<UnsafeRow>)keys$1);
        timer.stopTiming();
        store.abort();
    }

    private static final void registerDeleteBenchmarkCase$1(Benchmark benchmark, String testName, StateStoreProvider provider, long version, Seq keys) {
        benchmark.addTimerCase(testName, benchmark.addTimerCase$default$2(), (Function1 & Serializable)timer -> {
            StateStoreBasicOperationsBenchmark$.$anonfun$runDeleteBenchmark$1(provider, version, keys, timer);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$runEvictBenchmark$1(StateStoreProvider provider$3, long version$3, long maxTimestampToEvictInMillis$1, long expectedNumOfRows$1, Benchmark.Timer timer) {
        StateStore store = provider$3.getStore(version$3);
        timer.startTiming();
        MODULE$.evictAsFullScanAndRemove(store, maxTimestampToEvictInMillis$1, expectedNumOfRows$1);
        timer.stopTiming();
        store.abort();
    }

    private static final void registerEvictBenchmarkCase$1(Benchmark benchmark, String testName, StateStoreProvider provider, long version, long maxTimestampToEvictInMillis, long expectedNumOfRows) {
        benchmark.addTimerCase(testName, benchmark.addTimerCase$default$2(), (Function1 & Serializable)timer -> {
            StateStoreBasicOperationsBenchmark$.$anonfun$runEvictBenchmark$1(provider, version, maxTimestampToEvictInMillis, expectedNumOfRows, timer);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$updateRows$1(StateStore store$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        UnsafeRow key = (UnsafeRow)tuple2._1();
        UnsafeRow value = (UnsafeRow)tuple2._2();
        store$2.put(key, value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$evictAsFullScanAndRemove$1(long maxTimestampToEvictMillis$1, StateStore store$4, LongRef removedRows$1, UnsafeRowPair r) {
        block0: {
            if (r.key().getLong(1) > maxTimestampToEvictMillis$1 * 1000L) break block0;
            store$4.remove(r.key());
            ++removedRows$1.elem;
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$constructRandomizedTestData$1(List timestamps$1, int minIdx$1, int idx) {
        GenericInternalRow keyRow = new GenericInternalRow(2);
        keyRow.setInt(0, Random$.MODULE$.nextInt(Integer.MAX_VALUE));
        keyRow.setLong(1, BoxesRunTime.unboxToLong((Object)timestamps$1.apply((minIdx$1 + idx) % timestamps$1.length())));
        GenericInternalRow valueRow = new GenericInternalRow(1);
        valueRow.setInt(0, minIdx$1 + idx);
        UnsafeRow keyUnsafeRow = MODULE$.keyProjection().apply((InternalRow)keyRow).copy();
        UnsafeRow valueUnsafeRow = MODULE$.valueProjection().apply((InternalRow)valueRow).copy();
        return new Tuple2((Object)keyUnsafeRow, (Object)valueUnsafeRow);
    }

    private StateStoreBasicOperationsBenchmark$() {
    }
}

