/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.jdbc.connection;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.util.Properties;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.connection.BasicConnectionProvider;
import org.apache.spark.sql.execution.datasources.jdbc.connection.ConnectionProviderSuiteBase;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatestplus.mockito.MockitoSugar;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00112AAA\u0002\u0001)!)\u0011\u0005\u0001C\u0001E\ta\")Y:jG\u000e{gN\\3di&|g\u000e\u0015:pm&$WM]*vSR,'B\u0001\u0003\u0006\u0003)\u0019wN\u001c8fGRLwN\u001c\u0006\u0003\r\u001d\tAA\u001b3cG*\u0011\u0001\"C\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u000b\u0017\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u00195\t1a]9m\u0015\tqq\"A\u0003ta\u0006\u00148N\u0003\u0002\u0011#\u00051\u0011\r]1dQ\u0016T\u0011AE\u0001\u0004_J<7\u0001A\n\u0004\u0001UI\u0002C\u0001\f\u0018\u001b\u0005\u0019\u0011B\u0001\r\u0004\u0005m\u0019uN\u001c8fGRLwN\u001c)s_ZLG-\u001a:Tk&$XMQ1tKB\u0011!dH\u0007\u00027)\u0011A$H\u0001\b[>\u001c7.\u001b;p\u0015\tq\u0012#A\u0007tG\u0006d\u0017\r^3tiBdWo]\u0005\u0003Am\u0011A\"T8dW&$xnU;hCJ\fa\u0001P5oSRtD#A\u0012\u0011\u0005Y\u0001\u0001")
public class BasicConnectionProviderSuite
extends ConnectionProviderSuiteBase
implements MockitoSugar {
    public <T> T mock(ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, classTag);
    }

    public <T> T mock(Answer<?> defaultAnswer, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, defaultAnswer, classTag);
    }

    public <T> T mock(MockSettings mockSettings, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (MockSettings)mockSettings, classTag);
    }

    public <T> T mock(String name, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (String)name, classTag);
    }

    public BasicConnectionProviderSuite() {
        MockitoSugar.$init$((MockitoSugar)this);
        this.test("Check properties of BasicConnectionProvider", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            JDBCOptions opts = this.options("jdbc:postgresql://localhost/postgres");
            BasicConnectionProvider provider = new BasicConnectionProvider();
            String $org_scalatest_assert_macro_left = provider.name();
            String $org_scalatest_assert_macro_right = "basic";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicConnectionProviderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
            Properties $org_scalatest_assert_macro_left2 = provider.getAdditionalProperties(opts);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicConnectionProviderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        }, new Position("BasicConnectionProviderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        this.test("Check that JDBC options don't contain data source configs", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            BasicConnectionProvider provider = new BasicConnectionProvider();
            Driver driver = (Driver)this.mock(ClassTag$.MODULE$.apply(Driver.class));
            Mockito.when((Object)driver.connect((String)ArgumentMatchers.any(), (Properties)ArgumentMatchers.any())).thenAnswer(invocation -> {
                void var3_3;
                Properties props = (Properties)invocation.getArguments()[1];
                Connection conn = (Connection)this.mock(ClassTag$.MODULE$.apply(Connection.class));
                Mockito.when((Object)conn.getClientInfo()).thenReturn((Object)props);
                return var3_3;
            });
            Map opts = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_URL()), (Object)"jdbc:postgresql://localhost/postgres"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)"table"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_CONNECTION_PROVIDER()), (Object)"basic")}));
            Connection conn = provider.getConnection(driver, opts);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(conn.getClientInfo().containsKey(JDBCOptions$.MODULE$.JDBC_URL()), "conn.getClientInfo().containsKey(org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions.JDBC_URL)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicConnectionProviderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(conn.getClientInfo().containsKey(JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), "conn.getClientInfo().containsKey(org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions.JDBC_TABLE_NAME)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicConnectionProviderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(conn.getClientInfo().containsKey(JDBCOptions$.MODULE$.JDBC_CONNECTION_PROVIDER()), "conn.getClientInfo().containsKey(org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions.JDBC_CONNECTION_PROVIDER)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicConnectionProviderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        }, new Position("BasicConnectionProviderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
    }
}

