/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.time.Period;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.orc.OrcProto;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.orc.OrcSuite;
import org.apache.spark.sql.execution.datasources.orc.OrcTest;
import org.apache.spark.sql.execution.datasources.orc.OrcUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005%2Qa\u0001\u0003\u0002\u0002MAQA\b\u0001\u0005\u0002}AQ!\t\u0001\u0005R\t\u0012ab\u0014:d'>,(oY3Tk&$XM\u0003\u0002\u0006\r\u0005\u0019qN]2\u000b\u0005\u001dA\u0011a\u00033bi\u0006\u001cx.\u001e:dKNT!!\u0003\u0006\u0002\u0013\u0015DXmY;uS>t'BA\u0006\r\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u001b9\tQa\u001d9be.T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011c\u0001\u0001\u00151A\u0011QCF\u0007\u0002\t%\u0011q\u0003\u0002\u0002\t\u001fJ\u001c7+^5uKB\u0011\u0011\u0004H\u0007\u00025)\u00111DC\u0001\u0005i\u0016\u001cH/\u0003\u0002\u001e5\t\u00112\u000b[1sK\u0012\u001c\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0005\u0005\u0002\u0016\u0001\u0005I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002GA\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t!QK\\5u\u0001")
public abstract class OrcSourceSuite
extends OrcSuite
implements SharedSparkSession {
    private boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SharedSparkSessionBase.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        SharedSparkSessionBase.afterAll$(this);
    }

    @Override
    public void afterAll() {
        SharedSparkSession.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterAll() {
        OrcTest.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public SparkConf sparkConf() {
        return SharedSparkSessionBase.sparkConf$(this);
    }

    @Override
    public SparkSession spark() {
        return SharedSparkSessionBase.spark$(this);
    }

    @Override
    public SQLContext sqlContext() {
        return SharedSparkSessionBase.sqlContext$(this);
    }

    @Override
    public TestSparkSession createSparkSession() {
        return SharedSparkSessionBase.createSparkSession$(this);
    }

    @Override
    public void initializeSession() {
        SharedSparkSessionBase.initializeSession$(this);
    }

    @Override
    public void beforeEach() {
        SharedSparkSessionBase.beforeEach$(this);
    }

    @Override
    public void afterEach() {
        SharedSparkSessionBase.afterEach$(this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSession$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSessionBase$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark = x$1;
    }

    @Override
    public void beforeAll() {
        SharedSparkSession.beforeAll$(this);
        this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(143).append("CREATE TABLE normal_orc(\n         |  intField INT,\n         |  stringField STRING\n         |)\n         |USING ORC\n         |LOCATION '").append(this.orcTableAsDir().toURI()).append("'\n       ").toString())));
        this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("INSERT INTO TABLE normal_orc\n         |SELECT intField, stringField FROM orc_temp_table\n       ")));
        this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(119).append("CREATE TEMPORARY VIEW normal_orc_source\n         |USING ORC\n         |OPTIONS (\n         |  PATH '").append(new File(this.orcTableAsDir().getAbsolutePath()).toURI()).append("'\n         |)\n       ").toString())));
        this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(122).append("CREATE TEMPORARY VIEW normal_orc_as_source\n         |USING ORC\n         |OPTIONS (\n         |  PATH '").append(new File(this.orcTableAsDir().getAbsolutePath()).toURI()).append("'\n         |)\n       ").toString())));
    }

    public static final /* synthetic */ void $anonfun$new$104(OrcSourceSuite $this, File dir) {
        String path = dir.getAbsolutePath();
        $this.spark().sql("SELECT 'a' as `1`, 'b' as `2`, 'c' as `3`").write().orc(path);
        Dataset df = $this.spark().read().orc(path);
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a", "b", "c"})));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(df.schema().toArray(ClassTag$.MODULE$.apply(StructField.class)));
        StructField[] $org_scalatest_assert_macro_right = (StructField[])((Object[])new StructField[]{new StructField("1", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("2", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("3", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())});
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 679));
    }

    public static final /* synthetic */ void $anonfun$new$106(OrcSourceSuite $this, File dir) {
        String path = dir.getAbsolutePath();
        $this.spark().sql("SELECT 'a' as `10`, named_struct('20', 'b', '30', named_struct('40', 'c')) as `50`").write().orc(path);
        Dataset df = $this.spark().read().orc(path);
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a", Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"b", Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"c"}))}))})));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(df.schema().toArray(ClassTag$.MODULE$.apply(StructField.class)));
        StructField[] structFieldArray = new StructField[2];
        structFieldArray[0] = new StructField("10", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField = new StructField("20", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("40", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField3 = new StructField("30", (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField2)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        structFieldArray[1] = new StructField("50", (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField3).$colon$colon((Object)structField)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField[] $org_scalatest_assert_macro_right = (StructField[])((Object[])structFieldArray);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 694));
    }

    public static final /* synthetic */ void $anonfun$new$108(OrcSourceSuite $this, File dir) {
        String path = dir.getAbsolutePath();
        $this.spark().sql("SELECT array(array(named_struct('123', 'a'), named_struct('123', 'b'))) as `789`").write().orc(path);
        Dataset df = $this.spark().read().orc(path);
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"b"}))}))}))})));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(df.schema().toArray(ClassTag$.MODULE$.apply(StructField.class)));
        StructField[] structFieldArray = new StructField[1];
        StructField structField = new StructField("123", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        structFieldArray[0] = new StructField("789", (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField)))), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField[] $org_scalatest_assert_macro_right = (StructField[])((Object[])structFieldArray);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 711));
    }

    public static final /* synthetic */ void $anonfun$new$110(OrcSourceSuite $this, File dir) {
        String path = dir.getAbsolutePath();
        $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |SELECT\n          |  map(\n          |    named_struct('123', 'a'),\n          |    map(\n          |      named_struct('456', 'b'),\n          |      named_struct('789', 'c'))) as `012`"))).write().orc(path);
        Dataset df = $this.spark().read().orc(path);
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a"}))), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"b"}))), (Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"c"})))})))}))})));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(df.schema().toArray(ClassTag$.MODULE$.apply(StructField.class)));
        StructField[] structFieldArray = new StructField[1];
        StructField structField = new StructField("123", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("456", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField3 = new StructField("789", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        structFieldArray[0] = new StructField("012", (DataType)MapType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField)), (DataType)MapType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField2)), (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField3)))), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField[] $org_scalatest_assert_macro_right = (StructField[])((Object[])structFieldArray);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 732));
    }

    public static final /* synthetic */ void $anonfun$new$112(OrcSourceSuite $this, File dir) {
        String path = dir.getAbsolutePath();
        $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |SELECT\n          |  named_struct('123',\n          |    array(\n          |      map(\n          |        named_struct('456', 'a'),\n          |        named_struct('789', 'b')))) as `1000`,\n          |  named_struct('123',\n          |    map(\n          |      array(named_struct('456', 'a')),\n          |      array(named_struct('789', 'b')))) as `2000`,\n          |  array(\n          |    named_struct('123',\n          |      map(\n          |        named_struct('456', 'a'),\n          |        named_struct('789', 'b')))) as `3000`,\n          |  array(\n          |    map(\n          |      named_struct('123', 'a'),\n          |      named_struct('456', 'b'))) as `4000`,\n          |  map(\n          |    named_struct('123',\n          |      array(\n          |        named_struct('456', 'a'))),\n          |    named_struct('789',\n          |      array(\n          |        named_struct('012', 'b')))) as `5000`,\n          |  map(\n          |    array(\n          |      named_struct('123', 'a')),\n          |    array(\n          |      named_struct('456', 'b'))) as `6000`\n        "))).write().orc(path);
        Dataset df = $this.spark().read().orc(path);
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a"}))), (Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"b"})))}))}))})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a"}))}))), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"b"}))})))}))})), package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a"}))), (Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"b"})))}))}))})), package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a"}))), (Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"b"})))}))})), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a"}))}))}))), (Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"b"}))}))})))})), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a"}))}))), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"b"}))})))}))})));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(df.schema().toArray(ClassTag$.MODULE$.apply(StructField.class)));
        StructField[] structFieldArray = new StructField[6];
        StructField structField = new StructField("456", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("789", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField3 = new StructField("123", (DataType)ArrayType$.MODULE$.apply((DataType)MapType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField)), (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField2)))), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        structFieldArray[0] = new StructField("1000", (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField3)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField4 = new StructField("456", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField5 = new StructField("789", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField6 = new StructField("123", (DataType)MapType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField4))), (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField5)))), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        structFieldArray[1] = new StructField("2000", (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField6)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField7 = new StructField("456", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField8 = new StructField("789", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField9 = new StructField("123", (DataType)MapType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField7)), (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField8))), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        structFieldArray[2] = new StructField("3000", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField9))), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField10 = new StructField("123", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField11 = new StructField("456", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        structFieldArray[3] = new StructField("4000", (DataType)ArrayType$.MODULE$.apply((DataType)MapType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField10)), (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField11)))), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField12 = new StructField("456", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField13 = new StructField("123", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField12))), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField14 = new StructField("012", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField15 = new StructField("789", (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField14))), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        structFieldArray[4] = new StructField("5000", (DataType)MapType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField13)), (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField15))), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField16 = new StructField("123", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField17 = new StructField("456", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        structFieldArray[5] = new StructField("6000", (DataType)MapType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField16))), (DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField17)))), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField[] $org_scalatest_assert_macro_right = (StructField[])((Object[])structFieldArray);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 789));
    }

    public static final /* synthetic */ Period $anonfun$new$118(int i) {
        return Period.of(i, i, 0);
    }

    public static final /* synthetic */ Duration $anonfun$new$119(int i) {
        return Duration.ofDays(i).plusSeconds(i);
    }

    public static final /* synthetic */ void $anonfun$new$122(OrcSourceSuite $this, IndexedSeq data$1, StructType schema$1, File file) {
        SparkContext qual$1 = $this.sparkContext();
        IndexedSeq x$1 = data$1;
        int x$2 = qual$1.parallelize$default$2();
        Dataset df = $this.spark().createDataFrame(qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), schema$1);
        df.write().orc(file.getCanonicalPath());
        Dataset df2 = $this.spark().read().orc(file.getCanonicalPath());
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df2, (Seq<Row>)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])df.collect())));
    }

    public static final /* synthetic */ void $anonfun$new$120(OrcSourceSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AnsiIntervalType it = (AnsiIntervalType)tuple2._1();
        Function1 f = (Function1)tuple2._2();
        IndexedSeq data = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)i -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), f.apply((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)))})));
        StructType schema = new StructType((StructField[])((Object[])new StructField[]{new StructField("d", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("i", (DataType)it, false, StructField$.MODULE$.apply$default$4())}));
        $this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)file -> {
            OrcSourceSuite.$anonfun$new$122($this, data, schema, file);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$124(OrcSourceSuite $this, File file) {
        Dataset df = $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT\n                |  named_struct('interval', interval '1-2' year to month) a,\n                |  array(interval '1 2:3' day to minute) b,\n                |  map('key', interval '10' year) c,\n                |  map(interval '20' second, 'value') d")));
        df.write().orc(file.getCanonicalPath());
        Dataset df2 = $this.spark().read().orc(file.getCanonicalPath());
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df2, (Seq<Row>)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])df.collect())));
    }

    public static final /* synthetic */ void $anonfun$new$115(OrcSourceSuite $this, boolean vecReaderNestedColEnabled) {
        boolean vecReaderEnabled = SQLConf$.MODULE$.get().orcVectorizedReaderEnabled();
        $this.test(new StringBuilder(57).append("SPARK-36931: Support reading and writing ANSI intervals (").append(new StringBuilder(3).append(SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()).append("=").append(vecReaderEnabled).append(", ").toString()).append(new StringBuilder(2).append(SQLConf$.MODULE$.ORC_VECTORIZED_READER_NESTED_COLUMN_ENABLED().key()).append("=").append(vecReaderNestedColEnabled).append(")").toString()).toString(), (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)Boolean.toString(vecReaderEnabled)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_NESTED_COLUMN_ENABLED().key()), (Object)Boolean.toString(vecReaderNestedColEnabled))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)YearMonthIntervalType$.MODULE$.apply()), (Function1 & Serializable)i -> OrcSourceSuite.$anonfun$new$118(BoxesRunTime.unboxToInt((Object)i))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DayTimeIntervalType$.MODULE$.apply()), (Function1 & Serializable)i -> OrcSourceSuite.$anonfun$new$119(BoxesRunTime.unboxToInt((Object)i)))})).foreach((Function1 & Serializable)x0$1 -> {
                OrcSourceSuite.$anonfun$new$120($this, x0$1);
                return BoxedUnit.UNIT;
            });
            $this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)file -> {
                OrcSourceSuite.$anonfun$new$124($this, file);
                return BoxedUnit.UNIT;
            });
        }), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 853));
    }

    public static final /* synthetic */ void $anonfun$new$131(OrcSourceSuite $this, String query$1, File file) {
        Dataset df = (Dataset)$this.sql().apply((Object)query$1);
        df.coalesce(1).write().orc(file.getCanonicalPath());
        Dataset df2 = $this.spark().read().orc(file.getCanonicalPath());
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> df2, (Seq<Row>)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])df.collect())));
    }

    public OrcSourceSuite() {
        SharedSparkSessionBase.$init$(this);
        SharedSparkSession.$init$(this);
        this.test("Check BloomFilter creation", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testBloomFilterCreation(OrcProto.Stream.Kind.BLOOM_FILTER_UTF8), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
        this.test("Enforce direct encoding column-wise selectively", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testSelectiveDictionaryEncoding(true, false), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 642));
        this.test("SPARK-11412 read and merge orc schemas in parallel", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.testMergeSchemasInParallel((Function3<Seq<FileStatus>, Configuration, Object, Seq<StructType>>)(Function3 & Serializable)(files, conf, ignoreCorruptFiles) -> OrcUtils$.MODULE$.readOrcSchemasInParallel(files, conf, BoxesRunTime.unboxToBoolean((Object)ignoreCorruptFiles))), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 646));
        this.test("SPARK-31580: Read a file written before ORC-569", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Dataset<Row> df = this.readResourceOrcFile("test-data/TestStringDictionary.testRowIndex.orc");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df.where("str < 'row 001000'").count()));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 653));
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 650));
        this.test("SPARK-34897: Support reconcile schemas based on index after nested column pruning", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |CREATE TABLE t1 (\n          |  _col0 INT,\n          |  _col1 STRING,\n          |  _col2 STRUCT<c1: STRING, c2: STRING, c3: STRING, c4: BIGINT>)\n          |USING ORC\n          |")));
            this.spark().sql("INSERT INTO t1 values(1, '2', struct('a', 'b', 'c', 10L))");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().sql("SELECT _col0, _col2.c1 FROM t1"), (Seq<Row>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a"}))}))));
        }), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 656));
        this.test("SPARK-36663: OrcUtils.toCatalystSchema should correctly handle a column name which consists of only numbers", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
                OrcSourceSuite.$anonfun$new$104(this, dir);
                return BoxedUnit.UNIT;
            });
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
                OrcSourceSuite.$anonfun$new$106(this, dir);
                return BoxedUnit.UNIT;
            });
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
                OrcSourceSuite.$anonfun$new$108(this, dir);
                return BoxedUnit.UNIT;
            });
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
                OrcSourceSuite.$anonfun$new$110(this, dir);
                return BoxedUnit.UNIT;
            });
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
                OrcSourceSuite.$anonfun$new$112(this, dir);
                return BoxedUnit.UNIT;
            });
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 673));
        this.withAllNativeOrcReaders((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)vecReaderNestedColEnabled -> {
            OrcSourceSuite.$anonfun$new$115(this, BoxesRunTime.unboxToBoolean((Object)vecReaderNestedColEnabled));
            return BoxedUnit.UNIT;
        }));
        this.test("SPARK-37812: Reuse result row when deserializing a struct", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Seq queries = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT\n        |  array(\n        |    named_struct(\n        |      'a1', 1,\n        |      'a2', 2),\n        |    named_struct(\n        |      'a1', 3,\n        |      'a2', 4)\n        |  ) as col1\n        |")), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT\n        |  map(\n        |    'ns1',\n        |    named_struct(\n        |      'a1', 1,\n        |      'a2', 2),\n        |    'ns2',\n        |    named_struct(\n        |      'a1', 3,\n        |      'a2', 4)\n        |  ) as col1\n        |")), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT\n        |  map(\n        |    named_struct(\n        |      'a1', 1,\n        |      'a2', 2),\n        |    1,\n        |    named_struct(\n        |      'a1', 3,\n        |      'a2', 4),\n        |    2\n        |  ) as col1\n        |")), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT\n        |  array(\n        |    named_struct(\n        |      'a', named_struct(\n        |        'a1', 1,\n        |        'a2', 2),\n        |      'b', named_struct(\n        |        'b1', 3,\n        |        'b2', 4)\n        |    ),\n        |    named_struct(\n        |      'a', named_struct(\n        |        'a1', 5,\n        |        'a2', 6),\n        |      'b', named_struct(\n        |        'b1', 7,\n        |        'b2', 8)\n        |    )\n        |  ) as col1\n        |")), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT\n        |  map(\n        |    'ns1',\n        |    named_struct(\n        |      'a', named_struct(\n        |        'a1', 1,\n        |        'a2', 2),\n        |      'b', named_struct(\n        |        'b1', 3,\n        |        'b2', 4)\n        |    ),\n        |    'ns2',\n        |    named_struct(\n        |      'a', named_struct(\n        |        'a1', 5,\n        |        'a2', 6),\n        |      'b', named_struct(\n        |        'b1', 7,\n        |        'b2', 8)\n        |    )\n        |  ) as col1\n        |")), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT\n        |  map(\n        |    named_struct(\n        |      'a', named_struct(\n        |        'a1', 1,\n        |        'a2', 2),\n        |      'b', named_struct(\n        |        'b1', 3,\n        |        'b2', 4)\n        |    ),\n        |    1,\n        |    named_struct(\n        |      'a', named_struct(\n        |        'a1', 5,\n        |        'a2', 6),\n        |      'b', named_struct(\n        |        'b1', 7,\n        |        'b2', 8)\n        |    ),\n        |    2\n        |  ) as col1\n        |")), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT * FROM VALUES\n        |  (named_struct(\n        |    'a', 1,\n        |    'b', 2)),\n        |  (named_struct(\n        |    'a', 3,\n        |    'b', 4)),\n        |  (named_struct(\n        |    'a', 5,\n        |    'b', 6))\n        |tbl(c1)\n        |"))}));
            queries.foreach((Function1 & Serializable)query -> {
                this.withAllNativeOrcReaders((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)vecReaderNestedColEnabled -> {
                    $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_NESTED_COLUMN_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)vecReaderNestedColEnabled)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)file -> {
                        OrcSourceSuite.$anonfun$new$131($this, query$1, file);
                        return BoxedUnit.UNIT;
                    }));
                    return BoxedUnit.UNIT;
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 892));
        Statics.releaseFence();
    }
}

