/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.LocalSparkSession$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.StatefulOperatorStateInfo;
import org.apache.spark.sql.execution.streaming.state.ByteArrayPair;
import org.apache.spark.sql.execution.streaming.state.ReadStateStore;
import org.apache.spark.sql.execution.streaming.state.RocksDB;
import org.apache.spark.sql.execution.streaming.state.RocksDBConf;
import org.apache.spark.sql.execution.streaming.state.RocksDBConf$;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateStoreProvider$;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreCustomMetric;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreId$;
import org.apache.spark.sql.execution.streaming.state.StateStoreMetrics;
import org.apache.spark.sql.execution.streaming.state.StateStoreSuiteBase;
import org.apache.spark.sql.execution.streaming.state.StateStoreTestsHelper$;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair;
import org.apache.spark.sql.execution.streaming.state.package$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.tags.ExtendedSQLTest;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ExtendedSQLTest
@ScalaSignature(bytes="\u0006\u0005}4Aa\u0003\u0007\u00017!)\u0011\u0006\u0001C\u0001U!)A\u0006\u0001C![!)A\u0006\u0001C\u0001]!)A\u0006\u0001C!i!)A\u0006\u0001C\u0001{!)\u0011\t\u0001C!\u0005\")q\u000b\u0001C!1\"9Q\fAI\u0001\n\u0003q\u0006\"\u0002\u0017\u0001\t\u0003J\u0007\"\u00028\u0001\t\u0003z'A\u0006*pG.\u001cHIQ*uCR,7\u000b^8sKN+\u0018\u000e^3\u000b\u00055q\u0011!B:uCR,'BA\b\u0011\u0003%\u0019HO]3b[&twM\u0003\u0002\u0012%\u0005IQ\r_3dkRLwN\u001c\u0006\u0003'Q\t1a]9m\u0015\t)b#A\u0003ta\u0006\u00148N\u0003\u0002\u00181\u00051\u0011\r]1dQ\u0016T\u0011!G\u0001\u0004_J<7\u0001A\n\u0004\u0001q\u0019\u0003cA\u000f\u001fA5\tA\"\u0003\u0002 \u0019\t\u00192\u000b^1uKN#xN]3Tk&$XMQ1tKB\u0011Q$I\u0005\u0003E1\u0011\u0011DU8dWN$%i\u0015;bi\u0016\u001cFo\u001c:f!J|g/\u001b3feB\u0011AeJ\u0007\u0002K)\u0011a\u0005G\u0001\ng\u000e\fG.\u0019;fgRL!\u0001K\u0013\u0003\u001d\t+gm\u001c:f\u0003:$\u0017I\u001a;fe\u00061A(\u001b8jiz\"\u0012a\u000b\t\u0003;\u0001\t\u0001C\\3x'R|'/\u001a)s_ZLG-\u001a:\u0015\u0003\u0001\"\"\u0001I\u0018\t\u000bA\u001a\u0001\u0019A\u0019\u0002\u000fM$xN]3JIB\u0011QDM\u0005\u0003g1\u0011Ab\u0015;bi\u0016\u001cFo\u001c:f\u0013\u0012$\"\u0001I\u001b\t\u000bY\"\u0001\u0019A\u001c\u0002\u001b9,X\u000e\u0015:fM&D8i\u001c7t!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\rIe\u000e\u001e\u000b\u0004Ayz\u0004\"\u0002\u0019\u0006\u0001\u0004\t\u0004\"\u0002!\u0006\u0001\u00049\u0014\u0001\u00058v[\u000e{Gn\u001d)sK\u001aL\u0007pS3z\u000359W\r\u001e'bi\u0016\u001cH\u000fR1uCR\u00111)\u0016\t\u0004\t.seBA#J!\t1\u0015(D\u0001H\u0015\tA%$\u0001\u0004=e>|GOP\u0005\u0003\u0015f\na\u0001\u0015:fI\u00164\u0017B\u0001'N\u0005\r\u0019V\r\u001e\u0006\u0003\u0015f\u0002B\u0001O(Ro%\u0011\u0001+\u000f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\taz%k\u000e\t\u0003\tNK!\u0001V'\u0003\rM#(/\u001b8h\u0011\u00151f\u00011\u0001!\u00035\u0019Ho\u001c:f!J|g/\u001b3fe\u00069q-\u001a;ECR\fGcA\"Z7\")!l\u0002a\u0001A\u0005A\u0001O]8wS\u0012,'\u000fC\u0004]\u000fA\u0005\t\u0019A\u001c\u0002\u000fY,'o]5p]\u0006\tr-\u001a;ECR\fG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003}S#a\u000e1,\u0003\u0005\u0004\"AY4\u000e\u0003\rT!\u0001Z3\u0002\u0013Ut7\r[3dW\u0016$'B\u00014:\u0003)\tgN\\8uCRLwN\\\u0005\u0003Q\u000e\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f)\r\u0001#\u000e\u001c\u0005\u0006W&\u0001\raN\u0001\u0015[&tG)\u001a7uCN4uN]*oCB\u001c\bn\u001c;\t\u000b5L\u0001\u0019A\u001c\u000239,Xn\u00144WKJ\u001cHk\u001c*fi\u0006Lg.\u00138NK6|'/_\u0001\u0012O\u0016$H)\u001a4bk2$8+\u0015'D_:4Gc\u00019woB\u0011\u0011\u000f^\u0007\u0002e*\u00111OE\u0001\tS:$XM\u001d8bY&\u0011QO\u001d\u0002\b'Fc5i\u001c8g\u0011\u0015Y'\u00021\u00018\u0011\u0015i'\u00021\u00018Q\t\u0001\u0011\u0010\u0005\u0002{{6\t1P\u0003\u0002})\u0005!A/Y4t\u0013\tq8PA\bFqR,g\u000eZ3e'FcE+Z:u\u0001")
public class RocksDBStateStoreSuite
extends StateStoreSuiteBase<RocksDBStateStoreProvider>
implements BeforeAndAfter {
    private AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    @Override
    public RocksDBStateStoreProvider newStoreProvider() {
        return this.newStoreProvider(new StateStoreId(StateStoreTestsHelper$.MODULE$.newDir(), (long)Random$.MODULE$.nextInt(), 0, StateStoreId$.MODULE$.apply$default$4()));
    }

    @Override
    public RocksDBStateStoreProvider newStoreProvider(StateStoreId storeId) {
        return this.newStoreProvider(storeId, 0);
    }

    @Override
    public RocksDBStateStoreProvider newStoreProvider(int numPrefixCols) {
        return this.newStoreProvider(new StateStoreId(StateStoreTestsHelper$.MODULE$.newDir(), (long)Random$.MODULE$.nextInt(), 0, StateStoreId$.MODULE$.apply$default$4()), numPrefixCols);
    }

    /*
     * WARNING - void declaration
     */
    public RocksDBStateStoreProvider newStoreProvider(StateStoreId storeId, int numColsPrefixKey) {
        void var3_3;
        RocksDBStateStoreProvider provider = new RocksDBStateStoreProvider();
        provider.init(storeId, this.keySchema(), this.valueSchema(), numColsPrefixKey, new StateStoreConf(), new Configuration());
        return var3_3;
    }

    @Override
    public Set<Tuple2<Tuple2<String, Object>, Object>> getLatestData(RocksDBStateStoreProvider storeProvider) {
        return this.getData(storeProvider, -1);
    }

    @Override
    public Set<Tuple2<Tuple2<String, Object>, Object>> getData(RocksDBStateStoreProvider provider, int version) {
        return (Set)this.tryWithProviderResource(this.newStoreProvider(provider.stateStoreId()), (Function1 & Serializable)reloadedProvider -> {
            long versionToRead = version < 0 ? reloadedProvider.latestVersion() : (long)version;
            return reloadedProvider.getStore(versionToRead).iterator().map((Function1 & Serializable)row -> StateStoreTestsHelper$.MODULE$.rowPairToDataPair((UnsafeRowPair)row)).toSet();
        });
    }

    public int getData$default$2() {
        return -1;
    }

    @Override
    public RocksDBStateStoreProvider newStoreProvider(int minDeltasForSnapshot, int numOfVersToRetainInMemory) {
        return this.newStoreProvider();
    }

    @Override
    public SQLConf getDefaultSQLConf(int minDeltasForSnapshot, int numOfVersToRetainInMemory) {
        return new SQLConf();
    }

    public static final /* synthetic */ void $anonfun$new$7(SparkSession spark$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        spark$1.conf().set(k, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$new$9(Method x$2) {
        return x$2.getName().contains("dbInstance");
    }

    public static final /* synthetic */ boolean $anonfun$new$11(StateStoreCustomMetric customMetric$1, Tuple2 x$3) {
        String string = ((StateStoreCustomMetric)x$3._1()).name();
        String string2 = customMetric$1.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final long getCustomMetric$1(StateStoreMetrics metrics, StateStoreCustomMetric customMetric) {
        Option metricPair = metrics.customMetrics().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)RocksDBStateStoreSuite.$anonfun$new$11(customMetric, x$3)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(metricPair.isDefined(), "metricPair.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBStateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        return ((Tuple2)metricPair.get())._2$mcJ$sp();
    }

    public RocksDBStateStoreSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            StateStore$.MODULE$.stop();
            Predef$.MODULE$.require(!StateStore$.MODULE$.isMaintenanceRunning());
        }, new Position("RocksDBStateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        this.after((Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            StateStore$.MODULE$.stop();
            Predef$.MODULE$.require(!StateStore$.MODULE$.isMaintenanceRunning());
        }, new Position("RocksDBStateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        this.test("version encoding", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.tryWithProviderResource(this.newStoreProvider(), (Function1 & Serializable)provider -> {
            StateStore store = provider.getStore(0L);
            UnsafeRow keyRow = StateStoreTestsHelper$.MODULE$.dataToKeyRow("a", 0);
            UnsafeRow valueRow = StateStoreTestsHelper$.MODULE$.dataToValueRow(1);
            store.put(keyRow, valueRow);
            Iterator iter = provider.rocksDB().iterator();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(iter.hasNext(), "iter.hasNext", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBStateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            ByteArrayPair kv = (ByteArrayPair)iter.next();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToByte((byte)Platform.getByte((Object)kv.key(), (long)Platform.BYTE_ARRAY_OFFSET)));
            byte $org_scalatest_assert_macro_right = RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_VERSION();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBStateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToByte((byte)Platform.getByte((Object)kv.value(), (long)Platform.BYTE_ARRAY_OFFSET)));
            byte $org_scalatest_assert_macro_right2 = RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_VERSION();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBStateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        }), new Position("RocksDBStateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("RocksDB confs are passed correctly from SparkSession to db instance", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf sparkConf = new SparkConf().setMaster("local").setAppName(this.getClass().getSimpleName());
            return (Assertion)LocalSparkSession$.MODULE$.withSparkSession(SparkSession$.MODULE$.builder().config(sparkConf).getOrCreate(), (Function1 & Serializable)spark -> {
                Seq testConfs = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"spark.sql.streaming.stateStore.providerClass", (Object)RocksDBStateStoreProvider.class.getName()), new Tuple2((Object)new StringBuilder(16).append(RocksDBConf$.MODULE$.ROCKSDB_SQL_CONF_NAME_PREFIX()).append(".compactOnCommit").toString(), (Object)"true"), new Tuple2((Object)new StringBuilder(21).append(RocksDBConf$.MODULE$.ROCKSDB_SQL_CONF_NAME_PREFIX()).append(".lockAcquireTimeoutMs").toString(), (Object)"10"), new Tuple2((Object)new StringBuilder(13).append(RocksDBConf$.MODULE$.ROCKSDB_SQL_CONF_NAME_PREFIX()).append(".maxOpenFiles").toString(), (Object)"1000"), new Tuple2((Object)SQLConf$.MODULE$.STATE_STORE_ROCKSDB_FORMAT_VERSION().key(), (Object)"4")}));
                testConfs.foreach((Function1 & Serializable)x0$1 -> {
                    RocksDBStateStoreSuite.$anonfun$new$7(spark, x0$1);
                    return BoxedUnit.UNIT;
                });
                RDD testRDD = spark.sparkContext().makeRDD((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), 1, ClassTag$.MODULE$.apply(String.class));
                StructType testSchema = StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("key", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4())})));
                StatefulOperatorStateInfo testStateInfo = new StatefulOperatorStateInfo(Utils$.MODULE$.createTempDir().getAbsolutePath(), UUID.randomUUID(), 0L, 0L, 5);
                RocksDBConf rocksDBConfInTask = (RocksDBConf)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.StateStoreOps(testRDD, ClassTag$.MODULE$.apply(String.class)).mapPartitionsWithStateStore(spark.sqlContext(), testStateInfo, testSchema, testSchema, 0, (Function2 & Serializable)(store, x$1) -> {
                    Method dbInstanceMethod = (Method)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])store.getClass().getMethods()), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)RocksDBStateStoreSuite.$anonfun$new$9(x$2)))));
                    return scala.package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new RocksDBConf[]{((RocksDB)dbInstanceMethod.invoke(store, new Object[0])).conf()}));
                }, ClassTag$.MODULE$.apply(RocksDBConf.class)).collect()));
                boolean $org_scalatest_assert_macro_left = rocksDBConfInTask.compactOnCommit();
                boolean $org_scalatest_assert_macro_right = true;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBStateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
                long $org_scalatest_assert_macro_left2 = rocksDBConfInTask.lockAcquireTimeoutMs();
                long $org_scalatest_assert_macro_right2 = 10L;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBStateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
                int $org_scalatest_assert_macro_left3 = rocksDBConfInTask.formatVersion();
                int $org_scalatest_assert_macro_right3 = 4;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBStateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
                int $org_scalatest_assert_macro_left4 = rocksDBConfInTask.maxOpenFiles();
                int $org_scalatest_assert_macro_right4 = 1000;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBStateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            });
        }, new Position("RocksDBStateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("rocksdb file manager metrics exposed", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.tryWithProviderResource(this.newStoreProvider(), (Function1 & Serializable)provider -> {
            StateStore store = provider.getStore(0L);
            StateStoreTestsHelper$.MODULE$.put(store, "a", 0, 1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(StateStoreTestsHelper$.MODULE$.get((ReadStateStore)store, "a", 0));
            Some $org_scalatest_assert_macro_right = new Some((Object)BoxesRunTime.boxToInteger((int)1));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBStateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)store.commit()));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBStateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(store.hasCommitted(), "store.hasCommitted", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBStateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            StateStoreMetrics storeMetrics = store.metrics();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)storeMetrics.numKeys()));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBStateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
            long $org_scalatest_assert_macro_left4 = RocksDBStateStoreSuite.getCustomMetric$1(storeMetrics, (StateStoreCustomMetric)RocksDBStateStoreProvider$.MODULE$.CUSTOM_METRIC_FILES_COPIED());
            long $org_scalatest_assert_macro_right4 = 0L;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 > $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBStateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
            long $org_scalatest_assert_macro_left5 = RocksDBStateStoreSuite.getCustomMetric$1(storeMetrics, (StateStoreCustomMetric)RocksDBStateStoreProvider$.MODULE$.CUSTOM_METRIC_FILES_REUSED());
            long $org_scalatest_assert_macro_right5 = 0L;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBStateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            long $org_scalatest_assert_macro_left6 = RocksDBStateStoreSuite.getCustomMetric$1(storeMetrics, (StateStoreCustomMetric)RocksDBStateStoreProvider$.MODULE$.CUSTOM_METRIC_BYTES_COPIED());
            long $org_scalatest_assert_macro_right6 = 0L;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left6), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 > $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBStateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
            long $org_scalatest_assert_macro_left7 = RocksDBStateStoreSuite.getCustomMetric$1(storeMetrics, (StateStoreCustomMetric)RocksDBStateStoreProvider$.MODULE$.CUSTOM_METRIC_ZIP_FILE_BYTES_UNCOMPRESSED());
            long $org_scalatest_assert_macro_right7 = 0L;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left7), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 > $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("RocksDBStateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        }), new Position("RocksDBStateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        Statics.releaseFence();
    }
}

