/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.SortedMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.LocalSparkContext$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.streaming.CreateAtomicTestManager;
import org.apache.spark.sql.execution.streaming.CreateAtomicTestManager$;
import org.apache.spark.sql.execution.streaming.MemoryStream;
import org.apache.spark.sql.execution.streaming.MemoryStream$;
import org.apache.spark.sql.execution.streaming.state.HDFSBackedStateStoreMap;
import org.apache.spark.sql.execution.streaming.state.HDFSBackedStateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.RenameLikeHDFSFileSystem;
import org.apache.spark.sql.execution.streaming.state.RenameReturnsFalseFileSystem;
import org.apache.spark.sql.execution.streaming.state.RenameReturnsFalseFileSystem$;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf$;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorSuite$;
import org.apache.spark.sql.execution.streaming.state.StateStoreCustomMetric;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreId$;
import org.apache.spark.sql.execution.streaming.state.StateStoreMetrics;
import org.apache.spark.sql.execution.streaming.state.StateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.execution.streaming.state.StateStoreSuiteBase;
import org.apache.spark.sql.execution.streaming.state.StateStoreTestsHelper$;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.tags.ExtendedSQLTest;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.PrivateMethodTester;
import org.scalatest.Status;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.time.Span;
import org.scalatest.time.Span$;
import org.scalatest.time.SpanSugar$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ExtendedSQLTest
@ScalaSignature(bytes="\u0006\u0005\u0005ee\u0001\u0002\n\u0014\u0001\tBQ\u0001\r\u0001\u0005\u0002EBQa\r\u0001\u0005BQBQa\r\u0001\u0005BUBQa\r\u0001\u0005BmBQA\u0012\u0001\u0005B\u001dCQ\u0001\u0018\u0001\u0005BuCQA\u0019\u0001\u0005B\rDQa\r\u0001\u0005\u00021D\u0011\"!\u0003\u0001#\u0003%\t!a\u0003\t\u0013\u0005\u0005\u0002!%A\u0005\u0002\u0005\r\u0002\"CA\u0014\u0001E\u0005I\u0011AA\u0006\u0011%\tI\u0003AI\u0001\n\u0003\tY\u0001C\u0005\u0002,\u0001\t\n\u0011\"\u0001\u0002.!11\u0007\u0001C!\u0003cAq!a\u000e\u0001\t\u0003\tI\u0004C\u0004\u0002h\u0001!\t!!\u001b\t\u000f\u0005e\u0004\u0001\"\u0001\u0002|\ty1\u000b^1uKN#xN]3Tk&$XM\u0003\u0002\u0015+\u0005)1\u000f^1uK*\u0011acF\u0001\ngR\u0014X-Y7j]\u001eT!\u0001G\r\u0002\u0013\u0015DXmY;uS>t'B\u0001\u000e\u001c\u0003\r\u0019\u0018\u000f\u001c\u0006\u00039u\tQa\u001d9be.T!AH\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0013aA8sO\u000e\u00011c\u0001\u0001$UA\u0019A%J\u0014\u000e\u0003MI!AJ\n\u0003'M#\u0018\r^3Ti>\u0014XmU;ji\u0016\u0014\u0015m]3\u0011\u0005\u0011B\u0013BA\u0015\u0014\u0005qAEIR*CC\u000e\\W\rZ*uCR,7\u000b^8sKB\u0013xN^5eKJ\u0004\"a\u000b\u0018\u000e\u00031R!!L\u0010\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018BA\u0018-\u00059\u0011UMZ8sK\u0006sG-\u00114uKJ\fa\u0001P5oSRtD#\u0001\u001a\u0011\u0005\u0011\u0002\u0011\u0001\u00058foN#xN]3Qe>4\u0018\u000eZ3s)\u00059CCA\u00147\u0011\u001594\u00011\u00019\u0003\u001d\u0019Ho\u001c:f\u0013\u0012\u0004\"\u0001J\u001d\n\u0005i\u001a\"\u0001D*uCR,7\u000b^8sK&#GcA\u0014=\t\")Q\b\u0002a\u0001}\u0005!R.\u001b8EK2$\u0018m\u001d$peNs\u0017\r]:i_R\u0004\"a\u0010\"\u000e\u0003\u0001S\u0011!Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0007\u0002\u00131!\u00138u\u0011\u0015)E\u00011\u0001?\u0003eqW/\\(g-\u0016\u00148\u000fV8SKR\f\u0017N\\%o\u001b\u0016lwN]=\u0002\u001b\u001d,G\u000fT1uKN$H)\u0019;b)\tA%\fE\u0002J!Ns!A\u0013(\u0011\u0005-\u0003U\"\u0001'\u000b\u00055\u000b\u0013A\u0002\u001fs_>$h(\u0003\u0002P\u0001\u00061\u0001K]3eK\u001aL!!\u0015*\u0003\u0007M+GO\u0003\u0002P\u0001B!q\b\u0016,?\u0013\t)\u0006I\u0001\u0004UkBdWM\r\t\u0005\u007fQ;f\b\u0005\u0002J1&\u0011\u0011L\u0015\u0002\u0007'R\u0014\u0018N\\4\t\u000bm+\u0001\u0019A\u0014\u0002\u001bM$xN]3Qe>4\u0018\u000eZ3s\u0003\u001d9W\r\u001e#bi\u0006$2\u0001\u00130a\u0011\u0015yf\u00011\u0001(\u0003!\u0001(o\u001c<jI\u0016\u0014\b\"B1\u0007\u0001\u0004q\u0014a\u0002<feNLwN\\\u0001\u0012O\u0016$H)\u001a4bk2$8+\u0015'D_:4Gc\u00013kWB\u0011Q\r[\u0007\u0002M*\u0011q-G\u0001\tS:$XM\u001d8bY&\u0011\u0011N\u001a\u0002\b'Fc5i\u001c8g\u0011\u0015it\u00011\u0001?\u0011\u0015)u\u00011\u0001?)!9SN\u001d;wqfT\b\"\u00028\t\u0001\u0004y\u0017\u0001B8q\u0013\u0012\u0004\"a\u00109\n\u0005E\u0004%\u0001\u0002'p]\u001eDQa\u001d\u0005A\u0002y\n\u0011\u0002]1si&$\u0018n\u001c8\t\u000fUD\u0001\u0013!a\u0001}\u0005\u0001b.^7D_2\u001c\bK]3gSb\\U-\u001f\u0005\bo\"\u0001\n\u00111\u0001X\u0003\r!\u0017N\u001d\u0005\b{!\u0001\n\u00111\u0001?\u0011\u001d)\u0005\u0002%AA\u0002yBqa\u001f\u0005\u0011\u0002\u0003\u0007A0\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u00042!`A\u0003\u001b\u0005q(bA@\u0002\u0002\u0005!1m\u001c8g\u0015\r\t\u0019!H\u0001\u0007Q\u0006$wn\u001c9\n\u0007\u0005\u001daPA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u001b]\u0016<8\u000b^8sKB\u0013xN^5eKJ$C-\u001a4bk2$HeM\u000b\u0003\u0003\u001bQ3APA\bW\t\t\t\u0002\u0005\u0003\u0002\u0014\u0005uQBAA\u000b\u0015\u0011\t9\"!\u0007\u0002\u0013Ut7\r[3dW\u0016$'bAA\u000e\u0001\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0011Q\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017A\u00078foN#xN]3Qe>4\u0018\u000eZ3sI\u0011,g-Y;mi\u0012\"TCAA\u0013U\r9\u0016qB\u0001\u001b]\u0016<8\u000b^8sKB\u0013xN^5eKJ$C-\u001a4bk2$H%N\u0001\u001b]\u0016<8\u000b^8sKB\u0013xN^5eKJ$C-\u001a4bk2$HEN\u0001\u001b]\u0016<8\u000b^8sKB\u0013xN^5eKJ$C-\u001a4bk2$HeN\u000b\u0003\u0003_Q3\u0001`A\b)\r9\u00131\u0007\u0005\u0007\u0003kq\u0001\u0019\u0001 \u0002\u001b9,X\u000e\u0015:fM&D8i\u001c7t\u0003M\u0019\u0007.Z2l\u0019>\fG-\u001a3WKJ\u001c\u0018n\u001c8t))\tY$!\u0011\u0002\\\u0005}\u00131\r\t\u0004\u007f\u0005u\u0012bAA \u0001\n!QK\\5u\u0011\u001d\t\u0019e\u0004a\u0001\u0003\u000b\n!\u0002\\8bI\u0016$W*\u00199t!\u001d\t9%!\u0015p\u0003+j!!!\u0013\u000b\t\u0005-\u0013QJ\u0001\u0005kRLGN\u0003\u0002\u0002P\u0005!!.\u0019<b\u0013\u0011\t\u0019&!\u0013\u0003\u0013M{'\u000f^3e\u001b\u0006\u0004\bc\u0001\u0013\u0002X%\u0019\u0011\u0011L\n\u0003/!#ei\u0015\"bG.,Gm\u0015;bi\u0016\u001cFo\u001c:f\u001b\u0006\u0004\bBBA/\u001f\u0001\u0007a(A\u0003d_VtG\u000f\u0003\u0004\u0002b=\u0001\ra\\\u0001\fK\u0006\u0014H.[3ti.+\u0017\u0010\u0003\u0004\u0002f=\u0001\ra\\\u0001\nY\u0006$Xm\u001d;LKf\fAb\u00195fG.4VM]:j_:$\u0002\"a\u000f\u0002l\u00055\u0014q\u000e\u0005\b\u0003\u0007\u0002\u0002\u0019AA#\u0011\u0015\t\u0007\u00031\u0001p\u0011\u001d\t\t\b\u0005a\u0001\u0003g\nA\"\u001a=qK\u000e$X\r\u001a#bi\u0006\u0004R!SA;-zJ1!a\u001eS\u0005\ri\u0015\r]\u0001\fG>\u0014(/\u001e9u\r&dW\r\u0006\u0005\u0002<\u0005u\u0014qPAA\u0011\u0015y\u0016\u00031\u0001(\u0011\u0015\t\u0017\u00031\u0001p\u0011\u001d\t\u0019)\u0005a\u0001\u0003\u000b\u000b!\"[:T]\u0006\u00048\u000f[8u!\ry\u0014qQ\u0005\u0004\u0003\u0013\u0003%a\u0002\"p_2,\u0017M\u001c\u0015\u0004\u0001\u00055\u0005\u0003BAH\u0003+k!!!%\u000b\u0007\u0005M5$\u0001\u0003uC\u001e\u001c\u0018\u0002BAL\u0003#\u0013q\"\u0012=uK:$W\rZ*R\u0019R+7\u000f\u001e")
public class StateStoreSuite
extends StateStoreSuiteBase<HDFSBackedStateStoreProvider>
implements BeforeAndAfter {
    private AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    @Override
    public HDFSBackedStateStoreProvider newStoreProvider() {
        return this.newStoreProvider(Random$.MODULE$.nextInt(), 0, this.newStoreProvider$default$3(), this.newStoreProvider$default$4(), this.newStoreProvider$default$5(), this.newStoreProvider$default$6(), this.newStoreProvider$default$7());
    }

    @Override
    public HDFSBackedStateStoreProvider newStoreProvider(StateStoreId storeId) {
        long x$1 = storeId.operatorId();
        int x$2 = storeId.partitionId();
        String x$3 = storeId.checkpointRootLocation();
        int x$4 = this.newStoreProvider$default$3();
        int x$5 = this.newStoreProvider$default$5();
        int x$6 = this.newStoreProvider$default$6();
        Configuration x$7 = this.newStoreProvider$default$7();
        return this.newStoreProvider(x$1, x$2, x$4, x$3, x$5, x$6, x$7);
    }

    @Override
    public HDFSBackedStateStoreProvider newStoreProvider(int minDeltasForSnapshot, int numOfVersToRetainInMemory) {
        long x$1 = Random$.MODULE$.nextInt();
        boolean x$2 = false;
        int x$3 = minDeltasForSnapshot;
        int x$4 = numOfVersToRetainInMemory;
        int x$5 = this.newStoreProvider$default$3();
        String x$6 = this.newStoreProvider$default$4();
        Configuration x$7 = this.newStoreProvider$default$7();
        return this.newStoreProvider(x$1, 0, x$5, x$6, x$3, x$4, x$7);
    }

    @Override
    public Set<Tuple2<Tuple2<String, Object>, Object>> getLatestData(HDFSBackedStateStoreProvider storeProvider) {
        return this.getData(storeProvider, -1);
    }

    @Override
    public Set<Tuple2<Tuple2<String, Object>, Object>> getData(HDFSBackedStateStoreProvider provider, int version) {
        return (Set)this.tryWithProviderResource(this.newStoreProvider(provider.stateStoreId()), (Function1 & Serializable)reloadedProvider -> version < 0 ? reloadedProvider.latestIterator().map((Function1 & Serializable)row -> StateStoreTestsHelper$.MODULE$.rowPairToDataPair((UnsafeRowPair)row)).toSet() : reloadedProvider.getStore((long)version).iterator().map((Function1 & Serializable)row -> StateStoreTestsHelper$.MODULE$.rowPairToDataPair((UnsafeRowPair)row)).toSet());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SQLConf getDefaultSQLConf(int minDeltasForSnapshot, int numOfVersToRetainInMemory) {
        void var3_3;
        SQLConf sqlConf = new SQLConf();
        sqlConf.setConf(SQLConf$.MODULE$.STATE_STORE_MIN_DELTAS_FOR_SNAPSHOT(), (Object)BoxesRunTime.boxToInteger((int)minDeltasForSnapshot));
        sqlConf.setConf(SQLConf$.MODULE$.MAX_BATCHES_TO_RETAIN_IN_MEMORY(), (Object)BoxesRunTime.boxToInteger((int)numOfVersToRetainInMemory));
        sqlConf.setConf(SQLConf$.MODULE$.MIN_BATCHES_TO_RETAIN(), (Object)BoxesRunTime.boxToInteger((int)2));
        sqlConf.setConf(SQLConf$.MODULE$.STATE_STORE_COMPRESSION_CODEC(), (Object)SQLConf$.MODULE$.get().stateStoreCompressionCodec());
        return var3_3;
    }

    public HDFSBackedStateStoreProvider newStoreProvider(long opId, int partition, int numColsPrefixKey, String dir, int minDeltasForSnapshot, int numOfVersToRetainInMemory, Configuration hadoopConf) {
        SQLConf sqlConf = this.getDefaultSQLConf(minDeltasForSnapshot, numOfVersToRetainInMemory);
        HDFSBackedStateStoreProvider provider = new HDFSBackedStateStoreProvider();
        provider.init(new StateStoreId(dir, opId, partition, StateStoreId$.MODULE$.apply$default$4()), this.keySchema(), this.valueSchema(), numColsPrefixKey, new StateStoreConf(sqlConf, StateStoreConf$.MODULE$.$lessinit$greater$default$2()), hadoopConf);
        return provider;
    }

    @Override
    public HDFSBackedStateStoreProvider newStoreProvider(int numPrefixCols) {
        return this.newStoreProvider(Random$.MODULE$.nextInt(), 0, numPrefixCols, this.newStoreProvider$default$4(), this.newStoreProvider$default$5(), this.newStoreProvider$default$6(), this.newStoreProvider$default$7());
    }

    public int newStoreProvider$default$3() {
        return 0;
    }

    public String newStoreProvider$default$4() {
        return StateStoreTestsHelper$.MODULE$.newDir();
    }

    public int newStoreProvider$default$5() {
        return BoxesRunTime.unboxToInt((Object)SQLConf$.MODULE$.STATE_STORE_MIN_DELTAS_FOR_SNAPSHOT().defaultValue().get());
    }

    public int newStoreProvider$default$6() {
        return BoxesRunTime.unboxToInt((Object)SQLConf$.MODULE$.MAX_BATCHES_TO_RETAIN_IN_MEMORY().defaultValue().get());
    }

    public Configuration newStoreProvider$default$7() {
        return new Configuration();
    }

    public void checkLoadedVersions(SortedMap<Object, HDFSBackedStateStoreMap> loadedMaps, int count, long earliestKey, long latestKey) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedMaps.size()));
        int $org_scalatest_assert_macro_right = count;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 811));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(loadedMaps.firstKey());
        long $org_scalatest_assert_macro_right2 = earliestKey;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 812));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(loadedMaps.lastKey());
        long $org_scalatest_assert_macro_right3 = latestKey;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 813));
    }

    public void checkVersion(SortedMap<Object, HDFSBackedStateStoreMap> loadedMaps, long version, Map<Tuple2<String, Object>, Object> expectedData) {
        Map originValueMap = ((HDFSBackedStateStoreMap)loadedMaps.get(BoxesRunTime.boxToLong((long)version))).iterator().map((Function1 & Serializable)entry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(StateStoreTestsHelper$.MODULE$.keyRowToData(entry.key())), (Object)BoxesRunTime.boxToInteger((int)StateStoreTestsHelper$.MODULE$.valueRowToData(entry.value())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(originValueMap);
        Map<Tuple2<String, Object>, Object> $org_scalatest_assert_macro_right = expectedData;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 824));
    }

    public void corruptFile(HDFSBackedStateStoreProvider provider, long version, boolean isSnapshot) {
        PrivateMethodTester.PrivateMethod method = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "baseDir"));
        Path basePath = (Path)this.anyRefToInvoker(provider).invokePrivate(method.apply((Seq)Nil$.MODULE$));
        String fileName = isSnapshot ? new StringBuilder(9).append(version).append(".snapshot").toString() : new StringBuilder(6).append(version).append(".delta").toString();
        File filePath = new File(basePath.toString(), fileName);
        filePath.delete();
        filePath.createNewFile();
    }

    public static final /* synthetic */ void $anonfun$new$4(StateStoreSuite $this, HDFSBackedStateStoreProvider provider) {
        int currentVersion = 0;
        currentVersion = $this.incrementVersion((StateStoreProvider)provider, currentVersion);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.getLatestData(provider));
        Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        SortedMap loadedMaps = provider.getLoadedMaps();
        $this.checkLoadedVersions(loadedMaps, 1, 1L, 1L);
        $this.checkVersion(loadedMaps, 1L, (Map<Tuple2<String, Object>, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}))));
        currentVersion = $this.incrementVersion((StateStoreProvider)provider, currentVersion);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer($this.getLatestData(provider));
        Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2))}));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        loadedMaps = provider.getLoadedMaps();
        $this.checkLoadedVersions(loadedMaps, 2, 2L, 1L);
        $this.checkVersion(loadedMaps, 2L, (Map<Tuple2<String, Object>, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2))}))));
        $this.checkVersion(loadedMaps, 1L, (Map<Tuple2<String, Object>, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}))));
        currentVersion = $this.incrementVersion((StateStoreProvider)provider, currentVersion);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer($this.getLatestData(provider));
        Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)3))}));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        loadedMaps = provider.getLoadedMaps();
        $this.checkLoadedVersions(loadedMaps, 2, 3L, 2L);
        $this.checkVersion(loadedMaps, 3L, (Map<Tuple2<String, Object>, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)3))}))));
        $this.checkVersion(loadedMaps, 2L, (Map<Tuple2<String, Object>, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2))}))));
    }

    public static final /* synthetic */ void $anonfun$new$6(StateStoreSuite $this, HDFSBackedStateStoreProvider provider) {
        int currentVersion = 0;
        currentVersion = $this.incrementVersion((StateStoreProvider)provider, currentVersion);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.getLatestData(provider));
        Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        SortedMap loadedMaps = provider.getLoadedMaps();
        $this.checkLoadedVersions(loadedMaps, 1, 1L, 1L);
        $this.checkVersion(loadedMaps, 1L, (Map<Tuple2<String, Object>, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}))));
        currentVersion = $this.incrementVersion((StateStoreProvider)provider, currentVersion);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer($this.getLatestData(provider));
        Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2))}));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        loadedMaps = provider.getLoadedMaps();
        $this.checkLoadedVersions(loadedMaps, 1, 2L, 2L);
        $this.checkVersion(loadedMaps, 2L, (Map<Tuple2<String, Object>, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2))}))));
        currentVersion = 1;
        StateStore store = provider.getStore((long)currentVersion);
        StateStoreTestsHelper$.MODULE$.put(store, "a", 0, -2);
        store.commit();
        ++currentVersion;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer($this.getLatestData(provider));
        Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)-2))}));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        loadedMaps = provider.getLoadedMaps();
        $this.checkLoadedVersions(loadedMaps, 1, 2L, 2L);
        $this.checkVersion(loadedMaps, 2L, (Map<Tuple2<String, Object>, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)-2))}))));
    }

    public static final /* synthetic */ boolean $anonfun$new$15(File x$1) {
        return x$1.getName().startsWith("temp-");
    }

    public static final /* synthetic */ boolean $anonfun$new$25(Tuple2 x$2) {
        String string = ((StateStoreCustomMetric)x$2._1()).name();
        String string2 = "stateOnCurrentVersionSizeBytes";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final long getSizeOfStateForCurrentVersion$1(StateStoreMetrics metrics) {
        Option metricPair = metrics.customMetrics().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$25(x$2)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(metricPair.isDefined(), "metricPair.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
        return ((Tuple2)metricPair.get())._2$mcJ$sp();
    }

    private final void generateStoreVersions$1(StateStoreProviderId storeProviderId1$1, IntRef latestStoreVersion$1, StateStoreConf storeConf$1, Configuration hadoopConf$1) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            StateStore store = StateStore$.MODULE$.get(storeProviderId1$1, this.keySchema(), this.valueSchema(), 0, (long)latestStoreVersion$1.elem, storeConf$1, hadoopConf$1);
            StateStoreTestsHelper$.MODULE$.put(store, "a", 0, i);
            store.commit();
            ++latestStoreVersion$1.elem;
        });
    }

    public static final /* synthetic */ void $anonfun$new$31(StateStoreSuite $this, Span timeoutDuration$1, StateStoreProviderId storeProviderId1$1, IntRef latestStoreVersion$1, StateStoreConf storeConf$1, Configuration hadoopConf$1, StateStoreProviderId storeProviderId2$1, StateStoreCoordinatorRef coordinatorRef) {
        Predef$.MODULE$.require(!StateStore$.MODULE$.isMaintenanceRunning(), (Function0 & Serializable)() -> "StateStore is unexpectedly running");
        $this.generateStoreVersions$1(storeProviderId1$1, latestStoreVersion$1, storeConf$1, hadoopConf$1);
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$1), (Function0 & Serializable)() -> {
            Option $org_scalatest_assert_macro_left = coordinatorRef.getLocation(storeProviderId1$1);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"active instance was not reported", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isMaintenanceRunning(), "StateStore.isMaintenanceRunning", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Maintenance task is not running", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
            return (Assertion)$this.tryWithProviderResource($this.newStoreProvider(storeProviderId1$1.storeId()), (Function1 & Serializable)provider -> {
                IndexedSeq snapshotVersions;
                IndexedSeq $org_scalatest_assert_macro_left = snapshotVersions = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), latestStoreVersion$1.elem).filter((Function1)(JFunction1.mcZI.sp & Serializable)version -> $this.fileExists(provider, version, true));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"no snapshot file found", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
            });
        }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
        $this.generateStoreVersions$1(storeProviderId1$1, latestStoreVersion$1, storeConf$1, hadoopConf$1);
        $this.tryWithProviderResource($this.newStoreProvider(storeProviderId1$1.storeId()), (Function1 & Serializable)provider -> (Assertion)Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$1), (Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.fileExists(provider, 1L, false), "StateStoreSuite.this.fileExists(provider, 1L, false)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"earliest file not deleted", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
        }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312)));
        coordinatorRef.deactivateInstances(storeProviderId1$1.queryRunId());
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$1), (Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId1$1), "StateStore.isLoaded(storeProviderId1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
        }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
        StateStore$.MODULE$.get(storeProviderId1$1, $this.keySchema(), $this.valueSchema(), 0, (long)latestStoreVersion$1.elem, storeConf$1, hadoopConf$1);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId1$1), "StateStore.isLoaded(storeProviderId1)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
        coordinatorRef.reportActiveInstance(storeProviderId1$1, "other-host", "other-exec", (Seq)scala.package$.MODULE$.Seq().empty());
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$1), (Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId1$1), "StateStore.isLoaded(storeProviderId1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
        }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332));
        StateStore$.MODULE$.get(storeProviderId1$1, $this.keySchema(), $this.valueSchema(), 0, (long)latestStoreVersion$1.elem, storeConf$1, hadoopConf$1);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId1$1), "StateStore.isLoaded(storeProviderId1)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
        coordinatorRef.reportActiveInstance(storeProviderId1$1, "other-host", "other-exec", (Seq)scala.package$.MODULE$.Seq().empty());
        StateStore$.MODULE$.get(storeProviderId2$1, $this.keySchema(), $this.valueSchema(), 0, 0L, storeConf$1, hadoopConf$1);
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId1$1), "StateStore.isLoaded(storeProviderId1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId2$1), "StateStore.isLoaded(storeProviderId2)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
    }

    private final void generateStoreVersions$2(StateStoreProviderId storeProviderId1$2, IntRef latestStoreVersion$2, StateStoreConf storeConf$2, Configuration hadoopConf$2) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            StateStore store = StateStore$.MODULE$.get(storeProviderId1$2, this.keySchema(), this.valueSchema(), 0, (long)latestStoreVersion$2.elem, storeConf$2, hadoopConf$2);
            StateStoreTestsHelper$.MODULE$.put(store, "a", 0, i);
            store.commit();
            ++latestStoreVersion$2.elem;
        });
    }

    public static final /* synthetic */ void $anonfun$new$45(StateStoreSuite $this, Span timeoutDuration$2, StateStoreProviderId storeProviderId1$2, IntRef latestStoreVersion$2, StateStoreConf storeConf$2, Configuration hadoopConf$2, StateStoreCoordinatorRef coordinatorRef) {
        Predef$.MODULE$.require(!StateStore$.MODULE$.isMaintenanceRunning(), (Function0 & Serializable)() -> "StateStore is unexpectedly running");
        $this.generateStoreVersions$2(storeProviderId1$2, latestStoreVersion$2, storeConf$2, hadoopConf$2);
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$2), (Function0 & Serializable)() -> {
            Option $org_scalatest_assert_macro_left = coordinatorRef.getLocation(storeProviderId1$2);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"active instance was not reported", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isMaintenanceRunning(), "StateStore.isMaintenanceRunning", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Maintenance task is not running", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403));
            return (Assertion)$this.tryWithProviderResource($this.newStoreProvider(storeProviderId1$2.storeId()), (Function1 & Serializable)provider -> {
                IndexedSeq snapshotVersions;
                IndexedSeq $org_scalatest_assert_macro_left = snapshotVersions = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), latestStoreVersion$2.elem).filter((Function1)(JFunction1.mcZI.sp & Serializable)version -> $this.fileExists(provider, version, true));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"no snapshot file found", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
            });
        }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
        $this.generateStoreVersions$2(storeProviderId1$2, latestStoreVersion$2, storeConf$2, hadoopConf$2);
        coordinatorRef.deactivateInstances(storeProviderId1$2.queryRunId());
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$2), (Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId1$2), "StateStore.isLoaded(storeProviderId1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
        }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 418));
        $this.tryWithProviderResource($this.newStoreProvider(storeProviderId1$2.storeId()), (Function1 & Serializable)provider -> (Assertion)Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$2), (Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.fileExists(provider, 1L, false), "StateStoreSuite.this.fileExists(provider, 1L, false)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"earliest file not deleted", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
        }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$55(StateStoreSuite $this, HDFSBackedStateStoreProvider provider$7, int i) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.fileExists(provider$7, i, false), "StateStoreSuite.this.fileExists(provider, i.toLong, false)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.fileExists(provider$7, i, true), "StateStoreSuite.this.fileExists(provider, i.toLong, true)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 446));
    }

    private static final int numTempFiles$1(File deltaFileDir$1) {
        return deltaFileDir$1.exists() ? ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])deltaFileDir$1.listFiles()), (Function1 & Serializable)x$3 -> x$3.getName(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)n -> BoxesRunTime.boxToBoolean((boolean)n.endsWith(".tmp"))) : 0;
    }

    public static final /* synthetic */ boolean $anonfun$new$67(String n) {
        return n.contains(".delta") && !n.startsWith(".");
    }

    private static final int numDeltaFiles$1(File deltaFileDir$1) {
        return deltaFileDir$1.exists() ? ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])deltaFileDir$1.listFiles()), (Function1 & Serializable)x$4 -> x$4.getName(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)n -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$67(n))) : 0;
    }

    private final Object shouldNotCreateTempFile$1(Function0 body, File deltaFileDir$1) {
        int before = StateStoreSuite.numTempFiles$1(deltaFileDir$1);
        Object result = body.apply();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir$1)));
        int $org_scalatest_assert_macro_right = before;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 518));
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$new$70(Tuple2 x$5) {
        Object object = x$5._1();
        String string = "a";
        return !(object != null ? !object.equals(string) : string != null);
    }

    private final Seq runQueryAndGetLoadedProviders$1(MemoryStream inputData$1, File checkpointLocation$1) {
        Seq seq;
        HashMap loadedProvidersMap;
        Dataset aggregated = inputData$1.toDF().groupBy("value", (Seq)Nil$.MODULE$).agg((Column)functions$.MODULE$.count("*"), (Seq)Nil$.MODULE$);
        StreamingQuery query = aggregated.writeStream().format("memory").outputMode("complete").queryName("query").option("checkpointLocation", checkpointLocation$1.toString()).start();
        inputData$1.addData((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        query.processAllAvailable();
        Predef$.MODULE$.require(query.lastProgress() != null);
        PrivateMethodTester.PrivateMethod loadedProvidersMethod = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "loadedProviders"));
        HashMap hashMap = loadedProvidersMap = (HashMap)this.anyRefToInvoker(StateStore$.MODULE$).invokePrivate(loadedProvidersMethod.apply((Seq)Nil$.MODULE$));
        synchronized (hashMap) {
            seq = loadedProvidersMap.values().toSeq();
        }
        Seq loadedProviders = seq;
        query.stop();
        return loadedProviders;
    }

    public static final /* synthetic */ void $anonfun$new$73(SparkSession spark) {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])spark.streams().active()), (Function1 & Serializable)x$6 -> {
            x$6.stop();
            return BoxedUnit.UNIT;
        });
        spark.stop();
    }

    public static final /* synthetic */ String $anonfun$new$78(long x$7) {
        return Long.toString(x$7);
    }

    public static final /* synthetic */ boolean $anonfun$new$83(String name$1, Tuple2 x$8) {
        String string = ((StateStoreCustomMetric)x$8._1()).name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final long getCustomMetric$1(StateStoreMetrics metrics, String name) {
        Option metricPair = metrics.customMetrics().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$83(name, x$8)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(metricPair.isDefined(), "metricPair.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 655));
        return ((Tuple2)metricPair.get())._2$mcJ$sp();
    }

    private static final long getLoadedMapSizeMetric$1(StateStoreMetrics metrics) {
        return metrics.memoryUsedBytes();
    }

    private final void assertCacheHitAndMiss$1(StateStoreMetrics metrics, long expectedCacheHitCount, long expectedCacheMissCount) {
        long cacheHitCount = StateStoreSuite.getCustomMetric$1(metrics, "loadedMapCacheHitCount");
        long cacheMissCount = StateStoreSuite.getCustomMetric$1(metrics, "loadedMapCacheMissCount");
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)cacheHitCount));
        long $org_scalatest_assert_macro_right = expectedCacheHitCount;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 669));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)cacheMissCount));
        long $org_scalatest_assert_macro_right2 = expectedCacheMissCount;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 670));
    }

    public static final /* synthetic */ boolean $anonfun$new$85(Tuple2 x$9) {
        return ((String)x$9._1()).startsWith("a");
    }

    public static final /* synthetic */ void $anonfun$new$84(StateStoreSuite $this, ObjectRef store$3, LongRef loadedMapSizeForVersion1$1, HDFSBackedStateStoreProvider provider) {
        long loadedMapSizeForVersion1And2;
        long initialLoadedMapSize;
        Set<Tuple2<Tuple2<String, Object>, Object>> $org_scalatest_assert_macro_left = $this.getLatestData(provider);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 677));
        store$3.elem = provider.getStore(0L);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((StateStore)store$3.elem).hasCommitted(), "store.hasCommitted", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 680));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)((StateStore)store$3.elem).metrics().numKeys()));
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 682));
        long $org_scalatest_assert_macro_left3 = initialLoadedMapSize = StateStoreSuite.getLoadedMapSizeMetric$1(((StateStore)store$3.elem).metrics());
        int $org_scalatest_assert_macro_right2 = 0;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 >= (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 685));
        $this.assertCacheHitAndMiss$1(((StateStore)store$3.elem).metrics(), 0L, 0L);
        StateStoreTestsHelper$.MODULE$.put((StateStore)store$3.elem, "a", 0, 1);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)((StateStore)store$3.elem).metrics().numKeys()));
        int $org_scalatest_assert_macro_right3 = 1;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 689));
        StateStoreTestsHelper$.MODULE$.put((StateStore)store$3.elem, "b", 0, 2);
        StateStoreTestsHelper$.MODULE$.put((StateStore)store$3.elem, "aa", 0, 3);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)((StateStore)store$3.elem).metrics().numKeys()));
        int $org_scalatest_assert_macro_right4 = 3;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 693));
        StateStoreTestsHelper$.MODULE$.remove((StateStore)store$3.elem, (Function1<Tuple2<String, Object>, Object>)(Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$85(x$9)));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)((StateStore)store$3.elem).metrics().numKeys()));
        int $org_scalatest_assert_macro_right5 = 1;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 695));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)((StateStore)store$3.elem).commit()));
        int $org_scalatest_assert_macro_right6 = 1;
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 696));
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(((StateStore)store$3.elem).hasCommitted(), "store.hasCommitted", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 698));
        long $org_scalatest_assert_macro_left8 = loadedMapSizeForVersion1$1.elem = StateStoreSuite.getLoadedMapSizeMetric$1(((StateStore)store$3.elem).metrics());
        long $org_scalatest_assert_macro_right7 = initialLoadedMapSize;
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left8), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8 > $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 701));
        $this.assertCacheHitAndMiss$1(((StateStore)store$3.elem).metrics(), 0L, 0L);
        StateStore storeV2 = provider.getStore(1L);
        Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(storeV2.hasCommitted(), "storeV2.hasCommitted", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 705));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)storeV2.metrics().numKeys()));
        int $org_scalatest_assert_macro_right8 = 1;
        Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 706));
        StateStoreTestsHelper$.MODULE$.put(storeV2, "cc", 0, 4);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)storeV2.metrics().numKeys()));
        int $org_scalatest_assert_macro_right9 = 2;
        Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 709));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)storeV2.commit()));
        int $org_scalatest_assert_macro_right10 = 2;
        Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 710));
        Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(storeV2.hasCommitted(), "storeV2.hasCommitted", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 712));
        long $org_scalatest_assert_macro_left12 = loadedMapSizeForVersion1And2 = StateStoreSuite.getLoadedMapSizeMetric$1(storeV2.metrics());
        long $org_scalatest_assert_macro_right11 = loadedMapSizeForVersion1$1.elem;
        Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left12), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left12 > $org_scalatest_assert_macro_right11, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 715));
        $this.assertCacheHitAndMiss$1(storeV2.metrics(), 1L, 0L);
    }

    public static final /* synthetic */ void $anonfun$new$86(StateStoreSuite $this, LongRef loadedMapSizeForVersion1$1, HDFSBackedStateStoreProvider reloadedProvider) {
        StateStore reloadedStore = reloadedProvider.getStore(1L);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)reloadedStore.metrics().numKeys()));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 723));
        $this.assertCacheHitAndMiss$1(reloadedStore.metrics(), 0L, 1L);
        StateStore reloadedStoreV2 = reloadedProvider.getStore(2L);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)reloadedStoreV2.metrics().numKeys()));
        int $org_scalatest_assert_macro_right2 = 2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 730));
        long $org_scalatest_assert_macro_left3 = StateStoreSuite.getLoadedMapSizeMetric$1(reloadedStoreV2.metrics());
        long $org_scalatest_assert_macro_right3 = loadedMapSizeForVersion1$1.elem;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 > $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 732));
        $this.assertCacheHitAndMiss$1(reloadedStoreV2.metrics(), 0L, 2L);
    }

    public StateStoreSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            StateStore$.MODULE$.stop();
            Predef$.MODULE$.require(!StateStore$.MODULE$.isMaintenanceRunning());
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.after((Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            StateStore$.MODULE$.stop();
            Predef$.MODULE$.require(!StateStore$.MODULE$.isMaintenanceRunning());
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("retaining only two latest versions when MAX_BATCHES_TO_RETAIN_IN_MEMORY set to 2", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.tryWithProviderResource(this.newStoreProvider(10, 2), (Function1 & Serializable)provider -> {
            StateStoreSuite.$anonfun$new$4(this, provider);
            return BoxedUnit.UNIT;
        }), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("failure after committing with MAX_BATCHES_TO_RETAIN_IN_MEMORY set to 1", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            long x$1 = Random$.MODULE$.nextInt();
            boolean x$2 = false;
            boolean x$3 = true;
            int x$4 = this.newStoreProvider$default$3();
            String x$5 = this.newStoreProvider$default$4();
            int x$6 = this.newStoreProvider$default$5();
            Configuration x$7 = this.newStoreProvider$default$7();
            this.tryWithProviderResource(this.newStoreProvider(x$1, 0, x$4, x$5, x$6, 1, x$7), (Function1 & Serializable)provider -> {
                StateStoreSuite.$anonfun$new$6(this, provider);
                return BoxedUnit.UNIT;
            });
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        this.test("no cache data with MAX_BATCHES_TO_RETAIN_IN_MEMORY set to 0", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long x$8 = Random$.MODULE$.nextInt();
            boolean x$9 = false;
            boolean x$10 = false;
            int x$11 = this.newStoreProvider$default$3();
            String x$12 = this.newStoreProvider$default$4();
            int x$13 = this.newStoreProvider$default$5();
            Configuration x$14 = this.newStoreProvider$default$7();
            return (Assertion)this.tryWithProviderResource(this.newStoreProvider(x$8, 0, x$11, x$12, x$13, 0, x$14), (Function1 & Serializable)provider -> {
                int currentVersion = 0;
                currentVersion = this.incrementVersion((StateStoreProvider)provider, currentVersion);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getLatestData((HDFSBackedStateStoreProvider)provider));
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
                SortedMap loadedMaps = provider.getLoadedMaps();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedMaps.size()));
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
                currentVersion = this.incrementVersion((StateStoreProvider)provider, currentVersion);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.getLatestData((HDFSBackedStateStoreProvider)provider));
                Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2))}));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
                loadedMaps = provider.getLoadedMaps();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedMaps.size()));
                int $org_scalatest_assert_macro_right4 = 0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            });
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        this.test("cleaning", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long x$15 = Random$.MODULE$.nextInt();
            boolean x$16 = false;
            int x$17 = 5;
            int x$18 = this.newStoreProvider$default$3();
            String x$19 = this.newStoreProvider$default$4();
            int x$20 = this.newStoreProvider$default$6();
            Configuration x$21 = this.newStoreProvider$default$7();
            return (Assertion)this.tryWithProviderResource(this.newStoreProvider(x$15, 0, x$18, x$19, 5, x$20, x$21), (Function1 & Serializable)provider -> {
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    StateStore store = provider.getStore((long)(i - 1));
                    StateStoreTestsHelper$.MODULE$.put(store, "a", 0, i);
                    store.commit();
                    provider.doMaintenance();
                });
                Predef$.MODULE$.require(this.convertToEqualizer(StateStoreTestsHelper$.MODULE$.rowPairsToDataSet((Iterator<UnsafeRowPair>)provider.latestIterator())).$eq$eq$eq(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)20))})), Equality$.MODULE$.default()), (Function0 & Serializable)() -> "store not updated correctly");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.fileExists(provider, 1L, false), "StateStoreSuite.this.fileExists(provider, 1L, false)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getData((HDFSBackedStateStoreProvider)provider, 20));
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)20))}));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.getData((HDFSBackedStateStoreProvider)provider, 19));
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)19))}));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            });
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.testQuietly("SPARK-19677: Committing a delta file atop an existing one should not fail on HDFS", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Configuration conf = new Configuration();
            conf.set("fs.fake.impl", RenameLikeHDFSFileSystem.class.getName());
            conf.set("fs.defaultFS", "fake:///");
            long x$22 = Random$.MODULE$.nextInt();
            boolean x$23 = false;
            Configuration x$24 = conf;
            int x$25 = this.newStoreProvider$default$3();
            String x$26 = this.newStoreProvider$default$4();
            int x$27 = this.newStoreProvider$default$5();
            int x$28 = this.newStoreProvider$default$6();
            this.tryWithProviderResource(this.newStoreProvider(x$22, 0, x$25, x$26, x$27, x$28, x$24), (Function1 & Serializable)provider -> {
                Iterable tempFiles;
                provider.getStore(0L).commit();
                provider.getStore(0L).commit();
                Iterable $org_scalatest_assert_macro_left = tempFiles = (Iterable)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(FileUtils.listFiles((File)new File(provider.stateStoreId().checkpointRootLocation()), null, (boolean)true)).asScala()).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$15(x$1)));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
            });
        });
        this.test("corrupted file handling", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long x$29 = Random$.MODULE$.nextInt();
            boolean x$30 = false;
            int x$31 = 5;
            int x$32 = this.newStoreProvider$default$3();
            String x$33 = this.newStoreProvider$default$4();
            int x$34 = this.newStoreProvider$default$6();
            Configuration x$35 = this.newStoreProvider$default$7();
            return (Exception)this.tryWithProviderResource(this.newStoreProvider(x$29, 0, x$32, x$33, 5, x$34, x$35), (Function1 & Serializable)provider -> {
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    StateStore store = provider.getStore((long)(i - 1));
                    StateStoreTestsHelper$.MODULE$.put(store, "a", 0, i);
                    store.commit();
                    provider.doMaintenance();
                });
                int snapshotVersion = BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 10).find((Function1)(JFunction1.mcZI.sp & Serializable)version -> this.fileExists(provider, version, true)).getOrElse((Function0 & Serializable)() -> this.fail("snapshot file not found", new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209))));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getData((HDFSBackedStateStoreProvider)provider, snapshotVersion));
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)snapshotVersion))}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
                this.corruptFile((HDFSBackedStateStoreProvider)provider, snapshotVersion, true);
                this.intercept((Function0 & Serializable)() -> this.getData((HDFSBackedStateStoreProvider)provider, snapshotVersion), ClassTag$.MODULE$.apply(Exception.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.getData((HDFSBackedStateStoreProvider)provider, snapshotVersion - 1));
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)(snapshotVersion - 1)))}));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
                this.corruptFile((HDFSBackedStateStoreProvider)provider, snapshotVersion - 1, false);
                this.intercept((Function0 & Serializable)() -> this.getData((HDFSBackedStateStoreProvider)provider, snapshotVersion - 1), ClassTag$.MODULE$.apply(Exception.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
                this.deleteFilesEarlierThanVersion(provider, snapshotVersion);
                return (Exception)this.intercept((Function0 & Serializable)() -> this.getData((HDFSBackedStateStoreProvider)provider, snapshotVersion - 1), ClassTag$.MODULE$.apply(Exception.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
            });
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
        this.test("reports memory usage on current version", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.tryWithProviderResource(this.newStoreProvider(), (Function1 & Serializable)provider -> {
            StateStore store = provider.getStore(0L);
            long noDataMemoryUsed = StateStoreSuite.getSizeOfStateForCurrentVersion$1(store.metrics());
            StateStoreTestsHelper$.MODULE$.put(store, "a", 0, 1);
            store.commit();
            long $org_scalatest_assert_macro_left = StateStoreSuite.getSizeOfStateForCurrentVersion$1(store.metrics());
            long $org_scalatest_assert_macro_right = noDataMemoryUsed;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
        }), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        this.test("maintenance", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster("local").setAppName("test");
            int opId = 0;
            String dir1 = StateStoreTestsHelper$.MODULE$.newDir();
            StateStoreProviderId storeProviderId1 = new StateStoreProviderId(new StateStoreId(dir1, (long)opId, 0, StateStoreId$.MODULE$.apply$default$4()), UUID.randomUUID());
            String dir2 = StateStoreTestsHelper$.MODULE$.newDir();
            StateStoreProviderId storeProviderId2 = new StateStoreProviderId(new StateStoreId(dir2, (long)opId, 1, StateStoreId$.MODULE$.apply$default$4()), UUID.randomUUID());
            SQLConf sqlConf = this.getDefaultSQLConf(BoxesRunTime.unboxToInt((Object)SQLConf$.MODULE$.STATE_STORE_MIN_DELTAS_FOR_SNAPSHOT().defaultValue().get()), BoxesRunTime.unboxToInt((Object)SQLConf$.MODULE$.MAX_BATCHES_TO_RETAIN_IN_MEMORY().defaultValue().get()));
            sqlConf.setConf(SQLConf$.MODULE$.MIN_BATCHES_TO_RETAIN(), (Object)BoxesRunTime.boxToInteger((int)2));
            sqlConf.setConf(SQLConf$.MODULE$.STREAMING_MAINTENANCE_INTERVAL(), (Object)BoxesRunTime.boxToLong((long)10L));
            StateStoreConf storeConf = StateStoreConf$.MODULE$.apply(sqlConf);
            Configuration hadoopConf = new Configuration();
            IntRef latestStoreVersion = IntRef.create((int)0);
            Span timeoutDuration = SpanSugar$.MODULE$.convertIntToGrainOfTime(1).minute();
            return (Assertion)package$.MODULE$.quietly((Function0 & Serializable)() -> {
                LocalSparkContext$.MODULE$.withSpark(new SparkContext(conf), (Function1 & Serializable)sc -> {
                    StateStoreCoordinatorSuite$.MODULE$.withCoordinatorRef(sc, (Function1<StateStoreCoordinatorRef, BoxedUnit>)(Function1 & Serializable)coordinatorRef -> {
                        StateStoreSuite.$anonfun$new$31($this, timeoutDuration$1, storeProviderId1$1, latestStoreVersion$1, storeConf$1, hadoopConf$1, storeProviderId2$1, coordinatorRef);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                });
                return (Assertion)Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration), (Function0 & Serializable)() -> {
                    Predef$.MODULE$.require(this.convertToEqualizer(SparkEnv$.MODULE$.get()).$eq$eq$eq(null));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId1), "StateStore.isLoaded(storeProviderId1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId2), "StateStore.isLoaded(storeProviderId2)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isMaintenanceRunning(), "StateStore.isMaintenanceRunning", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
                }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
            });
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
        this.test("SPARK-40492: maintenance before unload", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster("local").setAppName("SPARK-40492");
            int opId = 0;
            String dir1 = StateStoreTestsHelper$.MODULE$.newDir();
            StateStoreProviderId storeProviderId1 = new StateStoreProviderId(new StateStoreId(dir1, (long)opId, 0, StateStoreId$.MODULE$.apply$default$4()), UUID.randomUUID());
            SQLConf sqlConf = this.getDefaultSQLConf(BoxesRunTime.unboxToInt((Object)SQLConf$.MODULE$.STATE_STORE_MIN_DELTAS_FOR_SNAPSHOT().defaultValue().get()), BoxesRunTime.unboxToInt((Object)SQLConf$.MODULE$.MAX_BATCHES_TO_RETAIN_IN_MEMORY().defaultValue().get()));
            sqlConf.setConf(SQLConf$.MODULE$.MIN_BATCHES_TO_RETAIN(), (Object)BoxesRunTime.boxToInteger((int)2));
            sqlConf.setConf(SQLConf$.MODULE$.STREAMING_MAINTENANCE_INTERVAL(), (Object)BoxesRunTime.boxToLong((long)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).minute()).toMillis()));
            StateStoreConf storeConf = StateStoreConf$.MODULE$.apply(sqlConf);
            Configuration hadoopConf = new Configuration();
            IntRef latestStoreVersion = IntRef.create((int)0);
            Span timeoutDuration = SpanSugar$.MODULE$.convertIntToGrainOfTime(1).minute();
            package$.MODULE$.quietly((Function0)(JFunction0.mcV.sp & Serializable)() -> LocalSparkContext$.MODULE$.withSpark(new SparkContext(conf), (Function1 & Serializable)sc -> {
                StateStoreCoordinatorSuite$.MODULE$.withCoordinatorRef(sc, (Function1<StateStoreCoordinatorRef, BoxedUnit>)(Function1 & Serializable)coordinatorRef -> {
                    StateStoreSuite.$anonfun$new$45($this, timeoutDuration$2, storeProviderId1$2, latestStoreVersion$2, storeConf$2, hadoopConf$2, coordinatorRef);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            }));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
        this.test("snapshotting", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.tryWithProviderResource(this.newStoreProvider(5, 2), (Function1 & Serializable)provider -> {
            Option latestSnapshotVersion;
            Option snapshotVersion;
            int currentVersion = 0;
            currentVersion = this.updateVersionTo((StateStoreProvider)provider, currentVersion, 2);
            Predef$.MODULE$.require(this.convertToEqualizer(this.getLatestData((HDFSBackedStateStoreProvider)provider)).$eq$eq$eq(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2))})), Equality$.MODULE$.default()));
            provider.doMaintenance();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getLatestData((HDFSBackedStateStoreProvider)provider));
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), currentVersion).foreach((Function1 & Serializable)i -> StateStoreSuite.$anonfun$new$55(this, provider, BoxesRunTime.unboxToInt((Object)i)));
            currentVersion = this.updateVersionTo((StateStoreProvider)provider, currentVersion, 6);
            Predef$.MODULE$.require(this.convertToEqualizer(this.getLatestData((HDFSBackedStateStoreProvider)provider)).$eq$eq$eq(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)6))})), Equality$.MODULE$.default()), (Function0 & Serializable)() -> "store not updated correctly");
            provider.doMaintenance();
            Option $org_scalatest_assert_macro_left2 = snapshotVersion = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 6).find((Function1)(JFunction1.mcZI.sp & Serializable)version -> this.fileExists(provider, version, true));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "nonEmpty", $org_scalatest_assert_macro_left2.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"snapshot file not generated", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 457));
            this.deleteFilesEarlierThanVersion(provider, BoxesRunTime.unboxToInt((Object)snapshotVersion.get()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.getData((HDFSBackedStateStoreProvider)provider, BoxesRunTime.unboxToInt((Object)snapshotVersion.get())));
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), snapshotVersion.get())}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"snapshotting messed up the data of the snapshotted version", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 459));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(this.getLatestData((HDFSBackedStateStoreProvider)provider));
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)6))}));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"snapshotting messed up the data of the final version", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
            currentVersion = this.updateVersionTo((StateStoreProvider)provider, currentVersion, 20);
            Predef$.MODULE$.require(this.convertToEqualizer(this.getLatestData((HDFSBackedStateStoreProvider)provider)).$eq$eq$eq(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)20))})), Equality$.MODULE$.default()), (Function0 & Serializable)() -> "store not updated correctly");
            provider.doMaintenance();
            Option $org_scalatest_assert_macro_left5 = latestSnapshotVersion = ((IterableOps)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 20).filter((Function1)(JFunction1.mcZI.sp & Serializable)version -> this.fileExists(provider, version, true))).lastOption();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "nonEmpty", $org_scalatest_assert_macro_left5.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"no snapshot file found", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 473));
            int $org_scalatest_assert_macro_left6 = BoxesRunTime.unboxToInt((Object)latestSnapshotVersion.get());
            int $org_scalatest_assert_macro_right4 = BoxesRunTime.unboxToInt((Object)snapshotVersion.get());
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left6 > $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"newer snapshot not generated", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 474));
            this.deleteFilesEarlierThanVersion(provider, BoxesRunTime.unboxToInt((Object)latestSnapshotVersion.get()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(this.getLatestData((HDFSBackedStateStoreProvider)provider));
            Set $org_scalatest_assert_macro_right5 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)20))}));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"snapshotting messed up the data", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 477));
        }), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 433));
        this.testQuietly("SPARK-18342: commit fails when rename fails", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            String dir = new StringBuilder(3).append(RenameReturnsFalseFileSystem$.MODULE$.scheme()).append("://").append(StateStoreTestsHelper$.MODULE$.newDir()).toString();
            Configuration conf = new Configuration();
            conf.set(new StringBuilder(8).append("fs.").append(RenameReturnsFalseFileSystem$.MODULE$.scheme()).append(".impl").toString(), RenameReturnsFalseFileSystem.class.getName());
            long x$36 = Random$.MODULE$.nextInt();
            boolean x$37 = false;
            String x$38 = dir;
            Configuration x$39 = conf;
            int x$40 = this.newStoreProvider$default$3();
            int x$41 = this.newStoreProvider$default$5();
            int x$42 = this.newStoreProvider$default$6();
            this.tryWithProviderResource(this.newStoreProvider(x$36, 0, x$40, x$38, x$41, x$42, x$39), (Function1 & Serializable)provider -> {
                StateStore store = provider.getStore(0L);
                StateStoreTestsHelper$.MODULE$.put(store, "a", 0, 0);
                IllegalStateException e = (IllegalStateException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> store.commit(), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 491));
                String $org_scalatest_assert_macro_left = e.getCause().getMessage();
                String $org_scalatest_assert_macro_right = "Failed to rename";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
            });
        });
        this.test("SPARK-18416: do not create temp delta file until the store is updated", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String dir = StateStoreTestsHelper$.MODULE$.newDir();
            StateStoreProviderId storeId = new StateStoreProviderId(new StateStoreId(dir, 0L, 0, StateStoreId$.MODULE$.apply$default$4()), UUID.randomUUID());
            StateStoreConf storeConf = StateStoreConf$.MODULE$.empty();
            Configuration hadoopConf = new Configuration();
            File deltaFileDir = new File(new StringBuilder(5).append(dir).append("/0/0/").toString());
            StateStore store0 = (StateStore)this.shouldNotCreateTempFile$1((Function0 & Serializable)() -> StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), 0, 0L, storeConf, hadoopConf), deltaFileDir);
            StateStoreTestsHelper$.MODULE$.put(store0, "a", 0, 1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 531));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 532));
            store0.commit();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 536));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 537));
            StateStore store1 = (StateStore)this.shouldNotCreateTempFile$1((Function0 & Serializable)() -> StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), 0, 1L, storeConf, hadoopConf), deltaFileDir);
            StateStoreTestsHelper$.MODULE$.remove(store1, (Function1<Tuple2<String, Object>, Object>)(Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$70(x$5)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 546));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 547));
            store1.commit();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right7 = 0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 551));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right8 = 2;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 552));
            StateStore store2 = (StateStore)this.shouldNotCreateTempFile$1((Function0 & Serializable)() -> StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), 0, 2L, storeConf, hadoopConf), deltaFileDir);
            store2.commit();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right9 = 0;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 561));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right10 = 3;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 562));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 496));
        this.test("SPARK-21145: Restarted queries create new provider instances", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Assertion assertion;
            try {
                File checkpointLocation = Utils$.MODULE$.createTempDir().getAbsoluteFile();
                SparkSession spark2 = SparkSession$.MODULE$.builder().master("local[2]").getOrCreate();
                SparkSession$.MODULE$.setActiveSession(spark2);
                SQLContext sqlContext = spark2.sqlContext();
                spark2.conf().set(SQLConf$.MODULE$.SHUFFLE_PARTITIONS().key(), "1");
                MemoryStream inputData = MemoryStream$.MODULE$.apply(spark2.implicits().newIntEncoder(), sqlContext);
                Seq loadedProvidersAfterRun1 = this.runQueryAndGetLoadedProviders$1(inputData, checkpointLocation);
                Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedProvidersAfterRun1.length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                Seq loadedProvidersAfterRun2 = this.runQueryAndGetLoadedProviders$1(inputData, checkpointLocation);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedProvidersAfterRun2.length()));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 600));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((StateStoreProvider)loadedProvidersAfterRun2.apply(0)).stateStoreId());
                StateStoreId $org_scalatest_assert_macro_right2 = ((StateStoreProvider)loadedProvidersAfterRun2.apply(1)).stateStoreId();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 603));
                StateStoreProvider $org_scalatest_assert_macro_left3 = (StateStoreProvider)loadedProvidersAfterRun2.apply(0);
                StateStoreProvider $org_scalatest_assert_macro_right3 = (StateStoreProvider)loadedProvidersAfterRun2.apply(1);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "ne", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3 != $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 604));
            }
            finally {
                SparkSession$.MODULE$.getActiveSession().foreach((Function1 & Serializable)spark -> {
                    StateStoreSuite.$anonfun$new$73(spark);
                    return BoxedUnit.UNIT;
                });
            }
            return assertion;
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 565));
        this.test("error writing [version].delta cancels the output stream", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Configuration hadoopConf = new Configuration();
            hadoopConf.set(SQLConf$.MODULE$.STREAMING_CHECKPOINT_FILE_MANAGER_CLASS().parent().key(), CreateAtomicTestManager.class.getName());
            String remoteDir = Utils$.MODULE$.createTempDir().getAbsolutePath();
            long x$43 = Random$.MODULE$.nextInt();
            boolean x$44 = false;
            String x$45 = remoteDir;
            Configuration x$46 = hadoopConf;
            int x$47 = this.newStoreProvider$default$3();
            int x$48 = this.newStoreProvider$default$5();
            int x$49 = this.newStoreProvider$default$6();
            return (Assertion)this.tryWithProviderResource(this.newStoreProvider(x$43, 0, x$47, x$45, x$48, x$49, x$46), (Function1 & Serializable)provider -> {
                CreateAtomicTestManager$.MODULE$.shouldFailInCreateAtomic_$eq(false);
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).foreach((Function1)(JFunction1.mcJI.sp & Serializable)version -> {
                    StateStore store = provider.getStore((long)(version - 1));
                    StateStoreTestsHelper$.MODULE$.put(store, Integer.toString(version), 0, version);
                    return store.commit();
                });
                Set version10Data = ((IterableOnceOps)((IndexedSeqOps)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)10L)).map((Function1 & Serializable)x$7 -> StateStoreSuite.$anonfun$new$78(BoxesRunTime.unboxToLong((Object)x$7)))).map((Function1 & Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x), x))).toSet();
                CreateAtomicTestManager$.MODULE$.cancelCalledInCreateAtomic_$eq(false);
                StateStore store = provider.getStore(10L);
                CreateAtomicTestManager$.MODULE$.shouldFailInCreateAtomic_$eq(true);
                StateStoreTestsHelper$.MODULE$.put(store, "11", 0, 11);
                IllegalStateException e = (IllegalStateException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)package$.MODULE$.quietly((Function0)(JFunction0.mcJ.sp & Serializable)() -> store.commit())), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 639));
                Throwable $org_scalatest_assert_macro_left = e.getCause();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "java.io.IOException", $org_scalatest_assert_macro_left instanceof IOException, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 640));
                CreateAtomicTestManager$.MODULE$.shouldFailInCreateAtomic_$eq(false);
                CreateAtomicTestManager$.MODULE$.cancelCalledInCreateAtomic_$eq(false);
                StateStore store2 = provider.getStore(10L);
                StateStoreTestsHelper$.MODULE$.put(store2, "11", 0, 11);
                store2.abort();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(CreateAtomicTestManager$.MODULE$.cancelCalledInCreateAtomic(), "org.apache.spark.sql.execution.streaming.CreateAtomicTestManager.cancelCalledInCreateAtomic", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 648));
            });
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 614));
        this.test("expose metrics with custom metrics to StateStoreMetrics", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ObjectRef store = ObjectRef.create(null);
            LongRef loadedMapSizeForVersion1 = LongRef.create((long)-1L);
            this.tryWithProviderResource(this.newStoreProvider(), (Function1 & Serializable)provider -> {
                StateStoreSuite.$anonfun$new$84(this, store, loadedMapSizeForVersion1, provider);
                return BoxedUnit.UNIT;
            });
            this.tryWithProviderResource(this.newStoreProvider(((StateStore)store.elem).id()), (Function1 & Serializable)reloadedProvider -> {
                StateStoreSuite.$anonfun$new$86(this, loadedMapSizeForVersion1, reloadedProvider);
                return BoxedUnit.UNIT;
            });
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 652));
        Statics.releaseFence();
    }
}

