/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.ReduceFunction;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericRow;
import org.apache.spark.sql.catalyst.util.DateTimeUtils;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Tuple2;

public class JavaBeanDeserializationSuite
implements Serializable {
    private TestSparkSession spark;
    private static final List<ArrayRecord> ARRAY_RECORDS = new ArrayList<ArrayRecord>();
    private static final List<MapRecord> MAP_RECORDS;

    @Before
    public void setUp() {
        this.spark = new TestSparkSession();
    }

    @After
    public void tearDown() {
        this.spark.stop();
        this.spark = null;
    }

    @Test
    public void testBeanWithArrayFieldDeserialization() {
        Encoder encoder = Encoders.bean(ArrayRecord.class);
        Dataset dataset = this.spark.read().format("json").schema("id int, intervals array<struct<startTime: bigint, endTime: bigint>>, ints array<int>").load("src/test/resources/test-data/with-array-fields.json").as(encoder);
        List records = dataset.collectAsList();
        Assert.assertEquals(ARRAY_RECORDS, (Object)records);
    }

    private static <K, V> Map<K, V> toMap(Collection<K> keys, Collection<V> values) {
        HashMap<K, V> map = new HashMap<K, V>();
        Iterator<K> keyI = keys.iterator();
        Iterator<V> valueI = values.iterator();
        while (keyI.hasNext() && valueI.hasNext()) {
            map.put(keyI.next(), valueI.next());
        }
        return map;
    }

    @Test
    public void testBeanWithMapFieldsDeserialization() {
        Encoder encoder = Encoders.bean(MapRecord.class);
        Dataset dataset = this.spark.read().format("json").schema("id int, intervals map<string, struct<startTime: bigint, endTime: bigint>>").load("src/test/resources/test-data/with-map-fields.json").as(encoder);
        List records = dataset.collectAsList();
        Assert.assertEquals(MAP_RECORDS, (Object)records);
    }

    @Test
    public void testSpark22000() {
        ArrayList<Row> inputRows = new ArrayList<Row>();
        ArrayList<RecordSpark22000> expectedRecords = new ArrayList<RecordSpark22000>();
        for (long idx = 0L; idx < 5L; ++idx) {
            Row row = JavaBeanDeserializationSuite.createRecordSpark22000Row(idx);
            inputRows.add(row);
            expectedRecords.add(JavaBeanDeserializationSuite.createRecordSpark22000(row));
        }
        Encoder encoder = Encoders.bean(RecordSpark22000.class);
        StructType schema = new StructType().add("shortField", DataTypes.ShortType).add("intField", DataTypes.IntegerType).add("longField", DataTypes.LongType).add("floatField", DataTypes.FloatType).add("doubleField", DataTypes.DoubleType).add("stringField", DataTypes.StringType).add("booleanField", DataTypes.BooleanType).add("timestampField", DataTypes.TimestampType).add("nullIntField", DataTypes.IntegerType, true);
        Dataset dataFrame = this.spark.createDataFrame(inputRows, schema);
        Dataset dataset = dataFrame.as(encoder);
        List records = dataset.collectAsList();
        Assert.assertEquals(expectedRecords, (Object)records);
    }

    @Test
    public void testSpark22000FailToUpcast() {
        ArrayList<Row> inputRows = new ArrayList<Row>();
        for (long idx = 0L; idx < 5L; ++idx) {
            Row row = JavaBeanDeserializationSuite.createRecordSpark22000FailToUpcastRow(idx);
            inputRows.add(row);
        }
        Encoder encoder = Encoders.bean(RecordSpark22000FailToUpcast.class);
        StructType schema = new StructType().add("id", DataTypes.StringType);
        Dataset dataFrame = this.spark.createDataFrame(inputRows, schema);
        AnalysisException e = (AnalysisException)Assert.assertThrows(AnalysisException.class, () -> dataFrame.as(encoder).collect());
        Assert.assertTrue((boolean)e.getMessage().contains("Cannot up cast "));
    }

    private static Row createRecordSpark22000Row(Long index) {
        Object[] values = new Object[]{index.shortValue(), index.intValue(), index, Float.valueOf(index.floatValue()), index.doubleValue(), String.valueOf(index), index % 2L == 0L, new Timestamp(System.currentTimeMillis()), null};
        return new GenericRow(values);
    }

    private static String timestampToString(Timestamp ts) {
        String timestampString = String.valueOf(ts);
        String formatted = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(ts);
        if (timestampString.length() > 19 && !timestampString.substring(19).equals(".0")) {
            return formatted + timestampString.substring(19);
        }
        return formatted;
    }

    private static RecordSpark22000 createRecordSpark22000(Row recordRow) {
        RecordSpark22000 record = new RecordSpark22000();
        record.setShortField(String.valueOf(recordRow.getShort(0)));
        record.setIntField(String.valueOf(recordRow.getInt(1)));
        record.setLongField(String.valueOf(recordRow.getLong(2)));
        record.setFloatField(String.valueOf(recordRow.getFloat(3)));
        record.setDoubleField(String.valueOf(recordRow.getDouble(4)));
        record.setStringField(recordRow.getString(5));
        record.setBooleanField(String.valueOf(recordRow.getBoolean(6)));
        record.setTimestampField(JavaBeanDeserializationSuite.timestampToString(recordRow.getTimestamp(7)));
        record.setNullIntField(null);
        return record;
    }

    private static Row createRecordSpark22000FailToUpcastRow(Long index) {
        Object[] values = new Object[]{String.valueOf(index)};
        return new GenericRow(values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBeanWithLocalDateAndInstant() {
        String originConf = this.spark.conf().get(SQLConf.DATETIME_JAVA8API_ENABLED().key());
        try {
            this.spark.conf().set(SQLConf.DATETIME_JAVA8API_ENABLED().key(), "true");
            ArrayList<Row> inputRows = new ArrayList<Row>();
            ArrayList<LocalDateInstantRecord> expectedRecords = new ArrayList<LocalDateInstantRecord>();
            for (long idx = 0L; idx < 5L; ++idx) {
                Row row = JavaBeanDeserializationSuite.createLocalDateInstantRow(idx);
                inputRows.add(row);
                expectedRecords.add(JavaBeanDeserializationSuite.createLocalDateInstantRecord(row));
            }
            Encoder encoder = Encoders.bean(LocalDateInstantRecord.class);
            StructType schema = new StructType().add("localDateField", DataTypes.DateType).add("instantField", DataTypes.TimestampType);
            Dataset dataFrame = this.spark.createDataFrame(inputRows, schema);
            Dataset dataset = dataFrame.as(encoder);
            List records = dataset.collectAsList();
            Assert.assertEquals(expectedRecords, (Object)records);
        }
        finally {
            this.spark.conf().set(SQLConf.DATETIME_JAVA8API_ENABLED().key(), originConf);
        }
    }

    @Test
    public void testSPARK38823NoBeanReuse() {
        List<Item> items = Arrays.asList(new Item("a", 1), new Item("b", 3), new Item("c", 2), new Item("a", 7));
        Encoder encoder = Encoders.bean(Item.class);
        Dataset ds = this.spark.createDataFrame(items, Item.class).as(encoder).coalesce(1);
        MapFunction<Item, String> mf = new MapFunction<Item, String>(){

            public String call(Item item) throws Exception {
                return item.getK();
            }
        };
        ReduceFunction<Item> rf = new ReduceFunction<Item>(){

            public Item call(Item item1, Item item2) throws Exception {
                Assert.assertNotSame((Object)item1, (Object)item2);
                return item1.addValue(item2.getV());
            }
        };
        Dataset finalDs = ds.groupByKey((MapFunction)mf, Encoders.STRING()).reduceGroups((ReduceFunction)rf);
        List<Tuple2> expectedRecords = Arrays.asList(new Tuple2((Object)"a", (Object)new Item("a", 8)), new Tuple2((Object)"b", (Object)new Item("b", 3)), new Tuple2((Object)"c", (Object)new Item("c", 2)));
        List result = finalDs.collectAsList();
        Assert.assertEquals(expectedRecords, (Object)result);
    }

    private static Row createLocalDateInstantRow(Long index) {
        Object[] values = new Object[]{LocalDate.ofEpochDay(42L), Instant.ofEpochSecond(42L)};
        return new GenericRow(values);
    }

    private static LocalDateInstantRecord createLocalDateInstantRecord(Row recordRow) {
        LocalDateInstantRecord record = new LocalDateInstantRecord();
        record.setLocalDateField(String.valueOf(recordRow.getLocalDate(0)));
        Instant instant = recordRow.getInstant(1);
        TimestampFormatter formatter = TimestampFormatter.getFractionFormatter((ZoneId)DateTimeUtils.getZoneId((String)SQLConf.get().sessionLocalTimeZone()));
        record.setInstantField(formatter.format(DateTimeUtils.instantToMicros((Instant)instant)));
        return record;
    }

    static {
        ARRAY_RECORDS.add(new ArrayRecord(1, Arrays.asList(new Interval(111L, 211L), new Interval(121L, 221L)), new int[]{11, 12, 13, 14}));
        ARRAY_RECORDS.add(new ArrayRecord(2, Arrays.asList(new Interval(112L, 212L), new Interval(122L, 222L)), new int[]{21, 22, 23, 24}));
        ARRAY_RECORDS.add(new ArrayRecord(3, Arrays.asList(new Interval(113L, 213L), new Interval(123L, 223L)), new int[]{31, 32, 33, 34}));
        MAP_RECORDS = new ArrayList<MapRecord>();
        MAP_RECORDS.add(new MapRecord(1, JavaBeanDeserializationSuite.toMap(Arrays.asList("a", "b"), Arrays.asList(new Interval(111L, 211L), new Interval(121L, 221L)))));
        MAP_RECORDS.add(new MapRecord(2, JavaBeanDeserializationSuite.toMap(Arrays.asList("a", "b"), Arrays.asList(new Interval(112L, 212L), new Interval(122L, 222L)))));
        MAP_RECORDS.add(new MapRecord(3, JavaBeanDeserializationSuite.toMap(Arrays.asList("a", "b"), Arrays.asList(new Interval(113L, 213L), new Interval(123L, 223L)))));
        MAP_RECORDS.add(new MapRecord(4, new HashMap<String, Interval>()));
        MAP_RECORDS.add(new MapRecord(5, null));
    }

    public static final class LocalDateInstantRecord {
        private String localDateField;
        private String instantField;

        public String getLocalDateField() {
            return this.localDateField;
        }

        public void setLocalDateField(String localDateField) {
            this.localDateField = localDateField;
        }

        public String getInstantField() {
            return this.instantField;
        }

        public void setInstantField(String instantField) {
            this.instantField = instantField;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalDateInstantRecord that = (LocalDateInstantRecord)o;
            return Objects.equals(this.localDateField, that.localDateField) && Objects.equals(this.instantField, that.instantField);
        }

        public int hashCode() {
            return Objects.hash(this.localDateField, this.instantField);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("localDateField", (Object)this.localDateField).append("instantField", (Object)this.instantField).toString();
        }
    }

    public static class Item
    implements Serializable {
        private String k;
        private int v;

        public String getK() {
            return this.k;
        }

        public int getV() {
            return this.v;
        }

        public void setK(String k) {
            this.k = k;
        }

        public void setV(int v) {
            this.v = v;
        }

        public Item() {
        }

        public Item(String k, int v) {
            this.k = k;
            this.v = v;
        }

        public Item addValue(int inc) {
            return new Item(this.k, this.v + inc);
        }

        public String toString() {
            return "Item(" + this.k + "," + this.v + ")";
        }

        public boolean equals(Object o) {
            if (!(o instanceof Item)) {
                return false;
            }
            Item other = (Item)o;
            return other.getK().equals(this.k) && other.getV() == this.v;
        }
    }

    public static final class RecordSpark22000FailToUpcast {
        private Integer id;

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }
    }

    public static final class RecordSpark22000 {
        private String shortField;
        private String intField;
        private String longField;
        private String floatField;
        private String doubleField;
        private String stringField;
        private String booleanField;
        private String timestampField;
        private String nullIntField;

        public String getShortField() {
            return this.shortField;
        }

        public void setShortField(String shortField) {
            this.shortField = shortField;
        }

        public String getIntField() {
            return this.intField;
        }

        public void setIntField(String intField) {
            this.intField = intField;
        }

        public String getLongField() {
            return this.longField;
        }

        public void setLongField(String longField) {
            this.longField = longField;
        }

        public String getFloatField() {
            return this.floatField;
        }

        public void setFloatField(String floatField) {
            this.floatField = floatField;
        }

        public String getDoubleField() {
            return this.doubleField;
        }

        public void setDoubleField(String doubleField) {
            this.doubleField = doubleField;
        }

        public String getStringField() {
            return this.stringField;
        }

        public void setStringField(String stringField) {
            this.stringField = stringField;
        }

        public String getBooleanField() {
            return this.booleanField;
        }

        public void setBooleanField(String booleanField) {
            this.booleanField = booleanField;
        }

        public String getTimestampField() {
            return this.timestampField;
        }

        public void setTimestampField(String timestampField) {
            this.timestampField = timestampField;
        }

        public String getNullIntField() {
            return this.nullIntField;
        }

        public void setNullIntField(String nullIntField) {
            this.nullIntField = nullIntField;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RecordSpark22000 that = (RecordSpark22000)o;
            return Objects.equals(this.shortField, that.shortField) && Objects.equals(this.intField, that.intField) && Objects.equals(this.longField, that.longField) && Objects.equals(this.floatField, that.floatField) && Objects.equals(this.doubleField, that.doubleField) && Objects.equals(this.stringField, that.stringField) && Objects.equals(this.booleanField, that.booleanField) && Objects.equals(this.timestampField, that.timestampField) && Objects.equals(this.nullIntField, that.nullIntField);
        }

        public int hashCode() {
            return Objects.hash(this.shortField, this.intField, this.longField, this.floatField, this.doubleField, this.stringField, this.booleanField, this.timestampField, this.nullIntField);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("shortField", (Object)this.shortField).append("intField", (Object)this.intField).append("longField", (Object)this.longField).append("floatField", (Object)this.floatField).append("doubleField", (Object)this.doubleField).append("stringField", (Object)this.stringField).append("booleanField", (Object)this.booleanField).append("timestampField", (Object)this.timestampField).append("nullIntField", (Object)this.nullIntField).toString();
        }
    }

    public static class Interval {
        private long startTime;
        private long endTime;

        public Interval() {
        }

        Interval(long startTime, long endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        public int hashCode() {
            return Long.hashCode(this.startTime) ^ Long.hashCode(this.endTime);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Interval)) {
                return false;
            }
            Interval other = (Interval)obj;
            return other.startTime == this.startTime && other.endTime == this.endTime;
        }

        public String toString() {
            return String.format("[%d,%d]", this.startTime, this.endTime);
        }
    }

    public static class MapRecord {
        private int id;
        private Map<String, Interval> intervals;

        public MapRecord() {
        }

        MapRecord(int id, Map<String, Interval> intervals) {
            this.id = id;
            this.intervals = intervals;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public Map<String, Interval> getIntervals() {
            return this.intervals;
        }

        public void setIntervals(Map<String, Interval> intervals) {
            this.intervals = intervals;
        }

        public int hashCode() {
            return this.id ^ Objects.hashCode(this.intervals);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MapRecord)) {
                return false;
            }
            MapRecord other = (MapRecord)obj;
            return other.id == this.id && Objects.equals(other.intervals, this.intervals);
        }

        public String toString() {
            return String.format("{ id: %d, intervals: %s }", this.id, this.intervals);
        }
    }

    public static class ArrayRecord {
        private int id;
        private List<Interval> intervals;
        private int[] ints;

        public ArrayRecord() {
        }

        ArrayRecord(int id, List<Interval> intervals, int[] ints) {
            this.id = id;
            this.intervals = intervals;
            this.ints = ints;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public List<Interval> getIntervals() {
            return this.intervals;
        }

        public void setIntervals(List<Interval> intervals) {
            this.intervals = intervals;
        }

        public int[] getInts() {
            return this.ints;
        }

        public void setInts(int[] ints) {
            this.ints = ints;
        }

        public int hashCode() {
            return this.id ^ Objects.hashCode(this.intervals) ^ Objects.hashCode(this.ints);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ArrayRecord)) {
                return false;
            }
            ArrayRecord other = (ArrayRecord)obj;
            return other.id == this.id && Objects.equals(other.intervals, this.intervals) && Arrays.equals(other.ints, this.ints);
        }

        public String toString() {
            return String.format("{ id: %d, intervals: %s, ints: %s }", this.id, this.intervals, Arrays.toString(this.ints));
        }
    }
}

