/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql.connector.catalog.functions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.functions.BoundFunction;
import org.apache.spark.sql.connector.catalog.functions.ScalarFunction;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

public class JavaStrLen
implements UnboundFunction {
    private final BoundFunction fn;

    public JavaStrLen(BoundFunction fn) {
        this.fn = fn;
    }

    public String name() {
        return "strlen";
    }

    public BoundFunction bind(StructType inputType) {
        if (inputType.fields().length != 1) {
            throw new UnsupportedOperationException("Expect exactly one argument");
        }
        if (inputType.fields()[0].dataType() instanceof StringType) {
            return this.fn;
        }
        throw new UnsupportedOperationException("Expect StringType");
    }

    public String description() {
        return "strlen: returns the length of the input string\n strlen(string) -> int";
    }

    public static class JavaStrLenStaticMagicNullSafe
    extends JavaStrLenBase {
        public static int invoke(UTF8String str) {
            if (str == null) {
                return 0;
            }
            return str.toString().length();
        }
    }

    public static class JavaStrLenMagicNullSafe
    extends JavaStrLenBase {
        public int invoke(UTF8String str) {
            if (str == null) {
                return 0;
            }
            return str.toString().length();
        }
    }

    public static class JavaStrLenNoImpl
    extends JavaStrLenBase {
    }

    public static class JavaStrLenBadStaticMagic
    extends JavaStrLenBase {
        public static int invoke(String str) {
            return str.length();
        }

        public int invoke(UTF8String str) {
            return str.toString().length() + 100;
        }
    }

    public static class JavaStrLenBoth
    extends JavaStrLenBase {
        public Integer produceResult(InternalRow input) {
            String str = input.getString(0);
            return str.length();
        }

        public int invoke(UTF8String str) {
            return str.toString().length() + 100;
        }
    }

    public static class JavaStrLenStaticMagic
    extends JavaStrLenBase {
        public static int invoke(UTF8String str) {
            return str.toString().length();
        }
    }

    public static class JavaStrLenMagic
    extends JavaStrLenBase {
        public int invoke(UTF8String str) {
            return str.toString().length();
        }
    }

    public static class JavaStrLenDefault
    extends JavaStrLenBase {
        public Integer produceResult(InternalRow input) {
            String str = input.getString(0);
            return str.length();
        }
    }

    private static abstract class JavaStrLenBase
    implements ScalarFunction<Integer> {
        private JavaStrLenBase() {
        }

        public DataType[] inputTypes() {
            return new DataType[]{DataTypes.StringType};
        }

        public DataType resultType() {
            return DataTypes.IntegerType;
        }

        public String name() {
            return "strlen";
        }
    }
}

