/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.arrow;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.ipc.WriteChannel;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.TaskContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.arrow.ArrowConverters$;
import org.apache.spark.sql.execution.arrow.ArrowWriter;
import org.apache.spark.sql.execution.arrow.ArrowWriter$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.ArrowUtils$;
import org.apache.spark.util.SizeEstimator$;
import org.apache.spark.util.Utils$;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r5qA\u0002'N\u0011\u0003\t\u0016L\u0002\u0004\\\u001b\"\u0005\u0011\u000b\u0018\u0005\u0006S\u0006!\ta\u001b\u0004\u0006Y\u0006\u0001\u0011+\u001c\u0005\u000b\u0003#\u0019!\u0011!Q\u0001\n\u0005M\u0001BCA\u0011\u0007\t\u0005\t\u0015!\u0003\u0002$!Q\u0011qF\u0002\u0003\u0002\u0003\u0006I!!\r\t\u0015\u0005]2A!A!\u0002\u0013\tI\u0004\u0003\u0006\u0002J\r\u0011\t\u0011)A\u0005\u0003\u0017Ba![\u0002\u0005\u0002\u0005M\u0003\"CA2\u0007\t\u0007I\u0011CA3\u0011!\tYh\u0001Q\u0001\n\u0005\u001d\u0004\"CA?\u0007\t\u0007I\u0011BA@\u0011!\tii\u0001Q\u0001\n\u0005\u0005\u0005\"CAH\u0007\t\u0007I\u0011BAI\u0011!\tYj\u0001Q\u0001\n\u0005M\u0005\"CAO\u0007\t\u0007I\u0011CAP\u0011!\t9k\u0001Q\u0001\n\u0005\u0005\u0006\"CAU\u0007\t\u0007I\u0011CAV\u0011!\t\u0019l\u0001Q\u0001\n\u00055\u0006bBA[\u0007\u0011\u0005\u0013q\u0017\u0005\b\u0003\u007f\u001bA\u0011IAa\u0011\u001d\t\u0019m\u0001C!\u0003\u000b4q!!4\u0002\u0001E\u000by\r\u0003\u0006\u0002\u0012]\u0011\t\u0011)A\u0005\u0003'A!\"!\t\u0018\u0005\u0003\u0005\u000b\u0011BA\u0012\u0011)\tyc\u0006B\u0001B\u0003%\u0011\u0011\u0007\u0005\u000b\u0003#<\"\u0011!Q\u0001\n\u0005E\u0002BCA\u001c/\t\u0005\t\u0015!\u0003\u0002:!Q\u0011\u0011J\f\u0003\u0002\u0003\u0006I!a\u0013\t\r%<B\u0011AAj\u0011%\t\u0019o\u0006b\u0001\n\u0013\t)\u000f\u0003\u0005\u0002h^\u0001\u000b\u0011BA\u0019\u0011%\tIo\u0006a\u0001\n\u0003\t)\u000fC\u0005\u0002l^\u0001\r\u0011\"\u0001\u0002n\"A\u00111_\f!B\u0013\t\t\u0004C\u0004\u0002@^!\t%!1\t\u0011\u0005U\u0018\u0001\"\u0001R\u0003oD\u0001Ba\u0001\u0002\t\u0003\t&Q\u0001\u0005\t\u0005#\tA\u0011A)\u0003\u0014\u0019A!\u0011D\u0001\u0002\u0002E\u0013Y\u0002C\u0005\u0003\u001e!\u0012\t\u0011)A\u0005]\"Q\u0011\u0011\n\u0015\u0003\u0002\u0003\u0006I!a\u0013\t\r%DC\u0011\u0001B\u0010\u0011%\u00119\u0003\u000bb\u0001\n\u0003\u0011I\u0003\u0003\u0005\u0003<!\u0002\u000b\u0011\u0002B\u0016\u0011%\ti\b\u000bb\u0001\n#\ty\b\u0003\u0005\u0002\u000e\"\u0002\u000b\u0011BAA\u0011%\u0011i\u0004\u000ba\u0001\n\u0013\u0011y\u0004C\u0005\u0003H!\u0002\r\u0011\"\u0003\u0003J!A!Q\n\u0015!B\u0013\u0011\t\u0005C\u0005\u0002\"!\u0012\r\u0011\"\u0001\u0003P!A!\u0011\u000b\u0015!\u0002\u0013\t\u0019\u0003C\u0004\u00026\"\"\t%a.\t\u000f\u0005}\u0006\u0006\"\u0011\u0003T!9!Q\u000b\u0015\u0007\u0002\t]ca\u0002B-\u0003\u0001\t&1\f\u0005\n\u0005;A$\u0011!Q\u0001\n9D!\"!\t9\u0005\u0003\u0005\u000b\u0011BA\u0012\u0011)\t9\u0004\u000fB\u0001B\u0003%\u0011\u0011\b\u0005\u000b\u0003\u0013B$\u0011!Q\u0001\n\u0005-\u0003BB59\t\u0003\u0011i\u0006C\u0004\u0003Va\"\tEa\u0016\u0007\u000f\t%\u0014\u0001A)\u0003l!I!QD \u0003\u0002\u0003\u0006IA\u001c\u0005\u000b\u0003\u0013z$\u0011!Q\u0001\n\u0005-\u0003BB5@\t\u0003\u0011i\u0007C\u0004\u0003V}\"\tEa\u0016\t\u0011\tU\u0014\u0001\"\u0001R\u0005oB\u0001B!!\u0002\t\u0003\t&1\u0011\u0005\b\u0005\u0013\u000bA\u0011\u0002BF\u0011!\u0011y)\u0001C\u0001\u001b\nE\u0005b\u0002BU\u0003\u0011\u0005!1\u0016\u0005\t\u0005;\fA\u0011A)\u0003`\"A!q]\u0001\u0005\u0002E\u0013I\u000fC\u0004\u0003\u0000\u0006!Ia!\u0001\u0002\u001f\u0005\u0013(o\\<D_:4XM\u001d;feNT!AT(\u0002\u000b\u0005\u0014(o\\<\u000b\u0005A\u000b\u0016!C3yK\u000e,H/[8o\u0015\t\u00116+A\u0002tc2T!\u0001V+\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y;\u0016AB1qC\u000eDWMC\u0001Y\u0003\ry'o\u001a\t\u00035\u0006i\u0011!\u0014\u0002\u0010\u0003J\u0014xn^\"p]Z,'\u000f^3sgN\u0019\u0011!X2\u0011\u0005y\u000bW\"A0\u000b\u0003\u0001\fQa]2bY\u0006L!AY0\u0003\r\u0005s\u0017PU3g!\t!w-D\u0001f\u0015\t17+\u0001\u0005j]R,'O\\1m\u0013\tAWMA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012!\u0017\u0002\u0013\u0003J\u0014xn\u001e\"bi\u000eD\u0017\n^3sCR|'oE\u0003\u0004;:\f\t\u0001E\u0002pojt!\u0001];\u000f\u0005E$X\"\u0001:\u000b\u0005MT\u0017A\u0002\u001fs_>$h(C\u0001a\u0013\t1x,A\u0004qC\u000e\\\u0017mZ3\n\u0005aL(\u0001C%uKJ\fGo\u001c:\u000b\u0005Y|\u0006c\u00010|{&\u0011Ap\u0018\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003=zL!a`0\u0003\t\tKH/\u001a\t\u0005\u0003\u0007\ti!\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003\u0011a\u0017M\\4\u000b\u0005\u0005-\u0011\u0001\u00026bm\u0006LA!a\u0004\u0002\u0006\ti\u0011)\u001e;p\u00072|7/Z1cY\u0016\fqA]8x\u0013R,'\u000f\u0005\u0003po\u0006U\u0001\u0003BA\f\u0003;i!!!\u0007\u000b\u0007\u0005m\u0011+\u0001\u0005dCR\fG._:u\u0013\u0011\ty\"!\u0007\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\u0007g\u000eDW-\\1\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000bR\u0003\u0015!\u0018\u0010]3t\u0013\u0011\ti#a\n\u0003\u0015M#(/^2u)f\u0004X-\u0001\nnCb\u0014VmY8sIN\u0004VM\u001d\"bi\u000eD\u0007c\u00010\u00024%\u0019\u0011QG0\u0003\t1{gnZ\u0001\u000bi&lWMW8oK&#\u0007\u0003BA\u001e\u0003\u0007rA!!\u0010\u0002@A\u0011\u0011oX\u0005\u0004\u0003\u0003z\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002F\u0005\u001d#AB*ue&twMC\u0002\u0002B}\u000bqaY8oi\u0016DH\u000f\u0005\u0003\u0002N\u0005=S\"A*\n\u0007\u0005E3KA\u0006UCN\\7i\u001c8uKb$H\u0003DA+\u00033\nY&!\u0018\u0002`\u0005\u0005\u0004cAA,\u00075\t\u0011\u0001C\u0004\u0002\u0012%\u0001\r!a\u0005\t\u000f\u0005\u0005\u0012\u00021\u0001\u0002$!9\u0011qF\u0005A\u0002\u0005E\u0002bBA\u001c\u0013\u0001\u0007\u0011\u0011\b\u0005\b\u0003\u0013J\u0001\u0019AA&\u0003-\t'O]8x'\u000eDW-\\1\u0016\u0005\u0005\u001d\u0004\u0003BA5\u0003oj!!a\u001b\u000b\t\u00055\u0014qN\u0001\u0005a>TwN\u0003\u0003\u0002*\u0005E$\u0002BA:\u0003k\naA^3di>\u0014(B\u0001(V\u0013\u0011\tI(a\u001b\u0003\rM\u001b\u0007.Z7b\u00031\t'O]8x'\u000eDW-\\1!\u0003%\tG\u000e\\8dCR|'/\u0006\u0002\u0002\u0002B!\u00111QAE\u001b\t\t)I\u0003\u0003\u0002\b\u0006U\u0014AB7f[>\u0014\u00180\u0003\u0003\u0002\f\u0006\u0015%a\u0004\"vM\u001a,'/\u00117m_\u000e\fGo\u001c:\u0002\u0015\u0005dGn\\2bi>\u0014\b%\u0001\u0003s_>$XCAAJ!\u0011\t)*a&\u000e\u0005\u0005E\u0014\u0002BAM\u0003c\u0012\u0001CV3di>\u00148k\u00195f[\u0006\u0014vn\u001c;\u0002\u000bI|w\u000e\u001e\u0011\u0002\u0011UtGn\\1eKJ,\"!!)\u0011\t\u0005U\u00151U\u0005\u0005\u0003K\u000b\tH\u0001\bWK\u000e$xN]+oY>\fG-\u001a:\u0002\u0013UtGn\\1eKJ\u0004\u0013aC1se><xK]5uKJ,\"!!,\u0011\u0007i\u000by+C\u0002\u000226\u00131\"\u0011:s_^<&/\u001b;fe\u0006a\u0011M\u001d:po^\u0013\u0018\u000e^3sA\u00059\u0001.Y:OKb$XCAA]!\rq\u00161X\u0005\u0004\u0003{{&a\u0002\"p_2,\u0017M\\\u0001\u0005]\u0016DH\u000fF\u0001{\u0003\u0015\u0019Gn\\:f)\t\t9\rE\u0002_\u0003\u0013L1!a3`\u0005\u0011)f.\u001b;\u00039\u0005\u0013(o\\<CCR\u001c\u0007nV5uQN\u001b\u0007.Z7b\u0013R,'/\u0019;peN\u0019q#!\u0016\u0002+5\f\u00070R:uS6\fG/\u001a3CCR\u001c\u0007nU5{KRq\u0011Q[Al\u00033\fY.!8\u0002`\u0006\u0005\bcAA,/!9\u0011\u0011\u0003\u0010A\u0002\u0005M\u0001bBA\u0011=\u0001\u0007\u00111\u0005\u0005\b\u0003_q\u0002\u0019AA\u0019\u0011\u001d\t\tN\ba\u0001\u0003cAq!a\u000e\u001f\u0001\u0004\tI\u0004C\u0004\u0002Jy\u0001\r!a\u0013\u0002\u001f\u0005\u0014(o\\<TG\",W.Y*ju\u0016,\"!!\r\u0002!\u0005\u0014(o\\<TG\",W.Y*ju\u0016\u0004\u0013a\u0005:po\u000e{WO\u001c;J]2\u000b7\u000f\u001e\"bi\u000eD\u0017a\u0006:po\u000e{WO\u001c;J]2\u000b7\u000f\u001e\"bi\u000eDw\fJ3r)\u0011\t9-a<\t\u0013\u0005E(%!AA\u0002\u0005E\u0012a\u0001=%c\u0005!\"o\\<D_VtG/\u00138MCN$()\u0019;dQ\u0002\nq\u0002^8CCR\u001c\u0007.\u0013;fe\u0006$xN\u001d\u000b\r\u0003+\nI0a?\u0002~\u0006}(\u0011\u0001\u0005\b\u0003#)\u0003\u0019AA\n\u0011\u001d\t\t#\na\u0001\u0003GAq!a\f&\u0001\u0004\t\t\u0004C\u0004\u00028\u0015\u0002\r!!\u000f\t\u000f\u0005%S\u00051\u0001\u0002L\u0005IBo\u001c\"bi\u000eDw+\u001b;i'\u000eDW-\\1Ji\u0016\u0014\u0018\r^8s)1\t)Na\u0002\u0003\n\t-!Q\u0002B\b\u0011\u001d\t\tB\na\u0001\u0003'Aq!!\t'\u0001\u0004\t\u0019\u0003C\u0004\u00020\u0019\u0002\r!!\r\t\u000f\u0005Eg\u00051\u0001\u00022!9\u0011q\u0007\u0014A\u0002\u0005e\u0012!F2sK\u0006$X-R7qif\f%O]8x\u0005\u0006$8\r\u001b\u000b\u0006u\nU!q\u0003\u0005\b\u0003C9\u0003\u0019AA\u0012\u0011\u001d\t9d\na\u0001\u0003s\u00111#\u00138uKJt\u0017\r\u001c*po&#XM]1u_J\u001cB\u0001K/\u0002\u0014\u0005q\u0011M\u001d:po\n\u000bGo\u00195Ji\u0016\u0014HC\u0002B\u0011\u0005G\u0011)\u0003E\u0002\u0002X!BaA!\b,\u0001\u0004q\u0007bBA%W\u0001\u0007\u00111J\u0001\ne\u0016\u001cx.\u001e:dKN,\"Aa\u000b\u0011\r\t5\"qGA\u0001\u001b\t\u0011yC\u0003\u0003\u00032\tM\u0012aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0005ky\u0016AC2pY2,7\r^5p]&!!\u0011\bB\u0018\u0005-\t%O]1z\u0005V4g-\u001a:\u0002\u0015I,7o\\;sG\u0016\u001c\b%\u0001\ts_^LE/\u001a:B]\u0012\u001c6\r[3nCV\u0011!\u0011\t\t\b=\n\r\u00131CA\u0012\u0013\r\u0011)e\u0018\u0002\u0007)V\u0004H.\u001a\u001a\u0002)I|w/\u0013;fe\u0006sGmU2iK6\fw\fJ3r)\u0011\t9Ma\u0013\t\u0013\u0005E\u0018'!AA\u0002\t\u0005\u0013!\u0005:po&#XM]!oIN\u001b\u0007.Z7bAU\u0011\u00111E\u0001\bg\u000eDW-\\1!)\t\t)\"A\u0005oKb$()\u0019;dQR\u0011!\u0011\t\u0002!\u0013:$XM\u001d8bYJ{w/\u0013;fe\u0006$xN],ji\"|W\u000f^*dQ\u0016l\u0017mE\u00029\u0005C!\"Ba\u0018\u0003b\t\r$Q\rB4!\r\t9\u0006\u000f\u0005\u0007\u0005;i\u0004\u0019\u00018\t\u000f\u0005\u0005R\b1\u0001\u0002$!9\u0011qG\u001fA\u0002\u0005e\u0002bBA%{\u0001\u0007\u00111\n\u0002\u001e\u0013:$XM\u001d8bYJ{w/\u0013;fe\u0006$xN],ji\"\u001c6\r[3nCN\u0019qH!\t\u0015\r\t=$\u0011\u000fB:!\r\t9f\u0010\u0005\u0007\u0005;\u0011\u0005\u0019\u00018\t\u000f\u0005%#\t1\u0001\u0002L\u0005\tbM]8n\u0005\u0006$8\r[%uKJ\fGo\u001c:\u0015\u0015\u0005M!\u0011\u0010B>\u0005{\u0012y\b\u0003\u0004\u0003\u001e\u0011\u0003\rA\u001c\u0005\b\u0003C!\u0005\u0019AA\u0012\u0011\u001d\t9\u0004\u0012a\u0001\u0003sAq!!\u0013E\u0001\u0004\tY%A\u000ege>l')\u0019;dQ^KG\u000f[*dQ\u0016l\u0017-\u0013;fe\u0006$xN\u001d\u000b\u0007\u0005\u0003\u0012)Ia\"\t\r\tuQ\t1\u0001o\u0011\u001d\tI%\u0012a\u0001\u0003\u0017\naC^3di>\u00148k\u00195f[\u0006\u0014vn\u001c;U_&#XM\u001d\u000b\u0005\u0003'\u0011i\tC\u0004\u0002\u0010\u001a\u0003\r!a%\u0002\u00131|\u0017\r\u001a\"bi\u000eDGC\u0002BJ\u0005G\u00139\u000b\u0005\u0003\u0003\u0016\n}UB\u0001BL\u0015\u0011\u0011IJa'\u0002\u000f5,7o]1hK*!!QTA9\u0003\rI\u0007oY\u0005\u0005\u0005C\u00139J\u0001\tBeJ|wOU3d_J$')\u0019;dQ\"1!QU$A\u0002i\f!BY1uG\"\u0014\u0015\u0010^3t\u0011\u001d\tih\u0012a\u0001\u0003\u0003\u000b1\u0002^8ECR\fgI]1nKRA!Q\u0016Be\u0005\u001b\u0014\t\u000e\u0005\u0003\u00030\n\rg\u0002\u0002BY\u0005\u0003tAAa-\u0003@:!!Q\u0017B_\u001d\u0011\u00119La/\u000f\u0007E\u0014I,C\u0001Y\u0013\t1v+\u0003\u0002U+&\u0011!kU\u0005\u0003mFKAA!2\u0003H\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003mFCaAa3I\u0001\u0004q\u0017\u0001D1se><()\u0019;dQ\u0016\u001c\bb\u0002Bh\u0011\u0002\u0007\u0011\u0011H\u0001\rg\u000eDW-\\1TiJLgn\u001a\u0005\b\u0005'D\u0005\u0019\u0001Bk\u0003\u001d\u0019Xm]:j_:\u0004BAa6\u0003Z6\t\u0011+C\u0002\u0003\\F\u0013Ab\u00159be.\u001cVm]:j_:\fqC]3bI\u0006\u0013(o\\<TiJ,\u0017-\u001c$s_64\u0015\u000e\\3\u0015\t\t\u0005(1\u001d\t\u0004=nT\bb\u0002Bs\u0013\u0002\u0007\u0011\u0011H\u0001\tM&dWM\\1nK\u0006!r-\u001a;CCR\u001c\u0007.Z:Ge>l7\u000b\u001e:fC6$2A\u001cBv\u0011\u001d\u0011iO\u0013a\u0001\u0005_\f!!\u001b8\u0011\t\tE(1`\u0007\u0003\u0005gTAA!>\u0003x\u0006A1\r[1o]\u0016d7O\u0003\u0003\u0003z\u0006%\u0011a\u00018j_&!!Q Bz\u0005M\u0011V-\u00193bE2,')\u001f;f\u0007\"\fgN\\3m\u0003!\u0019Gn\\:f\u00032dG\u0003BAd\u0007\u0007Aqa!\u0002L\u0001\u0004\u00199!\u0001\u0006dY>\u001cX-\u00192mKN\u0004RAXB\u0005\u0003\u0003I1aa\u0003`\u0005)a$/\u001a9fCR,GM\u0010")
public final class ArrowConverters {
    public static Dataset<Row> toDataFrame(Iterator<byte[]> arrowBatches, String schemaString, SparkSession session) {
        return ArrowConverters$.MODULE$.toDataFrame(arrowBatches, schemaString, session);
    }

    public static class ArrowBatchIterator
    implements Iterator<byte[]>,
    AutoCloseable {
        private final Iterator<InternalRow> rowIter;
        private final long maxRecordsPerBatch;
        private final Schema arrowSchema;
        private final BufferAllocator allocator;
        private final VectorSchemaRoot root;
        private final VectorUnloader unloader;
        private final ArrowWriter arrowWriter;

        public final boolean hasDefiniteSize() {
            return Iterator.hasDefiniteSize$((Iterator)this);
        }

        public final Iterator<byte[]> iterator() {
            return Iterator.iterator$((Iterator)this);
        }

        public Option<byte[]> nextOption() {
            return Iterator.nextOption$((Iterator)this);
        }

        public boolean contains(Object elem) {
            return Iterator.contains$((Iterator)this, (Object)elem);
        }

        public BufferedIterator<byte[]> buffered() {
            return Iterator.buffered$((Iterator)this);
        }

        public <B> Iterator<B> padTo(int len, B elem) {
            return Iterator.padTo$((Iterator)this, (int)len, elem);
        }

        public Tuple2<Iterator<byte[]>, Iterator<byte[]>> partition(Function1<byte[], Object> p) {
            return Iterator.partition$((Iterator)this, p);
        }

        public <B> Iterator.GroupedIterator<B> grouped(int size) {
            return Iterator.grouped$((Iterator)this, (int)size);
        }

        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
        }

        public <B> int sliding$default$2() {
            return Iterator.sliding$default$2$((Iterator)this);
        }

        public <B> Iterator<B> scanLeft(B z, Function2<B, byte[], B> op) {
            return Iterator.scanLeft$((Iterator)this, z, op);
        }

        public <B> Iterator<B> scanRight(B z, Function2<byte[], B, B> op) {
            return Iterator.scanRight$((Iterator)this, z, op);
        }

        public int indexWhere(Function1<byte[], Object> p, int from) {
            return Iterator.indexWhere$((Iterator)this, p, (int)from);
        }

        public int indexWhere$default$2() {
            return Iterator.indexWhere$default$2$((Iterator)this);
        }

        public <B> int indexOf(B elem) {
            return Iterator.indexOf$((Iterator)this, elem);
        }

        public <B> int indexOf(B elem, int from) {
            return Iterator.indexOf$((Iterator)this, elem, (int)from);
        }

        public final int length() {
            return Iterator.length$((Iterator)this);
        }

        public boolean isEmpty() {
            return Iterator.isEmpty$((Iterator)this);
        }

        public Iterator<byte[]> filter(Function1<byte[], Object> p) {
            return Iterator.filter$((Iterator)this, p);
        }

        public Iterator<byte[]> filterNot(Function1<byte[], Object> p) {
            return Iterator.filterNot$((Iterator)this, p);
        }

        public Iterator<byte[]> filterImpl(Function1<byte[], Object> p, boolean isFlipped) {
            return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
        }

        public Iterator<byte[]> withFilter(Function1<byte[], Object> p) {
            return Iterator.withFilter$((Iterator)this, p);
        }

        public <B> Iterator<B> collect(PartialFunction<byte[], B> pf) {
            return Iterator.collect$((Iterator)this, pf);
        }

        public Iterator<byte[]> distinct() {
            return Iterator.distinct$((Iterator)this);
        }

        public <B> Iterator<byte[]> distinctBy(Function1<byte[], B> f) {
            return Iterator.distinctBy$((Iterator)this, f);
        }

        public <B> Iterator<B> map(Function1<byte[], B> f) {
            return Iterator.map$((Iterator)this, f);
        }

        public <B> Iterator<B> flatMap(Function1<byte[], IterableOnce<B>> f) {
            return Iterator.flatMap$((Iterator)this, f);
        }

        public <B> Iterator<B> flatten(Function1<byte[], IterableOnce<B>> ev) {
            return Iterator.flatten$((Iterator)this, ev);
        }

        public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
            return Iterator.concat$((Iterator)this, xs);
        }

        public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
            return Iterator.$plus$plus$((Iterator)this, xs);
        }

        public Iterator<byte[]> take(int n) {
            return Iterator.take$((Iterator)this, (int)n);
        }

        public Iterator<byte[]> takeWhile(Function1<byte[], Object> p) {
            return Iterator.takeWhile$((Iterator)this, p);
        }

        public Iterator<byte[]> drop(int n) {
            return Iterator.drop$((Iterator)this, (int)n);
        }

        public Iterator<byte[]> dropWhile(Function1<byte[], Object> p) {
            return Iterator.dropWhile$((Iterator)this, p);
        }

        public Tuple2<Iterator<byte[]>, Iterator<byte[]>> span(Function1<byte[], Object> p) {
            return Iterator.span$((Iterator)this, p);
        }

        public Iterator<byte[]> slice(int from, int until) {
            return Iterator.slice$((Iterator)this, (int)from, (int)until);
        }

        public Iterator<byte[]> sliceIterator(int from, int until) {
            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
        }

        public <B> Iterator<Tuple2<byte[], B>> zip(IterableOnce<B> that) {
            return Iterator.zip$((Iterator)this, that);
        }

        public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
        }

        public Iterator<Tuple2<byte[], Object>> zipWithIndex() {
            return Iterator.zipWithIndex$((Iterator)this);
        }

        public <B> boolean sameElements(IterableOnce<B> that) {
            return Iterator.sameElements$((Iterator)this, that);
        }

        public Tuple2<Iterator<byte[]>, Iterator<byte[]>> duplicate() {
            return Iterator.duplicate$((Iterator)this);
        }

        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
        }

        public <U$> Iterator<byte[]> tapEach(Function1<byte[], U$> f) {
            return Iterator.tapEach$((Iterator)this, f);
        }

        public String toString() {
            return Iterator.toString$((Iterator)this);
        }

        public Iterator<byte[]> seq() {
            return Iterator.seq$((Iterator)this);
        }

        public Tuple2<Iterator<byte[]>, Iterator<byte[]>> splitAt(int n) {
            return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
        }

        public boolean isTraversableAgain() {
            return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
        }

        public <U$> void foreach(Function1<byte[], U$> f) {
            IterableOnceOps.foreach$((IterableOnceOps)this, f);
        }

        public boolean forall(Function1<byte[], Object> p) {
            return IterableOnceOps.forall$((IterableOnceOps)this, p);
        }

        public boolean exists(Function1<byte[], Object> p) {
            return IterableOnceOps.exists$((IterableOnceOps)this, p);
        }

        public int count(Function1<byte[], Object> p) {
            return IterableOnceOps.count$((IterableOnceOps)this, p);
        }

        public Option<byte[]> find(Function1<byte[], Object> p) {
            return IterableOnceOps.find$((IterableOnceOps)this, p);
        }

        public <B> B foldLeft(B z, Function2<B, byte[], B> op) {
            return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
        }

        public <B> B foldRight(B z, Function2<byte[], B, B> op) {
            return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
        }

        public final <B> B $div$colon(B z, Function2<B, byte[], B> op) {
            return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
        }

        public final <B> B $colon$bslash(B z, Function2<byte[], B, B> op) {
            return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
        }

        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
            return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
        }

        public <B> B reduce(Function2<B, B, B> op) {
            return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
        }

        public <B> Option<B> reduceOption(Function2<B, B, B> op) {
            return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
        }

        public <B> B reduceLeft(Function2<B, byte[], B> op) {
            return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
        }

        public <B> B reduceRight(Function2<byte[], B, B> op) {
            return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
        }

        public <B> Option<B> reduceLeftOption(Function2<B, byte[], B> op) {
            return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
        }

        public <B> Option<B> reduceRightOption(Function2<byte[], B, B> op) {
            return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
        }

        public boolean nonEmpty() {
            return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
        }

        public int size() {
            return IterableOnceOps.size$((IterableOnceOps)this);
        }

        public final <B> void copyToBuffer(Buffer<B> dest) {
            IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
        }

        public <B> int copyToArray(Object xs) {
            return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
        }

        public <B> int copyToArray(Object xs, int start) {
            return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
        }

        public <B> int copyToArray(Object xs, int start, int len) {
            return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
        }

        public <B> B sum(Numeric<B> num) {
            return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
        }

        public <B> B product(Numeric<B> num) {
            return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
        }

        public Object min(Ordering ord) {
            return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
        }

        public <B> Option<byte[]> minOption(Ordering<B> ord) {
            return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
        }

        public Object max(Ordering ord) {
            return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
        }

        public <B> Option<byte[]> maxOption(Ordering<B> ord) {
            return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
        }

        public Object maxBy(Function1 f, Ordering cmp) {
            return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
        }

        public <B> Option<byte[]> maxByOption(Function1<byte[], B> f, Ordering<B> cmp) {
            return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
        }

        public Object minBy(Function1 f, Ordering cmp) {
            return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
        }

        public <B> Option<byte[]> minByOption(Function1<byte[], B> f, Ordering<B> cmp) {
            return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
        }

        public <B> Option<B> collectFirst(PartialFunction<byte[], B> pf) {
            return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
        }

        public <B> B aggregate(Function0<B> z, Function2<B, byte[], B> seqop, Function2<B, B, B> combop) {
            return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
        }

        public <B> boolean corresponds(IterableOnce<B> that, Function2<byte[], B, Object> p) {
            return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
        }

        public final String mkString(String start, String sep, String end) {
            return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
        }

        public final String mkString(String sep) {
            return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
        }

        public final String mkString() {
            return IterableOnceOps.mkString$((IterableOnceOps)this);
        }

        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
            return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
        }

        public final StringBuilder addString(StringBuilder b, String sep) {
            return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
        }

        public final StringBuilder addString(StringBuilder b) {
            return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
        }

        public <C1> C1 to(Factory<byte[], C1> factory) {
            return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
        }

        public final Iterator<byte[]> toIterator() {
            return IterableOnceOps.toIterator$((IterableOnceOps)this);
        }

        public List<byte[]> toList() {
            return IterableOnceOps.toList$((IterableOnceOps)this);
        }

        public Vector<byte[]> toVector() {
            return IterableOnceOps.toVector$((IterableOnceOps)this);
        }

        public <K, V> Map<K, V> toMap(.less.colon.less<byte[], Tuple2<K, V>> ev) {
            return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
        }

        public <B> Set<B> toSet() {
            return IterableOnceOps.toSet$((IterableOnceOps)this);
        }

        public Seq<byte[]> toSeq() {
            return IterableOnceOps.toSeq$((IterableOnceOps)this);
        }

        public IndexedSeq<byte[]> toIndexedSeq() {
            return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
        }

        public final Stream<byte[]> toStream() {
            return IterableOnceOps.toStream$((IterableOnceOps)this);
        }

        public final <B> Buffer<B> toBuffer() {
            return IterableOnceOps.toBuffer$((IterableOnceOps)this);
        }

        public <B> Object toArray(ClassTag<B> evidence$2) {
            return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
        }

        public Iterable<byte[]> reversed() {
            return IterableOnceOps.reversed$((IterableOnceOps)this);
        }

        public <S extends Stepper<?>> S stepper(StepperShape<byte[], S> shape) {
            return (S)IterableOnce.stepper$((IterableOnce)this, shape);
        }

        public int knownSize() {
            return IterableOnce.knownSize$((IterableOnce)this);
        }

        public Schema arrowSchema() {
            return this.arrowSchema;
        }

        private BufferAllocator allocator() {
            return this.allocator;
        }

        private VectorSchemaRoot root() {
            return this.root;
        }

        public VectorUnloader unloader() {
            return this.unloader;
        }

        public ArrowWriter arrowWriter() {
            return this.arrowWriter;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean hasNext() {
            if (this.rowIter.hasNext()) return true;
            this.close();
            if (!false) return false;
            return true;
        }

        public byte[] next() {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            WriteChannel writeChannel = new WriteChannel(Channels.newChannel(out));
            Utils$.MODULE$.tryWithSafeFinally((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                for (long rowCount = 0L; $this.rowIter.hasNext() && ($this.maxRecordsPerBatch <= 0L || rowCount < $this.maxRecordsPerBatch); ++rowCount) {
                    InternalRow row = (InternalRow)$this.rowIter.next();
                    this.arrowWriter().write(row);
                }
                this.arrowWriter().finish();
                ArrowRecordBatch batch = this.unloader().getRecordBatch();
                MessageSerializer.serialize((WriteChannel)writeChannel, (ArrowRecordBatch)batch);
                batch.close();
            }, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.arrowWriter().reset());
            return out.toByteArray();
        }

        @Override
        public void close() {
            this.root().close();
            this.allocator().close();
        }

        public ArrowBatchIterator(Iterator<InternalRow> rowIter, StructType schema, long maxRecordsPerBatch, String timeZoneId, TaskContext context) {
            this.rowIter = rowIter;
            this.maxRecordsPerBatch = maxRecordsPerBatch;
            IterableOnce.$init$((IterableOnce)this);
            IterableOnceOps.$init$((IterableOnceOps)this);
            Iterator.$init$((Iterator)this);
            this.arrowSchema = ArrowUtils$.MODULE$.toArrowSchema(schema, timeZoneId);
            this.allocator = ArrowUtils$.MODULE$.rootAllocator().newChildAllocator(new java.lang.StringBuilder(2).append("to").append(this.getClass().getSimpleName()).toString(), 0L, Long.MAX_VALUE);
            this.root = VectorSchemaRoot.create((Schema)this.arrowSchema(), (BufferAllocator)this.allocator());
            this.unloader = new VectorUnloader(this.root());
            this.arrowWriter = ArrowWriter$.MODULE$.create(this.root());
            Option$.MODULE$.apply((Object)context).foreach((Function1 & Serializable)x$1 -> x$1.addTaskCompletionListener((Function1 & Serializable)x$2 -> {
                this.close();
                return BoxedUnit.UNIT;
            }));
        }
    }

    public static class ArrowBatchWithSchemaIterator
    extends ArrowBatchIterator {
        private final Iterator<InternalRow> rowIter;
        private final long maxRecordsPerBatch;
        private final long maxEstimatedBatchSize;
        private final long arrowSchemaSize;
        private long rowCountInLastBatch;

        private long arrowSchemaSize() {
            return this.arrowSchemaSize;
        }

        public long rowCountInLastBatch() {
            return this.rowCountInLastBatch;
        }

        public void rowCountInLastBatch_$eq(long x$1) {
            this.rowCountInLastBatch = x$1;
        }

        @Override
        public byte[] next() {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            WriteChannel writeChannel = new WriteChannel(Channels.newChannel(out));
            this.rowCountInLastBatch_$eq(0L);
            LongRef estimatedBatchSize = LongRef.create((long)this.arrowSchemaSize());
            Utils$.MODULE$.tryWithSafeFinally((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                MessageSerializer.serialize((WriteChannel)writeChannel, (Schema)this.arrowSchema());
                while ($this.rowIter.hasNext() && (this.rowCountInLastBatch() == 0L && $this.maxEstimatedBatchSize > 0L || !this.isBatchSizeLimitExceeded$1(estimatedBatchSize) && !this.isRecordLimitExceeded$1())) {
                    int n;
                    InternalRow row = (InternalRow)$this.rowIter.next();
                    this.arrowWriter().write(row);
                    long l = estimatedBatchSize$1.elem;
                    InternalRow internalRow = row;
                    if (internalRow instanceof UnsafeRow) {
                        UnsafeRow unsafeRow = (UnsafeRow)internalRow;
                        n = unsafeRow.getSizeInBytes();
                    } else if (internalRow != null) {
                        InternalRow internalRow2 = internalRow;
                        n = internalRow2.numFields() * 16;
                    } else {
                        throw new MatchError((Object)internalRow);
                    }
                    estimatedBatchSize$1.elem = l + (long)n;
                    this.rowCountInLastBatch_$eq(this.rowCountInLastBatch() + 1L);
                }
                this.arrowWriter().finish();
                ArrowRecordBatch batch = this.unloader().getRecordBatch();
                MessageSerializer.serialize((WriteChannel)writeChannel, (ArrowRecordBatch)batch);
                ArrowStreamWriter.writeEndOfStream((WriteChannel)writeChannel, (IpcOption)IpcOption.DEFAULT);
                batch.close();
            }, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.arrowWriter().reset());
            return out.toByteArray();
        }

        private final boolean isBatchSizeLimitExceeded$1(LongRef estimatedBatchSize$1) {
            return this.maxEstimatedBatchSize > 0L && estimatedBatchSize$1.elem >= this.maxEstimatedBatchSize;
        }

        private final boolean isRecordLimitExceeded$1() {
            return this.maxRecordsPerBatch > 0L && this.rowCountInLastBatch() >= this.maxRecordsPerBatch;
        }

        public ArrowBatchWithSchemaIterator(Iterator<InternalRow> rowIter, StructType schema, long maxRecordsPerBatch, long maxEstimatedBatchSize, String timeZoneId, TaskContext context) {
            this.rowIter = rowIter;
            this.maxRecordsPerBatch = maxRecordsPerBatch;
            this.maxEstimatedBatchSize = maxEstimatedBatchSize;
            super(rowIter, schema, maxRecordsPerBatch, timeZoneId, context);
            this.arrowSchemaSize = SizeEstimator$.MODULE$.estimate((Object)this.arrowSchema());
            this.rowCountInLastBatch = 0L;
        }
    }

    public static abstract class InternalRowIterator
    implements Iterator<InternalRow> {
        private final Iterator<byte[]> arrowBatchIter;
        private final ArrayBuffer<AutoCloseable> resources;
        private final BufferAllocator allocator;
        private Tuple2<Iterator<InternalRow>, StructType> rowIterAndSchema;
        private final StructType schema;

        public final boolean hasDefiniteSize() {
            return Iterator.hasDefiniteSize$((Iterator)this);
        }

        public final Iterator<InternalRow> iterator() {
            return Iterator.iterator$((Iterator)this);
        }

        public Option<InternalRow> nextOption() {
            return Iterator.nextOption$((Iterator)this);
        }

        public boolean contains(Object elem) {
            return Iterator.contains$((Iterator)this, (Object)elem);
        }

        public BufferedIterator<InternalRow> buffered() {
            return Iterator.buffered$((Iterator)this);
        }

        public <B> Iterator<B> padTo(int len, B elem) {
            return Iterator.padTo$((Iterator)this, (int)len, elem);
        }

        public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> partition(Function1<InternalRow, Object> p) {
            return Iterator.partition$((Iterator)this, p);
        }

        public <B> Iterator.GroupedIterator<B> grouped(int size) {
            return Iterator.grouped$((Iterator)this, (int)size);
        }

        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
        }

        public <B> int sliding$default$2() {
            return Iterator.sliding$default$2$((Iterator)this);
        }

        public <B> Iterator<B> scanLeft(B z, Function2<B, InternalRow, B> op) {
            return Iterator.scanLeft$((Iterator)this, z, op);
        }

        public <B> Iterator<B> scanRight(B z, Function2<InternalRow, B, B> op) {
            return Iterator.scanRight$((Iterator)this, z, op);
        }

        public int indexWhere(Function1<InternalRow, Object> p, int from) {
            return Iterator.indexWhere$((Iterator)this, p, (int)from);
        }

        public int indexWhere$default$2() {
            return Iterator.indexWhere$default$2$((Iterator)this);
        }

        public <B> int indexOf(B elem) {
            return Iterator.indexOf$((Iterator)this, elem);
        }

        public <B> int indexOf(B elem, int from) {
            return Iterator.indexOf$((Iterator)this, elem, (int)from);
        }

        public final int length() {
            return Iterator.length$((Iterator)this);
        }

        public boolean isEmpty() {
            return Iterator.isEmpty$((Iterator)this);
        }

        public Iterator<InternalRow> filter(Function1<InternalRow, Object> p) {
            return Iterator.filter$((Iterator)this, p);
        }

        public Iterator<InternalRow> filterNot(Function1<InternalRow, Object> p) {
            return Iterator.filterNot$((Iterator)this, p);
        }

        public Iterator<InternalRow> filterImpl(Function1<InternalRow, Object> p, boolean isFlipped) {
            return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
        }

        public Iterator<InternalRow> withFilter(Function1<InternalRow, Object> p) {
            return Iterator.withFilter$((Iterator)this, p);
        }

        public <B> Iterator<B> collect(PartialFunction<InternalRow, B> pf) {
            return Iterator.collect$((Iterator)this, pf);
        }

        public Iterator<InternalRow> distinct() {
            return Iterator.distinct$((Iterator)this);
        }

        public <B> Iterator<InternalRow> distinctBy(Function1<InternalRow, B> f) {
            return Iterator.distinctBy$((Iterator)this, f);
        }

        public <B> Iterator<B> map(Function1<InternalRow, B> f) {
            return Iterator.map$((Iterator)this, f);
        }

        public <B> Iterator<B> flatMap(Function1<InternalRow, IterableOnce<B>> f) {
            return Iterator.flatMap$((Iterator)this, f);
        }

        public <B> Iterator<B> flatten(Function1<InternalRow, IterableOnce<B>> ev) {
            return Iterator.flatten$((Iterator)this, ev);
        }

        public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
            return Iterator.concat$((Iterator)this, xs);
        }

        public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
            return Iterator.$plus$plus$((Iterator)this, xs);
        }

        public Iterator<InternalRow> take(int n) {
            return Iterator.take$((Iterator)this, (int)n);
        }

        public Iterator<InternalRow> takeWhile(Function1<InternalRow, Object> p) {
            return Iterator.takeWhile$((Iterator)this, p);
        }

        public Iterator<InternalRow> drop(int n) {
            return Iterator.drop$((Iterator)this, (int)n);
        }

        public Iterator<InternalRow> dropWhile(Function1<InternalRow, Object> p) {
            return Iterator.dropWhile$((Iterator)this, p);
        }

        public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> span(Function1<InternalRow, Object> p) {
            return Iterator.span$((Iterator)this, p);
        }

        public Iterator<InternalRow> slice(int from, int until) {
            return Iterator.slice$((Iterator)this, (int)from, (int)until);
        }

        public Iterator<InternalRow> sliceIterator(int from, int until) {
            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
        }

        public <B> Iterator<Tuple2<InternalRow, B>> zip(IterableOnce<B> that) {
            return Iterator.zip$((Iterator)this, that);
        }

        public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
        }

        public Iterator<Tuple2<InternalRow, Object>> zipWithIndex() {
            return Iterator.zipWithIndex$((Iterator)this);
        }

        public <B> boolean sameElements(IterableOnce<B> that) {
            return Iterator.sameElements$((Iterator)this, that);
        }

        public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> duplicate() {
            return Iterator.duplicate$((Iterator)this);
        }

        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
        }

        public <U$> Iterator<InternalRow> tapEach(Function1<InternalRow, U$> f) {
            return Iterator.tapEach$((Iterator)this, f);
        }

        public String toString() {
            return Iterator.toString$((Iterator)this);
        }

        public Iterator<InternalRow> seq() {
            return Iterator.seq$((Iterator)this);
        }

        public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> splitAt(int n) {
            return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
        }

        public boolean isTraversableAgain() {
            return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
        }

        public <U$> void foreach(Function1<InternalRow, U$> f) {
            IterableOnceOps.foreach$((IterableOnceOps)this, f);
        }

        public boolean forall(Function1<InternalRow, Object> p) {
            return IterableOnceOps.forall$((IterableOnceOps)this, p);
        }

        public boolean exists(Function1<InternalRow, Object> p) {
            return IterableOnceOps.exists$((IterableOnceOps)this, p);
        }

        public int count(Function1<InternalRow, Object> p) {
            return IterableOnceOps.count$((IterableOnceOps)this, p);
        }

        public Option<InternalRow> find(Function1<InternalRow, Object> p) {
            return IterableOnceOps.find$((IterableOnceOps)this, p);
        }

        public <B> B foldLeft(B z, Function2<B, InternalRow, B> op) {
            return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
        }

        public <B> B foldRight(B z, Function2<InternalRow, B, B> op) {
            return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
        }

        public final <B> B $div$colon(B z, Function2<B, InternalRow, B> op) {
            return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
        }

        public final <B> B $colon$bslash(B z, Function2<InternalRow, B, B> op) {
            return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
        }

        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
            return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
        }

        public <B> B reduce(Function2<B, B, B> op) {
            return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
        }

        public <B> Option<B> reduceOption(Function2<B, B, B> op) {
            return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
        }

        public <B> B reduceLeft(Function2<B, InternalRow, B> op) {
            return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
        }

        public <B> B reduceRight(Function2<InternalRow, B, B> op) {
            return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
        }

        public <B> Option<B> reduceLeftOption(Function2<B, InternalRow, B> op) {
            return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
        }

        public <B> Option<B> reduceRightOption(Function2<InternalRow, B, B> op) {
            return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
        }

        public boolean nonEmpty() {
            return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
        }

        public int size() {
            return IterableOnceOps.size$((IterableOnceOps)this);
        }

        public final <B> void copyToBuffer(Buffer<B> dest) {
            IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
        }

        public <B> int copyToArray(Object xs) {
            return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
        }

        public <B> int copyToArray(Object xs, int start) {
            return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
        }

        public <B> int copyToArray(Object xs, int start, int len) {
            return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
        }

        public <B> B sum(Numeric<B> num) {
            return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
        }

        public <B> B product(Numeric<B> num) {
            return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
        }

        public Object min(Ordering ord) {
            return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
        }

        public <B> Option<InternalRow> minOption(Ordering<B> ord) {
            return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
        }

        public Object max(Ordering ord) {
            return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
        }

        public <B> Option<InternalRow> maxOption(Ordering<B> ord) {
            return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
        }

        public Object maxBy(Function1 f, Ordering cmp) {
            return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
        }

        public <B> Option<InternalRow> maxByOption(Function1<InternalRow, B> f, Ordering<B> cmp) {
            return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
        }

        public Object minBy(Function1 f, Ordering cmp) {
            return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
        }

        public <B> Option<InternalRow> minByOption(Function1<InternalRow, B> f, Ordering<B> cmp) {
            return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
        }

        public <B> Option<B> collectFirst(PartialFunction<InternalRow, B> pf) {
            return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
        }

        public <B> B aggregate(Function0<B> z, Function2<B, InternalRow, B> seqop, Function2<B, B, B> combop) {
            return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
        }

        public <B> boolean corresponds(IterableOnce<B> that, Function2<InternalRow, B, Object> p) {
            return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
        }

        public final String mkString(String start, String sep, String end) {
            return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
        }

        public final String mkString(String sep) {
            return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
        }

        public final String mkString() {
            return IterableOnceOps.mkString$((IterableOnceOps)this);
        }

        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
            return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
        }

        public final StringBuilder addString(StringBuilder b, String sep) {
            return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
        }

        public final StringBuilder addString(StringBuilder b) {
            return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
        }

        public <C1> C1 to(Factory<InternalRow, C1> factory) {
            return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
        }

        public final Iterator<InternalRow> toIterator() {
            return IterableOnceOps.toIterator$((IterableOnceOps)this);
        }

        public List<InternalRow> toList() {
            return IterableOnceOps.toList$((IterableOnceOps)this);
        }

        public Vector<InternalRow> toVector() {
            return IterableOnceOps.toVector$((IterableOnceOps)this);
        }

        public <K, V> Map<K, V> toMap(.less.colon.less<InternalRow, Tuple2<K, V>> ev) {
            return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
        }

        public <B> Set<B> toSet() {
            return IterableOnceOps.toSet$((IterableOnceOps)this);
        }

        public Seq<InternalRow> toSeq() {
            return IterableOnceOps.toSeq$((IterableOnceOps)this);
        }

        public IndexedSeq<InternalRow> toIndexedSeq() {
            return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
        }

        public final Stream<InternalRow> toStream() {
            return IterableOnceOps.toStream$((IterableOnceOps)this);
        }

        public final <B> Buffer<B> toBuffer() {
            return IterableOnceOps.toBuffer$((IterableOnceOps)this);
        }

        public <B> Object toArray(ClassTag<B> evidence$2) {
            return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
        }

        public Iterable<InternalRow> reversed() {
            return IterableOnceOps.reversed$((IterableOnceOps)this);
        }

        public <S extends Stepper<?>> S stepper(StepperShape<InternalRow, S> shape) {
            return (S)IterableOnce.stepper$((IterableOnce)this, shape);
        }

        public int knownSize() {
            return IterableOnce.knownSize$((IterableOnce)this);
        }

        public ArrayBuffer<AutoCloseable> resources() {
            return this.resources;
        }

        public BufferAllocator allocator() {
            return this.allocator;
        }

        private Tuple2<Iterator<InternalRow>, StructType> rowIterAndSchema() {
            return this.rowIterAndSchema;
        }

        private void rowIterAndSchema_$eq(Tuple2<Iterator<InternalRow>, StructType> x$1) {
            this.rowIterAndSchema = x$1;
        }

        public StructType schema() {
            return this.schema;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean hasNext() {
            if (((Iterator)this.rowIterAndSchema()._1()).hasNext()) return true;
            if (this.arrowBatchIter.hasNext()) {
                this.rowIterAndSchema_$eq(this.nextBatch());
                StructType structType = this.schema();
                Object object = this.rowIterAndSchema()._2();
                if (structType == null ? object != null : !structType.equals(object)) {
                    throw new IllegalArgumentException(new java.lang.StringBuilder(0).append("ArrowBatch iterator contain 2 batches with").append(new java.lang.StringBuilder(24).append(" different schema: ").append(this.schema()).append(" and ").append(this.rowIterAndSchema()._2()).toString()).toString());
                }
            } else {
                ArrowConverters$.MODULE$.org$apache$spark$sql$execution$arrow$ArrowConverters$$closeAll((Seq<AutoCloseable>)((Seq)this.resources().toSeq().reverse()));
                return false;
            }
            boolean bl = ((Iterator)this.rowIterAndSchema()._1()).hasNext();
            if (!bl) return false;
            return true;
        }

        public InternalRow next() {
            return (InternalRow)((Iterator)this.rowIterAndSchema()._1()).next();
        }

        public abstract Tuple2<Iterator<InternalRow>, StructType> nextBatch();

        public InternalRowIterator(Iterator<byte[]> arrowBatchIter, TaskContext context) {
            this.arrowBatchIter = arrowBatchIter;
            IterableOnce.$init$((IterableOnce)this);
            IterableOnceOps.$init$((IterableOnceOps)this);
            Iterator.$init$((Iterator)this);
            this.resources = new ArrayBuffer();
            this.allocator = ArrowUtils$.MODULE$.rootAllocator().newChildAllocator(new java.lang.StringBuilder(2).append("to").append(this.getClass().getSimpleName()).toString(), 0L, Long.MAX_VALUE);
            this.resources().append((Object)this.allocator());
            this.rowIterAndSchema = arrowBatchIter.hasNext() ? this.nextBatch() : new Tuple2((Object)package$.MODULE$.Iterator().empty(), null);
            this.schema = (StructType)this.rowIterAndSchema()._2();
            Object object = context != null ? context.addTaskCompletionListener((Function1 & Serializable)x$3 -> {
                ArrowConverters$.MODULE$.org$apache$spark$sql$execution$arrow$ArrowConverters$$closeAll((Seq<AutoCloseable>)((Seq)this.resources().toSeq().reverse()));
                return BoxedUnit.UNIT;
            }) : BoxedUnit.UNIT;
        }
    }

    public static class InternalRowIteratorWithSchema
    extends InternalRowIterator {
        private final Iterator<byte[]> arrowBatchIter;

        @Override
        public Tuple2<Iterator<InternalRow>, StructType> nextBatch() {
            ArrowStreamReader reader = new ArrowStreamReader((InputStream)new ByteArrayInputStream((byte[])this.arrowBatchIter.next()), this.allocator());
            VectorSchemaRoot root = reader.loadNextBatch() ? reader.getVectorSchemaRoot() : null;
            this.resources().append((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{reader, root}));
            return root == null ? new Tuple2((Object)package$.MODULE$.Iterator().empty(), null) : new Tuple2(ArrowConverters$.MODULE$.org$apache$spark$sql$execution$arrow$ArrowConverters$$vectorSchemaRootToIter(root), (Object)ArrowUtils$.MODULE$.fromArrowSchema(root.getSchema()));
        }

        public InternalRowIteratorWithSchema(Iterator<byte[]> arrowBatchIter, TaskContext context) {
            this.arrowBatchIter = arrowBatchIter;
            super(arrowBatchIter, context);
        }
    }

    public static class InternalRowIteratorWithoutSchema
    extends InternalRowIterator {
        private final Iterator<byte[]> arrowBatchIter;
        private final StructType schema;
        private final String timeZoneId;

        @Override
        public Tuple2<Iterator<InternalRow>, StructType> nextBatch() {
            Schema arrowSchema = ArrowUtils$.MODULE$.toArrowSchema(this.schema, this.timeZoneId);
            VectorSchemaRoot root = VectorSchemaRoot.create((Schema)arrowSchema, (BufferAllocator)this.allocator());
            this.resources().append((Object)root);
            ArrowRecordBatch arrowRecordBatch = ArrowConverters$.MODULE$.loadBatch((byte[])this.arrowBatchIter.next(), this.allocator());
            VectorLoader vectorLoader = new VectorLoader(root);
            vectorLoader.load(arrowRecordBatch);
            arrowRecordBatch.close();
            return new Tuple2(ArrowConverters$.MODULE$.org$apache$spark$sql$execution$arrow$ArrowConverters$$vectorSchemaRootToIter(root), (Object)this.schema);
        }

        public InternalRowIteratorWithoutSchema(Iterator<byte[]> arrowBatchIter, StructType schema, String timeZoneId, TaskContext context) {
            this.arrowBatchIter = arrowBatchIter;
            this.schema = schema;
            this.timeZoneId = timeZoneId;
            super(arrowBatchIter, context);
        }
    }
}

