/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.AlterTableChangeColumnCommand$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t%b\u0001B\u0010!\u00016B\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t)\u0002\u0011\t\u0012)A\u0005!\"AQ\u000b\u0001BK\u0002\u0013\u0005a\u000b\u0003\u0005`\u0001\tE\t\u0015!\u0003X\u0011!\u0001\u0007A!f\u0001\n\u0003\t\u0007\u0002\u00035\u0001\u0005#\u0005\u000b\u0011\u00022\t\u000b%\u0004A\u0011\u00016\t\u000b=\u0004A\u0011\t9\t\u000bu\u0004A\u0011\u0002@\t\u000f\u0005e\u0002\u0001\"\u0003\u0002<!9\u00111\n\u0001\u0005\n\u00055\u0003bBA+\u0001\u0011%\u0011q\u000b\u0005\n\u0003S\u0002\u0011\u0011!C\u0001\u0003WB\u0011\"a\u001d\u0001#\u0003%\t!!\u001e\t\u0013\u0005-\u0005!%A\u0005\u0002\u00055\u0005\"CAI\u0001E\u0005I\u0011AAJ\u0011%\t9\nAA\u0001\n\u0003\nI\nC\u0005\u0002*\u0002\t\t\u0011\"\u0001\u0002,\"I\u00111\u0017\u0001\u0002\u0002\u0013\u0005\u0011Q\u0017\u0005\n\u0003\u0003\u0004\u0011\u0011!C!\u0003\u0007D\u0011\"!5\u0001\u0003\u0003%\t!a5\t\u0013\u0005]\u0007!!A\u0005B\u0005e\u0007\"CAo\u0001\u0005\u0005I\u0011IAp\u000f%\t\u0019\u000fIA\u0001\u0012\u0003\t)O\u0002\u0005 A\u0005\u0005\t\u0012AAt\u0011\u0019I\u0017\u0004\"\u0001\u0002\u0000\"I!\u0011A\r\u0002\u0002\u0013\u0015#1\u0001\u0005\n\u0005\u000bI\u0012\u0011!CA\u0005\u000fA\u0011Ba\u0004\u001a\u0003\u0003%\tI!\u0005\t\u0013\t}\u0011$!A\u0005\n\t\u0005\"!H!mi\u0016\u0014H+\u00192mK\u000eC\u0017M\\4f\u0007>dW/\u001c8D_6l\u0017M\u001c3\u000b\u0005\u0005\u0012\u0013aB2p[6\fg\u000e\u001a\u0006\u0003G\u0011\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u00152\u0013aA:rY*\u0011q\u0005K\u0001\u0006gB\f'o\u001b\u0006\u0003S)\na!\u00199bG\",'\"A\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001q\u0003\b\u0010\"\u0011\u0005=2T\"\u0001\u0019\u000b\u0005E\u0012\u0014a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003gQ\nQ\u0001\u001d7b]NT!!\u000e\u0013\u0002\u0011\r\fG/\u00197zgRL!a\u000e\u0019\u0003\u00171{w-[2bYBc\u0017M\u001c\t\u0003sij\u0011\u0001I\u0005\u0003w\u0001\u00121\u0003T3bMJ+hN\\1cY\u0016\u001cu.\\7b]\u0012\u0004\"!\u0010!\u000e\u0003yR\u0011aP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0003z\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002D\u0017:\u0011A)\u0013\b\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f2\na\u0001\u0010:p_Rt\u0014\"A \n\u0005)s\u0014a\u00029bG.\fw-Z\u0005\u0003\u00196\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!A\u0013 \u0002\u0013Q\f'\r\\3OC6,W#\u0001)\u0011\u0005E\u0013V\"\u0001\u001b\n\u0005M#$a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\u0002\u0015Q\f'\r\\3OC6,\u0007%\u0001\u0006d_2,XN\u001c(b[\u0016,\u0012a\u0016\t\u00031rs!!\u0017.\u0011\u0005\u0015s\u0014BA.?\u0003\u0019\u0001&/\u001a3fM&\u0011QL\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005ms\u0014aC2pYVlgNT1nK\u0002\n\u0011B\\3x\u0007>dW/\u001c8\u0016\u0003\t\u0004\"a\u00194\u000e\u0003\u0011T!!\u001a\u0013\u0002\u000bQL\b/Z:\n\u0005\u001d$'aC*ueV\u001cGOR5fY\u0012\f!B\\3x\u0007>dW/\u001c8!\u0003\u0019a\u0014N\\5u}Q!1\u000e\\7o!\tI\u0004\u0001C\u0003O\u000f\u0001\u0007\u0001\u000bC\u0003V\u000f\u0001\u0007q\u000bC\u0003a\u000f\u0001\u0007!-A\u0002sk:$\"!\u001d=\u0011\u0007\r\u0013H/\u0003\u0002t\u001b\n\u00191+Z9\u0011\u0005U4X\"\u0001\u0013\n\u0005]$#a\u0001*po\")\u0011\u0010\u0003a\u0001u\u0006a1\u000f]1sWN+7o]5p]B\u0011Qo_\u0005\u0003y\u0012\u0012Ab\u00159be.\u001cVm]:j_:\f\u0001CZ5oI\u000e{G.^7o\u0005ft\u0015-\\3\u0015\r\t|\u0018\u0011BA\u0007\u0011\u001d\t\t!\u0003a\u0001\u0003\u0007\taa]2iK6\f\u0007cA2\u0002\u0006%\u0019\u0011q\u00013\u0003\u0015M#(/^2u)f\u0004X\r\u0003\u0004\u0002\f%\u0001\raV\u0001\u0005]\u0006lW\rC\u0004\u0002\u0010%\u0001\r!!\u0005\u0002\u0011I,7o\u001c7wKJ\u0004B!a\u0005\u000249!\u0011QCA\u0018\u001d\u0011\t9\"a\u000b\u000f\t\u0005e\u0011\u0011\u0006\b\u0005\u00037\t9C\u0004\u0003\u0002\u001e\u0005\u0015b\u0002BA\u0010\u0003Gq1!RA\u0011\u0013\u0005Y\u0013BA\u0015+\u0013\t9\u0003&\u0003\u0002&M%\u0011Q\u0007J\u0005\u0004\u0003[!\u0014\u0001C1oC2L8/[:\n\u0007)\u000b\tDC\u0002\u0002.QJA!!\u000e\u00028\tA!+Z:pYZ,'OC\u0002K\u0003c\t!\"\u00193e\u0007>lW.\u001a8u)\u0015\u0011\u0017QHA!\u0011\u0019\tyD\u0003a\u0001E\u000611m\u001c7v[:Dq!a\u0011\u000b\u0001\u0004\t)%A\u0004d_6lWM\u001c;\u0011\tu\n9eV\u0005\u0004\u0003\u0013r$AB(qi&|g.\u0001\fbI\u0012\u001cUO\u001d:f]R$UMZ1vYR4\u0016\r\\;f)\u0015\u0011\u0017qJA)\u0011\u0019\tyd\u0003a\u0001E\"9\u00111K\u0006A\u0002\u0005\u0015\u0013!\u0002<bYV,\u0017aC2pYVlg.R9vC2$\u0002\"!\u0017\u0002`\u0005\r\u0014q\r\t\u0004{\u0005m\u0013bAA/}\t9!i\\8mK\u0006t\u0007BBA1\u0019\u0001\u0007!-A\u0003gS\u0016dG\r\u0003\u0004\u0002f1\u0001\rAY\u0001\u0006_RDWM\u001d\u0005\b\u0003\u001fa\u0001\u0019AA\t\u0003\u0011\u0019w\u000e]=\u0015\u000f-\fi'a\u001c\u0002r!9a*\u0004I\u0001\u0002\u0004\u0001\u0006bB+\u000e!\u0003\u0005\ra\u0016\u0005\bA6\u0001\n\u00111\u0001c\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u001e+\u0007A\u000bIh\u000b\u0002\u0002|A!\u0011QPAD\u001b\t\tyH\u0003\u0003\u0002\u0002\u0006\r\u0015!C;oG\",7m[3e\u0015\r\t)IP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAE\u0003\u007f\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a$+\u0007]\u000bI(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005U%f\u00012\u0002z\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a'\u0011\t\u0005u\u0015qU\u0007\u0003\u0003?SA!!)\u0002$\u0006!A.\u00198h\u0015\t\t)+\u0001\u0003kCZ\f\u0017bA/\u0002 \u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0016\t\u0004{\u0005=\u0016bAAY}\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qWA_!\ri\u0014\u0011X\u0005\u0004\u0003ws$aA!os\"I\u0011qX\n\u0002\u0002\u0003\u0007\u0011QV\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u0015\u0007CBAd\u0003\u001b\f9,\u0004\u0002\u0002J*\u0019\u00111\u001a \u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002P\u0006%'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u0017\u0002V\"I\u0011qX\u000b\u0002\u0002\u0003\u0007\u0011qW\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\u001c\u0006m\u0007\"CA`-\u0005\u0005\t\u0019AAW\u0003\u0019)\u0017/^1mgR!\u0011\u0011LAq\u0011%\tylFA\u0001\u0002\u0004\t9,A\u000fBYR,'\u000fV1cY\u0016\u001c\u0005.\u00198hK\u000e{G.^7o\u0007>lW.\u00198e!\tI\u0014dE\u0003\u001a\u0003S\f)\u0010\u0005\u0005\u0002l\u0006E\bk\u00162l\u001b\t\tiOC\u0002\u0002pz\nqA];oi&lW-\u0003\u0003\u0002t\u00065(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogA!\u0011q_A\u007f\u001b\t\tIP\u0003\u0003\u0002|\u0006\r\u0016AA5p\u0013\ra\u0015\u0011 \u000b\u0003\u0003K\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00037\u000bQ!\u00199qYf$ra\u001bB\u0005\u0005\u0017\u0011i\u0001C\u0003O9\u0001\u0007\u0001\u000bC\u0003V9\u0001\u0007q\u000bC\u0003a9\u0001\u0007!-A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tM!1\u0004\t\u0006{\u0005\u001d#Q\u0003\t\u0007{\t]\u0001k\u00162\n\u0007\teaH\u0001\u0004UkBdWm\r\u0005\t\u0005;i\u0012\u0011!a\u0001W\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t\r\u0002\u0003BAO\u0005KIAAa\n\u0002 \n1qJ\u00196fGR\u0004")
public class AlterTableChangeColumnCommand
extends LogicalPlan
implements LeafRunnableCommand,
Serializable {
    private final TableIdentifier tableName;
    private final String columnName;
    private final StructField newColumn;
    private Map<String, SQLMetric> metrics;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<TableIdentifier, String, StructField>> unapply(AlterTableChangeColumnCommand x$0) {
        return AlterTableChangeColumnCommand$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<TableIdentifier, String, StructField>, AlterTableChangeColumnCommand> tupled() {
        return AlterTableChangeColumnCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<String, Function1<StructField, AlterTableChangeColumnCommand>>> curried() {
        return AlterTableChangeColumnCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterTableChangeColumnCommand alterTableChangeColumnCommand = this;
        synchronized (alterTableChangeColumnCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public String columnName() {
        return this.columnName;
    }

    public StructField newColumn() {
        return this.newColumn;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable table = catalog.getTableRawMetadata(this.tableName());
        Function2 resolver = sparkSession.sessionState().conf().resolver();
        DDLUtils$.MODULE$.verifyAlterTableType(catalog, table, false);
        StructField originColumn = this.findColumnByName(table.dataSchema(), this.columnName(), (Function2<String, String, Object>)resolver);
        if (!this.columnEqual(originColumn, this.newColumn(), (Function2<String, String, Object>)resolver)) {
            throw QueryCompilationErrors$.MODULE$.alterTableChangeColumnNotSupportedForColumnTypeError(originColumn, this.newColumn());
        }
        StructField[] newDataSchema = (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])table.dataSchema().fields()), (Function1 & Serializable)field -> {
            StructField structField;
            String string = field.name();
            String string2 = originColumn.name();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                StructField withNewComment = this.addComment((StructField)field, (Option<String>)this.newColumn().getComment());
                if (this.newColumn().getCurrentDefaultValue().isDefined()) {
                    if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)this.newColumn().getCurrentDefaultValue().get()))) {
                        StructField result = this.addCurrentDefaultValue(withNewComment, (Option<String>)this.newColumn().getCurrentDefaultValue());
                        ResolveDefaultColumns$.MODULE$.analyze(result, "ALTER TABLE ALTER COLUMN", ResolveDefaultColumns$.MODULE$.analyze$default$3());
                        structField = result;
                    } else {
                        structField = withNewComment.clearCurrentDefaultValue();
                    }
                } else {
                    structField = withNewComment;
                }
            } else {
                structField = field;
            }
            return structField;
        }, ClassTag$.MODULE$.apply(StructField.class));
        catalog.alterTableDataSchema(this.tableName(), new StructType(newDataSchema));
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private StructField findColumnByName(StructType schema, String name, Function2<String, String, Object> resolver) {
        return (StructField)ArrayOps$.MODULE$.collectFirst$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (PartialFunction)new Serializable(null, resolver, name){
            private static final long serialVersionUID = 0L;
            private final Function2 resolver$1;
            private final String name$1;

            public final <A1 extends StructField, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = BoxesRunTime.unboxToBoolean((Object)this.resolver$1.apply((Object)A1.name(), (Object)this.name$1)) ? A1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(StructField x1) {
                StructField structField = x1;
                boolean bl = BoxesRunTime.unboxToBoolean((Object)this.resolver$1.apply((Object)structField.name(), (Object)this.name$1));
                return bl;
            }
            {
                this.resolver$1 = resolver$1;
                this.name$1 = name$1;
            }
        }).getOrElse((Function0 & Serializable)() -> {
            throw QueryCompilationErrors$.MODULE$.cannotFindColumnError(name, schema.fieldNames());
        });
    }

    private StructField addComment(StructField column, Option<String> comment2) {
        return (StructField)comment2.map((Function1 & Serializable)comment -> column.withComment(comment)).getOrElse((Function0 & Serializable)() -> column);
    }

    private StructField addCurrentDefaultValue(StructField column, Option<String> value2) {
        return (StructField)value2.map((Function1 & Serializable)value -> column.withCurrentDefaultValue(value)).getOrElse((Function0 & Serializable)() -> column);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean columnEqual(StructField field, StructField other, Function2<String, String, Object> resolver) {
        if (!BoxesRunTime.unboxToBoolean((Object)resolver.apply((Object)field.name(), (Object)other.name()))) return false;
        DataType dataType = field.dataType();
        DataType dataType2 = other.dataType();
        if (dataType != null) {
            if (!dataType.equals(dataType2)) return false;
            return true;
        }
        if (dataType2 == null) return true;
        return false;
    }

    public AlterTableChangeColumnCommand copy(TableIdentifier tableName, String columnName, StructField newColumn) {
        return new AlterTableChangeColumnCommand(tableName, columnName, newColumn);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public String copy$default$2() {
        return this.columnName();
    }

    public StructField copy$default$3() {
        return this.newColumn();
    }

    public String productPrefix() {
        return "AlterTableChangeColumnCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableName();
                break;
            }
            case 1: {
                object = this.columnName();
                break;
            }
            case 2: {
                object = this.newColumn();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableChangeColumnCommand;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "tableName";
                break;
            }
            case 1: {
                string = "columnName";
                break;
            }
            case 2: {
                string = "newColumn";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableChangeColumnCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableChangeColumnCommand alterTableChangeColumnCommand = (AlterTableChangeColumnCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = alterTableChangeColumnCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        String string = this.columnName();
        String string2 = alterTableChangeColumnCommand.columnName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        StructField structField = this.newColumn();
        StructField structField2 = alterTableChangeColumnCommand.newColumn();
        if (structField == null) {
            if (structField2 != null) {
                return false;
            }
        } else if (!structField.equals(structField2)) return false;
        if (!alterTableChangeColumnCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableChangeColumnCommand(TableIdentifier tableName, String columnName, StructField newColumn) {
        this.tableName = tableName;
        this.columnName = columnName;
        this.newColumn = newColumn;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
        Statics.releaseFence();
    }
}

