/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.compression.PassThrough$;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tUsAB\u0013'\u0011\u0003CCG\u0002\u00047M!\u0005\u0005f\u000e\u0005\u0006#\u0006!\tA\u0015\u0005\b'\u0006\u0011\r\u0011\"\u0011U\u0011\u0019A\u0016\u0001)A\u0005+\")\u0011,\u0001C!5\")\u0001/\u0001C!c\"9\u0011QH\u0001\u0005B\u0005}b\u0001B;\u0002\u0001YD\u0011b\u0018\u0005\u0003\u0002\u0003\u0006I!!\u0003\t\rECA\u0011AA\b\u0011\u0019\t)\u0002\u0003C!)\"1\u0011q\u0003\u0005\u0005BQCq!!\u0007\t\t\u0003\nYB\u0002\u0004\u0002F\u0005\u0001\u0011q\t\u0005\u000b\u0003'r!\u0011!Q\u0001\n\u0005u\u0001\"C0\u000f\u0005\u0003\u0005\u000b\u0011BA+\u0011\u0019\tf\u0002\"\u0001\u0002X!9\u0011q\f\b\u0005B\u0005\u0005\u0004bBA?\u001d\u0011\u0005\u0013q\u0010\u0005\b\u0003\u0003sA\u0011BAB\u0011\u001d\t\tK\u0004C\u0005\u0003GCq!!,\u000f\t\u0013\ty\u000bC\u0004\u0002::!I!a/\t\u000f\u0005\u0015g\u0002\"\u0003\u0002H\"9\u0011\u0011\u001b\b\u0005\n\u0005M\u0007bBAo\u001d\u0011%\u0011q\u001c\u0005\b\u0003StA\u0011BAv\u0011\u001d\u0011\tA\u0004C!\u0005\u0007A\u0011Ba\u0005\u0002\u0003\u0003%\tE!\u0006\t\u0011\t\r\u0012!!A\u0005\u0002QC\u0011B!\n\u0002\u0003\u0003%\tAa\n\t\u0013\t5\u0012!!A\u0005B\t=\u0002\"\u0003B\u001f\u0003\u0005\u0005I\u0011\u0001B \u0011%\u0011\u0019%AA\u0001\n\u0003\u0012)\u0005C\u0005\u0003H\u0005\t\t\u0011\"\u0011\u0003J!I!1J\u0001\u0002\u0002\u0013%!QJ\u0001\f!\u0006\u001c8\u000f\u00165s_V<\u0007N\u0003\u0002(Q\u0005Y1m\\7qe\u0016\u001c8/[8o\u0015\tI#&\u0001\u0005d_2,XN\\1s\u0015\tYC&A\u0005fq\u0016\u001cW\u000f^5p]*\u0011QFL\u0001\u0004gFd'BA\u00181\u0003\u0015\u0019\b/\u0019:l\u0015\t\t$'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002g\u0005\u0019qN]4\u0011\u0005U\nQ\"\u0001\u0014\u0003\u0017A\u000b7o\u001d+ie>,x\r[\n\u0006\u0003ar\u0014\t\u0012\t\u0003sqj\u0011A\u000f\u0006\u0002w\u0005)1oY1mC&\u0011QH\u000f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005Uz\u0014B\u0001!'\u0005E\u0019u.\u001c9sKN\u001c\u0018n\u001c8TG\",W.\u001a\t\u0003s\tK!a\u0011\u001e\u0003\u000fA\u0013x\u000eZ;diB\u0011QI\u0014\b\u0003\r2s!aR&\u000e\u0003!S!!\u0013&\u0002\rq\u0012xn\u001c;?\u0007\u0001I\u0011aO\u0005\u0003\u001bj\nq\u0001]1dW\u0006<W-\u0003\u0002P!\na1+\u001a:jC2L'0\u00192mK*\u0011QJO\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Q\na\u0001^=qK&#W#A+\u0011\u0005e2\u0016BA,;\u0005\rIe\u000e^\u0001\bif\u0004X-\u00133!\u0003!\u0019X\u000f\u001d9peR\u001cHCA._!\tID,\u0003\u0002^u\t9!i\\8mK\u0006t\u0007\"B0\u0006\u0001\u0004\u0001\u0017AC2pYVlg\u000eV=qKB\u0012\u0011m\u001a\t\u0004E\u000e,W\"\u0001\u0015\n\u0005\u0011D#AC\"pYVlg\u000eV=qKB\u0011am\u001a\u0007\u0001\t%Ag,!A\u0001\u0002\u000b\u0005\u0011NA\u0002`IE\n\"A[7\u0011\u0005eZ\u0017B\u00017;\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!\u000f8\n\u0005=T$aA!os\u00069QM\\2pI\u0016\u0014Xc\u0001:\u00028Q\u00191/!\u000f\u0011\tQD\u0011QG\u0007\u0002\u0003\t9QI\\2pI\u0016\u0014XCA<|'\rA\u0001\b\u001f\t\u0004keT\u0018BA;'!\t17\u0010B\u0003}\u0011\t\u0007QPA\u0001U#\tQg\u0010E\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\rA&A\u0003usB,7/\u0003\u0003\u0002\b\u0005\u0005!AC!u_6L7\rV=qKB!!-a\u0003{\u0013\r\ti\u0001\u000b\u0002\u0011\u001d\u0006$\u0018N^3D_2,XN\u001c+za\u0016$B!!\u0005\u0002\u0014A\u0019A\u000f\u0003>\t\r}S\u0001\u0019AA\u0005\u0003A)hnY8naJ,7o]3e'&TX-\u0001\bd_6\u0004(/Z:tK\u0012\u001c\u0016N_3\u0002\u0011\r|W\u000e\u001d:fgN$b!!\b\u0002.\u0005E\u0002\u0003BA\u0010\u0003Si!!!\t\u000b\t\u0005\r\u0012QE\u0001\u0004]&|'BAA\u0014\u0003\u0011Q\u0017M^1\n\t\u0005-\u0012\u0011\u0005\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\bbBA\u0018\u001b\u0001\u0007\u0011QD\u0001\u0005MJ|W\u000eC\u0004\u000245\u0001\r!!\b\u0002\u0005Q|\u0007c\u00014\u00028\u0011)AP\u0002b\u0001{\"1qL\u0002a\u0001\u0003w\u0001RAYA\u0006\u0003k\tq\u0001Z3d_\u0012,'/\u0006\u0003\u0002B\t-ACBA\"\u0005\u001b\u0011y\u0001\u0005\u0003u\u001d\t%!a\u0002#fG>$WM]\u000b\u0005\u0003\u0013\n\tf\u0005\u0003\u000fq\u0005-\u0003#B\u001b\u0002N\u0005=\u0013bAA#MA\u0019a-!\u0015\u0005\u000bqt!\u0019A?\u0002\r\t,hMZ3s!\u0015\u0011\u00171BA()\u0019\tI&a\u0017\u0002^A!AODA(\u0011\u001d\t\u0019&\u0005a\u0001\u0003;AaaX\tA\u0002\u0005U\u0013\u0001\u00028fqR$b!a\u0019\u0002j\u0005e\u0004cA\u001d\u0002f%\u0019\u0011q\r\u001e\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003W\u0012\u0002\u0019AA7\u0003\r\u0011xn\u001e\t\u0005\u0003_\n)(\u0004\u0002\u0002r)\u0019\u00111\u000f\u0017\u0002\u0011\r\fG/\u00197zgRLA!a\u001e\u0002r\tY\u0011J\u001c;fe:\fGNU8x\u0011\u0019\tYH\u0005a\u0001+\u00069qN\u001d3j]\u0006d\u0017a\u00025bg:+\u0007\u0010^\u000b\u00027\u0006Y\u0001/\u001e;C_>dW-\u00198t))\t\u0019'!\"\u0002\u0016\u0006e\u0015Q\u0014\u0005\b\u0003\u000f#\u0002\u0019AAE\u00031\u0019w\u000e\\;n]Z+7\r^8s!\u0011\tY)!%\u000e\u0005\u00055%bAAHU\u0005Qa/Z2u_JL'0\u001a3\n\t\u0005M\u0015Q\u0012\u0002\u0015/JLG/\u00192mK\u000e{G.^7o-\u0016\u001cGo\u001c:\t\r\u0005]E\u00031\u0001V\u0003\r\u0001xn\u001d\u0005\u0007\u00037#\u0002\u0019A+\u0002\u0013\t,hMZ3s!>\u001c\bBBAP)\u0001\u0007Q+A\u0002mK:\f\u0001\u0002];u\u0005f$Xm\u001d\u000b\u000b\u0003G\n)+a*\u0002*\u0006-\u0006bBAD+\u0001\u0007\u0011\u0011\u0012\u0005\u0007\u0003/+\u0002\u0019A+\t\r\u0005mU\u00031\u0001V\u0011\u0019\ty*\u0006a\u0001+\u0006I\u0001/\u001e;TQ>\u0014Ho\u001d\u000b\u000b\u0003G\n\t,a-\u00026\u0006]\u0006bBAD-\u0001\u0007\u0011\u0011\u0012\u0005\u0007\u0003/3\u0002\u0019A+\t\r\u0005me\u00031\u0001V\u0011\u0019\tyJ\u0006a\u0001+\u00069\u0001/\u001e;J]R\u001cHCCA2\u0003{\u000by,!1\u0002D\"9\u0011qQ\fA\u0002\u0005%\u0005BBAL/\u0001\u0007Q\u000b\u0003\u0004\u0002\u001c^\u0001\r!\u0016\u0005\u0007\u0003?;\u0002\u0019A+\u0002\u0011A,H\u000fT8oON$\"\"a\u0019\u0002J\u0006-\u0017QZAh\u0011\u001d\t9\t\u0007a\u0001\u0003\u0013Ca!a&\u0019\u0001\u0004)\u0006BBAN1\u0001\u0007Q\u000b\u0003\u0004\u0002 b\u0001\r!V\u0001\naV$h\t\\8biN$\"\"a\u0019\u0002V\u0006]\u0017\u0011\\An\u0011\u001d\t9)\u0007a\u0001\u0003\u0013Ca!a&\u001a\u0001\u0004)\u0006BBAN3\u0001\u0007Q\u000b\u0003\u0004\u0002 f\u0001\r!V\u0001\u000baV$Hi\\;cY\u0016\u001cHCCA2\u0003C\f\u0019/!:\u0002h\"9\u0011q\u0011\u000eA\u0002\u0005%\u0005BBAL5\u0001\u0007Q\u000b\u0003\u0004\u0002\u001cj\u0001\r!\u0016\u0005\u0007\u0003?S\u0002\u0019A+\u0002\u0017\u0011,7m\\7qe\u0016\u001c8\u000f\r\u000b\u000b\u0003G\ni/a<\u0002t\u0006]\bbBAD7\u0001\u0007\u0011\u0011\u0012\u0005\u0007\u0003c\\\u0002\u0019A+\u0002\u0011\r\f\u0007/Y2jifDa!!>\u001c\u0001\u0004)\u0016\u0001C;oSR\u001c\u0016N_3\t\u000f\u0005e8\u00041\u0001\u0002|\u0006Y\u0001/\u001e;Gk:\u001cG/[8o!)I\u0014Q`AE+V+\u00161M\u0005\u0004\u0003\u007fT$!\u0003$v]\u000e$\u0018n\u001c85\u0003)!WmY8naJ,7o\u001d\u000b\u0007\u0003G\u0012)Aa\u0002\t\u000f\u0005\u001dE\u00041\u0001\u0002\n\"1\u0011\u0011\u001f\u000fA\u0002U\u00032A\u001aB\u0006\t\u0015axA1\u0001~\u0011\u001d\t\u0019f\u0002a\u0001\u0003;AaaX\u0004A\u0002\tE\u0001#\u00022\u0002\f\t%\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\u0018A!!\u0011\u0004B\u0010\u001b\t\u0011YB\u0003\u0003\u0003\u001e\u0005\u0015\u0012\u0001\u00027b]\u001eLAA!\t\u0003\u001c\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002n\u0005SA\u0001Ba\u000b \u0003\u0003\u0005\r!V\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tE\u0002#\u0002B\u001a\u0005siWB\u0001B\u001b\u0015\r\u00119DO\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u001e\u0005k\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u00191L!\u0011\t\u0011\t-\u0012%!AA\u00025\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002+\u0006AAo\\*ue&tw\r\u0006\u0002\u0003\u0018\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!q\n\t\u0005\u00053\u0011\t&\u0003\u0003\u0003T\tm!AB(cU\u0016\u001cG\u000f")
public final class PassThrough {
    public static String toString() {
        return PassThrough$.MODULE$.toString();
    }

    public static int hashCode() {
        return PassThrough$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object x$1) {
        return PassThrough$.MODULE$.canEqual(x$1);
    }

    public static Iterator<Object> productIterator() {
        return PassThrough$.MODULE$.productIterator();
    }

    public static Object productElement(int x$1) {
        return PassThrough$.MODULE$.productElement(x$1);
    }

    public static int productArity() {
        return PassThrough$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return PassThrough$.MODULE$.productPrefix();
    }

    public static <T extends AtomicType> Decoder<T> decoder(ByteBuffer buffer, NativeColumnType<T> columnType) {
        return PassThrough$.MODULE$.decoder(buffer, (NativeColumnType)columnType);
    }

    public static <T extends AtomicType> Encoder<T> encoder(NativeColumnType<T> columnType) {
        return PassThrough$.MODULE$.encoder((NativeColumnType)columnType);
    }

    public static boolean supports(ColumnType<?> columnType) {
        return PassThrough$.MODULE$.supports(columnType);
    }

    public static int typeId() {
        return PassThrough$.MODULE$.typeId();
    }

    public static Iterator<String> productElementNames() {
        return PassThrough$.MODULE$.productElementNames();
    }

    public static String productElementName(int n) {
        return PassThrough$.MODULE$.productElementName(n);
    }

    public static class Decoder<T extends AtomicType>
    implements org.apache.spark.sql.execution.columnar.compression.Decoder<T> {
        private final ByteBuffer buffer;
        private final NativeColumnType<T> columnType;

        @Override
        public void next(InternalRow row, int ordinal) {
            this.columnType.extract(this.buffer, row, ordinal);
        }

        @Override
        public boolean hasNext() {
            return this.buffer.hasRemaining();
        }

        private void putBooleans(WritableColumnVector columnVector, int pos, int bufferPos, int len) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> columnVector.putBoolean(pos + i, $this.buffer.get(bufferPos + i) != 0));
        }

        private void putBytes(WritableColumnVector columnVector, int pos, int bufferPos, int len) {
            columnVector.putBytes(pos, len, this.buffer.array(), bufferPos);
        }

        private void putShorts(WritableColumnVector columnVector, int pos, int bufferPos, int len) {
            columnVector.putShorts(pos, len, this.buffer.array(), bufferPos);
        }

        private void putInts(WritableColumnVector columnVector, int pos, int bufferPos, int len) {
            columnVector.putInts(pos, len, this.buffer.array(), bufferPos);
        }

        private void putLongs(WritableColumnVector columnVector, int pos, int bufferPos, int len) {
            columnVector.putLongs(pos, len, this.buffer.array(), bufferPos);
        }

        private void putFloats(WritableColumnVector columnVector, int pos, int bufferPos, int len) {
            columnVector.putFloats(pos, len, this.buffer.array(), bufferPos);
        }

        private void putDoubles(WritableColumnVector columnVector, int pos, int bufferPos, int len) {
            columnVector.putDoubles(pos, len, this.buffer.array(), bufferPos);
        }

        private void decompress0(WritableColumnVector columnVector, int capacity, int unitSize, Function4<WritableColumnVector, Object, Object, Object, BoxedUnit> putFunction) {
            ByteBuffer nullsBuffer = this.buffer.duplicate().order(ByteOrder.nativeOrder());
            nullsBuffer.rewind();
            int nullCount = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
            int nextNullIndex = nullCount > 0 ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : capacity;
            int pos = 0;
            int seenNulls = 0;
            int bufferPos = this.buffer.position();
            while (pos < capacity) {
                if (pos != nextNullIndex) {
                    int len = nextNullIndex - pos;
                    Predef$.MODULE$.assert((long)len * (long)unitSize < Integer.MAX_VALUE);
                    putFunction.apply((Object)columnVector, (Object)BoxesRunTime.boxToInteger((int)pos), (Object)BoxesRunTime.boxToInteger((int)bufferPos), (Object)BoxesRunTime.boxToInteger((int)len));
                    bufferPos += len * unitSize;
                    pos += len;
                    continue;
                }
                nextNullIndex = ++seenNulls < nullCount ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : capacity;
                columnVector.putNull(pos);
                ++pos;
            }
        }

        @Override
        public void decompress(WritableColumnVector columnVector2, int capacity) {
            T t = this.columnType.dataType();
            if (t instanceof BooleanType) {
                int unitSize = 1;
                this.decompress0(columnVector2, capacity, unitSize, (Function4<WritableColumnVector, Object, Object, Object, BoxedUnit>)(Function4 & Serializable)(columnVector, pos, bufferPos, len) -> {
                    this.putBooleans(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)bufferPos), BoxesRunTime.unboxToInt((Object)len));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof ByteType) {
                int unitSize = 1;
                this.decompress0(columnVector2, capacity, unitSize, (Function4<WritableColumnVector, Object, Object, Object, BoxedUnit>)(Function4 & Serializable)(columnVector, pos, bufferPos, len) -> {
                    this.putBytes(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)bufferPos), BoxesRunTime.unboxToInt((Object)len));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof ShortType) {
                int unitSize = 2;
                this.decompress0(columnVector2, capacity, unitSize, (Function4<WritableColumnVector, Object, Object, Object, BoxedUnit>)(Function4 & Serializable)(columnVector, pos, bufferPos, len) -> {
                    this.putShorts(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)bufferPos), BoxesRunTime.unboxToInt((Object)len));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof IntegerType) {
                int unitSize = 4;
                this.decompress0(columnVector2, capacity, unitSize, (Function4<WritableColumnVector, Object, Object, Object, BoxedUnit>)(Function4 & Serializable)(columnVector, pos, bufferPos, len) -> {
                    this.putInts(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)bufferPos), BoxesRunTime.unboxToInt((Object)len));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof LongType) {
                int unitSize = 8;
                this.decompress0(columnVector2, capacity, unitSize, (Function4<WritableColumnVector, Object, Object, Object, BoxedUnit>)(Function4 & Serializable)(columnVector, pos, bufferPos, len) -> {
                    this.putLongs(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)bufferPos), BoxesRunTime.unboxToInt((Object)len));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof FloatType) {
                int unitSize = 4;
                this.decompress0(columnVector2, capacity, unitSize, (Function4<WritableColumnVector, Object, Object, Object, BoxedUnit>)(Function4 & Serializable)(columnVector, pos, bufferPos, len) -> {
                    this.putFloats(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)bufferPos), BoxesRunTime.unboxToInt((Object)len));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof DoubleType) {
                int unitSize = 8;
                this.decompress0(columnVector2, capacity, unitSize, (Function4<WritableColumnVector, Object, Object, Object, BoxedUnit>)(Function4 & Serializable)(columnVector, pos, bufferPos, len) -> {
                    this.putDoubles(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)bufferPos), BoxesRunTime.unboxToInt((Object)len));
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(t);
            }
        }

        public Decoder(ByteBuffer buffer, NativeColumnType<T> columnType) {
            this.buffer = buffer;
            this.columnType = columnType;
        }
    }

    public static class Encoder<T extends AtomicType>
    implements org.apache.spark.sql.execution.columnar.compression.Encoder<T> {
        @Override
        public void gatherCompressibilityStats(InternalRow row, int ordinal) {
            org.apache.spark.sql.execution.columnar.compression.Encoder.gatherCompressibilityStats$(this, row, ordinal);
        }

        @Override
        public double compressionRatio() {
            return org.apache.spark.sql.execution.columnar.compression.Encoder.compressionRatio$(this);
        }

        @Override
        public int uncompressedSize() {
            return 0;
        }

        @Override
        public int compressedSize() {
            return 0;
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            to.putInt(PassThrough$.MODULE$.typeId()).put(from).rewind();
            return to;
        }

        public Encoder(NativeColumnType<T> columnType) {
            org.apache.spark.sql.execution.columnar.compression.Encoder.$init$(this);
        }
    }
}

