/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormat$;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFooterReader;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRowIndexUtil$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetUtils$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.execution.vectorized.ConstantColumnVector;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

@ScalaSignature(bytes="\u0006\u0005\tmb\u0001\u0002\f\u0018\u0001\u0019BQ!\u0013\u0001\u0005\u0002)CQ!\u0014\u0001\u0005B9CQa\u0016\u0001\u0005B9CQ\u0001\u0017\u0001\u0005BeCQ!\u0018\u0001\u0005ByCQa\u001a\u0001\u0005B!Dq!a\u0005\u0001\t\u0003\n)\u0002C\u0004\u0002:\u0001!\t%a\u000f\t\u000f\u0005\r\u0003\u0001\"\u0011\u0002F!9\u0011\u0011\r\u0001\u0005B\u0005\r\u0004bBA:\u0001\u0011\u0005\u0013Q\u000f\u0005\b\u0003w\u0003A\u0011IA_\u000f\u001d\tIm\u0006E\u0001\u0003\u00174aAF\f\t\u0002\u00055\u0007BB%\u000f\t\u0003\ti\u000e\u0003\u0005\u0002`:!\taFAq\u0011!\t9P\u0004C\u0001/\u0005e\bb\u0002B\u0003\u001d\u0011\u0005!q\u0001\u0005\b\u0005#qA\u0011\u0001B\n\u0011\u001d\u0011\u0019C\u0004C\u0005\u0005KA\u0011Ba\u000b\u000f\u0003\u0003%IA!\f\u0003#A\u000b'/];fi\u001aKG.\u001a$pe6\fGO\u0003\u0002\u00193\u00059\u0001/\u0019:rk\u0016$(B\u0001\u000e\u001c\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0005qi\u0012!C3yK\u000e,H/[8o\u0015\tqr$A\u0002tc2T!\u0001I\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\t\u001a\u0013AB1qC\u000eDWMC\u0001%\u0003\ry'oZ\u0002\u0001'\u0019\u0001q%L\u00198{A\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t1\u0011I\\=SK\u001a\u0004\"AL\u0018\u000e\u0003eI!\u0001M\r\u0003\u0015\u0019KG.\u001a$pe6\fG\u000f\u0005\u00023k5\t1G\u0003\u00025;\u000591o\\;sG\u0016\u001c\u0018B\u0001\u001c4\u0005I!\u0015\r^1T_V\u00148-\u001a*fO&\u001cH/\u001a:\u0011\u0005aZT\"A\u001d\u000b\u0005iz\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005qJ$a\u0002'pO\u001eLgn\u001a\t\u0003}\u0019s!a\u0010#\u000f\u0005\u0001\u001bU\"A!\u000b\u0005\t+\u0013A\u0002\u001fs_>$h(C\u0001+\u0013\t)\u0015&A\u0004qC\u000e\\\u0017mZ3\n\u0005\u001dC%\u0001D*fe&\fG.\u001b>bE2,'BA#*\u0003\u0019a\u0014N\\5u}Q\t1\n\u0005\u0002M\u00015\tq#A\u0005tQ>\u0014HOT1nKR\tq\n\u0005\u0002Q):\u0011\u0011K\u0015\t\u0003\u0001&J!aU\u0015\u0002\rA\u0013X\rZ3g\u0013\t)fK\u0001\u0004TiJLgn\u001a\u0006\u0003'&\n\u0001\u0002^8TiJLgnZ\u0001\tQ\u0006\u001c\bnQ8eKR\t!\f\u0005\u0002)7&\u0011A,\u000b\u0002\u0004\u0013:$\u0018AB3rk\u0006d7\u000f\u0006\u0002`EB\u0011\u0001\u0006Y\u0005\u0003C&\u0012qAQ8pY\u0016\fg\u000eC\u0003d\u000b\u0001\u0007A-A\u0003pi\",'\u000f\u0005\u0002)K&\u0011a-\u000b\u0002\u0004\u0003:L\u0018\u0001\u00049sKB\f'/Z,sSR,GCB5mer\f\u0019\u0001\u0005\u0002/U&\u00111.\u0007\u0002\u0014\u001fV$\b/\u001e;Xe&$XM\u001d$bGR|'/\u001f\u0005\u0006[\u001a\u0001\rA\\\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003_Bl\u0011!H\u0005\u0003cv\u0011Ab\u00159be.\u001cVm]:j_:DQa\u001d\u0004A\u0002Q\f1A[8c!\t)(0D\u0001w\u0015\t9\b0A\u0005nCB\u0014X\rZ;dK*\u0011\u00110I\u0001\u0007Q\u0006$wn\u001c9\n\u0005m4(a\u0001&pE\")QP\u0002a\u0001}\u00069q\u000e\u001d;j_:\u001c\b\u0003\u0002)\u0000\u001f>K1!!\u0001W\u0005\ri\u0015\r\u001d\u0005\b\u0003\u000b1\u0001\u0019AA\u0004\u0003)!\u0017\r^1TG\",W.\u0019\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011QB\u000f\u0002\u000bQL\b/Z:\n\t\u0005E\u00111\u0002\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017aC5oM\u0016\u00148k\u00195f[\u0006$\u0002\"a\u0006\u0002\u001e\u0005}\u00111\u0005\t\u0006Q\u0005e\u0011qA\u0005\u0004\u00037I#AB(qi&|g\u000eC\u0003n\u000f\u0001\u0007a\u000e\u0003\u0004\u0002\"\u001d\u0001\rA`\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\bbBA\u0013\u000f\u0001\u0007\u0011qE\u0001\u0006M&dWm\u001d\t\u0006}\u0005%\u0012QF\u0005\u0004\u0003WA%aA*fcB!\u0011qFA\u001b\u001b\t\t\tDC\u0002\u00024a\f!AZ:\n\t\u0005]\u0012\u0011\u0007\u0002\u000b\r&dWm\u0015;biV\u001c\u0018\u0001D:vaB|'\u000f\u001e\"bi\u000eDG#B0\u0002>\u0005}\u0002\"B7\t\u0001\u0004q\u0007bBA!\u0011\u0001\u0007\u0011qA\u0001\u0007g\u000eDW-\\1\u0002\u0017Y,7\r^8s)f\u0004Xm\u001d\u000b\t\u0003\u000f\nY%a\u0014\u0002TA)\u0001&!\u0007\u0002JA!a(!\u000bP\u0011\u001d\ti%\u0003a\u0001\u0003\u000f\taB]3rk&\u0014X\rZ*dQ\u0016l\u0017\rC\u0004\u0002R%\u0001\r!a\u0002\u0002\u001fA\f'\u000f^5uS>t7k\u00195f[\u0006Dq!!\u0016\n\u0001\u0004\t9&A\u0004tc2\u001cuN\u001c4\u0011\t\u0005e\u0013QL\u0007\u0003\u00037R!AO\u000f\n\t\u0005}\u00131\f\u0002\b'Fc5i\u001c8g\u0003-I7o\u00159mSR\f'\r\\3\u0015\u000f}\u000b)'a\u001a\u0002j!)QN\u0003a\u0001]\")QP\u0003a\u0001}\"9\u00111\u000e\u0006A\u0002\u00055\u0014\u0001\u00029bi\"\u0004B!a\f\u0002p%!\u0011\u0011OA\u0019\u0005\u0011\u0001\u0016\r\u001e5\u0002=\t,\u0018\u000e\u001c3SK\u0006$WM],ji\"\u0004\u0016M\u001d;ji&|gNV1mk\u0016\u001cH\u0003EA<\u0003+\u000b9*!'\u0002\u001c\u0006u\u0015\u0011VAV!\u001dA\u0013\u0011PA?\u0003\u0007K1!a\u001f*\u0005%1UO\\2uS>t\u0017\u0007E\u0002/\u0003\u007fJ1!!!\u001a\u0005=\u0001\u0016M\u001d;ji&|g.\u001a3GS2,\u0007#\u0002 \u0002\u0006\u0006%\u0015bAAD\u0011\nA\u0011\n^3sCR|'\u000f\u0005\u0003\u0002\f\u0006EUBAAG\u0015\r\ty)H\u0001\tG\u0006$\u0018\r\\=ti&!\u00111SAG\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000b5\\\u0001\u0019\u00018\t\u000f\u0005\u00151\u00021\u0001\u0002\b!9\u0011\u0011K\u0006A\u0002\u0005\u001d\u0001bBA'\u0017\u0001\u0007\u0011q\u0001\u0005\b\u0003?[\u0001\u0019AAQ\u0003\u001d1\u0017\u000e\u001c;feN\u0004RAPA\u0015\u0003G\u00032AMAS\u0013\r\t9k\r\u0002\u0007\r&dG/\u001a:\t\u000bu\\\u0001\u0019\u0001@\t\u000f\u000556\u00021\u0001\u00020\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\t\u0005E\u0016qW\u0007\u0003\u0003gS1!!.y\u0003\u0011\u0019wN\u001c4\n\t\u0005e\u00161\u0017\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u001fM,\b\u000f]8si\u0012\u000bG/\u0019+za\u0016$2aXA`\u0011\u001d\t\t\r\u0004a\u0001\u0003\u0007\f\u0001\u0002Z1uCRK\b/\u001a\t\u0005\u0003\u0013\t)-\u0003\u0003\u0002H\u0006-!\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002#A\u000b'/];fi\u001aKG.\u001a$pe6\fG\u000f\u0005\u0002M\u001dM)abJ\u001c\u0002PB!\u0011\u0011[An\u001b\t\t\u0019N\u0003\u0003\u0002V\u0006]\u0017AA5p\u0015\t\tI.\u0001\u0003kCZ\f\u0017bA$\u0002TR\u0011\u00111Z\u0001\u000be\u0016\fGmU2iK6\fGCBA\f\u0003G\f)\u0010C\u0004\u0002fB\u0001\r!a:\u0002\u000f\u0019|w\u000e^3sgB)a(!\u000b\u0002jB!\u00111^Ay\u001b\t\tiOC\u0002z\u0003_T!\u0001G\u0011\n\t\u0005M\u0018Q\u001e\u0002\u0007\r>|G/\u001a:\t\u000b5\u0004\u0002\u0019\u00018\u00029I,\u0017\r\u001a)beF,X\r\u001e$p_R,'o]%o!\u0006\u0014\u0018\r\u001c7fYRA\u0011q]A~\u0003{\u0014\t\u0001C\u0004\u00026F\u0001\r!a,\t\u000f\u0005}\u0018\u00031\u0001\u0002(\u0005I\u0001/\u0019:u\r&dWm\u001d\u0005\u0007\u0005\u0007\t\u0002\u0019A0\u0002%%<gn\u001c:f\u0007>\u0014(/\u001e9u\r&dWm]\u0001\u0017[\u0016\u0014x-Z*dQ\u0016l\u0017m]%o!\u0006\u0014\u0018\r\u001c7fYRA\u0011q\u0003B\u0005\u0005\u0017\u0011y\u0001\u0003\u0004\u0002\"I\u0001\rA \u0005\b\u0005\u001b\u0011\u0002\u0019AA\u0014\u000311\u0017\u000e\\3t)>$v.^2i\u0011\u0015i'\u00031\u0001o\u0003Q\u0011X-\u00193TG\",W.\u0019$s_64un\u001c;feR1\u0011q\u0001B\u000b\u00053AqAa\u0006\u0014\u0001\u0004\tI/\u0001\u0004g_>$XM\u001d\u0005\b\u00057\u0019\u0002\u0019\u0001B\u000f\u0003%\u0019wN\u001c<feR,'\u000fE\u0002M\u0005?I1A!\t\u0018\u0005u\u0001\u0016M]9vKR$vn\u00159be.\u001c6\r[3nC\u000e{gN^3si\u0016\u0014\u0018a\u00063fg\u0016\u0014\u0018.\u00197ju\u0016\u001c6\r[3nCN#(/\u001b8h)\u0011\t9Ba\n\t\r\t%B\u00031\u0001P\u00031\u00198\r[3nCN#(/\u001b8h\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011y\u0003\u0005\u0003\u00032\t]RB\u0001B\u001a\u0015\u0011\u0011)$a6\u0002\t1\fgnZ\u0005\u0005\u0005s\u0011\u0019D\u0001\u0004PE*,7\r\u001e")
public class ParquetFileFormat
implements FileFormat,
DataSourceRegister,
Logging,
Serializable {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static StructType readSchemaFromFooter(Footer footer, ParquetToSparkSchemaConverter converter) {
        return ParquetFileFormat$.MODULE$.readSchemaFromFooter(footer, converter);
    }

    public static Option<StructType> mergeSchemasInParallel(scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> filesToTouch, SparkSession sparkSession) {
        return ParquetFileFormat$.MODULE$.mergeSchemasInParallel(parameters, filesToTouch, sparkSession);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReader$(this, sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    @Override
    public boolean supportFieldName(String name) {
        return FileFormat.supportFieldName$(this, name);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String shortName() {
        return "parquet";
    }

    public String toString() {
        return "Parquet";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof ParquetFileFormat;
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, scala.collection.immutable.Map<String, String> options, StructType dataSchema) {
        SQLConf sqlConf = sparkSession.sessionState().conf();
        ParquetOptions parquetOptions = new ParquetOptions(options, sqlConf);
        return ParquetUtils$.MODULE$.prepareWrite(sqlConf, job, dataSchema, parquetOptions);
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> files) {
        return ParquetUtils$.MODULE$.inferSchema(sparkSession, parameters, files);
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        SQLConf conf = sparkSession.sessionState().conf();
        return ParquetUtils$.MODULE$.isBatchReadSupportedForSchema(conf, schema);
    }

    @Override
    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return Option$.MODULE$.apply(((IterableOps)package$.MODULE$.Seq().fill(requiredSchema.fields().length, (Function0 & Serializable)() -> !sqlConf.offHeapColumnVectorEnabled() ? OnHeapColumnVector.class.getName() : OffHeapColumnVector.class.getName())).$plus$plus((IterableOnce)package$.MODULE$.Seq().fill(partitionSchema.fields().length, (Function0 & Serializable)() -> ConstantColumnVector.class.getName())));
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, scala.collection.immutable.Map<String, String> options, Path path) {
        return true;
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        boolean returningBatch;
        String int96RebaseModeInRead;
        String datetimeRebaseModeInRead;
        boolean isCaseSensitive;
        int pushDownInFilterThreshold;
        boolean pushDownStringPredicate;
        boolean pushDownDecimal;
        boolean pushDownTimestamp;
        boolean pushDownDate;
        boolean enableParquetFilterPushDown;
        int capacity;
        boolean timestampConversion;
        boolean enableRecordFilter;
        boolean enableVectorizedReader;
        boolean enableOffHeapColumnVector;
        Broadcast broadcastedHadoopConf;
        block0: {
            hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
            hadoopConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), requiredSchema.json());
            hadoopConf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), requiredSchema.json());
            hadoopConf.set(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key(), sparkSession.sessionState().conf().sessionLocalTimeZone());
            hadoopConf.setBoolean(SQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().key(), sparkSession.sessionState().conf().nestedSchemaPruningEnabled());
            hadoopConf.setBoolean(SQLConf$.MODULE$.CASE_SENSITIVE().key(), sparkSession.sessionState().conf().caseSensitiveAnalysis());
            hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), sparkSession.sessionState().conf().isParquetBinaryAsString());
            hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), sparkSession.sessionState().conf().isParquetINT96AsTimestamp());
            hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INFER_TIMESTAMP_NTZ_ENABLED().key(), sparkSession.sessionState().conf().parquetInferTimestampNTZEnabled());
            hadoopConf.setBoolean(SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key(), sparkSession.sessionState().conf().legacyParquetNanosAsLong());
            broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
            StructType resultSchema = new StructType((StructField[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields()), (Object)requiredSchema.fields(), ClassTag$.MODULE$.apply(StructField.class)));
            SQLConf sqlConf = sparkSession.sessionState().conf();
            enableOffHeapColumnVector = sqlConf.offHeapColumnVectorEnabled();
            enableVectorizedReader = ParquetUtils$.MODULE$.isBatchReadSupportedForSchema(sqlConf, resultSchema);
            enableRecordFilter = sqlConf.parquetRecordFilterEnabled();
            timestampConversion = sqlConf.isParquetINT96TimestampConversion();
            capacity = sqlConf.parquetVectorizedReaderBatchSize();
            enableParquetFilterPushDown = sqlConf.parquetFilterPushDown();
            pushDownDate = sqlConf.parquetFilterPushDownDate();
            pushDownTimestamp = sqlConf.parquetFilterPushDownTimestamp();
            pushDownDecimal = sqlConf.parquetFilterPushDownDecimal();
            pushDownStringPredicate = sqlConf.parquetFilterPushDownStringPredicate();
            pushDownInFilterThreshold = sqlConf.parquetFilterPushDownInFilterThreshold();
            isCaseSensitive = sqlConf.caseSensitiveAnalysis();
            ParquetOptions parquetOptions = new ParquetOptions(options, sparkSession.sessionState().conf());
            datetimeRebaseModeInRead = parquetOptions.datetimeRebaseModeInRead();
            int96RebaseModeInRead = parquetOptions.int96RebaseModeInRead();
            boolean bl = returningBatch = sparkSession.sessionState().conf().parquetVectorizedReaderEnabled() && ((String)options.get((Object)FileFormat$.MODULE$.OPTION_RETURNING_BATCH()).getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException("OPTION_RETURNING_BATCH should always be set for ParquetFileFormat. To workaround this issue, set spark.sql.parquet.enableVectorizedReader=false.");
            })).equals("true");
            if (!returningBatch) break block0;
            Predef$.MODULE$.assert(this.supportBatch(sparkSession, resultSchema));
        }
        return (Function1 & Serializable)file -> {
            ParquetRecordReader parquetRecordReader;
            RecordReaderIterator<Object> recordReaderIterator;
            None$ none$;
            LazyRef footerFileMetaData$lzy = new LazyRef();
            Predef$.MODULE$.assert(file.partitionValues().numFields() == partitionSchema.size());
            Path filePath = file.toPath();
            FileSplit split = new FileSplit(filePath, file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            Configuration sharedConf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            Map map = ParquetFileFormat.footerFileMetaData$1(footerFileMetaData$lzy, sharedConf, filePath).getKeyValueMetaData();
            RebaseDateTime.RebaseSpec datetimeRebaseSpec = DataSourceUtils$.MODULE$.datetimeRebaseSpec((Function1<String, String>)(Function1 & Serializable)x$1 -> (String)map.get(x$1), datetimeRebaseModeInRead);
            if (enableParquetFilterPushDown) {
                MessageType parquetSchema = ParquetFileFormat.footerFileMetaData$1(footerFileMetaData$lzy, sharedConf, filePath).getSchema();
                ParquetFilters parquetFilters = new ParquetFilters(parquetSchema, pushDownDate, pushDownTimestamp, pushDownDecimal, pushDownStringPredicate, pushDownInFilterThreshold, isCaseSensitive, datetimeRebaseSpec);
                none$ = ((IterableOnceOps)filters.flatMap((Function1 & Serializable)x$1 -> parquetFilters.createFilter((Filter)x$1))).reduceOption((Function2 & Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
            } else {
                none$ = None$.MODULE$;
            }
            None$ pushed = none$;
            None$ convertTz = timestampConversion && !ParquetFileFormat.isCreatedByParquetMr$1(footerFileMetaData$lzy, sharedConf, filePath) ? new Some((Object)DateTimeUtils$.MODULE$.getZoneId(sharedConf.get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
            Map map2 = ParquetFileFormat.footerFileMetaData$1(footerFileMetaData$lzy, sharedConf, filePath).getKeyValueMetaData();
            RebaseDateTime.RebaseSpec int96RebaseSpec = DataSourceUtils$.MODULE$.int96RebaseSpec((Function1<String, String>)(Function1 & Serializable)x$1 -> (String)map2.get(x$1), int96RebaseModeInRead);
            TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
            TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(((SerializableConfiguration)broadcastedHadoopConf.value()).value(), attemptId);
            if (pushed.isDefined()) {
                ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)pushed.get()));
            }
            Option taskContext = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
            if (enableVectorizedReader) {
                VectorizedParquetRecordReader vectorizedReader = new VectorizedParquetRecordReader((ZoneId)convertTz.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), datetimeRebaseSpec.mode().toString(), datetimeRebaseSpec.timeZone(), int96RebaseSpec.mode().toString(), int96RebaseSpec.timeZone(), enableOffHeapColumnVector && taskContext.isDefined(), capacity);
                RecordReaderIterator<Object> iter = new RecordReaderIterator<Object>(vectorizedReader);
                try {
                    vectorizedReader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(11).append("Appending ").append(partitionSchema).append(" ").append(file.partitionValues()).toString());
                    vectorizedReader.initBatch(partitionSchema, file.partitionValues());
                    if (returningBatch) {
                        vectorizedReader.enableReturningBatches();
                    }
                    recordReaderIterator = iter;
                }
                catch (Throwable e) {
                    iter.close();
                    throw e;
                }
            }
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Falling back to parquet-mr");
            ParquetReadSupport readSupport = new ParquetReadSupport((Option<ZoneId>)convertTz, false, datetimeRebaseSpec, int96RebaseSpec);
            if (pushed.isDefined() && enableRecordFilter) {
                FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
                parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport, parquetFilter);
            } else {
                parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport);
            }
            ParquetRecordReader reader = parquetRecordReader;
            RecordReader<Void, InternalRow> readerWithRowIndexes = ParquetRowIndexUtil$.MODULE$.addRowIndexToRecordReaderIfNeeded((ParquetRecordReader<InternalRow>)reader, requiredSchema);
            RecordReaderIterator<InternalRow> iter = new RecordReaderIterator<InternalRow>(readerWithRowIndexes);
            try {
                readerWithRowIndexes.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                Seq fullSchema = (Seq)requiredSchema.toAttributes().$plus$plus((IterableOnce)partitionSchema.toAttributes());
                UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                if (partitionSchema.length() == 0) {
                    recordReaderIterator = iter.map(unsafeProjection);
                } else {
                    JoinedRow joinedRow = new JoinedRow();
                    recordReaderIterator = iter.map((Function1 & Serializable)d -> unsafeProjection.apply((InternalRow)joinedRow.apply(d, file.partitionValues())));
                }
            }
            catch (Throwable e) {
                iter.close();
                throw e;
            }
            return recordReaderIterator;
        };
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        boolean bl;
        DataType dataType2 = dataType;
        if (dataType2 instanceof AtomicType) {
            bl = true;
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            bl = structType.forall((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.supportDataType(f.dataType())));
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            bl = this.supportDataType(elementType);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            bl = this.supportDataType(keyType) && this.supportDataType(valueType);
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            bl = this.supportDataType(userDefinedType.sqlType());
        } else {
            bl = false;
        }
        return bl;
    }

    private static final /* synthetic */ FileMetaData footerFileMetaData$lzycompute$1(LazyRef footerFileMetaData$lzy$1, Configuration sharedConf$1, Path filePath$1) {
        FileMetaData fileMetaData;
        LazyRef lazyRef = footerFileMetaData$lzy$1;
        synchronized (lazyRef) {
            fileMetaData = footerFileMetaData$lzy$1.initialized() ? (FileMetaData)footerFileMetaData$lzy$1.value() : (FileMetaData)footerFileMetaData$lzy$1.initialize((Object)ParquetFooterReader.readFooter(sharedConf$1, filePath$1, ParquetMetadataConverter.SKIP_ROW_GROUPS).getFileMetaData());
        }
        return fileMetaData;
    }

    private static final FileMetaData footerFileMetaData$1(LazyRef footerFileMetaData$lzy$1, Configuration sharedConf$1, Path filePath$1) {
        return footerFileMetaData$lzy$1.initialized() ? (FileMetaData)footerFileMetaData$lzy$1.value() : ParquetFileFormat.footerFileMetaData$lzycompute$1(footerFileMetaData$lzy$1, sharedConf$1, filePath$1);
    }

    private static final boolean isCreatedByParquetMr$1(LazyRef footerFileMetaData$lzy$1, Configuration sharedConf$1, Path filePath$1) {
        return ParquetFileFormat.footerFileMetaData$1(footerFileMetaData$lzy$1, sharedConf$1, filePath$1).getCreatedBy().startsWith("parquet-mr");
    }

    public ParquetFileFormat() {
        FileFormat.$init$(this);
        Logging.$init$((Logging)this);
    }
}

