/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.parquet.ParquetColumn;
import org.apache.spark.sql.execution.datasources.parquet.ParquetColumnVector;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRowIndexUtil$;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005uu!B\r\u001b\u0011\u0003Ic!B\u0016\u001b\u0011\u0003a\u0003\"B\u001a\u0002\t\u0003!d\u0001B\u001b\u0002\u0001YB\u0001bN\u0002\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\u0006g\r!\ta\u000f\u0005\n\u007f\r\u0001\r\u00111A\u0005\u0002\u0001C\u0011\u0002U\u0002A\u0002\u0003\u0007I\u0011A)\t\u0013]\u001b\u0001\u0019!A!B\u0013\t\u0005\"\u0002-\u0004\t\u0003I\u0006\"B3\u0004\t\u00031\u0007\"B3\u0004\t\u0003\t\b\"B>\u0002\t\u0003ahABA\u0006\u0003\u0011\ti\u0001\u0003\u0006\u0002<5\u0011\t\u0011)A\u0005\u0003{A\u0001bN\u0007\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\u0007g5!\t!a\u0012\t\u000f\u0005=S\u0002\"\u0011\u0002R!9\u0011qM\u0007\u0005B\u0005%\u0004bBA9\u001b\u0011\u0005\u00131\u000f\u0005\b\u0003kjA\u0011IA<\u0011\u001d\tI(\u0004C!\u0003wBq!a!\u000e\t\u0003\n)\tC\u0004\u0002\b\u0006!\t!!#\t\u000f\u0005E\u0015\u0001\"\u0001\u0002\u0014\u0006\u0019\u0002+\u0019:rk\u0016$(k\\<J]\u0012,\u00070\u0016;jY*\u00111\u0004H\u0001\ba\u0006\u0014\u0018/^3u\u0015\tib$A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u0010!\u0003%)\u00070Z2vi&|gN\u0003\u0002\"E\u0005\u00191/\u001d7\u000b\u0005\r\"\u0013!B:qCJ\\'BA\u0013'\u0003\u0019\t\u0007/Y2iK*\tq%A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002+\u00035\t!DA\nQCJ\fX/\u001a;S_^Le\u000eZ3y+RLGn\u0005\u0002\u0002[A\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0015\u0003#I{w/\u00138eKb<UM\\3sCR|'o\u0005\u0002\u0004[\u0005\t\"o\\<J]\u0012,\u0007pQ8mk6t\u0017\n\u001a=\u0011\u00059J\u0014B\u0001\u001e0\u0005\rIe\u000e\u001e\u000b\u0003yy\u0002\"!P\u0002\u000e\u0003\u0005AQaN\u0003A\u0002a\n\u0001C]8x\u0013:$W\r_%uKJ\fGo\u001c:\u0016\u0003\u0005\u00032A\u0011&N\u001d\t\u0019\u0005J\u0004\u0002E\u000f6\tQI\u0003\u0002GQ\u00051AH]8pizJ\u0011\u0001M\u0005\u0003\u0013>\nq\u0001]1dW\u0006<W-\u0003\u0002L\u0019\nA\u0011\n^3sCR|'O\u0003\u0002J_A\u0011aFT\u0005\u0003\u001f>\u0012A\u0001T8oO\u0006!\"o\\<J]\u0012,\u00070\u0013;fe\u0006$xN]0%KF$\"AU+\u0011\u00059\u001a\u0016B\u0001+0\u0005\u0011)f.\u001b;\t\u000fY;\u0011\u0011!a\u0001\u0003\u0006\u0019\u0001\u0010J\u0019\u0002#I|w/\u00138eKbLE/\u001a:bi>\u0014\b%A\u000bj]&$hI]8n!\u0006<WMU3bIN#xN]3\u0015\u0005IS\u0006\"B.\n\u0001\u0004a\u0016!\u00029bO\u0016\u001c\bCA/d\u001b\u0005q&BA0a\u0003\u0011\u0001\u0018mZ3\u000b\u0005\u0005\u0014\u0017AB2pYVlgN\u0003\u0002\u001cI%\u0011AM\u0018\u0002\u000e!\u0006<WMU3bIN#xN]3\u0002!A|\u0007/\u001e7bi\u0016\u0014vn^%oI\u0016DHc\u0001*h_\")\u0001N\u0003a\u0001S\u0006i1m\u001c7v[:4Vm\u0019;peN\u00042A\f6m\u0013\tYwFA\u0003BeJ\f\u0017\u0010\u0005\u0002+[&\u0011aN\u0007\u0002\u0014!\u0006\u0014\u0018/^3u\u0007>dW/\u001c8WK\u000e$xN\u001d\u0005\u0006a*\u0001\r\u0001O\u0001\b]Vl'k\\<t)\r\u0011&O\u001f\u0005\u0006g.\u0001\r\u0001^\u0001\rG>dW/\u001c8WK\u000e$xN\u001d\t\u0003kbl\u0011A\u001e\u0006\u0003oz\t!B^3di>\u0014\u0018N_3e\u0013\tIhO\u0001\u000bXe&$\u0018M\u00197f\u0007>dW/\u001c8WK\u000e$xN\u001d\u0005\u0006a.\u0001\r\u0001O\u0001\u0018GJ,\u0017\r^3HK:,'/\u0019;pe&3g*Z3eK\u0012$\"\u0001P?\t\u000byd\u0001\u0019A@\u0002\u0017M\u0004\u0018M]6TG\",W.\u0019\t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001\u0011\u0002\u000bQL\b/Z:\n\t\u0005%\u00111\u0001\u0002\u000b'R\u0014Xo\u0019;UsB,'A\u0007*fG>\u0014HMU3bI\u0016\u0014x+\u001b;i%><\u0018J\u001c3fq\u0016\u001c8cA\u0007\u0002\u0010AA\u0011\u0011CA\u000e\u0003?\ty#\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003%i\u0017\r\u001d:fIV\u001cWMC\u0002\u0002\u001a\u0011\na\u0001[1e_>\u0004\u0018\u0002BA\u000f\u0003'\u0011ABU3d_J$'+Z1eKJ\u0004B!!\t\u0002,5\u0011\u00111\u0005\u0006\u0005\u0003K\t9#\u0001\u0003mC:<'BAA\u0015\u0003\u0011Q\u0017M^1\n\t\u00055\u00121\u0005\u0002\u0005->LG\r\u0005\u0003\u00022\u0005]RBAA\u001a\u0015\r\t)\u0004I\u0001\tG\u0006$\u0018\r\\=ti&!\u0011\u0011HA\u001a\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\rA\f'/\u001a8u!\u0019\ty$a\u0011\u000205\u0011\u0011\u0011\t\u0006\u0004\u00033\u0011\u0017\u0002BA#\u0003\u0003\u00121\u0003U1scV,GOU3d_J$'+Z1eKJ$b!!\u0013\u0002L\u00055\u0003CA\u001f\u000e\u0011\u001d\tY\u0004\u0005a\u0001\u0003{AQa\u000e\tA\u0002a\n!\"\u001b8ji&\fG.\u001b>f)\u0015\u0011\u00161KA/\u0011\u001d\t)&\u0005a\u0001\u0003/\n!\"\u001b8qkR\u001c\u0006\u000f\\5u!\u0011\t\t\"!\u0017\n\t\u0005m\u00131\u0003\u0002\u000b\u0013:\u0004X\u000f^*qY&$\bbBA0#\u0001\u0007\u0011\u0011M\u0001\u0013i\u0006\u001c8.\u0011;uK6\u0004HoQ8oi\u0016DH\u000f\u0005\u0003\u0002\u0012\u0005\r\u0014\u0002BA3\u0003'\u0011!\u0003V1tW\u0006#H/Z7qi\u000e{g\u000e^3yi\u0006aa.\u001a=u\u0017\u0016Lh+\u00197vKR\u0011\u00111\u000e\t\u0004]\u00055\u0014bAA8_\t9!i\\8mK\u0006t\u0017!D4fi\u000e+(O]3oi.+\u0017\u0010\u0006\u0002\u0002 \u0005yq-\u001a;DkJ\u0014XM\u001c;WC2,X\r\u0006\u0002\u00020\u0005Yq-\u001a;Qe><'/Z:t)\t\ti\bE\u0002/\u0003\u007fJ1!!!0\u0005\u00151En\\1u\u0003\u0015\u0019Gn\\:f)\u0005\u0011\u0016!I1eIJ{w/\u00138eKb$vNU3d_J$'+Z1eKJLeMT3fI\u0016$GCBA\b\u0003\u0017\u000by\tC\u0004\u0002\u000e^\u0001\r!!\u0010\u0002\rI,\u0017\rZ3s\u0011\u0015qx\u00031\u0001\u0000\u0003AI7OU8x\u0013:$W\r_\"pYVlg\u000e\u0006\u0003\u0002l\u0005U\u0005BB1\u0019\u0001\u0004\t9\nE\u0002+\u00033K1!a'\u001b\u00055\u0001\u0016M]9vKR\u001cu\u000e\\;n]\u0002")
public final class ParquetRowIndexUtil {
    public static boolean isRowIndexColumn(ParquetColumn column) {
        return ParquetRowIndexUtil$.MODULE$.isRowIndexColumn(column);
    }

    public static RecordReader<Void, InternalRow> addRowIndexToRecordReaderIfNeeded(ParquetRecordReader<InternalRow> reader, StructType sparkSchema) {
        return ParquetRowIndexUtil$.MODULE$.addRowIndexToRecordReaderIfNeeded(reader, sparkSchema);
    }

    public static RowIndexGenerator createGeneratorIfNeeded(StructType sparkSchema) {
        return ParquetRowIndexUtil$.MODULE$.createGeneratorIfNeeded(sparkSchema);
    }

    private static class RecordReaderWithRowIndexes
    extends RecordReader<Void, InternalRow> {
        private final ParquetRecordReader<InternalRow> parent;
        private final int rowIndexColumnIdx;

        public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) {
            this.parent.initialize(inputSplit, taskAttemptContext);
        }

        public boolean nextKeyValue() {
            return this.parent.nextKeyValue();
        }

        public Void getCurrentKey() {
            return this.parent.getCurrentKey();
        }

        /*
         * WARNING - void declaration
         */
        public InternalRow getCurrentValue() {
            void var1_1;
            InternalRow row = (InternalRow)this.parent.getCurrentValue();
            row.setLong(this.rowIndexColumnIdx, this.parent.getCurrentRowIndex());
            return var1_1;
        }

        public float getProgress() {
            return this.parent.getProgress();
        }

        public void close() {
            this.parent.close();
        }

        public RecordReaderWithRowIndexes(ParquetRecordReader<InternalRow> parent, int rowIndexColumnIdx) {
            this.parent = parent;
            this.rowIndexColumnIdx = rowIndexColumnIdx;
        }
    }

    public static class RowIndexGenerator {
        private final int rowIndexColumnIdx;
        private Iterator<Object> rowIndexIterator;

        public Iterator<Object> rowIndexIterator() {
            return this.rowIndexIterator;
        }

        public void rowIndexIterator_$eq(Iterator<Object> x$1) {
            this.rowIndexIterator = x$1;
        }

        public void initFromPageReadStore(PageReadStore pages) {
            if (!pages.getRowIndexOffset().isPresent()) {
                throw new IOException("PageReadStore returned no row index offset.");
            }
            long startingRowIdx = Predef$.MODULE$.Long2long((Long)pages.getRowIndexOffset().get());
            if (pages.getRowIndexes().isPresent()) {
                this.rowIndexIterator_$eq((Iterator<Object>)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)pages.getRowIndexes().get()).asScala()).map((Function1 & Serializable)idx -> BoxesRunTime.boxToLong((long)RowIndexGenerator.$anonfun$initFromPageReadStore$1(startingRowIdx, idx))));
            } else {
                long numRowsInRowGroup = pages.getRowCount();
                this.rowIndexIterator_$eq((Iterator<Object>)new RichLong(Predef$.MODULE$.longWrapper(startingRowIdx)).until((Object)BoxesRunTime.boxToLong((long)(startingRowIdx + numRowsInRowGroup))).iterator());
            }
        }

        public void populateRowIndex(ParquetColumnVector[] columnVectors, int numRows) {
            this.populateRowIndex(columnVectors[this.rowIndexColumnIdx].getValueVector(), numRows);
        }

        public void populateRowIndex(WritableColumnVector columnVector, int numRows) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRows).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> columnVector.putLong(i, BoxesRunTime.unboxToLong((Object)this.rowIndexIterator().next())));
        }

        public static final /* synthetic */ long $anonfun$initFromPageReadStore$1(long startingRowIdx$1, Long idx) {
            return Predef$.MODULE$.Long2long(idx) + startingRowIdx$1;
        }

        public RowIndexGenerator(int rowIndexColumnIdx) {
            this.rowIndexColumnIdx = rowIndexColumnIdx;
        }
    }
}

