/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.FileSourceGeneratedMetadataStructField$;
import org.apache.spark.sql.catalyst.parser.LegacyTypeStringParser$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.SchemaMergeUtils$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFooterReader;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Failure;
import scala.util.Try$;

public final class ParquetFileFormat$
implements Logging,
Serializable {
    public static final ParquetFileFormat$ MODULE$ = new ParquetFileFormat$();
    private static final String ROW_INDEX;
    private static final String ROW_INDEX_TEMPORARY_COLUMN_NAME;
    private static final StructField ROW_INDEX_FIELD;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        ROW_INDEX = "row_index";
        ROW_INDEX_TEMPORARY_COLUMN_NAME = new StringBuilder(14).append("_tmp_metadata_").append(MODULE$.ROW_INDEX()).toString();
        ROW_INDEX_FIELD = FileSourceGeneratedMetadataStructField$.MODULE$.apply(MODULE$.ROW_INDEX(), MODULE$.ROW_INDEX_TEMPORARY_COLUMN_NAME(), (DataType)LongType$.MODULE$, false);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String ROW_INDEX() {
        return ROW_INDEX;
    }

    public String ROW_INDEX_TEMPORARY_COLUMN_NAME() {
        return ROW_INDEX_TEMPORARY_COLUMN_NAME;
    }

    public StructField ROW_INDEX_FIELD() {
        return ROW_INDEX_FIELD;
    }

    public Option<StructType> readSchema(Seq<Footer> footers, SparkSession sparkSession) {
        boolean x$1 = sparkSession.sessionState().conf().isParquetBinaryAsString();
        boolean x$2 = sparkSession.sessionState().conf().isParquetINT96AsTimestamp();
        boolean x$3 = sparkSession.sessionState().conf().parquetInferTimestampNTZEnabled();
        boolean x$4 = sparkSession.sessionState().conf().legacyParquetNanosAsLong();
        boolean x$5 = ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$3();
        ParquetToSparkSchemaConverter converter = new ParquetToSparkSchemaConverter(x$1, x$2, x$5, x$3, x$4);
        HashSet seen = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        Seq finalSchemas = (Seq)footers.flatMap((Function1 & Serializable)footer -> {
            Some some;
            FileMetaData metadata = footer.getParquetMetadata().getFileMetaData();
            Option serializedSchema = ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(metadata.getKeyValueMetaData()).asScala()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).get((Object)ParquetReadSupport$.MODULE$.SPARK_METADATA_KEY());
            if (serializedSchema.isEmpty()) {
                some = new Some((Object)converter.convert(metadata.getSchema()));
            } else if (!seen.contains(serializedSchema.get())) {
                seen.$plus$eq(serializedSchema.get());
                some = new Some(Try$.MODULE$.apply((Function0 & Serializable)() -> DataType$.MODULE$.fromJson((String)serializedSchema.get())).recover((PartialFunction)new Serializable(serializedSchema){
                    private static final long serialVersionUID = 0L;
                    private final Option serializedSchema$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 != null) {
                            ParquetFileFormat$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable)() -> "Serialized Spark schema in Parquet key-value metadata is not in JSON format, falling back to the deprecated DataType.fromCaseClassString parser.");
                            object = LegacyTypeStringParser$.MODULE$.parseString((String)this.serializedSchema$1.get());
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = throwable != null;
                        return bl;
                    }
                    {
                        this.serializedSchema$1 = serializedSchema$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1()}, serializedLambda);
                    }
                }).recover((PartialFunction)new Serializable(serializedSchema){
                    private static final long serialVersionUID = 0L;
                    private final Option serializedSchema$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x2;
                        if (A1 != null) {
                            A1 A12 = A1;
                            ParquetFileFormat$.MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(106).append("Failed to parse serialized Spark schema in Parquet key-value metadata:\n                 |\t").append($this.serializedSchema$1).append("\n               ").toString())), A12);
                            object = BoxedUnit.UNIT;
                        } else {
                            object = function1.apply(x2);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Throwable x2) {
                        Throwable throwable = x2;
                        boolean bl = throwable != null;
                        return bl;
                    }
                    {
                        this.serializedSchema$1 = serializedSchema$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$$anonfun$$nestedInanonfun$readSchema$1$2 )}, serializedLambda);
                    }
                }).map((Function1 & Serializable)x$2 -> (StructType)x$2).getOrElse((Function0 & Serializable)() -> converter.convert(metadata.getSchema())));
            } else {
                some = None$.MODULE$;
            }
            return some;
        });
        return finalSchemas.reduceOption((Function2 & Serializable)(left, right) -> {
            StructType structType;
            try {
                structType = left.merge(right);
            }
            catch (Throwable e) {
                throw QueryExecutionErrors$.MODULE$.failedToMergeIncompatibleSchemasError(left, right, e);
            }
            return structType;
        });
    }

    public Seq<Footer> readParquetFootersInParallel(Configuration conf, Seq<FileStatus> partFiles, boolean ignoreCorruptFiles) {
        return (Seq)ThreadUtils$.MODULE$.parmap(partFiles, "readingParquetFooters", 8, (Function1 & Serializable)currentFile -> {
            Some some;
            try {
                some = new Some((Object)new Footer(currentFile.getPath(), ParquetFooterReader.readFooter(conf, currentFile, ParquetMetadataConverter.SKIP_ROW_GROUPS)));
            }
            catch (RuntimeException e) {
                if (ignoreCorruptFiles) {
                    MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Skipped the footer in the corrupted file: ").append(currentFile).toString(), e);
                    some = None$.MODULE$;
                }
                throw QueryExecutionErrors$.MODULE$.cannotReadFooterForFileError(currentFile.getPath(), (Exception)e);
            }
            return some;
        }).flatten(Predef$.MODULE$.$conforms());
    }

    public Option<StructType> mergeSchemasInParallel(Map<String, String> parameters, Seq<FileStatus> filesToTouch, SparkSession sparkSession) {
        boolean assumeBinaryIsString = sparkSession.sessionState().conf().isParquetBinaryAsString();
        boolean assumeInt96IsTimestamp = sparkSession.sessionState().conf().isParquetINT96AsTimestamp();
        boolean inferTimestampNTZ = sparkSession.sessionState().conf().parquetInferTimestampNTZEnabled();
        boolean nanosAsLong = sparkSession.sessionState().conf().legacyParquetNanosAsLong();
        Function3 & Serializable reader = (Function3 & Serializable)(files, conf, ignoreCorruptFiles) -> ParquetFileFormat$.$anonfun$mergeSchemasInParallel$1(assumeBinaryIsString, assumeInt96IsTimestamp, inferTimestampNTZ, nanosAsLong, files, conf, BoxesRunTime.unboxToBoolean((Object)ignoreCorruptFiles));
        return SchemaMergeUtils$.MODULE$.mergeSchemasInParallel(sparkSession, parameters, filesToTouch, (Function3<Seq<FileStatus>, Configuration, Object, Seq<StructType>>)reader);
    }

    public StructType readSchemaFromFooter(Footer footer, ParquetToSparkSchemaConverter converter) {
        FileMetaData fileMetaData = footer.getParquetMetadata().getFileMetaData();
        return (StructType)((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(fileMetaData.getKeyValueMetaData()).asScala()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).get((Object)ParquetReadSupport$.MODULE$.SPARK_METADATA_KEY()).flatMap((Function1 & Serializable)schemaString -> MODULE$.deserializeSchemaString((String)schemaString)).getOrElse((Function0 & Serializable)() -> converter.convert(fileMetaData.getSchema()));
    }

    private Option<StructType> deserializeSchemaString(String schemaString) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> (StructType)DataType$.MODULE$.fromJson(schemaString)).recover((PartialFunction)new Serializable(schemaString){
            private static final long serialVersionUID = 0L;
            private final String schemaString$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    ParquetFileFormat$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable)() -> "Serialized Spark schema in Parquet key-value metadata is not in JSON format, falling back to the deprecated DataType.fromCaseClassString parser.");
                    object = (StructType)LegacyTypeStringParser$.MODULE$.parseString(this.schemaString$1);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable != null;
                return bl;
            }
            {
                this.schemaString$1 = schemaString$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3()}, serializedLambda);
            }
        }).recoverWith((PartialFunction)new Serializable(schemaString){
            private static final long serialVersionUID = 0L;
            private final String schemaString$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 != null) {
                    A1 A12 = A1;
                    ParquetFileFormat$.MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Failed to parse and ignored serialized Spark schema in ").append(new StringBuilder(29).append("Parquet key-value metadata:\n\t").append($this.schemaString$1).toString()).toString(), A12);
                    object = new Failure(A12);
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                boolean bl = throwable != null;
                return bl;
            }
            {
                this.schemaString$1 = schemaString$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$4(org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$$anonfun$deserializeSchemaString$3 )}, serializedLambda);
            }
        }).toOption();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ParquetFileFormat$.class);
    }

    public static final /* synthetic */ Seq $anonfun$mergeSchemasInParallel$1(boolean assumeBinaryIsString$1, boolean assumeInt96IsTimestamp$1, boolean inferTimestampNTZ$1, boolean nanosAsLong$1, Seq files, Configuration conf, boolean ignoreCorruptFiles) {
        boolean x$1 = assumeBinaryIsString$1;
        boolean x$2 = assumeInt96IsTimestamp$1;
        boolean x$32 = inferTimestampNTZ$1;
        boolean x$4 = nanosAsLong$1;
        boolean x$5 = ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$3();
        ParquetToSparkSchemaConverter converter = new ParquetToSparkSchemaConverter(x$1, x$2, x$5, x$32, x$4);
        return (Seq)MODULE$.readParquetFootersInParallel(conf, (Seq<FileStatus>)files, ignoreCorruptFiles).map((Function1 & Serializable)x$3 -> MODULE$.readSchemaFromFooter((Footer)x$3, converter));
    }

    private ParquetFileFormat$() {
    }
}

