/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkNumberFormatException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLInsertTestSuite$;
import org.apache.spark.sql.catalyst.expressions.Hex$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005=aaB\u0006\r!\u0003\r\t!\u0006\u0005\u0006A\u0001!\t!\t\u0005\u0006Q\u00011\t!\u000b\u0005\u0006k\u00011\tA\u000e\u0005\u0006\u0011\u0002!\t\"\u0013\u0005\b7\u0002\t\n\u0011\"\u0005]\u0011\u00159\u0007\u0001\"\u0005i\u0011\u001di\b!%A\u0005\u0012qCqA \u0001\u0012\u0002\u0013EA\f\u0003\u0005\u0000\u0001E\u0005I\u0011CA\u0001\u0011\u001d\t)\u0001\u0001C\t\u0003\u000f\u0011!cU)M\u0013:\u001cXM\u001d;UKN$8+^5uK*\u0011QBD\u0001\u0004gFd'BA\b\u0011\u0003\u0015\u0019\b/\u0019:l\u0015\t\t\"#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002'\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0006\u000e\u0011\u0005]AR\"\u0001\u0007\n\u0005ea!!C)vKJLH+Z:u!\tYb$D\u0001\u001d\u0015\tiB\"\u0001\u0003uKN$\u0018BA\u0010\u001d\u00051\u0019\u0016\u000b\u0014+fgR,F/\u001b7t\u0003\u0019!\u0013N\\5uIQ\t!\u0005\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0003V]&$\u0018A\u00024pe6\fG/F\u0001+!\tY#G\u0004\u0002-aA\u0011Q\u0006J\u0007\u0002])\u0011q\u0006F\u0001\u0007yI|w\u000e\u001e \n\u0005E\"\u0013A\u0002)sK\u0012,g-\u0003\u00024i\t11\u000b\u001e:j]\u001eT!!\r\u0013\u0002#\rDWmY6Wc\u0005sGM\u0016\u001aFeJ|'\u000f\u0006\u0004#ouz\u0014I\u0012\u0005\u0006q\r\u0001\r!O\u0001\nKb\u001cW\r\u001d;j_:\u0004\"AO\u001e\u000e\u00039I!\u0001\u0010\b\u0003\u001dM\u0003\u0018M]6UQJ|w/\u00192mK\")ah\u0001a\u0001U\u0005aa/M#se>\u00148\t\\1tg\")\u0001i\u0001a\u0001U\u0005aaOM#se>\u00148\t\\1tg\")!i\u0001a\u0001\u0007\u0006aa/\r)be\u0006lW\r^3sgB!1\u0006\u0012\u0016+\u0013\t)EGA\u0002NCBDQaR\u0002A\u0002\r\u000bAB\u001e\u001aQCJ\fW.\u001a;feN\f1b\u0019:fCR,G+\u00192mKR)!E\u0013'X3\")1\n\u0002a\u0001U\u0005)A/\u00192mK\")Q\n\u0002a\u0001\u001d\u0006!1m\u001c7t!\ryEK\u000b\b\u0003!Js!!L)\n\u0003\u0015J!a\u0015\u0013\u0002\u000fA\f7m[1hK&\u0011QK\u0016\u0002\u0004'\u0016\f(BA*%\u0011\u0015AF\u00011\u0001O\u0003!\u0019w\u000e\u001c+za\u0016\u001c\bb\u0002.\u0005!\u0003\u0005\rAT\u0001\ta\u0006\u0014HoQ8mg\u0006)2M]3bi\u0016$\u0016M\u00197fI\u0011,g-Y;mi\u0012\"T#A/+\u00059s6&A0\u0011\u0005\u0001,W\"A1\u000b\u0005\t\u001c\u0017!C;oG\",7m[3e\u0015\t!G%\u0001\u0006b]:|G/\u0019;j_:L!AZ1\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>\u001cWm]:J]N,'\u000f\u001e\u000b\bE%\\7\u000f\u001e<|\u0011\u0015Qg\u00011\u0001+\u0003%!\u0018M\u00197f\u001d\u0006lW\rC\u0003m\r\u0001\u0007Q.A\u0003j]B,H\u000f\u0005\u0002oa:\u0011qc\\\u0005\u0003'2I!!\u001d:\u0003\u0013\u0011\u000bG/\u0019$sC6,'BA*\r\u0011\u001die\u0001%AA\u00029Cq!\u001e\u0004\u0011\u0002\u0003\u0007a*\u0001\bqCJ$\u0018\u000e^5p]\u0016C\bO]:\t\u000b]4\u0001\u0019\u0001=\u0002\u0013=4XM]<sSR,\u0007CA\u0012z\u0013\tQHEA\u0004C_>dW-\u00198\t\u000fq4\u0001\u0013!a\u0001q\u00061!-\u001f(b[\u0016\fq\u0003\u001d:pG\u0016\u001c8/\u00138tKJ$H\u0005Z3gCVdG\u000fJ\u001a\u0002/A\u0014xnY3tg&s7/\u001a:uI\u0011,g-Y;mi\u0012\"\u0014a\u00069s_\u000e,7o]%og\u0016\u0014H\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\t\u0019A\u000b\u0002y=\u0006Ya/\u001a:jMf$\u0016M\u00197f)\u0015\u0011\u0013\u0011BA\u0006\u0011\u0015Q'\u00021\u0001+\u0011\u0019\tiA\u0003a\u0001[\u0006AQ\r\u001f9fGR,G\r")
public interface SQLInsertTestSuite
extends SQLTestUtils {
    public String format();

    public void checkV1AndV2Error(SparkThrowable var1, String var2, String var3, Map<String, String> var4, Map<String, String> var5);

    public static /* synthetic */ void createTable$(SQLInsertTestSuite $this, String table, Seq cols, Seq colTypes, Seq partCols) {
        $this.createTable(table, (Seq<String>)cols, (Seq<String>)colTypes, (Seq<String>)partCols);
    }

    default public void createTable(String table, Seq<String> cols, Seq<String> colTypes, Seq<String> partCols) {
        String values = ((IterableOnceOps)((IterableOps)cols.zip(colTypes)).map((Function1 & Serializable)tuple -> new StringBuilder(1).append((String)tuple._1()).append(" ").append(tuple._2()).toString())).mkString("(", ", ", ")");
        String partitionSpec = partCols.nonEmpty() ? partCols.mkString("PARTITIONED BY (", ",", ")") : "";
        this.sql().apply((Object)new StringBuilder(21).append("CREATE TABLE ").append(table).append(values).append(" USING ").append(this.format()).append(" ").append(partitionSpec).toString());
    }

    public static /* synthetic */ Seq createTable$default$4$(SQLInsertTestSuite $this) {
        return $this.createTable$default$4();
    }

    default public Seq<String> createTable$default$4() {
        return package$.MODULE$.Nil();
    }

    public static /* synthetic */ void processInsert$(SQLInsertTestSuite $this, String tableName, Dataset input, Seq cols, Seq partitionExprs, boolean overwrite, boolean byName) {
        $this.processInsert(tableName, (Dataset<Row>)input, (Seq<String>)cols, (Seq<String>)partitionExprs, overwrite, byName);
    }

    default public void processInsert(String tableName, Dataset<Row> input, Seq<String> cols, Seq<String> partitionExprs, boolean overwrite, boolean byName) {
        String tmpView = "tmp_view";
        String partitionList = partitionExprs.nonEmpty() ? partitionExprs.mkString("PARTITION (", ",", ")") : "";
        this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tmpView}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            input.createOrReplaceTempView(tmpView);
            String overwriteStr = overwrite ? "OVERWRITE" : "INTO";
            String columnList = cols.nonEmpty() && !byName ? cols.mkString("(", ",", ")") : "";
            String byNameStr = byName ? "BY NAME" : "";
            this.sql().apply((Object)new StringBuilder(0).append(new StringBuilder(17).append("INSERT ").append(overwriteStr).append(" TABLE ").append(tableName).append(" ").append(partitionList).append(" ").append(byNameStr).append(" ").toString()).append(new StringBuilder(15).append(columnList).append(" SELECT * FROM ").append(tmpView).toString()).toString());
        });
    }

    public static /* synthetic */ Seq processInsert$default$3$(SQLInsertTestSuite $this) {
        return $this.processInsert$default$3();
    }

    default public Seq<String> processInsert$default$3() {
        return package$.MODULE$.Nil();
    }

    public static /* synthetic */ Seq processInsert$default$4$(SQLInsertTestSuite $this) {
        return $this.processInsert$default$4();
    }

    default public Seq<String> processInsert$default$4() {
        return package$.MODULE$.Nil();
    }

    public static /* synthetic */ boolean processInsert$default$6$(SQLInsertTestSuite $this) {
        return $this.processInsert$default$6();
    }

    default public boolean processInsert$default$6() {
        return false;
    }

    public static /* synthetic */ void verifyTable$(SQLInsertTestSuite $this, String tableName, Dataset expected) {
        $this.verifyTable(tableName, (Dataset<Row>)expected);
    }

    default public void verifyTable(String tableName, Dataset<Row> expected) {
        ((QueryTest)((Object)this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().table(tableName), expected);
    }

    public static /* synthetic */ void $anonfun$$init$$3(SQLInsertTestSuite $this, Dataset df$1, Seq cols$2, boolean m) {
        String x$1 = "t1";
        Dataset x$2 = df$1;
        Seq x$3 = cols$2;
        boolean x$4 = m;
        Seq<String> x$5 = $this.processInsert$default$4();
        boolean x$6 = $this.processInsert$default$6();
        $this.processInsert("t1", (Dataset<Row>)x$2, (Seq<String>)x$3, x$5, x$4, x$6);
        $this.verifyTable("t1", (Dataset<Row>)df$1);
    }

    public static /* synthetic */ void $anonfun$$init$$6(SQLInsertTestSuite $this, Dataset df$2, Seq cols$3, boolean m) {
        String x$7 = "t1";
        Dataset x$8 = df$2;
        Seq x$9 = cols$3;
        boolean x$10 = m;
        Seq<String> x$11 = $this.processInsert$default$4();
        boolean x$12 = $this.processInsert$default$6();
        $this.processInsert("t1", (Dataset<Row>)x$8, (Seq<String>)x$9, x$11, x$10, x$12);
        $this.verifyTable("t1", (Dataset<Row>)df$2);
    }

    public static /* synthetic */ void $anonfun$$init$$8(SQLInsertTestSuite $this, Dataset df$2, Seq cols$3, boolean m) {
        $this.processInsert("t1", (Dataset<Row>)df$2.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2"})), (Seq<String>)((Seq)cols$3.take(2)), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c3=3", "c4=4"}))), m, $this.processInsert$default$6());
        $this.verifyTable("t1", (Dataset<Row>)df$2);
    }

    public static /* synthetic */ boolean $anonfun$$init$$11(String x$1) {
        String string = x$1;
        String string2 = "c3";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static /* synthetic */ void $anonfun$$init$$10(SQLInsertTestSuite $this, Dataset df$2, Seq cols$3, boolean m) {
        $this.processInsert("t1", (Dataset<Row>)df$2.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c4"})), (Seq<String>)((Seq)cols$3.filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SQLInsertTestSuite.$anonfun$$init$$11(x$1)))), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c3=3", "c4"}))), m, $this.processInsert$default$6());
        $this.verifyTable("t1", (Dataset<Row>)df$2);
    }

    public static /* synthetic */ void $anonfun$$init$$14(SQLInsertTestSuite $this, Dataset df$3, Seq cols$4, boolean m) {
        String x$13 = "t1";
        Dataset x$14 = df$3;
        Seq x$15 = (Seq)cols$4.reverse();
        boolean x$16 = m;
        Seq<String> x$17 = $this.processInsert$default$4();
        boolean x$18 = $this.processInsert$default$6();
        $this.processInsert("t1", (Dataset<Row>)x$14, (Seq<String>)x$15, x$17, x$16, x$18);
        $this.verifyTable("t1", (Dataset<Row>)df$3.selectExpr((Seq)cols$4.reverse()));
    }

    public static /* synthetic */ void $anonfun$$init$$32(SQLInsertTestSuite $this, Dataset df$7, Seq cols$7, boolean m) {
        String x$91 = "t1";
        Dataset x$92 = df$7;
        Seq x$93 = (Seq)cols$7.reverse();
        boolean x$94 = m;
        Seq<String> x$95 = $this.processInsert$default$4();
        boolean x$96 = $this.processInsert$default$6();
        $this.processInsert("t1", (Dataset<Row>)x$92, (Seq<String>)x$93, x$95, x$94, x$96);
        $this.verifyTable("t1", (Dataset<Row>)df$7.selectExpr((Seq)cols$7.reverse()));
    }

    public static /* synthetic */ void $anonfun$$init$$34(SQLInsertTestSuite $this, Dataset df$7, Seq cols$7, boolean m) {
        $this.processInsert("t1", (Dataset<Row>)df$7.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2"})), (Seq<String>)((Seq)((SeqOps)cols$7.take(2)).reverse()), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c3=3", "c4=4"}))), m, $this.processInsert$default$6());
        $this.verifyTable("t1", (Dataset<Row>)df$7.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c2", "c1", "c3", "c4"})));
    }

    public static /* synthetic */ void $anonfun$$init$$36(SQLInsertTestSuite $this, Dataset df$7, boolean m) {
        $this.processInsert("t1", (Dataset<Row>)df$7.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c4"})), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c4", "c2", "c1"}))), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c3=3", "c4"}))), m, $this.processInsert$default$6());
        $this.verifyTable("t1", (Dataset<Row>)df$7.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c4", "c2", "c3", "c1"})));
    }

    private void test$1() {
        this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Seq cols = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c3"}));
            this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "long", "string"}))), this.createTable$default$4());
            AnalysisException x$1 = (AnalysisException)((Object)((Object)((Assertions)this).intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"INSERT INTO t1 (c1, c2) values(1, 2, 3)"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303))));
            None$ x$2 = None$.MODULE$;
            String x$3 = "INSERT_COLUMN_ARITY_MISMATCH.TOO_MANY_DATA_COLUMNS";
            Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)".*`t1`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableColumns"), (Object)"`c1`, `c2`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataColumns"), (Object)"`col1`, `col2`, `col3`")}));
            boolean x$5 = true;
            QueryContext[] x$6 = ((SparkFunSuite)this).checkError$default$6();
            ((SparkFunSuite)this).checkError((SparkThrowable)x$1, "INSERT_COLUMN_ARITY_MISMATCH.TOO_MANY_DATA_COLUMNS", (Option)x$2, x$4, true, x$6);
            AnalysisException x$7 = (AnalysisException)((Object)((Object)((Assertions)this).intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"INSERT INTO t1 (c1, c2, c3) values(1, 2)"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315))));
            None$ x$8 = None$.MODULE$;
            String x$9 = "INSERT_COLUMN_ARITY_MISMATCH.NOT_ENOUGH_DATA_COLUMNS";
            Map x$10 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)".*`t1`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableColumns"), (Object)"`c1`, `c2`, `c3`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataColumns"), (Object)"`col1`, `col2`")}));
            boolean x$11 = true;
            QueryContext[] x$12 = ((SparkFunSuite)this).checkError$default$6();
            ((SparkFunSuite)this).checkError((SparkThrowable)x$7, "INSERT_COLUMN_ARITY_MISMATCH.NOT_ENOUGH_DATA_COLUMNS", (Option)x$8, x$10, true, x$12);
        });
    }

    private static boolean shouldThrowException$1(Enumeration.Value policy) {
        boolean bl;
        boolean bl2;
        Enumeration.Value value = policy;
        Enumeration.Value value2 = SQLConf.StoreAssignmentPolicy$.MODULE$.ANSI();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl2 = true;
        } else {
            Enumeration.Value value4 = SQLConf.StoreAssignmentPolicy$.MODULE$.STRICT();
            Enumeration.Value value5 = value;
            bl2 = !(value4 != null ? !value4.equals(value5) : value5 != null);
        }
        if (bl2) {
            bl = true;
        } else {
            Enumeration.Value value6 = SQLConf.StoreAssignmentPolicy$.MODULE$.LEGACY();
            Enumeration.Value value7 = value;
            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                bl = false;
            } else {
                throw new MatchError((Object)value);
            }
        }
        return bl;
    }

    public static /* synthetic */ void $anonfun$$init$$76(SQLInsertTestSuite $this, String query) {
        ((QueryTest)((Object)$this)).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)query), (Seq<Row>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToInteger((int)10), "08"}))}))));
    }

    public static void $init$(SQLInsertTestSuite $this) {
        $this.test("insert with column list - follow table output order", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(SQLInsertTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_SQLInsertTestSuite$$typecreator10$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_SQLInsertTestSuite$$typecreator10$1(SQLInsertTestSuite $outer) {
                }
            }
            Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"3")})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_SQLInsertTestSuite$$typecreator10$1(null)))).toDF();
            Seq cols = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c3"}));
            $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "long", "string"}))), $this.createTable$default$4());
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)m -> {
                SQLInsertTestSuite.$anonfun$$init$$3($this, df, cols, BoxesRunTime.unboxToBoolean((Object)m));
                return BoxedUnit.UNIT;
            });
        }), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        $this.test("insert with column list - follow table output order + partitioned table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Seq cols = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c3", "c4"}));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(SQLInsertTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_SQLInsertTestSuite$$typecreator20$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
                }

                public Org_apache_spark_sql_SQLInsertTestSuite$$typecreator20$1(SQLInsertTestSuite $outer) {
                }
            }
            Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)4))})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_SQLInsertTestSuite$$typecreator20$1(null)))).toDF(cols);
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "int", "int", "int"}))), (Seq<String>)((Seq)cols.takeRight(2)));
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)m -> {
                    SQLInsertTestSuite.$anonfun$$init$$6($this, df, cols, BoxesRunTime.unboxToBoolean((Object)m));
                    return BoxedUnit.UNIT;
                });
            });
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "int", "int", "int"}))), (Seq<String>)((Seq)cols.takeRight(2)));
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)m -> {
                    SQLInsertTestSuite.$anonfun$$init$$8($this, df, cols, BoxesRunTime.unboxToBoolean((Object)m));
                    return BoxedUnit.UNIT;
                });
            });
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "int", "int", "int"}))), (Seq<String>)((Seq)cols.takeRight(2)));
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)m -> {
                    SQLInsertTestSuite.$anonfun$$init$$10($this, df, cols, BoxesRunTime.unboxToBoolean((Object)m));
                    return BoxedUnit.UNIT;
                });
            });
        }, new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        $this.test("insert with column list - table output reorder", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Seq cols = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c3"}));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(SQLInsertTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_SQLInsertTestSuite$$typecreator30$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_SQLInsertTestSuite$$typecreator30$1(SQLInsertTestSuite $outer) {
                }
            }
            Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3))})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_SQLInsertTestSuite$$typecreator30$1(null)))).toDF(cols);
            $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "int", "int"}))), $this.createTable$default$4());
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)m -> {
                SQLInsertTestSuite.$anonfun$$init$$14($this, df, cols, BoxesRunTime.unboxToBoolean((Object)m));
                return BoxedUnit.UNIT;
            });
        }), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        $this.test("insert with column list - by name", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Seq cols = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c3"}));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(SQLInsertTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_SQLInsertTestSuite$$typecreator40$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_SQLInsertTestSuite$$typecreator40$1(SQLInsertTestSuite $outer) {
                }
            }
            Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)1))})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_SQLInsertTestSuite$$typecreator40$1(null)))).toDF((Seq)cols.reverse());
            $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "int", "int"}))), $this.createTable$default$4());
            String x$19 = "t1";
            Dataset x$20 = df;
            boolean x$21 = false;
            boolean x$22 = true;
            Seq<String> x$23 = $this.processInsert$default$3();
            Seq<String> x$24 = $this.processInsert$default$4();
            $this.processInsert("t1", (Dataset<Row>)x$20, x$23, x$24, false, true);
            $this.verifyTable("t1", (Dataset<Row>)df.selectExpr(cols));
        }), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        $this.test("insert with column list - by name + partitioned table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Seq cols = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c3", "c4"}));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(SQLInsertTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_SQLInsertTestSuite$$typecreator50$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
                }

                public Org_apache_spark_sql_SQLInsertTestSuite$$typecreator50$1(SQLInsertTestSuite $outer) {
                }
            }
            Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)1))})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_SQLInsertTestSuite$$typecreator50$1(null)))).toDF((Seq)cols.reverse());
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "int", "int", "int"}))), (Seq<String>)((Seq)cols.takeRight(2)));
                String x$25 = "t1";
                Dataset x$26 = df;
                boolean x$27 = false;
                boolean x$28 = true;
                Seq<String> x$29 = $this.processInsert$default$3();
                Seq<String> x$30 = $this.processInsert$default$4();
                $this.processInsert("t1", (Dataset<Row>)x$26, x$29, x$30, false, true);
                $this.verifyTable("t1", (Dataset<Row>)df.selectExpr(cols));
            });
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "int", "int", "int"}))), (Seq<String>)((Seq)cols.takeRight(2)));
                String x$31 = "t1";
                Dataset x$32 = df.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c2", "c1", "c4"}));
                Seq x$33 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c3=3", "c4"}));
                boolean x$34 = false;
                boolean x$35 = true;
                Seq<String> x$36 = $this.processInsert$default$3();
                $this.processInsert("t1", (Dataset<Row>)x$32, x$36, (Seq<String>)x$33, false, true);
                $this.verifyTable("t1", (Dataset<Row>)df.selectExpr(cols));
            });
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "int", "int", "int"}))), (Seq<String>)((Seq)cols.takeRight(2)));
                String x$37 = "t1";
                Dataset x$38 = df.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c2", "c1"}));
                Seq x$39 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c3=3", "c4=4"}));
                boolean x$40 = false;
                boolean x$41 = true;
                Seq<String> x$42 = $this.processInsert$default$3();
                $this.processInsert("t1", (Dataset<Row>)x$38, x$42, (Seq<String>)x$39, false, true);
                $this.verifyTable("t1", (Dataset<Row>)df.selectExpr(cols));
            });
        }, new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
        $this.test("insert overwrite with column list - by name", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Seq cols = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c3"}));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(SQLInsertTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_SQLInsertTestSuite$$typecreator60$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_SQLInsertTestSuite$$typecreator60$1(SQLInsertTestSuite $outer) {
                }
            }
            Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)1))})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_SQLInsertTestSuite$$typecreator60$1(null)))).toDF((Seq)cols.reverse());
            $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "int", "int"}))), $this.createTable$default$4());
            String x$43 = "t1";
            Dataset x$44 = df;
            boolean x$45 = false;
            Seq<String> x$46 = $this.processInsert$default$3();
            Seq<String> x$47 = $this.processInsert$default$4();
            boolean x$48 = $this.processInsert$default$6();
            $this.processInsert("t1", (Dataset<Row>)x$44, x$46, x$47, false, x$48);
            $this.verifyTable("t1", (Dataset<Row>)df.selectExpr((Seq)cols.reverse()));
            String x$49 = "t1";
            Dataset x$50 = df;
            boolean x$51 = true;
            boolean x$52 = true;
            Seq<String> x$53 = $this.processInsert$default$3();
            Seq<String> x$54 = $this.processInsert$default$4();
            $this.processInsert("t1", (Dataset<Row>)x$50, x$53, x$54, true, true);
            $this.verifyTable("t1", (Dataset<Row>)df.selectExpr(cols));
        }), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        $this.test("insert overwrite with column list - by name + partitioned table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Seq cols = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c3", "c4"}));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(SQLInsertTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_SQLInsertTestSuite$$typecreator70$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
                }

                public Org_apache_spark_sql_SQLInsertTestSuite$$typecreator70$1(SQLInsertTestSuite $outer) {
                }
            }
            Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)1))})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_SQLInsertTestSuite$$typecreator70$1(null)))).toDF((Seq)cols.reverse());
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "int", "int", "int"}))), (Seq<String>)((Seq)cols.takeRight(2)));
                String x$55 = "t1";
                Dataset x$56 = df.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c2", "c1", "c4"}));
                Seq x$57 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c3=3", "c4"}));
                boolean x$58 = false;
                Seq<String> x$59 = $this.processInsert$default$3();
                boolean x$60 = $this.processInsert$default$6();
                $this.processInsert("t1", (Dataset<Row>)x$56, x$59, (Seq<String>)x$57, false, x$60);
                $this.verifyTable("t1", (Dataset<Row>)df.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c2", "c1", "c3", "c4"})));
                String x$61 = "t1";
                Dataset x$62 = df.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c2", "c1", "c4"}));
                Seq x$63 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c3=3", "c4"}));
                boolean x$64 = true;
                boolean x$65 = true;
                Seq<String> x$66 = $this.processInsert$default$3();
                $this.processInsert("t1", (Dataset<Row>)x$62, x$66, (Seq<String>)x$63, true, true);
                $this.verifyTable("t1", (Dataset<Row>)df.selectExpr(cols));
            });
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "int", "int", "int"}))), (Seq<String>)((Seq)cols.takeRight(2)));
                String x$67 = "t1";
                Dataset x$68 = df.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c2", "c1"}));
                Seq x$69 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c3=3", "c4=4"}));
                boolean x$70 = false;
                Seq<String> x$71 = $this.processInsert$default$3();
                boolean x$72 = $this.processInsert$default$6();
                $this.processInsert("t1", (Dataset<Row>)x$68, x$71, (Seq<String>)x$69, false, x$72);
                $this.verifyTable("t1", (Dataset<Row>)df.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c2", "c1", "c3", "c4"})));
                String x$73 = "t1";
                Dataset x$74 = df.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c2", "c1"}));
                Seq x$75 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c3=3", "c4=4"}));
                boolean x$76 = true;
                boolean x$77 = true;
                Seq<String> x$78 = $this.processInsert$default$3();
                $this.processInsert("t1", (Dataset<Row>)x$74, x$78, (Seq<String>)x$75, true, true);
                $this.verifyTable("t1", (Dataset<Row>)df.selectExpr(cols));
            });
        }, new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
        $this.test("insert by name: mismatch column name", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Seq cols = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c3"}));
            Seq cols2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x1", "c2", "c3"}));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(SQLInsertTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_SQLInsertTestSuite$$typecreator80$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_SQLInsertTestSuite$$typecreator80$1(SQLInsertTestSuite $outer) {
                }
            }
            Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)1))})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_SQLInsertTestSuite$$typecreator80$1(null)))).toDF((Seq)cols2.reverse());
            $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "int", "int"}))), $this.createTable$default$4());
            $this.checkV1AndV2Error((SparkThrowable)((Assertions)$this).intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                String x$79 = "t1";
                Dataset x$80 = df;
                boolean x$81 = false;
                boolean x$82 = true;
                Seq<String> x$83 = $this.processInsert$default$3();
                Seq<String> x$84 = $this.processInsert$default$4();
                $this.processInsert("t1", (Dataset<Row>)x$80, x$83, x$84, false, true);
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213)), "INCOMPATIBLE_DATA_FOR_TABLE.EXTRA_COLUMNS", "INCOMPATIBLE_DATA_FOR_TABLE.CANNOT_FIND_DATA", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"`spark_catalog`.`default`.`t1`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"extraColumns"), (Object)"`x1`")}))), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"`testcat`.`t1`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)"`c1`")}))));
            JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(SQLInsertTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_SQLInsertTestSuite$$typecreator90$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
                }

                public Org_apache_spark_sql_SQLInsertTestSuite$$typecreator90$1(SQLInsertTestSuite $outer) {
                }
            }
            Dataset df2 = $this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)0))})), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_SQLInsertTestSuite$$typecreator90$1(null)))).toDF((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c3", "c2", "c1", "c0"})));
            $this.checkV1AndV2Error((SparkThrowable)((Assertions)$this).intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                String x$85 = "t1";
                Dataset x$86 = df2;
                boolean x$87 = false;
                boolean x$88 = true;
                Seq<String> x$89 = $this.processInsert$default$3();
                Seq<String> x$90 = $this.processInsert$default$4();
                $this.processInsert("t1", (Dataset<Row>)x$86, x$89, x$90, false, true);
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224)), "INSERT_COLUMN_ARITY_MISMATCH.TOO_MANY_DATA_COLUMNS", "INSERT_COLUMN_ARITY_MISMATCH.TOO_MANY_DATA_COLUMNS", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"`spark_catalog`.`default`.`t1`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableColumns"), (Object)"`c1`, `c2`, `c3`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataColumns"), (Object)"`c3`, `c2`, `c1`, `c0`")}))), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"`testcat`.`t1`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableColumns"), (Object)"`c1`, `c2`, `c3`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataColumns"), (Object)"`c3`, `c2`, `c1`, `c0`")}))));
        }), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
        $this.test("insert with column list - table output reorder + partitioned table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Seq cols = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c3", "c4"}));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(SQLInsertTestSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_SQLInsertTestSuite$$typecreator100$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
                }

                public Org_apache_spark_sql_SQLInsertTestSuite$$typecreator100$1(SQLInsertTestSuite $outer) {
                }
            }
            Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)4))})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_SQLInsertTestSuite$$typecreator100$1(null)))).toDF(cols);
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "int", "int", "int"}))), (Seq<String>)((Seq)cols.takeRight(2)));
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)m -> {
                    SQLInsertTestSuite.$anonfun$$init$$32($this, df, cols, BoxesRunTime.unboxToBoolean((Object)m));
                    return BoxedUnit.UNIT;
                });
            });
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "int", "int", "int"}))), (Seq<String>)((Seq)cols.takeRight(2)));
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)m -> {
                    SQLInsertTestSuite.$anonfun$$init$$34($this, df, cols, BoxesRunTime.unboxToBoolean((Object)m));
                    return BoxedUnit.UNIT;
                });
            });
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "int", "int", "int"}))), (Seq<String>)((Seq)cols.takeRight(2)));
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)m -> {
                    SQLInsertTestSuite.$anonfun$$init$$36($this, df, BoxesRunTime.unboxToBoolean((Object)m));
                    return BoxedUnit.UNIT;
                });
            });
        }, new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
        $this.test("insert with column list - duplicated columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Seq cols = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c3"}));
            $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "long", "string"}))), $this.createTable$default$4());
            AnalysisException x$97 = (AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t1 (c1, c2, c2) values(1, 2, 3)"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274)))));
            String x$98 = "COLUMN_ALREADY_EXISTS";
            Map x$99 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)"`c2`")}));
            Option x$100 = ((SparkFunSuite)$this).checkError$default$3();
            boolean x$101 = ((SparkFunSuite)$this).checkError$default$5();
            QueryContext[] x$102 = ((SparkFunSuite)$this).checkError$default$6();
            ((SparkFunSuite)$this).checkError((SparkThrowable)x$97, "COLUMN_ALREADY_EXISTS", x$100, x$99, x$101, x$102);
        }), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
        $this.test("insert with column list - invalid columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Seq cols = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "c3"}));
            $this.createTable("t1", (Seq<String>)cols, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"int", "long", "string"}))), $this.createTable$default$4());
            ((SparkFunSuite)$this).checkError((SparkThrowable)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT INTO t1 (c1, c2, c4) values(1, 2, 3)"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287)), "UNRESOLVED_COLUMN.WITH_SUGGESTION", (Option)None$.MODULE$, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objectName"), (Object)"`c4`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"proposal"), (Object)"`c1`, `c2`, `c3`")})), (QueryContext)((SparkFunSuite)$this).ExpectedContext().apply("INSERT INTO t1 (c1, c2, c4)", 0, 26));
        }), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        $this.test("insert with column list - mismatched column list size", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_DEFAULT_COLUMNS().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.test$1());
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_DEFAULT_COLUMNS().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.test$1());
        }, new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
        $this.test("SPARK-34223: static partition with null raise NPE", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.sql().apply((Object)"CREATE TABLE t(i STRING, c string) USING PARQUET PARTITIONED BY (c)");
            $this.sql().apply((Object)"INSERT OVERWRITE t PARTITION (c=null) VALUES ('1')");
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"1", null})));
        }), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
        $this.test("SPARK-33474: Support typed literals as partition spec values", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            String e;
            String binaryStr = "Spark SQL";
            String binaryHexStr = Hex$.MODULE$.hex(UTF8String.fromString((String)binaryStr).getBytes()).toString();
            $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          | CREATE TABLE t1(name STRING, part1 DATE, part2 TIMESTAMP, part3 BINARY,\n          |  part4 STRING, part5 STRING, part6 STRING, part7 STRING)\n          | USING PARQUET PARTITIONED BY (part1, part2, part3, part4, part5, part6, part7)\n         ")));
            $this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(342).append("\n           | INSERT OVERWRITE t1 PARTITION(\n           | part1 = date'2019-01-01',\n           | part2 = timestamp'2019-01-01 11:11:11',\n           | part3 = X'").append(binaryHexStr).append("',\n           | part4 = 'p1',\n           | part5 = date'2019-01-01',\n           | part6 = timestamp'2019-01-01 11:11:11',\n           | part7 = X'").append(binaryHexStr).append("'\n           | ) VALUES('a')\n        ").toString())));
            ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          | SELECT\n          |   name,\n          |   CAST(part1 AS STRING),\n          |   CAST(part2 as STRING),\n          |   CAST(part3 as STRING),\n          |   part4,\n          |   part5,\n          |   part6,\n          |   part7\n          | FROM t1\n        "))), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a", "2019-01-01", "2019-01-01 11:11:11", "Spark SQL", "p1", "2019-01-01", "2019-01-01 11:11:11", "Spark SQL"})));
            String $org_scalatest_assert_macro_left = e = ((AnalysisException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"CREATE TABLE t2(name STRING, part INTERVAL) USING PARQUET PARTITIONED BY (part)"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383)))))).getMessage();
            String $org_scalatest_assert_macro_right = "Cannot use interval";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
        }), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
        $this.test("SPARK-34556: checking duplicate static partition columns should respect case sensitive conf", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)"CREATE TABLE t(i STRING, c string) USING PARQUET PARTITIONED BY (c)");
                ParseException x$103 = (ParseException)((Object)((Object)((Object)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"INSERT OVERWRITE t PARTITION (c='2', C='3') VALUES (1)"), ClassTag$.MODULE$.apply(ParseException.class), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395)))));
                None$ x$104 = None$.MODULE$;
                String x$105 = "DUPLICATE_KEY";
                Map x$106 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"keyColumn"), (Object)"`c`")}));
                SparkFunSuite.ExpectedContext x$107 = ((SparkFunSuite)$this).ExpectedContext().apply("PARTITION (c='2', C='3')", 19, 42);
                ((SparkFunSuite)$this).checkError((SparkThrowable)x$103, "DUPLICATE_KEY", (Option)x$104, x$106, (QueryContext)x$107);
            });
            if (!$this.format().startsWith("hive")) {
                $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    $this.sql().apply((Object)"CREATE TABLE t(i int, c string, C string) USING PARQUET PARTITIONED BY (c, C)");
                    $this.sql().apply((Object)"INSERT OVERWRITE t PARTITION (c='2', C='3') VALUES (1)");
                    ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", "3"})));
                }));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
        $this.test("SPARK-30844: static partition should also follow StoreAssignmentPolicy", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String string = $this.format();
            String string2 = "foo";
            Enumeration.ValueSet testingPolicies = !(string != null ? !string.equals(string2) : string2 != null) ? (Iterable)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{SQLConf.StoreAssignmentPolicy$.MODULE$.ANSI(), SQLConf.StoreAssignmentPolicy$.MODULE$.STRICT()})) : SQLConf.StoreAssignmentPolicy$.MODULE$.values();
            testingPolicies.foreach((Function1 & Serializable)policy -> {
                $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STORE_ASSIGNMENT_POLICY().key()), (Object)policy.toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    $this.sql().apply((Object)"create table t(a int, b string) using parquet partitioned by (a)");
                    if (SQLInsertTestSuite.shouldThrowException$1(policy)) {
                        ((SparkFunSuite)$this).checkError((SparkThrowable)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"insert into t partition(a='ansi') values('ansi')"), ClassTag$.MODULE$.apply(SparkNumberFormatException.class), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438)), "CAST_INVALID_INPUT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expression"), (Object)"'ansi'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceType"), (Object)"\"STRING\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"INT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ansiConfig"), (Object)"\"spark.sql.ansi.enabled\"")})), (QueryContext)((SparkFunSuite)$this).ExpectedContext().apply("insert into t partition(a='ansi')", 0, 32));
                    } else {
                        $this.sql().apply((Object)"insert into t partition(a='ansi') values('ansi')");
                        Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"ansi", null}));
                        ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"select * from t"), (Seq<Row>)package$.MODULE$.Nil().$colon$colon((Object)row));
                    }
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 417));
        $this.test("SPARK-38228: legacy store assignment should not fail on error under ANSI mode", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            String string = $this.format();
            String string2 = "foo";
            if (string == null ? string2 != null : !string.equals(string2)) {
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)ansiEnabled -> {
                    $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STORE_ASSIGNMENT_POLICY().key()), (Object)SQLConf.StoreAssignmentPolicy$.MODULE$.LEGACY().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)ansiEnabled)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                        $this.sql().apply((Object)"create table t(a int) using parquet");
                        $this.sql().apply((Object)"insert into t values('ansi')");
                        ((QueryTest)((Object)((Object)((Object)$this)))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})));
                    }));
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 459));
        $this.test("SPARK-41982: treat the partition field as string literal when keepPartitionSpecAsStringLiteral is enabled", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_KEEP_PARTITION_SPEC_AS_STRING_LITERAL().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)"create table t(i string, j int) using orc partitioned by (dt string)");
                $this.sql().apply((Object)"insert into t partition(dt=08) values('a', 10)");
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select * from t where dt='08'", "select * from t where dt=08"})).foreach((Function1 & Serializable)query -> {
                    SQLInsertTestSuite.$anonfun$$init$$76($this, query);
                    return BoxedUnit.UNIT;
                });
                ((SparkFunSuite)$this).checkError((SparkThrowable)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"alter table t drop partition(dt='8')"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 489)), "PARTITIONS_NOT_FOUND", (Option)None$.MODULE$, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitionList"), (Object)"PARTITION \\(`dt` = 8\\)"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)".*`t`")})), true, ((SparkFunSuite)$this).checkError$default$6());
            }));
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_KEEP_PARTITION_SPEC_AS_STRING_LITERAL().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.sql().apply((Object)"create table t(i string, j int) using orc partitioned by (dt string)");
                $this.sql().apply((Object)"insert into t partition(dt=08) values('a', 10)");
                ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"select * from t where dt='08'"), (Dataset<Row>)((Dataset)$this.sql().apply((Object)"select * from t where dt='07'")));
                ((QueryTest)((Object)((Object)((Object)((Object)$this))))).checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"select * from t where dt=08"), (Seq<Row>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToInteger((int)10), "8"}))}))));
                ((SparkFunSuite)$this).checkError((SparkThrowable)((Assertions)$this).intercept((Function0 & Serializable)() -> (Dataset)$this.sql().apply((Object)"alter table t drop partition(dt='08')"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 509)), "PARTITIONS_NOT_FOUND", (Option)None$.MODULE$, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitionList"), (Object)"PARTITION \\(`dt` = 08\\)"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)".*.`t`")})), true, ((SparkFunSuite)$this).checkError$default$6());
            }));
        }, new Position("SQLInsertTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 477));
    }
}

