/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.Serializable;
import java.sql.Date;
import java.util.NoSuchElementException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.api.java.Optional;
import org.apache.spark.sql.execution.streaming.GroupStateImpl;
import org.apache.spark.sql.execution.streaming.GroupStateImpl$;
import org.apache.spark.sql.streaming.GroupState;
import org.apache.spark.sql.streaming.GroupStateTimeout;
import org.apache.spark.sql.streaming.TestGroupState;
import org.apache.spark.sql.streaming.TestGroupState$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005u3A\u0001B\u0003\u0001!!)Q\u0003\u0001C\u0001-!)\u0011\u0004\u0001C\u00015!)a\n\u0001C\u0001\u001f\nyqI]8vaN#\u0018\r^3Tk&$XM\u0003\u0002\u0007\u000f\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u0011%\t1a]9m\u0015\tQ1\"A\u0003ta\u0006\u00148N\u0003\u0002\r\u001b\u00051\u0011\r]1dQ\u0016T\u0011AD\u0001\u0004_J<7\u0001A\n\u0003\u0001E\u0001\"AE\n\u000e\u0003%I!\u0001F\u0005\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u0019\u00015\tQ!A\u000fuKN$H+[7f_V$H)\u001e:bi&|gNT8u\u00032dwn^3e+\tY\"\u0007\u0006\u0002\u001d\u0003R\u0011Qd\t\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0005+:LG\u000fC\u0004%\u0005\u0005\u0005\t9A\u0013\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0002'[Ar!aJ\u0016\u0011\u0005!zR\"A\u0015\u000b\u0005)z\u0011A\u0002\u001fs_>$h(\u0003\u0002-?\u00051\u0001K]3eK\u001aL!AL\u0018\u0003\u00115\u000bg.\u001b4fgRT!\u0001L\u0010\u0011\u0005E\u0012D\u0002\u0001\u0003\u0006g\t\u0011\r\u0001\u000e\u0002\u0002)F\u0011Q\u0007\u000f\t\u0003=YJ!aN\u0010\u0003\u000f9{G\u000f[5oOB\u0011\u0011H\u0010\b\u0003uqr!\u0001K\u001e\n\u0003\u0001J!!P\u0010\u0002\u000fA\f7m[1hK&\u0011q\b\u0011\u0002\n\u000bb\u001cW\r\u001d;j_:T!!P\u0010\t\u000b\t\u0013\u0001\u0019A\"\u0002\u000bM$\u0018\r^31\u0005\u0011C\u0005c\u0001\rF\u000f&\u0011a)\u0002\u0002\u000f)\u0016\u001cHo\u0012:pkB\u001cF/\u0019;f!\t\t\u0004\nB\u0005J\u0003\u0006\u0005\t\u0011!B\u0001\u0015\n\u0019q\fJ\u0019\u0012\u0005UZ\u0005C\u0001\u0010M\u0013\tiuDA\u0002B]f\fa\u0004^3tiRKW.Z8viRKW.Z:uC6\u0004hj\u001c;BY2|w/\u001a3\u0016\u0005A3FCA)X)\ti\"\u000bC\u0004T\u0007\u0005\u0005\t9\u0001+\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007E\u0002'[U\u0003\"!\r,\u0005\u000bM\u001a!\u0019\u0001\u001b\t\u000b\t\u001b\u0001\u0019\u0001-1\u0005e[\u0006c\u0001\rF5B\u0011\u0011g\u0017\u0003\n9^\u000b\t\u0011!A\u0003\u0002)\u00131a\u0018\u00133\u0001")
public class GroupStateSuite
extends SparkFunSuite {
    public <T extends Exception> void testTimeoutDurationNotAllowed(TestGroupState<?> state, Manifest<T> evidence$1) {
        Optional prevTimestamp = state.getTimeoutTimestampMs();
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> state.setTimeoutDuration(1000L), (ClassTag)evidence$1, new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(state.getTimeoutTimestampMs());
        Optional $org_scalatest_assert_macro_right = prevTimestamp;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> state.setTimeoutDuration("2 second"), (ClassTag)evidence$1, new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 443));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(state.getTimeoutTimestampMs());
        Optional $org_scalatest_assert_macro_right2 = prevTimestamp;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 444));
    }

    public <T extends Exception> void testTimeoutTimestampNotAllowed(TestGroupState<?> state, Manifest<T> evidence$2) {
        Optional prevTimestamp = state.getTimeoutTimestampMs();
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> state.setTimeoutTimestamp(2000L), (ClassTag)evidence$2, new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(state.getTimeoutTimestampMs());
        Optional $org_scalatest_assert_macro_right = prevTimestamp;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 450));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> state.setTimeoutTimestamp(2000L, "1 second"), (ClassTag)evidence$2, new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(state.getTimeoutTimestampMs());
        Optional $org_scalatest_assert_macro_right2 = prevTimestamp;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 452));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> state.setTimeoutTimestamp(new Date(2000L)), (ClassTag)evidence$2, new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 453));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(state.getTimeoutTimestampMs());
        Optional $org_scalatest_assert_macro_right3 = prevTimestamp;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 454));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> state.setTimeoutTimestamp(new Date(2000L), "1 second"), (ClassTag)evidence$2, new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 455));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(state.getTimeoutTimestampMs());
        Optional $org_scalatest_assert_macro_right4 = prevTimestamp;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 456));
    }

    private final void testState$1(Option expectedData, boolean shouldBeUpdated, boolean shouldBeRemoved, ObjectRef state$1) {
        Object object;
        if (expectedData.isDefined()) {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((TestGroupState)state$1.elem).exists(), "state.exists", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((TestGroupState)state$1.elem).get());
            String $org_scalatest_assert_macro_right = (String)expectedData.get();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            object = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        } else {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((TestGroupState)state$1.elem).exists(), "state.exists", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            object = this.intercept((Function0 & Serializable)() -> (String)((TestGroupState)state$1.elem).get(), ClassTag$.MODULE$.apply(NoSuchElementException.class), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        }
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((TestGroupState)state$1.elem).getOption());
        Option $org_scalatest_assert_macro_right = expectedData;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)((TestGroupState)state$1.elem).isUpdated()));
        boolean $org_scalatest_assert_macro_right2 = shouldBeUpdated;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)((TestGroupState)state$1.elem).isRemoved()));
        boolean $org_scalatest_assert_macro_right3 = shouldBeRemoved;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
    }

    private static final boolean testState$default$2$1() {
        return false;
    }

    private static final boolean testState$default$3$1() {
        return false;
    }

    public static final /* synthetic */ void $anonfun$new$7(GroupStateSuite $this, TestGroupState state) {
        $this.testTimeoutDurationNotAllowed(state, ManifestFactory$.MODULE$.classType(UnsupportedOperationException.class));
        $this.testTimeoutTimestampNotAllowed(state, ManifestFactory$.MODULE$.classType(UnsupportedOperationException.class));
        $this.testTimeoutDurationNotAllowed(state, ManifestFactory$.MODULE$.classType(UnsupportedOperationException.class));
        $this.testTimeoutTimestampNotAllowed(state, ManifestFactory$.MODULE$.classType(UnsupportedOperationException.class));
    }

    public static final /* synthetic */ void $anonfun$new$6(GroupStateSuite $this, Optional initValue) {
        Seq states = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TestGroupState[]{TestGroupState$.MODULE$.create(initValue, GroupStateTimeout.NoTimeout(), 1000L, Optional.empty(), false), GroupStateImpl$.MODULE$.createForBatch(GroupStateTimeout.NoTimeout(), false)}));
        states.foreach((Function1 & Serializable)state -> {
            GroupStateSuite.$anonfun$new$7($this, state);
            return BoxedUnit.UNIT;
        });
    }

    private final void testIllegalTimeout$1(Function0 body, ObjectRef state$2) {
        this.intercept(body, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((TestGroupState)state$2.elem).getTimeoutTimestampMs().isPresent(), "state.getTimeoutTimestampMs.isPresent()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
    }

    private static final GroupState streamingState$1(GroupStateTimeout timeoutConf, Optional watermark) {
        return TestGroupState$.MODULE$.create(Optional.empty(), timeoutConf, 1000L, watermark, false);
    }

    private static final GroupState batchState$1(GroupStateTimeout timeoutConf, boolean watermarkPresent) {
        return GroupStateImpl$.MODULE$.createForBatch(timeoutConf, watermarkPresent);
    }

    private final void assertWrongTimeoutError$1(Function0 test) {
        UnsupportedOperationException e = (UnsupportedOperationException)this.intercept(test, ClassTag$.MODULE$.apply(UnsupportedOperationException.class), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
        String $org_scalatest_assert_macro_left = e.getMessage();
        String $org_scalatest_assert_macro_right = "Cannot get event time watermark timestamp without setting watermark";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
    }

    private static final GroupState streamingState$2(GroupStateTimeout timeoutConf, long procTime, boolean watermarkPresent) {
        Optional eventTimeWatermarkMs = watermarkPresent ? Optional.of((Object)BoxesRunTime.boxToLong((long)1000L)) : Optional.empty();
        return TestGroupState$.MODULE$.create(Optional.of((Object)BoxesRunTime.boxToInteger((int)1000)), timeoutConf, procTime, eventTimeWatermarkMs, false);
    }

    private static final GroupState batchState$2(GroupStateTimeout timeoutConf, boolean watermarkPresent) {
        return GroupStateImpl$.MODULE$.createForBatch(timeoutConf, watermarkPresent);
    }

    public static final /* synthetic */ Assertion $anonfun$new$40(GroupStateSuite $this, GroupStateTimeout timeoutConf$3, boolean watermarkPresent) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)GroupStateSuite.streamingState$2(timeoutConf$3, 0L, watermarkPresent).getCurrentProcessingTimeMs()));
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)GroupStateSuite.streamingState$2(timeoutConf$3, 1000L, watermarkPresent).getCurrentProcessingTimeMs()));
        int $org_scalatest_assert_macro_right2 = 1000;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 399));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)GroupStateSuite.streamingState$2(timeoutConf$3, 2000L, watermarkPresent).getCurrentProcessingTimeMs()));
        int $org_scalatest_assert_macro_right3 = 2000;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
        long currentTime = System.currentTimeMillis();
        long $org_scalatest_assert_macro_left4 = GroupStateSuite.batchState$2(timeoutConf$3, watermarkPresent).getCurrentProcessingTimeMs();
        long $org_scalatest_assert_macro_right4 = currentTime;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), ">=", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 >= $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 406));
    }

    public static final /* synthetic */ void $anonfun$new$39(GroupStateSuite $this, GroupStateTimeout timeoutConf) {
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)watermarkPresent -> GroupStateSuite.$anonfun$new$40($this, timeoutConf, BoxesRunTime.unboxToBoolean((Object)watermarkPresent)));
    }

    public GroupStateSuite() {
        this.test("SPARK-35800: ensure TestGroupState creates instances the same as prod", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TestGroupState testState = TestGroupState$.MODULE$.create(Optional.of((Object)BoxesRunTime.boxToInteger((int)5)), GroupStateTimeout.EventTimeTimeout(), 1L, Optional.of((Object)BoxesRunTime.boxToLong((long)1L)), false);
            GroupStateImpl prodState = GroupStateImpl$.MODULE$.createForStreaming((Option)new Some((Object)BoxesRunTime.boxToInteger((int)5)), 1L, 1L, GroupStateTimeout.EventTimeTimeout(), false, true);
            TestGroupState $org_scalatest_assert_macro_left = testState;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.sql.execution.streaming.GroupStateImpl", $org_scalatest_assert_macro_left instanceof GroupStateImpl, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)testState.isRemoved()));
            boolean $org_scalatest_assert_macro_right = prodState.isRemoved();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)testState.isUpdated()));
            boolean $org_scalatest_assert_macro_right2 = prodState.isUpdated();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)testState.exists()));
            boolean $org_scalatest_assert_macro_right3 = prodState.exists();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(testState.get());
            int $org_scalatest_assert_macro_right4 = BoxesRunTime.unboxToInt((Object)prodState.get());
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(testState.getTimeoutTimestampMs());
            Optional $org_scalatest_assert_macro_right5 = prodState.getTimeoutTimestampMs();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)testState.hasTimedOut()));
            boolean $org_scalatest_assert_macro_right6 = prodState.hasTimedOut();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)testState.getCurrentProcessingTimeMs()));
            long $org_scalatest_assert_macro_right7 = prodState.getCurrentProcessingTimeMs();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)testState.getCurrentWatermarkMs()));
            long $org_scalatest_assert_macro_right8 = prodState.getCurrentWatermarkMs();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
            testState.update((Object)BoxesRunTime.boxToInteger((int)6));
            prodState.update((Object)BoxesRunTime.boxToInteger((int)6));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)testState.isUpdated()));
            boolean $org_scalatest_assert_macro_right9 = prodState.isUpdated();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)testState.exists()));
            boolean $org_scalatest_assert_macro_right10 = prodState.exists();
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(testState.get());
            int $org_scalatest_assert_macro_right11 = BoxesRunTime.unboxToInt((Object)prodState.get());
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
            testState.remove();
            prodState.remove();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)testState.exists()));
            boolean $org_scalatest_assert_macro_right12 = prodState.exists();
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)testState.isRemoved()));
            boolean $org_scalatest_assert_macro_right13 = prodState.isRemoved();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right13), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        }, new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
        this.test("GroupState - get, exists, update, remove", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ObjectRef state = ObjectRef.create(null);
            state.elem = TestGroupState$.MODULE$.create(Optional.empty(), GroupStateTimeout.NoTimeout(), 1L, Optional.empty(), false);
            this.testState$1((Option)None$.MODULE$, GroupStateSuite.testState$default$2$1(), GroupStateSuite.testState$default$3$1(), state);
            ((TestGroupState)state.elem).update((Object)"");
            this.testState$1((Option)new Some((Object)""), true, GroupStateSuite.testState$default$3$1(), state);
            state.elem = TestGroupState$.MODULE$.create(Optional.of((Object)"2"), GroupStateTimeout.NoTimeout(), 1L, Optional.empty(), false);
            this.testState$1((Option)new Some((Object)"2"), GroupStateSuite.testState$default$2$1(), GroupStateSuite.testState$default$3$1(), state);
            ((TestGroupState)state.elem).update((Object)"3");
            this.testState$1((Option)new Some((Object)"3"), true, GroupStateSuite.testState$default$3$1(), state);
            ((TestGroupState)state.elem).remove();
            None$ x$1 = None$.MODULE$;
            boolean x$2 = true;
            boolean x$3 = false;
            this.testState$1((Option)x$1, false, true, state);
            ((TestGroupState)state.elem).remove();
            ((TestGroupState)state.elem).update((Object)"4");
            Some x$4 = new Some((Object)"4");
            boolean x$5 = false;
            boolean x$6 = true;
            this.testState$1((Option)x$4, true, false, state);
            return (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ((TestGroupState)state$1.elem).update(null), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        }, new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("GroupState - setTimeout - with NoTimeout", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Optional[]{Optional.empty(), Optional.of((Object)BoxesRunTime.boxToInteger((int)5))})).foreach((Function1 & Serializable)initValue -> {
            GroupStateSuite.$anonfun$new$6(this, initValue);
            return BoxedUnit.UNIT;
        }), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        this.test("GroupState - setTimeout - with ProcessingTimeTimeout", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            TestGroupState state = TestGroupState$.MODULE$.create(Optional.empty(), GroupStateTimeout.ProcessingTimeTimeout(), 1000L, Optional.empty(), false);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(state.getTimeoutTimestampMs().isPresent(), "state.getTimeoutTimestampMs.isPresent()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
            state.setTimeoutDuration("-1 month 31 days 1 second");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(state.getTimeoutTimestampMs().isPresent(), "state.getTimeoutTimestampMs.isPresent()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(state.getTimeoutTimestampMs().get());
            int $org_scalatest_assert_macro_right = 2000;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            state.setTimeoutDuration(500L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(state.getTimeoutTimestampMs().get());
            int $org_scalatest_assert_macro_right2 = 1500;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            this.testTimeoutTimestampNotAllowed(state, ManifestFactory$.MODULE$.classType(UnsupportedOperationException.class));
            state.update((Object)BoxesRunTime.boxToInteger((int)5));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(state.getTimeoutTimestampMs().isPresent(), "state.getTimeoutTimestampMs.isPresent()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(state.getTimeoutTimestampMs().get());
            int $org_scalatest_assert_macro_right3 = 1500;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            state.setTimeoutDuration(1000L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(state.getTimeoutTimestampMs().get());
            int $org_scalatest_assert_macro_right4 = 2000;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            state.setTimeoutDuration("2 second");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(state.getTimeoutTimestampMs().get());
            int $org_scalatest_assert_macro_right5 = 3000;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            this.testTimeoutTimestampNotAllowed(state, ManifestFactory$.MODULE$.classType(UnsupportedOperationException.class));
            state.remove();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(state.getTimeoutTimestampMs().isPresent(), "state.getTimeoutTimestampMs.isPresent()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(state.getTimeoutTimestampMs().get());
            int $org_scalatest_assert_macro_right6 = 3000;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            state.setTimeoutDuration(500L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(state.getTimeoutTimestampMs().get());
            int $org_scalatest_assert_macro_right7 = 1500;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
            this.testTimeoutTimestampNotAllowed(state, ManifestFactory$.MODULE$.classType(UnsupportedOperationException.class));
            state = GroupStateImpl$.MODULE$.createForBatch(GroupStateTimeout.ProcessingTimeTimeout(), false);
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(state.getTimeoutTimestampMs().isPresent(), "state.getTimeoutTimestampMs.isPresent()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            state.setTimeoutDuration(500L);
            this.testTimeoutTimestampNotAllowed(state, ManifestFactory$.MODULE$.classType(UnsupportedOperationException.class));
            state.update((Object)BoxesRunTime.boxToInteger((int)5));
            state.setTimeoutDuration(1000L);
            state.setTimeoutDuration("2 second");
            this.testTimeoutTimestampNotAllowed(state, ManifestFactory$.MODULE$.classType(UnsupportedOperationException.class));
            state.remove();
            state.setTimeoutDuration(500L);
            this.testTimeoutTimestampNotAllowed(state, ManifestFactory$.MODULE$.classType(UnsupportedOperationException.class));
        }, new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        this.test("GroupState - setTimeout - with EventTimeTimeout", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            TestGroupState state = TestGroupState$.MODULE$.create(Optional.empty(), GroupStateTimeout.EventTimeTimeout(), 1000L, Optional.of((Object)BoxesRunTime.boxToLong((long)1000L)), false);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(state.getTimeoutTimestampMs().isPresent(), "state.getTimeoutTimestampMs.isPresent()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            this.testTimeoutDurationNotAllowed(state, ManifestFactory$.MODULE$.classType(UnsupportedOperationException.class));
            state.setTimeoutTimestamp(5000L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(state.getTimeoutTimestampMs().get());
            int $org_scalatest_assert_macro_right = 5000;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            state.update((Object)BoxesRunTime.boxToInteger((int)5));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(state.getTimeoutTimestampMs().get());
            int $org_scalatest_assert_macro_right2 = 5000;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
            state.setTimeoutTimestamp(10000L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(state.getTimeoutTimestampMs().get());
            int $org_scalatest_assert_macro_right3 = 10000;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
            state.setTimeoutTimestamp(new Date(20000L));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(state.getTimeoutTimestampMs().get());
            int $org_scalatest_assert_macro_right4 = 20000;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            this.testTimeoutDurationNotAllowed(state, ManifestFactory$.MODULE$.classType(UnsupportedOperationException.class));
            state.remove();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(state.getTimeoutTimestampMs().get());
            int $org_scalatest_assert_macro_right5 = 20000;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            state.setTimeoutTimestamp(5000L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(state.getTimeoutTimestampMs().get());
            int $org_scalatest_assert_macro_right6 = 5000;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            this.testTimeoutDurationNotAllowed(state, ManifestFactory$.MODULE$.classType(UnsupportedOperationException.class));
            state = GroupStateImpl$.MODULE$.createForBatch(GroupStateTimeout.EventTimeTimeout(), false);
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(state.getTimeoutTimestampMs().isPresent(), "state.getTimeoutTimestampMs.isPresent()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
            this.testTimeoutDurationNotAllowed(state, ManifestFactory$.MODULE$.classType(UnsupportedOperationException.class));
            state.setTimeoutTimestamp(5000L);
            state.update((Object)BoxesRunTime.boxToInteger((int)5));
            state.setTimeoutTimestamp(10000L);
            state.setTimeoutTimestamp(new Date(20000L));
            this.testTimeoutDurationNotAllowed(state, ManifestFactory$.MODULE$.classType(UnsupportedOperationException.class));
            state.remove();
            state.setTimeoutTimestamp(5000L);
            this.testTimeoutDurationNotAllowed(state, ManifestFactory$.MODULE$.classType(UnsupportedOperationException.class));
        }, new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
        this.test("GroupState - illegal params to setTimeout", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ObjectRef state = ObjectRef.create(null);
            state.elem = TestGroupState$.MODULE$.create(Optional.of((Object)BoxesRunTime.boxToInteger((int)5)), GroupStateTimeout.ProcessingTimeTimeout(), 1000L, Optional.empty(), false);
            this.testIllegalTimeout$1((Function0)(JFunction0.mcV.sp & Serializable)() -> ((TestGroupState)state$2.elem).setTimeoutDuration(-1000L), state);
            this.testIllegalTimeout$1((Function0)(JFunction0.mcV.sp & Serializable)() -> ((TestGroupState)state$2.elem).setTimeoutDuration(0L), state);
            this.testIllegalTimeout$1((Function0)(JFunction0.mcV.sp & Serializable)() -> ((TestGroupState)state$2.elem).setTimeoutDuration("-2 second"), state);
            this.testIllegalTimeout$1((Function0)(JFunction0.mcV.sp & Serializable)() -> ((TestGroupState)state$2.elem).setTimeoutDuration("-1 month"), state);
            this.testIllegalTimeout$1((Function0)(JFunction0.mcV.sp & Serializable)() -> ((TestGroupState)state$2.elem).setTimeoutDuration("1 month -31 day"), state);
            state.elem = TestGroupState$.MODULE$.create(Optional.of((Object)BoxesRunTime.boxToInteger((int)5)), GroupStateTimeout.EventTimeTimeout(), 1000L, Optional.of((Object)BoxesRunTime.boxToLong((long)1000L)), false);
            this.testIllegalTimeout$1((Function0)(JFunction0.mcV.sp & Serializable)() -> ((TestGroupState)state$2.elem).setTimeoutTimestamp(-10000L), state);
            this.testIllegalTimeout$1((Function0)(JFunction0.mcV.sp & Serializable)() -> ((TestGroupState)state$2.elem).setTimeoutTimestamp(10000L, "-3 second"), state);
            this.testIllegalTimeout$1((Function0)(JFunction0.mcV.sp & Serializable)() -> ((TestGroupState)state$2.elem).setTimeoutTimestamp(10000L, "-1 month"), state);
            this.testIllegalTimeout$1((Function0)(JFunction0.mcV.sp & Serializable)() -> ((TestGroupState)state$2.elem).setTimeoutTimestamp(10000L, "1 month -32 day"), state);
            this.testIllegalTimeout$1((Function0)(JFunction0.mcV.sp & Serializable)() -> ((TestGroupState)state$2.elem).setTimeoutTimestamp(new Date(-10000L)), state);
            this.testIllegalTimeout$1((Function0)(JFunction0.mcV.sp & Serializable)() -> ((TestGroupState)state$2.elem).setTimeoutTimestamp(new Date(-10000L), "-3 second"), state);
            this.testIllegalTimeout$1((Function0)(JFunction0.mcV.sp & Serializable)() -> ((TestGroupState)state$2.elem).setTimeoutTimestamp(new Date(-10000L), "-1 month"), state);
            this.testIllegalTimeout$1((Function0)(JFunction0.mcV.sp & Serializable)() -> ((TestGroupState)state$2.elem).setTimeoutTimestamp(new Date(-10000L), "1 month -32 day"), state);
        }, new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
        this.test("SPARK-35800: illegal params to create", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            IllegalArgumentException illegalArgument = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> TestGroupState$.MODULE$.create(Optional.of((Object)BoxesRunTime.boxToInteger((int)5)), GroupStateTimeout.EventTimeTimeout(), 100L, Optional.of((Object)BoxesRunTime.boxToLong((long)-1000L)), false), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
            String $org_scalatest_assert_macro_left = illegalArgument.getMessage();
            String $org_scalatest_assert_macro_right = "eventTimeWatermarkMs must be 0 or positive if present";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
            illegalArgument = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> GroupStateImpl$.MODULE$.createForStreaming((Option)new Some((Object)BoxesRunTime.boxToInteger((int)5)), 100L, -1000L, GroupStateTimeout.EventTimeTimeout(), false, true), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
            String $org_scalatest_assert_macro_left2 = illegalArgument.getMessage();
            String $org_scalatest_assert_macro_right2 = "eventTimeWatermarkMs must be 0 or positive if present";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
            illegalArgument = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> TestGroupState$.MODULE$.create(Optional.of((Object)BoxesRunTime.boxToInteger((int)5)), GroupStateTimeout.EventTimeTimeout(), -100L, Optional.of((Object)BoxesRunTime.boxToLong((long)1000L)), false), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288));
            String $org_scalatest_assert_macro_left3 = illegalArgument.getMessage();
            String $org_scalatest_assert_macro_right3 = "batchProcessingTimeMs must be 0 or positive";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
            illegalArgument = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> GroupStateImpl$.MODULE$.createForStreaming((Option)new Some((Object)BoxesRunTime.boxToInteger((int)5)), -100L, 1000L, GroupStateTimeout.EventTimeTimeout(), false, true), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
            String $org_scalatest_assert_macro_left4 = illegalArgument.getMessage();
            String $org_scalatest_assert_macro_right4 = "batchProcessingTimeMs must be 0 or positive";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
            UnsupportedOperationException unsupportedOperation = (UnsupportedOperationException)this.intercept((Function0 & Serializable)() -> TestGroupState$.MODULE$.create(Optional.of((Object)BoxesRunTime.boxToInteger((int)5)), GroupStateTimeout.NoTimeout(), 100L, Optional.empty(), true), ClassTag$.MODULE$.apply(UnsupportedOperationException.class), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
            String $org_scalatest_assert_macro_left5 = unsupportedOperation.getMessage();
            String $org_scalatest_assert_macro_right5 = "hasTimedOut is true however there's no timeout configured";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
            unsupportedOperation = (UnsupportedOperationException)this.intercept((Function0 & Serializable)() -> GroupStateImpl$.MODULE$.createForStreaming((Option)new Some((Object)BoxesRunTime.boxToInteger((int)5)), 100L, GroupStateImpl$.MODULE$.NO_TIMESTAMP(), GroupStateTimeout.NoTimeout(), true, false), ClassTag$.MODULE$.apply(UnsupportedOperationException.class), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
            String $org_scalatest_assert_macro_left6 = unsupportedOperation.getMessage();
            String $org_scalatest_assert_macro_right6 = "hasTimedOut is true however there's no timeout configured";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.contains($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
        }, new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
        this.test("GroupState - hasTimedOut", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GroupStateTimeout[]{GroupStateTimeout.NoTimeout(), GroupStateTimeout.ProcessingTimeTimeout(), GroupStateTimeout.EventTimeTimeout()})).foreach((Function1 & Serializable)timeoutConf -> {
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Optional[]{Optional.empty(), Optional.of((Object)BoxesRunTime.boxToInteger((int)5))})).foreach((Function1 & Serializable)initState -> {
                BoxedUnit boxedUnit;
                TestGroupState state1 = TestGroupState$.MODULE$.create(initState, timeoutConf, 1000L, Optional.empty(), false);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)state1.hasTimedOut()));
                boolean $org_scalatest_assert_macro_right = false;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
                GroupStateTimeout groupStateTimeout = timeoutConf;
                GroupStateTimeout groupStateTimeout2 = GroupStateTimeout.NoTimeout();
                if (groupStateTimeout == null ? groupStateTimeout2 != null : !groupStateTimeout.equals(groupStateTimeout2)) {
                    TestGroupState state2 = TestGroupState$.MODULE$.create(initState, timeoutConf, 1000L, Optional.empty(), true);
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(state2.hasTimedOut(), "state2.hasTimedOut", Prettifier$.MODULE$.default());
                    boxedUnit = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)GroupStateImpl$.MODULE$.createForBatch(timeoutConf, false).hasTimedOut()));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
        }), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
        this.test("GroupState - getCurrentWatermarkMs", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GroupStateTimeout[]{GroupStateTimeout.NoTimeout(), GroupStateTimeout.EventTimeTimeout(), GroupStateTimeout.ProcessingTimeTimeout()})).foreach((Function1 & Serializable)timeoutConf -> {
            this.assertWrongTimeoutError$1((Function0)(JFunction0.mcV.sp & Serializable)() -> GroupStateSuite.streamingState$1(timeoutConf, Optional.empty()).getCurrentWatermarkMs());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)GroupStateSuite.streamingState$1(timeoutConf, Optional.of((Object)BoxesRunTime.boxToLong((long)0L))).getCurrentWatermarkMs()));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)GroupStateSuite.streamingState$1(timeoutConf, Optional.of((Object)BoxesRunTime.boxToLong((long)1000L))).getCurrentWatermarkMs()));
            int $org_scalatest_assert_macro_right2 = 1000;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)GroupStateSuite.streamingState$1(timeoutConf, Optional.of((Object)BoxesRunTime.boxToLong((long)2000L))).getCurrentWatermarkMs()));
            int $org_scalatest_assert_macro_right3 = 2000;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)GroupStateSuite.batchState$1(GroupStateTimeout.EventTimeTimeout(), true).getCurrentWatermarkMs()));
            int $org_scalatest_assert_macro_right4 = -1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
            this.assertWrongTimeoutError$1((Function0)(JFunction0.mcV.sp & Serializable)() -> GroupStateSuite.batchState$1(timeoutConf, false).getCurrentWatermarkMs());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)GroupStateSuite.batchState$1(timeoutConf, true).getCurrentWatermarkMs()));
            int $org_scalatest_assert_macro_right5 = -1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
        }), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
        this.test("GroupState - getCurrentProcessingTimeMs", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GroupStateTimeout[]{GroupStateTimeout.NoTimeout(), GroupStateTimeout.EventTimeTimeout(), GroupStateTimeout.ProcessingTimeTimeout()})).foreach((Function1 & Serializable)timeoutConf -> {
            GroupStateSuite.$anonfun$new$39(this, timeoutConf);
            return BoxedUnit.UNIT;
        }), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
        this.test("GroupState - primitive type", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ObjectRef intState = ObjectRef.create((Object)TestGroupState$.MODULE$.create(Optional.empty(), GroupStateTimeout.NoTimeout(), 1000L, Optional.empty(), false));
            this.intercept((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)((TestGroupState)intState$1.elem).get()), ClassTag$.MODULE$.apply(NoSuchElementException.class), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 418));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((TestGroupState)intState.elem).getOption());
            None$ $org_scalatest_assert_macro_right = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 421));
            intState.elem = TestGroupState$.MODULE$.create(Optional.of((Object)BoxesRunTime.boxToInteger((int)10)), GroupStateTimeout.NoTimeout(), 1000L, Optional.empty(), false);
            int $org_scalatest_assert_macro_left2 = BoxesRunTime.unboxToInt((Object)((TestGroupState)intState.elem).get());
            int $org_scalatest_assert_macro_right2 = 10;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 430));
            ((TestGroupState)intState.elem).update((Object)BoxesRunTime.boxToInteger((int)0));
            int $org_scalatest_assert_macro_left3 = BoxesRunTime.unboxToInt((Object)((TestGroupState)intState.elem).get());
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
            ((TestGroupState)intState.elem).remove();
            return (NoSuchElementException)this.intercept((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)((TestGroupState)intState$1.elem).get()), ClassTag$.MODULE$.apply(NoSuchElementException.class), new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434));
        }, new Position("GroupStateSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
    }
}

