/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.ExtendedAnalysisException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.columnar.CachedRDDBuilder;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.storage.StorageLevel;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u001df!B\u0012%\u0003\u0003i\u0003\"\u0002\u001e\u0001\t\u0003Y\u0004\"B\u0014\u0001\r#q\u0004\"\u0002\"\u0001\t\u0003\u0019\u0005\"B2\u0001\t\u0003!\u0007\"B4\u0001\t#A\u0007bBA\u0001\u0001\u0011E\u00111\u0001\u0005\b\u0003W\u0001A\u0011BA\u0017\u0011\u001d\t\t\u0005\u0001C\t\u0003\u0007Bq!!\u0011\u0001\t#\t9\u0006C\u0004\u0002B\u0001!\t\"!\u0018\t\u000f\u0005\r\u0004\u0001\"\u0005\u0002f!9\u00111\r\u0001\u0005\u0012\u0005]\u0004bBA@\u0001\u0011\u0005\u0011\u0011\u0011\u0005\n\u00037\u0003\u0011\u0013!C\u0001\u0003;Cq!a \u0001\t\u0003\t\u0019\fC\u0004\u0002V\u0002!\t!a6\b\u000f\u0005\u0015H\u0005#\u0001\u0002h\u001a11\u0005\nE\u0001\u0003SDaA\u000f\n\u0005\u0002\t5\u0001bBA!%\u0011\u0005!q\u0002\u0005\n\u0005?\u0011\u0012\u0013!C\u0001\u0005CAqA!\n\u0013\t\u0003\u00119\u0003C\u0005\u00036I\t\n\u0011\"\u0001\u0003\"!9!q\u0007\n\u0005\u0002\te\u0002b\u0002B\"%\u0011\u0005!Q\t\u0005\b\u0005\u0017\u0012B\u0011\u0002B'\u0011%\u00119FEI\u0001\n\u0013\u0011\t\u0003C\u0004\u0003ZI!\tAa\u0017\t\u000f\t\r$\u0003\"\u0001\u0003f!9!q\u000e\n\u0005\u0002\tE\u0004\"\u0003B=%E\u0005I\u0011\u0001B\u0011\u0011\u001d\t\u0019G\u0005C\t\u0005wBq!!\u0011\u0013\t\u0003\u0011)\tC\u0005\u0003\u0018J\t\t\u0011\"\u0003\u0003\u001a\nI\u0011+^3ssR+7\u000f\u001e\u0006\u0003K\u0019\n1a]9m\u0015\t9\u0003&A\u0003ta\u0006\u00148N\u0003\u0002*U\u00051\u0011\r]1dQ\u0016T\u0011aK\u0001\u0004_J<7\u0001A\n\u0004\u00019\u0012\u0004CA\u00181\u001b\u00051\u0013BA\u0019'\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u00111\u0007O\u0007\u0002i)\u0011QGN\u0001\u0006a2\fgn\u001d\u0006\u0003o\u0011\n\u0001bY1uC2L8\u000f^\u0005\u0003sQ\u0012\u0001\u0002\u00157b]R+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0002\"!\u0010\u0001\u000e\u0003\u0011*\u0012a\u0010\t\u0003{\u0001K!!\u0011\u0013\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002%\rDWmY6LKf<xN\u001d3t\u000bbL7\u000f\u001e\u000b\u0004\t*\u001b\u0006CA#I\u001b\u00051%\"A$\u0002\u000bM\u001c\u0017\r\\1\n\u0005%3%\u0001B+oSRDQaS\u0002A\u00021\u000b!\u0001\u001a4\u0011\u00055\u0003fBA\u001fO\u0013\tyE%A\u0004qC\u000e\\\u0017mZ3\n\u0005E\u0013&!\u0003#bi\u00064%/Y7f\u0015\tyE\u0005C\u0003U\u0007\u0001\u0007Q+\u0001\u0005lKf<xN\u001d3t!\r)e\u000bW\u0005\u0003/\u001a\u0013!\u0002\u0010:fa\u0016\fG/\u001a3?!\tI\u0006M\u0004\u0002[=B\u00111LR\u0007\u00029*\u0011Q\fL\u0001\u0007yI|w\u000e\u001e \n\u0005}3\u0015A\u0002)sK\u0012,g-\u0003\u0002bE\n11\u000b\u001e:j]\u001eT!a\u0018$\u0002+\rDWmY6LKf<xN\u001d3t\u001d>$X\t_5tiR\u0019A)\u001a4\t\u000b-#\u0001\u0019\u0001'\t\u000bQ#\u0001\u0019A+\u0002\u0019\rDWmY6ECR\f7/\u001a;\u0016\u0005%$Hc\u0001#k{\"11.\u0002CA\u00021\f!\u0001Z:\u0011\u0007\u0015kw.\u0003\u0002o\r\nAAHY=oC6,g\bE\u0002>aJL!!\u001d\u0013\u0003\u000f\u0011\u000bG/Y:fiB\u00111\u000f\u001e\u0007\u0001\t\u0015)XA1\u0001w\u0005\u0005!\u0016CA<{!\t)\u00050\u0003\u0002z\r\n9aj\u001c;iS:<\u0007CA#|\u0013\tahIA\u0002B]fDQA`\u0003A\u0002}\fa\"\u001a=qK\u000e$X\rZ!og^,'\u000fE\u0002F-J\fQc\u00195fG.$\u0015\r^1tKR,fn\u001c:eKJd\u00170\u0006\u0003\u0002\u0006\u0005}ACBA\u0004\u0003C\t9\u0003F\u0002E\u0003\u0013A\u0011\"a\u0003\u0007\u0003\u0003\u0005\u001d!!\u0004\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007\u0005\u0004\u0002\u0010\u0005]\u0011Q\u0004\b\u0005\u0003#\t)BD\u0002\\\u0003'I\u0011aR\u0005\u0003\u001f\u001aKA!!\u0007\u0002\u001c\tAqJ\u001d3fe&twM\u0003\u0002P\rB\u00191/a\b\u0005\u000bU4!\u0019\u0001<\t\u000f-4A\u00111\u0001\u0002$A!Q)\\A\u0013!\u0011i\u0004/!\b\t\ry4\u0001\u0019AA\u0015!\u0011)e+!\b\u0002\u0013\u001d,GOU3tk2$X\u0003BA\u0018\u0003s!B!!\r\u0002<A)Q)a\r\u00028%\u0019\u0011Q\u0007$\u0003\u000b\u0005\u0013(/Y=\u0011\u0007M\fI\u0004B\u0003v\u000f\t\u0007a\u000fC\u0004l\u000f\u0011\u0005\r!!\u0010\u0011\t\u0015k\u0017q\b\t\u0005{A\f9$A\u0006dQ\u0016\u001c7.\u00118to\u0016\u0014H#\u0002#\u0002F\u0005%\u0003bB&\t\t\u0003\u0007\u0011q\t\t\u0004\u000b6d\u0005B\u0002@\t\u0001\u0004\tY\u0005\u0005\u0004\u0002\u0010\u00055\u0013\u0011K\u0005\u0005\u0003\u001f\nYBA\u0002TKF\u00042!PA*\u0013\r\t)\u0006\n\u0002\u0004%><H#\u0002#\u0002Z\u0005m\u0003bB&\n\t\u0003\u0007\u0011q\t\u0005\u0007}&\u0001\r!!\u0015\u0015\u000b\u0011\u000by&!\u0019\t\u000f-SA\u00111\u0001\u0002H!)aP\u0003a\u0001\u0019\u000612\r[3dW\u0006;wM]3hCR,7oV5uQR{G\u000eF\u0004E\u0003O\nY'!\u001c\t\r\u0005%4\u00021\u0001M\u0003%!\u0017\r^1Ge\u0006lW\r\u0003\u0004\u007f\u0017\u0001\u0007\u00111\n\u0005\b\u0003_Z\u0001\u0019AA9\u0003\u0019\t'm\u001d+pYB\u0019Q)a\u001d\n\u0007\u0005UdI\u0001\u0004E_V\u0014G.\u001a\u000b\b\t\u0006e\u00141PA?\u0011\u0019\tI\u0007\u0004a\u0001\u0019\"1a\u0010\u0004a\u0001\u0003#Bq!a\u001c\r\u0001\u0004\t\t(\u0001\u0007bgN,'\u000f^\"bG\",G\rF\u0003E\u0003\u0007\u000b\t\nC\u0004\u0002\u00066\u0001\r!a\"\u0002\u000bE,XM]=1\t\u0005%\u0015Q\u0012\t\u0005{A\fY\tE\u0002t\u0003\u001b#1\"a$\u0002\u0004\u0006\u0005\t\u0011!B\u0001m\n\u0019q\fJ\u0019\t\u0013\u0005MU\u0002%AA\u0002\u0005U\u0015a\u00048v[\u000e\u000b7\r[3e)\u0006\u0014G.Z:\u0011\u0007\u0015\u000b9*C\u0002\u0002\u001a\u001a\u00131!\u00138u\u0003Y\t7o]3si\u000e\u000b7\r[3eI\u0011,g-Y;mi\u0012\u0012TCAAPU\u0011\t)*!),\u0005\u0005\r\u0006\u0003BAS\u0003_k!!a*\u000b\t\u0005%\u00161V\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!,G\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003c\u000b9KA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$r\u0001RA[\u0003\u0003\f)\rC\u0004\u0002\u0006>\u0001\r!a.1\t\u0005e\u0016Q\u0018\t\u0005{A\fY\fE\u0002t\u0003{#1\"a0\u00026\u0006\u0005\t\u0011!B\u0001m\n\u0019q\f\n\u001a\t\r\u0005\rw\u00021\u0001Y\u0003)\u0019\u0017m\u00195fI:\u000bW.\u001a\u0005\b\u0003\u000f|\u0001\u0019AAe\u00031\u0019Ho\u001c:bO\u0016dUM^3m!\u0011\tY-!5\u000e\u0005\u00055'bAAhM\u000591\u000f^8sC\u001e,\u0017\u0002BAj\u0003\u001b\u0014Ab\u0015;pe\u0006<W\rT3wK2\fq#Y:tKJ$X)\u001c9us6K7o]5oO&s\u0007/\u001e;\u0015\u0007\u0011\u000bI\u000eC\u0004\u0002\u0006B\u0001\r!a71\t\u0005u\u0017\u0011\u001d\t\u0005{A\fy\u000eE\u0002t\u0003C$1\"a9\u0002Z\u0006\u0005\t\u0011!B\u0001m\n\u0019q\fJ\u001a\u0002\u0013E+XM]=UKN$\bCA\u001f\u0013'\u001d\u0011\u00121^Ay\u0003{\u00042!RAw\u0013\r\tyO\u0012\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005M\u0018\u0011`\u0007\u0003\u0003kT1!a>+\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0003\u0002|\u0006U(AC!tg\u0016\u0014H/[8ogB!\u0011q B\u0005\u001b\t\u0011\tA\u0003\u0003\u0003\u0004\t\u0015\u0011AA5p\u0015\t\u00119!\u0001\u0003kCZ\f\u0017\u0002\u0002B\u0006\u0005\u0003\u0011AbU3sS\u0006d\u0017N_1cY\u0016$\"!a:\u0015\u000f\u0011\u0013\tBa\u0005\u0003\u0016!)1\n\u0006a\u0001\u0019\"1a\u0010\u0006a\u0001\u0003\u0017B\u0011Ba\u0006\u0015!\u0003\u0005\rA!\u0007\u0002\u0015\rDWmY6U_J#E\tE\u0002F\u00057I1A!\bG\u0005\u001d\u0011un\u001c7fC:\fQc\u00195fG.\fen]<fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0003$)\"!\u0011DAQ\u0003q9W\r^#se>\u0014X*Z:tC\u001e,\u0017J\\\"iK\u000e\\\u0017I\\:xKJ$\u0002B!\u000b\u00030\tE\"1\u0007\t\u0005\u000b\n-\u0002,C\u0002\u0003.\u0019\u0013aa\u00149uS>t\u0007\"B&\u0017\u0001\u0004a\u0005B\u0002@\u0017\u0001\u0004\tY\u0005C\u0005\u0003\u0018Y\u0001\n\u00111\u0001\u0003\u001a\u00051s-\u001a;FeJ|'/T3tg\u0006<W-\u00138DQ\u0016\u001c7.\u00118to\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014X\r]1sK\u0006s7o^3s)\u0019\tYEa\u000f\u0003@!9!Q\b\rA\u0002\u0005-\u0013AB1og^,'\u000fC\u0004\u0003Ba\u0001\rA!\u0007\u0002\u0011%\u001c8k\u001c:uK\u0012\f!\u0002\u001d:fa\u0006\u0014XMU8x)\u0011\t\tFa\u0012\t\u000f\t%\u0013\u00041\u0001\u0002R\u0005\u0019!o\\<\u0002\u0011\u001d,g.\u0012:s_J$r\u0001\u0017B(\u0005#\u0012)\u0006\u0003\u0004\u007f5\u0001\u0007\u00111\n\u0005\b\u0005'R\u0002\u0019AA&\u0003-\u0019\b/\u0019:l\u0003:\u001cx/\u001a:\t\u0013\t\u0005#\u0004%AA\u0002\te\u0011AE4f]\u0016\u0013(o\u001c:%I\u00164\u0017-\u001e7uIM\nA\"\u001b8dYV$Wm\u001d*poN$bA!\u000b\u0003^\t\u0005\u0004b\u0002B09\u0001\u0007\u00111J\u0001\rKb\u0004Xm\u0019;fIJ{wo\u001d\u0005\b\u0005'b\u0002\u0019AA&\u0003\u001d\u0019w.\u001c9be\u0016$bA!\u0007\u0003h\t-\u0004B\u0002B5;\u0001\u0007!0\u0001\u0003pE*\f\u0004B\u0002B7;\u0001\u0007!0\u0001\u0003pE*\u0014\u0014\u0001C:b[\u0016\u0014vn^:\u0015\u0011\t%\"1\u000fB;\u0005oBaA \u0010A\u0002\u0005-\u0003b\u0002B*=\u0001\u0007\u00111\n\u0005\n\u0005\u0003r\u0002\u0013!a\u0001\u00053\t!c]1nKJ{wo\u001d\u0013eK\u001a\fW\u000f\u001c;%gQ9AI! \u0003\u0002\n\r\u0005b\u0002B@A\u0001\u0007\u0011\u0011K\u0001\rC\u000e$X/\u00197B]N<XM\u001d\u0005\u0007}\u0002\u0002\r!!\u0015\t\u000f\u0005=\u0004\u00051\u0001\u0002rQ)AIa\"\u0003\n\")1*\ta\u0001\u0019\"1a0\ta\u0001\u0005\u0017\u0003bA!$\u0003\u0014\u0006ESB\u0001BH\u0015\u0011\u0011\tJ!\u0002\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005+\u0013yI\u0001\u0003MSN$\u0018\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001BN!\u0011\u0011iJa)\u000e\u0005\t}%\u0002\u0002BQ\u0005\u000b\tA\u0001\\1oO&!!Q\u0015BP\u0005\u0019y%M[3di\u0002")
public abstract class QueryTest
extends SparkFunSuite
implements PlanTest {
    private String sparkHome;
    private volatile boolean bitmap$0;

    public static boolean sameRows$default$3() {
        return QueryTest$.MODULE$.sameRows$default$3();
    }

    public static Option<String> sameRows(Seq<Row> expectedAnswer, Seq<Row> sparkAnswer, boolean isSorted) {
        return QueryTest$.MODULE$.sameRows(expectedAnswer, sparkAnswer, isSorted);
    }

    public static boolean compare(Object obj1, Object obj2) {
        return QueryTest$.MODULE$.compare(obj1, obj2);
    }

    public static Option<String> includesRows(Seq<Row> expectedRows, Seq<Row> sparkAnswer) {
        return QueryTest$.MODULE$.includesRows(expectedRows, sparkAnswer);
    }

    public static Row prepareRow(Row row) {
        return QueryTest$.MODULE$.prepareRow(row);
    }

    public static Seq<Row> prepareAnswer(Seq<Row> answer, boolean isSorted) {
        return QueryTest$.MODULE$.prepareAnswer(answer, isSorted);
    }

    public static boolean getErrorMessageInCheckAnswer$default$3() {
        return QueryTest$.MODULE$.getErrorMessageInCheckAnswer$default$3();
    }

    public static Option<String> getErrorMessageInCheckAnswer(Dataset<Row> df, Seq<Row> expectedAnswer, boolean checkToRDD) {
        return QueryTest$.MODULE$.getErrorMessageInCheckAnswer(df, expectedAnswer, checkToRDD);
    }

    public static boolean checkAnswer$default$3() {
        return QueryTest$.MODULE$.checkAnswer$default$3();
    }

    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$((PlanTestBase)this, (LogicalPlan)plan1, (LogicalPlan)plan2, (boolean)checkAnalysis);
    }

    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$((PlanTestBase)this);
    }

    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$((PlanTestBase)this, (Expression)e1, (Expression)e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private String sparkHome$lzycompute() {
        QueryTest queryTest = this;
        synchronized (queryTest) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    public abstract SparkSession spark();

    public void checkKeywordsExist(Dataset<Row> df, Seq<String> keywords) {
        String outputs = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])df.collect()), (Function1 & Serializable)x$1 -> x$1.mkString(), ClassTag$.MODULE$.apply(String.class))).mkString();
        keywords.foreach((Function1 & Serializable)key -> {
            String $org_scalatest_assert_macro_left = outputs;
            String $org_scalatest_assert_macro_right = key;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(38).append("Failed for ").append(df).append(" (").append((String)key).append(" doesn't exist in result)").toString(), Prettifier$.MODULE$.default(), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        });
    }

    public void checkKeywordsNotExist(Dataset<Row> df, Seq<String> keywords) {
        String outputs = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])df.collect()), (Function1 & Serializable)x$2 -> x$2.mkString(), ClassTag$.MODULE$.apply(String.class))).mkString();
        keywords.foreach((Function1 & Serializable)key -> {
            String $org_scalatest_assert_macro_left = outputs;
            String $org_scalatest_assert_macro_right = key;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(36).append("Failed for ").append(df).append(" (").append((String)key).append(" existed in the result)").toString(), Prettifier$.MODULE$.default(), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        });
    }

    public <T> void checkDataset(Function0<Dataset<T>> ds, Seq<T> expectedAnswer) {
        Object result = this.getResult(ds);
        if (!QueryTest$.MODULE$.compare(ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.genericArrayOps(result)), expectedAnswer)) {
            throw this.fail(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(128).append("\n           |Decoded objects do not match expected objects:\n           |expected: ").append(expectedAnswer).append("\n           |actual:   ").append(ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.genericArrayOps(result))).append("\n           |").append(((Dataset)ds.apply()).exprEnc().deserializer().treeString()).append("\n         ").toString())), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        }
    }

    public <T> void checkDatasetUnorderly(Function0<Dataset<T>> ds, Seq<T> expectedAnswer, Ordering<T> evidence$1) {
        Object result = this.getResult(ds);
        if (!QueryTest$.MODULE$.compare(ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.genericArrayOps(result)).sorted(evidence$1), expectedAnswer.sorted(evidence$1))) {
            throw this.fail(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(128).append("\n           |Decoded objects do not match expected objects:\n           |expected: ").append(expectedAnswer).append("\n           |actual:   ").append(ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.genericArrayOps(result))).append("\n           |").append(((Dataset)ds.apply()).exprEnc().deserializer().treeString()).append("\n         ").toString())), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        }
    }

    private <T> Object getResult(Function0<Dataset<T>> ds) {
        Object object;
        Dataset dataset;
        try {
            dataset = (Dataset)ds.apply();
        }
        catch (ExtendedAnalysisException ae) {
            if (ae.plan().isDefined()) {
                throw this.fail(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(107).append("\n               |Failed to analyze query: ").append((Object)ae).append("\n               |").append(ae.plan().get()).append("\n               |\n               |").append(package$.MODULE$.stackTraceToString((Throwable)ae)).append("\n             ").toString())), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            }
            throw ae;
        }
        Dataset analyzedDS = dataset;
        this.assertEmptyMissingInput(analyzedDS);
        try {
            object = ((Dataset)ds.apply()).collect();
        }
        catch (Exception e) {
            throw this.fail(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(111).append("\n             |Exception collecting dataset as objects\n             |").append(((Dataset)ds.apply()).exprEnc()).append("\n             |").append(((Dataset)ds.apply()).exprEnc().deserializer().treeString()).append("\n             |").append(((Dataset)ds.apply()).queryExecution()).append("\n           ").toString())), e, new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        }
        return object;
    }

    public void checkAnswer(Function0<Dataset<Row>> df, Seq<Row> expectedAnswer) {
        Dataset dataset;
        try {
            dataset = (Dataset)df.apply();
        }
        catch (ExtendedAnalysisException ae) {
            if (ae.plan().isDefined()) {
                throw this.fail(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(110).append("\n               |Failed to analyze query: ").append((Object)ae).append("\n               |").append(ae.plan().get()).append("\n               |\n               |").append(package$.MODULE$.stackTraceToString((Throwable)ae)).append("\n               |").toString())), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            }
            throw ae;
        }
        Dataset analyzedDF = dataset;
        this.assertEmptyMissingInput(analyzedDF);
        QueryTest$.MODULE$.checkAnswer((Dataset<Row>)analyzedDF, expectedAnswer, QueryTest$.MODULE$.checkAnswer$default$3());
    }

    public void checkAnswer(Function0<Dataset<Row>> df, Row expectedAnswer) {
        this.checkAnswer(df, (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{expectedAnswer}))));
    }

    public void checkAnswer(Function0<Dataset<Row>> df, Dataset<Row> expectedAnswer) {
        this.checkAnswer(df, (Seq<Row>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(expectedAnswer.collect()));
    }

    public void checkAggregatesWithTol(Dataset<Row> dataFrame, Seq<Row> expectedAnswer, double absTol) {
        Row[] actualAnswer = (Row[])dataFrame.collect();
        Predef$.MODULE$.require(actualAnswer.length == expectedAnswer.length(), (Function0 & Serializable)() -> new StringBuilder(41).append("actual num rows ").append(actualAnswer.length).append(" != expected num of rows ").append(expectedAnswer.length()).toString());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])actualAnswer), expectedAnswer)), (Function1 & Serializable)x0$1 -> {
            QueryTest.$anonfun$checkAggregatesWithTol$2(absTol, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void checkAggregatesWithTol(Dataset<Row> dataFrame, Row expectedAnswer, double absTol) {
        this.checkAggregatesWithTol(dataFrame, (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{expectedAnswer}))), absTol);
    }

    public void assertCached(Dataset<?> query, int numCachedTables) {
        Seq cachedData;
        LogicalPlan planWithCaching = query.queryExecution().withCachedData();
        Seq $org_scalatest_assert_macro_left = cachedData = planWithCaching.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                InMemoryRelation inMemoryRelation;
                A1 A1 = x1;
                Object object = A1 instanceof InMemoryRelation ? (inMemoryRelation = (InMemoryRelation)A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof InMemoryRelation;
                return bl;
            }
        });
        int $org_scalatest_assert_macro_right = numCachedTables;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(0).append(new StringBuilder(49).append("Expected query to contain ").append(numCachedTables).append(", but it actually had ").append(cachedData.size()).append("\n").toString()).append(planWithCaching).toString(), Prettifier$.MODULE$.default(), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
    }

    public void assertCached(Dataset<?> query, String cachedName, StorageLevel storageLevel) {
        LogicalPlan planWithCaching = query.queryExecution().withCachedData();
        boolean matched = planWithCaching.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)QueryTest.$anonfun$assertCached$1(cachedName, storageLevel, x0$1)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(matched, "matched", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(0).append(new StringBuilder(47).append("Expected query plan to hit cache ").append(cachedName).append(" with storage ").toString()).append(new StringBuilder(23).append("level ").append(storageLevel).append(", but it doesn't.").toString()).toString(), Prettifier$.MODULE$.default(), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
    }

    public int assertCached$default$2() {
        return 1;
    }

    public void assertEmptyMissingInput(Dataset<?> query) {
        AttributeSet $org_scalatest_assert_macro_left = query.queryExecution().analyzed().missingInput();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(46).append("The analyzed logical plan has missing inputs:\n").append(query.queryExecution().analyzed()).toString(), Prettifier$.MODULE$.default(), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
        AttributeSet $org_scalatest_assert_macro_left2 = query.queryExecution().optimizedPlan().missingInput();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(47).append("The optimized logical plan has missing inputs:\n").append(query.queryExecution().optimizedPlan()).toString(), Prettifier$.MODULE$.default(), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
        AttributeSet $org_scalatest_assert_macro_left3 = query.queryExecution().executedPlan().missingInput();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)new StringBuilder(38).append("The physical plan has missing inputs:\n").append(query.queryExecution().executedPlan()).toString(), Prettifier$.MODULE$.default(), new Position("QueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
    }

    public static final /* synthetic */ void $anonfun$checkAggregatesWithTol$2(double absTol$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Row actualRow = (Row)tuple2._1();
        Row expectedRow = (Row)tuple2._2();
        QueryTest$.MODULE$.checkAggregatesWithTol(actualRow, expectedRow, absTol$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$assertCached$1(String cachedName$1, StorageLevel storageLevel$1, LogicalPlan x0$1) {
        LogicalPlan logicalPlan = x0$1;
        if (!(logicalPlan instanceof InMemoryRelation)) return false;
        InMemoryRelation inMemoryRelation = (InMemoryRelation)logicalPlan;
        CachedRDDBuilder cacheBuilder = inMemoryRelation.cacheBuilder();
        String string = cachedName$1;
        Object object = cacheBuilder.tableName().get();
        if (string == null) {
            if (object != null) {
                return false;
            }
        } else if (!string.equals(object)) return false;
        StorageLevel storageLevel = storageLevel$1;
        StorageLevel storageLevel2 = cacheBuilder.storageLevel();
        if (storageLevel == null) {
            if (storageLevel2 == null) return true;
            return false;
        } else {
            if (!storageLevel.equals(storageLevel2)) return false;
            return true;
        }
    }

    public QueryTest() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$((SQLHelper)this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$((PlanTestBase)this);
    }
}

