/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.connector.AlterTableTests;
import org.apache.spark.sql.connector.InMemoryTableSessionCatalog;
import org.apache.spark.sql.connector.InMemoryTableSessionCatalog$;
import org.apache.spark.sql.connector.InsertIntoTests;
import org.apache.spark.sql.connector.SessionCatalogTest;
import org.apache.spark.sql.connector.TestV2SessionCatalogBase$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.InMemoryTable;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005-4Aa\u0002\u0005\u0001'!)q\u0005\u0001C\u0001Q!9!\u0006\u0001b\u0001\n#Z\u0003B\u0002\u001b\u0001A\u0003%A\u0006C\u00036\u0001\u0011Ec\u0007C\u0003a\u0001\u0011E\u0013\rC\u0003f\u0001\u0011\u0005cM\u0001\u0012ECR\f7k\\;sG\u00164&gU)M'\u0016\u001c8/[8o\u0007\u0006$\u0018\r\\8h'VLG/\u001a\u0006\u0003\u0013)\t\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0005-a\u0011aA:rY*\u0011QBD\u0001\u0006gB\f'o\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001!\u0002d\u0007\t\u0003+Yi\u0011\u0001C\u0005\u0003/!\u0011q\"\u00138tKJ$\u0018J\u001c;p)\u0016\u001cHo\u001d\t\u0003+eI!A\u0007\u0005\u0003\u001f\u0005cG/\u001a:UC\ndW\rV3tiN\u0004B!\u0006\u000f\u001fI%\u0011Q\u0004\u0003\u0002\u0013'\u0016\u001c8/[8o\u0007\u0006$\u0018\r\\8h)\u0016\u001cH\u000f\u0005\u0002 E5\t\u0001E\u0003\u0002\"\u0011\u000591-\u0019;bY><\u0017BA\u0012!\u00055Ie.T3n_JLH+\u00192mKB\u0011Q#J\u0005\u0003M!\u00111$\u00138NK6|'/\u001f+bE2,7+Z:tS>t7)\u0019;bY><\u0017A\u0002\u001fj]&$h\bF\u0001*!\t)\u0002!A\ndCR\fGn\\4B]\u0012t\u0015-\\3ta\u0006\u001cW-F\u0001-!\ti#'D\u0001/\u0015\ty\u0003'\u0001\u0003mC:<'\"A\u0019\u0002\t)\fg/Y\u0005\u0003g9\u0012aa\u0015;sS:<\u0017\u0001F2bi\u0006dwnZ!oI:\u000bW.Z:qC\u000e,\u0007%\u0001\u0005e_&s7/\u001a:u)\u00119T(\u0013.\u0011\u0005aZT\"A\u001d\u000b\u0003i\nQa]2bY\u0006L!\u0001P\u001d\u0003\tUs\u0017\u000e\u001e\u0005\u0006}\u0011\u0001\raP\u0001\ni\u0006\u0014G.\u001a(b[\u0016\u0004\"\u0001Q$\u000f\u0005\u0005+\u0005C\u0001\":\u001b\u0005\u0019%B\u0001#\u0013\u0003\u0019a$o\\8u}%\u0011a)O\u0001\u0007!J,G-\u001a4\n\u0005MB%B\u0001$:\u0011\u0015QE\u00011\u0001L\u0003\u0019Ign]3siB\u0011Aj\u0016\b\u0003\u001bVs!A\u0014+\u000f\u0005=\u001bfB\u0001)S\u001d\t\u0011\u0015+C\u0001\u0012\u0013\ty\u0001#\u0003\u0002\u000e\u001d%\u00111\u0002D\u0005\u0003-*\tq\u0001]1dW\u0006<W-\u0003\u0002Y3\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003-*Aqa\u0017\u0003\u0011\u0002\u0003\u0007A,\u0001\u0003n_\u0012,\u0007CA/_\u001b\u0005Q\u0011BA0\u000b\u0005!\u0019\u0016M^3N_\u0012,\u0017a\u0003<fe&4\u0017\u0010V1cY\u0016$2a\u000e2d\u0011\u0015qT\u00011\u0001@\u0011\u0015!W\u00011\u0001L\u0003!)\u0007\u0010]3di\u0016$\u0017\u0001E4fiR\u000b'\r\\3NKR\fG-\u0019;b)\t9'\u000e\u0005\u0002 Q&\u0011\u0011\u000e\t\u0002\u0006)\u0006\u0014G.\u001a\u0005\u0006}\u0019\u0001\ra\u0010")
public class DataSourceV2SQLSessionCatalogSuite
extends InsertIntoTests
implements AlterTableTests,
SessionCatalogTest<InMemoryTable, InMemoryTableSessionCatalog> {
    private final String catalogAndNamespace;
    private String v2Format;
    private String catalogClassName;

    @Override
    public /* synthetic */ void org$apache$spark$sql$connector$SessionCatalogTest$$super$afterEach() {
        SharedSparkSessionBase.afterEach$(this);
    }

    @Override
    public CatalogPlugin catalog(String name) {
        return SessionCatalogTest.catalog$(this, name);
    }

    @Override
    public void afterEach() {
        SessionCatalogTest.afterEach$(this);
    }

    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$((QueryErrorsBase)this, (String)conf);
    }

    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$((QueryErrorsBase)this, (String)option);
    }

    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$((QueryErrorsBase)this, (Expression)e);
    }

    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$((QueryErrorsBase)this, (String)schema);
    }

    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$((QueryErrorsBase)this, (Object)v, (DataType)t);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public String v2Format() {
        return this.v2Format;
    }

    @Override
    public String catalogClassName() {
        return this.catalogClassName;
    }

    @Override
    public void org$apache$spark$sql$connector$SessionCatalogTest$_setter_$v2Format_$eq(String x$1) {
        this.v2Format = x$1;
    }

    @Override
    public void org$apache$spark$sql$connector$SessionCatalogTest$_setter_$catalogClassName_$eq(String x$1) {
        this.catalogClassName = x$1;
    }

    @Override
    public String catalogAndNamespace() {
        return this.catalogAndNamespace;
    }

    @Override
    public void doInsert(String tableName, Dataset<Row> insert, SaveMode mode) {
        String tmpView = "tmp_view";
        this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tmpView}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            insert.createOrReplaceTempView(tmpView);
            SaveMode saveMode = mode;
            SaveMode saveMode2 = SaveMode.Overwrite;
            String overwrite = !(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null) ? "OVERWRITE" : "INTO";
            this.sql().apply((Object)new StringBuilder(29).append("INSERT ").append(overwrite).append(" TABLE ").append(tableName).append(" SELECT * FROM ").append(tmpView).toString());
        });
    }

    @Override
    public void verifyTable(String tableName, Dataset<Row> expected) {
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().table(tableName), expected);
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(tableName).toString()), expected);
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(22).append("SELECT * FROM default.").append(tableName).toString()), expected);
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(6).append("TABLE ").append(tableName).toString()), expected);
    }

    @Override
    public Table getTableMetadata(String tableName) {
        CatalogPlugin v2Catalog = this.spark().sessionState().catalogManager().currentCatalog();
        Seq nameParts = this.spark().sessionState().sqlParser().parseMultipartIdentifier(tableName);
        return ((TableCatalog)v2Catalog).loadTable(Identifier.of((String[])((String[])((IterableOnceOps)nameParts.init()).toArray(ClassTag$.MODULE$.apply(String.class))), (String)((String)nameParts.last())));
    }

    private static final Identifier idResolver$1(Identifier id) {
        return Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)id.name());
    }

    public DataSourceV2SQLSessionCatalogSuite() {
        super(true, true);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$((QueryErrorsBase)this);
        AlterTableTests.$init$(this);
        SessionCatalogTest.$init$(this);
        this.catalogAndNamespace = "";
        this.test("SPARK-30697: catalog.isView doesn't throw an error for specialized identifiers", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t1 = "tbl";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(45).append("CREATE TABLE ").append(t1).append(" (id bigint, data string) USING ").append(this.v2Format()).toString());
                InMemoryTableSessionCatalog$.MODULE$.withCustomIdentifierResolver((Function1<Identifier, Identifier>)(Function1 & Serializable)id -> DataSourceV2SQLSessionCatalogSuite.idResolver$1(id), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.sql().apply((Object)new StringBuilder(23).append("DESCRIBE TABLE ignored.").append(t1).toString()));
            });
        }, new Position("DataSourceV2SQLSessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("SPARK-33651: allow CREATE EXTERNAL TABLE without LOCATION", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            String prop = new StringBuilder(5).append(TestV2SessionCatalogBase$.MODULE$.SIMULATE_ALLOW_EXTERNAL_PROPERTY()).append("=true").toString();
            this.sql().apply((Object)new StringBuilder(54).append("CREATE EXTERNAL TABLE t (i INT) USING ").append(this.v2Format()).append(" TBLPROPERTIES(").append(prop).append(")").toString());
        }), new Position("DataSourceV2SQLSessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        this.test("SPARK-49152: partition columns should be put at the end", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE t (c1 INT, c2 INT) USING json PARTITIONED BY (c1)");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.getTableMetadata("default.t").columns()), (Function1 & Serializable)x$1 -> x$1.name(), ClassTag$.MODULE$.apply(String.class)));
            Seq $org_scalatest_assert_macro_right = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c2", "c1"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        }), new Position("DataSourceV2SQLSessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        Statics.releaseFence();
    }
}

