/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import org.apache.spark.sql.catalyst.types.PhysicalArrayType;
import org.apache.spark.sql.catalyst.types.PhysicalBinaryType$;
import org.apache.spark.sql.catalyst.types.PhysicalBooleanType$;
import org.apache.spark.sql.catalyst.types.PhysicalByteType$;
import org.apache.spark.sql.catalyst.types.PhysicalCalendarIntervalType$;
import org.apache.spark.sql.catalyst.types.PhysicalDataType;
import org.apache.spark.sql.catalyst.types.PhysicalDecimalType;
import org.apache.spark.sql.catalyst.types.PhysicalDoubleType$;
import org.apache.spark.sql.catalyst.types.PhysicalFloatType$;
import org.apache.spark.sql.catalyst.types.PhysicalIntegerType$;
import org.apache.spark.sql.catalyst.types.PhysicalLongType$;
import org.apache.spark.sql.catalyst.types.PhysicalMapType;
import org.apache.spark.sql.catalyst.types.PhysicalNullType$;
import org.apache.spark.sql.catalyst.types.PhysicalShortType$;
import org.apache.spark.sql.catalyst.types.PhysicalStringType$;
import org.apache.spark.sql.catalyst.types.PhysicalStructType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public final class ColumnarDataTypeUtils$ {
    public static final ColumnarDataTypeUtils$ MODULE$ = new ColumnarDataTypeUtils$();

    public DataType toLogicalDataType(PhysicalDataType dataType) {
        NullType$ nullType$;
        PhysicalDataType physicalDataType = dataType;
        if (PhysicalNullType$.MODULE$.equals(physicalDataType)) {
            nullType$ = NullType$.MODULE$;
        } else if (PhysicalBooleanType$.MODULE$.equals(physicalDataType)) {
            nullType$ = BooleanType$.MODULE$;
        } else if (PhysicalIntegerType$.MODULE$.equals(physicalDataType)) {
            nullType$ = IntegerType$.MODULE$;
        } else if (PhysicalLongType$.MODULE$.equals(physicalDataType)) {
            nullType$ = LongType$.MODULE$;
        } else if (PhysicalByteType$.MODULE$.equals(physicalDataType)) {
            nullType$ = ByteType$.MODULE$;
        } else if (PhysicalShortType$.MODULE$.equals(physicalDataType)) {
            nullType$ = ShortType$.MODULE$;
        } else if (PhysicalBinaryType$.MODULE$.equals(physicalDataType)) {
            nullType$ = BinaryType$.MODULE$;
        } else if (PhysicalCalendarIntervalType$.MODULE$.equals(physicalDataType)) {
            nullType$ = CalendarIntervalType$.MODULE$;
        } else if (PhysicalFloatType$.MODULE$.equals(physicalDataType)) {
            nullType$ = FloatType$.MODULE$;
        } else if (PhysicalDoubleType$.MODULE$.equals(physicalDataType)) {
            nullType$ = DoubleType$.MODULE$;
        } else if (PhysicalStringType$.MODULE$.equals(physicalDataType)) {
            nullType$ = StringType$.MODULE$;
        } else if (physicalDataType instanceof PhysicalDecimalType) {
            PhysicalDecimalType physicalDecimalType = (PhysicalDecimalType)physicalDataType;
            int precision = physicalDecimalType.precision();
            int scale = physicalDecimalType.scale();
            nullType$ = new DecimalType(precision, scale);
        } else if (physicalDataType instanceof PhysicalArrayType) {
            PhysicalArrayType physicalArrayType = (PhysicalArrayType)physicalDataType;
            DataType elementType = physicalArrayType.elementType();
            boolean containsNull = physicalArrayType.containsNull();
            nullType$ = new ArrayType(elementType, containsNull);
        } else if (physicalDataType instanceof PhysicalStructType) {
            PhysicalStructType physicalStructType = (PhysicalStructType)physicalDataType;
            StructField[] fields = physicalStructType.fields();
            nullType$ = new StructType(fields);
        } else if (physicalDataType instanceof PhysicalMapType) {
            PhysicalMapType physicalMapType = (PhysicalMapType)physicalDataType;
            DataType keyType = physicalMapType.keyType();
            DataType valueType = physicalMapType.valueType();
            boolean valueContainsNull = physicalMapType.valueContainsNull();
            nullType$ = new MapType(keyType, valueType, valueContainsNull);
        } else {
            throw new UnsupportedOperationException();
        }
        return nullType$;
    }

    private ColumnarDataTypeUtils$() {
    }
}

