/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.json;

import java.io.File;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class JsonBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static final JsonBenchmark$ MODULE$ = new JsonBenchmark$();
    private static SparkSession spark;
    private static String sparkHome;
    private static volatile boolean bitmap$0;

    static {
        SQLHelper.$init$((SQLHelper)MODULE$);
        SqlBasedBenchmark.$init$(MODULE$);
    }

    @Override
    public SparkSession getSparkSession() {
        return SqlBasedBenchmark.getSparkSession$(this);
    }

    @Override
    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$(this, name, cardinality, f);
    }

    @Override
    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$(this, ds);
    }

    @Override
    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$(this, benchmark);
    }

    @Override
    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$(this, path, rowsNum, numCols);
    }

    @Override
    public void afterAll() {
        SqlBasedBenchmark.afterAll$(this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    @Override
    public SparkSession spark() {
        return spark;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        spark = x$1;
    }

    private String sparkHome$lzycompute() {
        JsonBenchmark$ jsonBenchmark$ = this;
        synchronized (jsonBenchmark$) {
            if (!bitmap$0) {
                sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                bitmap$0 = true;
            }
        }
        return sparkHome;
    }

    public String sparkHome() {
        return !bitmap$0 ? this.sparkHome$lzycompute() : sparkHome;
    }

    public void schemaInferring(int rowsNum, int numIters) {
        String x$1 = "JSON schema inferring";
        long x$2 = rowsNum;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("JSON schema inferring", x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
            JsonBenchmark$.$anonfun$schemaInferring$1(benchmark, rowsNum, numIters, path);
            return BoxedUnit.UNIT;
        });
    }

    public StructType writeShortColumn(String path, int rowsNum) {
        this.spark().implicits().rddToDatasetHolder(this.spark().sparkContext().range(0L, (long)rowsNum, 1L, this.spark().sparkContext().range$default$4()).map((Function1 & Serializable)x$4 -> JsonBenchmark$.$anonfun$writeShortColumn$1(BoxesRunTime.unboxToLong((Object)x$4)), ClassTag$.MODULE$.apply(String.class)), this.spark().implicits().newStringEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fieldA"})).write().json(path);
        return new StructType().add("fieldA", (DataType)StringType$.MODULE$);
    }

    public void countShortColumn(int rowsNum, int numIters) {
        String x$1 = "count a short column";
        long x$2 = rowsNum;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("count a short column", x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
            JsonBenchmark$.$anonfun$countShortColumn$1(benchmark, rowsNum, numIters, path);
            return BoxedUnit.UNIT;
        });
    }

    public StructType writeWideColumn(String path, int rowsNum) {
        this.spark().implicits().rddToDatasetHolder(this.spark().sparkContext().range(0L, (long)rowsNum, 1L, this.spark().sparkContext().range$default$4()).map((Function1 & Serializable)i -> JsonBenchmark$.$anonfun$writeWideColumn$1(BoxesRunTime.unboxToLong((Object)i)), ClassTag$.MODULE$.apply(String.class)), this.spark().implicits().newStringEncoder()).toDF().write().text(path);
        return new StructType().add("a", (DataType)StringType$.MODULE$).add("b", (DataType)LongType$.MODULE$).add("c", (DataType)StringType$.MODULE$).add("d", (DataType)LongType$.MODULE$).add("e", (DataType)StringType$.MODULE$).add("f", (DataType)LongType$.MODULE$).add("x", (DataType)StringType$.MODULE$).add("y", (DataType)LongType$.MODULE$).add("z", (DataType)StringType$.MODULE$);
    }

    public void countWideColumn(int rowsNum, int numIters) {
        String x$1 = "count a wide column";
        long x$2 = rowsNum;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("count a wide column", x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
            JsonBenchmark$.$anonfun$countWideColumn$1(benchmark, rowsNum, numIters, path);
            return BoxedUnit.UNIT;
        });
    }

    public void countWideRow(int rowsNum, int numIters) {
        String x$1 = "select wide row";
        long x$2 = rowsNum;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("select wide row", x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
            JsonBenchmark$.$anonfun$countWideRow$1(benchmark, rowsNum, numIters, path);
            return BoxedUnit.UNIT;
        });
    }

    public void selectSubsetOfColumns(int rowsNum, int numIters) {
        int colsNum = 10;
        String x$1 = new StringBuilder(27).append("Select a subset of ").append(colsNum).append(" columns").toString();
        long x$2 = rowsNum;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
            JsonBenchmark$.$anonfun$selectSubsetOfColumns$1(benchmark, colsNum, rowsNum, numIters, path);
            return BoxedUnit.UNIT;
        });
    }

    public void jsonParserCreation(int rowsNum, int numIters) {
        String x$1 = "creation of JSON parser per line";
        long x$2 = rowsNum;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("creation of JSON parser per line", x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
            JsonBenchmark$.$anonfun$jsonParserCreation$1(benchmark, rowsNum, numIters, path);
            return BoxedUnit.UNIT;
        });
    }

    public void jsonFunctions(int rows, int iters) {
        String x$1 = "JSON functions";
        long x$2 = rows;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("JSON functions", x$2, x$4, x$5, x$6, x$7, x$3);
        this.prepareDataInfo(benchmark);
        Dataset in = this.spark().range(0L, (long)rows, 1L, 1).map((Function1 & Serializable)x$17 -> "{\"a\":1}", this.spark().implicits().newStringEncoder());
        benchmark.addCase("Text read", iters, (Function1)(JFunction1.mcVI.sp & Serializable)x$18 -> MODULE$.DatasetToBenchmark(in).noop());
        benchmark.addCase("from_json", iters, (Function1)(JFunction1.mcVI.sp & Serializable)x$19 -> {
            StructType schema = new StructType().add("a", (DataType)IntegerType$.MODULE$);
            Dataset from_json_ds = in.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.from_json((Column)MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$), schema)}));
            MODULE$.DatasetToBenchmark(from_json_ds).noop();
        });
        benchmark.addCase("json_tuple", iters, (Function1)(JFunction1.mcVI.sp & Serializable)x$20 -> {
            Dataset json_tuple_ds = in.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.json_tuple((Column)MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))}));
            MODULE$.DatasetToBenchmark(json_tuple_ds).noop();
        });
        benchmark.addCase("get_json_object", iters, (Function1)(JFunction1.mcVI.sp & Serializable)x$21 -> {
            Dataset get_json_object_ds = in.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.get_json_object((Column)MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$), "$.a")}));
            MODULE$.DatasetToBenchmark(get_json_object_ds).noop();
        });
        benchmark.run();
    }

    public void jsonInDS(int rows, int iters) {
        String x$1 = "Dataset of json strings";
        long x$2 = rows;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("Dataset of json strings", x$2, x$4, x$5, x$6, x$7, x$3);
        this.prepareDataInfo(benchmark);
        Dataset in = this.spark().range(0L, (long)rows, 1L, 1).map((Function1 & Serializable)x$22 -> "{\"a\":1}", this.spark().implicits().newStringEncoder());
        benchmark.addCase("Text read", iters, (Function1)(JFunction1.mcVI.sp & Serializable)x$23 -> MODULE$.DatasetToBenchmark(in).noop());
        benchmark.addCase("schema inferring", iters, (Function1)(JFunction1.mcVI.sp & Serializable)x$24 -> MODULE$.spark().read().json(in).schema());
        benchmark.addCase("parsing", iters, (Function1)(JFunction1.mcVI.sp & Serializable)x$25 -> {
            StructType schema = new StructType().add("a", (DataType)IntegerType$.MODULE$);
            Dataset ds = MODULE$.spark().read().schema(schema).json(in);
            MODULE$.DatasetToBenchmark(ds).noop();
        });
        benchmark.run();
    }

    public void jsonInFile(int rows, int iters) {
        String x$1 = "Json files in the per-line mode";
        long x$2 = rows;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("Json files in the per-line mode", x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
            JsonBenchmark$.$anonfun$jsonInFile$1(benchmark, rows, iters, path);
            return BoxedUnit.UNIT;
        });
    }

    private void datetimeBenchmark(int rowsNum, int numIters) {
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
            JsonBenchmark$.$anonfun$datetimeBenchmark$5(this, rowsNum, numIters, path);
            return BoxedUnit.UNIT;
        });
    }

    private void filtersPushdownBenchmark(int rowsNum, int numIters) {
        String x$1 = "Filters pushdown";
        long x$2 = rowsNum;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("Filters pushdown", x$2, x$4, x$5, x$6, x$7, x$3);
        int colsNum = 100;
        Seq fields = (Seq)package$.MODULE$.Seq().tabulate(colsNum, (Function1 & Serializable)i -> JsonBenchmark$.$anonfun$filtersPushdownBenchmark$1(BoxesRunTime.unboxToInt((Object)i)));
        StructField structField = new StructField("key", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructType schema = StructType$.MODULE$.apply((Seq)fields.$plus$colon((Object)structField));
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
            JsonBenchmark$.$anonfun$filtersPushdownBenchmark$3(this, rowsNum, schema, benchmark, numIters, colsNum, path);
            return BoxedUnit.UNIT;
        });
    }

    private void partialResultBenchmark(int rowsNum, int numIters) {
        String x$1 = "Partial JSON results";
        long x$2 = rowsNum;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark("Partial JSON results", x$2, x$4, x$5, x$6, x$7, x$3);
        int colsNum = 1000;
        Seq fields = (Seq)package$.MODULE$.Seq().tabulate(colsNum, (Function1 & Serializable)i -> JsonBenchmark$.$anonfun$partialResultBenchmark$1(BoxesRunTime.unboxToInt((Object)i)));
        StructType schema = StructType$.MODULE$.apply(fields);
        benchmark.addCase("parse invalid JSON", numIters, (Function1)(JFunction1.mcVI.sp & Serializable)x$55 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.JSON_ENABLE_PARTIAL_RESULTS().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.DatasetToBenchmark(MODULE$.spark().read().schema(schema).json(this.data$1(rowsNum, colsNum))).noop()));
        benchmark.run();
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        int numIters = 3;
        this.runBenchmark("Benchmark for performance of JSON parsing", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            MODULE$.schemaInferring(5000000, numIters);
            MODULE$.countShortColumn(5000000, numIters);
            MODULE$.countWideColumn(1000000, numIters);
            MODULE$.countWideRow(50000, numIters);
            MODULE$.selectSubsetOfColumns(1000000, numIters);
            MODULE$.jsonParserCreation(1000000, numIters);
            MODULE$.jsonFunctions(1000000, numIters);
            MODULE$.jsonInDS(5000000, numIters);
            MODULE$.jsonInFile(5000000, numIters);
            MODULE$.datetimeBenchmark(1000000, numIters);
            MODULE$.filtersPushdownBenchmark(100000, numIters);
            MODULE$.partialResultBenchmark(10000, numIters);
        });
    }

    public static final /* synthetic */ String $anonfun$schemaInferring$2(long x$1) {
        return "a";
    }

    public static final /* synthetic */ void $anonfun$schemaInferring$1(Benchmark benchmark$1, int rowsNum$1, int numIters$1, File path) {
        MODULE$.prepareDataInfo(benchmark$1);
        MODULE$.spark().implicits().rddToDatasetHolder(MODULE$.spark().sparkContext().range(0L, (long)rowsNum$1, 1L, MODULE$.spark().sparkContext().range$default$4()).map((Function1 & Serializable)x$1 -> JsonBenchmark$.$anonfun$schemaInferring$2(BoxesRunTime.unboxToLong((Object)x$1)), ClassTag$.MODULE$.apply(String.class)), MODULE$.spark().implicits().newStringEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fieldA"})).write().option("encoding", "UTF-8").json(path.getAbsolutePath());
        benchmark$1.addCase("No encoding", numIters$1, (Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> MODULE$.spark().read().option("inferTimestamp", false).json(path.getAbsolutePath()));
        benchmark$1.addCase("UTF-8 is set", numIters$1, (Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> MODULE$.spark().read().option("encoding", "UTF-8").option("inferTimestamp", false).json(path.getAbsolutePath()));
        benchmark$1.run();
    }

    public static final /* synthetic */ String $anonfun$writeShortColumn$1(long x$4) {
        return "a";
    }

    public static final /* synthetic */ void $anonfun$countShortColumn$1(Benchmark benchmark$2, int rowsNum$2, int numIters$2, File path) {
        MODULE$.prepareDataInfo(benchmark$2);
        StructType schema = MODULE$.writeShortColumn(path.getAbsolutePath(), rowsNum$2);
        benchmark$2.addCase("No encoding", numIters$2, (Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> MODULE$.spark().read().schema(schema).json(path.getAbsolutePath()).count());
        benchmark$2.addCase("UTF-8 is set", numIters$2, (Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> MODULE$.spark().read().option("encoding", "UTF-8").schema(schema).json(path.getAbsolutePath()).count());
        benchmark$2.run();
    }

    public static final /* synthetic */ String $anonfun$writeWideColumn$1(long i) {
        String s = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("abcdef0123456789ABCDEF"), 20);
        return new StringBuilder(57).append("{\"a\":\"").append(s).append("\",\"b\": ").append(i).append(",\"c\":\"").append(s).append("\",\"d\":").append(i).append(",\"e\":\"").append(s).append("\",\"f\":").append(i).append(",\"x\":\"").append(s).append("\",\"y\":").append(i).append(",\"z\":\"").append(s).append("\"}").toString();
    }

    public static final /* synthetic */ void $anonfun$countWideColumn$1(Benchmark benchmark$3, int rowsNum$3, int numIters$3, File path) {
        MODULE$.prepareDataInfo(benchmark$3);
        StructType schema = MODULE$.writeWideColumn(path.getAbsolutePath(), rowsNum$3);
        benchmark$3.addCase("No encoding", numIters$3, (Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> MODULE$.spark().read().schema(schema).json(path.getAbsolutePath()).count());
        benchmark$3.addCase("UTF-8 is set", numIters$3, (Function1)(JFunction1.mcVI.sp & Serializable)x$8 -> MODULE$.spark().read().option("encoding", "UTF-8").schema(schema).json(path.getAbsolutePath()).count());
        benchmark$3.run();
    }

    public static final /* synthetic */ boolean $anonfun$countWideRow$3(Row row) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$countWideRow$5(Row row) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$countWideRow$1(Benchmark benchmark$4, int rowsNum$4, int numIters$4, File path) {
        MODULE$.prepareDataInfo(benchmark$4);
        StructType schema = MODULE$.writeWideRow(path.getAbsolutePath(), rowsNum$4, 1000);
        benchmark$4.addCase("No encoding", numIters$4, (Function1)(JFunction1.mcVI.sp & Serializable)x$9 -> MODULE$.spark().read().schema(schema).json(path.getAbsolutePath()).select("*", (Seq)Nil$.MODULE$).filter((Function1 & Serializable)row -> BoxesRunTime.boxToBoolean((boolean)JsonBenchmark$.$anonfun$countWideRow$3(row))).count());
        benchmark$4.addCase("UTF-8 is set", numIters$4, (Function1)(JFunction1.mcVI.sp & Serializable)x$10 -> MODULE$.spark().read().option("encoding", "UTF-8").schema(schema).json(path.getAbsolutePath()).select("*", (Seq)Nil$.MODULE$).filter((Function1 & Serializable)row -> BoxesRunTime.boxToBoolean((boolean)JsonBenchmark$.$anonfun$countWideRow$5(row))).count());
        benchmark$4.run();
    }

    public static final /* synthetic */ StructField $anonfun$selectSubsetOfColumns$2(int i) {
        return new StructField(new StringBuilder(3).append("col").append(i).toString(), (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ Column $anonfun$selectSubsetOfColumns$3(int i) {
        return functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)i)).as(new StringBuilder(3).append("col").append(i).toString());
    }

    public static final /* synthetic */ void $anonfun$selectSubsetOfColumns$1(Benchmark benchmark$5, int colsNum$1, int rowsNum$5, int numIters$5, File path) {
        MODULE$.prepareDataInfo(benchmark$5);
        Seq fields = (Seq)package$.MODULE$.Seq().tabulate(colsNum$1, (Function1 & Serializable)i -> JsonBenchmark$.$anonfun$selectSubsetOfColumns$2(BoxesRunTime.unboxToInt((Object)i)));
        StructType schema = StructType$.MODULE$.apply(fields);
        MODULE$.spark().range((long)rowsNum$5).select((Seq)package$.MODULE$.Seq().tabulate(colsNum$1, (Function1 & Serializable)i -> JsonBenchmark$.$anonfun$selectSubsetOfColumns$3(BoxesRunTime.unboxToInt((Object)i)))).write().json(path.getAbsolutePath());
        Dataset in = MODULE$.spark().read().schema(schema).json(path.getAbsolutePath());
        benchmark$5.addCase(new StringBuilder(15).append("Select ").append(colsNum$1).append(" columns").toString(), numIters$5, (Function1)(JFunction1.mcVI.sp & Serializable)x$11 -> {
            Dataset ds = in.select("*", (Seq)Nil$.MODULE$);
            MODULE$.DatasetToBenchmark(ds).noop();
        });
        benchmark$5.addCase("Select 1 column", numIters$5, (Function1)(JFunction1.mcVI.sp & Serializable)x$12 -> {
            Dataset ds = in.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)}));
            MODULE$.DatasetToBenchmark(ds).noop();
        });
        benchmark$5.run();
    }

    public static final /* synthetic */ void $anonfun$jsonParserCreation$1(Benchmark benchmark$6, int rowsNum$6, int numIters$6, File path) {
        MODULE$.prepareDataInfo(benchmark$6);
        String shortColumnPath = new StringBuilder(6).append(path.getAbsolutePath()).append("/short").toString();
        StructType shortSchema = MODULE$.writeShortColumn(shortColumnPath, rowsNum$6);
        String wideColumnPath = new StringBuilder(5).append(path.getAbsolutePath()).append("/wide").toString();
        StructType wideSchema = MODULE$.writeWideColumn(wideColumnPath, rowsNum$6);
        benchmark$6.addCase("Short column without encoding", numIters$6, (Function1)(JFunction1.mcVI.sp & Serializable)x$13 -> {
            Dataset ds = MODULE$.spark().read().schema(shortSchema).json(shortColumnPath);
            MODULE$.DatasetToBenchmark(ds).noop();
        });
        benchmark$6.addCase("Short column with UTF-8", numIters$6, (Function1)(JFunction1.mcVI.sp & Serializable)x$14 -> {
            Dataset ds = MODULE$.spark().read().option("encoding", "UTF-8").schema(shortSchema).json(shortColumnPath);
            MODULE$.DatasetToBenchmark(ds).noop();
        });
        benchmark$6.addCase("Wide column without encoding", numIters$6, (Function1)(JFunction1.mcVI.sp & Serializable)x$15 -> {
            Dataset ds = MODULE$.spark().read().schema(wideSchema).json(wideColumnPath);
            MODULE$.DatasetToBenchmark(ds).noop();
        });
        benchmark$6.addCase("Wide column with UTF-8", numIters$6, (Function1)(JFunction1.mcVI.sp & Serializable)x$16 -> {
            Dataset ds = MODULE$.spark().read().option("encoding", "UTF-8").schema(wideSchema).json(wideColumnPath);
            MODULE$.DatasetToBenchmark(ds).noop();
        });
        benchmark$6.run();
    }

    public static final /* synthetic */ void $anonfun$jsonInFile$1(Benchmark benchmark$7, int rows$1, int iters$1, File path) {
        MODULE$.prepareDataInfo(benchmark$7);
        MODULE$.spark().implicits().rddToDatasetHolder(MODULE$.spark().sparkContext().range(0L, (long)rows$1, 1L, 1), MODULE$.spark().implicits().newLongEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).write().json(path.getAbsolutePath());
        benchmark$7.addCase("Text read", iters$1, (Function1)(JFunction1.mcVI.sp & Serializable)x$26 -> {
            Dataset ds = MODULE$.spark().read().format("text").load(path.getAbsolutePath());
            MODULE$.DatasetToBenchmark(ds).noop();
        });
        benchmark$7.addCase("Schema inferring", iters$1, (Function1)(JFunction1.mcVI.sp & Serializable)x$27 -> {
            Dataset ds = MODULE$.spark().read().option("multiLine", false).json(path.getAbsolutePath());
            ds.schema();
        });
        StructType schema = new StructType().add("a", (DataType)LongType$.MODULE$);
        benchmark$7.addCase("Parsing without charset", iters$1, (Function1)(JFunction1.mcVI.sp & Serializable)x$28 -> {
            Dataset ds = MODULE$.spark().read().schema(schema).option("multiLine", false).json(path.getAbsolutePath());
            MODULE$.DatasetToBenchmark(ds).noop();
        });
        benchmark$7.addCase("Parsing with UTF-8", iters$1, (Function1)(JFunction1.mcVI.sp & Serializable)x$29 -> {
            Dataset ds = MODULE$.spark().read().schema(schema).option("multiLine", false).option("charset", "UTF-8").json(path.getAbsolutePath());
            MODULE$.DatasetToBenchmark(ds).noop();
        });
        benchmark$7.run();
    }

    private final Dataset timestamps$1(int rowsNum$7) {
        return this.spark().range(0L, (long)rowsNum$7, 1L, 1).mapPartitions((Function1 & Serializable)iter -> iter.map((Function1 & Serializable)x$30 -> Instant.ofEpochSecond(Predef$.MODULE$.Long2long(x$30))), this.spark().implicits().newInstantEncoder()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).as("timestamp")}));
    }

    private final Dataset dates$1(int rowsNum$7) {
        return this.spark().range(0L, (long)rowsNum$7, 1L, 1).mapPartitions((Function1 & Serializable)iter -> iter.map((Function1 & Serializable)d -> LocalDate.ofEpochDay(Predef$.MODULE$.Long2long(d) % 36500L)), this.spark().implicits().newLocalDateEncoder()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).as("date")}));
    }

    private static final Dataset timestampStr$1(int rowsNum$7) {
        return MODULE$.spark().range(0L, (long)rowsNum$7, 1L, 1).mapPartitions((Function1 & Serializable)iter -> iter.map((Function1 & Serializable)i -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(new StringBuilder(37).append("{\"timestamp\":\"1970-01-01T01:02:03.").append(Predef$.MODULE$.Long2long(i) % 200L).append("Z\"}").toString()), ".0Z")), MODULE$.spark().implicits().newStringEncoder()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).as("timestamp")})).as(MODULE$.spark().implicits().newStringEncoder());
    }

    private static final Dataset dateStr$1(int rowsNum$7) {
        return MODULE$.spark().range(0L, (long)rowsNum$7, 1L, 1).mapPartitions((Function1 & Serializable)iter -> iter.map((Function1 & Serializable)i -> new StringBuilder(11).append("{\"date\":\"").append(LocalDate.ofEpochDay(Predef$.MODULE$.Long2long(i) % 1000L * 365L).toString()).append("\"}").toString()), MODULE$.spark().implicits().newStringEncoder()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).as("date")})).as(MODULE$.spark().implicits().newStringEncoder());
    }

    private static final Dataset errorTimestampStr$1(int rowsNum$7) {
        return MODULE$.spark().range(0L, (long)rowsNum$7, 1L, 1).mapPartitions((Function1 & Serializable)iter -> iter.map((Function1 & Serializable)i -> new StringBuilder(20).append("{\"timestamp\":\"data").append(Predef$.MODULE$.Long2long(i) % 200L).append("\"}").toString()), MODULE$.spark().implicits().newStringEncoder()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).as("timestamp")})).as(MODULE$.spark().implicits().newStringEncoder());
    }

    public static final /* synthetic */ void $anonfun$datetimeBenchmark$5(JsonBenchmark$ $this, int rowsNum$7, int numIters$7, File path) {
        String timestampDir = new File(path, "timestamp").getAbsolutePath();
        String dateDir = new File(path, "date").getAbsolutePath();
        String x$1 = "Write dates and timestamps";
        long x$2 = rowsNum$7;
        Option x$3 = MODULE$.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark writeBench = new Benchmark("Write dates and timestamps", x$2, x$4, x$5, x$6, x$7, x$3);
        writeBench.addCase("Create a dataset of timestamps", numIters$7, (Function1)(JFunction1.mcVI.sp & Serializable)x$31 -> MODULE$.DatasetToBenchmark($this.timestamps$1(rowsNum$7)).noop());
        writeBench.addCase("to_json(timestamp)", numIters$7, (Function1)(JFunction1.mcVI.sp & Serializable)x$32 -> MODULE$.DatasetToBenchmark($this.timestamps$1(rowsNum$7).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.to_json(functions$.MODULE$.struct((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp"}))).$((Seq)Nil$.MODULE$)})))}))).noop());
        writeBench.addCase("write timestamps to files", numIters$7, (Function1)(JFunction1.mcVI.sp & Serializable)x$33 -> $this.timestamps$1(rowsNum$7).write().option("header", true).mode("overwrite").json(timestampDir));
        writeBench.addCase("Create a dataset of dates", numIters$7, (Function1)(JFunction1.mcVI.sp & Serializable)x$34 -> MODULE$.DatasetToBenchmark($this.dates$1(rowsNum$7)).noop());
        writeBench.addCase("to_json(date)", numIters$7, (Function1)(JFunction1.mcVI.sp & Serializable)x$35 -> MODULE$.DatasetToBenchmark($this.dates$1(rowsNum$7).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.to_json(functions$.MODULE$.struct((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"date"}))).$((Seq)Nil$.MODULE$)})))}))).noop());
        writeBench.addCase("write dates to files", numIters$7, (Function1)(JFunction1.mcVI.sp & Serializable)x$36 -> $this.dates$1(rowsNum$7).write().option("header", true).mode("overwrite").json(dateDir));
        writeBench.run();
        String x$8 = "Read dates and timestamps";
        long x$9 = rowsNum$7;
        Option x$10 = MODULE$.output();
        int x$11 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$12 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$13 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$14 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark readBench = new Benchmark("Read dates and timestamps", x$9, x$11, x$12, x$13, x$14, x$10);
        StructType tsSchema = new StructType().add("timestamp", (DataType)TimestampType$.MODULE$);
        readBench.addCase("read timestamp text from files", numIters$7, (Function1)(JFunction1.mcVI.sp & Serializable)x$37 -> MODULE$.DatasetToBenchmark(MODULE$.spark().read().text(timestampDir)).noop());
        readBench.addCase("read timestamps from files", numIters$7, (Function1)(JFunction1.mcVI.sp & Serializable)x$38 -> MODULE$.DatasetToBenchmark(MODULE$.spark().read().schema(tsSchema).json(timestampDir)).noop());
        readBench.addCase("infer timestamps from files", numIters$7, (Function1)(JFunction1.mcVI.sp & Serializable)x$39 -> MODULE$.DatasetToBenchmark(MODULE$.spark().read().option("inferTimestamp", true).json(timestampDir)).noop());
        StructType dateSchema = new StructType().add("date", (DataType)DateType$.MODULE$);
        readBench.addCase("read date text from files", numIters$7, (Function1)(JFunction1.mcVI.sp & Serializable)x$40 -> MODULE$.DatasetToBenchmark(MODULE$.spark().read().text(dateDir)).noop());
        readBench.addCase("read date from files", numIters$7, (Function1)(JFunction1.mcVI.sp & Serializable)x$41 -> MODULE$.DatasetToBenchmark(MODULE$.spark().read().schema(dateSchema).json(dateDir)).noop());
        readBench.addCase("timestamp strings", numIters$7, (Function1)(JFunction1.mcVI.sp & Serializable)x$42 -> MODULE$.DatasetToBenchmark(JsonBenchmark$.timestampStr$1(rowsNum$7)).noop());
        readBench.addCase("parse timestamps from Dataset[String]", numIters$7, (Function1)(JFunction1.mcVI.sp & Serializable)x$43 -> MODULE$.DatasetToBenchmark(MODULE$.spark().read().schema(tsSchema).json(JsonBenchmark$.timestampStr$1(rowsNum$7))).noop());
        readBench.addCase("infer timestamps from Dataset[String]", numIters$7, (Function1)(JFunction1.mcVI.sp & Serializable)x$44 -> MODULE$.DatasetToBenchmark(MODULE$.spark().read().option("inferTimestamp", true).json(JsonBenchmark$.timestampStr$1(rowsNum$7))).noop());
        readBench.addCase("date strings", numIters$7, (Function1)(JFunction1.mcVI.sp & Serializable)x$45 -> MODULE$.DatasetToBenchmark(JsonBenchmark$.dateStr$1(rowsNum$7)).noop());
        readBench.addCase("parse dates from Dataset[String]", numIters$7, (Function1)(JFunction1.mcVI.sp & Serializable)x$46 -> {
            Dataset ds = MODULE$.spark().read().option("header", false).schema(dateSchema).json(JsonBenchmark$.dateStr$1(rowsNum$7));
            MODULE$.DatasetToBenchmark(ds).noop();
        });
        readBench.addCase("from_json(timestamp)", numIters$7, (Function1)(JFunction1.mcVI.sp & Serializable)x$47 -> {
            Dataset ds = JsonBenchmark$.timestampStr$1(rowsNum$7).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.from_json((Column)MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp"}))).$((Seq)Nil$.MODULE$), tsSchema, Predef$.MODULE$.Map().empty())}));
            MODULE$.DatasetToBenchmark(ds).noop();
        });
        readBench.addCase("from_json(date)", numIters$7, (Function1)(JFunction1.mcVI.sp & Serializable)x$48 -> {
            Dataset ds = JsonBenchmark$.dateStr$1(rowsNum$7).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.from_json((Column)MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"date"}))).$((Seq)Nil$.MODULE$), dateSchema, Predef$.MODULE$.Map().empty())}));
            MODULE$.DatasetToBenchmark(ds).noop();
        });
        readBench.addCase("infer error timestamps from Dataset[String] with default format", numIters$7, (Function1)(JFunction1.mcVI.sp & Serializable)x$49 -> MODULE$.DatasetToBenchmark(MODULE$.spark().read().option("inferTimestamp", true).json(JsonBenchmark$.errorTimestampStr$1(rowsNum$7))).noop());
        readBench.addCase("infer error timestamps from Dataset[String] with user-provided format", numIters$7, (Function1)(JFunction1.mcVI.sp & Serializable)x$50 -> MODULE$.DatasetToBenchmark(MODULE$.spark().read().option("inferTimestamp", true).option("timestampFormat", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").json(JsonBenchmark$.errorTimestampStr$1(rowsNum$7))).noop());
        readBench.addCase("infer error timestamps from Dataset[String] with legacy format", numIters$7, (Function1)(JFunction1.mcVI.sp & Serializable)x$51 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_TIME_PARSER_POLICY().key()), (Object)"LEGACY")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.DatasetToBenchmark(MODULE$.spark().read().option("inferTimestamp", true).json(JsonBenchmark$.errorTimestampStr$1(rowsNum$7))).noop()));
        readBench.run();
    }

    public static final /* synthetic */ StructField $anonfun$filtersPushdownBenchmark$1(int i) {
        return new StructField(new StringBuilder(3).append("col").append(i).toString(), (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ Column $anonfun$filtersPushdownBenchmark$2(int i) {
        return functions$.MODULE$.lit((Object)Instant.ofEpochSecond(i * 12345678)).as(new StringBuilder(3).append("col").append(i).toString());
    }

    private final Seq columns$1(int colsNum$2) {
        Seq ts = (Seq)package$.MODULE$.Seq().tabulate(colsNum$2, (Function1 & Serializable)i -> JsonBenchmark$.$anonfun$filtersPushdownBenchmark$2(BoxesRunTime.unboxToInt((Object)i)));
        Column column = this.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).$percent((Object)BoxesRunTime.boxToInteger((int)1000)).as("key");
        return (Seq)ts.$plus$colon((Object)column);
    }

    private static final Dataset readback$1(StructType schema$5, File path$6) {
        return MODULE$.spark().read().schema(schema$5).json(path$6.getAbsolutePath());
    }

    private static final void withFilter$1(boolean configEnabled, StructType schema$5, File path$6) {
        MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.JSON_FILTER_PUSHDOWN_ENABLED().key()), (Object)Boolean.toString(configEnabled))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.DatasetToBenchmark(JsonBenchmark$.readback$1(schema$5, path$6).filter(MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)))).noop());
    }

    public static final /* synthetic */ void $anonfun$filtersPushdownBenchmark$3(JsonBenchmark$ $this, int rowsNum$8, StructType schema$5, Benchmark benchmark$8, int numIters$8, int colsNum$2, File path) {
        MODULE$.spark().range((long)rowsNum$8).select($this.columns$1(colsNum$2)).write().json(path.getAbsolutePath());
        benchmark$8.addCase("w/o filters", numIters$8, (Function1)(JFunction1.mcVI.sp & Serializable)x$52 -> MODULE$.DatasetToBenchmark(JsonBenchmark$.readback$1(schema$5, path)).noop());
        benchmark$8.addCase("pushdown disabled", numIters$8, (Function1)(JFunction1.mcVI.sp & Serializable)x$53 -> JsonBenchmark$.withFilter$1(false, schema$5, path));
        benchmark$8.addCase("w/ filters", numIters$8, (Function1)(JFunction1.mcVI.sp & Serializable)x$54 -> JsonBenchmark$.withFilter$1(true, schema$5, path));
        benchmark$8.run();
    }

    public static final /* synthetic */ StructField $anonfun$partialResultBenchmark$1(int i) {
        return new StructField(new StringBuilder(3).append("col").append(i).toString(), (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ String $anonfun$partialResultBenchmark$4(int colsNum$3, Long i$1, int j) {
        return j < colsNum$3 - 1 ? new StringBuilder(12).append("\"col").append(i$1).append("\":\"foo_").append(j).append("\"").toString() : new StringBuilder(6).append("\"col").append(i$1).append("\":").append(j).toString();
    }

    private final Dataset data$1(int rowsNum$9, int colsNum$3) {
        return this.spark().range(0L, (long)rowsNum$9, 1L, 1).mapPartitions((Function1 & Serializable)iter -> iter.map((Function1 & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), colsNum$3).map((Function1 & Serializable)j -> JsonBenchmark$.$anonfun$partialResultBenchmark$4(colsNum$3, i, BoxesRunTime.unboxToInt((Object)j))).mkString("{", ", ", "}")), this.spark().implicits().newStringEncoder()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.spark().implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$)})).as(this.spark().implicits().newStringEncoder());
    }

    private JsonBenchmark$() {
    }
}

