/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.vectorized;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.sql.RandomDataGenerator$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapBuilder;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.execution.RowToColumnConverter;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedPlainValuesReader;
import org.apache.spark.sql.execution.vectorized.ColumnVectorUtils;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypeTestUtils$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.util.ArrowUtils$;
import org.apache.spark.sql.vectorized.ArrowColumnVector;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.sql.vectorized.ColumnarBatchRow;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.sql.vectorized.ColumnarRow;
import org.apache.spark.tags.ExtendedSQLTest;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.BigDecimal$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ExtendedSQLTest
@ScalaSignature(bytes="\u0006\u0005\u0005]e\u0001B\t\u0013\u0001}AQ\u0001\n\u0001\u0005\u0002\u0015BQ\u0001\u000b\u0001\u0005\n%BQ!\u0012\u0001\u0005\n\u0019Cq\u0001\u0019\u0001C\u0002\u0013%\u0011\r\u0003\u0004f\u0001\u0001\u0006IA\u0019\u0005\bM\u0002\u0011\r\u0011\"\u0003b\u0011\u00199\u0007\u0001)A\u0005E\u001a!\u0001\u000e\u0001\u0001j\u0011!y\u0007B!A!\u0002\u0013\u0001\b\"\u0002\u0013\t\t\u00031\bb\u0002>\t\u0005\u0004%\ta\u001f\u0005\b\u0003\u0013A\u0001\u0015!\u0003}\u0011\u001d\tY\u0001\u0003C!\u0003\u001bAq!a\u000b\u0001\t\u0013\ti\u0003C\u0004\u0002D\u0001!I!!\u0012\t\u000f\u0005u\u0004\u0001\"\u0001\u0002\u0000\t\u00112i\u001c7v[:\f'OQ1uG\"\u001cV/\u001b;f\u0015\t\u0019B#\u0001\u0006wK\u000e$xN]5{K\u0012T!!\u0006\f\u0002\u0013\u0015DXmY;uS>t'BA\f\u0019\u0003\r\u0019\u0018\u000f\u001c\u0006\u00033i\tQa\u001d9be.T!a\u0007\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0012aA8sO\u000e\u00011C\u0001\u0001!!\t\t#%D\u0001\u0019\u0013\t\u0019\u0003DA\u0007Ta\u0006\u00148NR;o'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0019\u0002\"a\n\u0001\u000e\u0003I\t\u0001\"\u00197m_\u000e\fG/\u001a\u000b\u0005U5*T\b\u0005\u0002(W%\u0011AF\u0005\u0002\u0015/JLG/\u00192mK\u000e{G.^7o-\u0016\u001cGo\u001c:\t\u000b9\u0012\u0001\u0019A\u0018\u0002\u0011\r\f\u0007/Y2jif\u0004\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u00121!\u00138u\u0011\u00151$\u00011\u00018\u0003\t!G\u000f\u0005\u00029w5\t\u0011H\u0003\u0002;-\u0005)A/\u001f9fg&\u0011A(\u000f\u0002\t\t\u0006$\u0018\rV=qK\")aH\u0001a\u0001\u007f\u00059Q.Z7N_\u0012,\u0007C\u0001!D\u001b\u0005\t%B\u0001\"\u0019\u0003\u0019iW-\\8ss&\u0011A)\u0011\u0002\u000b\u001b\u0016lwN]=N_\u0012,\u0017A\u0003;fgR4Vm\u0019;peR!q\tU/`)\tA5\n\u0005\u00021\u0013&\u0011!*\r\u0002\u0005+:LG\u000fC\u0003M\u0007\u0001\u0007Q*A\u0003cY>\u001c7\u000e\u0005\u00031\u001d*B\u0015BA(2\u0005%1UO\\2uS>t\u0017\u0007C\u0003R\u0007\u0001\u0007!+\u0001\u0003oC6,\u0007CA*[\u001d\t!\u0006\f\u0005\u0002Vc5\taK\u0003\u0002X=\u00051AH]8pizJ!!W\u0019\u0002\rA\u0013X\rZ3g\u0013\tYFL\u0001\u0004TiJLgn\u001a\u0006\u00033FBQAX\u0002A\u0002=\nAa]5{K\")ag\u0001a\u0001o\u0005Q1\u000f\u001e:vGR$\u0016\u0010]3\u0016\u0003\t\u0004\"\u0001O2\n\u0005\u0011L$AC*ueV\u001cG\u000fV=qK\u0006Y1\u000f\u001e:vGR$\u0016\u0010]3!\u0003%\u0019XOY*dQ\u0016l\u0017-\u0001\u0006tk\n\u001c6\r[3nC\u0002\u0012qcQ;ti>l\u0017N_3e\u0007>dW/\u001c8be\n\u000bGo\u00195\u0014\u0005!Q\u0007CA6n\u001b\u0005a'BA\n\u0017\u0013\tqGNA\u0007D_2,XN\\1s\u0005\u0006$8\r[\u0001\bG>dW/\u001c8t!\r\u0001\u0014o]\u0005\u0003eF\u0012Q!\u0011:sCf\u0004\"a\u001b;\n\u0005Ud'\u0001D\"pYVlgNV3di>\u0014HCA<z!\tA\b\"D\u0001\u0001\u0011\u0015y'\u00021\u0001q\u0003)\u00198.\u001b9S_^LEm]\u000b\u0002yB!Q0!\u00020\u001b\u0005q(bA@\u0002\u0002\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u0007\t\u0014AC2pY2,7\r^5p]&\u0019\u0011q\u0001@\u0003\t1K7\u000f^\u0001\fg.L\u0007OU8x\u0013\u0012\u001c\b%A\u0006s_^LE/\u001a:bi>\u0014HCAA\b!\u0019\t\t\"a\u0007\u0002 5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"\u0001\u0003vi&d'BAA\r\u0003\u0011Q\u0017M^1\n\t\u0005u\u00111\u0003\u0002\t\u0013R,'/\u0019;peB!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&Y\t\u0001bY1uC2L8\u000f^\u0005\u0005\u0003S\t\u0019CA\u0006J]R,'O\\1m%><\u0018\u0001\u00043pk\ndW-R9vC2\u001cHCBA\u0018\u0003k\ty\u0004E\u00021\u0003cI1!a\r2\u0005\u001d\u0011un\u001c7fC:Dq!a\u000e\u000f\u0001\u0004\tI$\u0001\u0002ecA\u0019\u0001'a\u000f\n\u0007\u0005u\u0012G\u0001\u0004E_V\u0014G.\u001a\u0005\b\u0003\u0003r\u0001\u0019AA\u001d\u0003\t!''A\u0007d_6\u0004\u0018M]3TiJ,8\r\u001e\u000b\n\u0011\u0006\u001d\u00131MA4\u0003gBq!!\u0013\u0010\u0001\u0004\tY%\u0001\u0004gS\u0016dGm\u001d\t\u0007\u0003\u001b\n9&!\u0018\u000f\t\u0005=\u00131\u000b\b\u0004+\u0006E\u0013\"\u0001\u001a\n\u0007\u0005U\u0013'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00131\f\u0002\u0004'\u0016\f(bAA+cA\u0019\u0001(a\u0018\n\u0007\u0005\u0005\u0014HA\u0006TiJ,8\r\u001e$jK2$\u0007bBA3\u001f\u0001\u0007\u0011qD\u0001\u0003eFBq!!\u001b\u0010\u0001\u0004\tY'\u0001\u0002seA!\u0011QNA8\u001b\u00051\u0012bAA9-\t\u0019!k\\<\t\u000f\u0005Ut\u00021\u0001\u0002x\u0005!1/Z3e!\r\u0001\u0014\u0011P\u0005\u0004\u0003w\n$\u0001\u0002'p]\u001e\fa\u0002^3tiJ\u000bg\u000eZ8n%><8\u000fF\u0003I\u0003\u0003\u000b)\tC\u0004\u0002\u0004B\u0001\r!a\f\u0002\u0015\u0019d\u0017\r^*dQ\u0016l\u0017\r\u0003\u0004\u0002\bB\u0001\raL\u0001\n]Vlg)[3mIND3\u0001AAF!\u0011\ti)a%\u000e\u0005\u0005=%bAAI1\u0005!A/Y4t\u0013\u0011\t)*a$\u0003\u001f\u0015CH/\u001a8eK\u0012\u001c\u0016\u000b\u0014+fgR\u0004")
public class ColumnarBatchSuite
extends SparkFunSuite {
    private final StructType structType;
    private final StructType subSchema;

    private WritableColumnVector allocate(int capacity, DataType dt, MemoryMode memMode) {
        MemoryMode memoryMode = memMode;
        MemoryMode memoryMode2 = MemoryMode.OFF_HEAP;
        return !(memoryMode != null ? !memoryMode.equals(memoryMode2) : memoryMode2 != null) ? new OffHeapColumnVector(capacity, dt) : new OnHeapColumnVector(capacity, dt);
    }

    private void testVector(String name, int size, DataType dt, Function1<WritableColumnVector, BoxedUnit> block) {
        this.test(name, (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MemoryMode[]{MemoryMode.ON_HEAP, MemoryMode.OFF_HEAP})).foreach((Function1 & Serializable)mode -> {
            ColumnarBatchSuite.$anonfun$testVector$2(this, size, dt, block, mode);
            return BoxedUnit.UNIT;
        }), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
    }

    private StructType structType() {
        return this.structType;
    }

    private StructType subSchema() {
        return this.subSchema;
    }

    private boolean doubleEquals(double d1, double d2) {
        return Double.isNaN(d1) && Double.isNaN(d2) ? true : d1 == d2;
    }

    private void compareStruct(Seq<StructField> fields, InternalRow r1, Row r2, long seed) {
        ((IterableOnceOps)fields.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            StructField field = (StructField)tuple2._1();
            int ordinal = tuple2._2$mcI$sp();
            if (field == null) throw new MatchError((Object)tuple2);
            StructField structField = field;
            if (!true) throw new MatchError((Object)tuple2);
            int n = ordinal;
            boolean $org_scalatest_assert_macro_left = r1.isNullAt(n);
            boolean $org_scalatest_assert_macro_right = r2.isNullAt(n);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1367));
            if (!r1.isNullAt(n)) {
                Assertion assertion;
                DataType dataType = structField.dataType();
                if (BooleanType$.MODULE$.equals(dataType)) {
                    boolean $org_scalatest_assert_macro_left2 = r1.getBoolean(n);
                    boolean $org_scalatest_assert_macro_right2 = r2.getBoolean(n);
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1370));
                } else if (ByteType$.MODULE$.equals(dataType)) {
                    byte $org_scalatest_assert_macro_left3 = r1.getByte(n);
                    byte $org_scalatest_assert_macro_right3 = r2.getByte(n);
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1372));
                } else if (ShortType$.MODULE$.equals(dataType)) {
                    short $org_scalatest_assert_macro_left4 = r1.getShort(n);
                    short $org_scalatest_assert_macro_right4 = r2.getShort(n);
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1373));
                } else if (IntegerType$.MODULE$.equals(dataType)) {
                    int $org_scalatest_assert_macro_left5 = r1.getInt(n);
                    int $org_scalatest_assert_macro_right5 = r2.getInt(n);
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1374));
                } else if (LongType$.MODULE$.equals(dataType)) {
                    long $org_scalatest_assert_macro_left6 = r1.getLong(n);
                    long $org_scalatest_assert_macro_right6 = r2.getLong(n);
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1375));
                } else if (FloatType$.MODULE$.equals(dataType)) {
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(this.doubleEquals(r1.getFloat(n), r2.getFloat(n)), "ColumnarBatchSuite.this.doubleEquals(r1.getFloat(ordinal).toDouble, r2.getFloat(ordinal).toDouble)", Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1376));
                } else if (DoubleType$.MODULE$.equals(dataType)) {
                    Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(this.doubleEquals(r1.getDouble(n), r2.getDouble(n)), "ColumnarBatchSuite.this.doubleEquals(r1.getDouble(ordinal), r2.getDouble(ordinal))", Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1378));
                } else if (DateType$.MODULE$.equals(dataType)) {
                    int $org_scalatest_assert_macro_left7 = r1.getInt(n);
                    int $org_scalatest_assert_macro_right7 = DateTimeUtils$.MODULE$.fromJavaDate(r2.getDate(n));
                    Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1381));
                } else if (TimestampType$.MODULE$.equals(dataType)) {
                    long $org_scalatest_assert_macro_left8 = r1.getLong(n);
                    long $org_scalatest_assert_macro_right8 = DateTimeUtils$.MODULE$.fromJavaTimestamp(r2.getTimestamp(n));
                    Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left8), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 == $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1384));
                } else if (TimestampNTZType$.MODULE$.equals(dataType)) {
                    long $org_scalatest_assert_macro_left9 = r1.getLong(n);
                    long $org_scalatest_assert_macro_right9 = DateTimeUtils$.MODULE$.localDateTimeToMicros((LocalDateTime)r2.getAs(n));
                    Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left9), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9 == $org_scalatest_assert_macro_right9, Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1388));
                } else if (dataType instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)dataType;
                    scala.math.BigDecimal d1 = r1.getDecimal(n, decimalType.precision(), decimalType.scale()).toBigDecimal();
                    BigDecimal d2 = r2.getDecimal(n);
                    int $org_scalatest_assert_macro_left10 = d1.compare(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(d2));
                    int $org_scalatest_assert_macro_right10 = 0;
                    Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10 == $org_scalatest_assert_macro_right10, Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1394));
                } else if (StringType$.MODULE$.equals(dataType)) {
                    String $org_scalatest_assert_macro_left11 = r1.getString(n);
                    String $org_scalatest_assert_macro_right11 = r2.getString(n);
                    String string = $org_scalatest_assert_macro_left11;
                    String string2 = $org_scalatest_assert_macro_right11;
                    Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right11, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1396));
                } else if (BinaryType$.MODULE$.equals(dataType)) {
                    Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapByteArray(r1.getBinary(n)).sameElements((IterableOnce)Predef$.MODULE$.wrapByteArray((byte[])r2.getAs(n))), "scala.Predef.wrapByteArray(r1.getBinary(ordinal)).sameElements[Byte](scala.Predef.wrapByteArray(r2.getAs[Array[Byte]](ordinal)))", Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1398));
                } else if (CalendarIntervalType$.MODULE$.equals(dataType)) {
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(r1.getInterval(n));
                    CalendarInterval $org_scalatest_assert_macro_right12 = (CalendarInterval)r2.get(n);
                    Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1401));
                } else if (dataType instanceof ArrayType) {
                    BoxedUnit boxedUnit2;
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType childType = arrayType.elementType();
                    Object[] a1 = r1.getArray(n).array();
                    Object[] a2 = r2.getList(n).toArray();
                    Object[] $org_scalatest_assert_macro_left13 = a1;
                    int $org_scalatest_assert_macro_right13 = a2.length;
                    Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left13, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left13.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right13), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1405));
                    DataType dataType2 = childType;
                    if (DoubleType$.MODULE$.equals(dataType2)) {
                        for (int i = 0; i < a1.length; ++i) {
                            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(this.doubleEquals(BoxesRunTime.unboxToDouble((Object)a1[i]), BoxesRunTime.unboxToDouble((Object)a2[i])), "ColumnarBatchSuite.this.doubleEquals(a1.apply(i).asInstanceOf[Double], a2.apply(i).asInstanceOf[Double])", Prettifier$.MODULE$.default());
                            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1410));
                        }
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else if (FloatType$.MODULE$.equals(dataType2)) {
                        for (int i = 0; i < a1.length; ++i) {
                            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.simpleMacroBool(this.doubleEquals(BoxesRunTime.unboxToFloat((Object)a1[i]), BoxesRunTime.unboxToFloat((Object)a2[i])), "ColumnarBatchSuite.this.doubleEquals(a1.apply(i).asInstanceOf[Float].toDouble, a2.apply(i).asInstanceOf[Float].toDouble)", Prettifier$.MODULE$.default());
                            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1417));
                        }
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else if (StringType$.MODULE$.equals(dataType2)) {
                        for (int i = 0; i < a1.length; ++i) {
                            BoxedUnit boxedUnit3;
                            boolean $org_scalatest_assert_macro_left14 = a1[i] == null;
                            boolean $org_scalatest_assert_macro_right14 = a2[i] == null;
                            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left14), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left14 == $org_scalatest_assert_macro_right14, Prettifier$.MODULE$.default());
                            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1424));
                            if (a1[i] != null) {
                                String s1 = ((UTF8String)a1[i]).toString();
                                String s2 = (String)a2[i];
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left15 = this.convertToEqualizer(s1);
                                String $org_scalatest_assert_macro_right15 = s2;
                                Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "===", (Object)$org_scalatest_assert_macro_right15, $org_scalatest_assert_macro_left15.$eq$eq$eq((Object)$org_scalatest_assert_macro_right15, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                boxedUnit3 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1428));
                                continue;
                            }
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else if (DateType$.MODULE$.equals(dataType2)) {
                        for (int i = 0; i < a1.length; ++i) {
                            BoxedUnit boxedUnit4;
                            boolean $org_scalatest_assert_macro_left16 = a1[i] == null;
                            boolean $org_scalatest_assert_macro_right16 = a2[i] == null;
                            Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left16), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right16), $org_scalatest_assert_macro_left16 == $org_scalatest_assert_macro_right16, Prettifier$.MODULE$.default());
                            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1435));
                            if (a1[i] != null) {
                                int i1 = BoxesRunTime.unboxToInt((Object)a1[i]);
                                int i2 = DateTimeUtils$.MODULE$.fromJavaDate((Date)a2[i]);
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left17 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)i1));
                                int $org_scalatest_assert_macro_right17 = i2;
                                Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right17), $org_scalatest_assert_macro_left17.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right17), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                boxedUnit4 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1439));
                                continue;
                            }
                            boxedUnit4 = BoxedUnit.UNIT;
                        }
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else if (TimestampType$.MODULE$.equals(dataType2)) {
                        for (int i = 0; i < a1.length; ++i) {
                            BoxedUnit boxedUnit5;
                            boolean $org_scalatest_assert_macro_left18 = a1[i] == null;
                            boolean $org_scalatest_assert_macro_right18 = a2[i] == null;
                            Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left18), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right18), $org_scalatest_assert_macro_left18 == $org_scalatest_assert_macro_right18, Prettifier$.MODULE$.default());
                            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1446));
                            if (a1[i] != null) {
                                long i1 = BoxesRunTime.unboxToLong((Object)a1[i]);
                                long i2 = DateTimeUtils$.MODULE$.fromJavaTimestamp((Timestamp)a2[i]);
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left19 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)i1));
                                long $org_scalatest_assert_macro_right19 = i2;
                                Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left19, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right19), $org_scalatest_assert_macro_left19.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right19), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                boxedUnit5 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1450));
                                continue;
                            }
                            boxedUnit5 = BoxedUnit.UNIT;
                        }
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else if (TimestampNTZType$.MODULE$.equals(dataType2)) {
                        for (int i = 0; i < a1.length; ++i) {
                            BoxedUnit boxedUnit6;
                            boolean $org_scalatest_assert_macro_left20 = a1[i] == null;
                            boolean $org_scalatest_assert_macro_right20 = a2[i] == null;
                            Bool $org_scalatest_assert_macro_expr25 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left20), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right20), $org_scalatest_assert_macro_left20 == $org_scalatest_assert_macro_right20, Prettifier$.MODULE$.default());
                            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr25, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1457));
                            if (a1[i] != null) {
                                long i1 = BoxesRunTime.unboxToLong((Object)a1[i]);
                                long i2 = DateTimeUtils$.MODULE$.localDateTimeToMicros((LocalDateTime)a2[i]);
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left21 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)i1));
                                long $org_scalatest_assert_macro_right21 = i2;
                                Bool $org_scalatest_assert_macro_expr26 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left21, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right21), $org_scalatest_assert_macro_left21.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right21), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                boxedUnit6 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr26, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1461));
                                continue;
                            }
                            boxedUnit6 = BoxedUnit.UNIT;
                        }
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else if (dataType2 instanceof DecimalType) {
                        for (int i = 0; i < a1.length; ++i) {
                            BoxedUnit boxedUnit7;
                            boolean $org_scalatest_assert_macro_left22 = a1[i] == null;
                            boolean $org_scalatest_assert_macro_right22 = a2[i] == null;
                            Bool $org_scalatest_assert_macro_expr27 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left22), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right22), $org_scalatest_assert_macro_left22 == $org_scalatest_assert_macro_right22, Prettifier$.MODULE$.default());
                            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr27, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1468));
                            if (a1[i] != null) {
                                scala.math.BigDecimal d1 = ((Decimal)a1[i]).toBigDecimal();
                                BigDecimal d2 = (BigDecimal)a2[i];
                                int $org_scalatest_assert_macro_left23 = d1.compare(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(d2));
                                int $org_scalatest_assert_macro_right23 = 0;
                                Bool $org_scalatest_assert_macro_expr28 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left23), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right23), $org_scalatest_assert_macro_left23 == $org_scalatest_assert_macro_right23, Prettifier$.MODULE$.default());
                                boxedUnit7 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr28, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1472));
                                continue;
                            }
                            boxedUnit7 = BoxedUnit.UNIT;
                        }
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left24 = this.convertToEqualizer(a1);
                        Object[] $org_scalatest_assert_macro_right24 = a2;
                        Bool $org_scalatest_assert_macro_expr29 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left24, "===", (Object)$org_scalatest_assert_macro_right24, $org_scalatest_assert_macro_left24.$eq$eq$eq((Object)$org_scalatest_assert_macro_right24, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        boxedUnit2 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr29, (Object)new StringBuilder(7).append("Seed = ").append(seed).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1476));
                    }
                    assertion = boxedUnit2;
                } else {
                    if (!(dataType instanceof StructType)) throw new UnsupportedOperationException(new StringBuilder(16).append("Not implemented ").append(structField.dataType()).toString());
                    StructType structType = (StructType)dataType;
                    StructField[] childFields = structType.fields();
                    this.compareStruct((Seq<StructField>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)childFields), r1.getStruct(n, fields.length()), r2.getStruct(n), seed);
                    assertion = BoxedUnit.UNIT;
                }
                boxedUnit = assertion;
                return boxedUnit;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
    }

    public void testRandomRows(boolean flatSchema, int numFields) {
        DataType[] types = (DataType[])((Object[])new DataType[]{BooleanType$.MODULE$, ByteType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, ShortType$.MODULE$, DecimalType$.MODULE$.ShortDecimal(), DecimalType$.MODULE$.IntDecimal(), DecimalType$.MODULE$.ByteDecimal(), DecimalType$.MODULE$.FloatDecimal(), DecimalType$.MODULE$.LongDecimal(), new DecimalType(5, 2), new DecimalType(12, 2), new DecimalType(30, 10), CalendarIntervalType$.MODULE$, DateType$.MODULE$, StringType$.MODULE$, BinaryType$.MODULE$, TimestampType$.MODULE$, TimestampNTZType$.MODULE$});
        long seed = System.nanoTime();
        int NUM_ROWS = 200;
        int NUM_ITERS = 1000;
        Random random = new Random(seed);
        for (int i = 0; i < NUM_ITERS; ++i) {
            StructType schema = flatSchema ? RandomDataGenerator$.MODULE$.randomSchema(random, numFields, (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)types)) : RandomDataGenerator$.MODULE$.randomNestedSchema(random, numFields, (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)types));
            ArrayBuffer rows = ArrayBuffer$.MODULE$.empty();
            for (int j = 0; j < NUM_ROWS; ++j) {
                Row row = RandomDataGenerator$.MODULE$.randomRow(random, schema);
                rows.$plus$eq((Object)row);
            }
            scala.package$.MODULE$.Nil().$colon$colon((Object)MemoryMode.OFF_HEAP).$colon$colon((Object)MemoryMode.ON_HEAP).foreach((Function1 & Serializable)memMode -> {
                ColumnarBatchSuite.$anonfun$testRandomRows$1(this, schema, rows, NUM_ROWS, seed, memMode);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$testVector$2(ColumnarBatchSuite $this, int size$1, DataType dt$1, Function1 block$1, MemoryMode mode) {
        try (WritableColumnVector vector = $this.allocate(size$1, dt$1, mode);){
            block$1.apply((Object)vector);
        }
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$new$2(ArrayBuffer reference$1, int x$1) {
        return (ArrayBuffer)reference$1.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$new$3(ArrayBuffer reference$1, int x$2) {
        return (ArrayBuffer)reference$1.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public static final /* synthetic */ void $anonfun$new$1(WritableColumnVector column) {
        ArrayBuffer reference = ArrayBuffer$.MODULE$.empty();
        int idx = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(column.hasNull(), "column.hasNull()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        int $org_scalatest_assert_macro_left = column.numNulls();
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        column.appendNotNull();
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(column.hasNull(), "column.hasNull()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        int $org_scalatest_assert_macro_left2 = column.numNulls();
        int $org_scalatest_assert_macro_right2 = 0;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        column.appendNotNulls(3);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3).foreach((Function1 & Serializable)x$1 -> ColumnarBatchSuite.$anonfun$new$2(reference, BoxesRunTime.unboxToInt((Object)x$1)));
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(column.hasNull(), "column.hasNull()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        int $org_scalatest_assert_macro_left3 = column.numNulls();
        int $org_scalatest_assert_macro_right3 = 0;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        column.appendNull();
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(column.hasNull(), "column.hasNull()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        int $org_scalatest_assert_macro_left4 = column.numNulls();
        int $org_scalatest_assert_macro_right4 = 1;
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        column.appendNulls(3);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3).foreach((Function1 & Serializable)x$2 -> ColumnarBatchSuite.$anonfun$new$3(reference, BoxesRunTime.unboxToInt((Object)x$2)));
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(column.hasNull(), "column.hasNull()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        int $org_scalatest_assert_macro_left5 = column.numNulls();
        int $org_scalatest_assert_macro_right5 = 4;
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        idx = column.elementsAppended;
        column.putNotNull(idx);
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)false));
        ++idx;
        Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(column.hasNull(), "column.hasNull()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        int $org_scalatest_assert_macro_left6 = column.numNulls();
        int $org_scalatest_assert_macro_right6 = 4;
        Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        column.putNull(idx);
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)true));
        ++idx;
        Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(column.hasNull(), "column.hasNull()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        int $org_scalatest_assert_macro_left7 = column.numNulls();
        int $org_scalatest_assert_macro_right7 = 5;
        Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        column.putNulls(idx, 3);
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)true));
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)true));
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)true));
        idx += 3;
        Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(column.hasNull(), "column.hasNull()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        int $org_scalatest_assert_macro_left8 = column.numNulls();
        int $org_scalatest_assert_macro_right8 = 8;
        Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 == $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        column.putNotNulls(idx, 4);
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)false));
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)false));
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)false));
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)false));
        idx += 4;
        Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(column.hasNull(), "column.hasNull()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        int $org_scalatest_assert_macro_left9 = column.numNulls();
        int $org_scalatest_assert_macro_right9 = 8;
        Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9 == $org_scalatest_assert_macro_right9, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        ((IterableOnceOps)reference.zipWithIndex()).foreach((Function1 & Serializable)v -> {
            boolean $org_scalatest_assert_macro_left = v._1$mcZ$sp();
            boolean $org_scalatest_assert_macro_right = column.isNullAt(v._2$mcI$sp());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        });
    }

    public static final /* synthetic */ int $anonfun$new$6(boolean b, int i) {
        return i << 1 | (b ? 1 : 0);
    }

    public static final /* synthetic */ int $anonfun$new$8(boolean b, int i) {
        return i << 1 | (b ? 1 : 0);
    }

    private static final byte intToByte$1(int i) {
        return (byte)i;
    }

    public static final /* synthetic */ void $anonfun$new$5(WritableColumnVector column) {
        ArrayBuffer reference = ArrayBuffer$.MODULE$.empty();
        boolean[] values = new boolean[]{true, false, true, false, false};
        byte bits = (byte)BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.foldRight$extension(Predef$.MODULE$.booleanArrayOps(values), (Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(b, i) -> BoxesRunTime.boxToInteger((int)ColumnarBatchSuite.$anonfun$new$6(BoxesRunTime.unboxToBoolean((Object)b), BoxesRunTime.unboxToInt((Object)i)))));
        column.appendBooleans(2, bits, 0);
        reference.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapBooleanArray((boolean[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.booleanArrayOps(values), 0, 2)));
        column.appendBooleans(3, bits, 2);
        reference.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapBooleanArray((boolean[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.booleanArrayOps(values), 2, 5)));
        column.appendBooleans(6, true);
        reference.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapBooleanArray((boolean[])Array$.MODULE$.fill(6, (Function0)(JFunction0.mcZ.sp & Serializable)() -> true, (ClassTag)ClassTag$.MODULE$.Boolean())));
        column.appendBoolean(false);
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)false));
        int idx = column.elementsAppended;
        values = new boolean[]{true, true, false, true, false, true, false, true};
        bits = (byte)BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.foldRight$extension(Predef$.MODULE$.booleanArrayOps(values), (Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(b, i) -> BoxesRunTime.boxToInteger((int)ColumnarBatchSuite.$anonfun$new$8(BoxesRunTime.unboxToBoolean((Object)b), BoxesRunTime.unboxToInt((Object)i)))));
        column.putBooleans(idx, 2, bits, 0);
        reference.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapBooleanArray((boolean[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.booleanArrayOps(values), 0, 2)));
        column.putBooleans(idx += 2, 3, bits, 2);
        reference.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapBooleanArray((boolean[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.booleanArrayOps(values), 2, 5)));
        column.putBooleans(idx += 3, bits);
        reference.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapBooleanArray(values));
        column.putBoolean(idx += 8, false);
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)false));
        column.putBooleans(++idx, 3, true);
        reference.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapBooleanArray((boolean[])Array$.MODULE$.fill(3, (Function0)(JFunction0.mcZ.sp & Serializable)() -> true, (ClassTag)ClassTag$.MODULE$.Boolean())));
        ByteBuffer buf = ByteBuffer.wrap(new byte[]{51, 90, ColumnarBatchSuite.intToByte$1(165), ColumnarBatchSuite.intToByte$1(204), 15, ColumnarBatchSuite.intToByte$1(240), ColumnarBatchSuite.intToByte$1(238), 119, ColumnarBatchSuite.intToByte$1(136)});
        VectorizedPlainValuesReader reader = new VectorizedPlainValuesReader();
        reader.initFromPage(0, ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{buf}));
        reader.skipBooleans(1);
        column.putBoolean(idx += 3, reader.readBoolean());
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)true));
        column.putBoolean(++idx, reader.readBoolean());
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)false));
        reader.skipBooleans(5);
        column.putBoolean(++idx, reader.readBoolean());
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)false));
        reader.skipBooleans(8);
        reader.skipBooleans(0);
        column.putBoolean(++idx, reader.readBoolean());
        reference.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)false));
        reader.skipBooleans(16);
        reader.readBooleans(4, column, ++idx);
        reference.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, true, false, false}));
        reader.readBooleans(11, column, idx += 4);
        reference.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, false, false, false, false, false, true, true, true, true, false}));
        reader.skipBooleans(7);
        reader.readBooleans(9, column, idx += 11);
        reference.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, true, true, false, true, true, true, false, false}));
        idx += 9;
        ((IterableOnceOps)reference.zipWithIndex()).foreach((Function1 & Serializable)v -> {
            boolean $org_scalatest_assert_macro_left = v._1$mcZ$sp();
            boolean $org_scalatest_assert_macro_right = column.getBoolean(v._2$mcI$sp());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(11).append("VectorType=").append(column.getClass().getSimpleName()).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
        });
    }

    public static final /* synthetic */ byte $anonfun$new$12(int x$3) {
        return (byte)x$3;
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$new$13(ArrayBuffer reference$2, int x$4) {
        return (ArrayBuffer)reference$2.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)60)));
    }

    public static final /* synthetic */ byte $anonfun$new$14(int x$5) {
        return (byte)x$5;
    }

    public static final /* synthetic */ void $anonfun$new$11(WritableColumnVector column) {
        ArrayBuffer reference = ArrayBuffer$.MODULE$.empty();
        byte[] values = (byte[])scala.package$.MODULE$.Nil().$colon$colon((Object)BoxesRunTime.boxToInteger((int)50)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)40)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)30)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)20)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)10)).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToByte((byte)ColumnarBatchSuite.$anonfun$new$12(BoxesRunTime.unboxToInt((Object)x$3)))).toArray((ClassTag)ClassTag$.MODULE$.Byte());
        column.appendBytes(2, values, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)10)));
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)20)));
        column.appendBytes(3, values, 2);
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)30)));
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)40)));
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)50)));
        column.appendBytes(6, (byte)60);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 6).foreach((Function1 & Serializable)x$4 -> ColumnarBatchSuite.$anonfun$new$13(reference, BoxesRunTime.unboxToInt((Object)x$4)));
        column.appendByte((byte)70);
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)70)));
        int idx = column.elementsAppended;
        values = (byte[])scala.package$.MODULE$.Nil().$colon$colon((Object)BoxesRunTime.boxToInteger((int)5)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)4)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)3)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)2)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)1)).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToByte((byte)ColumnarBatchSuite.$anonfun$new$14(BoxesRunTime.unboxToInt((Object)x$5)))).toArray((ClassTag)ClassTag$.MODULE$.Byte());
        column.putBytes(idx, 2, values, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)1));
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)2));
        column.putBytes(idx += 2, 3, values, 2);
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)3));
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)4));
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)5));
        column.putByte(idx += 3, (byte)9);
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)9));
        column.putBytes(++idx, 3, (byte)4);
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)4));
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)4));
        reference.$plus$eq((Object)BoxesRunTime.boxToByte((byte)4));
        idx += 3;
        ((IterableOnceOps)reference.zipWithIndex()).foreach((Function1 & Serializable)v -> {
            byte $org_scalatest_assert_macro_left = BoxesRunTime.unboxToByte((Object)v._1());
            byte $org_scalatest_assert_macro_right = column.getByte(v._2$mcI$sp());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(11).append("VectorType=").append(column.getClass().getSimpleName()).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
        });
    }

    public static final /* synthetic */ short $anonfun$new$17(int x$6) {
        return (short)x$6;
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$new$18(ArrayBuffer reference$3, int x$7) {
        return (ArrayBuffer)reference$3.$plus$eq((Object)BoxesRunTime.boxToShort((short)((short)60)));
    }

    public static final /* synthetic */ short $anonfun$new$19(int x$8) {
        return (short)x$8;
    }

    public static final /* synthetic */ void $anonfun$new$16(WritableColumnVector column) {
        long seed = System.currentTimeMillis();
        Random random = new Random(seed);
        ArrayBuffer reference = ArrayBuffer$.MODULE$.empty();
        short[] values = (short[])scala.package$.MODULE$.Nil().$colon$colon((Object)BoxesRunTime.boxToInteger((int)50)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)40)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)30)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)20)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)10)).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToShort((short)ColumnarBatchSuite.$anonfun$new$17(BoxesRunTime.unboxToInt((Object)x$6)))).toArray((ClassTag)ClassTag$.MODULE$.Short());
        column.appendShorts(2, values, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)((short)10)));
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)((short)20)));
        column.appendShorts(3, values, 2);
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)((short)30)));
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)((short)40)));
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)((short)50)));
        column.appendShorts(6, (short)60);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 6).foreach((Function1 & Serializable)x$7 -> ColumnarBatchSuite.$anonfun$new$18(reference, BoxesRunTime.unboxToInt((Object)x$7)));
        column.appendShort((short)70);
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)((short)70)));
        int idx = column.elementsAppended;
        values = (short[])scala.package$.MODULE$.Nil().$colon$colon((Object)BoxesRunTime.boxToInteger((int)5)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)4)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)3)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)2)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)1)).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToShort((short)ColumnarBatchSuite.$anonfun$new$19(BoxesRunTime.unboxToInt((Object)x$8)))).toArray((ClassTag)ClassTag$.MODULE$.Short());
        column.putShorts(idx, 2, values, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)1));
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)2));
        column.putShorts(idx += 2, 3, values, 2);
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)3));
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)4));
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)5));
        column.putShort(idx += 3, (short)9);
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)9));
        column.putShorts(++idx, 3, (short)4);
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)4));
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)4));
        reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)4));
        idx += 3;
        while (idx < column.capacity) {
            boolean single = random.nextBoolean();
            if (single) {
                short v2 = (short)random.nextInt();
                column.putShort(idx, v2);
                reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)v2));
                ++idx;
                continue;
            }
            int n = package$.MODULE$.min(random.nextInt(column.capacity / 20), column.capacity - idx);
            short v3 = (short)(n + 1);
            column.putShorts(idx, n, v3);
            for (int i = 0; i < n; ++i) {
                reference.$plus$eq((Object)BoxesRunTime.boxToShort((short)v3));
            }
            idx += n;
        }
        ((IterableOnceOps)reference.zipWithIndex()).foreach((Function1 & Serializable)v -> {
            short $org_scalatest_assert_macro_left = BoxesRunTime.unboxToShort((Object)v._1());
            short $org_scalatest_assert_macro_right = column.getShort(v._2$mcI$sp());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(19).append("Seed = ").append(seed).append(" VectorType=").append(column.getClass().getSimpleName()).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
        });
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$new$22(ArrayBuffer reference$4, int x$9) {
        return (ArrayBuffer)reference$4.$plus$eq((Object)BoxesRunTime.boxToInteger((int)60));
    }

    public static final /* synthetic */ void $anonfun$new$21(WritableColumnVector column) {
        long seed = System.currentTimeMillis();
        Random random = new Random(seed);
        ArrayBuffer reference = ArrayBuffer$.MODULE$.empty();
        int[] values = (int[])scala.package$.MODULE$.Nil().$colon$colon((Object)BoxesRunTime.boxToInteger((int)50)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)40)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)30)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)20)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)10)).toArray((ClassTag)ClassTag$.MODULE$.Int());
        column.appendInts(2, values, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)10));
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)20));
        column.appendInts(3, values, 2);
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)30));
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)40));
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)50));
        column.appendInts(6, 60);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 6).foreach((Function1 & Serializable)x$9 -> ColumnarBatchSuite.$anonfun$new$22(reference, BoxesRunTime.unboxToInt((Object)x$9)));
        column.appendInt(70);
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)70));
        int idx = column.elementsAppended;
        values = (int[])scala.package$.MODULE$.Nil().$colon$colon((Object)BoxesRunTime.boxToInteger((int)5)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)4)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)3)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)2)).$colon$colon((Object)BoxesRunTime.boxToInteger((int)1)).toArray((ClassTag)ClassTag$.MODULE$.Int());
        column.putInts(idx, 2, values, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)1));
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)2));
        column.putInts(idx += 2, 3, values, 2);
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)3));
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)4));
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)5));
        idx += 3;
        byte[] littleEndian = new byte[8];
        littleEndian[0] = 7;
        littleEndian[1] = 1;
        littleEndian[4] = 6;
        littleEndian[6] = 1;
        column.putIntsLittleEndian(idx, 1, littleEndian, 4);
        column.putIntsLittleEndian(idx + 1, 1, littleEndian, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)65542));
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)263));
        column.putIntsLittleEndian(idx += 2, 2, littleEndian, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)263));
        reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)65542));
        idx += 2;
        while (idx < column.capacity) {
            boolean single = random.nextBoolean();
            if (single) {
                int v2 = random.nextInt();
                column.putInt(idx, v2);
                reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)v2));
                ++idx;
                continue;
            }
            int n = package$.MODULE$.min(random.nextInt(column.capacity / 20), column.capacity - idx);
            column.putInts(idx, n, n + 1);
            for (int i = 0; i < n; ++i) {
                reference.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(n + 1)));
            }
            idx += n;
        }
        ((IterableOnceOps)reference.zipWithIndex()).foreach((Function1 & Serializable)v -> {
            int $org_scalatest_assert_macro_left = v._1$mcI$sp();
            int $org_scalatest_assert_macro_right = column.getInt(v._2$mcI$sp());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(19).append("Seed = ").append(seed).append(" VectorType=").append(column.getClass().getSimpleName()).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
        });
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$new$25(ArrayBuffer reference$5, int x$10) {
        return (ArrayBuffer)reference$5.$plus$eq((Object)BoxesRunTime.boxToLong((long)60L));
    }

    public static final /* synthetic */ void $anonfun$new$24(WritableColumnVector column) {
        long seed = System.currentTimeMillis();
        Random random = new Random(seed);
        ArrayBuffer reference = ArrayBuffer$.MODULE$.empty();
        long[] values = (long[])scala.package$.MODULE$.Nil().$colon$colon((Object)BoxesRunTime.boxToLong((long)50L)).$colon$colon((Object)BoxesRunTime.boxToLong((long)40L)).$colon$colon((Object)BoxesRunTime.boxToLong((long)30L)).$colon$colon((Object)BoxesRunTime.boxToLong((long)20L)).$colon$colon((Object)BoxesRunTime.boxToLong((long)10L)).toArray((ClassTag)ClassTag$.MODULE$.Long());
        column.appendLongs(2, values, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)10L));
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)20L));
        column.appendLongs(3, values, 2);
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)30L));
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)40L));
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)50L));
        column.appendLongs(6, 60L);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 6).foreach((Function1 & Serializable)x$10 -> ColumnarBatchSuite.$anonfun$new$25(reference, BoxesRunTime.unboxToInt((Object)x$10)));
        column.appendLong(70L);
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)70L));
        int idx = column.elementsAppended;
        values = (long[])scala.package$.MODULE$.Nil().$colon$colon((Object)BoxesRunTime.boxToLong((long)5L)).$colon$colon((Object)BoxesRunTime.boxToLong((long)4L)).$colon$colon((Object)BoxesRunTime.boxToLong((long)3L)).$colon$colon((Object)BoxesRunTime.boxToLong((long)2L)).$colon$colon((Object)BoxesRunTime.boxToLong((long)1L)).toArray((ClassTag)ClassTag$.MODULE$.Long());
        column.putLongs(idx, 2, values, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)1L));
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)2L));
        column.putLongs(idx += 2, 3, values, 2);
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)3L));
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)4L));
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)5L));
        idx += 3;
        byte[] littleEndian = new byte[16];
        littleEndian[0] = 7;
        littleEndian[1] = 1;
        littleEndian[8] = 6;
        littleEndian[10] = 1;
        column.putLongsLittleEndian(idx, 1, littleEndian, 8);
        column.putLongsLittleEndian(idx + 1, 1, littleEndian, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)65542L));
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)263L));
        column.putLongsLittleEndian(idx += 2, 2, littleEndian, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)263L));
        reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)65542L));
        idx += 2;
        while (idx < column.capacity) {
            boolean single = random.nextBoolean();
            if (single) {
                long v2 = random.nextLong();
                column.putLong(idx, v2);
                reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)v2));
                ++idx;
                continue;
            }
            int n = package$.MODULE$.min(random.nextInt(column.capacity / 20), column.capacity - idx);
            column.putLongs(idx, n, (long)(n + 1));
            for (int i = 0; i < n; ++i) {
                reference.$plus$eq((Object)BoxesRunTime.boxToLong((long)(n + 1)));
            }
            idx += n;
        }
        ((IterableOnceOps)reference.zipWithIndex()).foreach((Function1 & Serializable)v -> {
            long $org_scalatest_assert_macro_left = v._1$mcJ$sp();
            long $org_scalatest_assert_macro_right = column.getLong(v._2$mcI$sp());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(24).append("idx=").append(v._2$mcI$sp()).append(" Seed = ").append(seed).append(" VectorType=").append(column.getClass().getSimpleName()).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 504));
        });
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$new$28(ArrayBuffer reference$6, int x$11) {
        return (ArrayBuffer)reference$6.$plus$eq((Object)BoxesRunTime.boxToFloat((float)0.6f));
    }

    public static final /* synthetic */ void $anonfun$new$27(WritableColumnVector column) {
        long seed = System.currentTimeMillis();
        Random random = new Random(seed);
        ArrayBuffer reference = ArrayBuffer$.MODULE$.empty();
        float[] values = (float[])scala.package$.MODULE$.Nil().$colon$colon((Object)BoxesRunTime.boxToFloat((float)0.5f)).$colon$colon((Object)BoxesRunTime.boxToFloat((float)0.4f)).$colon$colon((Object)BoxesRunTime.boxToFloat((float)0.3f)).$colon$colon((Object)BoxesRunTime.boxToFloat((float)0.2f)).$colon$colon((Object)BoxesRunTime.boxToFloat((float)0.1f)).toArray((ClassTag)ClassTag$.MODULE$.Float());
        column.appendFloats(2, values, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)0.1f));
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)0.2f));
        column.appendFloats(3, values, 2);
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)0.3f));
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)0.4f));
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)0.5f));
        column.appendFloats(6, 0.6f);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 6).foreach((Function1 & Serializable)x$11 -> ColumnarBatchSuite.$anonfun$new$28(reference, BoxesRunTime.unboxToInt((Object)x$11)));
        column.appendFloat(0.7f);
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)0.7f));
        int idx = column.elementsAppended;
        values = (float[])scala.package$.MODULE$.Nil().$colon$colon((Object)BoxesRunTime.boxToFloat((float)5.0f)).$colon$colon((Object)BoxesRunTime.boxToFloat((float)4.0f)).$colon$colon((Object)BoxesRunTime.boxToFloat((float)3.0f)).$colon$colon((Object)BoxesRunTime.boxToFloat((float)2.0f)).$colon$colon((Object)BoxesRunTime.boxToFloat((float)1.0f)).toArray((ClassTag)ClassTag$.MODULE$.Float());
        column.putFloats(idx, 2, values, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)1.0f));
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)2.0f));
        column.putFloats(idx += 2, 3, values, 2);
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)3.0f));
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)4.0f));
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)5.0f));
        byte[] buffer = new byte[8];
        Platform.putFloat((Object)buffer, (long)Platform.BYTE_ARRAY_OFFSET, (float)2.234f);
        Platform.putFloat((Object)buffer, (long)(Platform.BYTE_ARRAY_OFFSET + 4), (float)1.123f);
        column.putFloats(idx += 3, 1, buffer, 4);
        column.putFloats(idx + 1, 1, buffer, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)1.123f));
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)2.234f));
        column.putFloats(idx += 2, 2, buffer, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)2.234f));
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)1.123f));
        idx += 2;
        while (idx < column.capacity) {
            boolean single = random.nextBoolean();
            if (single) {
                float v2 = random.nextFloat();
                column.putFloat(idx, v2);
                reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)v2));
                ++idx;
                continue;
            }
            int n = package$.MODULE$.min(random.nextInt(column.capacity / 20), column.capacity - idx);
            float v3 = random.nextFloat();
            column.putFloats(idx, n, v3);
            for (int i = 0; i < n; ++i) {
                reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)v3));
            }
            idx += n;
        }
        ((IterableOnceOps)reference.zipWithIndex()).foreach((Function1 & Serializable)v -> {
            float $org_scalatest_assert_macro_left = BoxesRunTime.unboxToFloat((Object)v._1());
            float $org_scalatest_assert_macro_right = column.getFloat(v._2$mcI$sp());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(19).append("Seed = ").append(seed).append(" VectorType=").append(column.getClass().getSimpleName()).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 581));
        });
    }

    public static final /* synthetic */ void $anonfun$new$30(WritableColumnVector column) {
        long seed = System.currentTimeMillis();
        Random random = new Random(seed);
        ArrayBuffer reference = ArrayBuffer$.MODULE$.empty();
        int idx = 0;
        ByteBuffer littleEndian = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        littleEndian.putFloat(0, 1.357f);
        littleEndian.putFloat(4, 2.468f);
        byte[] arr = new byte[littleEndian.remaining()];
        littleEndian.get(arr);
        column.putFloatsLittleEndian(idx, 1, arr, 4);
        column.putFloatsLittleEndian(idx + 1, 1, arr, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)2.468f));
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)1.357f));
        column.putFloatsLittleEndian(idx += 2, 2, arr, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)1.357f));
        reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)2.468f));
        idx += 2;
        while (idx < column.capacity) {
            boolean single = random.nextBoolean();
            if (single) {
                float v2 = random.nextFloat();
                column.putFloat(idx, v2);
                reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)v2));
                ++idx;
                continue;
            }
            int n = package$.MODULE$.min(random.nextInt(column.capacity / 20), column.capacity - idx);
            float v3 = random.nextFloat();
            column.putFloats(idx, n, v3);
            for (int i = 0; i < n; ++i) {
                reference.$plus$eq((Object)BoxesRunTime.boxToFloat((float)v3));
            }
            idx += n;
        }
        ((IterableOnceOps)reference.zipWithIndex()).foreach((Function1 & Serializable)v -> {
            float $org_scalatest_assert_macro_left = BoxesRunTime.unboxToFloat((Object)v._1());
            float $org_scalatest_assert_macro_right = column.getFloat(v._2$mcI$sp());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(19).append("Seed = ").append(seed).append(" VectorType=").append(column.getClass().getSimpleName()).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 632));
        });
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$new$33(ArrayBuffer reference$7, int x$12) {
        return (ArrayBuffer)reference$7.$plus$eq((Object)BoxesRunTime.boxToDouble((double)0.6));
    }

    public static final /* synthetic */ void $anonfun$new$32(WritableColumnVector column) {
        long seed = System.currentTimeMillis();
        Random random = new Random(seed);
        ArrayBuffer reference = ArrayBuffer$.MODULE$.empty();
        double[] values = (double[])scala.package$.MODULE$.Nil().$colon$colon((Object)BoxesRunTime.boxToDouble((double)0.5)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)0.4)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)0.3)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)0.2)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)0.1)).toArray((ClassTag)ClassTag$.MODULE$.Double());
        column.appendDoubles(2, values, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)0.1));
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)0.2));
        column.appendDoubles(3, values, 2);
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)0.3));
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)0.4));
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)0.5));
        column.appendDoubles(6, 0.6);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 6).foreach((Function1 & Serializable)x$12 -> ColumnarBatchSuite.$anonfun$new$33(reference, BoxesRunTime.unboxToInt((Object)x$12)));
        column.appendDouble(0.7);
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)0.7));
        int idx = column.elementsAppended;
        values = (double[])scala.package$.MODULE$.Nil().$colon$colon((Object)BoxesRunTime.boxToDouble((double)5.0)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)4.0)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)3.0)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)2.0)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)1.0)).toArray((ClassTag)ClassTag$.MODULE$.Double());
        column.putDoubles(idx, 2, values, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)1.0));
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)2.0));
        column.putDoubles(idx += 2, 3, values, 2);
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)3.0));
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)4.0));
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)5.0));
        byte[] buffer = new byte[16];
        Platform.putDouble((Object)buffer, (long)Platform.BYTE_ARRAY_OFFSET, (double)2.234);
        Platform.putDouble((Object)buffer, (long)(Platform.BYTE_ARRAY_OFFSET + 8), (double)1.123);
        column.putDoubles(idx += 3, 1, buffer, 8);
        column.putDoubles(idx + 1, 1, buffer, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)1.123));
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)2.234));
        column.putDoubles(idx += 2, 2, buffer, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)2.234));
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)1.123));
        idx += 2;
        while (idx < column.capacity) {
            boolean single = random.nextBoolean();
            if (single) {
                double v2 = random.nextDouble();
                column.putDouble(idx, v2);
                reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)v2));
                ++idx;
                continue;
            }
            int n = package$.MODULE$.min(random.nextInt(column.capacity / 20), column.capacity - idx);
            double v3 = random.nextDouble();
            column.putDoubles(idx, n, v3);
            for (int i = 0; i < n; ++i) {
                reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)v3));
            }
            idx += n;
        }
        ((IterableOnceOps)reference.zipWithIndex()).foreach((Function1 & Serializable)v -> {
            double $org_scalatest_assert_macro_left = v._1$mcD$sp();
            double $org_scalatest_assert_macro_right = column.getDouble(v._2$mcI$sp());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(19).append("Seed = ").append(seed).append(" VectorType=").append(column.getClass().getSimpleName()).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 709));
        });
    }

    public static final /* synthetic */ void $anonfun$new$35(WritableColumnVector column) {
        long seed = System.currentTimeMillis();
        Random random = new Random(seed);
        ArrayBuffer reference = ArrayBuffer$.MODULE$.empty();
        int idx = 0;
        ByteBuffer littleEndian = ByteBuffer.allocate(16).order(ByteOrder.LITTLE_ENDIAN);
        littleEndian.putDouble(0, 1.357);
        littleEndian.putDouble(8, 2.468);
        byte[] arr = new byte[littleEndian.remaining()];
        littleEndian.get(arr);
        column.putDoublesLittleEndian(idx, 1, arr, 8);
        column.putDoublesLittleEndian(idx + 1, 1, arr, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)2.468));
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)1.357));
        column.putDoublesLittleEndian(idx += 2, 2, arr, 0);
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)1.357));
        reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)2.468));
        idx += 2;
        while (idx < column.capacity) {
            boolean single = random.nextBoolean();
            if (single) {
                double v2 = random.nextDouble();
                column.putDouble(idx, v2);
                reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)v2));
                ++idx;
                continue;
            }
            int n = package$.MODULE$.min(random.nextInt(column.capacity / 20), column.capacity - idx);
            double v3 = random.nextDouble();
            column.putDoubles(idx, n, v3);
            for (int i = 0; i < n; ++i) {
                reference.$plus$eq((Object)BoxesRunTime.boxToDouble((double)v3));
            }
            idx += n;
        }
        ((IterableOnceOps)reference.zipWithIndex()).foreach((Function1 & Serializable)v -> {
            double $org_scalatest_assert_macro_left = v._1$mcD$sp();
            double $org_scalatest_assert_macro_right = column.getDouble(v._2$mcI$sp());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(19).append("Seed = ").append(seed).append(" VectorType=").append(column.getClass().getSimpleName()).toString(), Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 760));
        });
    }

    public static final /* synthetic */ void $anonfun$new$37(WritableColumnVector column) {
        ArrayBuffer reference = ArrayBuffer$.MODULE$.empty();
        int $org_scalatest_assert_macro_left = column.arrayData().elementsAppended;
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 769));
        String str = "string";
        column.appendByteArray(str.getBytes(StandardCharsets.UTF_8), 0, str.getBytes(StandardCharsets.UTF_8).length);
        reference.$plus$eq((Object)str);
        int $org_scalatest_assert_macro_left2 = column.arrayData().elementsAppended;
        int $org_scalatest_assert_macro_right2 = 6;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 775));
        int idx = column.elementsAppended;
        String[] values = (String[])scala.package$.MODULE$.Nil().$colon$colon((Object)"abc").$colon$colon((Object)"Hello").toArray(ClassTag$.MODULE$.apply(String.class));
        column.putByteArray(idx, values[0].getBytes(StandardCharsets.UTF_8), 0, values[0].getBytes(StandardCharsets.UTF_8).length);
        reference.$plus$eq((Object)values[0]);
        ++idx;
        int $org_scalatest_assert_macro_left3 = column.arrayData().elementsAppended;
        int $org_scalatest_assert_macro_right3 = 11;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 784));
        column.putByteArray(idx, values[1].getBytes(StandardCharsets.UTF_8), 0, values[1].getBytes(StandardCharsets.UTF_8).length);
        reference.$plus$eq((Object)values[1]);
        ++idx;
        int $org_scalatest_assert_macro_left4 = column.arrayData().elementsAppended;
        int $org_scalatest_assert_macro_right4 = 14;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 790));
        int offset = column.putByteArray(idx, values[0].getBytes(StandardCharsets.UTF_8), 2, values[0].getBytes(StandardCharsets.UTF_8).length - 2);
        reference.$plus$eq((Object)"llo");
        ++idx;
        int $org_scalatest_assert_macro_left5 = column.arrayData().elementsAppended;
        int $org_scalatest_assert_macro_right5 = 17;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 797));
        column.putArray(idx, offset, 2);
        reference.$plus$eq((Object)"ll");
        ++idx;
        int $org_scalatest_assert_macro_left6 = column.arrayData().elementsAppended;
        int $org_scalatest_assert_macro_right6 = 17;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 803));
        String s = "abcdefghijklmnopqrstuvwxyz";
        column.putByteArray(idx, new StringBuilder(0).append(s).append(s).toString().getBytes(StandardCharsets.UTF_8));
        reference.$plus$eq((Object)new StringBuilder(0).append(s).append(s).toString());
        ++idx;
        int $org_scalatest_assert_macro_left7 = column.arrayData().elementsAppended;
        int $org_scalatest_assert_macro_right7 = 17 + new StringBuilder(0).append(s).append(s).toString().length();
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 810));
        column.putNull(idx);
        UTF8String $org_scalatest_assert_macro_left8 = column.getUTF8String(idx);
        Object $org_scalatest_assert_macro_right8 = null;
        UTF8String uTF8String = $org_scalatest_assert_macro_left8;
        Object var31_30 = null;
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", null, !(uTF8String != null ? !uTF8String.equals(var31_30) : var31_30 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 813));
        ++idx;
        ((IterableOnceOps)reference.zipWithIndex()).foreach((Function1 & Serializable)v -> {
            String errMsg = new StringBuilder(11).append("VectorType=").append(column.getClass().getSimpleName()).toString();
            String $org_scalatest_assert_macro_left = (String)v._1();
            int $org_scalatest_assert_macro_right = column.getArrayLength(v._2$mcI$sp());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)errMsg, Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 818));
            String $org_scalatest_assert_macro_left2 = (String)v._1();
            String $org_scalatest_assert_macro_right2 = column.getUTF8String(v._2$mcI$sp()).toString();
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)errMsg, Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 819));
        });
        column.reset();
        int $org_scalatest_assert_macro_left9 = column.arrayData().elementsAppended;
        int $org_scalatest_assert_macro_right9 = 0;
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9 == $org_scalatest_assert_macro_right9, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 823));
    }

    public static final /* synthetic */ void $anonfun$new$39(WritableColumnVector column) {
        ArrayBuffer reference = ArrayBuffer$.MODULE$.empty();
        WritableColumnVector months = column.getChild(0);
        WritableColumnVector days = column.getChild(1);
        WritableColumnVector microseconds = column.getChild(2);
        DataType $org_scalatest_assert_macro_left = months.dataType();
        IntegerType$ $org_scalatest_assert_macro_right = IntegerType$.MODULE$;
        DataType dataType = $org_scalatest_assert_macro_left;
        IntegerType$ integerType$ = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(integerType$) : integerType$ != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 833));
        DataType $org_scalatest_assert_macro_left2 = days.dataType();
        IntegerType$ $org_scalatest_assert_macro_right2 = IntegerType$.MODULE$;
        DataType dataType2 = $org_scalatest_assert_macro_left2;
        IntegerType$ integerType$2 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType2 != null ? !dataType2.equals(integerType$2) : integerType$2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 834));
        DataType $org_scalatest_assert_macro_left3 = microseconds.dataType();
        LongType$ $org_scalatest_assert_macro_right3 = LongType$.MODULE$;
        DataType dataType3 = $org_scalatest_assert_macro_left3;
        LongType$ longType$ = $org_scalatest_assert_macro_right3;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(dataType3 != null ? !dataType3.equals(longType$) : longType$ != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 835));
        ((IterableOnceOps)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CalendarInterval[]{new CalendarInterval(1, 10, 100L), new CalendarInterval(0, 0, 2000L), new CalendarInterval(20, 0, 0L), new CalendarInterval(0, 200, 0L)})).zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            CalendarInterval v = (CalendarInterval)tuple2._1();
            int i = tuple2._2$mcI$sp();
            column.putInterval(i, v);
            ArrayBuffer arrayBuffer = (ArrayBuffer)reference.$plus$eq((Object)v);
            return arrayBuffer;
        });
        ((IterableOnceOps)reference.zipWithIndex()).foreach((Function1 & Serializable)x0$2 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                CalendarInterval v = (CalendarInterval)tuple2._1();
                int i = tuple2._2$mcI$sp();
                String errMsg = new StringBuilder(11).append("VectorType=").append(column.getClass().getSimpleName()).toString();
                CalendarInterval $org_scalatest_assert_macro_left = v;
                CalendarInterval $org_scalatest_assert_macro_right = column.getInterval(i);
                CalendarInterval calendarInterval = $org_scalatest_assert_macro_left;
                CalendarInterval calendarInterval2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(calendarInterval != null ? !calendarInterval.equals(calendarInterval2) : calendarInterval2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)errMsg, Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
                if (v == null) {
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(column.isNullAt(i), "column.isNullAt(i)", Prettifier$.MODULE$.default());
                    boxedUnit = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)errMsg, Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 848));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        });
        column.close();
    }

    public static final /* synthetic */ void $anonfun$new$42(ColumnarBatchSuite $this, WritableColumnVector column) {
        WritableColumnVector data = column.arrayData();
        for (int i = 0; i < 6; ++i) {
            data.putInt(i, i);
        }
        column.putArray(0, 0, 1);
        column.putArray(1, 1, 2);
        column.putNull(2);
        column.putArray(3, 3, 0);
        column.putArray(4, 3, 3);
        int $org_scalatest_assert_macro_left = column.getArray(0).numElements();
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 872));
        int $org_scalatest_assert_macro_left2 = column.getArray(1).numElements();
        int $org_scalatest_assert_macro_right2 = 2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 873));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(column.isNullAt(2), "column.isNullAt(2)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 874));
        ColumnarArray $org_scalatest_assert_macro_left3 = column.getArray(2);
        Object $org_scalatest_assert_macro_right3 = null;
        ColumnarArray columnarArray = $org_scalatest_assert_macro_left3;
        Object var14_13 = null;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", null, !(columnarArray != null ? !columnarArray.equals(var14_13) : var14_13 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 875));
        int $org_scalatest_assert_macro_left4 = column.getArray(3).numElements();
        int $org_scalatest_assert_macro_right4 = 0;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 876));
        int $org_scalatest_assert_macro_left5 = column.getArray(4).numElements();
        int $org_scalatest_assert_macro_right5 = 3;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 877));
        int[] a1 = ColumnVectorUtils.toJavaIntArray((ColumnarArray)column.getArray(0));
        int[] a2 = ColumnVectorUtils.toJavaIntArray((ColumnarArray)column.getArray(1));
        int[] a3 = ColumnVectorUtils.toJavaIntArray((ColumnarArray)column.getArray(3));
        int[] a4 = ColumnVectorUtils.toJavaIntArray((ColumnarArray)column.getArray(4));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(a1);
        int[] $org_scalatest_assert_macro_right6 = new int[]{0};
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 883));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = $this.convertToEqualizer(a2);
        int[] $org_scalatest_assert_macro_right7 = new int[]{1, 2};
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 884));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = $this.convertToEqualizer(a3);
        int[] $org_scalatest_assert_macro_right8 = (int[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int());
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 885));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = $this.convertToEqualizer(a4);
        int[] $org_scalatest_assert_macro_right9 = new int[]{3, 4, 5};
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 886));
        int $org_scalatest_assert_macro_left10 = column.getArray(0).getInt(0);
        int $org_scalatest_assert_macro_right10 = 0;
        Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10 == $org_scalatest_assert_macro_right10, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 889));
        int $org_scalatest_assert_macro_left11 = column.getArray(1).getInt(0);
        int $org_scalatest_assert_macro_right11 = 1;
        Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left11), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11 == $org_scalatest_assert_macro_right11, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 891));
        int $org_scalatest_assert_macro_left12 = column.getArray(1).getInt(1);
        int $org_scalatest_assert_macro_right12 = 2;
        Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left12), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12 == $org_scalatest_assert_macro_right12, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 892));
        int $org_scalatest_assert_macro_left13 = column.getArray(4).getInt(0);
        int $org_scalatest_assert_macro_right13 = 3;
        Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left13), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left13 == $org_scalatest_assert_macro_right13, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 894));
        int $org_scalatest_assert_macro_left14 = column.getArray(4).getInt(1);
        int $org_scalatest_assert_macro_right14 = 4;
        Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left14), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left14 == $org_scalatest_assert_macro_right14, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 895));
        int $org_scalatest_assert_macro_left15 = column.getArray(4).getInt(2);
        int $org_scalatest_assert_macro_right15 = 5;
        Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left15), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right15), $org_scalatest_assert_macro_left15 == $org_scalatest_assert_macro_right15, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 896));
        column.reset();
        int[] array = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
        int $org_scalatest_assert_macro_left16 = data.capacity;
        int $org_scalatest_assert_macro_right16 = 10;
        Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left16), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right16), $org_scalatest_assert_macro_left16 == $org_scalatest_assert_macro_right16, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 901));
        data.reserve(array.length);
        int $org_scalatest_assert_macro_left17 = data.capacity;
        int $org_scalatest_assert_macro_right17 = array.length * 2;
        Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left17), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right17), $org_scalatest_assert_macro_left17 == $org_scalatest_assert_macro_right17, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 903));
        data.putInts(0, array.length, array, 0);
        column.putArray(0, 0, array.length);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left18 = $this.convertToEqualizer(ColumnVectorUtils.toJavaIntArray((ColumnarArray)column.getArray(0)));
        int[] $org_scalatest_assert_macro_right18 = array;
        Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left18, "===", (Object)$org_scalatest_assert_macro_right18, $org_scalatest_assert_macro_left18.$eq$eq$eq((Object)$org_scalatest_assert_macro_right18, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 906));
    }

    public static final /* synthetic */ void $anonfun$new$45(WritableColumnVector columnBool$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean v = tuple2._1$mcZ$sp();
        int i = tuple2._2$mcI$sp();
        columnBool$1.arrayData().putBoolean(i, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$46(WritableColumnVector columnByte$1, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        byte v = BoxesRunTime.unboxToByte((Object)tuple2._1());
        int i = tuple2._2$mcI$sp();
        columnByte$1.arrayData().putByte(i, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$47(WritableColumnVector columnShort$1, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        short v = BoxesRunTime.unboxToShort((Object)tuple2._1());
        int i = tuple2._2$mcI$sp();
        columnShort$1.arrayData().putShort(i, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$48(WritableColumnVector columnInt$1, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int v = tuple2._1$mcI$sp();
        int i = tuple2._2$mcI$sp();
        columnInt$1.arrayData().putInt(i, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$49(WritableColumnVector columnLong$1, Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long v = tuple2._1$mcJ$sp();
        int i = tuple2._2$mcI$sp();
        columnLong$1.arrayData().putLong(i, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$50(WritableColumnVector columnFloat$1, Tuple2 x0$8) {
        Tuple2 tuple2 = x0$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        float v = BoxesRunTime.unboxToFloat((Object)tuple2._1());
        int i = tuple2._2$mcI$sp();
        columnFloat$1.arrayData().putFloat(i, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$51(WritableColumnVector columnDouble$1, Tuple2 x0$9) {
        Tuple2 tuple2 = x0$9;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double v = tuple2._1$mcD$sp();
        int i = tuple2._2$mcI$sp();
        columnDouble$1.arrayData().putDouble(i, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$44(ColumnarBatchSuite $this, MemoryMode memMode) {
        int len = 4;
        WritableColumnVector columnBool = $this.allocate(len, (DataType)new ArrayType((DataType)BooleanType$.MODULE$, false), memMode);
        boolean[] boolArray = new boolean[]{false, true, false, true};
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.booleanArrayOps(boolArray))), (Function1 & Serializable)x0$3 -> {
            ColumnarBatchSuite.$anonfun$new$45(columnBool, x0$3);
            return BoxedUnit.UNIT;
        });
        columnBool.putArray(0, 0, len);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(columnBool.getArray(0).toBooleanArray());
        boolean[] $org_scalatest_assert_macro_right = boolArray;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 917));
        columnBool.close();
        WritableColumnVector columnByte = $this.allocate(len, (DataType)new ArrayType((DataType)ByteType$.MODULE$, false), memMode);
        byte[] byteArray = new byte[]{0, 1, 2, 3};
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.byteArrayOps(byteArray))), (Function1 & Serializable)x0$4 -> {
            ColumnarBatchSuite.$anonfun$new$46(columnByte, x0$4);
            return BoxedUnit.UNIT;
        });
        columnByte.putArray(0, 0, len);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(columnByte.getArray(0).toByteArray());
        byte[] $org_scalatest_assert_macro_right2 = byteArray;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 924));
        columnByte.close();
        WritableColumnVector columnShort = $this.allocate(len, (DataType)new ArrayType((DataType)ShortType$.MODULE$, false), memMode);
        short[] shortArray = new short[]{0, 1, 2, 3};
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.shortArrayOps(shortArray))), (Function1 & Serializable)x0$5 -> {
            ColumnarBatchSuite.$anonfun$new$47(columnShort, x0$5);
            return BoxedUnit.UNIT;
        });
        columnShort.putArray(0, 0, len);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(columnShort.getArray(0).toShortArray());
        short[] $org_scalatest_assert_macro_right3 = shortArray;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 931));
        columnShort.close();
        WritableColumnVector columnInt = $this.allocate(len, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), memMode);
        int[] intArray = new int[]{0, 1, 2, 3};
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.intArrayOps(intArray))), (Function1 & Serializable)x0$6 -> {
            ColumnarBatchSuite.$anonfun$new$48(columnInt, x0$6);
            return BoxedUnit.UNIT;
        });
        columnInt.putArray(0, 0, len);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(columnInt.getArray(0).toIntArray());
        int[] $org_scalatest_assert_macro_right4 = intArray;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 938));
        columnInt.close();
        WritableColumnVector columnLong = $this.allocate(len, (DataType)new ArrayType((DataType)LongType$.MODULE$, false), memMode);
        long[] longArray = new long[]{0L, 1L, 2L, 3L};
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.longArrayOps(longArray))), (Function1 & Serializable)x0$7 -> {
            ColumnarBatchSuite.$anonfun$new$49(columnLong, x0$7);
            return BoxedUnit.UNIT;
        });
        columnLong.putArray(0, 0, len);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(columnLong.getArray(0).toLongArray());
        long[] $org_scalatest_assert_macro_right5 = longArray;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 945));
        columnLong.close();
        WritableColumnVector columnFloat = $this.allocate(len, (DataType)new ArrayType((DataType)FloatType$.MODULE$, false), memMode);
        float[] floatArray = new float[]{0.0f, 1.1f, 2.2f, 3.3f};
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.floatArrayOps(floatArray))), (Function1 & Serializable)x0$8 -> {
            ColumnarBatchSuite.$anonfun$new$50(columnFloat, x0$8);
            return BoxedUnit.UNIT;
        });
        columnFloat.putArray(0, 0, len);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(columnFloat.getArray(0).toFloatArray());
        float[] $org_scalatest_assert_macro_right6 = floatArray;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 952));
        columnFloat.close();
        WritableColumnVector columnDouble = $this.allocate(len, (DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), memMode);
        double[] doubleArray = new double[]{0.0, 1.1, 2.2, 3.3};
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.doubleArrayOps(doubleArray))), (Function1 & Serializable)x0$9 -> {
            ColumnarBatchSuite.$anonfun$new$51(columnDouble, x0$9);
            return BoxedUnit.UNIT;
        });
        columnDouble.putArray(0, 0, len);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = $this.convertToEqualizer(columnDouble.getArray(0).toDoubleArray());
        double[] $org_scalatest_assert_macro_right7 = doubleArray;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 959));
        columnDouble.close();
    }

    private static final scala.collection.immutable.Map toScalaMap$1(MapData mapData) {
        IndexedSeq keys = mapData.keyArray().toSeq((DataType)IntegerType$.MODULE$);
        IndexedSeq values = mapData.valueArray().toSeq((DataType)IntegerType$.MODULE$);
        return ((IterableOnceOps)keys.zip((IterableOnce)values)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ void $anonfun$new$53(ColumnarBatchSuite $this, MemoryMode memMode) {
        WritableColumnVector column = $this.allocate(10, (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$, false), memMode);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)colIndex -> {
            WritableColumnVector data = column.getChild(colIndex);
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> data.putInt(i, i * (colIndex + 1)));
        });
        column.putArray(0, 0, 1);
        column.putArray(1, 1, 2);
        column.putNull(2);
        ColumnarMap $org_scalatest_assert_macro_left = column.getMap(2);
        Object $org_scalatest_assert_macro_right = null;
        ColumnarMap columnarMap = $org_scalatest_assert_macro_left;
        Object var6_5 = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", null, !(columnarMap != null ? !columnarMap.equals(var6_5) : var6_5 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 978));
        column.putArray(3, 3, 0);
        column.putArray(4, 3, 3);
        int $org_scalatest_assert_macro_left2 = column.getMap(0).numElements();
        int $org_scalatest_assert_macro_right2 = 1;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 982));
        int $org_scalatest_assert_macro_left3 = column.getMap(1).numElements();
        int $org_scalatest_assert_macro_right3 = 2;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 983));
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(column.isNullAt(2), "column.isNullAt(2)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 984));
        int $org_scalatest_assert_macro_left4 = column.getMap(3).numElements();
        int $org_scalatest_assert_macro_right4 = 0;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 985));
        int $org_scalatest_assert_macro_left5 = column.getMap(4).numElements();
        int $org_scalatest_assert_macro_right5 = 3;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 986));
        Map a1 = ColumnVectorUtils.toJavaIntMap((ColumnarMap)column.getMap(0));
        Map a2 = ColumnVectorUtils.toJavaIntMap((ColumnarMap)column.getMap(1));
        Map a4 = ColumnVectorUtils.toJavaIntMap((ColumnarMap)column.getMap(3));
        Map a5 = ColumnVectorUtils.toJavaIntMap((ColumnarMap)column.getMap(4));
        scala.collection.mutable.Map $org_scalatest_assert_macro_left6 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(a1).asScala();
        scala.collection.immutable.Map $org_scalatest_assert_macro_right6 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)0))}));
        scala.collection.mutable.Map map = $org_scalatest_assert_macro_left6;
        scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right6;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 993));
        scala.collection.mutable.Map $org_scalatest_assert_macro_left7 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(a2).asScala();
        scala.collection.immutable.Map $org_scalatest_assert_macro_right7 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)4))}));
        scala.collection.mutable.Map map3 = $org_scalatest_assert_macro_left7;
        scala.collection.immutable.Map map4 = $org_scalatest_assert_macro_right7;
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 994));
        scala.collection.mutable.Map $org_scalatest_assert_macro_left8 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(a4).asScala();
        scala.collection.immutable.Map $org_scalatest_assert_macro_right8 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map map5 = $org_scalatest_assert_macro_left8;
        scala.collection.immutable.Map map6 = $org_scalatest_assert_macro_right8;
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(map5 != null ? !map5.equals(map6) : map6 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 995));
        scala.collection.mutable.Map $org_scalatest_assert_macro_left9 = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(a5).asScala();
        scala.collection.immutable.Map $org_scalatest_assert_macro_right9 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToInteger((int)6)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)BoxesRunTime.boxToInteger((int)10))}));
        scala.collection.mutable.Map map7 = $org_scalatest_assert_macro_left9;
        scala.collection.immutable.Map map8 = $org_scalatest_assert_macro_right9;
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right9, !(map7 != null ? !map7.equals(map8) : map8 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 996));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = $this.convertToEqualizer(ColumnarBatchSuite.toScalaMap$1(column.getMap(0).copy()));
        scala.collection.immutable.Map $org_scalatest_assert_macro_right10 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)0))}));
        Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1003));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = $this.convertToEqualizer(ColumnarBatchSuite.toScalaMap$1(column.getMap(1).copy()));
        scala.collection.immutable.Map $org_scalatest_assert_macro_right11 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)4))}));
        Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1004));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = $this.convertToEqualizer(ColumnarBatchSuite.toScalaMap$1(column.getMap(3).copy()));
        scala.collection.immutable.Map $org_scalatest_assert_macro_right12 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1005));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = $this.convertToEqualizer(ColumnarBatchSuite.toScalaMap$1(column.getMap(4).copy()));
        scala.collection.immutable.Map $org_scalatest_assert_macro_right13 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToInteger((int)6)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)BoxesRunTime.boxToInteger((int)10))}));
        Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)$org_scalatest_assert_macro_right13, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1006));
        column.close();
    }

    public static final /* synthetic */ void $anonfun$new$56(WritableColumnVector column) {
        WritableColumnVector c1 = column.getChild(0);
        WritableColumnVector c2 = column.getChild(1);
        DataType $org_scalatest_assert_macro_left = c1.dataType();
        IntegerType$ $org_scalatest_assert_macro_right = IntegerType$.MODULE$;
        DataType dataType = $org_scalatest_assert_macro_left;
        IntegerType$ integerType$ = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(integerType$) : integerType$ != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1018));
        DataType $org_scalatest_assert_macro_left2 = c2.dataType();
        DoubleType$ $org_scalatest_assert_macro_right2 = DoubleType$.MODULE$;
        DataType dataType2 = $org_scalatest_assert_macro_left2;
        DoubleType$ doubleType$ = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType2 != null ? !dataType2.equals(doubleType$) : doubleType$ != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1019));
        c1.putInt(0, 123);
        c2.putDouble(0, 3.45);
        column.putNull(1);
        ColumnarRow $org_scalatest_assert_macro_left3 = column.getStruct(1);
        Object $org_scalatest_assert_macro_right3 = null;
        ColumnarRow columnarRow = $org_scalatest_assert_macro_left3;
        Object var14_13 = null;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", null, !(columnarRow != null ? !columnarRow.equals(var14_13) : var14_13 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1025));
        c1.putInt(2, 456);
        c2.putDouble(2, 5.67);
        ColumnarRow s = column.getStruct(0);
        int $org_scalatest_assert_macro_left4 = s.getInt(0);
        int $org_scalatest_assert_macro_right4 = 123;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1031));
        double $org_scalatest_assert_macro_left5 = s.getDouble(1);
        double $org_scalatest_assert_macro_right5 = 3.45;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1032));
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(column.isNullAt(1), "column.isNullAt(1)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1034));
        ColumnarRow $org_scalatest_assert_macro_left6 = column.getStruct(1);
        Object $org_scalatest_assert_macro_right6 = null;
        ColumnarRow columnarRow2 = $org_scalatest_assert_macro_left6;
        Object var28_25 = null;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", null, !(columnarRow2 != null ? !columnarRow2.equals(var28_25) : var28_25 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1035));
        ColumnarRow s2 = column.getStruct(2);
        int $org_scalatest_assert_macro_left7 = s2.getInt(0);
        int $org_scalatest_assert_macro_right7 = 456;
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1038));
        double $org_scalatest_assert_macro_left8 = s2.getDouble(1);
        double $org_scalatest_assert_macro_right8 = 5.67;
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left8), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 == $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1039));
    }

    public static final /* synthetic */ void $anonfun$new$57(ColumnarBatchSuite $this, WritableColumnVector column) {
        WritableColumnVector childColumn = column.arrayData();
        WritableColumnVector data = column.arrayData().arrayData();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x0$10 -> {
            int n = x0$10;
            switch (n) {
                case 3: {
                    data.putNull(3);
                    break;
                }
                default: {
                    data.putInt(n, n);
                    break;
                }
            }
        });
        childColumn.putArray(0, 0, 1);
        childColumn.putArray(1, 1, 2);
        childColumn.putArray(2, 2, 0);
        childColumn.putArray(3, 3, 3);
        column.putArray(0, 0, 1);
        column.putArray(1, 1, 2);
        column.putArray(2, 2, 2);
        column.putNull(3);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(column.getArray(0).getArray(0).toIntArray());
        int[] $org_scalatest_assert_macro_right = new int[]{0};
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1061));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(column.getArray(1).getArray(0).toIntArray());
        int[] $org_scalatest_assert_macro_right2 = new int[]{1, 2};
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1062));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(column.getArray(1).getArray(1).toIntArray());
        Object[] $org_scalatest_assert_macro_right3 = (Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing());
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1063));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(column.getArray(2).getArray(0).toIntArray());
        Object[] $org_scalatest_assert_macro_right4 = (Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing());
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1064));
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(column.getArray(2).getArray(1).isNullAt(0), "column.getArray(2).getArray(1).isNullAt(0)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1065));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)column.getArray(2).getArray(1).getInt(1)));
        int $org_scalatest_assert_macro_right5 = 4;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1066));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)column.getArray(2).getArray(1).getInt(2)));
        int $org_scalatest_assert_macro_right6 = 5;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1067));
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(column.isNullAt(3), "column.isNullAt(3)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1068));
    }

    public static final /* synthetic */ void $anonfun$new$59(ColumnarBatchSuite $this, WritableColumnVector column) {
        WritableColumnVector data = column.arrayData();
        WritableColumnVector c0 = data.getChild(0);
        WritableColumnVector c1 = data.getChild(1);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            c0.putInt(i, i);
            c1.putLong(i, (long)(i * 10));
        });
        column.putArray(0, 0, 2);
        column.putArray(1, 1, 3);
        column.putArray(2, 4, 2);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(column.getArray(0).getStruct(0, 2).toSeq($this.structType()));
        Seq $org_scalatest_assert_macro_right = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 0}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1091));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(column.getArray(0).getStruct(1, 2).toSeq($this.structType()));
        Seq $org_scalatest_assert_macro_right2 = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 10}));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1092));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(column.getArray(1).getStruct(0, 2).toSeq($this.structType()));
        Seq $org_scalatest_assert_macro_right3 = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 10}));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1093));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(column.getArray(1).getStruct(1, 2).toSeq($this.structType()));
        Seq $org_scalatest_assert_macro_right4 = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 20}));
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1094));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(column.getArray(1).getStruct(2, 2).toSeq($this.structType()));
        Seq $org_scalatest_assert_macro_right5 = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 30}));
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1095));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(column.getArray(2).getStruct(0, 2).toSeq($this.structType()));
        Seq $org_scalatest_assert_macro_right6 = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 40}));
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1096));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = $this.convertToEqualizer(column.getArray(2).getStruct(1, 2).toSeq($this.structType()));
        Seq $org_scalatest_assert_macro_right7 = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 50}));
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1097));
    }

    public static final /* synthetic */ void $anonfun$new$61(ColumnarBatchSuite $this, WritableColumnVector column) {
        WritableColumnVector c0 = column.getChild(0);
        WritableColumnVector c1 = column.getChild(1);
        c0.putInt(0, 0);
        c0.putInt(1, 1);
        c0.putInt(2, 2);
        WritableColumnVector c1Child = c1.arrayData();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> c1Child.putInt(i, i));
        c1.putArray(0, 0, 2);
        c1.putArray(1, 2, 1);
        c1.putArray(2, 3, 3);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)column.getStruct(0).getInt(0)));
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1120));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(column.getStruct(0).getArray(1).toIntArray());
        int[] $org_scalatest_assert_macro_right2 = new int[]{0, 1};
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1121));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)column.getStruct(1).getInt(0)));
        int $org_scalatest_assert_macro_right3 = 1;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1122));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(column.getStruct(1).getArray(1).toIntArray());
        int[] $org_scalatest_assert_macro_right4 = new int[]{2};
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1123));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)column.getStruct(2).getInt(0)));
        int $org_scalatest_assert_macro_right5 = 2;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1124));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(column.getStruct(2).getArray(1).toIntArray());
        int[] $org_scalatest_assert_macro_right6 = new int[]{3, 4, 5};
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1125));
    }

    public static final /* synthetic */ void $anonfun$new$63(ColumnarBatchSuite $this, WritableColumnVector column) {
        WritableColumnVector c0 = column.getChild(0);
        WritableColumnVector c1 = column.getChild(1);
        c0.putInt(0, 0);
        c0.putInt(1, 1);
        c0.putInt(2, 2);
        WritableColumnVector c1c0 = c1.getChild(0);
        WritableColumnVector c1c1 = c1.getChild(1);
        c1c0.putInt(0, 7);
        c1c0.putInt(1, 8);
        c1c0.putInt(2, 9);
        c1c1.putInt(0, 70);
        c1c1.putInt(1, 80);
        c1c1.putInt(2, 90);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)column.getStruct(0).getInt(0)));
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1150));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(column.getStruct(0).getStruct(1, 2).toSeq($this.subSchema()));
        Seq $org_scalatest_assert_macro_right2 = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 70}));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1151));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)column.getStruct(1).getInt(0)));
        int $org_scalatest_assert_macro_right3 = 1;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1152));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(column.getStruct(1).getStruct(1, 2).toSeq($this.subSchema()));
        Seq $org_scalatest_assert_macro_right4 = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{8, 80}));
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1153));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)column.getStruct(2).getInt(0)));
        int $org_scalatest_assert_macro_right5 = 2;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1154));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(column.getStruct(2).getStruct(1, 2).toSeq($this.subSchema()));
        Seq $org_scalatest_assert_macro_right6 = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{9, 90}));
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1155));
    }

    private static final void rowEquals$1(InternalRow x, Row y) {
        block6: {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            boolean $org_scalatest_assert_macro_left = x.isNullAt(0);
            boolean $org_scalatest_assert_macro_right = y.isNullAt(0);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1228));
            if (!x.isNullAt(0)) {
                int $org_scalatest_assert_macro_left2 = x.getInt(0);
                int $org_scalatest_assert_macro_right2 = y.getInt(0);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                boxedUnit3 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1229));
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            boolean $org_scalatest_assert_macro_left3 = x.isNullAt(1);
            boolean $org_scalatest_assert_macro_right3 = y.isNullAt(1);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1231));
            if (!x.isNullAt(1)) {
                double $org_scalatest_assert_macro_left4 = x.getDouble(1);
                double $org_scalatest_assert_macro_right4 = y.getDouble(1);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
                boxedUnit2 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1232));
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            boolean $org_scalatest_assert_macro_left5 = x.isNullAt(2);
            boolean $org_scalatest_assert_macro_right5 = y.isNullAt(2);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1234));
            if (!x.isNullAt(2)) {
                int $org_scalatest_assert_macro_left6 = x.getInt(2);
                int $org_scalatest_assert_macro_right6 = y.getInt(2);
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
                boxedUnit = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1235));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            boolean $org_scalatest_assert_macro_left7 = x.isNullAt(3);
            boolean $org_scalatest_assert_macro_right7 = y.isNullAt(3);
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1237));
            if (x.isNullAt(3)) break block6;
            String $org_scalatest_assert_macro_left8 = x.getString(3);
            String $org_scalatest_assert_macro_right8 = y.getString(3);
            String string = $org_scalatest_assert_macro_left8;
            String string2 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1238));
        }
    }

    public static final /* synthetic */ void $anonfun$new$65(ColumnarBatchSuite $this, MemoryMode memMode) {
        StructType schema = new StructType().add("intCol", (DataType)IntegerType$.MODULE$).add("doubleCol", (DataType)DoubleType$.MODULE$).add("intCol2", (DataType)IntegerType$.MODULE$).add("string", (DataType)BinaryType$.MODULE$);
        int capacity = 4096;
        WritableColumnVector[] columns = (WritableColumnVector[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)field -> $this.allocate(capacity, field.dataType(), memMode), ClassTag$.MODULE$.apply(WritableColumnVector.class));
        ColumnarBatch batch = new ColumnarBatch((ColumnVector[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])columns), ClassTag$.MODULE$.apply(ColumnVector.class)));
        int $org_scalatest_assert_macro_left = batch.numCols();
        int $org_scalatest_assert_macro_right = 4;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1171));
        int $org_scalatest_assert_macro_left2 = batch.numRows();
        int $org_scalatest_assert_macro_right2 = 0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1172));
        boolean $org_scalatest_assert_macro_left3 = batch.rowIterator().hasNext();
        boolean $org_scalatest_assert_macro_right3 = false;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1173));
        columns[0].putInt(0, 1);
        columns[1].putDouble(0, 1.1);
        columns[2].putNull(0);
        columns[3].putByteArray(0, "Hello".getBytes(StandardCharsets.UTF_8));
        batch.setNumRows(1);
        int $org_scalatest_assert_macro_left4 = batch.numCols();
        int $org_scalatest_assert_macro_right4 = 4;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1183));
        int $org_scalatest_assert_macro_left5 = batch.numRows();
        int $org_scalatest_assert_macro_right5 = 1;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1184));
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(batch.rowIterator().hasNext(), "batch.rowIterator().hasNext()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1185));
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(batch.rowIterator().hasNext(), "batch.rowIterator().hasNext()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1186));
        int $org_scalatest_assert_macro_left6 = columns[0].getInt(0);
        int $org_scalatest_assert_macro_right6 = 1;
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1188));
        boolean $org_scalatest_assert_macro_left7 = columns[0].isNullAt(0);
        boolean $org_scalatest_assert_macro_right7 = false;
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1189));
        double $org_scalatest_assert_macro_left8 = columns[1].getDouble(0);
        double $org_scalatest_assert_macro_right8 = 1.1;
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left8), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 == $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1190));
        boolean $org_scalatest_assert_macro_left9 = columns[1].isNullAt(0);
        boolean $org_scalatest_assert_macro_right9 = false;
        Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left9), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9 == $org_scalatest_assert_macro_right9, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1191));
        Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(columns[2].isNullAt(0), "columns.apply(2).isNullAt(0)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1192));
        String $org_scalatest_assert_macro_left10 = columns[3].getUTF8String(0).toString();
        String $org_scalatest_assert_macro_right10 = "Hello";
        String string = $org_scalatest_assert_macro_left10;
        String string2 = $org_scalatest_assert_macro_right10;
        Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right10, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1193));
        java.util.Iterator it = batch.rowIterator();
        Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(it.hasNext(), "it.hasNext()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1197));
        InternalRow row = (InternalRow)it.next();
        int $org_scalatest_assert_macro_left11 = row.getInt(0);
        int $org_scalatest_assert_macro_right11 = 1;
        Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left11), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11 == $org_scalatest_assert_macro_right11, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1199));
        boolean $org_scalatest_assert_macro_left12 = row.isNullAt(0);
        boolean $org_scalatest_assert_macro_right12 = false;
        Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left12), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12 == $org_scalatest_assert_macro_right12, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1200));
        double $org_scalatest_assert_macro_left13 = row.getDouble(1);
        double $org_scalatest_assert_macro_right13 = 1.1;
        Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left13), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left13 == $org_scalatest_assert_macro_right13, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1201));
        boolean $org_scalatest_assert_macro_left14 = row.isNullAt(1);
        boolean $org_scalatest_assert_macro_right14 = false;
        Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left14), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left14 == $org_scalatest_assert_macro_right14, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1202));
        Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.simpleMacroBool(row.isNullAt(2), "row.isNullAt(2)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1203));
        String $org_scalatest_assert_macro_left15 = columns[3].getUTF8String(0).toString();
        String $org_scalatest_assert_macro_right15 = "Hello";
        String string3 = $org_scalatest_assert_macro_left15;
        String string4 = $org_scalatest_assert_macro_right15;
        Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "==", (Object)$org_scalatest_assert_macro_right15, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1204));
        boolean $org_scalatest_assert_macro_left16 = it.hasNext();
        boolean $org_scalatest_assert_macro_right16 = false;
        Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left16), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right16), $org_scalatest_assert_macro_left16 == $org_scalatest_assert_macro_right16, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1205));
        boolean $org_scalatest_assert_macro_left17 = it.hasNext();
        boolean $org_scalatest_assert_macro_right17 = false;
        Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left17), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right17), $org_scalatest_assert_macro_left17 == $org_scalatest_assert_macro_right17, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1206));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)x$13 -> {
            x$13.reset();
            return BoxedUnit.UNIT;
        });
        columns[0].putNull(0);
        columns[1].putDouble(0, 2.2);
        columns[2].putInt(0, 2);
        columns[3].putByteArray(0, "abc".getBytes(StandardCharsets.UTF_8));
        columns[0].putInt(1, 3);
        columns[1].putNull(1);
        columns[2].putInt(1, 3);
        columns[3].putByteArray(1, "".getBytes(StandardCharsets.UTF_8));
        columns[0].putInt(2, 4);
        columns[1].putDouble(2, 4.4);
        columns[2].putInt(2, 4);
        columns[3].putByteArray(2, "world".getBytes(StandardCharsets.UTF_8));
        batch.setNumRows(3);
        int $org_scalatest_assert_macro_left18 = batch.numRows();
        int $org_scalatest_assert_macro_right18 = 3;
        Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left18), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right18), $org_scalatest_assert_macro_left18 == $org_scalatest_assert_macro_right18, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1242));
        java.util.Iterator it2 = batch.rowIterator();
        ColumnarBatchSuite.rowEquals$1((InternalRow)it2.next(), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)2.2), BoxesRunTime.boxToInteger((int)2), "abc"})));
        ColumnarBatchSuite.rowEquals$1((InternalRow)it2.next(), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, BoxesRunTime.boxToInteger((int)3), ""})));
        ColumnarBatchSuite.rowEquals$1((InternalRow)it2.next(), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToDouble((double)4.4), BoxesRunTime.boxToInteger((int)4), "world"})));
        Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(it.hasNext(), "it.hasNext()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1247));
        batch.close();
    }

    private static final void rowEquals$2(InternalRow x, Row y) {
        block6: {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            boolean $org_scalatest_assert_macro_left = x.isNullAt(0);
            boolean $org_scalatest_assert_macro_right = y.isNullAt(0);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1303));
            if (!x.isNullAt(0)) {
                int $org_scalatest_assert_macro_left2 = x.getInt(0);
                int $org_scalatest_assert_macro_right2 = y.getInt(0);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                boxedUnit3 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1304));
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            boolean $org_scalatest_assert_macro_left3 = x.isNullAt(1);
            boolean $org_scalatest_assert_macro_right3 = y.isNullAt(1);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1306));
            if (!x.isNullAt(1)) {
                double $org_scalatest_assert_macro_left4 = x.getDouble(1);
                double $org_scalatest_assert_macro_right4 = y.getDouble(1);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
                boxedUnit2 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1307));
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            boolean $org_scalatest_assert_macro_left5 = x.isNullAt(2);
            boolean $org_scalatest_assert_macro_right5 = y.isNullAt(2);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1309));
            if (!x.isNullAt(2)) {
                int $org_scalatest_assert_macro_left6 = x.getInt(2);
                int $org_scalatest_assert_macro_right6 = y.getInt(2);
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
                boxedUnit = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1310));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            boolean $org_scalatest_assert_macro_left7 = x.isNullAt(3);
            boolean $org_scalatest_assert_macro_right7 = y.isNullAt(3);
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1312));
            if (x.isNullAt(3)) break block6;
            String $org_scalatest_assert_macro_left8 = x.getString(3);
            String $org_scalatest_assert_macro_right8 = y.getString(3);
            String string = $org_scalatest_assert_macro_left8;
            String string2 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1313));
        }
    }

    public static final /* synthetic */ void $anonfun$new$69(ColumnarBatchSuite $this, MemoryMode memMode) {
        StructType schema = new StructType().add("intCol", (DataType)IntegerType$.MODULE$).add("doubleCol", (DataType)DoubleType$.MODULE$).add("intCol2", (DataType)IntegerType$.MODULE$).add("string", (DataType)BinaryType$.MODULE$);
        int capacity = 4096;
        WritableColumnVector[] columns = (WritableColumnVector[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)field -> $this.allocate(capacity, field.dataType(), memMode), ClassTag$.MODULE$.apply(WritableColumnVector.class));
        CustomizedColumnarBatch batch = new CustomizedColumnarBatch($this, (ColumnVector[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])columns), ClassTag$.MODULE$.apply(ColumnVector.class)));
        int $org_scalatest_assert_macro_left = batch.numCols();
        int $org_scalatest_assert_macro_right = 4;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1266));
        int $org_scalatest_assert_macro_left2 = batch.numRows();
        int $org_scalatest_assert_macro_right2 = 0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1267));
        boolean $org_scalatest_assert_macro_left3 = batch.rowIterator().hasNext();
        boolean $org_scalatest_assert_macro_right3 = false;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1268));
        columns[0].putInt(0, 1);
        columns[1].putDouble(0, 1.1);
        columns[2].putNull(0);
        columns[3].putByteArray(0, "Hello".getBytes(StandardCharsets.UTF_8));
        batch.setNumRows(1);
        int $org_scalatest_assert_macro_left4 = batch.numCols();
        int $org_scalatest_assert_macro_right4 = 4;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1278));
        int $org_scalatest_assert_macro_left5 = batch.numRows();
        int $org_scalatest_assert_macro_right5 = 1;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1279));
        boolean $org_scalatest_assert_macro_left6 = batch.rowIterator().hasNext();
        boolean $org_scalatest_assert_macro_right6 = false;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1281));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)x$14 -> {
            x$14.reset();
            return BoxedUnit.UNIT;
        });
        columns[0].putNull(0);
        columns[1].putDouble(0, 2.2);
        columns[2].putInt(0, 2);
        columns[3].putByteArray(0, "abc".getBytes(StandardCharsets.UTF_8));
        columns[0].putInt(1, 3);
        columns[1].putNull(1);
        columns[2].putInt(1, 3);
        columns[3].putByteArray(1, "".getBytes(StandardCharsets.UTF_8));
        columns[0].putInt(2, 4);
        columns[1].putDouble(2, 4.4);
        columns[2].putInt(2, 4);
        columns[3].putByteArray(2, "world".getBytes(StandardCharsets.UTF_8));
        batch.setNumRows(3);
        int $org_scalatest_assert_macro_left7 = batch.numRows();
        int $org_scalatest_assert_macro_right7 = 3;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1317));
        java.util.Iterator<InternalRow> it2 = batch.rowIterator();
        ColumnarBatchSuite.rowEquals$2(it2.next(), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, BoxesRunTime.boxToInteger((int)3), ""})));
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(it2.hasNext(), "it2.hasNext()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1321));
        batch.close();
    }

    public static final /* synthetic */ void $anonfun$new$73(ColumnarBatchSuite $this, MemoryMode memMode) {
        Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)2L), "a", BoxesRunTime.boxToDouble((double)1.2), BoxesRunTime.boxToByte((byte)((byte)98))}));
        Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToLong((long)5L), "cd", BoxesRunTime.boxToDouble((double)2.3), BoxesRunTime.boxToByte((byte)((byte)97))}));
        List rows = scala.package$.MODULE$.Nil().$colon$colon((Object)row2).$colon$colon((Object)row);
        StructType schema = new StructType().add("i1", (DataType)IntegerType$.MODULE$).add("l2", (DataType)LongType$.MODULE$).add("string", (DataType)StringType$.MODULE$).add("d", (DataType)DoubleType$.MODULE$).add("b", (DataType)ByteType$.MODULE$);
        ColumnarBatch batch = ColumnVectorUtils.toBatch((StructType)schema, (MemoryMode)memMode, (java.util.Iterator)((java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(rows.iterator()).asJava()));
        int $org_scalatest_assert_macro_left = batch.numRows();
        int $org_scalatest_assert_macro_right = 2;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1499));
        int $org_scalatest_assert_macro_left2 = batch.numCols();
        int $org_scalatest_assert_macro_right2 = 5;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1500));
        java.util.Iterator it = batch.rowIterator();
        Iterator referenceIt = rows.iterator();
        while (it.hasNext()) {
            $this.compareStruct((Seq<StructField>)schema, (InternalRow)it.next(), (Row)referenceIt.next(), 0L);
        }
        batch.close();
    }

    public static final /* synthetic */ void $anonfun$testRandomRows$1(ColumnarBatchSuite $this, StructType schema$1, ArrayBuffer rows$1, int NUM_ROWS$1, long seed$9, MemoryMode memMode) {
        ColumnarBatch batch = ColumnVectorUtils.toBatch((StructType)schema$1, (MemoryMode)memMode, (java.util.Iterator)((java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(rows$1.iterator()).asJava()));
        int $org_scalatest_assert_macro_left = batch.numRows();
        int $org_scalatest_assert_macro_right = NUM_ROWS$1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1542));
        java.util.Iterator it = batch.rowIterator();
        Iterator referenceIt = rows$1.iterator();
        int k = 0;
        while (it.hasNext()) {
            $this.compareStruct((Seq<StructField>)schema$1, (InternalRow)it.next(), (Row)referenceIt.next(), seed$9);
            ++k;
        }
        batch.close();
    }

    public static final /* synthetic */ Assertion $anonfun$new$85(RowToColumnConverter converter$1, OnHeapColumnVector[] columns$1, int i) {
        GenericInternalRow row = new GenericInternalRow(new Object[]{BoxesRunTime.boxToInteger((int)i)});
        converter$1.convert((InternalRow)row, (WritableColumnVector[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])columns$1), ClassTag$.MODULE$.apply(WritableColumnVector.class)));
        int $org_scalatest_assert_macro_left = columns$1[0].getInt(i);
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1869));
    }

    public static final /* synthetic */ Assertion $anonfun$new$88(RowToColumnConverter converter$2, OnHeapColumnVector[] columns$2, int i) {
        GenericInternalRow row = new GenericInternalRow(new Object[]{BoxesRunTime.boxToLong((long)i)});
        converter$2.convert((InternalRow)row, (WritableColumnVector[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])columns$2), ClassTag$.MODULE$.apply(WritableColumnVector.class)));
        long $org_scalatest_assert_macro_left = columns$2[0].getLong(i);
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1886));
    }

    public static final /* synthetic */ void $anonfun$new$90(WritableColumnVector column) {
        ArrayBuffer reference = ArrayBuffer$.MODULE$.empty();
        int idx = 0;
        column.putDecimal(idx, new Decimal().set(10), 10);
        reference.$plus$eq((Object)new Decimal().set(10));
        column.putDecimal(++idx, new Decimal().set(20), 10);
        reference.$plus$eq((Object)new Decimal().set(20));
        column.putNull(++idx);
        Decimal $org_scalatest_assert_macro_left = column.getDecimal(idx, 10, 0);
        Object $org_scalatest_assert_macro_right = null;
        Decimal decimal = $org_scalatest_assert_macro_left;
        Object var6_5 = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", null, !(decimal != null ? !decimal.equals(var6_5) : var6_5 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1911));
        reference.$plus$eq(null);
        column.putDecimal(++idx, new Decimal().set(30), 10);
        reference.$plus$eq((Object)new Decimal().set(30));
        ((IterableOnceOps)reference.zipWithIndex()).foreach((Function1 & Serializable)x0$12 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$12;
            if (tuple2 != null) {
                Decimal v = (Decimal)tuple2._1();
                int i = tuple2._2$mcI$sp();
                String errMsg = new StringBuilder(11).append("VectorType=").append(column.getClass().getSimpleName()).toString();
                Decimal $org_scalatest_assert_macro_left = v;
                Decimal $org_scalatest_assert_macro_right = column.getDecimal(i, 10, 0);
                Decimal decimal = $org_scalatest_assert_macro_left;
                Decimal decimal2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(decimal != null ? !decimal.equals(decimal2) : decimal2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)errMsg, Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1920));
                if (v == null) {
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(column.isNullAt(i), "column.isNullAt(i)", Prettifier$.MODULE$.default());
                    boxedUnit = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)errMsg, Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1921));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        });
        column.close();
    }

    public static final /* synthetic */ void $anonfun$new$92(WritableColumnVector column) {
        ArrayBuffer reference = ArrayBuffer$.MODULE$.empty();
        int idx = 0;
        column.putByteArray(idx, "Hello".getBytes(StandardCharsets.UTF_8));
        reference.$plus$eq((Object)"Hello");
        column.putByteArray(++idx, "World".getBytes(StandardCharsets.UTF_8));
        reference.$plus$eq((Object)"World");
        column.putNull(++idx);
        reference.$plus$eq(null);
        column.putByteArray(++idx, "abc".getBytes(StandardCharsets.UTF_8));
        reference.$plus$eq((Object)"abc");
        ((IterableOnceOps)reference.zipWithIndex()).foreach((Function1 & Serializable)x0$13 -> {
            Assertion assertion;
            Tuple2 tuple2 = x0$13;
            if (tuple2 != null) {
                String v = (String)tuple2._1();
                int i = tuple2._2$mcI$sp();
                String errMsg = new StringBuilder(11).append("VectorType=").append(column.getClass().getSimpleName()).toString();
                if (v != null) {
                    String $org_scalatest_assert_macro_left = v;
                    String $org_scalatest_assert_macro_right = new String(column.getBinary(i));
                    String string = $org_scalatest_assert_macro_left;
                    String string2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)errMsg, Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1950));
                } else {
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(column.isNullAt(i), "column.isNullAt(i)", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)errMsg, Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1952));
                    byte[] $org_scalatest_assert_macro_left = column.getBinary(i);
                    Object $org_scalatest_assert_macro_right = null;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", null, $org_scalatest_assert_macro_left == null, Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)errMsg, Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1953));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Assertion assertion2 = assertion;
            return assertion2;
        });
        column.close();
    }

    public static final /* synthetic */ Assertion $anonfun$new$96(ColumnarBatchSuite $this, ColumnarBatchRow bachRow$1, TimestampNTZType$ dt$2, int i) {
        bachRow$1.rowId = i;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(bachRow$1.get(0, (DataType)dt$2));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1969));
        InternalRow batchRowCopy = bachRow$1.copy();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(batchRowCopy.get(0, (DataType)dt$2));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1971));
    }

    public static final /* synthetic */ void $anonfun$new$94(ColumnarBatchSuite $this, WritableColumnVector column) {
        TimestampNTZType$ dt = TimestampNTZType$.MODULE$;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> column.putLong(i, (long)i));
        ColumnarBatchRow bachRow = new ColumnarBatchRow((ColumnVector[])((Object[])new ColumnVector[]{column}));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnarBatchSuite.$anonfun$new$96($this, bachRow, dt, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ void $anonfun$new$97(ColumnarBatchSuite $this, WritableColumnVector column) {
        RuntimeException ex = (RuntimeException)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> column.reserve(-1), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1977));
        String $org_scalatest_assert_macro_left = ex.getMessage();
        String $org_scalatest_assert_macro_right = "Cannot reserve additional contiguous bytes in the vectorized reader (integer overflow)";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1978));
    }

    public static final /* synthetic */ Assertion $anonfun$new$102(ColumnarBatchSuite $this, ColumnarBatchRow bachRow$2, YearMonthIntervalType dt$3, int i) {
        bachRow$2.rowId = i;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(bachRow$2.get(0, (DataType)dt$3));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1991));
        InternalRow batchRowCopy = bachRow$2.copy();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(batchRowCopy.get(0, (DataType)dt$3));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1993));
    }

    public static final /* synthetic */ void $anonfun$new$100(ColumnarBatchSuite $this, YearMonthIntervalType dt$3, WritableColumnVector column) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> column.putInt(i, i));
        ColumnarBatchRow bachRow = new ColumnarBatchRow((ColumnVector[])((Object[])new ColumnVector[]{column}));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnarBatchSuite.$anonfun$new$102($this, bachRow, dt$3, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$106(ColumnarBatchSuite $this, ColumnarBatchRow bachRow$3, DayTimeIntervalType dt$4, int i) {
        bachRow$3.rowId = i;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(bachRow$3.get(0, (DataType)dt$4));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2007));
        InternalRow batchRowCopy = bachRow$3.copy();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(batchRowCopy.get(0, (DataType)dt$4));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2009));
    }

    public static final /* synthetic */ void $anonfun$new$104(ColumnarBatchSuite $this, DayTimeIntervalType dt$4, WritableColumnVector column) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> column.putLong(i, (long)i));
        ColumnarBatchRow bachRow = new ColumnarBatchRow((ColumnVector[])((Object[])new ColumnVector[]{column}));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnarBatchSuite.$anonfun$new$106($this, bachRow, dt$4, BoxesRunTime.unboxToInt((Object)i)));
    }

    public ColumnarBatchSuite() {
        this.testVector("Null APIs", 1024, (DataType)IntegerType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$1(column);
            return BoxedUnit.UNIT;
        });
        this.testVector("Boolean APIs", 1024, (DataType)BooleanType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$5(column);
            return BoxedUnit.UNIT;
        });
        this.testVector("Byte APIs", 1024, (DataType)ByteType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$11(column);
            return BoxedUnit.UNIT;
        });
        this.testVector("Short APIs", 1024, (DataType)ShortType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$16(column);
            return BoxedUnit.UNIT;
        });
        this.testVector("Int APIs", 1024, (DataType)IntegerType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$21(column);
            return BoxedUnit.UNIT;
        });
        this.testVector("Long APIs", 1024, (DataType)LongType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$24(column);
            return BoxedUnit.UNIT;
        });
        this.testVector("Float APIs", 1024, (DataType)FloatType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$27(column);
            return BoxedUnit.UNIT;
        });
        this.testVector("[SPARK-31703] Float API - Little Endian", 1024, (DataType)FloatType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$30(column);
            return BoxedUnit.UNIT;
        });
        this.testVector("Double APIs", 1024, (DataType)DoubleType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$32(column);
            return BoxedUnit.UNIT;
        });
        this.testVector("[SPARK-31703] Double API - Little Endian", 1024, (DataType)DoubleType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$35(column);
            return BoxedUnit.UNIT;
        });
        this.testVector("String APIs", 7, (DataType)StringType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$37(column);
            return BoxedUnit.UNIT;
        });
        this.testVector("CalendarInterval APIs", 5, (DataType)CalendarIntervalType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$39(column);
            return BoxedUnit.UNIT;
        });
        this.testVector("Int Array", 10, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$42(this, column);
            return BoxedUnit.UNIT;
        });
        this.test("toArray for primitive types", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> scala.package$.MODULE$.Nil().$colon$colon((Object)MemoryMode.OFF_HEAP).$colon$colon((Object)MemoryMode.ON_HEAP).foreach((Function1 & Serializable)memMode -> {
            ColumnarBatchSuite.$anonfun$new$44(this, memMode);
            return BoxedUnit.UNIT;
        }), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 909));
        this.test("Int Map", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> scala.package$.MODULE$.Nil().$colon$colon((Object)MemoryMode.OFF_HEAP).$colon$colon((Object)MemoryMode.ON_HEAP).foreach((Function1 & Serializable)memMode -> {
            ColumnarBatchSuite.$anonfun$new$53(this, memMode);
            return BoxedUnit.UNIT;
        }), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 964));
        this.testVector("Struct Column", 10, (DataType)new StructType().add("int", (DataType)IntegerType$.MODULE$).add("double", (DataType)DoubleType$.MODULE$), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$56(column);
            return BoxedUnit.UNIT;
        });
        this.testVector("Nest Array in Array", 10, (DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$57(this, column);
            return BoxedUnit.UNIT;
        });
        this.structType = new StructType().add("i", (DataType)IntegerType$.MODULE$).add("l", (DataType)LongType$.MODULE$);
        this.testVector("Nest Struct in Array", 10, (DataType)new ArrayType((DataType)this.structType(), true), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$59(this, column);
            return BoxedUnit.UNIT;
        });
        this.testVector("Nest Array in Struct", 10, (DataType)new StructType().add("int", (DataType)IntegerType$.MODULE$).add("array", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true)), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$61(this, column);
            return BoxedUnit.UNIT;
        });
        this.subSchema = new StructType().add("int", (DataType)IntegerType$.MODULE$).add("int", (DataType)IntegerType$.MODULE$);
        this.testVector("Nest Struct in Struct", 10, (DataType)new StructType().add("int", (DataType)IntegerType$.MODULE$).add("struct", (DataType)this.subSchema()), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$63(this, column);
            return BoxedUnit.UNIT;
        });
        this.test("ColumnarBatch basic", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> scala.package$.MODULE$.Nil().$colon$colon((Object)MemoryMode.OFF_HEAP).$colon$colon((Object)MemoryMode.ON_HEAP).foreach((Function1 & Serializable)memMode -> {
            ColumnarBatchSuite.$anonfun$new$65(this, memMode);
            return BoxedUnit.UNIT;
        }), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1158));
        this.test("ColumnarBatch customization", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> scala.package$.MODULE$.Nil().$colon$colon((Object)MemoryMode.OFF_HEAP).$colon$colon((Object)MemoryMode.ON_HEAP).foreach((Function1 & Serializable)memMode -> {
            ColumnarBatchSuite.$anonfun$new$69(this, memMode);
            return BoxedUnit.UNIT;
        }), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1253));
        this.test("Convert rows", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> scala.package$.MODULE$.Nil().$colon$colon((Object)MemoryMode.OFF_HEAP).$colon$colon((Object)MemoryMode.ON_HEAP).foreach((Function1 & Serializable)memMode -> {
            ColumnarBatchSuite.$anonfun$new$73(this, memMode);
            return BoxedUnit.UNIT;
        }), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1488));
        this.test("Random flat schema", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testRandomRows(true, 15), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1557));
        this.test("Random nested schema", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testRandomRows(false, 30), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1561));
        this.test("exceeding maximum capacity should throw an error", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> scala.package$.MODULE$.Nil().$colon$colon((Object)MemoryMode.OFF_HEAP).$colon$colon((Object)MemoryMode.ON_HEAP).foreach((Function1 & Serializable)memMode -> {
            WritableColumnVector column = this.allocate(1, (DataType)ByteType$.MODULE$, (MemoryMode)memMode);
            column.MAX_CAPACITY = 15;
            column.appendBytes(5, (byte)0);
            int $org_scalatest_assert_macro_left = column.capacity;
            int $org_scalatest_assert_macro_right = 10;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1571));
            column.appendBytes(10, (byte)0);
            int $org_scalatest_assert_macro_left2 = column.capacity;
            int $org_scalatest_assert_macro_right2 = 15;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1574));
            RuntimeException ex = (RuntimeException)this.intercept((Function0)(JFunction0.mcI.sp & Serializable)() -> column.appendBytes(10, (byte)0), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1575));
            String $org_scalatest_assert_macro_left3 = ex.getMessage();
            String $org_scalatest_assert_macro_right3 = new StringBuilder(0).append("Cannot reserve additional contiguous bytes in the ").append("vectorized reader").toString();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1579));
        }), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1565));
        this.test("create columnar batch from Arrow column vectors", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            BufferAllocator allocator = ArrowUtils$.MODULE$.rootAllocator().newChildAllocator("int", 0L, Long.MAX_VALUE);
            IntVector vector1 = (IntVector)ArrowUtils$.MODULE$.toArrowField("int1", (DataType)IntegerType$.MODULE$, true, null, ArrowUtils$.MODULE$.toArrowField$default$5()).createVector(allocator);
            vector1.allocateNew();
            IntVector vector2 = (IntVector)ArrowUtils$.MODULE$.toArrowField("int2", (DataType)IntegerType$.MODULE$, true, null, ArrowUtils$.MODULE$.toArrowField$default$5()).createVector(allocator);
            vector2.allocateNew();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                vector1.setSafe(i, i);
                vector2.setSafe(i + 1, i);
            });
            vector1.setNull(10);
            vector1.setValueCount(11);
            vector2.setNull(0);
            vector2.setValueCount(11);
            Seq columnVectors = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ArrowColumnVector[]{new ArrowColumnVector((ValueVector)vector1), new ArrowColumnVector((ValueVector)vector2)}));
            StructType schema = StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("int1", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("int2", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            ColumnarBatch batch = new ColumnarBatch((ColumnVector[])columnVectors.toArray(ClassTag$.MODULE$.apply(ColumnVector.class)));
            batch.setNumRows(11);
            int $org_scalatest_assert_macro_left = batch.numCols();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1608));
            int $org_scalatest_assert_macro_left2 = batch.numRows();
            int $org_scalatest_assert_macro_right2 = 11;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1609));
            Iterator rowIter = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(batch.rowIterator()).asScala();
            rowIter.zipWithIndex().foreach((Function1 & Serializable)x0$11 -> {
                Assertion assertion;
                Tuple2 tuple2 = x0$11;
                if (tuple2 != null) {
                    Assertion assertion2;
                    InternalRow row = (InternalRow)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    if (i == 10) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(row.isNullAt(0), "row.isNullAt(0)", Prettifier$.MODULE$.default());
                        assertion2 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1614));
                    } else {
                        int $org_scalatest_assert_macro_left = row.getInt(0);
                        int $org_scalatest_assert_macro_right = i;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                        assertion2 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1616));
                    }
                    if (i == 0) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(row.isNullAt(1), "row.isNullAt(1)", Prettifier$.MODULE$.default());
                        assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1619));
                    } else {
                        int $org_scalatest_assert_macro_left = row.getInt(1);
                        int $org_scalatest_assert_macro_right = i - 1;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                        assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1621));
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Assertion assertion3 = assertion;
                return assertion3;
            });
            batch.close();
            allocator.close();
        }, new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1584));
        this.test("RowToColumnConverter", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Assertion assertion;
            StructField structField = new StructField("str", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("bool", (DataType)BooleanType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField3 = new StructField("byte", (DataType)ByteType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField4 = new StructField("short", (DataType)ShortType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField5 = new StructField("int", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField6 = new StructField("long", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField7 = new StructField("float", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField8 = new StructField("double", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField9 = new StructField("decimal", (DataType)new DecimalType(25, 5), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField10 = new StructField("date", (DataType)DateType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField11 = new StructField("ts", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField12 = new StructField("cal", (DataType)CalendarIntervalType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField13 = new StructField("arr_of_int", (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField14 = new StructField("int1", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
            StructField structField15 = new StructField("int2", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField16 = new StructField("int_and_int", (DataType)StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)structField15).$colon$colon((Object)structField14)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField17 = new StructField("int_to_int", (DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField18 = new StructField("binary", (DataType)BinaryType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField19 = new StructField("ts_ntz", (DataType)TimestampNTZType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType schema = StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)structField19).$colon$colon((Object)structField18).$colon$colon((Object)structField17).$colon$colon((Object)structField16).$colon$colon((Object)structField13).$colon$colon((Object)structField12).$colon$colon((Object)structField11).$colon$colon((Object)structField10).$colon$colon((Object)structField9).$colon$colon((Object)structField8).$colon$colon((Object)structField7).$colon$colon((Object)structField6).$colon$colon((Object)structField5).$colon$colon((Object)structField4).$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField));
            ArrayBasedMapBuilder mapBuilder = new ArrayBasedMapBuilder((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$);
            mapBuilder.put((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)10));
            mapBuilder.put((Object)BoxesRunTime.boxToInteger((int)20), null);
            String tsString1 = "2015-01-01 23:50:59.123";
            long ts1 = DateTimeUtils$.MODULE$.fromJavaTimestamp(Timestamp.valueOf(tsString1));
            long tsNTZ1 = DateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.parse(tsString1.replace(" ", "T")));
            String tsString2 = "1880-01-05 12:45:21.321";
            long ts2 = DateTimeUtils$.MODULE$.fromJavaTimestamp(Timestamp.valueOf(tsString2));
            long tsNTZ2 = DateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.parse(tsString2.replace(" ", "T")));
            GenericInternalRow row1 = new GenericInternalRow(new Object[]{UTF8String.fromString((String)"a string"), BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToByte((byte)((byte)1)), BoxesRunTime.boxToShort((short)((short)2)), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToFloat((float)((float)0.25)), BoxesRunTime.boxToDouble((double)0.75), Decimal$.MODULE$.apply("1234.23456"), BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf("2015-01-01"))), BoxesRunTime.boxToLong((long)ts1), new CalendarInterval(1, 0, 0L), new GenericArrayData(new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)4), null}), new GenericInternalRow(new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)10)}), mapBuilder.build(), "Spark SQL".getBytes(), BoxesRunTime.boxToLong((long)tsNTZ1)});
            mapBuilder = new ArrayBasedMapBuilder((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$);
            mapBuilder.put((Object)BoxesRunTime.boxToInteger((int)30), null);
            mapBuilder.put((Object)BoxesRunTime.boxToInteger((int)40), (Object)BoxesRunTime.boxToInteger((int)50));
            GenericInternalRow row2 = new GenericInternalRow(new Object[]{UTF8String.fromString((String)"second string"), BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToByte((byte)((byte)-1)), BoxesRunTime.boxToShort((short)((short)17)), BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE), BoxesRunTime.boxToLong((long)987654321L), BoxesRunTime.boxToFloat((float)Float.NaN), BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY), Decimal$.MODULE$.apply("0.01000"), BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf("1875-12-12"))), BoxesRunTime.boxToLong((long)ts2), new CalendarInterval(-10, -50, -100L), new GenericArrayData(new int[]{5, 10, -100}), new GenericInternalRow(new Object[]{BoxesRunTime.boxToInteger((int)20), null}), mapBuilder.build(), "Parquet".getBytes(), BoxesRunTime.boxToLong((long)tsNTZ2)});
            GenericInternalRow row3 = new GenericInternalRow(new Object[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null});
            RowToColumnConverter converter = new RowToColumnConverter(schema);
            OnHeapColumnVector[] columns = OnHeapColumnVector.allocateColumns((int)3, (StructType)schema);
            try (ColumnarBatch batch = new ColumnarBatch((ColumnVector[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])columns), ClassTag$.MODULE$.apply(ColumnVector.class)), 3);){
                void $org_scalatest_assert_macro_expr;
                void $org_scalatest_assert_macro_expr2;
                void $org_scalatest_assert_macro_right;
                void $org_scalatest_assert_macro_left;
                void $org_scalatest_assert_macro_expr3;
                void $org_scalatest_assert_macro_right2;
                void $org_scalatest_assert_macro_left2;
                void $org_scalatest_assert_macro_expr4;
                void $org_scalatest_assert_macro_right3;
                void $org_scalatest_assert_macro_left3;
                void $org_scalatest_assert_macro_expr5;
                void $org_scalatest_assert_macro_expr6;
                void $org_scalatest_assert_macro_right4;
                void $org_scalatest_assert_macro_left4;
                void $org_scalatest_assert_macro_expr7;
                void $org_scalatest_assert_macro_right5;
                void $org_scalatest_assert_macro_left5;
                void $org_scalatest_assert_macro_expr8;
                void $org_scalatest_assert_macro_right6;
                void $org_scalatest_assert_macro_left6;
                void $org_scalatest_assert_macro_expr9;
                void $org_scalatest_assert_macro_expr10;
                void $org_scalatest_assert_macro_right7;
                void $org_scalatest_assert_macro_left7;
                void $org_scalatest_assert_macro_expr11;
                void $org_scalatest_assert_macro_right8;
                void $org_scalatest_assert_macro_left8;
                void $org_scalatest_assert_macro_expr12;
                void $org_scalatest_assert_macro_expr13;
                void $org_scalatest_assert_macro_right9;
                void $org_scalatest_assert_macro_left9;
                void $org_scalatest_assert_macro_expr14;
                void $org_scalatest_assert_macro_right10;
                void $org_scalatest_assert_macro_left10;
                void map2;
                void $org_scalatest_assert_macro_expr15;
                converter.convert((InternalRow)row1, (WritableColumnVector[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])columns), ClassTag$.MODULE$.apply(WritableColumnVector.class)));
                converter.convert((InternalRow)row2, (WritableColumnVector[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])columns), ClassTag$.MODULE$.apply(WritableColumnVector.class)));
                converter.convert((InternalRow)row3, (WritableColumnVector[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])columns), ClassTag$.MODULE$.apply(WritableColumnVector.class)));
                DataType $org_scalatest_assert_macro_left11 = columns[0].dataType();
                StringType$ $org_scalatest_assert_macro_right11 = StringType$.MODULE$;
                DataType dataType = $org_scalatest_assert_macro_left11;
                StringType$ stringType$ = $org_scalatest_assert_macro_right11;
                Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right11, !(dataType != null ? !dataType.equals(stringType$) : stringType$ != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1737));
                String $org_scalatest_assert_macro_left12 = columns[0].getUTF8String(0).toString();
                String $org_scalatest_assert_macro_right12 = "a string";
                String string = $org_scalatest_assert_macro_left12;
                String string2 = $org_scalatest_assert_macro_right12;
                Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right12, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1738));
                String $org_scalatest_assert_macro_left13 = columns[0].getUTF8String(1).toString();
                String $org_scalatest_assert_macro_right13 = "second string";
                String string3 = $org_scalatest_assert_macro_left13;
                String string4 = $org_scalatest_assert_macro_right13;
                Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right13, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1739));
                Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.simpleMacroBool(columns[0].isNullAt(2), "columns.apply(0).isNullAt(2)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1740));
                DataType $org_scalatest_assert_macro_left14 = columns[1].dataType();
                BooleanType$ $org_scalatest_assert_macro_right14 = BooleanType$.MODULE$;
                DataType dataType2 = $org_scalatest_assert_macro_left14;
                BooleanType$ booleanType$ = $org_scalatest_assert_macro_right14;
                Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "==", (Object)$org_scalatest_assert_macro_right14, !(dataType2 != null ? !dataType2.equals(booleanType$) : booleanType$ != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1742));
                boolean $org_scalatest_assert_macro_left15 = columns[1].getBoolean(0);
                boolean $org_scalatest_assert_macro_right15 = true;
                Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left15), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right15), $org_scalatest_assert_macro_left15 == $org_scalatest_assert_macro_right15, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1743));
                boolean $org_scalatest_assert_macro_left16 = columns[1].getBoolean(1);
                boolean $org_scalatest_assert_macro_right16 = false;
                Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left16), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right16), $org_scalatest_assert_macro_left16 == $org_scalatest_assert_macro_right16, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1744));
                Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.simpleMacroBool(columns[1].isNullAt(2), "columns.apply(1).isNullAt(2)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1745));
                DataType $org_scalatest_assert_macro_left17 = columns[2].dataType();
                ByteType$ $org_scalatest_assert_macro_right17 = ByteType$.MODULE$;
                DataType dataType3 = $org_scalatest_assert_macro_left17;
                ByteType$ byteType$ = $org_scalatest_assert_macro_right17;
                Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "==", (Object)$org_scalatest_assert_macro_right17, !(dataType3 != null ? !dataType3.equals(byteType$) : byteType$ != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1747));
                byte $org_scalatest_assert_macro_left18 = columns[2].getByte(0);
                byte $org_scalatest_assert_macro_right18 = (byte)1;
                Bool $org_scalatest_assert_macro_expr25 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left18), "==", (Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right18), $org_scalatest_assert_macro_left18 == $org_scalatest_assert_macro_right18, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr25, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1748));
                byte $org_scalatest_assert_macro_left19 = columns[2].getByte(1);
                byte $org_scalatest_assert_macro_right19 = (byte)-1;
                Bool $org_scalatest_assert_macro_expr26 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left19), "==", (Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right19), $org_scalatest_assert_macro_left19 == $org_scalatest_assert_macro_right19, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr26, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1749));
                Bool $org_scalatest_assert_macro_expr27 = Bool$.MODULE$.simpleMacroBool(columns[2].isNullAt(2), "columns.apply(2).isNullAt(2)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr27, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1750));
                DataType $org_scalatest_assert_macro_left20 = columns[3].dataType();
                ShortType$ $org_scalatest_assert_macro_right20 = ShortType$.MODULE$;
                DataType dataType4 = $org_scalatest_assert_macro_left20;
                ShortType$ shortType$ = $org_scalatest_assert_macro_right20;
                Bool $org_scalatest_assert_macro_expr28 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left20, "==", (Object)$org_scalatest_assert_macro_right20, !(dataType4 != null ? !dataType4.equals(shortType$) : shortType$ != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr28, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1752));
                short $org_scalatest_assert_macro_left21 = columns[3].getShort(0);
                short $org_scalatest_assert_macro_right21 = (short)2;
                Bool $org_scalatest_assert_macro_expr29 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_left21), "==", (Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right21), $org_scalatest_assert_macro_left21 == $org_scalatest_assert_macro_right21, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr29, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1753));
                short $org_scalatest_assert_macro_left22 = columns[3].getShort(1);
                short $org_scalatest_assert_macro_right22 = (short)17;
                Bool $org_scalatest_assert_macro_expr30 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_left22), "==", (Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right22), $org_scalatest_assert_macro_left22 == $org_scalatest_assert_macro_right22, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr30, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1754));
                Bool $org_scalatest_assert_macro_expr31 = Bool$.MODULE$.simpleMacroBool(columns[3].isNullAt(2), "columns.apply(3).isNullAt(2)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr31, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1755));
                DataType $org_scalatest_assert_macro_left23 = columns[4].dataType();
                IntegerType$ $org_scalatest_assert_macro_right23 = IntegerType$.MODULE$;
                DataType dataType5 = $org_scalatest_assert_macro_left23;
                IntegerType$ integerType$ = $org_scalatest_assert_macro_right23;
                Bool $org_scalatest_assert_macro_expr32 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left23, "==", (Object)$org_scalatest_assert_macro_right23, !(dataType5 != null ? !dataType5.equals(integerType$) : integerType$ != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr32, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1757));
                int $org_scalatest_assert_macro_left24 = columns[4].getInt(0);
                int $org_scalatest_assert_macro_right24 = 3;
                Bool $org_scalatest_assert_macro_expr33 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left24), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right24), $org_scalatest_assert_macro_left24 == $org_scalatest_assert_macro_right24, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr33, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1758));
                int $org_scalatest_assert_macro_left25 = columns[4].getInt(1);
                int $org_scalatest_assert_macro_right25 = Integer.MIN_VALUE;
                Bool $org_scalatest_assert_macro_expr34 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left25), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right25), $org_scalatest_assert_macro_left25 == $org_scalatest_assert_macro_right25, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr34, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1759));
                Bool $org_scalatest_assert_macro_expr35 = Bool$.MODULE$.simpleMacroBool(columns[4].isNullAt(2), "columns.apply(4).isNullAt(2)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr35, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1760));
                DataType $org_scalatest_assert_macro_left26 = columns[5].dataType();
                LongType$ $org_scalatest_assert_macro_right26 = LongType$.MODULE$;
                DataType dataType6 = $org_scalatest_assert_macro_left26;
                LongType$ longType$ = $org_scalatest_assert_macro_right26;
                Bool $org_scalatest_assert_macro_expr36 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left26, "==", (Object)$org_scalatest_assert_macro_right26, !(dataType6 != null ? !dataType6.equals(longType$) : longType$ != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr36, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1762));
                long $org_scalatest_assert_macro_left27 = columns[5].getLong(0);
                long $org_scalatest_assert_macro_right27 = Long.MAX_VALUE;
                Bool $org_scalatest_assert_macro_expr37 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left27), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right27), $org_scalatest_assert_macro_left27 == $org_scalatest_assert_macro_right27, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr37, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1763));
                long $org_scalatest_assert_macro_left28 = columns[5].getLong(1);
                long $org_scalatest_assert_macro_right28 = 987654321L;
                Bool $org_scalatest_assert_macro_expr38 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left28), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right28), $org_scalatest_assert_macro_left28 == $org_scalatest_assert_macro_right28, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr38, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1764));
                Bool $org_scalatest_assert_macro_expr39 = Bool$.MODULE$.simpleMacroBool(columns[5].isNullAt(2), "columns.apply(5).isNullAt(2)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr39, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1765));
                DataType $org_scalatest_assert_macro_left29 = columns[6].dataType();
                FloatType$ $org_scalatest_assert_macro_right29 = FloatType$.MODULE$;
                DataType dataType7 = $org_scalatest_assert_macro_left29;
                FloatType$ floatType$ = $org_scalatest_assert_macro_right29;
                Bool $org_scalatest_assert_macro_expr40 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left29, "==", (Object)$org_scalatest_assert_macro_right29, !(dataType7 != null ? !dataType7.equals(floatType$) : floatType$ != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr40, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1767));
                float $org_scalatest_assert_macro_left30 = columns[6].getFloat(0);
                float $org_scalatest_assert_macro_right30 = (float)0.25;
                Bool $org_scalatest_assert_macro_expr41 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left30), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right30), $org_scalatest_assert_macro_left30 == $org_scalatest_assert_macro_right30, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr41, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1768));
                Bool $org_scalatest_assert_macro_expr42 = Bool$.MODULE$.simpleMacroBool(Float.isNaN(columns[6].getFloat(1)), "scala.Predef.float2Float(columns.apply(6).getFloat(1)).isNaN()", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr42, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1769));
                Bool $org_scalatest_assert_macro_expr43 = Bool$.MODULE$.simpleMacroBool(columns[6].isNullAt(2), "columns.apply(6).isNullAt(2)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr43, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1770));
                DataType $org_scalatest_assert_macro_left31 = columns[7].dataType();
                DoubleType$ $org_scalatest_assert_macro_right31 = DoubleType$.MODULE$;
                DataType dataType8 = $org_scalatest_assert_macro_left31;
                DoubleType$ doubleType$ = $org_scalatest_assert_macro_right31;
                Bool $org_scalatest_assert_macro_expr44 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left31, "==", (Object)$org_scalatest_assert_macro_right31, !(dataType8 != null ? !dataType8.equals(doubleType$) : doubleType$ != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr44, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1772));
                double $org_scalatest_assert_macro_left32 = columns[7].getDouble(0);
                double $org_scalatest_assert_macro_right32 = 0.75;
                Bool $org_scalatest_assert_macro_expr45 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left32), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right32), $org_scalatest_assert_macro_left32 == $org_scalatest_assert_macro_right32, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr45, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1773));
                double $org_scalatest_assert_macro_left33 = columns[7].getDouble(1);
                double $org_scalatest_assert_macro_right33 = Double.POSITIVE_INFINITY;
                Bool $org_scalatest_assert_macro_expr46 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left33), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right33), $org_scalatest_assert_macro_left33 == $org_scalatest_assert_macro_right33, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr46, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1774));
                Bool $org_scalatest_assert_macro_expr47 = Bool$.MODULE$.simpleMacroBool(columns[7].isNullAt(2), "columns.apply(7).isNullAt(2)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr47, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1775));
                DataType $org_scalatest_assert_macro_left34 = columns[8].dataType();
                DecimalType $org_scalatest_assert_macro_right34 = new DecimalType(25, 5);
                DataType dataType9 = $org_scalatest_assert_macro_left34;
                DecimalType decimalType = $org_scalatest_assert_macro_right34;
                Bool $org_scalatest_assert_macro_expr48 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left34, "==", (Object)$org_scalatest_assert_macro_right34, !(dataType9 != null ? !dataType9.equals(decimalType) : decimalType != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr48, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1777));
                Decimal $org_scalatest_assert_macro_left35 = columns[8].getDecimal(0, 25, 5);
                Decimal $org_scalatest_assert_macro_right35 = Decimal$.MODULE$.apply("1234.23456");
                Decimal decimal = $org_scalatest_assert_macro_left35;
                Decimal decimal2 = $org_scalatest_assert_macro_right35;
                Bool $org_scalatest_assert_macro_expr49 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left35, "==", (Object)$org_scalatest_assert_macro_right35, !(decimal != null ? !decimal.equals(decimal2) : decimal2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr49, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1778));
                Decimal $org_scalatest_assert_macro_left36 = columns[8].getDecimal(1, 25, 5);
                Decimal $org_scalatest_assert_macro_right36 = Decimal$.MODULE$.apply("0.01000");
                Decimal decimal3 = $org_scalatest_assert_macro_left36;
                Decimal decimal4 = $org_scalatest_assert_macro_right36;
                Bool $org_scalatest_assert_macro_expr50 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left36, "==", (Object)$org_scalatest_assert_macro_right36, !(decimal3 != null ? !decimal3.equals(decimal4) : decimal4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr50, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1779));
                Bool $org_scalatest_assert_macro_expr51 = Bool$.MODULE$.simpleMacroBool(columns[8].isNullAt(2), "columns.apply(8).isNullAt(2)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr51, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1780));
                DataType $org_scalatest_assert_macro_left37 = columns[9].dataType();
                DateType$ $org_scalatest_assert_macro_right37 = DateType$.MODULE$;
                DataType dataType10 = $org_scalatest_assert_macro_left37;
                DateType$ dateType$ = $org_scalatest_assert_macro_right37;
                Bool $org_scalatest_assert_macro_expr52 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left37, "==", (Object)$org_scalatest_assert_macro_right37, !(dataType10 != null ? !dataType10.equals(dateType$) : dateType$ != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr52, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1782));
                int $org_scalatest_assert_macro_left38 = columns[9].getInt(0);
                int $org_scalatest_assert_macro_right38 = DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf("2015-01-01"));
                Bool $org_scalatest_assert_macro_expr53 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left38), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right38), $org_scalatest_assert_macro_left38 == $org_scalatest_assert_macro_right38, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr53, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1783));
                int $org_scalatest_assert_macro_left39 = columns[9].getInt(1);
                int $org_scalatest_assert_macro_right39 = DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf("1875-12-12"));
                Bool $org_scalatest_assert_macro_expr54 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left39), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right39), $org_scalatest_assert_macro_left39 == $org_scalatest_assert_macro_right39, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr54, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1785));
                Bool $org_scalatest_assert_macro_expr55 = Bool$.MODULE$.simpleMacroBool(columns[9].isNullAt(2), "columns.apply(9).isNullAt(2)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr55, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1787));
                DataType $org_scalatest_assert_macro_left40 = columns[10].dataType();
                TimestampType$ $org_scalatest_assert_macro_right40 = TimestampType$.MODULE$;
                DataType dataType11 = $org_scalatest_assert_macro_left40;
                TimestampType$ timestampType$ = $org_scalatest_assert_macro_right40;
                Bool $org_scalatest_assert_macro_expr56 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left40, "==", (Object)$org_scalatest_assert_macro_right40, !(dataType11 != null ? !dataType11.equals(timestampType$) : timestampType$ != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr56, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1789));
                long $org_scalatest_assert_macro_left41 = columns[10].getLong(0);
                long $org_scalatest_assert_macro_right41 = ts1;
                Bool $org_scalatest_assert_macro_expr57 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left41), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right41), $org_scalatest_assert_macro_left41 == $org_scalatest_assert_macro_right41, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr57, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1790));
                long $org_scalatest_assert_macro_left42 = columns[10].getLong(1);
                long $org_scalatest_assert_macro_right42 = ts2;
                Bool $org_scalatest_assert_macro_expr58 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left42), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right42), $org_scalatest_assert_macro_left42 == $org_scalatest_assert_macro_right42, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr58, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1791));
                Bool $org_scalatest_assert_macro_expr59 = Bool$.MODULE$.simpleMacroBool(columns[10].isNullAt(2), "columns.apply(10).isNullAt(2)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr59, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1792));
                DataType $org_scalatest_assert_macro_left43 = columns[11].dataType();
                CalendarIntervalType$ $org_scalatest_assert_macro_right43 = CalendarIntervalType$.MODULE$;
                DataType dataType12 = $org_scalatest_assert_macro_left43;
                CalendarIntervalType$ calendarIntervalType$ = $org_scalatest_assert_macro_right43;
                Bool $org_scalatest_assert_macro_expr60 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left43, "==", (Object)$org_scalatest_assert_macro_right43, !(dataType12 != null ? !dataType12.equals(calendarIntervalType$) : calendarIntervalType$ != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr60, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1794));
                CalendarInterval $org_scalatest_assert_macro_left44 = columns[11].getInterval(0);
                CalendarInterval $org_scalatest_assert_macro_right44 = new CalendarInterval(1, 0, 0L);
                CalendarInterval calendarInterval = $org_scalatest_assert_macro_left44;
                CalendarInterval calendarInterval2 = $org_scalatest_assert_macro_right44;
                Bool $org_scalatest_assert_macro_expr61 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left44, "==", (Object)$org_scalatest_assert_macro_right44, !(calendarInterval != null ? !calendarInterval.equals(calendarInterval2) : calendarInterval2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr61, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1795));
                CalendarInterval $org_scalatest_assert_macro_left45 = columns[11].getInterval(1);
                CalendarInterval $org_scalatest_assert_macro_right45 = new CalendarInterval(-10, -50, -100L);
                CalendarInterval calendarInterval3 = $org_scalatest_assert_macro_left45;
                CalendarInterval calendarInterval4 = $org_scalatest_assert_macro_right45;
                Bool $org_scalatest_assert_macro_expr62 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left45, "==", (Object)$org_scalatest_assert_macro_right45, !(calendarInterval3 != null ? !calendarInterval3.equals(calendarInterval4) : calendarInterval4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr62, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1796));
                Bool $org_scalatest_assert_macro_expr63 = Bool$.MODULE$.simpleMacroBool(columns[11].isNullAt(2), "columns.apply(11).isNullAt(2)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr63, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1797));
                DataType $org_scalatest_assert_macro_left46 = columns[12].dataType();
                ArrayType $org_scalatest_assert_macro_right46 = ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$);
                DataType dataType13 = $org_scalatest_assert_macro_left46;
                ArrayType arrayType = $org_scalatest_assert_macro_right46;
                Bool $org_scalatest_assert_macro_expr64 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left46, "==", (Object)$org_scalatest_assert_macro_right46, !(dataType13 != null ? !dataType13.equals(arrayType) : arrayType != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr64, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1799));
                ColumnarArray arr1 = columns[12].getArray(0);
                int $org_scalatest_assert_macro_left47 = arr1.numElements();
                int $org_scalatest_assert_macro_right47 = 5;
                Bool $org_scalatest_assert_macro_expr65 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left47), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right47), $org_scalatest_assert_macro_left47 == $org_scalatest_assert_macro_right47, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr65, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1801));
                int $org_scalatest_assert_macro_left48 = arr1.getInt(0);
                int $org_scalatest_assert_macro_right48 = 1;
                Bool $org_scalatest_assert_macro_expr66 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left48), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right48), $org_scalatest_assert_macro_left48 == $org_scalatest_assert_macro_right48, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr66, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1802));
                int $org_scalatest_assert_macro_left49 = arr1.getInt(1);
                int $org_scalatest_assert_macro_right49 = 2;
                Bool $org_scalatest_assert_macro_expr67 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left49), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right49), $org_scalatest_assert_macro_left49 == $org_scalatest_assert_macro_right49, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr67, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1803));
                int $org_scalatest_assert_macro_left50 = arr1.getInt(2);
                int $org_scalatest_assert_macro_right50 = 3;
                Bool $org_scalatest_assert_macro_expr68 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left50), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right50), $org_scalatest_assert_macro_left50 == $org_scalatest_assert_macro_right50, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr68, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1804));
                int $org_scalatest_assert_macro_left51 = arr1.getInt(3);
                int $org_scalatest_assert_macro_right51 = 4;
                Bool $org_scalatest_assert_macro_expr69 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left51), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right51), $org_scalatest_assert_macro_left51 == $org_scalatest_assert_macro_right51, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr69, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1805));
                Bool $org_scalatest_assert_macro_expr70 = Bool$.MODULE$.simpleMacroBool(arr1.isNullAt(4), "arr1.isNullAt(4)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr70, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1806));
                ColumnarArray arr2 = columns[12].getArray(1);
                int $org_scalatest_assert_macro_left52 = arr2.numElements();
                int $org_scalatest_assert_macro_right52 = 3;
                Bool $org_scalatest_assert_macro_expr71 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left52), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right52), $org_scalatest_assert_macro_left52 == $org_scalatest_assert_macro_right52, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr71, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1809));
                int $org_scalatest_assert_macro_left53 = arr2.getInt(0);
                int $org_scalatest_assert_macro_right53 = 5;
                Bool $org_scalatest_assert_macro_expr72 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left53), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right53), $org_scalatest_assert_macro_left53 == $org_scalatest_assert_macro_right53, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr72, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1810));
                int $org_scalatest_assert_macro_left54 = arr2.getInt(1);
                int $org_scalatest_assert_macro_right54 = 10;
                Bool $org_scalatest_assert_macro_expr73 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left54), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right54), $org_scalatest_assert_macro_left54 == $org_scalatest_assert_macro_right54, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr73, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1811));
                int $org_scalatest_assert_macro_left55 = arr2.getInt(2);
                int $org_scalatest_assert_macro_right55 = -100;
                Bool $org_scalatest_assert_macro_expr74 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left55), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right55), $org_scalatest_assert_macro_left55 == $org_scalatest_assert_macro_right55, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr74, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1812));
                Bool $org_scalatest_assert_macro_expr75 = Bool$.MODULE$.simpleMacroBool(columns[12].isNullAt(2), "columns.apply(12).isNullAt(2)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr75, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1814));
                DataType $org_scalatest_assert_macro_left56 = columns[13].dataType();
                StructField structField20 = new StructField("int1", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
                StructField structField21 = new StructField("int2", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType $org_scalatest_assert_macro_right56 = StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)structField21).$colon$colon((Object)structField20));
                DataType dataType14 = $org_scalatest_assert_macro_left56;
                StructType structType = $org_scalatest_assert_macro_right56;
                Bool $org_scalatest_assert_macro_expr76 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left56, "==", (Object)$org_scalatest_assert_macro_right56, !(dataType14 != null ? !dataType14.equals(structType) : structType != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr76, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1816));
                ColumnarRow struct1 = columns[13].getStruct(0);
                int $org_scalatest_assert_macro_left57 = struct1.getInt(0);
                int $org_scalatest_assert_macro_right57 = 5;
                Bool $org_scalatest_assert_macro_expr77 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left57), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right57), $org_scalatest_assert_macro_left57 == $org_scalatest_assert_macro_right57, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr77, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1822));
                int $org_scalatest_assert_macro_left58 = struct1.getInt(1);
                int $org_scalatest_assert_macro_right58 = 10;
                Bool $org_scalatest_assert_macro_expr78 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left58), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right58), $org_scalatest_assert_macro_left58 == $org_scalatest_assert_macro_right58, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr78, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1823));
                ColumnarRow struct2 = columns[13].getStruct(1);
                int $org_scalatest_assert_macro_left59 = struct2.getInt(0);
                int $org_scalatest_assert_macro_right59 = 20;
                Bool $org_scalatest_assert_macro_expr79 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left59), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right59), $org_scalatest_assert_macro_left59 == $org_scalatest_assert_macro_right59, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr79, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1825));
                Bool $org_scalatest_assert_macro_expr80 = Bool$.MODULE$.simpleMacroBool(struct2.isNullAt(1), "struct2.isNullAt(1)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr80, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1826));
                Bool $org_scalatest_assert_macro_expr81 = Bool$.MODULE$.simpleMacroBool(columns[13].isNullAt(2), "columns.apply(13).isNullAt(2)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr81, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1827));
                DataType $org_scalatest_assert_macro_left60 = columns[14].dataType();
                MapType $org_scalatest_assert_macro_right60 = MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$);
                DataType dataType15 = $org_scalatest_assert_macro_left60;
                MapType mapType = $org_scalatest_assert_macro_right60;
                Bool $org_scalatest_assert_macro_expr82 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left60, "==", (Object)$org_scalatest_assert_macro_right60, !(dataType15 != null ? !dataType15.equals(mapType) : mapType != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr82, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1829));
                ColumnarMap map1 = columns[14].getMap(0);
                int $org_scalatest_assert_macro_left61 = map1.numElements();
                int $org_scalatest_assert_macro_right61 = 2;
                Bool $org_scalatest_assert_macro_expr83 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left61), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right61), $org_scalatest_assert_macro_left61 == $org_scalatest_assert_macro_right61, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr83, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1831));
                int $org_scalatest_assert_macro_left62 = map1.keyArray().getInt(0);
                int $org_scalatest_assert_macro_right62 = 1;
                Bool $org_scalatest_assert_macro_expr84 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left62), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right62), $org_scalatest_assert_macro_left62 == $org_scalatest_assert_macro_right62, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr84, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1832));
                int $org_scalatest_assert_macro_left63 = map1.valueArray().getInt(0);
                int $org_scalatest_assert_macro_right63 = 10;
                Bool $org_scalatest_assert_macro_expr85 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left63), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right63), $org_scalatest_assert_macro_left63 == $org_scalatest_assert_macro_right63, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr85, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1833));
                int $org_scalatest_assert_macro_left64 = map1.keyArray().getInt(1);
                int $org_scalatest_assert_macro_right64 = 20;
                Bool $org_scalatest_assert_macro_expr86 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left64), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right64), $org_scalatest_assert_macro_left64 == $org_scalatest_assert_macro_right64, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr86, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1834));
                Bool bool = Bool$.MODULE$.simpleMacroBool(map1.valueArray().isNullAt(1), "map1.valueArray().isNullAt(1)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert((Bool)$org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1835));
                ColumnarMap columnarMap = columns[14].getMap(1);
                int n = map2.numElements();
                int n2 = 2;
                Bool bool2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10 == $org_scalatest_assert_macro_right10, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert((Bool)$org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1838));
                int n3 = map2.keyArray().getInt(0);
                int n4 = 30;
                Bool bool3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9 == $org_scalatest_assert_macro_right9, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert((Bool)$org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1839));
                Bool bool4 = Bool$.MODULE$.simpleMacroBool(map2.valueArray().isNullAt(0), "map2.valueArray().isNullAt(0)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert((Bool)$org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1840));
                int n5 = map2.keyArray().getInt(1);
                int n6 = 40;
                Bool bool5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 == $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert((Bool)$org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1841));
                int n7 = map2.valueArray().getInt(1);
                int n8 = 50;
                Bool bool6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert((Bool)$org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1842));
                Bool bool7 = Bool$.MODULE$.simpleMacroBool(columns[14].isNullAt(2), "columns.apply(14).isNullAt(2)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert((Bool)$org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1843));
                DataType dataType16 = columns[15].dataType();
                BinaryType$ binaryType$ = BinaryType$.MODULE$;
                void v21 = $org_scalatest_assert_macro_left6;
                void var275_258 = $org_scalatest_assert_macro_right6;
                Bool bool8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(v21 != null ? !v21.equals(var275_258) : var275_258 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert((Bool)$org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1845));
                String string5 = new String(columns[15].getBinary(0));
                String string6 = "Spark SQL";
                void v22 = $org_scalatest_assert_macro_left5;
                void var279_262 = $org_scalatest_assert_macro_right5;
                Bool bool9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(v22 != null ? !v22.equals(var279_262) : var279_262 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert((Bool)$org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1846));
                String string7 = new String(columns[15].getBinary(1));
                String string8 = "Parquet";
                void v23 = $org_scalatest_assert_macro_left4;
                void var283_266 = $org_scalatest_assert_macro_right4;
                Bool bool10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(v23 != null ? !v23.equals(var283_266) : var283_266 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert((Bool)$org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1847));
                Bool bool11 = Bool$.MODULE$.simpleMacroBool(columns[15].isNullAt(2), "columns.apply(15).isNullAt(2)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert((Bool)$org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1848));
                DataType dataType17 = columns[16].dataType();
                TimestampNTZType$ timestampNTZType$ = TimestampNTZType$.MODULE$;
                void v24 = $org_scalatest_assert_macro_left3;
                void var288_271 = $org_scalatest_assert_macro_right3;
                Bool bool12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(v24 != null ? !v24.equals(var288_271) : var288_271 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert((Bool)$org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1850));
                long l = columns[16].getLong(0);
                long l2 = tsNTZ1;
                Bool bool13 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert((Bool)$org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1851));
                long l3 = columns[16].getLong(1);
                long l4 = tsNTZ2;
                Bool bool14 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert((Bool)$org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1852));
                Bool bool15 = Bool$.MODULE$.simpleMacroBool(columns[16].isNullAt(2), "columns.apply(16).isNullAt(2)", Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert((Bool)$org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1853));
            }
            return assertion;
        }, new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1629));
        this.test("SPARK-37161: RowToColumnConverter for AnsiIntervalType", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            DataTypeTestUtils$.MODULE$.yearMonthIntervalTypes().foreach((Function1 & Serializable)dt -> {
                Assertion assertion;
                StructType schema = new StructType().add(dt.typeName(), (DataType)dt);
                RowToColumnConverter converter = new RowToColumnConverter(schema);
                OnHeapColumnVector[] columns = OnHeapColumnVector.allocateColumns((int)10, (StructType)schema);
                try {
                    DataType $org_scalatest_assert_macro_left = columns[0].dataType();
                    YearMonthIntervalType $org_scalatest_assert_macro_right = dt;
                    DataType dataType = $org_scalatest_assert_macro_left;
                    YearMonthIntervalType yearMonthIntervalType = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(yearMonthIntervalType) : yearMonthIntervalType != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1865));
                    RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 9).foreach((Function1 & Serializable)i -> ColumnarBatchSuite.$anonfun$new$85(converter, columns, BoxesRunTime.unboxToInt((Object)i)));
                    converter.convert((InternalRow)new GenericInternalRow(new Object[]{null}), (WritableColumnVector[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])columns), ClassTag$.MODULE$.apply(WritableColumnVector.class)));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(columns[0].isNullAt(9), "columns.apply(0).isNullAt(9)", Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1872));
                }
                finally {
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)x$15 -> {
                        x$15.close();
                        return BoxedUnit.UNIT;
                    });
                }
                return assertion;
            });
            DataTypeTestUtils$.MODULE$.dayTimeIntervalTypes().foreach((Function1 & Serializable)dt -> {
                Assertion assertion;
                StructType schema = new StructType().add(dt.typeName(), (DataType)dt);
                RowToColumnConverter converter = new RowToColumnConverter(schema);
                OnHeapColumnVector[] columns = OnHeapColumnVector.allocateColumns((int)10, (StructType)schema);
                try {
                    DataType $org_scalatest_assert_macro_left = columns[0].dataType();
                    DayTimeIntervalType $org_scalatest_assert_macro_right = dt;
                    DataType dataType = $org_scalatest_assert_macro_left;
                    DayTimeIntervalType dayTimeIntervalType = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(dayTimeIntervalType) : dayTimeIntervalType != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1882));
                    RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 9).foreach((Function1 & Serializable)i -> ColumnarBatchSuite.$anonfun$new$88(converter, columns, BoxesRunTime.unboxToInt((Object)i)));
                    converter.convert((InternalRow)new GenericInternalRow(new Object[]{null}), (WritableColumnVector[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])columns), ClassTag$.MODULE$.apply(WritableColumnVector.class)));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(columns[0].isNullAt(9), "columns.apply(0).isNullAt(9)", Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1889));
                }
                finally {
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)x$16 -> {
                        x$16.close();
                        return BoxedUnit.UNIT;
                    });
                }
                return assertion;
            });
        }, new Position("ColumnarBatchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1859));
        this.testVector("Decimal API", 4, (DataType)DecimalType$.MODULE$.IntDecimal(), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$90(column);
            return BoxedUnit.UNIT;
        });
        this.testVector("Binary APIs", 4, (DataType)BinaryType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$92(column);
            return BoxedUnit.UNIT;
        });
        this.testVector("Timestamp without timezone", 10, (DataType)TimestampNTZType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$94(this, column);
            return BoxedUnit.UNIT;
        });
        this.testVector("WritableColumnVector.reserve(): requested capacity is negative", 1024, (DataType)ByteType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)column -> {
            ColumnarBatchSuite.$anonfun$new$97(this, column);
            return BoxedUnit.UNIT;
        });
        DataTypeTestUtils$.MODULE$.yearMonthIntervalTypes().foreach((Function1 & Serializable)dt -> {
            this.testVector(dt.typeName(), 10, (DataType)dt, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)column -> {
                ColumnarBatchSuite.$anonfun$new$100($this, dt, column);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        DataTypeTestUtils$.MODULE$.dayTimeIntervalTypes().foreach((Function1 & Serializable)dt -> {
            this.testVector(dt.typeName(), 10, (DataType)dt, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)column -> {
                ColumnarBatchSuite.$anonfun$new$104($this, dt, column);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public class CustomizedColumnarBatch
    extends ColumnarBatch {
        private final ColumnVector[] columns;
        private final List<Object> skipRowIds;
        public final /* synthetic */ ColumnarBatchSuite $outer;

        public List<Object> skipRowIds() {
            return this.skipRowIds;
        }

        public java.util.Iterator<InternalRow> rowIterator() {
            int maxRows = this.numRows;
            ColumnarBatchRow row = new ColumnarBatchRow(this.columns);
            return new java.util.Iterator<InternalRow>(this, maxRows, row){
                private int rowId;
                private final /* synthetic */ CustomizedColumnarBatch $outer;
                private final int maxRows$1;
                private final ColumnarBatchRow row$1;

                public void remove() {
                    java.util.Iterator.super.remove();
                }

                public void forEachRemaining(Consumer<? super InternalRow> x$1) {
                    java.util.Iterator.super.forEachRemaining(x$1);
                }

                private int rowId() {
                    return this.rowId;
                }

                private void rowId_$eq(int x$1) {
                    this.rowId = x$1;
                }

                public boolean hasNext() {
                    while (this.$outer.skipRowIds().contains((Object)BoxesRunTime.boxToInteger((int)this.rowId()))) {
                        this.rowId_$eq(this.rowId() + 1);
                    }
                    return this.rowId() < this.maxRows$1;
                }

                public InternalRow next() {
                    while (this.$outer.skipRowIds().contains((Object)BoxesRunTime.boxToInteger((int)this.rowId()))) {
                        this.rowId_$eq(this.rowId() + 1);
                    }
                    if (this.rowId() >= this.maxRows$1) {
                        throw new NoSuchElementException();
                    }
                    this.row$1.rowId = this.rowId();
                    this.rowId_$eq(this.rowId() + 1);
                    return this.row$1;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.maxRows$1 = maxRows$1;
                    this.row$1 = row$1;
                    this.rowId = 0;
                }
            };
        }

        public /* synthetic */ ColumnarBatchSuite org$apache$spark$sql$execution$vectorized$ColumnarBatchSuite$CustomizedColumnarBatch$$$outer() {
            return this.$outer;
        }

        public CustomizedColumnarBatch(ColumnarBatchSuite $outer, ColumnVector[] columns) {
            this.columns = columns;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(columns);
            this.skipRowIds = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2}));
        }
    }
}

