/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql.connector;

import java.util.Arrays;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Expressions;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.NullOrdering;
import org.apache.spark.sql.connector.expressions.SortDirection;
import org.apache.spark.sql.connector.expressions.SortOrder;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.read.SupportsReportOrdering;
import org.apache.spark.sql.connector.read.partitioning.KeyGroupedPartitioning;
import org.apache.spark.sql.connector.read.partitioning.Partitioning;
import org.apache.spark.sql.connector.read.partitioning.UnknownPartitioning;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import test.org.apache.spark.sql.connector.JavaPartitionAwareDataSource;
import test.org.apache.spark.sql.connector.JavaSimpleBatchTable;

public class JavaOrderAndPartitionAwareDataSource
extends JavaPartitionAwareDataSource {
    @Override
    public Table getTable(final CaseInsensitiveStringMap options) {
        return new JavaSimpleBatchTable(){

            public Transform[] partitioning() {
                String partitionKeys = options.get((Object)"partitionKeys");
                if (partitionKeys == null) {
                    return new Transform[0];
                }
                return (Transform[])Arrays.stream(partitionKeys.split(",")).map(Expressions::identity).toArray();
            }

            public ScanBuilder newScanBuilder(CaseInsensitiveStringMap options2) {
                return new MyScanBuilder(options2.get((Object)"partitionKeys"), options2.get((Object)"orderKeys"));
            }
        };
    }

    static class MyIdentityTransform
    implements Transform {
        private final Expression[] args;

        MyIdentityTransform(NamedReference namedReference) {
            this.args = new Expression[]{namedReference};
        }

        public String name() {
            return "identity";
        }

        public NamedReference[] references() {
            return new NamedReference[0];
        }

        public Expression[] arguments() {
            return this.args;
        }
    }

    static class MyNamedReference
    implements NamedReference {
        private final String[] parts;

        MyNamedReference(String part) {
            this.parts = new String[]{part};
        }

        public String[] fieldNames() {
            return this.parts;
        }
    }

    static class MySortOrder
    implements SortOrder {
        private final Expression expression;

        MySortOrder(String columnName) {
            this.expression = new MyIdentityTransform(new MyNamedReference(columnName));
        }

        public Expression expression() {
            return this.expression;
        }

        public SortDirection direction() {
            return SortDirection.ASCENDING;
        }

        public NullOrdering nullOrdering() {
            return NullOrdering.NULLS_FIRST;
        }
    }

    static class MyScanBuilder
    extends JavaPartitionAwareDataSource.MyScanBuilder
    implements SupportsReportOrdering {
        private final Partitioning partitioning;
        private final SortOrder[] ordering;

        MyScanBuilder(String partitionKeys, String orderKeys) {
            String[] keys;
            if (partitionKeys != null) {
                keys = partitionKeys.split(",");
                Transform[] clustering = new Transform[keys.length];
                for (int i = 0; i < keys.length; ++i) {
                    clustering[i] = Expressions.identity((String)keys[i]);
                }
                this.partitioning = new KeyGroupedPartitioning((Expression[])clustering, 2);
            } else {
                this.partitioning = new UnknownPartitioning(2);
            }
            if (orderKeys != null) {
                keys = orderKeys.split(",");
                this.ordering = new SortOrder[keys.length];
                for (int i = 0; i < keys.length; ++i) {
                    this.ordering[i] = new MySortOrder(keys[i]);
                }
            } else {
                this.ordering = new SortOrder[0];
            }
        }

        @Override
        public InputPartition[] planInputPartitions() {
            InputPartition[] partitions = new InputPartition[]{new JavaPartitionAwareDataSource.SpecificInputPartition(new int[]{1, 1, 3}, new int[]{4, 5, 5}), new JavaPartitionAwareDataSource.SpecificInputPartition(new int[]{2, 4, 4}, new int[]{6, 1, 2})};
            return partitions;
        }

        @Override
        public Partitioning outputPartitioning() {
            return this.partitioning;
        }

        public SortOrder[] outputOrdering() {
            return this.ordering;
        }
    }
}

