/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.exchange;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.plans.physical.ClusteredDistribution;
import org.apache.spark.sql.catalyst.plans.physical.Distribution;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.catalyst.plans.physical.ShuffleSpec;
import org.apache.spark.sql.execution.SparkPlan;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;

public final class ValidateRequirements$
implements Logging {
    public static final ValidateRequirements$ MODULE$ = new ValidateRequirements$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean validate(SparkPlan plan, Distribution requiredDistribution) {
        return this.validate(plan) && plan.outputPartitioning().satisfies(requiredDistribution);
    }

    public boolean validate(SparkPlan plan2) {
        return plan2.children().forall((Function1 & Serializable)plan -> BoxesRunTime.boxToBoolean((boolean)ValidateRequirements$.MODULE$.validate(plan))) && this.validateInternal(plan2);
    }

    private boolean validateInternal(SparkPlan plan) {
        boolean bl;
        Seq children = plan.children();
        Seq<Distribution> requiredChildDistributions = plan.requiredChildDistribution();
        Seq<Seq<SortOrder>> requiredChildOrderings = plan.requiredChildOrdering();
        Predef$.MODULE$.assert(requiredChildDistributions.length() == children.length());
        Predef$.MODULE$.assert(requiredChildOrderings.length() == children.length());
        boolean satisfied = ((IterableOnceOps)children.zip((IterableOnce)requiredChildDistributions.zip(requiredChildOrderings))).forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ValidateRequirements$.$anonfun$validateInternal$1(plan, x0$1)));
        if (satisfied && children.length() > 1 && requiredChildDistributions.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ValidateRequirements$.$anonfun$validateInternal$3(x$1)))) {
            Seq specs = (Seq)((IterableOps)((IterableOps)children.map((Function1 & Serializable)x$2 -> x$2.outputPartitioning())).zip(requiredChildDistributions)).map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Partitioning p = (Partitioning)tuple2._1();
                Distribution d = (Distribution)tuple2._2();
                ShuffleSpec shuffleSpec = p.createShuffleSpec((ClusteredDistribution)d);
                return shuffleSpec;
            });
            if (((IterableOnceOps)specs.tail()).forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isCompatibleWith((ShuffleSpec)specs.head())))) {
                bl = true;
            } else {
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(60).append("ValidateRequirements failed: children not co-partitioned in\n").append(plan).toString());
                bl = false;
            }
        } else {
            bl = satisfied;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$validateInternal$1(SparkPlan plan$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) return true;
        SparkPlan child = (SparkPlan)tuple2._1();
        Tuple2 tuple22 = (Tuple2)tuple2._2();
        if (tuple22 == null) return true;
        Distribution distribution = (Distribution)tuple22._1();
        Seq ordering2 = (Seq)tuple22._2();
        if (child.outputPartitioning().satisfies(distribution)) {
            if (SortOrder$.MODULE$.orderingSatisfies(child.outputOrdering(), ordering2)) return true;
        }
        MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("ValidateRequirements failed: ").append(distribution).append(", ").append(ordering2).append("\n").append(plan$1).toString());
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$validateInternal$3(Distribution x$1) {
        return x$1 instanceof ClusteredDistribution;
    }

    private ValidateRequirements$() {
    }
}

