/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.BaseSubqueryExec;
import org.apache.spark.sql.execution.ExplainMode;
import org.apache.spark.sql.execution.FormattedMode$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.ReusedSubqueryExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.SubqueryBroadcastExec;
import org.apache.spark.sql.execution.SubqueryExec;
import org.apache.spark.sql.execution.adaptive.DisableAdaptiveExecutionSuite;
import org.apache.spark.sql.execution.exchange.Exchange;
import org.apache.spark.sql.execution.exchange.ReusedExchangeExec;
import org.apache.spark.sql.execution.exchange.ValidateRequirements$;
import org.apache.spark.sql.internal.SQLConf$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015ca\u0002\n\u0014!\u0003\r\t\u0001\b\u0005\u0006S\u0001!\tA\u000b\u0005\bc\u0001\u0011\r\u0011\"\u00053\u0011\u001dY\u0004A1A\u0005\nqBq!\u0012\u0001C\u0002\u0013%A\bC\u0004G\u0001\t\u0007I\u0011\u0002\u001f\t\u000f\u001d\u0003!\u0019!C\u0005\u0011\")q\n\u0001D\u0001!\"91\f\u0001b\u0001\n\u0013a\u0006\"\u00024\u0001\t\u00139\u0007\"\u00026\u0001\t\u0013Y\u0007\"B;\u0001\t\u00131\bbBA\u0001\u0001\u0011%\u00111\u0001\u0005\b\u0003\u0017\u0001A\u0011BA\u0007\u0011\u001d\t\t\u0002\u0001C\u0005\u0003'Aq!a\u0006\u0001\t\u0013\tI\u0002C\u0004\u0002\u001e\u0001!\t\"a\b\t\u0013\u00055\u0002!%A\u0005\u0012\u0005=\"A\u0005)mC:\u001cF/\u00192jY&$\u0018pU;ji\u0016T!\u0001F\u000b\u0002\u0007M\fHN\u0003\u0002\u0017/\u0005)1\u000f]1sW*\u0011\u0001$G\u0001\u0007CB\f7\r[3\u000b\u0003i\t1a\u001c:h\u0007\u0001\u00192\u0001A\u000f\"!\tqr$D\u0001\u0016\u0013\t\u0001SCA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003E\u001dj\u0011a\t\u0006\u0003I\u0015\n\u0001\"\u00193baRLg/\u001a\u0006\u0003MM\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005!\u001a#!\b#jg\u0006\u0014G.Z!eCB$\u0018N^3Fq\u0016\u001cW\u000f^5p]N+\u0018\u000e^3\u0002\r\u0011Jg.\u001b;%)\u0005Y\u0003C\u0001\u00170\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj#\u0001B+oSR\f\u0001CY1tKJ+7o\\;sG\u0016\u0004\u0016\r\u001e5\u0016\u0003M\u0002\"\u0001N\u001d\u000e\u0003UR!AN\u001c\u0002\u0005%|'\"\u0001\u001d\u0002\t)\fg/Y\u0005\u0003uU\u0012AAR5mK\u0006q!/\u001a4fe\u0016t7-\u001a*fO\u0016DX#A\u001f\u0011\u0005y\u001aU\"A \u000b\u0005\u0001\u000b\u0015\u0001C7bi\u000eD\u0017N\\4\u000b\u0005\tk\u0013\u0001B;uS2L!\u0001R \u0003\u000bI+w-\u001a=\u0002\u001d9|'/\\1mSj,'+Z4fq\u0006Y\u0001\u000f\\1o\u0013\u0012\u0014VmZ3y\u0003\u001d\u0019Gn\u001d(b[\u0016,\u0012!\u0013\t\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019^\nA\u0001\\1oO&\u0011aj\u0013\u0002\u0007'R\u0014\u0018N\\4\u0002\u001d\u001d|G\u000eZ3o\r&dW\rU1uQV\t\u0011\u000b\u0005\u0002S3:\u00111k\u0016\t\u0003)6j\u0011!\u0016\u0006\u0003-n\ta\u0001\u0010:p_Rt\u0014B\u0001-.\u0003\u0019\u0001&/\u001a3fM&\u0011aJ\u0017\u0006\u000316\n\u0011#\u00199qe>4X\rZ!og&\u0004F.\u00198t+\u0005i\u0006c\u00010d#:\u0011q,\u0019\b\u0003)\u0002L\u0011AL\u0005\u0003E6\nq\u0001]1dW\u0006<W-\u0003\u0002eK\n\u00191+Z9\u000b\u0005\tl\u0013!D4fi\u0012K'OR8s)\u0016\u001cH\u000f\u0006\u00024Q\")\u0011.\u0003a\u0001#\u0006!a.Y7f\u0003)I7/\u00119qe>4X\r\u001a\u000b\u0005Y>\f8\u000f\u0005\u0002-[&\u0011a.\f\u0002\b\u0005>|G.Z1o\u0011\u0015\u0001(\u00021\u00014\u0003\r!\u0017N\u001d\u0005\u0006e*\u0001\r!U\u0001\u0015C\u000e$X/\u00197TS6\u0004H.\u001b4jK\u0012\u0004F.\u00198\t\u000bQT\u0001\u0019A)\u0002\u001b\u0005\u001cG/^1m\u000bb\u0004H.Y5o\u0003I9WM\\3sCR,wi\u001c7eK:4\u0015\u000e\\3\u0015\t-:XP \u0005\u0006q.\u0001\r!_\u0001\u0005a2\fg\u000e\u0005\u0002{w6\tQ%\u0003\u0002}K\tI1\u000b]1sWBc\u0017M\u001c\u0005\u0006S.\u0001\r!\u0015\u0005\u0006\u007f.\u0001\r!U\u0001\bKb\u0004H.Y5o\u0003E\u0019\u0007.Z2l/&$\b.\u00119qe>4X\r\u001a\u000b\bW\u0005\u0015\u0011qAA\u0005\u0011\u0015AH\u00021\u0001z\u0011\u0015IG\u00021\u0001R\u0011\u0015yH\u00021\u0001R\u0003E9W\r^*j[Bd\u0017NZ5fIBc\u0017M\u001c\u000b\u0004#\u0006=\u0001\"\u0002=\u000e\u0001\u0004I\u0018\u0001\u00048pe6\fG.\u001b>f\u0013\u0012\u001cHcA)\u0002\u0016!)\u0001P\u0004a\u0001#\u0006\tbn\u001c:nC2L'0\u001a'pG\u0006$\u0018n\u001c8\u0015\u0007E\u000bY\u0002C\u0003y\u001f\u0001\u0007\u0011+A\u0005uKN$\u0018+^3ssR91&!\t\u0002&\u0005%\u0002BBA\u0012!\u0001\u0007\u0011+\u0001\u0006ua\u000e$7o\u0012:pkBDa!a\n\u0011\u0001\u0004\t\u0016!B9vKJL\b\u0002CA\u0016!A\u0005\t\u0019A)\u0002\rM,hMZ5y\u0003M!Xm\u001d;Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t\tDK\u0002R\u0003gY#!!\u000e\u0011\t\u0005]\u0012\u0011I\u0007\u0003\u0003sQA!a\u000f\u0002>\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u007fi\u0013AC1o]>$\u0018\r^5p]&!\u00111IA\u001d\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public interface PlanStabilitySuite
extends DisableAdaptiveExecutionSuite {
    public void org$apache$spark$sql$PlanStabilitySuite$_setter_$baseResourcePath_$eq(File var1);

    public void org$apache$spark$sql$PlanStabilitySuite$_setter_$org$apache$spark$sql$PlanStabilitySuite$$referenceRegex_$eq(Regex var1);

    public void org$apache$spark$sql$PlanStabilitySuite$_setter_$org$apache$spark$sql$PlanStabilitySuite$$normalizeRegex_$eq(Regex var1);

    public void org$apache$spark$sql$PlanStabilitySuite$_setter_$org$apache$spark$sql$PlanStabilitySuite$$planIdRegex_$eq(Regex var1);

    public void org$apache$spark$sql$PlanStabilitySuite$_setter_$org$apache$spark$sql$PlanStabilitySuite$$clsName_$eq(String var1);

    public void org$apache$spark$sql$PlanStabilitySuite$_setter_$org$apache$spark$sql$PlanStabilitySuite$$approvedAnsiPlans_$eq(Seq<String> var1);

    public File baseResourcePath();

    public Regex org$apache$spark$sql$PlanStabilitySuite$$referenceRegex();

    public Regex org$apache$spark$sql$PlanStabilitySuite$$normalizeRegex();

    public Regex org$apache$spark$sql$PlanStabilitySuite$$planIdRegex();

    public String org$apache$spark$sql$PlanStabilitySuite$$clsName();

    public String goldenFilePath();

    public Seq<String> org$apache$spark$sql$PlanStabilitySuite$$approvedAnsiPlans();

    private File getDirForTest(String name) {
        String goldenFileName = SQLConf$.MODULE$.get().ansiEnabled() && this.org$apache$spark$sql$PlanStabilitySuite$$approvedAnsiPlans().contains((Object)name) ? new StringBuilder(5).append(name).append(".ansi").toString() : name;
        return new File(this.goldenFilePath(), goldenFileName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isApproved(File dir, String actualSimplifiedPlan, String actualExplain) {
        String expectedSimplified;
        LazyRef explainFile$lzy = new LazyRef();
        LazyRef expectedExplain$lzy = new LazyRef();
        File simplifiedFile = new File(dir, "simplified.txt");
        String string = expectedSimplified = FileUtils.readFileToString((File)simplifiedFile, (Charset)StandardCharsets.UTF_8);
        String string2 = actualSimplifiedPlan;
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = PlanStabilitySuite.expectedExplain$1(expectedExplain$lzy, explainFile$lzy, dir);
        String string4 = actualExplain;
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    private void generateGoldenFile(SparkPlan plan, String name, String explain) {
        block0: {
            boolean foundMatch;
            File dir = this.getDirForTest(name);
            String simplified = this.getSimplifiedPlan(plan);
            boolean bl = foundMatch = dir.exists() && this.isApproved(dir, simplified, explain);
            if (foundMatch) break block0;
            FileUtils.deleteDirectory((File)dir);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(dir.mkdirs(), "dir.mkdirs()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PlanStabilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
            File file = new File(dir, "simplified.txt");
            FileUtils.writeStringToFile((File)file, (String)simplified, (Charset)StandardCharsets.UTF_8);
            File fileOriginalPlan = new File(dir, "explain.txt");
            FileUtils.writeStringToFile((File)fileOriginalPlan, (String)explain, (Charset)StandardCharsets.UTF_8);
            this.logDebug((Function0 & Serializable)() -> new StringBuilder(11).append("APPROVED: ").append(file).append(" ").append(fileOriginalPlan).toString());
        }
    }

    private void checkWithApproved(SparkPlan plan, String name, String explain) {
        File dir = this.getDirForTest(name);
        File tempDir = FileUtils.getTempDirectory();
        String actualSimplified = this.getSimplifiedPlan(plan);
        boolean foundMatch = this.isApproved(dir, actualSimplified, explain);
        if (!foundMatch) {
            File approvedSimplifiedFile = new File(dir, "simplified.txt");
            File approvedExplainFile = new File(dir, "explain.txt");
            File actualSimplifiedFile = new File(tempDir, new StringBuilder(22).append(name).append(".actual.simplified.txt").toString());
            File actualExplainFile = new File(tempDir, new StringBuilder(19).append(name).append(".actual.explain.txt").toString());
            String approvedSimplified = FileUtils.readFileToString((File)approvedSimplifiedFile, (Charset)StandardCharsets.UTF_8);
            FileUtils.writeStringToFile((File)actualSimplifiedFile, (String)actualSimplified, (Charset)StandardCharsets.UTF_8);
            FileUtils.writeStringToFile((File)actualExplainFile, (String)explain, (Charset)StandardCharsets.UTF_8);
            throw ((Assertions)this).fail(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(253).append("\n          |Plans did not match:\n          |last approved simplified plan: ").append(approvedSimplifiedFile.getAbsolutePath()).append("\n          |last approved explain plan: ").append(approvedExplainFile.getAbsolutePath()).append("\n          |\n          |").append(approvedSimplified).append("\n          |\n          |actual simplified plan: ").append(actualSimplifiedFile.getAbsolutePath()).append("\n          |actual explain plan: ").append(actualExplainFile.getAbsolutePath()).append("\n          |\n          |").append(actualSimplified).append("\n        ").toString())), new Position("PlanStabilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        }
    }

    private String getSimplifiedPlan(SparkPlan plan) {
        HashMap exchangeIdMap = new HashMap();
        HashMap subqueriesMap = new HashMap();
        return this.simplifyNode$1(plan, 0, exchangeIdMap, subqueriesMap);
    }

    private String normalizeIds(String plan) {
        HashMap map = new HashMap();
        this.org$apache$spark$sql$PlanStabilitySuite$$normalizeRegex().findAllMatchIn((CharSequence)plan).map((Function1 & Serializable)x$4 -> x$4.toString()).foreach((Function1 & Serializable)x$5 -> (String)map.getOrElseUpdate(x$5, (Function0 & Serializable)() -> Integer.toString(map.size() + 1)));
        String exprIdNormalized = this.org$apache$spark$sql$PlanStabilitySuite$$normalizeRegex().replaceAllIn((CharSequence)plan, (Function1 & Serializable)regexMatch -> new StringBuilder(1).append("#").append(map.apply((Object)regexMatch.toString())).toString());
        HashMap planIdMap = new HashMap();
        this.org$apache$spark$sql$PlanStabilitySuite$$planIdRegex().findAllMatchIn((CharSequence)exprIdNormalized).map((Function1 & Serializable)x$6 -> x$6.toString()).foreach((Function1 & Serializable)x$7 -> (String)planIdMap.getOrElseUpdate(x$7, (Function0 & Serializable)() -> Integer.toString(planIdMap.size() + 1)));
        return this.org$apache$spark$sql$PlanStabilitySuite$$planIdRegex().replaceAllIn((CharSequence)exprIdNormalized, (Function1 & Serializable)regexMatch -> new StringBuilder(8).append("plan_id=").append(planIdMap.apply((Object)regexMatch.toString())).toString());
    }

    private String normalizeLocation(String plan) {
        return plan.replaceAll(new StringBuilder(11).append("Location.*").append(this.org$apache$spark$sql$PlanStabilitySuite$$clsName()).append("/").toString(), "Location [not included in comparison]/{warehouse_dir}/");
    }

    public static /* synthetic */ void testQuery$(PlanStabilitySuite $this, String tpcdsGroup, String query, String suffix) {
        $this.testQuery(tpcdsGroup, query, suffix);
    }

    default public void testQuery(String tpcdsGroup, String query, String suffix) {
        String x$1 = new StringBuilder(5).append(tpcdsGroup).append("/").append(query).append(".sql").toString();
        ClassLoader x$2 = Thread.currentThread().getContextClassLoader();
        String x$3 = package$.MODULE$.resourceToString$default$2();
        String queryString = package$.MODULE$.resourceToString(x$1, x$3, x$2);
        this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.READ_SIDE_CHAR_PADDING().key()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_NO_CHAR_PADDING_IN_PREDICATE().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()), (Object)"10MB")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            QueryExecution qe = ((Dataset)this.sql().apply((Object)queryString)).queryExecution();
            SparkPlan plan = qe.executedPlan();
            String explain = this.normalizeLocation(this.normalizeIds(qe.explainString((ExplainMode)FormattedMode$.MODULE$)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ValidateRequirements$.MODULE$.validate(plan), "org.apache.spark.sql.execution.exchange.ValidateRequirements.validate(plan)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PlanStabilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
            if (((SparkFunSuite)this).regenerateGoldenFiles()) {
                this.generateGoldenFile(plan, new StringBuilder(0).append(query).append(suffix).toString(), explain);
            } else {
                this.checkWithApproved(plan, new StringBuilder(0).append(query).append(suffix).toString(), explain);
            }
        });
    }

    public static /* synthetic */ String testQuery$default$3$(PlanStabilitySuite $this) {
        return $this.testQuery$default$3();
    }

    default public String testQuery$default$3() {
        return "";
    }

    private static /* synthetic */ File explainFile$lzycompute$1(LazyRef explainFile$lzy$1, File dir$1) {
        File file;
        LazyRef lazyRef = explainFile$lzy$1;
        synchronized (lazyRef) {
            file = explainFile$lzy$1.initialized() ? (File)explainFile$lzy$1.value() : (File)explainFile$lzy$1.initialize((Object)new File(dir$1, "explain.txt"));
        }
        return file;
    }

    private static File explainFile$1(LazyRef explainFile$lzy$1, File dir$1) {
        return explainFile$lzy$1.initialized() ? (File)explainFile$lzy$1.value() : PlanStabilitySuite.explainFile$lzycompute$1(explainFile$lzy$1, dir$1);
    }

    private static /* synthetic */ String expectedExplain$lzycompute$1(LazyRef expectedExplain$lzy$1, LazyRef explainFile$lzy$1, File dir$1) {
        String string;
        LazyRef lazyRef = expectedExplain$lzy$1;
        synchronized (lazyRef) {
            string = expectedExplain$lzy$1.initialized() ? (String)expectedExplain$lzy$1.value() : (String)expectedExplain$lzy$1.initialize((Object)FileUtils.readFileToString((File)PlanStabilitySuite.explainFile$1(explainFile$lzy$1, dir$1), (Charset)StandardCharsets.UTF_8));
        }
        return string;
    }

    private static String expectedExplain$1(LazyRef expectedExplain$lzy$1, LazyRef explainFile$lzy$1, File dir$1) {
        return expectedExplain$lzy$1.initialized() ? (String)expectedExplain$lzy$1.value() : PlanStabilitySuite.expectedExplain$lzycompute$1(expectedExplain$lzy$1, explainFile$lzy$1, dir$1);
    }

    private static int getId$1(SparkPlan plan, HashMap exchangeIdMap$1, HashMap subqueriesMap$1) {
        int n;
        SparkPlan sparkPlan2 = plan;
        if (sparkPlan2 instanceof Exchange) {
            Exchange exchange = (Exchange)sparkPlan2;
            n = BoxesRunTime.unboxToInt((Object)exchangeIdMap$1.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)exchange.id()), (Function0)(JFunction0.mcI.sp & Serializable)() -> exchangeIdMap$1.size() + 1));
        } else if (sparkPlan2 instanceof ReusedExchangeExec) {
            ReusedExchangeExec reusedExchangeExec = (ReusedExchangeExec)sparkPlan2;
            Exchange exchange = reusedExchangeExec.child();
            n = BoxesRunTime.unboxToInt((Object)exchangeIdMap$1.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)exchange.id()), (Function0)(JFunction0.mcI.sp & Serializable)() -> exchangeIdMap$1.size() + 1));
        } else if (sparkPlan2 instanceof SubqueryExec) {
            SubqueryExec subqueryExec = (SubqueryExec)sparkPlan2;
            n = BoxesRunTime.unboxToInt((Object)subqueriesMap$1.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)subqueryExec.id()), (Function0)(JFunction0.mcI.sp & Serializable)() -> subqueriesMap$1.size() + 1));
        } else if (sparkPlan2 instanceof SubqueryBroadcastExec) {
            SubqueryBroadcastExec subqueryBroadcastExec = (SubqueryBroadcastExec)sparkPlan2;
            n = BoxesRunTime.unboxToInt((Object)subqueriesMap$1.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)subqueryBroadcastExec.id()), (Function0)(JFunction0.mcI.sp & Serializable)() -> subqueriesMap$1.size() + 1));
        } else if (sparkPlan2 instanceof ReusedSubqueryExec) {
            ReusedSubqueryExec reusedSubqueryExec = (ReusedSubqueryExec)sparkPlan2;
            BaseSubqueryExec subquery = reusedSubqueryExec.child();
            n = BoxesRunTime.unboxToInt((Object)subqueriesMap$1.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)subquery.id()), (Function0)(JFunction0.mcI.sp & Serializable)() -> subqueriesMap$1.size() + 1));
        } else {
            n = -1;
        }
        return n;
    }

    private String cleanUpReferences$1(AttributeSet references) {
        return this.org$apache$spark$sql$PlanStabilitySuite$$referenceRegex().replaceAllIn((CharSequence)((IterableOnceOps)references.map((Function1 & Serializable)x$1 -> x$1.name())).mkString(","), "");
    }

    private String simplifyNode$1(SparkPlan node, int depth, HashMap exchangeIdMap$1, HashMap subqueriesMap$1) {
        int id;
        String padding = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("  "), depth);
        String thisNode = node.nodeName();
        if (node.references().nonEmpty()) {
            thisNode = new StringBuilder(0).append(thisNode).append(new StringBuilder(3).append(" [").append(this.cleanUpReferences$1(node.references())).append("]").toString()).toString();
        }
        if (node.producedAttributes().nonEmpty()) {
            thisNode = new StringBuilder(0).append(thisNode).append(new StringBuilder(3).append(" [").append(this.cleanUpReferences$1(node.producedAttributes())).append("]").toString()).toString();
        }
        if ((id = PlanStabilitySuite.getId$1(node, exchangeIdMap$1, subqueriesMap$1)) > 0) {
            thisNode = new StringBuilder(0).append(thisNode).append(new StringBuilder(2).append(" #").append(id).toString()).toString();
        }
        Seq childrenSimplified = (Seq)node.children().map((Function1 & Serializable)x$2 -> this.simplifyNode$1((SparkPlan)x$2, depth + 1, exchangeIdMap$1, subqueriesMap$1));
        Seq subqueriesSimplified = (Seq)node.subqueries().map((Function1 & Serializable)x$3 -> this.simplifyNode$1((SparkPlan)x$3, depth + 1, exchangeIdMap$1, subqueriesMap$1));
        return new StringBuilder(1).append(padding).append(thisNode).append("\n").append(subqueriesSimplified.mkString("")).append(childrenSimplified.mkString("")).toString();
    }

    public static void $init$(PlanStabilitySuite $this) {
        $this.org$apache$spark$sql$PlanStabilitySuite$_setter_$baseResourcePath_$eq(((SparkFunSuite)$this).getWorkspaceFilePath("sql", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"core", "src", "test", "resources", "tpcds-plan-stability"})).toFile());
        $this.org$apache$spark$sql$PlanStabilitySuite$_setter_$org$apache$spark$sql$PlanStabilitySuite$$referenceRegex_$eq(StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("#\\d+")));
        $this.org$apache$spark$sql$PlanStabilitySuite$_setter_$org$apache$spark$sql$PlanStabilitySuite$$normalizeRegex_$eq(StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("#\\d+L?")));
        $this.org$apache$spark$sql$PlanStabilitySuite$_setter_$org$apache$spark$sql$PlanStabilitySuite$$planIdRegex_$eq(StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("plan_id=\\d+")));
        $this.org$apache$spark$sql$PlanStabilitySuite$_setter_$org$apache$spark$sql$PlanStabilitySuite$$clsName_$eq($this.getClass().getCanonicalName());
        $this.org$apache$spark$sql$PlanStabilitySuite$_setter_$org$apache$spark$sql$PlanStabilitySuite$$approvedAnsiPlans_$eq((Seq<String>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"q83", "q83.sf100"}))));
    }
}

