/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector;

import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.connector.DeleteFromTableSuiteBase$;
import org.apache.spark.sql.connector.RowLevelOperationSuiteBase;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.v2.DeleteFromTableExec;
import org.apache.spark.sql.execution.datasources.v2.ReplaceDataExec;
import org.apache.spark.sql.execution.datasources.v2.WriteDeltaExec;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005A2Q\u0001B\u0003\u0002\u0002AAQ!\u0006\u0001\u0005\u0002YAQ\u0001\u0007\u0001\u0005\neAQ!\f\u0001\u0005\n9\u0012\u0001\u0004R3mKR,gI]8n)\u0006\u0014G.Z*vSR,')Y:f\u0015\t1q!A\u0005d_:tWm\u0019;pe*\u0011\u0001\"C\u0001\u0004gFd'B\u0001\u0006\f\u0003\u0015\u0019\b/\u0019:l\u0015\taQ\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001d\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0005\t\u0003%Mi\u0011!B\u0005\u0003)\u0015\u0011!DU8x\u0019\u00164X\r\\(qKJ\fG/[8o'VLG/\u001a\"bg\u0016\fa\u0001P5oSRtD#A\f\u0011\u0005I\u0001\u0011\u0001G3yK\u000e,H/\u001a#fY\u0016$XmV5uQ\u001aKG\u000e^3sgR\u0011!\u0004\t\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0005+:LG\u000fC\u0003\"\u0005\u0001\u0007!%A\u0003rk\u0016\u0014\u0018\u0010\u0005\u0002$U9\u0011A\u0005\u000b\t\u0003Kqi\u0011A\n\u0006\u0003O=\ta\u0001\u0010:p_Rt\u0014BA\u0015\u001d\u0003\u0019\u0001&/\u001a3fM&\u00111\u0006\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%b\u0012\u0001G3yK\u000e,H/\u001a#fY\u0016$XmV5uQJ+wO]5uKR\u0011!d\f\u0005\u0006C\r\u0001\rA\t")
public abstract class DeleteFromTableSuiteBase
extends RowLevelOperationSuiteBase {
    private void executeDeleteWithFilters(String query) {
        SparkPlan executedPlan = this.executeAndKeepPlan((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.sql().apply((Object)query));
        SparkPlan sparkPlan2 = executedPlan;
        if (!(sparkPlan2 instanceof DeleteFromTableExec)) {
            throw this.fail(new StringBuilder(26).append("unexpected executed plan: ").append(sparkPlan2).toString(), new Position("DeleteFromTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 521));
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void executeDeleteWithRewrite(String query) {
        SparkPlan executedPlan = this.executeAndKeepPlan((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.sql().apply((Object)query));
        SparkPlan sparkPlan2 = executedPlan;
        if (sparkPlan2 instanceof ReplaceDataExec) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkPlan2 instanceof WriteDeltaExec) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw this.fail(new StringBuilder(26).append("unexpected executed plan: ").append(sparkPlan2).toString(), new Position("DeleteFromTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 536));
        }
    }

    public DeleteFromTableSuiteBase() {
        this.test("EXPLAIN only delete", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("id INT, dep STRING", "{ \"id\": 1, \"dep\": \"hr\" }");
            this.sql().apply((Object)new StringBuilder(35).append("EXPLAIN DELETE FROM ").append(this.tableNameAsString()).append(" WHERE id <= 10").toString());
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row));
        }, new Position("DeleteFromTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 27));
        this.test("delete from empty tables", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createTable("pk INT NOT NULL, id INT, dep STRING");
            this.sql().apply((Object)new StringBuilder(26).append("DELETE FROM ").append(this.tableNameAsString()).append(" WHERE id <= 1").toString());
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil());
        }, new Position("DeleteFromTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        this.test("delete with basic filters", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"dep\": \"hr\" }\n        |{ \"pk\": 2, \"id\": 2, \"dep\": \"software\" }\n        |{ \"pk\": 3, \"id\": 3, \"dep\": \"hr\" }\n        |")));
            this.sql().apply((Object)new StringBuilder(26).append("DELETE FROM ").append(this.tableNameAsString()).append(" WHERE id <= 1").toString());
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "software"}));
            Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3), "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row2).$colon$colon((Object)row));
        }, new Position("DeleteFromTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("delete with aliases", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"dep\": \"hr\" }\n        |{ \"pk\": 2, \"id\": 2, \"dep\": \"software\" }\n        |{ \"pk\": 3, \"id\": 3, \"dep\": \"hr\" }\n        |")));
            this.sql().apply((Object)new StringBuilder(49).append("DELETE FROM ").append(this.tableNameAsString()).append(" AS t WHERE t.id <= 1 OR t.dep = 'hr'").toString());
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "software"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row));
        }, new Position("DeleteFromTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test("delete with IN predicates", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"dep\": \"hr\" }\n        |{ \"pk\": 2, \"id\": 2, \"dep\": \"software\" }\n        |{ \"pk\": 3, \"id\": null, \"dep\": \"hr\" }\n        |")));
            this.sql().apply((Object)new StringBuilder(34).append("DELETE FROM ").append(this.tableNameAsString()).append(" WHERE id IN (1, null)").toString());
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "software"}));
            Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row2).$colon$colon((Object)row));
        }, new Position("DeleteFromTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("delete with NOT IN predicates", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"dep\": \"hr\" }\n        |{ \"pk\": 2, \"id\": 2, \"dep\": \"software\" }\n        |{ \"pk\": 3, \"id\": null, \"dep\": \"hr\" }\n        |")));
            this.sql().apply((Object)new StringBuilder(38).append("DELETE FROM ").append(this.tableNameAsString()).append(" WHERE id NOT IN (null, 1)").toString());
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "hr"}));
            Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "software"}));
            Row row3 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
            this.sql().apply((Object)new StringBuilder(36).append("DELETE FROM ").append(this.tableNameAsString()).append(" WHERE id NOT IN (1, 10)").toString());
            Row row4 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "hr"}));
            Row row5 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row5).$colon$colon((Object)row4));
        }, new Position("DeleteFromTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.test("delete with conditions on nested columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, complex STRUCT<c1:INT,c2:STRING>, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"complex\": { \"c1\": 3, \"c2\": \"v1\" }, \"dep\": \"hr\" }\n        |{ \"pk\": 2, \"id\": 2, \"complex\": { \"c1\": 2, \"c2\": \"v2\" }, \"dep\": \"software\" }\n        |")));
            this.sql().apply((Object)new StringBuilder(38).append("DELETE FROM ").append(this.tableNameAsString()).append(" WHERE complex.c1 = id + 2").toString());
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "v2"})), "software"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row));
            this.sql().apply((Object)new StringBuilder(38).append("DELETE FROM ").append(this.tableNameAsString()).append(" t WHERE t.complex.c1 = id").toString());
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil());
        }, new Position("DeleteFromTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("delete with IN subqueries", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"deleted_id", "deleted_dep"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"id\": 2, \"dep\": \"hardware\" }\n          |{ \"pk\": 3, \"id\": null, \"dep\": \"hr\" }\n          |")));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DeleteFromTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_DeleteFromTableSuiteBase$$typecreator10$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_connector_DeleteFromTableSuiteBase$$typecreator10$1(DeleteFromTableSuiteBase $outer) {
                }
            }
            Dataset deletedIdDF = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{new Some((Object)BoxesRunTime.boxToInteger((int)0)), new Some((Object)BoxesRunTime.boxToInteger((int)1)), None$.MODULE$})), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DeleteFromTableSuiteBase$$typecreator10$1(null)))).toDF();
            deletedIdDF.createOrReplaceTempView("deleted_id");
            Dataset deletedDepDF = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"software", "hr"})), this.testImplicits().newStringEncoder()).toDF();
            deletedDepDF.createOrReplaceTempView("deleted_dep");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(154).append("DELETE FROM ").append(this.tableNameAsString()).append("\n           |WHERE\n           | id IN (SELECT * FROM deleted_id)\n           | AND\n           | dep IN (SELECT * FROM deleted_dep)\n           |").toString())));
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "hardware"}));
            Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row2).$colon$colon((Object)row));
            this.append("pk INT NOT NULL, id INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 4, \"id\": 1, \"dep\": \"hr\" }\n          |{ \"pk\": 5, \"id\": -1, \"dep\": \"hr\" }\n          |")));
            Row row3 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)-1), "hr"}));
            Row row4 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)1), "hr"}));
            Row row5 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "hardware"}));
            Row row6 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row6).$colon$colon((Object)row5).$colon$colon((Object)row4).$colon$colon((Object)row3));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(137).append("DELETE FROM ").append(this.tableNameAsString()).append("\n           |WHERE\n           | id IS NULL\n           | OR\n           | id IN (SELECT value + 2 FROM deleted_id)\n           |").toString())));
            Row row7 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)-1), "hr"}));
            Row row8 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)1), "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row8).$colon$colon((Object)row7));
            this.append("pk INT NOT NULL, id INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 6, \"id\": null, \"dep\": \"hr\" }\n          |{ \"pk\": 7, \"id\": 2, \"dep\": \"hr\" }\n          |")));
            Row row9 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)-1), "hr"}));
            Row row10 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)1), "hr"}));
            Row row11 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), BoxesRunTime.boxToInteger((int)2), "hr"}));
            Row row12 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row12).$colon$colon((Object)row11).$colon$colon((Object)row10).$colon$colon((Object)row9));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(138).append("DELETE FROM ").append(this.tableNameAsString()).append("\n           |WHERE\n           | id IN (SELECT value + 2 FROM deleted_id)\n           | AND\n           | dep = 'hr'\n           |").toString())));
            Row row13 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)-1), "hr"}));
            Row row14 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)1), "hr"}));
            Row row15 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row15).$colon$colon((Object)row14).$colon$colon((Object)row13));
        }), new Position("DeleteFromTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        this.test("delete with multi-column IN subqueries", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"deleted_employee"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"id\": 2, \"dep\": \"hardware\" }\n          |{ \"pk\": 3, \"id\": null, \"dep\": \"hr\" }\n          |")));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DeleteFromTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_DeleteFromTableSuiteBase$$typecreator28$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connector_DeleteFromTableSuiteBase$$typecreator28$1(DeleteFromTableSuiteBase $outer) {
                }
            }
            Dataset deletedEmployeeDF = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)None$.MODULE$, (Object)"hr"), new Tuple2((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"hr")})), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DeleteFromTableSuiteBase$$typecreator28$1(null)))).toDF();
            deletedEmployeeDF.createOrReplaceTempView("deleted_employee");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(102).append("DELETE FROM ").append(this.tableNameAsString()).append("\n           |WHERE\n           | (id, dep) IN (SELECT * FROM deleted_employee)\n           |").toString())));
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "hardware"}));
            Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row2).$colon$colon((Object)row));
        }), new Position("DeleteFromTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        this.test("delete with NOT IN subqueries", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"deleted_id", "deleted_dep"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"id\": 2, \"dep\": \"hardware\" }\n          |{ \"pk\": 3, \"id\": null, \"dep\": \"hr\" }\n          |")));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DeleteFromTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_DeleteFromTableSuiteBase$$typecreator38$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_connector_DeleteFromTableSuiteBase$$typecreator38$1(DeleteFromTableSuiteBase $outer) {
                }
            }
            Dataset deletedIdDF = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{new Some((Object)BoxesRunTime.boxToInteger((int)-1)), new Some((Object)BoxesRunTime.boxToInteger((int)-2)), None$.MODULE$})), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DeleteFromTableSuiteBase$$typecreator38$1(null)))).toDF();
            deletedIdDF.createOrReplaceTempView("deleted_id");
            Dataset deletedDepDF = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"software", "hr"})), this.testImplicits().newStringEncoder()).toDF();
            deletedDepDF.createOrReplaceTempView("deleted_dep");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(93).append("DELETE FROM ").append(this.tableNameAsString()).append("\n           |WHERE\n           | id NOT IN (SELECT * FROM deleted_id)\n           |").toString())));
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "hr"}));
            Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "hardware"}));
            Row row3 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(117).append("DELETE FROM ").append(this.tableNameAsString()).append("\n           |WHERE\n           | id NOT IN (SELECT * FROM deleted_id WHERE value IS NOT NULL)\n           |").toString())));
            Row row4 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row4));
            this.append("pk INT NOT NULL, id INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 4, \"id\": 1, \"dep\": \"hr\" }\n          |{ \"pk\": 5, \"id\": 2, \"dep\": \"hardware\" }\n          |{ \"pk\": 6, \"id\": null, \"dep\": \"hr\" }\n          |")));
            Row row5 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)1), "hr"}));
            Row row6 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)2), "hardware"}));
            Row row7 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "hr"}));
            Row row8 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row8).$colon$colon((Object)row7).$colon$colon((Object)row6).$colon$colon((Object)row5));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(148).append("DELETE FROM ").append(this.tableNameAsString()).append("\n           |WHERE\n           | id NOT IN (SELECT * FROM deleted_id)\n           | OR\n           | dep IN ('software', 'hr')\n           |").toString())));
            Row row9 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)2), "hardware"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row9));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(217).append("DELETE FROM ").append(this.tableNameAsString()).append("\n           |WHERE\n           | id NOT IN (SELECT * FROM deleted_id WHERE value IS NOT NULL)\n           | AND\n           | EXISTS (SELECT 1 FROM FROM deleted_dep WHERE dep = deleted_dep.value)\n           |").toString())));
            Row row10 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)2), "hardware"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row10));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(222).append("DELETE FROM ").append(this.tableNameAsString()).append(" t\n           |WHERE\n           | t.id NOT IN (SELECT * FROM deleted_id WHERE value IS NOT NULL)\n           | OR\n           | EXISTS (SELECT 1 FROM FROM deleted_dep WHERE t.dep = deleted_dep.value)\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil());
        }), new Position("DeleteFromTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
        this.test("delete with EXISTS subquery", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"deleted_id", "deleted_dep"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"id\": 2, \"dep\": \"hardware\" }\n          |{ \"pk\": 3, \"id\": null, \"dep\": \"hr\" }\n          |")));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DeleteFromTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_DeleteFromTableSuiteBase$$typecreator56$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_connector_DeleteFromTableSuiteBase$$typecreator56$1(DeleteFromTableSuiteBase $outer) {
                }
            }
            Dataset deletedIdDF = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{new Some((Object)BoxesRunTime.boxToInteger((int)-1)), new Some((Object)BoxesRunTime.boxToInteger((int)-2)), None$.MODULE$})), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DeleteFromTableSuiteBase$$typecreator56$1(null)))).toDF();
            deletedIdDF.createOrReplaceTempView("deleted_id");
            Dataset deletedDepDF = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"software", "hr"})), this.testImplicits().newStringEncoder()).toDF();
            deletedDepDF.createOrReplaceTempView("deleted_dep");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(115).append("DELETE FROM ").append(this.tableNameAsString()).append(" t\n           |WHERE\n           | EXISTS (SELECT 1 FROM deleted_id d WHERE t.id = d.value)\n           |").toString())));
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "hr"}));
            Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "hardware"}));
            Row row3 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(119).append("DELETE FROM ").append(this.tableNameAsString()).append(" t\n           |WHERE\n           | EXISTS (SELECT 1 FROM deleted_id d WHERE t.id = d.value + 2)\n           |").toString())));
            Row row4 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "hardware"}));
            Row row5 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row5).$colon$colon((Object)row4));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(131).append("DELETE FROM ").append(this.tableNameAsString()).append(" t\n           |WHERE\n           | EXISTS (SELECT 1 FROM deleted_id d WHERE t.id = d.value) OR t.id IS NULL\n           |").toString())));
            Row row6 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "hardware"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row6));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(208).append("DELETE FROM ").append(this.tableNameAsString()).append(" t\n           |WHERE\n           | EXISTS (SELECT 1 FROM deleted_id di WHERE t.id = di.value)\n           | AND\n           | EXISTS (SELECT 1 FROM deleted_dep dd WHERE t.dep = dd.value)\n           |").toString())));
            Row row7 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "hardware"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row7));
        }), new Position("DeleteFromTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
        this.test("delete with NOT EXISTS subquery", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"deleted_id", "deleted_dep"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"id\": 2, \"dep\": \"hardware\" }\n          |{ \"pk\": 3, \"id\": null, \"dep\": \"hr\" }\n          |")));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DeleteFromTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_DeleteFromTableSuiteBase$$typecreator74$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_connector_DeleteFromTableSuiteBase$$typecreator74$1(DeleteFromTableSuiteBase $outer) {
                }
            }
            Dataset deletedIdDF = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{new Some((Object)BoxesRunTime.boxToInteger((int)-1)), new Some((Object)BoxesRunTime.boxToInteger((int)-2)), None$.MODULE$})), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DeleteFromTableSuiteBase$$typecreator74$1(null)))).toDF();
            deletedIdDF.createOrReplaceTempView("deleted_id");
            Dataset deletedDepDF = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"software", "hr"})), this.testImplicits().newStringEncoder()).toDF();
            deletedDepDF.createOrReplaceTempView("deleted_dep");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(220).append("DELETE FROM ").append(this.tableNameAsString()).append(" t\n           |WHERE\n           | NOT EXISTS (SELECT 1 FROM deleted_id di WHERE t.id = di.value + 2)\n           | AND\n           | NOT EXISTS (SELECT 1 FROM deleted_dep dd WHERE t.dep = dd.value)\n           |").toString())));
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "hr"}));
            Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row2).$colon$colon((Object)row));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(123).append("DELETE FROM ").append(this.tableNameAsString()).append(" t\n           |WHERE\n           | NOT EXISTS (SELECT 1 FROM deleted_id d WHERE t.id = d.value + 2)\n           |").toString())));
            Row row3 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row3));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(161).append("DELETE FROM ").append(this.tableNameAsString()).append(" t\n           |WHERE\n           | NOT EXISTS (SELECT 1 FROM deleted_id d WHERE t.id = d.value + 2)\n           | OR\n           | t.id = 1\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil());
        }), new Position("DeleteFromTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
        this.test("delete with a scalar subquery", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"deleted_id"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"id\": 2, \"dep\": \"hardware\" }\n          |{ \"pk\": 3, \"id\": null, \"dep\": \"hr\" }\n          |")));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DeleteFromTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_DeleteFromTableSuiteBase$$typecreator92$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_connector_DeleteFromTableSuiteBase$$typecreator92$1(DeleteFromTableSuiteBase $outer) {
                }
            }
            Dataset deletedIdDF = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{new Some((Object)BoxesRunTime.boxToInteger((int)1)), new Some((Object)BoxesRunTime.boxToInteger((int)100)), None$.MODULE$})), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DeleteFromTableSuiteBase$$typecreator92$1(null)))).toDF();
            deletedIdDF.createOrReplaceTempView("deleted_id");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(100).append("DELETE FROM ").append(this.tableNameAsString()).append(" t\n           |WHERE\n           | id <= (SELECT min(value) FROM deleted_id)\n           |").toString())));
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "hardware"}));
            Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), null, "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row2).$colon$colon((Object)row));
        }), new Position("DeleteFromTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393));
        this.test("delete refreshes relation cache", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"temp"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withCache((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"temp"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"dep\": \"hr\" }\n            |{ \"pk\": 2, \"id\": 1, \"dep\": \"hardware\" }\n            |{ \"pk\": 3, \"id\": 2, \"dep\": \"hardware\" }\n            |{ \"pk\": 4, \"id\": 3, \"dep\": \"hr\" }\n            |")));
            Dataset query = (Dataset)this.sql().apply((Object)new StringBuilder(27).append("SELECT * FROM ").append(this.tableNameAsString()).append(" WHERE id = 1").toString());
            query.createOrReplaceTempView("temp");
            this.sql().apply((Object)"CACHE TABLE temp");
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "hr"}));
            Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), "hardware"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM temp"), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row2).$colon$colon((Object)row));
            this.sql().apply((Object)new StringBuilder(26).append("DELETE FROM ").append(this.tableNameAsString()).append(" WHERE id <= 1").toString());
            Row row3 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), "hardware"}));
            Row row4 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)3), "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row4).$colon$colon((Object)row3));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM temp"), (Seq<Row>)scala.package$.MODULE$.Nil());
        })), new Position("DeleteFromTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416));
        this.test("delete without condition executed as delete with filters", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, dep INT", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"dep\": 100 }\n        |{ \"pk\": 2, \"id\": 2, \"dep\": 200 }\n        |{ \"pk\": 3, \"id\": 3, \"dep\": 100 }\n        |")));
            this.executeDeleteWithFilters(new StringBuilder(12).append("DELETE FROM ").append(this.tableNameAsString()).toString());
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil());
        }, new Position("DeleteFromTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 452));
        this.test("delete with supported predicates gets converted into delete with filters", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, dep INT", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"dep\": 100 }\n        |{ \"pk\": 2, \"id\": 2, \"dep\": 200 }\n        |{ \"pk\": 3, \"id\": 3, \"dep\": 100 }\n        |")));
            this.executeDeleteWithFilters(new StringBuilder(28).append("DELETE FROM ").append(this.tableNameAsString()).append(" WHERE dep = 100").toString());
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200)}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row));
        }, new Position("DeleteFromTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 464));
        this.test("delete with unsupported predicates cannot be converted into delete with filters", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, dep INT", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"dep\": 100 }\n        |{ \"pk\": 2, \"id\": 2, \"dep\": 200 }\n        |{ \"pk\": 3, \"id\": 3, \"dep\": 100 }\n        |")));
            this.executeDeleteWithRewrite(new StringBuilder(41).append("DELETE FROM ").append(this.tableNameAsString()).append(" WHERE dep = 100 OR dep < 200").toString());
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200)}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row));
        }, new Position("DeleteFromTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 478));
        this.test("delete with subquery cannot be converted into delete with filters", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"deleted_id"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, dep INT", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"dep\": 100 }\n          |{ \"pk\": 2, \"id\": 2, \"dep\": 200 }\n          |{ \"pk\": 3, \"id\": 3, \"dep\": 100 }\n          |")));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DeleteFromTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_DeleteFromTableSuiteBase$$typecreator102$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_connector_DeleteFromTableSuiteBase$$typecreator102$1(DeleteFromTableSuiteBase $outer) {
                }
            }
            Dataset deletedIdDF = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{new Some((Object)BoxesRunTime.boxToInteger((int)1)), new Some((Object)BoxesRunTime.boxToInteger((int)100)), None$.MODULE$})), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DeleteFromTableSuiteBase$$typecreator102$1(null)))).toDF();
            deletedIdDF.createOrReplaceTempView("deleted_id");
            String q = new StringBuilder(65).append("DELETE FROM ").append(this.tableNameAsString()).append(" WHERE dep = 100 AND id IN (SELECT * FROM deleted_id)").toString();
            this.executeDeleteWithRewrite(q);
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200)}));
            Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)100)}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row2).$colon$colon((Object)row));
        }), new Position("DeleteFromTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
    }
}

