/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.connector.UpdateTableSuiteBase;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005Y1QAA\u0002\u0002\u00029AQa\u0005\u0001\u0005\u0002Q\u0011a\u0004R3mi\u0006\u0014\u0015m]3e+B$\u0017\r^3UC\ndWmU;ji\u0016\u0014\u0015m]3\u000b\u0005\u0011)\u0011!C2p]:,7\r^8s\u0015\t1q!A\u0002tc2T!\u0001C\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005)Y\u0011AB1qC\u000eDWMC\u0001\r\u0003\ry'oZ\u0002\u0001'\t\u0001q\u0002\u0005\u0002\u0011#5\t1!\u0003\u0002\u0013\u0007\t!R\u000b\u001d3bi\u0016$\u0016M\u00197f'VLG/\u001a\"bg\u0016\fa\u0001P5oSRtD#A\u000b\u0011\u0005A\u0001\u0001")
public abstract class DeltaBasedUpdateTableSuiteBase
extends UpdateTableSuiteBase {
    public DeltaBasedUpdateTableSuiteBase() {
        this.test("nullable row ID attrs", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 300, \"dep\": 'hr' }\n        |{ \"pk\": 2, \"salary\": 150, \"dep\": 'software' }\n        |{ \"pk\": 3, \"salary\": 120, \"dep\": 'hr' }\n        |")));
            this.checkErrorMatchPVals((SparkThrowable)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(36).append("UPDATE ").append(this.tableNameAsString()).append(" SET salary = -1 WHERE pk = 1").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DeltaBasedUpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32)), "NULLABLE_ROW_ID_ATTRIBUTES", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nullableRowIdAttrs"), (Object)"pk#\\d+")})));
        }, new Position("DeltaBasedUpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 24));
        this.test("update with assignments to row ID", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"dep\": \"hr\" }\n        |{ \"pk\": 2, \"id\": 2, \"dep\": \"software\" }\n        |{ \"pk\": 3, \"id\": 3, \"dep\": \"hr\" }\n        |")));
            this.sql().apply((Object)new StringBuilder(32).append("UPDATE ").append(this.tableNameAsString()).append(" SET pk = 10 WHERE id = 1").toString());
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1), "hr"}));
            Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "software"}));
            Row row3 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3), "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)package$.MODULE$.Nil().$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
        }, new Position("DeltaBasedUpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        this.test("update with nondeterministic conditions", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"dep\": \"hr\" }\n        |{ \"pk\": 2, \"id\": 2, \"dep\": \"software\" }\n        |{ \"pk\": 3, \"id\": 3, \"dep\": \"hr\" }\n        |")));
            this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(58).append("UPDATE ").append(this.tableNameAsString()).append(" SET dep = 'invalid' WHERE id <= 1 AND rand() > 0.5").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DeltaBasedUpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62)), "INVALID_NON_DETERMINISTIC_EXPRESSIONS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExprs"), (Object)"\"((id <= 1) AND (rand() > 0.5))\"")})), (QueryContext)this.ExpectedContext().apply("UPDATE cat.ns1.test_table SET dep = 'invalid' WHERE id <= 1 AND rand() > 0.5", 0, 75));
        }, new Position("DeltaBasedUpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("update with schema pruning", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"salary\": 100, \"dep\": \"hr\" }\n        |{ \"pk\": 2, \"id\": 2, \"salary\": 200, \"dep\": \"software\" }\n        |{ \"pk\": 3, \"id\": 3, \"salary\": 300, \"dep\": \"hr\" }\n        |")));
            this.executeAndCheckScan(new StringBuilder(62).append("UPDATE ").append(this.tableNameAsString()).append(" SET salary = -1, id = -1, dep = 'invalid' WHERE pk = 1").toString(), "pk INT, _partition STRING");
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)-1), BoxesRunTime.boxToInteger((int)-1), "invalid"}));
            Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "software"}));
            Row row3 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)300), "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)package$.MODULE$.Nil().$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
        }, new Position("DeltaBasedUpdateTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
    }
}

