/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector;

import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.optimizer.BuildLeft$;
import org.apache.spark.sql.catalyst.optimizer.BuildSide;
import org.apache.spark.sql.connector.MergeIntoTableSuiteBase$;
import org.apache.spark.sql.connector.RowLevelOperationSuiteBase;
import org.apache.spark.sql.connector.catalog.Column;
import org.apache.spark.sql.connector.catalog.ColumnDefaultValue;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.connector.expressions.LiteralValue;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.joins.BroadcastHashJoinExec;
import org.apache.spark.sql.execution.joins.BroadcastNestedLoopJoinExec;
import org.apache.spark.sql.execution.joins.CartesianProductExec;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005i2Q!\u0002\u0004\u0002\u0002EAQA\u0006\u0001\u0005\u0002]AQ!\u0007\u0001\u0005\niAQ!\u0007\u0001\u0005\n9BQa\u000e\u0001\u0005\na\u0012q#T3sO\u0016Le\u000e^8UC\ndWmU;ji\u0016\u0014\u0015m]3\u000b\u0005\u001dA\u0011!C2p]:,7\r^8s\u0015\tI!\"A\u0002tc2T!a\u0003\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014)5\ta!\u0003\u0002\u0016\r\tQ\"k\\<MKZ,Gn\u00149fe\u0006$\u0018n\u001c8Tk&$XMQ1tK\u00061A(\u001b8jiz\"\u0012\u0001\u0007\t\u0003'\u0001\t!%Y:tKJ$hj\u001c'fMR\u0014%o\\1eG\u0006\u001cHo\u0014:SKBd\u0017nY1uS>tGCA\u000e\"!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0011)f.\u001b;\t\u000b\t\u0012\u0001\u0019A\u0012\u0002\u000bE,XM]=\u0011\u0005\u0011ZcBA\u0013*!\t1S$D\u0001(\u0015\tA\u0003#\u0001\u0004=e>|GOP\u0005\u0003Uu\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0017.\u0005\u0019\u0019FO]5oO*\u0011!&\b\u000b\u00037=BQ\u0001M\u0002A\u0002E\nA\u0001\u001d7b]B\u0011!'N\u0007\u0002g)\u0011A\u0007C\u0001\nKb,7-\u001e;j_:L!AN\u001a\u0003\u0013M\u0003\u0018M]6QY\u0006t\u0017AF1tg\u0016\u0014HoQ1sI&t\u0017\r\\5us\u0016\u0013(o\u001c:\u0015\u0005mI\u0004\"\u0002\u0012\u0005\u0001\u0004\u0019\u0003")
public abstract class MergeIntoTableSuiteBase
extends RowLevelOperationSuiteBase {
    private void assertNoLeftBroadcastOrReplication(String query) {
        SparkPlan plan = this.executeAndKeepPlan((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.sql().apply((Object)query));
        this.assertNoLeftBroadcastOrReplication(plan);
    }

    private void assertNoLeftBroadcastOrReplication(SparkPlan plan) {
        Seq joins;
        Seq $org_scalatest_assert_macro_left = joins = plan.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var3_10;
                A1 A1 = x1;
                if (A1 instanceof BroadcastHashJoinExec) {
                    BroadcastHashJoinExec broadcastHashJoinExec = (BroadcastHashJoinExec)A1;
                    BuildSide buildSide = broadcastHashJoinExec.buildSide();
                    BuildLeft$ buildLeft$ = BuildLeft$.MODULE$;
                    if (!(buildSide != null ? !buildSide.equals(buildLeft$) : buildLeft$ != null)) {
                        BroadcastHashJoinExec broadcastHashJoinExec2 = broadcastHashJoinExec;
                        return var3_10;
                    }
                }
                if (A1 instanceof BroadcastNestedLoopJoinExec) {
                    BroadcastNestedLoopJoinExec broadcastNestedLoopJoinExec = (BroadcastNestedLoopJoinExec)A1;
                    BuildSide buildSide = broadcastNestedLoopJoinExec.buildSide();
                    BuildLeft$ buildLeft$ = BuildLeft$.MODULE$;
                    if (!(buildSide != null ? !buildSide.equals(buildLeft$) : buildLeft$ != null)) {
                        BroadcastNestedLoopJoinExec broadcastNestedLoopJoinExec2 = broadcastNestedLoopJoinExec;
                        return var3_10;
                    }
                }
                if (A1 instanceof CartesianProductExec) {
                    CartesianProductExec cartesianProductExec;
                    CartesianProductExec cartesianProductExec2 = cartesianProductExec = (CartesianProductExec)A1;
                    return var3_10;
                }
                Object object = function1.apply(x1);
                return var3_10;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan2 = x1;
                if (sparkPlan2 instanceof BroadcastHashJoinExec) {
                    BroadcastHashJoinExec broadcastHashJoinExec = (BroadcastHashJoinExec)sparkPlan2;
                    BuildSide buildSide = broadcastHashJoinExec.buildSide();
                    BuildLeft$ buildLeft$ = BuildLeft$.MODULE$;
                    if (buildSide == null) {
                        if (buildLeft$ == null) return true;
                    } else if (buildSide.equals(buildLeft$)) {
                        return true;
                    }
                }
                if (sparkPlan2 instanceof BroadcastNestedLoopJoinExec) {
                    BroadcastNestedLoopJoinExec broadcastNestedLoopJoinExec = (BroadcastNestedLoopJoinExec)sparkPlan2;
                    BuildSide buildSide = broadcastNestedLoopJoinExec.buildSide();
                    BuildLeft$ buildLeft$ = BuildLeft$.MODULE$;
                    if (buildSide == null) {
                        if (buildLeft$ == null) return true;
                    } else if (buildSide.equals(buildLeft$)) {
                        return true;
                    }
                }
                if (!(sparkPlan2 instanceof CartesianProductExec)) return false;
                return true;
            }
        });
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"left side must not be broadcasted or replicated", Prettifier$.MODULE$.default(), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1610));
    }

    private void assertCardinalityError(String query) {
        SparkException e = (SparkException)((Object)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)query), ClassTag$.MODULE$.apply(SparkException.class), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1614)));
        String $org_scalatest_assert_macro_left = e.getCause().getMessage();
        String $org_scalatest_assert_macro_right = "ON search condition of the MERGE statement";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1617));
    }

    public static final /* synthetic */ Tuple3 $anonfun$new$66(int pk) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)pk), (Object)BoxesRunTime.boxToInteger((int)(pk * 100)), (Object)"support");
    }

    public static final /* synthetic */ Tuple3 $anonfun$new$70(int pk) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)pk), (Object)BoxesRunTime.boxToInteger((int)(pk * 100)), (Object)"support");
    }

    public static final /* synthetic */ Tuple3 $anonfun$new$74(int pk) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)pk), (Object)BoxesRunTime.boxToInteger((int)(pk * 100)), (Object)"support");
    }

    public static final /* synthetic */ Tuple3 $anonfun$new$78(int pk) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)pk), (Object)BoxesRunTime.boxToInteger((int)(pk * 100)), (Object)"support");
    }

    public static final /* synthetic */ Tuple3 $anonfun$new$82(int pk) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)pk), (Object)BoxesRunTime.boxToInteger((int)(pk * 100)), (Object)"support");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$new$160(Expression x0$3) {
        Expression expression = x0$3;
        if (!(expression instanceof In)) return true;
        In in = (In)expression;
        Expression attr = in.value();
        if (!(attr instanceof AttributeReference)) return true;
        AttributeReference attributeReference = (AttributeReference)attr;
        String string = attributeReference.name();
        String string2 = "DeP";
        if (string != null) {
            if (!string.equals(string2)) return true;
            return false;
        }
        if (string2 == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$new$167(Expression x0$4) {
        Expression expression = x0$4;
        if (!(expression instanceof In)) return true;
        In in = (In)expression;
        Expression attr = in.value();
        if (!(attr instanceof AttributeReference)) return true;
        AttributeReference attributeReference = (AttributeReference)attr;
        String string = attributeReference.name();
        String string2 = "dep";
        if (string != null) {
            if (!string.equals(string2)) return true;
            return false;
        }
        if (string2 == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$new$168(Expression x0$5) {
        Expression expression = x0$5;
        if (!(expression instanceof Not)) return false;
        Not not = (Not)expression;
        Expression expression2 = not.child();
        if (!(expression2 instanceof EqualTo)) return false;
        EqualTo equalTo = (EqualTo)expression2;
        Expression attr = equalTo.left();
        if (!(attr instanceof AttributeReference)) return false;
        AttributeReference attributeReference = (AttributeReference)attr;
        String string = attributeReference.name();
        String string2 = "salary";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$new$175(Expression x0$6) {
        Expression expression = x0$6;
        if (!(expression instanceof In)) return false;
        In in = (In)expression;
        Expression attr = in.value();
        if (!(attr instanceof AttributeReference)) return false;
        AttributeReference attributeReference = (AttributeReference)attr;
        String string = attributeReference.name();
        String string2 = "DeP";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public MergeIntoTableSuiteBase() {
        this.test("SPARK-45974: merge into non filter attributes table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String tableName = "cat.ns1.non_partitioned_table";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Seq sourceRows = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)100), (Object)"hr"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)200), (Object)"finance"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)300), (Object)"hr")}));
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator10$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                    }

                    public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator10$1(MergeIntoTableSuiteBase $outer) {
                    }
                }
                this.testImplicits().localSeqToDatasetHolder(sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator10$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk", "salary", "dep"})).createOrReplaceTempView("source");
                this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(55).append("CREATE TABLE ").append(tableName).append(" (pk INT NOT NULL, salary INT, dep STRING)").toString())));
                Dataset df = (Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(240).append("MERGE INTO ").append(tableName).append(" t\n             |USING (select * from source) s\n             |ON t.pk = s.pk\n             |WHEN MATCHED THEN\n             | UPDATE SET t.salary = s.salary\n             |WHEN NOT MATCHED THEN\n             | INSERT *\n             |").toString())));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(tableName).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)100), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "finance"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)300), "hr"}))}))));
            }));
        }, new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        this.test("merge into empty table with NOT MATCHED clause", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createTable("pk INT NOT NULL, salary INT, dep STRING");
            Seq sourceRows = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)100), (Object)"hr"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)200), (Object)"finance"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)300), (Object)"hr")}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator20$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator20$1(MergeIntoTableSuiteBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder(sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator20$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk", "salary", "dep"})).createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(136).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source s\n           |ON t.pk = s.pk\n           |WHEN NOT MATCHED THEN\n           | INSERT *\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)100), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "finance"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)300), "hr"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        this.test("merge into empty table with conditional NOT MATCHED clause", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createTable("pk INT NOT NULL, salary INT, dep STRING");
            Seq sourceRows = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)100), (Object)"hr"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)200), (Object)"finance"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)300), (Object)"hr")}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator30$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator30$1(MergeIntoTableSuiteBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder(sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator30$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk", "salary", "dep"})).createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(150).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source s\n           |ON t.pk = s.pk\n           |WHEN NOT MATCHED AND s.pk >= 2 THEN\n           | INSERT *\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "finance"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)300), "hr"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        this.test("merge into with conditional WHEN MATCHED clause (update)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"corrupted\" }\n          |")));
            Seq sourceRows = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)100), (Object)"software"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)200), (Object)"finance"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)300), (Object)"software")}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator40$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator40$1(MergeIntoTableSuiteBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder(sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator40$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk", "salary", "dep"})).createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(149).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source s\n           |ON t.pk = s.pk\n           |WHEN MATCHED AND s.pk = 2 THEN\n           | UPDATE SET *\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)100), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "finance"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("merge into with conditional WHEN MATCHED clause (delete)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"corrupted\" }\n          |")));
            this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), this.testImplicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk"})).createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(149).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source s\n           |ON t.pk = s.pk\n           |WHEN MATCHED AND t.salary = 200 THEN\n           | DELETE\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)100), "hr"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        this.test("merge into with assignments to primary key in NOT MATCHED BY SOURCE", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"finance\" }\n          |")));
            Seq sourceRows = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)100), (Object)"software"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)500), (Object)"finance")}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator50$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator50$1(MergeIntoTableSuiteBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder(sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator50$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk", "salary", "dep"})).createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(226).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source s\n           |ON t.pk = s.pk\n           |WHEN MATCHED THEN\n           | UPDATE SET t.salary = -1\n           |WHEN NOT MATCHED BY SOURCE THEN\n           | UPDATE SET t.pk = -1\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)-1), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)-1), BoxesRunTime.boxToInteger((int)200), "finance"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        this.test("merge into with assignments to primary key in MATCHED", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"finance\" }\n          |")));
            Seq sourceRows = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)100), (Object)"software"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)500), (Object)"finance")}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator60$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator60$1(MergeIntoTableSuiteBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder(sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator60$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk", "salary", "dep"})).createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(226).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source s\n           |ON t.pk = s.pk\n           |WHEN MATCHED THEN\n           | UPDATE SET t.pk = -1\n           |WHEN NOT MATCHED BY SOURCE THEN\n           | UPDATE SET t.salary = -1\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)-1), BoxesRunTime.boxToInteger((int)100), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)-1), "finance"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        this.test("merge with all types of clauses", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"software\" }\n          |{ \"pk\": 3, \"salary\": 300, \"dep\": \"hr\" }\n          |{ \"pk\": 4, \"salary\": 400, \"dep\": \"hr\" }\n          |{ \"pk\": 5, \"salary\": 500, \"dep\": \"hr\" }\n          |")));
            Dataset sourceDF = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6})), this.testImplicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk"}));
            sourceDF.createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(318).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source s\n           |ON t.pk = s.pk\n           |WHEN MATCHED THEN\n           | UPDATE SET t.salary = t.salary + 1\n           |WHEN NOT MATCHED THEN\n           | INSERT (pk, salary, dep) VALUES (s.pk, 0, 'new')\n           |WHEN NOT MATCHED BY SOURCE THEN\n           | DELETE\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)301), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)401), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)501), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)0), "new"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
        this.test("merge with all types of clauses (update and insert star)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"software\" }\n          |{ \"pk\": 3, \"salary\": 300, \"dep\": \"software\" }\n          |")));
            Seq sourceRows = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)101), (Object)"support"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)201), (Object)"support"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)401), (Object)"support"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)501), (Object)"support")}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator70$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator70$1(MergeIntoTableSuiteBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder(sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator70$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk", "salary", "dep"})).createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(308).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source s\n           |ON t.pk = s.pk\n           |WHEN MATCHED AND t.pk = 1 THEN\n           | UPDATE SET *\n           |WHEN NOT MATCHED AND s.pk = 4 THEN\n           | INSERT *\n           |WHEN NOT MATCHED BY SOURCE AND t.pk = t.salary / 100 THEN\n           | DELETE\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)101), "support"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "software"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)401), "support"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
        this.test("merge with all types of conditional clauses", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"software\" }\n          |{ \"pk\": 3, \"salary\": 300, \"dep\": \"hr\" }\n          |{ \"pk\": 4, \"salary\": 400, \"dep\": \"hr\" }\n          |{ \"pk\": 5, \"salary\": 500, \"dep\": \"hr\" }\n          |")));
            Dataset sourceDF = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 7})), this.testImplicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk"}));
            sourceDF.createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(359).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source s\n           |ON t.pk = s.pk\n           |WHEN MATCHED AND t.pk = 4 THEN\n           | UPDATE SET t.salary = t.salary + 1\n           |WHEN NOT MATCHED AND pk = 6 THEN\n           | INSERT (pk, salary, dep) VALUES (s.pk, 0, 'new')\n           |WHEN NOT MATCHED BY SOURCE AND salary = 100 THEN\n           | DELETE\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "software"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)300), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)401), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)500), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)0), "new"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
        this.test("merge with one NOT MATCHED BY SOURCE clause", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"software\" }\n          |{ \"pk\": 3, \"salary\": 300, \"dep\": \"hr\" }\n          |")));
            Dataset sourceDF = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), this.testImplicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk"}));
            sourceDF.createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(144).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source s\n           |ON t.pk = s.pk\n           |WHEN NOT MATCHED BY SOURCE THEN\n           | DELETE\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)100), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "software"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
        this.test("merge with one conditional NOT MATCHED BY SOURCE clause", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"software\" }\n          |{ \"pk\": 3, \"salary\": 300, \"dep\": \"hr\" }\n          |")));
            Dataset sourceDF = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), this.testImplicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk"}));
            sourceDF.createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(177).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source s\n           |ON t.pk = s.pk\n           |WHEN NOT MATCHED BY SOURCE AND salary = 100 THEN\n           | UPDATE SET salary = -1\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)-1), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "software"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)300), "hr"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
        this.test("merge with MATCHED and NOT MATCHED BY SOURCE clauses", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"software\" }\n          |{ \"pk\": 3, \"salary\": 300, \"dep\": \"hr\" }\n          |")));
            Dataset sourceDF = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), this.testImplicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk"}));
            sourceDF.createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(227).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source s\n           |ON t.pk = s.pk\n           |WHEN MATCHED THEN\n           | DELETE\n           |WHEN NOT MATCHED BY SOURCE AND salary = 100 THEN\n           | UPDATE SET salary = -1\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)-1), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)300), "hr"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394));
        this.test("merge with NOT MATCHED and NOT MATCHED BY SOURCE clauses", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"software\" }\n          |{ \"pk\": 3, \"salary\": 300, \"dep\": \"hr\" }\n          |")));
            Dataset sourceDF = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), this.testImplicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk"}));
            sourceDF.createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(239).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source s\n           |ON t.pk = s.pk\n           |WHEN NOT MATCHED THEN\n           | INSERT (pk, salary, dep) VALUES (pk, -1, 'new')\n           |WHEN NOT MATCHED BY SOURCE THEN\n           | DELETE\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "software"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)300), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)-1), "new"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 423));
        this.test("merge with multiple NOT MATCHED BY SOURCE clauses", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"software\" }\n          |{ \"pk\": 3, \"salary\": 300, \"dep\": \"hr\" }\n          |")));
            Dataset sourceDF = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 6, 7})), this.testImplicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk"}));
            sourceDF.createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(266).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source s\n           |ON t.pk = s.pk\n           |WHEN NOT MATCHED BY SOURCE AND salary = 100 THEN\n           | UPDATE SET salary = salary + 1\n           |WHEN NOT MATCHED BY SOURCE AND salary = 300 THEN\n           | DELETE\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)101), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "software"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 453));
        this.test("merge with MATCHED BY SOURCE clause and NULL values", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": null, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"id\": 2, \"salary\": 200, \"dep\": \"software\" }\n          |{ \"pk\": 3, \"id\": 3, \"salary\": 300, \"dep\": \"hr\" }\n          |")));
            Seq sourceRows = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)201), (Object)"support"), new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)101), (Object)"support"), new Tuple4((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)301), (Object)"support")}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator80$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
                }

                public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator80$1(MergeIntoTableSuiteBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder(sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator80$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk", "id", "salary", "dep"})).createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(149).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source s\n           |ON t.id = s.id AND t.id < 3\n           |WHEN MATCHED THEN\n           | UPDATE SET *\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null, BoxesRunTime.boxToInteger((int)100), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)201), "support"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)300), "hr"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
        this.test("merge with CTE", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"software\" }\n          |")));
            Seq sourceRows = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)101), (Object)"support"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)301), (Object)"support")}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator90$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator90$1(MergeIntoTableSuiteBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder(sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator90$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk", "salary", "dep"})).createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(212).append("WITH cte1 AS (SELECT pk + 1 as pk, salary, dep FROM source)\n           |MERGE INTO ").append(this.tableNameAsString()).append(" AS t\n           |USING cte1 AS s\n           |ON t.pk = s.pk\n           |WHEN MATCHED THEN\n           | UPDATE SET *\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)101), "support"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "software"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 513));
        this.test("merge with subquery as source", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 6, \"salary\": 600, \"dep\": \"software\" }\n          |")));
            Seq sourceRows = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)201), (Object)"support"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)101), (Object)"support"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)301), (Object)"support"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToInteger((int)601), (Object)"support")}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator100$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator100$1(MergeIntoTableSuiteBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder(sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator100$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk", "salary", "dep"})).createOrReplaceTempView("source");
            String subquery = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |SELECT * FROM source WHERE pk = 2\n           |UNION ALL\n           |SELECT * FROM source WHERE pk = 1 OR pk = 6\n           |"));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(194).append("MERGE INTO ").append(this.tableNameAsString()).append(" AS t\n           |USING (").append(subquery).append(") AS s\n           |ON t.pk = s.pk\n           |WHEN MATCHED THEN\n           | UPDATE SET *\n           |WHEN NOT MATCHED THEN\n           | INSERT *\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)101), "support"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)201), "support"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)601), "support"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 542));
        this.test("merge cardinality check with conditional MATCHED clause (delete)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 6, \"salary\": 600, \"dep\": \"software\" }\n          |")));
            Seq sourceRows = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)101), (Object)"support"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)102), (Object)"support"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)201), (Object)"support")}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator110$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator110$1(MergeIntoTableSuiteBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder(sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator110$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk", "salary", "dep"})).createOrReplaceTempView("source");
            this.assertCardinalityError(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(155).append("MERGE INTO ").append(this.tableNameAsString()).append(" AS t\n           |USING source AS s\n           |ON t.pk = s.pk\n           |WHEN MATCHED AND s.salary = 101 THEN\n           | DELETE\n           |").toString())));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 582));
        this.test("merge cardinality check with unconditional MATCHED clause (delete)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 6, \"salary\": 600, \"dep\": \"software\" }\n          |")));
            Seq sourceRows = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)101), (Object)"support"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)102), (Object)"support"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)201), (Object)"support")}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator120$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator120$1(MergeIntoTableSuiteBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder(sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator120$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk", "salary", "dep"})).createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(136).append("MERGE INTO ").append(this.tableNameAsString()).append(" AS t\n           |USING source AS s\n           |ON t.pk = s.pk\n           |WHEN MATCHED THEN\n           | DELETE\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)600), "software"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 605));
        this.test("merge cardinality check with only NOT MATCHED clauses", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 6, \"salary\": 600, \"dep\": \"software\" }\n          |")));
            Seq sourceRows = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)101), (Object)"support"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)102), (Object)"support"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)201), (Object)"support")}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator130$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator130$1(MergeIntoTableSuiteBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder(sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator130$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk", "salary", "dep"})).createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(142).append("MERGE INTO ").append(this.tableNameAsString()).append(" AS t\n           |USING source AS s\n           |ON t.pk = s.pk\n           |WHEN NOT MATCHED THEN\n           | INSERT *\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)100), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)201), "support"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)600), "software"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 632));
        this.test("merge cardinality check with small target and large source (broadcast enabled)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"software\" }\n          |")));
            IndexedSeq sourceRows = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 1000).map((Function1 & Serializable)pk -> MergeIntoTableSuiteBase.$anonfun$new$66(BoxesRunTime.unboxToInt((Object)pk)));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator140$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator140$1(MergeIntoTableSuiteBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder((Seq)sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator140$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk", "salary", "dep"})).createOrReplaceTempView("source");
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()), (Object)Long.toString(Long.MAX_VALUE))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.assertCardinalityError(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(199).append("MERGE INTO ").append(this.tableNameAsString()).append(" AS t\n             |USING (SELECT * FROM source UNION ALL SELECT * FROM source) AS s\n             |ON t.pk = s.pk\n             |WHEN MATCHED THEN\n             | UPDATE SET *\n             |").toString())));
                this.assertNoLeftBroadcastOrReplication(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(152).append("MERGE INTO ").append(this.tableNameAsString()).append(" AS t\n             |USING source AS s\n             |ON t.pk = s.pk\n             |WHEN MATCHED THEN\n             | UPDATE SET *\n             |").toString())));
                long $org_scalatest_assert_macro_left = ((Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString())).count();
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 689));
            });
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 662));
        this.test("merge cardinality check with small target and large source (broadcast disabled)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"software\" }\n          |")));
            IndexedSeq sourceRows = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 1000).map((Function1 & Serializable)pk -> MergeIntoTableSuiteBase.$anonfun$new$70(BoxesRunTime.unboxToInt((Object)pk)));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator150$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator150$1(MergeIntoTableSuiteBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder((Seq)sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator150$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk", "salary", "dep"})).createOrReplaceTempView("source");
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()), (Object)"-1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.assertCardinalityError(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(199).append("MERGE INTO ").append(this.tableNameAsString()).append(" AS t\n             |USING (SELECT * FROM source UNION ALL SELECT * FROM source) AS s\n             |ON t.pk = s.pk\n             |WHEN MATCHED THEN\n             | UPDATE SET *\n             |").toString())));
                this.assertNoLeftBroadcastOrReplication(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(152).append("MERGE INTO ").append(this.tableNameAsString()).append(" AS t\n             |USING source AS s\n             |ON t.pk = s.pk\n             |WHEN MATCHED THEN\n             | UPDATE SET *\n             |").toString())));
                long $org_scalatest_assert_macro_left = ((Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString())).count();
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 721));
            });
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 694));
        this.test("merge cardinality check with small target and large source (shuffle hash enabled)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"software\" }\n          |")));
            IndexedSeq sourceRows = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 1000).map((Function1 & Serializable)pk -> MergeIntoTableSuiteBase.$anonfun$new$74(BoxesRunTime.unboxToInt((Object)pk)));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator160$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator160$1(MergeIntoTableSuiteBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder((Seq)sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator160$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk", "salary", "dep"})).createOrReplaceTempView("source");
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()), (Object)"-1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PREFER_SORTMERGEJOIN().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.assertCardinalityError(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(199).append("MERGE INTO ").append(this.tableNameAsString()).append(" AS t\n             |USING (SELECT * FROM source UNION ALL SELECT * FROM source) AS s\n             |ON t.pk = s.pk\n             |WHEN MATCHED THEN\n             | UPDATE SET *\n             |").toString())));
                this.assertNoLeftBroadcastOrReplication(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(152).append("MERGE INTO ").append(this.tableNameAsString()).append(" AS t\n             |USING source AS s\n             |ON t.pk = s.pk\n             |WHEN MATCHED THEN\n             | UPDATE SET *\n             |").toString())));
                long $org_scalatest_assert_macro_left = ((Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString())).count();
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 756));
            });
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 726));
        this.test("merge cardinality check without equality condition and only MATCHED clauses", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"software\" }\n          |")));
            IndexedSeq sourceRows = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 1000).map((Function1 & Serializable)pk -> MergeIntoTableSuiteBase.$anonfun$new$78(BoxesRunTime.unboxToInt((Object)pk)));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator170$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator170$1(MergeIntoTableSuiteBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder((Seq)sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator170$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk", "salary", "dep"})).createOrReplaceTempView("source");
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()), (Object)"-1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.assertCardinalityError(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(199).append("MERGE INTO ").append(this.tableNameAsString()).append(" AS t\n             |USING (SELECT * FROM source UNION ALL SELECT * FROM source) AS s\n             |ON t.pk > s.pk\n             |WHEN MATCHED THEN\n             | UPDATE SET *\n             |").toString())));
                long $org_scalatest_assert_macro_left = ((Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString())).count();
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 780));
            });
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 761));
        this.test("merge cardinality check without equality condition", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"software\" }\n          |")));
            IndexedSeq sourceRows = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 1000).map((Function1 & Serializable)pk -> MergeIntoTableSuiteBase.$anonfun$new$82(BoxesRunTime.unboxToInt((Object)pk)));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator180$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator180$1(MergeIntoTableSuiteBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder((Seq)sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator180$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk", "salary", "dep"})).createOrReplaceTempView("source");
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()), (Object)"-1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.assertCardinalityError(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(259).append("MERGE INTO ").append(this.tableNameAsString()).append(" AS t\n             |USING (SELECT * FROM source UNION ALL SELECT * FROM source) AS s\n             |ON t.pk > s.pk\n             |WHEN MATCHED THEN\n             | UPDATE SET *\n             |WHEN NOT MATCHED THEN\n             | INSERT *\n             |").toString())));
                long $org_scalatest_assert_macro_left = ((Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString())).count();
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 806));
            });
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 785));
        this.test("self merge", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n        |{ \"pk\": 2, \"salary\": 200, \"dep\": \"software\" }\n        |{ \"pk\": 3, \"salary\": 300, \"dep\": \"hr\" }\n        |")));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(211).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n         |USING ").append(this.tableNameAsString()).append(" s\n         |ON t.pk = s.pk\n         |WHEN MATCHED AND t.salary = 100 THEN\n         | UPDATE SET salary = t.salary + 1\n         |WHEN NOT MATCHED THEN\n         | INSERT *\n         |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)101), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "software"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)300), "hr"}))}))));
        }, new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 811));
        this.test("merge with self subquery", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ids"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"software\" }\n          |{ \"pk\": 3, \"salary\": 300, \"dep\": \"hr\" }\n          |")));
            this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), this.testImplicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"})).createOrReplaceTempView("ids");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(312).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING (SELECT pk FROM ").append(this.tableNameAsString()).append(" r JOIN ids ON r.pk = ids.value) s\n           |ON t.pk = s.pk\n           |WHEN MATCHED AND t.salary = 100 THEN\n           | UPDATE SET salary = t.salary + 1\n           |WHEN NOT MATCHED THEN\n           | INSERT (dep, salary, pk) VALUES ('new', 300, 1)\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)101), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "software"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)300), "hr"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 836));
        this.test("merge with extra columns in source", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"software\" }\n          |{ \"pk\": 3, \"salary\": 300, \"dep\": \"hr\" }\n          |")));
            Seq sourceRows = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"smth", (Object)BoxesRunTime.boxToInteger((int)101), (Object)"support"), new Tuple4((Object)BoxesRunTime.boxToInteger((int)2), (Object)"smth", (Object)BoxesRunTime.boxToInteger((int)201), (Object)"support"), new Tuple4((Object)BoxesRunTime.boxToInteger((int)4), (Object)"smth", (Object)BoxesRunTime.boxToInteger((int)401), (Object)"support")}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator190$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
                }

                public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator190$1(MergeIntoTableSuiteBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder(sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator190$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk", "extra", "salary", "dep"})).createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(323).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source s\n           |ON t.pk = s.pk\n           |WHEN MATCHED THEN\n           | UPDATE SET salary = s.salary + 1\n           |WHEN NOT MATCHED THEN\n           | INSERT (pk, salary, dep) VALUES (s.pk, s.salary, s.dep)\n           |WHEN NOT MATCHED BY SOURCE THEN\n           | DELETE\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)102), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)202), "software"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)401), "support"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 865));
        this.test("merge with NULL values in target and source", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": null, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"id\": 2, \"salary\": 200, \"dep\": \"software\" }\n          |")));
            Seq sourceRows = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)5), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)501), (Object)"support"), new Tuple4((Object)BoxesRunTime.boxToInteger((int)6), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)6)), (Object)BoxesRunTime.boxToInteger((int)601), (Object)"support")}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator200$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
                }

                public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator200$1(MergeIntoTableSuiteBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder(sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator200$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk", "id", "salary", "dep"})).createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(192).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source s\n           |ON t.id = s.id\n           |WHEN MATCHED THEN\n           | UPDATE SET *\n           |WHEN NOT MATCHED THEN\n           | INSERT *\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null, BoxesRunTime.boxToInteger((int)100), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "software"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), null, BoxesRunTime.boxToInteger((int)501), "support"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)601), "support"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 900));
        this.test("merge with <=>", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": null, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"id\": 2, \"salary\": 200, \"dep\": \"software\" }\n          |")));
            Seq sourceRows = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)5), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)501), (Object)"support"), new Tuple4((Object)BoxesRunTime.boxToInteger((int)6), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)6)), (Object)BoxesRunTime.boxToInteger((int)601), (Object)"support")}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator210$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
                }

                public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator210$1(MergeIntoTableSuiteBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder(sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator210$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk", "id", "salary", "dep"})).createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(194).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source s\n           |ON t.id <=> s.id\n           |WHEN MATCHED THEN\n           | UPDATE SET *\n           |WHEN NOT MATCHED THEN\n           | INSERT *\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "software"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), null, BoxesRunTime.boxToInteger((int)501), "support"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)601), "support"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 932));
        this.test("merge with NULL ON condition", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, id INT, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": null, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"id\": 2, \"salary\": 200, \"dep\": \"software\" }\n          |")));
            Seq sourceRows = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)5), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)501), (Object)"support"), new Tuple4((Object)BoxesRunTime.boxToInteger((int)6), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)201), (Object)"support")}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator220$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
                }

                public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator220$1(MergeIntoTableSuiteBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder(sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator220$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk", "id", "salary", "dep"})).createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(217).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source s\n           |ON t.id = s.id AND NULL\n           |WHEN MATCHED THEN\n           | UPDATE SET salary = s.salary\n           |WHEN NOT MATCHED THEN\n           | INSERT *\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null, BoxesRunTime.boxToInteger((int)100), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "software"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), null, BoxesRunTime.boxToInteger((int)501), "support"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)201), "support"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 963));
        this.test("merge with NULL clause conditions", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"software\" }\n          |")));
            Seq sourceRows = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)101), (Object)"support"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)301), (Object)"support")}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator230$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator230$1(MergeIntoTableSuiteBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder(sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator230$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk", "salary", "dep"})).createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(299).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source s\n           |ON t.pk = s.pk\n           |WHEN MATCHED AND NULL THEN\n           | UPDATE SET salary = s.salary\n           |WHEN NOT MATCHED AND NULL THEN\n           | INSERT *\n           |WHEN NOT MATCHED BY SOURCE AND NULL THEN\n           | DELETE\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)100), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "software"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 995));
        this.test("merge with multiple matching clauses", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"software\" }\n          |")));
            Seq sourceRows = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)101), (Object)"support"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)301), (Object)"support")}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator240$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator240$1(MergeIntoTableSuiteBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder(sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator240$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk", "salary", "dep"})).createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(448).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source s\n           |ON t.pk = s.pk\n           |WHEN MATCHED AND t.pk = 1 THEN\n           | UPDATE SET salary = t.salary + 5\n           |WHEN MATCHED AND t.salary = 100 THEN\n           | UPDATE SET salary = t.salary + 2\n           |WHEN NOT MATCHED BY SOURCE AND t.pk = 2 THEN\n           | UPDATE SET salary = salary - 1\n           |WHEN NOT MATCHED BY SOURCE AND t.salary = 200 THEN\n           | DELETE\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)105), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)199), "software"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1027));
        this.test("merge resolves and aligns columns by name", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"software\" }\n          |")));
            Seq sourceRows = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"support", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)101)), new Tuple3((Object)"support", (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)301))}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator250$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator250$1(MergeIntoTableSuiteBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder(sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator250$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"dep", "pk", "salary"})).createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(192).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source s\n           |ON t.pk = s.pk\n           |WHEN MATCHED THEN\n           | UPDATE SET *\n           |WHEN NOT MATCHED THEN\n           | INSERT *\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)101), "support"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)200), "software"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)301), "support"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1061));
        this.test("merge refreshed relation cache", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"temp", "source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withCache((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"temp"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n            |{ \"pk\": 2, \"salary\": 100, \"dep\": \"software\" }\n            |{ \"pk\": 3, \"salary\": 300, \"dep\": \"hr\" }\n            |")));
            Dataset query = (Dataset)this.sql().apply((Object)new StringBuilder(33).append("SELECT * FROM ").append(this.tableNameAsString()).append(" WHERE salary = 100").toString());
            query.createOrReplaceTempView("temp");
            this.sql().apply((Object)"CACHE TABLE temp");
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)100), "hr"}));
            Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)100), "software"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM temp"), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row2).$colon$colon((Object)row));
            Seq sourceRows = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"support", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)101)), new Tuple3((Object)"support", (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)301))}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator260$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator260$1(MergeIntoTableSuiteBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder(sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator260$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"dep", "pk", "salary"})).createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(206).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n             |USING source s\n             |ON t.pk = s.pk\n             |WHEN MATCHED THEN\n             | UPDATE SET *\n             |WHEN NOT MATCHED THEN\n             | INSERT *\n             |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)101), "support"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)100), "software"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)301), "support"}))}))));
            Row row3 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)100), "software"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM temp"), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row3));
        })), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1092));
        this.test("merge with updates to nested struct fields in MATCHED clauses", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("pk INT NOT NULL,\n           |s STRUCT<c1: INT, c2: STRUCT<a: ARRAY<INT>, m: MAP<STRING, STRING>>>,\n           |dep STRING")), "{ \"pk\": 1, \"s\": { \"c1\": 2, \"c2\": { \"a\": [1,2], \"m\": { \"a\": \"b\" } } }, \"dep\": \"hr\" }");
            this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3})), this.testImplicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk"})).createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(192).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source src\n           |ON t.pk = src.pk\n           |WHEN MATCHED THEN\n           | UPDATE SET s.c1 = -1, s.c2.m = map('k', 'v'), s.c2.a = array(-1)\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)-1), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-1})), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)"v")}))}))})), "hr"}))}))));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(163).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source src\n           |ON t.pk = src.pk\n           |WHEN MATCHED THEN\n           | UPDATE SET s.c1 = NULL, s.c2 = NULL\n           |").toString())));
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null, null})), "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(210).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source src\n           |ON t.pk = src.pk\n           |WHEN MATCHED THEN\n           | UPDATE SET s = named_struct('c1', 1, 'c2', named_struct('a', array(1), 'm', null))\n           |").toString())));
            Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), null}))})), "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row2));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1143));
        this.test("merge with updates to nested struct fields in NOT MATCHED BY SOURCE clauses", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("pk INT NOT NULL,\n           |s STRUCT<c1: INT, c2: STRUCT<a: ARRAY<INT>, m: MAP<STRING, STRING>>>,\n           |dep STRING")), "{ \"pk\": 1, \"s\": { \"c1\": 2, \"c2\": { \"a\": [1,2], \"m\": { \"a\": \"b\" } } }, \"dep\": \"hr\" }");
            this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4})), this.testImplicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk"})).createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(206).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source src\n           |ON t.pk = src.pk\n           |WHEN NOT MATCHED BY SOURCE THEN\n           | UPDATE SET s.c1 = -1, s.c2.m = map('k', 'v'), s.c2.a = array(-1)\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)-1), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-1})), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)"v")}))}))})), "hr"}))}))));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(177).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source src\n           |ON t.pk = src.pk\n           |WHEN NOT MATCHED BY SOURCE THEN\n           | UPDATE SET s.c1 = NULL, s.c2 = NULL\n           |").toString())));
            Row row = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null, null})), "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row));
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(224).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source src\n           |ON t.pk = src.pk\n           |WHEN NOT MATCHED BY SOURCE THEN\n           | UPDATE SET s = named_struct('c1', 1, 'c2', named_struct('a', array(1), 'm', null))\n           |").toString())));
            Row row2 = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), null}))})), "hr"}));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)scala.package$.MODULE$.Nil().$colon$colon((Object)row2));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1191));
        this.test("merge with default values", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            ColumnDefaultValue idDefault = new ColumnDefaultValue("42", (Literal)new LiteralValue((Object)BoxesRunTime.boxToInteger((int)42), (DataType)IntegerType$.MODULE$));
            Column[] columns = (Column[])((Object[])new Column[]{Column.create((String)"pk", (DataType)IntegerType$.MODULE$, (boolean)false, null, null), Column.create((String)"id", (DataType)IntegerType$.MODULE$, (boolean)true, null, (ColumnDefaultValue)idDefault, null), Column.create((String)"dep", (DataType)StringType$.MODULE$, (boolean)true, null, null)});
            this.createTable(columns);
            this.append("pk INT NOT NULL, id INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"id\": 1, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"id\": 2, \"dep\": \"software\" }\n          |{ \"pk\": 3, \"id\": 3, \"dep\": \"hr\" }\n          |")));
            this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 4})), this.testImplicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk"})).createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(326).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source s\n           |ON t.pk = s.pk\n           |WHEN MATCHED THEN\n           | UPDATE SET id = DEFAULT\n           |WHEN NOT MATCHED THEN\n           | INSERT (pk, id, dep) VALUES (s.pk, DEFAULT, 'new')\n           |WHEN NOT MATCHED BY SOURCE THEN\n           | UPDATE SET id = DEFAULT\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)42), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)42), "software"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)42), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)42), "new"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1239));
        this.test("merge with char/varchar columns", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createTable("pk INT NOT NULL, s STRUCT<n_c: CHAR(3), n_vc: VARCHAR(5)>, dep STRING");
            this.append("pk INT NOT NULL, s STRUCT<n_c: STRING, n_vc: STRING>, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"s\": { \"n_c\": \"aaa\", \"n_vc\": \"aaa\" }, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"s\": { \"n_c\": \"bbb\", \"n_vc\": \"bbb\" }, \"dep\": \"software\" }\n          |{ \"pk\": 3, \"s\": { \"n_c\": \"ccc\", \"n_vc\": \"ccc\" }, \"dep\": \"hr\" }\n          |")));
            this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 4})), this.testImplicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk"})).createOrReplaceTempView("source");
            this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(258).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n           |USING source s\n           |ON t.pk = s.pk\n           |WHEN MATCHED THEN\n           | UPDATE SET s.n_c = 'x1', s.n_vc = 'x2'\n           |WHEN NOT MATCHED BY SOURCE THEN\n           | UPDATE SET s.n_c = 'y1', s.n_vc = 'y2'\n           |").toString())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"x1 ", "x2"})), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"x1 ", "x2"})), "software"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"y1 ", "y2"})), "hr"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1279));
        this.test("merge with NOT NULL checks", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, s STRUCT<n_i: INT NOT NULL, n_l: LONG>, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"s\": { \"n_i\": 1, \"n_l\": 11 }, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"s\": { \"n_i\": 2, \"n_l\": 22 }, \"dep\": \"software\" }\n          |{ \"pk\": 3, \"s\": { \"n_i\": 3, \"n_l\": 33 }, \"dep\": \"hr\" }\n          |")));
            this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 4})), this.testImplicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk"})).createOrReplaceTempView("source");
            SparkException e1 = (SparkException)((Object)((Object)((Object)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(186).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n             |USING source s\n             |ON t.pk = s.pk\n             |WHEN MATCHED THEN\n             | UPDATE SET s = named_struct('n_i', null, 'n_l', -1L)\n             |").toString()))), ClassTag$.MODULE$.apply(SparkException.class), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1320)))));
            String $org_scalatest_assert_macro_left = e1.getCause().getMessage();
            String $org_scalatest_assert_macro_right = "Null value appeared in non-nullable field";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1329));
            SparkException e2 = (SparkException)((Object)((Object)((Object)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(200).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n             |USING source s\n             |ON t.pk = s.pk\n             |WHEN NOT MATCHED BY SOURCE THEN\n             | UPDATE SET s = named_struct('n_i', null, 'n_l', -1L)\n             |").toString()))), ClassTag$.MODULE$.apply(SparkException.class), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1331)))));
            String $org_scalatest_assert_macro_left2 = e2.getCause().getMessage();
            String $org_scalatest_assert_macro_right2 = "Null value appeared in non-nullable field";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1340));
            SparkException e3 = (SparkException)((Object)((Object)((Object)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(221).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n             |USING source s\n             |ON t.pk = s.pk\n             |WHEN NOT MATCHED THEN\n             | INSERT (pk, s, dep) VALUES (s.pk, named_struct('n_i', null, 'n_l', -1L), 'invalid')\n             |").toString()))), ClassTag$.MODULE$.apply(SparkException.class), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1342)))));
            String $org_scalatest_assert_macro_left3 = e3.getCause().getMessage();
            String $org_scalatest_assert_macro_right3 = "Null value appeared in non-nullable field";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1351));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1310));
        this.test("unsupported merge into conditions", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createTable("pk INT NOT NULL, salary INT, dep STRING");
            Seq sourceRows = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)100), (Object)"hr"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)200), (Object)"finance"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)300), (Object)"hr")}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MergeIntoTableSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator270$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator270$1(MergeIntoTableSuiteBase $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder(sourceRows, this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_MergeIntoTableSuiteBase$$typecreator270$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk", "salary", "dep"})).createOrReplaceTempView("source");
            Map unsupportedSourceExprs = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"s.pk < rand()"), (Object)"Non-deterministic expressions are not allowed"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max(s.pk) < 10"), (Object)"Aggregates are not allowed"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(25).append("s.pk IN (SELECT pk FROM ").append(this.tableNameAsString()).append(")").toString()), (Object)"Subqueries are not allowed")}));
            unsupportedSourceExprs.map((Function1 & Serializable)x0$1 -> {
                Bool bool;
                Bool $org_scalatest_assert_macro_left;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Bool bool2;
                    Bool bool3;
                    Bool bool4;
                    String $org_scalatest_assert_macro_right;
                    String expr = (String)tuple2._1();
                    String errMsg = (String)tuple2._2();
                    AnalysisException e1 = (AnalysisException)((Object)((Object)((Object)((Object)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(161).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n               |USING source s\n               |ON t.pk = s.pk AND ").append(expr).append("\n               |WHEN MATCHED THEN\n               | UPDATE SET *\n               |").toString()))), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1371))))));
                    String $org_scalatest_assert_macro_left2 = e1.message();
                    Bool $org_scalatest_assert_macro_left3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)($org_scalatest_assert_macro_right = "unsupported SEARCH condition"), $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    if ($org_scalatest_assert_macro_left3.value()) {
                        String $org_scalatest_assert_macro_left4 = e1.message();
                        String $org_scalatest_assert_macro_right2 = errMsg;
                        bool4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    } else {
                        bool4 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                    }
                    Bool $org_scalatest_assert_macro_right3 = bool4;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1380));
                    AnalysisException e2 = (AnalysisException)((Object)((Object)((Object)((Object)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(161).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n               |USING source s\n               |ON t.pk = s.pk\n               |WHEN MATCHED AND ").append(expr).append(" THEN\n               | UPDATE SET *\n               |").toString()))), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1382))))));
                    String $org_scalatest_assert_macro_left5 = e2.message();
                    String $org_scalatest_assert_macro_right4 = "unsupported UPDATE condition";
                    Bool $org_scalatest_assert_macro_left6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                    if ($org_scalatest_assert_macro_left6.value()) {
                        String $org_scalatest_assert_macro_left7 = e2.message();
                        String $org_scalatest_assert_macro_right5 = errMsg;
                        bool3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left7.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
                    } else {
                        bool3 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                    }
                    Bool $org_scalatest_assert_macro_right6 = bool3;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "&&", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1391));
                    AnalysisException e3 = (AnalysisException)((Object)((Object)((Object)((Object)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(155).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n               |USING source s\n               |ON t.pk = s.pk\n               |WHEN MATCHED AND ").append(expr).append(" THEN\n               | DELETE\n               |").toString()))), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1393))))));
                    String $org_scalatest_assert_macro_left8 = e3.message();
                    String $org_scalatest_assert_macro_right7 = "unsupported DELETE condition";
                    Bool $org_scalatest_assert_macro_left9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left8.contains($org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
                    if ($org_scalatest_assert_macro_left9.value()) {
                        String $org_scalatest_assert_macro_left10 = e3.message();
                        String $org_scalatest_assert_macro_right8 = errMsg;
                        bool2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "contains", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left10.contains($org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
                    } else {
                        bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                    }
                    Bool $org_scalatest_assert_macro_right9 = bool2;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "&&", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1402));
                    AnalysisException e4 = (AnalysisException)((Object)((Object)((Object)((Object)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(161).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n               |USING source s\n               |ON t.pk = s.pk\n               |WHEN NOT MATCHED AND ").append(expr).append(" THEN\n               | INSERT *\n               |").toString()))), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1404))))));
                    String $org_scalatest_assert_macro_left11 = e4.message();
                    String $org_scalatest_assert_macro_right10 = "unsupported INSERT condition";
                    $org_scalatest_assert_macro_left = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "contains", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left11.contains($org_scalatest_assert_macro_right10), Prettifier$.MODULE$.default());
                    if ($org_scalatest_assert_macro_left.value()) {
                        String $org_scalatest_assert_macro_left12 = e4.message();
                        String $org_scalatest_assert_macro_right11 = errMsg;
                        bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "contains", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left12.contains($org_scalatest_assert_macro_right11), Prettifier$.MODULE$.default());
                    } else {
                        bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Bool $org_scalatest_assert_macro_right = bool;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1413));
                return assertion;
            });
            Map unsupportedTargetExprs = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"t.pk < rand()"), (Object)"Non-deterministic expressions are not allowed"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max(t.pk) < 10"), (Object)"Aggregates are not allowed"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(25).append("t.pk IN (SELECT pk FROM ").append(this.tableNameAsString()).append(")").toString()), (Object)"Subqueries are not allowed")}));
            unsupportedTargetExprs.map((Function1 & Serializable)x0$2 -> {
                Bool bool;
                Bool $org_scalatest_assert_macro_left;
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    Bool bool2;
                    Bool bool3;
                    String $org_scalatest_assert_macro_right;
                    String expr = (String)tuple2._1();
                    String errMsg = (String)tuple2._2();
                    AnalysisException e1 = (AnalysisException)((Object)((Object)((Object)((Object)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(161).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n               |USING source s\n               |ON t.pk = s.pk AND ").append(expr).append("\n               |WHEN MATCHED THEN\n               | UPDATE SET *\n               |").toString()))), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1422))))));
                    String $org_scalatest_assert_macro_left2 = e1.message();
                    Bool $org_scalatest_assert_macro_left3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)($org_scalatest_assert_macro_right = "unsupported SEARCH condition"), $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    if ($org_scalatest_assert_macro_left3.value()) {
                        String $org_scalatest_assert_macro_left4 = e1.message();
                        String $org_scalatest_assert_macro_right2 = errMsg;
                        bool3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    } else {
                        bool3 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                    }
                    Bool $org_scalatest_assert_macro_right3 = bool3;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1431));
                    AnalysisException e2 = (AnalysisException)((Object)((Object)((Object)((Object)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(183).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n               |USING source s\n               |ON t.pk = s.pk\n               |WHEN NOT MATCHED BY SOURCE AND ").append(expr).append(" THEN\n               | UPDATE SET t.pk = -1\n               |").toString()))), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1433))))));
                    String $org_scalatest_assert_macro_left5 = e2.message();
                    String $org_scalatest_assert_macro_right4 = "unsupported UPDATE condition";
                    Bool $org_scalatest_assert_macro_left6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                    if ($org_scalatest_assert_macro_left6.value()) {
                        String $org_scalatest_assert_macro_left7 = e2.message();
                        String $org_scalatest_assert_macro_right5 = errMsg;
                        bool2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left7.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
                    } else {
                        bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                    }
                    Bool $org_scalatest_assert_macro_right6 = bool2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "&&", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1442));
                    AnalysisException e3 = (AnalysisException)((Object)((Object)((Object)((Object)this.intercept((Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(169).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n               |USING source s\n               |ON t.pk = s.pk\n               |WHEN NOT MATCHED BY SOURCE AND ").append(expr).append(" THEN\n               | DELETE\n               |").toString()))), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1444))))));
                    String $org_scalatest_assert_macro_left8 = e3.message();
                    String $org_scalatest_assert_macro_right7 = "unsupported DELETE condition";
                    $org_scalatest_assert_macro_left = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left8.contains($org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
                    if ($org_scalatest_assert_macro_left.value()) {
                        String $org_scalatest_assert_macro_left9 = e3.message();
                        String $org_scalatest_assert_macro_right8 = errMsg;
                        bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "contains", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left9.contains($org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
                    } else {
                        bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Bool $org_scalatest_assert_macro_right = bool;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1453));
                return assertion;
            });
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1355));
        this.test("all target filters are evaluated on data source side", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"hr\" }\n          |{ \"pk\": 3, \"salary\": 300, \"dep\": \"hr\" }\n          |{ \"pk\": 4, \"salary\": 400, \"dep\": \"software\" }\n          |{ \"pk\": 5, \"salary\": 500, \"dep\": \"software\" }\n          |")));
            Dataset sourceDF = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 6})), this.testImplicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk"}));
            sourceDF.createOrReplaceTempView("source");
            SparkPlan executedPlan = this.executeAndKeepPlan((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(299).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n             |USING source s\n             |ON t.pk = s.pk AND t.DeP IN ('hr', 'software')\n             |WHEN MATCHED THEN\n             | UPDATE SET t.salary = t.salary + 1\n             |WHEN NOT MATCHED THEN\n             | INSERT (pk, salary, dep) VALUES (s.pk, 0, 'hr')\n             |").toString()))));
            Seq expressions = this.flatMap(executedPlan, (Function1 & Serializable)x$1 -> (Seq)x$1.expressions().flatMap((Function1 & Serializable)condition -> this.splitConjunctivePredicates((Expression)condition)));
            boolean inFilterPushed = expressions.forall((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)MergeIntoTableSuiteBase.$anonfun$new$160(x0$3)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(inFilterPushed, "inFilterPushed", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"IN filter must be evaluated on data source side", Prettifier$.MODULE$.default(), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1488));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)101), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)201), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)301), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)400), "software"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)500), "software"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)0), "hr"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1458));
        this.test("some target filters are evaluated on data source side", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"hr\" }\n          |{ \"pk\": 3, \"salary\": 300, \"dep\": \"hr\" }\n          |{ \"pk\": 4, \"salary\": 400, \"dep\": \"software\" }\n          |{ \"pk\": 5, \"salary\": 500, \"dep\": \"software\" }\n          |")));
            Dataset sourceDF = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 6})), this.testImplicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk"}));
            sourceDF.createOrReplaceTempView("source");
            SparkPlan executedPlan = this.executeAndKeepPlan((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(318).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n             |USING source s\n             |ON t.pk = s.pk AND t.dep IN ('hr', 'software') AND t.salary != -1\n             |WHEN MATCHED THEN\n             | UPDATE SET t.salary = t.salary + 1\n             |WHEN NOT MATCHED THEN\n             | INSERT (pk, salary, dep) VALUES (s.pk, 0, 'hr')\n             |").toString()))));
            Seq expressions = this.flatMap(executedPlan, (Function1 & Serializable)x$2 -> (Seq)x$2.expressions().flatMap((Function1 & Serializable)condition -> this.splitConjunctivePredicates((Expression)condition)));
            boolean inFilterPushed = expressions.forall((Function1 & Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)MergeIntoTableSuiteBase.$anonfun$new$167(x0$4)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(inFilterPushed, "inFilterPushed", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"IN filter must be evaluated on data source side", Prettifier$.MODULE$.default(), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1533));
            boolean notEqualFilterPreserved = expressions.exists((Function1 & Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)MergeIntoTableSuiteBase.$anonfun$new$168(x0$5)));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(notEqualFilterPreserved, "notEqualFilterPreserved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"NOT filter must be evaluated on Spark side", Prettifier$.MODULE$.default(), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1539));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)101), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)201), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)301), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)400), "software"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)500), "software"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)0), "hr"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1502));
        this.test("pushable target filters are preserved with NOT MATCHED BY SOURCE clause", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"source"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.createAndInitTable("pk INT NOT NULL, salary INT, dep STRING", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{ \"pk\": 1, \"salary\": 100, \"dep\": \"hr\" }\n          |{ \"pk\": 2, \"salary\": 200, \"dep\": \"hr\" }\n          |{ \"pk\": 3, \"salary\": 300, \"dep\": \"hr\" }\n          |{ \"pk\": 4, \"salary\": 400, \"dep\": \"software\" }\n          |{ \"pk\": 5, \"salary\": 500, \"dep\": \"software\" }\n          |")));
            Dataset sourceDF = this.testImplicits().localSeqToDatasetHolder((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 6})), this.testImplicits().newIntEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pk"}));
            sourceDF.createOrReplaceTempView("source");
            SparkPlan executedPlan = this.executeAndKeepPlan((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.sql().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(365).append("MERGE INTO ").append(this.tableNameAsString()).append(" t\n             |USING source s\n             |ON t.pk = s.pk AND DeP IN ('hr', 'software')\n             |WHEN MATCHED THEN\n             | UPDATE SET t.salary = t.salary + 1\n             |WHEN NOT MATCHED THEN\n             | INSERT (pk, salary, dep) VALUES (s.pk, 0, 'hr')\n             |WHEN NOT MATCHED BY SOURCE THEN\n             | DELETE\n             |").toString()))));
            Seq expressions = this.flatMap(executedPlan, (Function1 & Serializable)x$3 -> (Seq)x$3.expressions().flatMap((Function1 & Serializable)condition -> this.splitConjunctivePredicates((Expression)condition)));
            boolean inFilterPreserved = expressions.exists((Function1 & Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)MergeIntoTableSuiteBase.$anonfun$new$175(x0$6)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(inFilterPreserved, "inFilterPreserved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"IN filter must be preserved", Prettifier$.MODULE$.default(), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1585));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(this.tableNameAsString()).toString()), (Seq<Row>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)101), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)201), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)301), "hr"})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)0), "hr"}))}))));
        }), new Position("MergeIntoTableSuiteBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1553));
    }
}

