/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkConf;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

public final class FilterPushdownBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static final FilterPushdownBenchmark$ MODULE$ = new FilterPushdownBenchmark$();
    private static final int numRows;
    private static final int width;
    private static final int mid;
    private static final int blockSize;
    private static SparkSession spark;
    private static String sparkHome;
    private static volatile boolean bitmap$0;

    static {
        SQLHelper.$init$((SQLHelper)MODULE$);
        SqlBasedBenchmark.$init$(MODULE$);
        numRows = 0xF00000;
        width = 5;
        mid = MODULE$.numRows() / 2;
        blockSize = 0x100000;
    }

    @Override
    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$(this, name, cardinality, f);
    }

    @Override
    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$(this, ds);
    }

    @Override
    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$(this, benchmark);
    }

    @Override
    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$(this, path, rowsNum, numCols);
    }

    @Override
    public void afterAll() {
        SqlBasedBenchmark.afterAll$(this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    @Override
    public SparkSession spark() {
        return spark;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        spark = x$1;
    }

    private String sparkHome$lzycompute() {
        FilterPushdownBenchmark$ filterPushdownBenchmark$ = this;
        synchronized (filterPushdownBenchmark$) {
            if (!bitmap$0) {
                sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                bitmap$0 = true;
            }
        }
        return sparkHome;
    }

    public String sparkHome() {
        return !bitmap$0 ? this.sparkHome$lzycompute() : sparkHome;
    }

    @Override
    public SparkSession getSparkSession() {
        SparkConf conf = new SparkConf().setAppName(this.getClass().getSimpleName()).set("spark.master", "local[1]").setIfMissing("spark.driver.memory", "3g").setIfMissing("spark.executor.memory", "3g").setIfMissing("orc.compression", "snappy").setIfMissing("spark.sql.parquet.compression.codec", "snappy");
        return SparkSession$.MODULE$.builder().config(conf).getOrCreate();
    }

    private int numRows() {
        return numRows;
    }

    private int width() {
        return width;
    }

    private int mid() {
        return mid;
    }

    private int blockSize() {
        return blockSize;
    }

    public void withTempTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        finally {
            tableNames.foreach((Function1 & Serializable)viewName -> BoxesRunTime.boxToBoolean((boolean)FilterPushdownBenchmark$.$anonfun$withTempTable$1(viewName)));
        }
    }

    private void prepareTable(File dir, int numRows, int width, boolean useStringForValue) {
        IndexedSeq selectExpr = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), width).map((Function1 & Serializable)i -> FilterPushdownBenchmark$.$anonfun$prepareTable$1(BoxesRunTime.unboxToInt((Object)i)));
        Column valueCol = useStringForValue ? functions$.MODULE$.monotonically_increasing_id().cast("string") : functions$.MODULE$.monotonically_increasing_id();
        Dataset df = this.spark().range((long)numRows).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), this.spark().implicits().newLongEncoder()).selectExpr((Seq)selectExpr).withColumn("value", valueCol).sort("value", (Seq)Nil$.MODULE$);
        this.saveAsTable((Dataset<Row>)df, dir, this.saveAsTable$default$3());
    }

    private void prepareStringDictTable(File dir, int numRows, int numDistinctValues, int width) {
        IndexedSeq selectExpr = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), width).map((Function1 & Serializable)x0$1 -> FilterPushdownBenchmark$.$anonfun$prepareStringDictTable$1(numDistinctValues, BoxesRunTime.unboxToInt((Object)x0$1)));
        Dataset df = this.spark().range((long)numRows).selectExpr((Seq)selectExpr).sort("value", (Seq)Nil$.MODULE$);
        this.saveAsTable((Dataset<Row>)df, dir, true);
    }

    private void saveAsTable(Dataset<Row> df, File dir, boolean useDictionary) {
        String orcPath = new StringBuilder(4).append(dir.getCanonicalPath()).append("/orc").toString();
        String parquetPath = new StringBuilder(8).append(dir.getCanonicalPath()).append("/parquet").toString();
        df.write().mode("overwrite").option("orc.dictionary.key.threshold", useDictionary ? 1.0 : 0.8).option("orc.compress.size", (long)this.blockSize()).option("orc.stripe.size", (long)this.blockSize()).orc(orcPath);
        this.spark().read().orc(orcPath).createOrReplaceTempView("orcTable");
        df.write().mode("overwrite").option("parquet.block.size", (long)this.blockSize()).parquet(parquetPath);
        this.spark().read().parquet(parquetPath).createOrReplaceTempView("parquetTable");
    }

    private boolean saveAsTable$default$3() {
        return false;
    }

    public void filterPushDownBenchmark(int values, String title, String whereExpr, String selectExpr) {
        String x$1 = title;
        long x$2 = values;
        int x$3 = 5;
        Option x$4 = this.output();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, 5, x$5, x$6, x$7, x$4);
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)pushDownEnabled -> {
            FilterPushdownBenchmark$.$anonfun$filterPushDownBenchmark$1(benchmark, selectExpr, whereExpr, BoxesRunTime.unboxToBoolean((Object)pushDownEnabled));
            return BoxedUnit.UNIT;
        });
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)pushDownEnabled -> {
            FilterPushdownBenchmark$.$anonfun$filterPushDownBenchmark$4(benchmark, selectExpr, whereExpr, BoxesRunTime.unboxToBoolean((Object)pushDownEnabled));
            return BoxedUnit.UNIT;
        });
        benchmark.run();
    }

    public String filterPushDownBenchmark$default$4() {
        return "*";
    }

    private void runIntBenchmark(int numRows, int width, int mid) {
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value IS NULL", new StringBuilder(21).append(mid).append(" < value AND value < ").append(mid).toString()})).foreach((Function1 & Serializable)whereExpr -> {
            FilterPushdownBenchmark$.$anonfun$runIntBenchmark$1(numRows, whereExpr);
            return BoxedUnit.UNIT;
        });
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(8).append("value = ").append(mid).toString(), new StringBuilder(10).append("value <=> ").append(mid).toString(), new StringBuilder(23).append(mid).append(" <= value AND value <= ").append(mid).toString(), new StringBuilder(21).append(mid - 1).append(" < value AND value < ").append(mid + 1).toString()})).foreach((Function1 & Serializable)whereExpr -> {
            FilterPushdownBenchmark$.$anonfun$runIntBenchmark$2(numRows, whereExpr);
            return BoxedUnit.UNIT;
        });
        String selectExpr = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), width).map((Function1 & Serializable)i -> FilterPushdownBenchmark$.$anonfun$runIntBenchmark$3(BoxesRunTime.unboxToInt((Object)i))).mkString("", ",", ", MAX(value)");
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{10, 50, 90})).foreach((Function1)(JFunction1.mcVI.sp & Serializable)percent -> MODULE$.filterPushDownBenchmark(numRows, new StringBuilder(28).append("Select ").append(percent).append("% int rows (value < ").append(numRows * percent / 100).append(")").toString(), new StringBuilder(8).append("value < ").append(numRows * percent / 100).toString(), selectExpr));
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value IS NOT NULL", "value > -1", "value != -1"})).foreach((Function1 & Serializable)whereExpr -> {
            FilterPushdownBenchmark$.MODULE$.filterPushDownBenchmark(numRows, new StringBuilder(22).append("Select all int rows (").append(whereExpr).append(")").toString(), whereExpr, selectExpr);
            return BoxedUnit.UNIT;
        });
    }

    private void runStringBenchmark(int numRows, int width, int searchValue, String colType) {
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value IS NULL", new StringBuilder(25).append("'").append(searchValue).append("' < value AND value < '").append(searchValue).append("'").toString()})).foreach((Function1 & Serializable)whereExpr -> {
            FilterPushdownBenchmark$.$anonfun$runStringBenchmark$1(colType, numRows, whereExpr);
            return BoxedUnit.UNIT;
        });
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append("value = '").append(searchValue).append("'").toString(), new StringBuilder(12).append("value <=> '").append(searchValue).append("'").toString(), new StringBuilder(27).append("'").append(searchValue).append("' <= value AND value <= '").append(searchValue).append("'").toString()})).foreach((Function1 & Serializable)whereExpr -> {
            FilterPushdownBenchmark$.$anonfun$runStringBenchmark$2(colType, numRows, whereExpr);
            return BoxedUnit.UNIT;
        });
        String selectExpr = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), width).map((Function1 & Serializable)i -> FilterPushdownBenchmark$.$anonfun$runStringBenchmark$3(BoxesRunTime.unboxToInt((Object)i))).mkString("", ",", ", MAX(value)");
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value IS NOT NULL"})).foreach((Function1 & Serializable)whereExpr -> {
            FilterPushdownBenchmark$.MODULE$.filterPushDownBenchmark(numRows, new StringBuilder(19).append("Select all ").append(colType).append(" rows (").append(whereExpr).append(")").toString(), whereExpr, selectExpr);
            return BoxedUnit.UNIT;
        });
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.runBenchmark("Pushdown for many distinct value case", (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            FilterPushdownBenchmark$.MODULE$.withTempTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"orcTable", "parquetTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)useStringForValue -> {
                FilterPushdownBenchmark$.$anonfun$runBenchmarkSuite$4(dir, BoxesRunTime.unboxToBoolean((Object)useStringForValue));
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }));
        this.runBenchmark("Pushdown for few distinct value case (use dictionary encoding)", (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            FilterPushdownBenchmark$.$anonfun$runBenchmarkSuite$6(dir);
            return BoxedUnit.UNIT;
        }));
        this.runBenchmark("Pushdown benchmark for StringStartsWith", (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            FilterPushdownBenchmark$.MODULE$.withTempTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"orcTable", "parquetTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                FilterPushdownBenchmark$.MODULE$.prepareTable(dir, FilterPushdownBenchmark$.MODULE$.numRows(), FilterPushdownBenchmark$.MODULE$.width(), true);
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value like '10%'", "value like '1000%'", new StringBuilder(14).append("value like '").append(Integer.toString(FilterPushdownBenchmark$.MODULE$.mid()).substring(0, Integer.toString(FilterPushdownBenchmark$.MODULE$.mid()).length() - 1)).append("%'").toString()})).foreach((Function1 & Serializable)whereExpr -> {
                    FilterPushdownBenchmark$.$anonfun$runBenchmarkSuite$11(whereExpr);
                    return BoxedUnit.UNIT;
                });
            });
            return BoxedUnit.UNIT;
        }));
        this.runBenchmark("Pushdown benchmark for StringEndsWith", (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            FilterPushdownBenchmark$.MODULE$.withTempTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"orcTable", "parquetTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                FilterPushdownBenchmark$.MODULE$.prepareStringDictTable(dir, FilterPushdownBenchmark$.MODULE$.numRows(), 200, FilterPushdownBenchmark$.MODULE$.width());
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value like '%10'", "value like '%1000'", new StringBuilder(14).append("value like '%").append(Integer.toString(FilterPushdownBenchmark$.MODULE$.mid()).substring(0, Integer.toString(FilterPushdownBenchmark$.MODULE$.mid()).length() - 1)).append("'").toString()})).foreach((Function1 & Serializable)whereExpr -> {
                    FilterPushdownBenchmark$.$anonfun$runBenchmarkSuite$15(whereExpr);
                    return BoxedUnit.UNIT;
                });
            });
            return BoxedUnit.UNIT;
        }));
        this.runBenchmark("Pushdown benchmark for StringContains", (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            FilterPushdownBenchmark$.MODULE$.withTempTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"orcTable", "parquetTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                FilterPushdownBenchmark$.MODULE$.prepareStringDictTable(dir, FilterPushdownBenchmark$.MODULE$.numRows(), 200, FilterPushdownBenchmark$.MODULE$.width());
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value like '%10%'", "value like '%1000%'", new StringBuilder(15).append("value like '%").append(Integer.toString(FilterPushdownBenchmark$.MODULE$.mid()).substring(0, Integer.toString(FilterPushdownBenchmark$.MODULE$.mid()).length() - 1)).append("%'").toString()})).foreach((Function1 & Serializable)whereExpr -> {
                    FilterPushdownBenchmark$.$anonfun$runBenchmarkSuite$19(whereExpr);
                    return BoxedUnit.UNIT;
                });
            });
            return BoxedUnit.UNIT;
        }));
        this.runBenchmark(new StringBuilder(23).append("Pushdown benchmark for ").append(DecimalType$.MODULE$.simpleString()).toString(), (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            FilterPushdownBenchmark$.$anonfun$runBenchmarkSuite$21(dir);
            return BoxedUnit.UNIT;
        }));
        this.runBenchmark("Pushdown benchmark for InSet -> InFilters", (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            FilterPushdownBenchmark$.MODULE$.withTempTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"orcTable", "parquetTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                FilterPushdownBenchmark$.MODULE$.prepareTable(dir, FilterPushdownBenchmark$.MODULE$.numRows(), FilterPushdownBenchmark$.MODULE$.width(), false);
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 10, 50, 100})).foreach((Function1)(JFunction1.mcVI.sp & Serializable)count -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{10, 50, 90})).foreach((Function1)(JFunction1.mcVI.sp & Serializable)distribution -> {
                    IndexedSeq filter = package$.MODULE$.Range().apply(0, count).map((Function1)(JFunction1.mcII.sp & Serializable)r -> Random$.MODULE$.nextInt(FilterPushdownBenchmark$.MODULE$.numRows() * distribution / 100));
                    String whereExpr = new StringBuilder(10).append("value in(").append(filter.mkString(",")).append(")").toString();
                    String title = new StringBuilder(51).append("InSet -> InFilters (values count: ").append(count).append(", distribution: ").append(distribution).append(")").toString();
                    FilterPushdownBenchmark$.MODULE$.filterPushDownBenchmark(FilterPushdownBenchmark$.MODULE$.numRows(), title, whereExpr, FilterPushdownBenchmark$.MODULE$.filterPushDownBenchmark$default$4());
                }));
            });
            return BoxedUnit.UNIT;
        }));
        this.runBenchmark(new StringBuilder(23).append("Pushdown benchmark for ").append(ByteType$.MODULE$.simpleString()).toString(), (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            FilterPushdownBenchmark$.$anonfun$runBenchmarkSuite$35(dir);
            return BoxedUnit.UNIT;
        }));
        this.runBenchmark("Pushdown benchmark for Timestamp", (Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            FilterPushdownBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_FILTER_PUSHDOWN_TIMESTAMP_ENABLED().key()), (Object)Boolean.toString(true))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> ((IterableOnceOps)SQLConf.ParquetOutputTimestampType$.MODULE$.values().toSeq().map((Function1 & Serializable)x$4 -> x$4.toString())).foreach((Function1 & Serializable)fileType -> {
                FilterPushdownBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key()), (Object)fileType)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    IndexedSeq columns = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), FilterPushdownBenchmark$.MODULE$.width()).map((Function1 & Serializable)i -> FilterPushdownBenchmark$.$anonfun$runBenchmarkSuite$47(BoxesRunTime.unboxToInt((Object)i)));
                    Dataset df = FilterPushdownBenchmark$.MODULE$.spark().range((long)FilterPushdownBenchmark$.MODULE$.numRows()).selectExpr((Seq)columns).withColumn("value", functions$.MODULE$.timestamp_seconds(functions$.MODULE$.monotonically_increasing_id()));
                    FilterPushdownBenchmark$.MODULE$.withTempTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"orcTable", "parquetTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                        FilterPushdownBenchmark$.MODULE$.saveAsTable((Dataset<Row>)df, dir$9, FilterPushdownBenchmark$.MODULE$.saveAsTable$default$3());
                        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(27).append("value = timestamp_seconds(").append(FilterPushdownBenchmark$.MODULE$.mid()).append(")").toString()})).foreach((Function1 & Serializable)whereExpr -> {
                            FilterPushdownBenchmark$.$anonfun$runBenchmarkSuite$49(fileType, whereExpr);
                            return BoxedUnit.UNIT;
                        });
                        String selectExpr = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), FilterPushdownBenchmark$.MODULE$.width()).map((Function1 & Serializable)i -> FilterPushdownBenchmark$.$anonfun$runBenchmarkSuite$50(BoxesRunTime.unboxToInt((Object)i))).mkString("", ",", ", MAX(value)");
                        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{10, 50, 90})).foreach((Function1)(JFunction1.mcVI.sp & Serializable)percent -> FilterPushdownBenchmark$.MODULE$.filterPushDownBenchmark(FilterPushdownBenchmark$.MODULE$.numRows(), new StringBuilder(0).append(new StringBuilder(35).append("Select ").append(percent).append("% timestamp stored as ").append(fileType).append(" rows ").toString()).append(new StringBuilder(29).append("(value < timestamp_seconds(").append(FilterPushdownBenchmark$.MODULE$.numRows() * percent / 100).append("))").toString()).toString(), new StringBuilder(27).append("value < timestamp_seconds(").append(FilterPushdownBenchmark$.MODULE$.numRows() * percent / 100).append(")").toString(), selectExpr));
                    });
                });
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }));
        this.runBenchmark("Pushdown benchmark with many filters", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int numRows = 1;
            int width = 500;
            MODULE$.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
                FilterPushdownBenchmark$.$anonfun$runBenchmarkSuite$53(width, numRows, dir);
                return BoxedUnit.UNIT;
            });
        });
    }

    public static final /* synthetic */ boolean $anonfun$withTempTable$1(String viewName) {
        return MODULE$.spark().catalog().dropTempView(viewName);
    }

    public static final /* synthetic */ String $anonfun$prepareTable$1(int i) {
        return new StringBuilder(23).append("CAST(value AS STRING) c").append(i).toString();
    }

    public static final /* synthetic */ String $anonfun$prepareStringDictTable$1(int numDistinctValues$1, int x0$1) {
        String string;
        int n = x0$1;
        switch (n) {
            case 0: {
                string = new StringBuilder(30).append("CAST(id % ").append(numDistinctValues$1).append(" AS STRING) AS value").toString();
                break;
            }
            default: {
                string = new StringBuilder(24).append("CAST(rand() AS STRING) c").append(n).toString();
                break;
            }
        }
        return string;
    }

    public static final /* synthetic */ void $anonfun$filterPushDownBenchmark$1(Benchmark benchmark$1, String selectExpr$1, String whereExpr$1, boolean pushDownEnabled) {
        String name = new StringBuilder(19).append("Parquet Vectorized ").append((Object)(pushDownEnabled ? "(Pushdown)" : "")).toString();
        benchmark$1.addCase(name, benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_FILTER_PUSHDOWN_ENABLED().key()), (Object)String.valueOf(BoxesRunTime.boxToBoolean((boolean)pushDownEnabled)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.DatasetToBenchmark(MODULE$.spark().sql(new StringBuilder(32).append("SELECT ").append(selectExpr$1).append(" FROM parquetTable WHERE ").append(whereExpr$1).toString())).noop()));
    }

    public static final /* synthetic */ void $anonfun$filterPushDownBenchmark$4(Benchmark benchmark$1, String selectExpr$1, String whereExpr$1, boolean pushDownEnabled) {
        String name = new StringBuilder(22).append("Native ORC Vectorized ").append((Object)(pushDownEnabled ? "(Pushdown)" : "")).toString();
        benchmark$1.addCase(name, benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_FILTER_PUSHDOWN_ENABLED().key()), (Object)String.valueOf(BoxesRunTime.boxToBoolean((boolean)pushDownEnabled)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> MODULE$.DatasetToBenchmark(MODULE$.spark().sql(new StringBuilder(28).append("SELECT ").append(selectExpr$1).append(" FROM orcTable WHERE ").append(whereExpr$1).toString())).noop()));
    }

    public static final /* synthetic */ void $anonfun$runIntBenchmark$1(int numRows$1, String whereExpr) {
        String title = new StringBuilder(19).append("Select 0 int row (").append(whereExpr).append(")").toString().replace("value AND value", "value");
        MODULE$.filterPushDownBenchmark(numRows$1, title, whereExpr, MODULE$.filterPushDownBenchmark$default$4());
    }

    public static final /* synthetic */ void $anonfun$runIntBenchmark$2(int numRows$1, String whereExpr) {
        String title = new StringBuilder(19).append("Select 1 int row (").append(whereExpr).append(")").toString().replace("value AND value", "value");
        MODULE$.filterPushDownBenchmark(numRows$1, title, whereExpr, MODULE$.filterPushDownBenchmark$default$4());
    }

    public static final /* synthetic */ String $anonfun$runIntBenchmark$3(int i) {
        return new StringBuilder(6).append("MAX(c").append(i).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$runStringBenchmark$1(String colType$1, int numRows$2, String whereExpr) {
        String title = new StringBuilder(16).append("Select 0 ").append(colType$1).append(" row (").append(whereExpr).append(")").toString().replace("value AND value", "value");
        MODULE$.filterPushDownBenchmark(numRows$2, title, whereExpr, MODULE$.filterPushDownBenchmark$default$4());
    }

    public static final /* synthetic */ void $anonfun$runStringBenchmark$2(String colType$1, int numRows$2, String whereExpr) {
        String title = new StringBuilder(16).append("Select 1 ").append(colType$1).append(" row (").append(whereExpr).append(")").toString().replace("value AND value", "value");
        MODULE$.filterPushDownBenchmark(numRows$2, title, whereExpr, MODULE$.filterPushDownBenchmark$default$4());
    }

    public static final /* synthetic */ String $anonfun$runStringBenchmark$3(int i) {
        return new StringBuilder(6).append("MAX(c").append(i).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$runBenchmarkSuite$4(File dir$1, boolean useStringForValue) {
        MODULE$.prepareTable(dir$1, MODULE$.numRows(), MODULE$.width(), useStringForValue);
        if (useStringForValue) {
            MODULE$.runStringBenchmark(MODULE$.numRows(), MODULE$.width(), MODULE$.mid(), "string");
        } else {
            MODULE$.runIntBenchmark(MODULE$.numRows(), MODULE$.width(), MODULE$.mid());
        }
    }

    public static final /* synthetic */ void $anonfun$runBenchmarkSuite$6(File dir) {
        int numDistinctValues = 200;
        MODULE$.withTempTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"orcTable", "parquetTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            MODULE$.prepareStringDictTable(dir, MODULE$.numRows(), numDistinctValues, MODULE$.width());
            MODULE$.runStringBenchmark(MODULE$.numRows(), MODULE$.width(), numDistinctValues / 2, "distinct string");
        });
    }

    public static final /* synthetic */ void $anonfun$runBenchmarkSuite$11(String whereExpr) {
        String title = new StringBuilder(27).append("StringStartsWith filter: (").append(whereExpr).append(")").toString();
        MODULE$.filterPushDownBenchmark(MODULE$.numRows(), title, whereExpr, MODULE$.filterPushDownBenchmark$default$4());
    }

    public static final /* synthetic */ void $anonfun$runBenchmarkSuite$15(String whereExpr) {
        String title = new StringBuilder(25).append("StringEndsWith filter: (").append(whereExpr).append(")").toString();
        MODULE$.filterPushDownBenchmark(MODULE$.numRows(), title, whereExpr, MODULE$.filterPushDownBenchmark$default$4());
    }

    public static final /* synthetic */ void $anonfun$runBenchmarkSuite$19(String whereExpr) {
        String title = new StringBuilder(25).append("StringContains filter: (").append(whereExpr).append(")").toString();
        MODULE$.filterPushDownBenchmark(MODULE$.numRows(), title, whereExpr, MODULE$.filterPushDownBenchmark$default$4());
    }

    public static final /* synthetic */ String $anonfun$runBenchmarkSuite$23(int i) {
        return new StringBuilder(20).append("CAST(id AS string) c").append(i).toString();
    }

    public static final /* synthetic */ void $anonfun$runBenchmarkSuite$25(String dt$1, String whereExpr) {
        String title = new StringBuilder(16).append("Select 1 ").append(dt$1).append(" row (").append(whereExpr).append(")").toString().replace("value AND value", "value");
        MODULE$.filterPushDownBenchmark(MODULE$.numRows(), title, whereExpr, MODULE$.filterPushDownBenchmark$default$4());
    }

    public static final /* synthetic */ String $anonfun$runBenchmarkSuite$26(int i) {
        return new StringBuilder(6).append("MAX(c").append(i).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$runBenchmarkSuite$22(File dir$6, String dt) {
        IndexedSeq columns = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), MODULE$.width()).map((Function1 & Serializable)i -> FilterPushdownBenchmark$.$anonfun$runBenchmarkSuite$23(BoxesRunTime.unboxToInt((Object)i)));
        Column valueCol = dt.equalsIgnoreCase(new StringBuilder(12).append("decimal(").append(Decimal$.MODULE$.MAX_INT_DIGITS()).append(", 2)").toString()) ? functions$.MODULE$.monotonically_increasing_id().$percent((Object)BoxesRunTime.boxToInteger((int)9999999)) : functions$.MODULE$.monotonically_increasing_id();
        Dataset df = MODULE$.spark().range((long)MODULE$.numRows()).selectExpr((Seq)columns).withColumn("value", valueCol.cast(dt));
        MODULE$.withTempTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"orcTable", "parquetTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            MODULE$.saveAsTable((Dataset<Row>)df, dir$6, MODULE$.saveAsTable$default$3());
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(8).append("value = ").append(MODULE$.mid()).toString()})).foreach((Function1 & Serializable)whereExpr -> {
                FilterPushdownBenchmark$.$anonfun$runBenchmarkSuite$25(dt, whereExpr);
                return BoxedUnit.UNIT;
            });
            String selectExpr = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), MODULE$.width()).map((Function1 & Serializable)i -> FilterPushdownBenchmark$.$anonfun$runBenchmarkSuite$26(BoxesRunTime.unboxToInt((Object)i))).mkString("", ",", ", MAX(value)");
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{10, 50, 90})).foreach((Function1)(JFunction1.mcVI.sp & Serializable)percent -> MODULE$.filterPushDownBenchmark(MODULE$.numRows(), new StringBuilder(25).append("Select ").append(percent).append("% ").append(dt).append(" rows (value < ").append(MODULE$.numRows() * percent / 100).append(")").toString(), new StringBuilder(8).append("value < ").append(MODULE$.numRows() * percent / 100).toString(), selectExpr));
        });
    }

    public static final /* synthetic */ void $anonfun$runBenchmarkSuite$21(File dir) {
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(12).append("decimal(").append(Decimal$.MODULE$.MAX_INT_DIGITS()).append(", 2)").toString(), new StringBuilder(12).append("decimal(").append(Decimal$.MODULE$.MAX_LONG_DIGITS()).append(", 2)").toString(), new StringBuilder(12).append("decimal(").append(DecimalType$.MODULE$.MAX_PRECISION()).append(", 2)").toString()})).foreach((Function1 & Serializable)dt -> {
            FilterPushdownBenchmark$.$anonfun$runBenchmarkSuite$22(dir, dt);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$runBenchmarkSuite$36(int i) {
        return new StringBuilder(20).append("CAST(id AS string) c").append(i).toString();
    }

    public static final /* synthetic */ void $anonfun$runBenchmarkSuite$38(String whereExpr) {
        String title = new StringBuilder(16).append("Select 1 ").append(ByteType$.MODULE$.simpleString()).append(" row (").append(whereExpr).append(")").toString().replace("value AND value", "value");
        MODULE$.filterPushDownBenchmark(MODULE$.numRows(), title, whereExpr, MODULE$.filterPushDownBenchmark$default$4());
    }

    public static final /* synthetic */ String $anonfun$runBenchmarkSuite$39(int i) {
        return new StringBuilder(6).append("MAX(c").append(i).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$runBenchmarkSuite$35(File dir) {
        IndexedSeq columns = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), MODULE$.width()).map((Function1 & Serializable)i -> FilterPushdownBenchmark$.$anonfun$runBenchmarkSuite$36(BoxesRunTime.unboxToInt((Object)i)));
        Dataset df = MODULE$.spark().range((long)MODULE$.numRows()).selectExpr((Seq)columns).withColumn("value", functions$.MODULE$.monotonically_increasing_id().$percent((Object)BoxesRunTime.boxToByte((byte)127)).cast((DataType)ByteType$.MODULE$)).orderBy("value", (Seq)Nil$.MODULE$);
        MODULE$.withTempTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"orcTable", "parquetTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            MODULE$.saveAsTable((Dataset<Row>)df, dir, MODULE$.saveAsTable$default$3());
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(30).append("value = CAST(").append(63).append(" AS ").append(ByteType$.MODULE$.simpleString()).append(")").toString()})).foreach((Function1 & Serializable)whereExpr -> {
                FilterPushdownBenchmark$.$anonfun$runBenchmarkSuite$38(whereExpr);
                return BoxedUnit.UNIT;
            });
            String selectExpr = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), MODULE$.width()).map((Function1 & Serializable)i -> FilterPushdownBenchmark$.$anonfun$runBenchmarkSuite$39(BoxesRunTime.unboxToInt((Object)i))).mkString("", ",", ", MAX(value)");
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{10, 50, 90})).foreach((Function1)(JFunction1.mcVI.sp & Serializable)percent -> MODULE$.filterPushDownBenchmark(MODULE$.numRows(), new StringBuilder(0).append(new StringBuilder(15).append("Select ").append(percent).append("% ").append(ByteType$.MODULE$.simpleString()).append(" rows ").toString()).append(new StringBuilder(20).append("(value < CAST(").append(127 * percent / 100).append(" AS ").append(ByteType$.MODULE$.simpleString()).append("))").toString()).toString(), new StringBuilder(18).append("value < CAST(").append(127 * percent / 100).append(" AS ").append(ByteType$.MODULE$.simpleString()).append(")").toString(), selectExpr));
        });
    }

    public static final /* synthetic */ String $anonfun$runBenchmarkSuite$47(int i) {
        return new StringBuilder(20).append("CAST(id AS string) c").append(i).toString();
    }

    public static final /* synthetic */ void $anonfun$runBenchmarkSuite$49(String fileType$1, String whereExpr) {
        String title = new StringBuilder(36).append("Select 1 timestamp stored as ").append(fileType$1).append(" row (").append(whereExpr).append(")").toString().replace("value AND value", "value");
        MODULE$.filterPushDownBenchmark(MODULE$.numRows(), title, whereExpr, MODULE$.filterPushDownBenchmark$default$4());
    }

    public static final /* synthetic */ String $anonfun$runBenchmarkSuite$50(int i) {
        return new StringBuilder(6).append("MAX(c").append(i).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$runBenchmarkSuite$54(int i) {
        return new StringBuilder(4).append("id c").append(i).toString();
    }

    public static final /* synthetic */ String $anonfun$runBenchmarkSuite$57(int i) {
        return new StringBuilder(5).append("c").append(i).append(" = 0").toString();
    }

    public static final /* synthetic */ void $anonfun$runBenchmarkSuite$53(int width$1, int numRows$3, File dir) {
        IndexedSeq columns = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), width$1).map((Function1 & Serializable)i -> FilterPushdownBenchmark$.$anonfun$runBenchmarkSuite$54(BoxesRunTime.unboxToInt((Object)i)));
        Dataset df = MODULE$.spark().range(1L).selectExpr((Seq)columns);
        MODULE$.withTempTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"orcTable", "parquetTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            MODULE$.saveAsTable((Dataset<Row>)df, dir, MODULE$.saveAsTable$default$3());
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 250, 500})).foreach((Function1)(JFunction1.mcVI.sp & Serializable)numFilter -> {
                String whereExpr = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numFilter).map((Function1 & Serializable)i -> FilterPushdownBenchmark$.$anonfun$runBenchmarkSuite$57(BoxesRunTime.unboxToInt((Object)i))).mkString(" and ");
                MODULE$.filterPushDownBenchmark(numRows$3, new StringBuilder(26).append("Select 1 row with ").append(numFilter).append(" filters").toString(), whereExpr, MODULE$.filterPushDownBenchmark$default$4());
            });
        });
    }

    private FilterPushdownBenchmark$() {
    }
}

