/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.DirectByteBufferAllocator;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.column.values.delta.DeltaBinaryPackingValuesWriterForInteger;
import org.apache.spark.sql.execution.datasources.parquet.ParquetDeltaEncodingSuite;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005i4A\u0001E\t\u0001A!)1\u0006\u0001C\u0001Y!)a\u0006\u0001C)_!)a\u0007\u0001C)o!)a\u0007\u0001C)\u0001\")A\t\u0001C)\u000b\")a\t\u0001C)\u000f\")!\n\u0001C)\u0017\")A\n\u0001C)\u0017\")Q\n\u0001C)\u0017\")a\n\u0001C)\u001f\")A\f\u0001C);\")q\f\u0001C)A\")1\r\u0001C)I\")\u0011\u000e\u0001C)U\")\u0011\u000f\u0001C)e\nY\u0002+\u0019:rk\u0016$H)\u001a7uC\u0016s7m\u001c3j]\u001eLe\u000e^3hKJT!AE\n\u0002\u000fA\f'/];fi*\u0011A#F\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u0017/\u0005IQ\r_3dkRLwN\u001c\u0006\u00031e\t1a]9m\u0015\tQ2$A\u0003ta\u0006\u00148N\u0003\u0002\u001d;\u00051\u0011\r]1dQ\u0016T\u0011AH\u0001\u0004_J<7\u0001A\n\u0003\u0001\u0005\u00022AI\u0012&\u001b\u0005\t\u0012B\u0001\u0013\u0012\u0005e\u0001\u0016M]9vKR$U\r\u001c;b\u000b:\u001cw\u000eZ5oON+\u0018\u000e^3\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\u0007%sG/\u0001\u0004=S:LGO\u0010\u000b\u0002[A\u0011!\u0005A\u0001\u0010O\u0016$8\u000b]1sWN\u000bH\u000eV=qKV\t\u0001\u0007\u0005\u00022i5\t!G\u0003\u00024/\u0005)A/\u001f9fg&\u0011QG\r\u0002\r\u0013:$Xm\u001a:bYRK\b/Z\u0001\noJLG/\u001a#bi\u0006$\"\u0001O\u001e\u0011\u0005\u0019J\u0014B\u0001\u001e(\u0005\u0011)f.\u001b;\t\u000bq\u001a\u0001\u0019A\u001f\u0002\t\u0011\fG/\u0019\t\u0004My*\u0013BA (\u0005\u0015\t%O]1z)\rA\u0014I\u0011\u0005\u0006y\u0011\u0001\r!\u0010\u0005\u0006\u0007\u0012\u0001\r!J\u0001\u0007Y\u0016tw\r\u001e5\u0002!%t\u0017\u000e\u001e,bYV,7o\u0016:ji\u0016\u0014H#\u0001\u001d\u0002\u001d\u0005dGn\\2ECR\f\u0017I\u001d:bsR\u0011Q\b\u0013\u0005\u0006\u0013\u001a\u0001\r!J\u0001\u0005g&TX-A\u0007hKRtU\r\u001f;SC:$w.\\\u000b\u0002K\u0005yq-\u001a;UsB,W*\u001b8WC2,X-A\bhKR$\u0016\u0010]3NCb4\u0016\r\\;f\u0003!\u0011X-\u00193ECR\fG\u0003\u0002\u001dQ%jCQ!\u0015\u0006A\u0002\u0015\nQ\u0001^8uC2DQa\u0015\u0006A\u0002Q\u000bAbY8mk6tg+Z2u_J\u0004\"!\u0016-\u000e\u0003YS!aV\u000b\u0002\u0015Y,7\r^8sSj,G-\u0003\u0002Z-\n!rK]5uC\ndWmQ8mk6tg+Z2u_JDQa\u0017\u0006A\u0002\u0015\nQA]8x\u0013\u0012\fAa]6jaR\u0011\u0001H\u0018\u0005\u0006#.\u0001\r!J\u0001\u0013e\u0016\fG\rR1uC\u001a\u0013x.\u001c,fGR|'\u000fF\u0002&C\nDQa\u0015\u0007A\u0002QCQa\u0017\u0007A\u0002\u0015\nQ\"Z:uS6\fG/\u001a3TSj,GCA3i!\t1c-\u0003\u0002hO\t1Ai\\;cY\u0016DQaQ\u0007A\u0002\u0015\n\u0001b]3u-\u0006dW/\u001a\u000b\u0005q-lw\u000eC\u0003m\u001d\u0001\u0007Q(A\u0002beJDQA\u001c\bA\u0002\u0015\nQ!\u001b8eKbDQ\u0001\u001d\bA\u0002\u0015\nQA^1mk\u0016\fQbY8na\u0006\u0014XMV1mk\u0016\u001cHcA:wqB\u0011a\u0005^\u0005\u0003k\u001e\u0012qAQ8pY\u0016\fg\u000eC\u0003x\u001f\u0001\u0007Q%\u0001\u0005fqB,7\r^3e\u0011\u0015Ix\u00021\u0001&\u0003\u0019\t7\r^;bY\u0002")
public class ParquetDeltaEncodingInteger
extends ParquetDeltaEncodingSuite<Object> {
    @Override
    public IntegralType getSparkSqlType() {
        return IntegerType$.MODULE$;
    }

    public void writeData(int[] data) {
        this.writeData(data, data.length);
    }

    public void writeData(int[] data, int length) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.writer().writeInteger(data[i]));
    }

    @Override
    public void initValuesWriter() {
        this.writer_$eq((ValuesWriter)new DeltaBinaryPackingValuesWriterForInteger(this.blockSize(), this.miniBlockNum(), 100, 200, (ByteBufferAllocator)new DirectByteBufferAllocator()));
    }

    public int[] allocDataArray(int size) {
        return new int[size];
    }

    @Override
    public int getNextRandom() {
        return this.random().nextInt();
    }

    @Override
    public int getTypeMinValue() {
        return Integer.MIN_VALUE;
    }

    @Override
    public int getTypeMaxValue() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void readData(int total, WritableColumnVector columnVector, int rowId) {
        this.reader().readIntegers(total, columnVector, rowId);
    }

    @Override
    public void skip(int total) {
        this.reader().skipIntegers(total);
    }

    @Override
    public int readDataFromVector(WritableColumnVector columnVector, int rowId) {
        return columnVector.getInt(rowId);
    }

    @Override
    public double estimatedSize(int length) {
        int miniBlockSize = this.blockSize() / this.miniBlockNum();
        double miniBlockFlushed = Math.ceil(((double)length - 1.0) / (double)miniBlockSize);
        double blockFlushed = Math.ceil(((double)length - 1.0) / (double)this.blockSize());
        return (double)20 + (double)4 * miniBlockFlushed * (double)miniBlockSize + blockFlushed * (double)this.miniBlockNum() + 5.0 * blockFlushed;
    }

    public void setValue(int[] arr, int index, int value) {
        arr[index] = value;
    }

    @Override
    public boolean compareValues(int expected, int actual) {
        return expected == actual;
    }
}

