/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.vectorized;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.execution.vectorized.ColumnVectorUtils;
import org.apache.spark.sql.execution.vectorized.ConstantColumnVector;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00153Aa\u0001\u0003\u0001#!)a\u0003\u0001C\u0001/!)!\u0004\u0001C\u00057\t12i\u001c7v[:4Vm\u0019;peV#\u0018\u000e\\:Tk&$XM\u0003\u0002\u0006\r\u0005Qa/Z2u_JL'0\u001a3\u000b\u0005\u001dA\u0011!C3yK\u000e,H/[8o\u0015\tI!\"A\u0002tc2T!a\u0003\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014)5\t!\"\u0003\u0002\u0016\u0015\ti1\u000b]1sW\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#\u0001\r\u0011\u0005e\u0001Q\"\u0001\u0003\u00021Q,7\u000f^\"p]N$\u0018M\u001c;D_2,XN\u001c,fGR|'\u000f\u0006\u0003\u001dWajDCA\u000f$!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0011)f.\u001b;\t\u000b\u0011\u0012\u0001\u0019A\u0013\u0002\u0003\u0019\u0004BA\b\u0014);%\u0011qe\b\u0002\n\rVt7\r^5p]F\u0002\"!G\u0015\n\u0005)\"!\u0001F\"p]N$\u0018M\u001c;D_2,XN\u001c,fGR|'\u000fC\u0003-\u0005\u0001\u0007Q&\u0001\u0003oC6,\u0007C\u0001\u00186\u001d\ty3\u0007\u0005\u00021?5\t\u0011G\u0003\u00023!\u00051AH]8pizJ!\u0001N\u0010\u0002\rA\u0013X\rZ3g\u0013\t1tG\u0001\u0004TiJLgn\u001a\u0006\u0003i}AQ!\u000f\u0002A\u0002i\nAa]5{KB\u0011adO\u0005\u0003y}\u00111!\u00138u\u0011\u0015q$\u00011\u0001@\u0003\t!G\u000f\u0005\u0002A\u00076\t\u0011I\u0003\u0002C\u0011\u0005)A/\u001f9fg&\u0011A)\u0011\u0002\t\t\u0006$\u0018\rV=qK\u0002")
public class ColumnVectorUtilsSuite
extends SparkFunSuite {
    private void testConstantColumnVector(String name, int size, DataType dt, Function1<ConstantColumnVector, BoxedUnit> f) {
        this.test(name, (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ConstantColumnVector vector = new ConstantColumnVector(size, dt);
            f.apply((Object)vector);
            vector.close();
        }, new Position("ColumnVectorUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
    }

    public static final /* synthetic */ Assertion $anonfun$new$2(ConstantColumnVector vector$1, int i) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(vector$1.isNullAt(i), "vector.isNullAt(i)", Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
    }

    public static final /* synthetic */ Assertion $anonfun$new$3(ConstantColumnVector vector$1, int i) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(vector$1.isNullAt(i), "vector.isNullAt(i)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
    }

    public static final /* synthetic */ void $anonfun$new$1(ConstantColumnVector vector) {
        ColumnVectorUtils.populate((ConstantColumnVector)vector, (InternalRow)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})), (int)0);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(vector.hasNull(), "vector.hasNull()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        int $org_scalatest_assert_macro_left = vector.numNulls();
        int $org_scalatest_assert_macro_right = 10;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorUtilsSuite.$anonfun$new$2(vector, BoxesRunTime.unboxToInt((Object)i)));
        vector.setNotNull();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(vector.hasNull(), "vector.hasNull()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        int $org_scalatest_assert_macro_left2 = vector.numNulls();
        int $org_scalatest_assert_macro_right2 = 0;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorUtilsSuite.$anonfun$new$3(vector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$5(ConstantColumnVector vector$2, int i) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(vector$2.getBoolean(i), "vector.getBoolean(i)", Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
    }

    public static final /* synthetic */ void $anonfun$new$4(ConstantColumnVector vector) {
        ColumnVectorUtils.populate((ConstantColumnVector)vector, (InternalRow)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true)})), (int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorUtilsSuite.$anonfun$new$5(vector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$7(ConstantColumnVector vector$3, int i) {
        byte $org_scalatest_assert_macro_left = vector$3.getByte(i);
        byte $org_scalatest_assert_macro_right = (byte)3;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
    }

    public static final /* synthetic */ void $anonfun$new$6(ConstantColumnVector vector) {
        ColumnVectorUtils.populate((ConstantColumnVector)vector, (InternalRow)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)((byte)3))})), (int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorUtilsSuite.$anonfun$new$7(vector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$9(ConstantColumnVector vector$4, int i) {
        short $org_scalatest_assert_macro_left = vector$4.getShort(i);
        short $org_scalatest_assert_macro_right = (short)3;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
    }

    public static final /* synthetic */ void $anonfun$new$8(ConstantColumnVector vector) {
        ColumnVectorUtils.populate((ConstantColumnVector)vector, (InternalRow)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)((short)3))})), (int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorUtilsSuite.$anonfun$new$9(vector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$11(ConstantColumnVector vector$5, int i) {
        int $org_scalatest_assert_macro_left = vector$5.getInt(i);
        int $org_scalatest_assert_macro_right = 3;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
    }

    public static final /* synthetic */ void $anonfun$new$10(ConstantColumnVector vector) {
        ColumnVectorUtils.populate((ConstantColumnVector)vector, (InternalRow)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)})), (int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorUtilsSuite.$anonfun$new$11(vector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$13(ConstantColumnVector vector$6, int i) {
        long $org_scalatest_assert_macro_left = vector$6.getLong(i);
        long $org_scalatest_assert_macro_right = 3L;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
    }

    public static final /* synthetic */ void $anonfun$new$12(ConstantColumnVector vector) {
        ColumnVectorUtils.populate((ConstantColumnVector)vector, (InternalRow)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L)})), (int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorUtilsSuite.$anonfun$new$13(vector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$15(ConstantColumnVector vector$7, int i) {
        float $org_scalatest_assert_macro_left = vector$7.getFloat(i);
        float $org_scalatest_assert_macro_right = 3;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
    }

    public static final /* synthetic */ void $anonfun$new$14(ConstantColumnVector vector) {
        ColumnVectorUtils.populate((ConstantColumnVector)vector, (InternalRow)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)3)})), (int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorUtilsSuite.$anonfun$new$15(vector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$17(ConstantColumnVector vector$8, int i) {
        double $org_scalatest_assert_macro_left = vector$8.getDouble(i);
        double $org_scalatest_assert_macro_right = 3;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
    }

    public static final /* synthetic */ void $anonfun$new$16(ConstantColumnVector vector) {
        ColumnVectorUtils.populate((ConstantColumnVector)vector, (InternalRow)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)3)})), (int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorUtilsSuite.$anonfun$new$17(vector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$19(ConstantColumnVector vector$9, Decimal decimal$1, int i) {
        Decimal $org_scalatest_assert_macro_left = vector$9.getDecimal(i, 10, 0);
        Decimal $org_scalatest_assert_macro_right = decimal$1;
        Decimal decimal = $org_scalatest_assert_macro_left;
        Decimal decimal2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(decimal != null ? !decimal.equals(decimal2) : decimal2 != null), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
    }

    public static final /* synthetic */ void $anonfun$new$18(ConstantColumnVector vector) {
        Decimal decimal = Decimal$.MODULE$.apply(100L);
        ColumnVectorUtils.populate((ConstantColumnVector)vector, (InternalRow)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{decimal})), (int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorUtilsSuite.$anonfun$new$19(vector, decimal, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$21(ConstantColumnVector vector$10, UTF8String string$1, int i) {
        UTF8String $org_scalatest_assert_macro_left = vector$10.getUTF8String(i);
        UTF8String $org_scalatest_assert_macro_right = string$1;
        UTF8String uTF8String = $org_scalatest_assert_macro_left;
        UTF8String uTF8String2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(uTF8String != null ? !uTF8String.equals(uTF8String2) : uTF8String2 != null), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
    }

    public static final /* synthetic */ void $anonfun$new$20(ConstantColumnVector vector) {
        UTF8String string = UTF8String.fromString((String)"hello");
        ColumnVectorUtils.populate((ConstantColumnVector)vector, (InternalRow)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{string})), (int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorUtilsSuite.$anonfun$new$21(vector, string, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$23(ColumnVectorUtilsSuite $this, ConstantColumnVector vector$11, byte[] binary$1, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(vector$11.getBinary(i));
        byte[] $org_scalatest_assert_macro_right = binary$1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
    }

    public static final /* synthetic */ void $anonfun$new$22(ColumnVectorUtilsSuite $this, ConstantColumnVector vector) {
        byte[] binary = "hello".getBytes("utf8");
        ColumnVectorUtils.populate((ConstantColumnVector)vector, (InternalRow)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{binary})), (int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorUtilsSuite.$anonfun$new$23($this, vector, binary, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$25(ColumnVectorUtilsSuite $this, ConstantColumnVector vector$12, CalendarInterval interval$1, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(vector$12.getInterval(i));
        CalendarInterval $org_scalatest_assert_macro_right = interval$1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
    }

    public static final /* synthetic */ void $anonfun$new$24(ColumnVectorUtilsSuite $this, ConstantColumnVector vector) {
        CalendarInterval interval = new CalendarInterval(3, 5, 1000000L);
        ColumnVectorUtils.populate((ConstantColumnVector)vector, (InternalRow)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{interval})), (int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorUtilsSuite.$anonfun$new$25($this, vector, interval, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ void $anonfun$new$26(ColumnVectorUtilsSuite $this, ConstantColumnVector vector) {
        String message;
        String $org_scalatest_assert_macro_left = message = ((Throwable)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ColumnVectorUtils.populate((ConstantColumnVector)vector, (InternalRow)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"fakeMap"})), (int)0), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("ColumnVectorUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139))).getMessage();
        String $org_scalatest_assert_macro_right = "DataType MAP<INT, BOOLEAN> is not supported in column vectorized reader.";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
    }

    public static final /* synthetic */ void $anonfun$new$28(ColumnVectorUtilsSuite $this, ConstantColumnVector vector) {
        String message;
        String $org_scalatest_assert_macro_left = message = ((Throwable)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ColumnVectorUtils.populate((ConstantColumnVector)vector, (InternalRow)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"fakeStruct"})), (int)0), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("ColumnVectorUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149))).getMessage();
        String $org_scalatest_assert_macro_right = "DataType STRUCT<name: STRING, age: INT> is not supported in column vectorized reader.";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
    }

    public static final /* synthetic */ void $anonfun$new$30(ColumnVectorUtilsSuite $this, ConstantColumnVector vector) {
        String message;
        String $org_scalatest_assert_macro_left = message = ((Throwable)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ColumnVectorUtils.populate((ConstantColumnVector)vector, (InternalRow)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"fakeArray"})), (int)0), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("ColumnVectorUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158))).getMessage();
        String $org_scalatest_assert_macro_right = "DataType ARRAY<INT> is not supported in column vectorized reader.";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
    }

    public ColumnVectorUtilsSuite() {
        this.testConstantColumnVector("fill null", 10, (DataType)IntegerType$.MODULE$, (Function1<ConstantColumnVector, BoxedUnit>)(Function1 & Serializable)vector -> {
            ColumnVectorUtilsSuite.$anonfun$new$1(vector);
            return BoxedUnit.UNIT;
        });
        this.testConstantColumnVector("fill boolean", 10, (DataType)BooleanType$.MODULE$, (Function1<ConstantColumnVector, BoxedUnit>)(Function1 & Serializable)vector -> {
            ColumnVectorUtilsSuite.$anonfun$new$4(vector);
            return BoxedUnit.UNIT;
        });
        this.testConstantColumnVector("fill byte", 10, (DataType)ByteType$.MODULE$, (Function1<ConstantColumnVector, BoxedUnit>)(Function1 & Serializable)vector -> {
            ColumnVectorUtilsSuite.$anonfun$new$6(vector);
            return BoxedUnit.UNIT;
        });
        this.testConstantColumnVector("fill short", 10, (DataType)ShortType$.MODULE$, (Function1<ConstantColumnVector, BoxedUnit>)(Function1 & Serializable)vector -> {
            ColumnVectorUtilsSuite.$anonfun$new$8(vector);
            return BoxedUnit.UNIT;
        });
        this.testConstantColumnVector("fill int", 10, (DataType)IntegerType$.MODULE$, (Function1<ConstantColumnVector, BoxedUnit>)(Function1 & Serializable)vector -> {
            ColumnVectorUtilsSuite.$anonfun$new$10(vector);
            return BoxedUnit.UNIT;
        });
        this.testConstantColumnVector("fill long", 10, (DataType)LongType$.MODULE$, (Function1<ConstantColumnVector, BoxedUnit>)(Function1 & Serializable)vector -> {
            ColumnVectorUtilsSuite.$anonfun$new$12(vector);
            return BoxedUnit.UNIT;
        });
        this.testConstantColumnVector("fill float", 10, (DataType)FloatType$.MODULE$, (Function1<ConstantColumnVector, BoxedUnit>)(Function1 & Serializable)vector -> {
            ColumnVectorUtilsSuite.$anonfun$new$14(vector);
            return BoxedUnit.UNIT;
        });
        this.testConstantColumnVector("fill double", 10, (DataType)DoubleType$.MODULE$, (Function1<ConstantColumnVector, BoxedUnit>)(Function1 & Serializable)vector -> {
            ColumnVectorUtilsSuite.$anonfun$new$16(vector);
            return BoxedUnit.UNIT;
        });
        this.testConstantColumnVector("fill decimal", 10, (DataType)new DecimalType(10, 0), (Function1<ConstantColumnVector, BoxedUnit>)(Function1 & Serializable)vector -> {
            ColumnVectorUtilsSuite.$anonfun$new$18(vector);
            return BoxedUnit.UNIT;
        });
        this.testConstantColumnVector("fill utf8string", 10, (DataType)StringType$.MODULE$, (Function1<ConstantColumnVector, BoxedUnit>)(Function1 & Serializable)vector -> {
            ColumnVectorUtilsSuite.$anonfun$new$20(vector);
            return BoxedUnit.UNIT;
        });
        this.testConstantColumnVector("fill binary", 10, (DataType)BinaryType$.MODULE$, (Function1<ConstantColumnVector, BoxedUnit>)(Function1 & Serializable)vector -> {
            ColumnVectorUtilsSuite.$anonfun$new$22(this, vector);
            return BoxedUnit.UNIT;
        });
        this.testConstantColumnVector("fill calendar interval", 10, (DataType)CalendarIntervalType$.MODULE$, (Function1<ConstantColumnVector, BoxedUnit>)(Function1 & Serializable)vector -> {
            ColumnVectorUtilsSuite.$anonfun$new$24(this, vector);
            return BoxedUnit.UNIT;
        });
        this.testConstantColumnVector("not supported: fill map", 10, (DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)BooleanType$.MODULE$), (Function1<ConstantColumnVector, BoxedUnit>)(Function1 & Serializable)vector -> {
            ColumnVectorUtilsSuite.$anonfun$new$26(this, vector);
            return BoxedUnit.UNIT;
        });
        this.testConstantColumnVector("not supported: fill struct", 10, (DataType)new StructType().add(new StructField("name", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("age", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())), (Function1<ConstantColumnVector, BoxedUnit>)(Function1 & Serializable)vector -> {
            ColumnVectorUtilsSuite.$anonfun$new$28(this, vector);
            return BoxedUnit.UNIT;
        });
        this.testConstantColumnVector("not supported: fill array", 10, (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$), (Function1<ConstantColumnVector, BoxedUnit>)(Function1 & Serializable)vector -> {
            ColumnVectorUtilsSuite.$anonfun$new$30(this, vector);
            return BoxedUnit.UNIT;
        });
    }
}

