/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector;

import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.FakeV2Provider;
import org.apache.spark.sql.connector.InMemoryTableSessionCatalog;
import org.apache.spark.sql.connector.SessionCatalogTest$;
import org.apache.spark.sql.connector.TestV2SessionCatalogBase;
import org.apache.spark.sql.connector.catalog.CatalogManager$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.SharedSparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfter;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005E4\u0001\u0002C\u0005\u0011\u0002\u0007\u0005\u0011b\u0005\u0005\u0006K\u0001!\ta\n\u0005\u0006]\u0001!\tb\f\u0005\b\u0005\u0002\u0011\r\u0011\"\u0005D\u0011\u001d!\u0005A1A\u0005\u0012\rCQ!\u0012\u0001\u0005B\u001dBQA\u0012\u0001\u0007\u0012\u001dC1b\u0017\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003(9\n\u00112+Z:tS>t7)\u0019;bY><G+Z:u\u0015\tQ1\"A\u0005d_:tWm\u0019;pe*\u0011A\"D\u0001\u0004gFd'B\u0001\b\u0010\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0012#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002%\u0005\u0019qN]4\u0016\u0007Qy\u0006n\u0005\u0003\u0001+ey\u0002C\u0001\f\u0018\u001b\u0005Y\u0011B\u0001\r\f\u0005%\tV/\u001a:z)\u0016\u001cH\u000f\u0005\u0002\u001b;5\t1D\u0003\u0002\u001d\u0017\u0005!A/Z:u\u0013\tq2D\u0001\nTQ\u0006\u0014X\rZ*qCJ\\7+Z:tS>t\u0007C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0012\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002%C\tq!)\u001a4pe\u0016\fe\u000eZ!gi\u0016\u0014\u0018A\u0002\u0013j]&$He\u0001\u0001\u0015\u0003!\u0002\"!\u000b\u0017\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u0012A!\u00168ji\u000691-\u0019;bY><GC\u0001\u00196!\t\t4'D\u00013\u0015\tq\u0013\"\u0003\u00025e\ti1)\u0019;bY><\u0007\u000b\\;hS:DQA\u000e\u0002A\u0002]\nAA\\1nKB\u0011\u0001h\u0010\b\u0003su\u0002\"A\u000f\u0016\u000e\u0003mR!\u0001\u0010\u0014\u0002\rq\u0012xn\u001c;?\u0013\tq$&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0001\u0006\u0013aa\u0015;sS:<'B\u0001 +\u0003!1(GR8s[\u0006$X#A\u001c\u0002!\r\fG/\u00197pO\u000ec\u0017m]:OC6,\u0017!C1gi\u0016\u0014X)Y2i\u0003-1XM]5gsR\u000b'\r\\3\u0015\u0007!B%\nC\u0003J\r\u0001\u0007q'A\u0005uC\ndWMT1nK\")1J\u0002a\u0001\u0019\u0006AQ\r\u001f9fGR,G\r\u0005\u0002N1:\u0011aJ\u0016\b\u0003\u001fVs!\u0001\u0015+\u000f\u0005E\u001bfB\u0001\u001eS\u0013\u0005\u0011\u0012B\u0001\t\u0012\u0013\tqq\"\u0003\u0002\r\u001b%\u0011qkC\u0001\ba\u0006\u001c7.Y4f\u0013\tI&LA\u0005ECR\fgI]1nK*\u0011qkC\u0001\u0010gV\u0004XM\u001d\u0013bMR,'/R1dQ&\u0011Q)X\u0005\u0003=n\u0011ac\u00155be\u0016$7\u000b]1sWN+7o]5p]\n\u000b7/\u001a\u0003\u0006A\u0002\u0011\r!\u0019\u0002\u0002)F\u0011!-\u001a\t\u0003S\rL!\u0001\u001a\u0016\u0003\u000f9{G\u000f[5oOB\u0011\u0011GZ\u0005\u0003OJ\u0012Q\u0001V1cY\u0016$Q!\u001b\u0001C\u0002)\u0014qaQ1uC2|w-\u0005\u0002cWB\u0019A.\\8\u000e\u0003%I!A\\\u0005\u00031Q+7\u000f\u001e,3'\u0016\u001c8/[8o\u0007\u0006$\u0018\r\\8h\u0005\u0006\u001cX\r\u0005\u0002q?2\u0001\u0001")
public interface SessionCatalogTest<T extends Table, Catalog extends TestV2SessionCatalogBase<T>>
extends SharedSparkSession,
BeforeAndAfter {
    public void org$apache$spark$sql$connector$SessionCatalogTest$_setter_$v2Format_$eq(String var1);

    public void org$apache$spark$sql$connector$SessionCatalogTest$_setter_$catalogClassName_$eq(String var1);

    public /* synthetic */ void org$apache$spark$sql$connector$SessionCatalogTest$$super$afterEach();

    public static /* synthetic */ CatalogPlugin catalog$(SessionCatalogTest $this, String name) {
        return $this.catalog(name);
    }

    default public CatalogPlugin catalog(String name) {
        return this.spark().sessionState().catalogManager().catalog(name);
    }

    public String v2Format();

    public String catalogClassName();

    public static /* synthetic */ void afterEach$(SessionCatalogTest $this) {
        $this.afterEach();
    }

    @Override
    default public void afterEach() {
        this.org$apache$spark$sql$connector$SessionCatalogTest$$super$afterEach();
        ((TestV2SessionCatalogBase)this.catalog(CatalogManager$.MODULE$.SESSION_CATALOG_NAME())).clearTables();
        this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
    }

    public void verifyTable(String var1, Dataset<Row> var2);

    public static void $init$(SessionCatalogTest $this) {
        $this.org$apache$spark$sql$connector$SessionCatalogTest$_setter_$v2Format_$eq(FakeV2Provider.class.getName());
        $this.org$apache$spark$sql$connector$SessionCatalogTest$_setter_$catalogClassName_$eq(InMemoryTableSessionCatalog.class.getName());
        $this.before((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.spark().conf().set(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key(), $this.catalogClassName()), new Position("DataSourceV2DataFrameSessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        $this.test("saveAsTable: v2 table - table doesn't exist and default mode (ErrorIfExists)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t1 = "tbl";
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(SessionCatalogTest.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_SessionCatalogTest$$typecreator10$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connector_SessionCatalogTest$$typecreator10$1(SessionCatalogTest $outer) {
                }
            }
            Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c")})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_SessionCatalogTest$$typecreator10$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
            df.write().format($this.v2Format()).saveAsTable(t1);
            $this.verifyTable(t1, (Dataset<Row>)df);
        }, new Position("DataSourceV2DataFrameSessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        $this.test("saveAsTable: v2 table - table doesn't exist and append mode", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t1 = "tbl";
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(SessionCatalogTest.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_SessionCatalogTest$$typecreator20$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connector_SessionCatalogTest$$typecreator20$1(SessionCatalogTest $outer) {
                }
            }
            Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c")})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_SessionCatalogTest$$typecreator20$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
            df.write().format($this.v2Format()).mode("append").saveAsTable(t1);
            $this.verifyTable(t1, (Dataset<Row>)df);
        }, new Position("DataSourceV2DataFrameSessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        $this.test("saveAsTable: Append mode should not fail if the table not exists but a same-name temp view exist", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"same_name"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"same_name"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.spark().range(10L).createTempView("same_name");
            $this.spark().range(20L).write().format($this.v2Format()).mode(SaveMode.Append).saveAsTable("same_name");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.spark().sessionState().catalog().tableExists(TableIdentifier$.MODULE$.apply("same_name", (Option)new Some((Object)"default"))), "SessionCatalogTest.this.spark.sessionState.catalog.tableExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(\"same_name\", scala.Some.apply[String](\"default\")))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2DataFrameSessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
        })), new Position("DataSourceV2DataFrameSessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        $this.test("saveAsTable: v2 table - table exists", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t1 = "tbl";
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(SessionCatalogTest.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_SessionCatalogTest$$typecreator30$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connector_SessionCatalogTest$$typecreator30$1(SessionCatalogTest $outer) {
                }
            }
            Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c")})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_SessionCatalogTest$$typecreator30$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
            $this.spark().sql(new StringBuilder(45).append("CREATE TABLE ").append(t1).append(" (id bigint, data string) USING ").append($this.v2Format()).toString());
            ((Assertions)$this).intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> df.select("id", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"data"})).write().format($this.v2Format()).saveAsTable(t1), ClassTag$.MODULE$.apply(TableAlreadyExistsException.class), new Position("DataSourceV2DataFrameSessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
            df.write().format($this.v2Format()).mode("append").saveAsTable(t1);
            $this.verifyTable(t1, (Dataset<Row>)df);
            df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{$this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"data"}))).$((Seq)Nil$.MODULE$), $this.testImplicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)})).write().format($this.v2Format()).mode("append").saveAsTable(t1);
            $this.verifyTable(t1, (Dataset<Row>)df.union(df));
        }, new Position("DataSourceV2DataFrameSessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
        $this.test("saveAsTable: v2 table - table overwrite and table doesn't exist", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t1 = "tbl";
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(SessionCatalogTest.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_SessionCatalogTest$$typecreator40$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connector_SessionCatalogTest$$typecreator40$1(SessionCatalogTest $outer) {
                }
            }
            Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c")})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_SessionCatalogTest$$typecreator40$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
            df.write().format($this.v2Format()).mode("overwrite").saveAsTable(t1);
            $this.verifyTable(t1, (Dataset<Row>)df);
        }, new Position("DataSourceV2DataFrameSessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
        $this.test("saveAsTable: v2 table - table overwrite and table exists", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t1 = "tbl";
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(SessionCatalogTest.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_SessionCatalogTest$$typecreator50$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connector_SessionCatalogTest$$typecreator50$1(SessionCatalogTest $outer) {
                }
            }
            Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c")})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_SessionCatalogTest$$typecreator50$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
            $this.spark().sql(new StringBuilder(39).append("CREATE TABLE ").append(t1).append(" USING ").append($this.v2Format()).append(" AS SELECT 'c', 'd'").toString());
            df.write().format($this.v2Format()).mode("overwrite").saveAsTable(t1);
            $this.verifyTable(t1, (Dataset<Row>)df);
        }, new Position("DataSourceV2DataFrameSessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
        $this.test("saveAsTable: Overwrite mode should not drop the temp view if the table not exists but a same-name temp view exist", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"same_name"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.withTempView((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"same_name"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.spark().range(10L).createTempView("same_name");
            $this.spark().range(20L).write().format($this.v2Format()).mode(SaveMode.Overwrite).saveAsTable("same_name");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.spark().sessionState().catalog().getTempView("same_name").isDefined(), "SessionCatalogTest.this.spark.sessionState.catalog.getTempView(\"same_name\").isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2DataFrameSessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool($this.spark().sessionState().catalog().tableExists(TableIdentifier$.MODULE$.apply("same_name", (Option)new Some((Object)"default"))), "SessionCatalogTest.this.spark.sessionState.catalog.tableExists(org.apache.spark.sql.catalyst.TableIdentifier.apply(\"same_name\", scala.Some.apply[String](\"default\")))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2DataFrameSessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
        })), new Position("DataSourceV2DataFrameSessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
        $this.test("saveAsTable: v2 table - ignore mode and table doesn't exist", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t1 = "tbl";
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(SessionCatalogTest.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_SessionCatalogTest$$typecreator60$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connector_SessionCatalogTest$$typecreator60$1(SessionCatalogTest $outer) {
                }
            }
            Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c")})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_SessionCatalogTest$$typecreator60$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
            df.write().format($this.v2Format()).mode("ignore").saveAsTable(t1);
            $this.verifyTable(t1, (Dataset<Row>)df);
        }, new Position("DataSourceV2DataFrameSessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
        $this.test("saveAsTable: v2 table - ignore mode and table exists", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String t1 = "tbl";
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(SessionCatalogTest.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_SessionCatalogTest$$typecreator70$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connector_SessionCatalogTest$$typecreator70$1(SessionCatalogTest $outer) {
                }
            }
            Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c")})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_SessionCatalogTest$$typecreator70$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
            $this.spark().sql(new StringBuilder(39).append("CREATE TABLE ").append(t1).append(" USING ").append($this.v2Format()).append(" AS SELECT 'c', 'd'").toString());
            df.write().format($this.v2Format()).mode("ignore").saveAsTable(t1);
            JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(SessionCatalogTest.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_SessionCatalogTest$$typecreator80$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connector_SessionCatalogTest$$typecreator80$1(SessionCatalogTest $outer) {
                }
            }
            $this.verifyTable(t1, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"c", (Object)"d")})), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_connector_SessionCatalogTest$$typecreator80$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"})));
        }, new Position("DataSourceV2DataFrameSessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
    }
}

