/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.vectorized;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.execution.columnar.ColumnAccessor;
import org.apache.spark.sql.execution.columnar.ColumnAccessor$;
import org.apache.spark.sql.execution.columnar.ColumnBuilder;
import org.apache.spark.sql.execution.columnar.ColumnDictionary;
import org.apache.spark.sql.execution.columnar.compression.ColumnBuilderHelper$;
import org.apache.spark.sql.execution.vectorized.Dictionary;
import org.apache.spark.sql.execution.vectorized.MutableColumnarRow;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypeTestUtils$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarRow;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005y4A\u0001D\u0007\u00015!)q\u0004\u0001C\u0001A!)1\u0005\u0001C\u0005I!)a\u0007\u0001C\u0005o!)q\t\u0001C\u0005\u0011\"9!\f\u0001b\u0001\n\u0003Y\u0006BB0\u0001A\u0003%A\fC\u0004a\u0001\t\u0007I\u0011A1\t\r\u0015\u0004\u0001\u0015!\u0003c\u0011\u001d1\u0007A1A\u0005\u0002\u001dDaa\u001b\u0001!\u0002\u0013A\u0007\"\u00027\u0001\t\u0003i'!E\"pYVlgNV3di>\u00148+^5uK*\u0011abD\u0001\u000bm\u0016\u001cGo\u001c:ju\u0016$'B\u0001\t\u0012\u0003%)\u00070Z2vi&|gN\u0003\u0002\u0013'\u0005\u00191/\u001d7\u000b\u0005Q)\u0012!B:qCJ\\'B\u0001\f\u0018\u0003\u0019\t\u0007/Y2iK*\t\u0001$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00017A\u0011A$H\u0007\u0002'%\u0011ad\u0005\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005\t\u0003C\u0001\u0012\u0001\u001b\u0005i\u0011AC<ji\"4Vm\u0019;peR\u0011Q\u0005\u000e\u000b\u0003M1\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012A!\u00168ji\")QF\u0001a\u0001]\u0005)!\r\\8dWB!qeL\u0019'\u0013\t\u0001\u0004FA\u0005Gk:\u001cG/[8ocA\u0011!EM\u0005\u0003g5\u0011Ac\u0016:ji\u0006\u0014G.Z\"pYVlgNV3di>\u0014\b\"B\u001b\u0003\u0001\u0004\t\u0014A\u0002<fGR|'/A\u0006xSRDg+Z2u_J\u001cHc\u0001\u001d;\u007fQ\u0011a%\u000f\u0005\u0006[\r\u0001\rA\f\u0005\u0006w\r\u0001\r\u0001P\u0001\u0005g&TX\r\u0005\u0002({%\u0011a\b\u000b\u0002\u0004\u0013:$\b\"\u0002!\u0004\u0001\u0004\t\u0015A\u00013u!\t\u0011U)D\u0001D\u0015\t!\u0015#A\u0003usB,7/\u0003\u0002G\u0007\nAA)\u0019;b)f\u0004X-A\u0006uKN$h+Z2u_J\u001cH\u0003B%L1f#\"A\n&\t\u000b5\"\u0001\u0019\u0001\u0018\t\u000b1#\u0001\u0019A'\u0002\t9\fW.\u001a\t\u0003\u001dVs!aT*\u0011\u0005ACS\"A)\u000b\u0005IK\u0012A\u0002\u001fs_>$h(\u0003\u0002UQ\u00051\u0001K]3eK\u001aL!AV,\u0003\rM#(/\u001b8h\u0015\t!\u0006\u0006C\u0003<\t\u0001\u0007A\bC\u0003A\t\u0001\u0007\u0011)A\u0005beJ\f\u0017\u0010V=qKV\tA\f\u0005\u0002C;&\u0011al\u0011\u0002\n\u0003J\u0014\u0018-\u001f+za\u0016\f!\"\u0019:sCf$\u0016\u0010]3!\u0003\u001di\u0017\r\u001d+za\u0016,\u0012A\u0019\t\u0003\u0005\u000eL!\u0001Z\"\u0003\u000f5\u000b\u0007\u000fV=qK\u0006AQ.\u00199UsB,\u0007%\u0001\u0006tiJ,8\r\u001e+za\u0016,\u0012\u0001\u001b\t\u0003\u0005&L!A[\"\u0003\u0015M#(/^2u)f\u0004X-A\u0006tiJ,8\r\u001e+za\u0016\u0004\u0013!B2iK\u000e\\Gc\u0001\u0014oy\")qn\u0003a\u0001a\u0006AQ\r\u001f9fGR,G\rE\u0002rmft!A\u001d;\u000f\u0005A\u001b\u0018\"A\u0015\n\u0005UD\u0013a\u00029bG.\fw-Z\u0005\u0003ob\u00141aU3r\u0015\t)\b\u0006\u0005\u0002(u&\u00111\u0010\u000b\u0002\u0004\u0003:L\b\"B?\f\u0001\u0004\t\u0014A\u0003;fgR4Vm\u0019;pe\u0002")
public class ColumnVectorSuite
extends SparkFunSuite {
    private final ArrayType arrayType;
    private final MapType mapType;
    private final StructType structType;

    private void withVector(WritableColumnVector vector, Function1<WritableColumnVector, BoxedUnit> block) {
        try {
            block.apply((Object)vector);
        }
        finally {
            vector.close();
        }
    }

    private void withVectors(int size, DataType dt, Function1<WritableColumnVector, BoxedUnit> block) {
        this.withVector((WritableColumnVector)new OnHeapColumnVector(size, dt), block);
        this.withVector((WritableColumnVector)new OffHeapColumnVector(size, dt), block);
    }

    private void testVectors(String name, int size, DataType dt, Function1<WritableColumnVector, BoxedUnit> block) {
        this.test(name, (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withVectors(size, dt, block), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
    }

    public ArrayType arrayType() {
        return this.arrayType;
    }

    public MapType mapType() {
        return this.mapType;
    }

    public StructType structType() {
        return this.structType;
    }

    public void check(Seq<Object> expected, WritableColumnVector testVector) {
        block0: {
            ((IterableOnceOps)expected.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Object v = tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    if (v instanceof Integer) {
                        Integer n = (Integer)v;
                        int $org_scalatest_assert_macro_left = testVector.getInt(idx);
                        Integer $org_scalatest_assert_macro_right = n;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)$org_scalatest_assert_macro_right, BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), (Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 498));
                        int $org_scalatest_assert_macro_left2 = testVector.getInts(0, testVector$15.capacity)[idx];
                        Integer $org_scalatest_assert_macro_right2 = n;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)$org_scalatest_assert_macro_right2, BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), (Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 499));
                    }
                }
                if (tuple2 != null) {
                    Object v = tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    if (v instanceof Short) {
                        short s = BoxesRunTime.unboxToShort((Object)v);
                        short $org_scalatest_assert_macro_left = testVector.getShort(idx);
                        short $org_scalatest_assert_macro_right = s;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
                        short $org_scalatest_assert_macro_left3 = testVector.getShorts(0, testVector$15.capacity)[idx];
                        short $org_scalatest_assert_macro_right3 = s;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 502));
                    }
                }
                if (tuple2 != null) {
                    Object v = tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    if (v instanceof Byte) {
                        byte by = BoxesRunTime.unboxToByte((Object)v);
                        byte $org_scalatest_assert_macro_left = testVector.getByte(idx);
                        byte $org_scalatest_assert_macro_right = by;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 504));
                        byte $org_scalatest_assert_macro_left4 = testVector.getBytes(0, testVector$15.capacity)[idx];
                        byte $org_scalatest_assert_macro_right4 = by;
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 505));
                    }
                }
                if (tuple2 != null) {
                    Object v = tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    if (v instanceof Long) {
                        long l = BoxesRunTime.unboxToLong((Object)v);
                        long $org_scalatest_assert_macro_left = testVector.getLong(idx);
                        long $org_scalatest_assert_macro_right = l;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 507));
                        long $org_scalatest_assert_macro_left5 = testVector.getLongs(0, testVector$15.capacity)[idx];
                        long $org_scalatest_assert_macro_right5 = l;
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 508));
                    }
                }
                if (tuple2 != null) {
                    Object v = tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    if (v instanceof Float) {
                        float f = BoxesRunTime.unboxToFloat((Object)v);
                        float $org_scalatest_assert_macro_left = testVector.getFloat(idx);
                        float $org_scalatest_assert_macro_right = f;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 510));
                        float $org_scalatest_assert_macro_left6 = testVector.getFloats(0, testVector$15.capacity)[idx];
                        float $org_scalatest_assert_macro_right6 = f;
                        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 511));
                    }
                }
                if (tuple2 != null) {
                    Object v = tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    if (v instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)v);
                        double $org_scalatest_assert_macro_left = testVector.getDouble(idx);
                        double $org_scalatest_assert_macro_right = d;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 513));
                        double $org_scalatest_assert_macro_left7 = testVector.getDoubles(0, testVector$15.capacity)[idx];
                        double $org_scalatest_assert_macro_right7 = d;
                        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 514));
                    }
                }
                if (tuple2 != null) {
                    Object object = tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    if (object == null) {
                        return BoxesRunTime.boxToBoolean((boolean)testVector.isNullAt(idx));
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                int idx = tuple2._2$mcI$sp();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(20).append("Unexpected value at ").append(idx).toString(), Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
            });
            ColumnarArray arr = new ColumnarArray((ColumnVector)testVector, 0, testVector.capacity);
            IndexedSeq $org_scalatest_assert_macro_left = arr.toSeq(testVector.dataType());
            Seq<Object> $org_scalatest_assert_macro_right = expected;
            IndexedSeq indexedSeq = $org_scalatest_assert_macro_left;
            Seq<Object> seq = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", $org_scalatest_assert_macro_right, !(indexedSeq != null ? !indexedSeq.equals(seq) : seq != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 521));
            IndexedSeq $org_scalatest_assert_macro_left2 = arr.copy().toSeq(testVector.dataType());
            Seq<Object> $org_scalatest_assert_macro_right2 = expected;
            IndexedSeq indexedSeq2 = $org_scalatest_assert_macro_left2;
            Seq<Object> seq2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", $org_scalatest_assert_macro_right2, !(indexedSeq2 != null ? !indexedSeq2.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 522));
            if (!expected.nonEmpty()) break block0;
            ColumnarArray withOffset = new ColumnarArray((ColumnVector)testVector, 1, testVector.capacity - 1);
            IndexedSeq $org_scalatest_assert_macro_left3 = withOffset.toSeq(testVector.dataType());
            Seq $org_scalatest_assert_macro_right3 = (Seq)expected.tail();
            IndexedSeq indexedSeq3 = $org_scalatest_assert_macro_left3;
            Seq seq3 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(indexedSeq3 != null ? !indexedSeq3.equals(seq3) : seq3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 526));
            IndexedSeq $org_scalatest_assert_macro_left4 = withOffset.copy().toSeq(testVector.dataType());
            Seq $org_scalatest_assert_macro_right4 = (Seq)expected.tail();
            IndexedSeq indexedSeq4 = $org_scalatest_assert_macro_left4;
            Seq seq4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(indexedSeq4 != null ? !indexedSeq4.equals(seq4) : seq4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 527));
        }
    }

    public static final /* synthetic */ Assertion $anonfun$new$3(ColumnVectorSuite $this, ColumnarArray array$1, ArrayData arrayCopy$1, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$1.get(i, (DataType)BooleanType$.MODULE$));
        boolean $org_scalatest_assert_macro_right = i % 2 == 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$1.get(i, (DataType)BooleanType$.MODULE$));
        boolean $org_scalatest_assert_macro_right2 = i % 2 == 0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
    }

    public static final /* synthetic */ void $anonfun$new$1(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendBoolean(i % 2 == 0));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$3($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$6(ColumnVectorSuite $this, ColumnarArray array$2, ArrayData arrayCopy$2, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$2.get(i, (DataType)ByteType$.MODULE$));
        byte $org_scalatest_assert_macro_right = (byte)i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$2.get(i, (DataType)ByteType$.MODULE$));
        byte $org_scalatest_assert_macro_right2 = (byte)i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
    }

    public static final /* synthetic */ void $anonfun$new$4(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendByte((byte)i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$6($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$9(ColumnVectorSuite $this, ColumnarArray array$3, ArrayData arrayCopy$3, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$3.get(i, (DataType)ShortType$.MODULE$));
        short $org_scalatest_assert_macro_right = (short)i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$3.get(i, (DataType)ShortType$.MODULE$));
        short $org_scalatest_assert_macro_right2 = (short)i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
    }

    public static final /* synthetic */ void $anonfun$new$7(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendShort((short)i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$9($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$12(ColumnVectorSuite $this, ColumnarArray array$4, ArrayData arrayCopy$4, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$4.get(i, (DataType)IntegerType$.MODULE$));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$4.get(i, (DataType)IntegerType$.MODULE$));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
    }

    public static final /* synthetic */ void $anonfun$new$10(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendInt(i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$12($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$15(ColumnVectorSuite $this, ColumnarArray array$5, ArrayData arrayCopy$5, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$5.get(i, (DataType)DateType$.MODULE$));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$5.get(i, (DataType)DateType$.MODULE$));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
    }

    public static final /* synthetic */ void $anonfun$new$13(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendInt(i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$15($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$18(ColumnVectorSuite $this, ColumnarArray array$6, ArrayData arrayCopy$6, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$6.get(i, (DataType)LongType$.MODULE$));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$6.get(i, (DataType)LongType$.MODULE$));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
    }

    public static final /* synthetic */ void $anonfun$new$16(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendLong((long)i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$18($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$21(ColumnVectorSuite $this, ColumnarArray array$7, ArrayData arrayCopy$7, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$7.get(i, (DataType)TimestampType$.MODULE$));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$7.get(i, (DataType)TimestampType$.MODULE$));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
    }

    public static final /* synthetic */ void $anonfun$new$19(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendLong((long)i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$21($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$24(ColumnVectorSuite $this, ColumnarArray array$8, ArrayData arrayCopy$8, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$8.get(i, (DataType)TimestampNTZType$.MODULE$));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$8.get(i, (DataType)TimestampNTZType$.MODULE$));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
    }

    public static final /* synthetic */ void $anonfun$new$22(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendLong((long)i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$24($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$27(ColumnVectorSuite $this, ColumnarArray array$9, ArrayData arrayCopy$9, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$9.get(i, (DataType)FloatType$.MODULE$));
        float $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$9.get(i, (DataType)FloatType$.MODULE$));
        float $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
    }

    public static final /* synthetic */ void $anonfun$new$25(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendFloat((float)i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$27($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$30(ColumnVectorSuite $this, ColumnarArray array$10, ArrayData arrayCopy$10, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$10.get(i, (DataType)DoubleType$.MODULE$));
        double $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$10.get(i, (DataType)DoubleType$.MODULE$));
        double $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
    }

    public static final /* synthetic */ void $anonfun$new$28(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendDouble((double)i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$30($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$33(ColumnVectorSuite $this, ColumnarArray array$11, ArrayData arrayCopy$11, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$11.get(i, (DataType)StringType$.MODULE$));
        UTF8String $org_scalatest_assert_macro_right = UTF8String.fromString((String)new StringBuilder(3).append("str").append(i).toString());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$11.get(i, (DataType)StringType$.MODULE$));
        UTF8String $org_scalatest_assert_macro_right2 = UTF8String.fromString((String)new StringBuilder(3).append("str").append(i).toString());
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
    }

    public static final /* synthetic */ void $anonfun$new$31(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1)(JFunction1.mcII.sp & Serializable)i -> {
            byte[] utf8 = new StringBuilder(3).append("str").append(i).toString().getBytes("utf8");
            return testVector.appendByteArray(utf8, 0, utf8.length);
        });
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$33($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$36(ColumnVectorSuite $this, ColumnarArray array$12, ArrayData arrayCopy$12, int i) {
        byte[] utf8 = new StringBuilder(3).append("str").append(i).toString().getBytes("utf8");
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$12.get(i, (DataType)BinaryType$.MODULE$));
        byte[] $org_scalatest_assert_macro_right = utf8;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$12.get(i, (DataType)BinaryType$.MODULE$));
        byte[] $org_scalatest_assert_macro_right2 = utf8;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
    }

    public static final /* synthetic */ void $anonfun$new$34(ColumnVectorSuite $this, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1)(JFunction1.mcII.sp & Serializable)i -> {
            byte[] utf8 = new StringBuilder(3).append("str").append(i).toString().getBytes("utf8");
            return testVector.appendByteArray(utf8, 0, utf8.length);
        });
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$36($this, array, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$40(ColumnVectorSuite $this, ColumnarArray array$13, YearMonthIntervalType dt$2, ArrayData arrayCopy$13, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$13.get(i, (DataType)dt$2));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$13.get(i, (DataType)dt$2));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
    }

    public static final /* synthetic */ void $anonfun$new$38(ColumnVectorSuite $this, YearMonthIntervalType dt$2, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendInt(i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$40($this, array, dt$2, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$44(ColumnVectorSuite $this, ColumnarArray array$14, DayTimeIntervalType dt$3, ArrayData arrayCopy$14, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(array$14.get(i, (DataType)dt$3));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(arrayCopy$14.get(i, (DataType)dt$3));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
    }

    public static final /* synthetic */ void $anonfun$new$42(ColumnVectorSuite $this, DayTimeIntervalType dt$3, WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)(JFunction1.mcII.sp & Serializable)i -> testVector.appendLong((long)i));
        ColumnarArray array = new ColumnarArray((ColumnVector)testVector, 0, 10);
        ArrayData arrayCopy = array.copy();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$44($this, array, dt$3, arrayCopy, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$47(ColumnVectorSuite $this, MutableColumnarRow mutableRow$1, int i) {
        mutableRow$1.rowId = i;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mutableRow$1.getInt(0)));
        int $org_scalatest_assert_macro_right = 10 - i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
    }

    public static final /* synthetic */ void $anonfun$new$45(ColumnVectorSuite $this, WritableColumnVector testVector) {
        MutableColumnarRow mutableRow = new MutableColumnarRow((WritableColumnVector[])((Object[])new WritableColumnVector[]{testVector}));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            mutableRow$1.rowId = i;
            mutableRow.setInt(0, 10 - i);
        });
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$47($this, mutableRow, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$50(ColumnVectorSuite $this, MutableColumnarRow mutableRow$2, int i) {
        mutableRow$2.rowId = i;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(mutableRow$2.get(0, (DataType)TimestampNTZType$.MODULE$));
        int $org_scalatest_assert_macro_right = 10 - i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(mutableRow$2.copy().get(0, (DataType)TimestampNTZType$.MODULE$));
        int $org_scalatest_assert_macro_right2 = 10 - i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
    }

    public static final /* synthetic */ void $anonfun$new$48(ColumnVectorSuite $this, WritableColumnVector testVector) {
        MutableColumnarRow mutableRow = new MutableColumnarRow((WritableColumnVector[])((Object[])new WritableColumnVector[]{testVector}));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            mutableRow$2.rowId = i;
            mutableRow.setLong(0, (long)(10 - i));
        });
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$50($this, mutableRow, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ void $anonfun$new$51(ColumnVectorSuite $this, WritableColumnVector testVector) {
        WritableColumnVector data = testVector.arrayData();
        for (int i = 0; i < 6; ++i) {
            data.putInt(i, i);
        }
        testVector.putArray(0, 0, 1);
        testVector.putArray(1, 1, 2);
        testVector.putArray(2, 3, 0);
        testVector.putArray(3, 3, 3);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(testVector.getArray(0).toIntArray());
        int[] $org_scalatest_assert_macro_right = new int[]{0};
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(testVector.getArray(1).toIntArray());
        int[] $org_scalatest_assert_macro_right2 = new int[]{1, 2};
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(testVector.getArray(2).toIntArray());
        int[] $org_scalatest_assert_macro_right3 = (int[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int());
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(testVector.getArray(3).toIntArray());
        int[] $org_scalatest_assert_macro_right4 = new int[]{3, 4, 5};
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
    }

    public static final /* synthetic */ void $anonfun$new$52(ColumnVectorSuite $this, WritableColumnVector testVector) {
        WritableColumnVector data = testVector.arrayData();
        testVector.appendArray(1);
        data.appendInt(0);
        testVector.appendArray(2);
        data.appendInt(1);
        data.appendInt(2);
        testVector.appendArray(0);
        testVector.appendArray(3);
        data.appendInt(3);
        data.appendInt(4);
        data.appendInt(5);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(testVector.getArray(0).toIntArray());
        int[] $org_scalatest_assert_macro_right = new int[]{0};
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(testVector.getArray(1).toIntArray());
        int[] $org_scalatest_assert_macro_right2 = new int[]{1, 2};
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(testVector.getArray(2).toIntArray());
        int[] $org_scalatest_assert_macro_right3 = (int[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int());
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(testVector.getArray(3).toIntArray());
        int[] $org_scalatest_assert_macro_right4 = new int[]{3, 4, 5};
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
    }

    public static final /* synthetic */ UTF8String $anonfun$new$54(int i) {
        return UTF8String.fromString((String)new StringBuilder(3).append("str").append(i).toString());
    }

    public static final /* synthetic */ UTF8String $anonfun$new$55(int i) {
        return UTF8String.fromString((String)new StringBuilder(3).append("str").append(i).toString());
    }

    public static final /* synthetic */ void $anonfun$new$53(ColumnVectorSuite $this, WritableColumnVector testVector) {
        WritableColumnVector keys = testVector.getChild(0);
        WritableColumnVector values = testVector.getChild(1);
        for (int i2 = 0; i2 < 6; ++i2) {
            keys.appendInt(i2);
            byte[] utf8 = new StringBuilder(3).append("str").append(i2).toString().getBytes("utf8");
            values.appendByteArray(utf8, 0, utf8.length);
        }
        testVector.putArray(0, 0, 1);
        testVector.putArray(1, 1, 2);
        testVector.putArray(2, 3, 0);
        testVector.putArray(3, 3, 3);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(testVector.getMap(0).keyArray().toIntArray());
        int[] $org_scalatest_assert_macro_right = new int[]{0};
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(testVector.getMap(0).valueArray().toArray((DataType)StringType$.MODULE$, ClassTag$.MODULE$.apply(UTF8String.class)));
        UTF8String[] $org_scalatest_assert_macro_right2 = (UTF8String[])((Object[])new UTF8String[]{UTF8String.fromString((String)"str0")});
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(testVector.getMap(1).keyArray().toIntArray());
        int[] $org_scalatest_assert_macro_right3 = new int[]{1, 2};
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(testVector.getMap(1).valueArray().toArray((DataType)StringType$.MODULE$, ClassTag$.MODULE$.apply(UTF8String.class)));
        UTF8String[] $org_scalatest_assert_macro_right4 = (UTF8String[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 2).map((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$54(BoxesRunTime.unboxToInt((Object)i))).toArray(ClassTag$.MODULE$.apply(UTF8String.class));
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(testVector.getMap(2).keyArray().toIntArray());
        int[] $org_scalatest_assert_macro_right5 = (int[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int());
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(testVector.getMap(2).valueArray().toArray((DataType)StringType$.MODULE$, ClassTag$.MODULE$.apply(UTF8String.class)));
        UTF8String[] $org_scalatest_assert_macro_right6 = (UTF8String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(UTF8String.class));
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = $this.convertToEqualizer(testVector.getMap(3).keyArray().toIntArray());
        int[] $org_scalatest_assert_macro_right7 = new int[]{3, 4, 5};
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = $this.convertToEqualizer(testVector.getMap(3).valueArray().toArray((DataType)StringType$.MODULE$, ClassTag$.MODULE$.apply(UTF8String.class)));
        UTF8String[] $org_scalatest_assert_macro_right8 = (UTF8String[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(3), 5).map((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$55(BoxesRunTime.unboxToInt((Object)i))).toArray(ClassTag$.MODULE$.apply(UTF8String.class));
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
    }

    private static final void appendPair$1(int i, WritableColumnVector keys$1, WritableColumnVector values$1) {
        keys$1.appendInt(i);
        byte[] utf8 = new StringBuilder(3).append("str").append(i).toString().getBytes("utf8");
        values$1.appendByteArray(utf8, 0, utf8.length);
    }

    public static final /* synthetic */ UTF8String $anonfun$new$57(int i) {
        return UTF8String.fromString((String)new StringBuilder(3).append("str").append(i).toString());
    }

    public static final /* synthetic */ UTF8String $anonfun$new$58(int i) {
        return UTF8String.fromString((String)new StringBuilder(3).append("str").append(i).toString());
    }

    public static final /* synthetic */ void $anonfun$new$56(ColumnVectorSuite $this, WritableColumnVector testVector) {
        WritableColumnVector keys = testVector.getChild(0);
        WritableColumnVector values = testVector.getChild(1);
        testVector.appendArray(1);
        ColumnVectorSuite.appendPair$1(0, keys, values);
        testVector.appendArray(2);
        ColumnVectorSuite.appendPair$1(1, keys, values);
        ColumnVectorSuite.appendPair$1(2, keys, values);
        testVector.appendArray(0);
        testVector.appendArray(3);
        ColumnVectorSuite.appendPair$1(3, keys, values);
        ColumnVectorSuite.appendPair$1(4, keys, values);
        ColumnVectorSuite.appendPair$1(5, keys, values);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(testVector.getMap(0).keyArray().toIntArray());
        int[] $org_scalatest_assert_macro_right = new int[]{0};
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(testVector.getMap(0).valueArray().toArray((DataType)StringType$.MODULE$, ClassTag$.MODULE$.apply(UTF8String.class)));
        UTF8String[] $org_scalatest_assert_macro_right2 = (UTF8String[])((Object[])new UTF8String[]{UTF8String.fromString((String)"str0")});
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(testVector.getMap(1).keyArray().toIntArray());
        int[] $org_scalatest_assert_macro_right3 = new int[]{1, 2};
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(testVector.getMap(1).valueArray().toArray((DataType)StringType$.MODULE$, ClassTag$.MODULE$.apply(UTF8String.class)));
        UTF8String[] $org_scalatest_assert_macro_right4 = (UTF8String[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 2).map((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$57(BoxesRunTime.unboxToInt((Object)i))).toArray(ClassTag$.MODULE$.apply(UTF8String.class));
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(testVector.getMap(2).keyArray().toIntArray());
        int[] $org_scalatest_assert_macro_right5 = (int[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int());
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(testVector.getMap(2).valueArray().toArray((DataType)StringType$.MODULE$, ClassTag$.MODULE$.apply(UTF8String.class)));
        UTF8String[] $org_scalatest_assert_macro_right6 = (UTF8String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(UTF8String.class));
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = $this.convertToEqualizer(testVector.getMap(3).keyArray().toIntArray());
        int[] $org_scalatest_assert_macro_right7 = new int[]{3, 4, 5};
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = $this.convertToEqualizer(testVector.getMap(3).valueArray().toArray((DataType)StringType$.MODULE$, ClassTag$.MODULE$.apply(UTF8String.class)));
        UTF8String[] $org_scalatest_assert_macro_right8 = (UTF8String[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(3), 5).map((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$58(BoxesRunTime.unboxToInt((Object)i))).toArray(ClassTag$.MODULE$.apply(UTF8String.class));
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 392));
    }

    public static final /* synthetic */ void $anonfun$new$59(ColumnVectorSuite $this, WritableColumnVector testVector) {
        WritableColumnVector c1 = testVector.getChild(0);
        WritableColumnVector c2 = testVector.getChild(1);
        WritableColumnVector c3 = testVector.getChild(2);
        c1.putInt(0, 123);
        c2.putDouble(0, 3.45);
        c3.putLong(0, 1000L);
        c1.putInt(1, 456);
        c2.putDouble(1, 5.67);
        c3.putLong(1, 2000L);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(testVector.getStruct(0).get(0, (DataType)IntegerType$.MODULE$));
        int $org_scalatest_assert_macro_right = 123;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(testVector.getStruct(0).get(1, (DataType)DoubleType$.MODULE$));
        double $org_scalatest_assert_macro_right2 = 3.45;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 410));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(testVector.getStruct(0).get(2, (DataType)TimestampNTZType$.MODULE$));
        long $org_scalatest_assert_macro_right3 = 1000L;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(testVector.getStruct(1).get(0, (DataType)IntegerType$.MODULE$));
        int $org_scalatest_assert_macro_right4 = 456;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 412));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(testVector.getStruct(1).get(1, (DataType)DoubleType$.MODULE$));
        double $org_scalatest_assert_macro_right5 = 5.67;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(testVector.getStruct(1).get(2, (DataType)TimestampNTZType$.MODULE$));
        long $org_scalatest_assert_macro_right6 = 2000L;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 414));
    }

    public static final /* synthetic */ void $anonfun$new$60(WritableColumnVector testVector) {
        ColumnDictionary dict = new ColumnDictionary(new int[]{7, 8, 9});
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 0);
        testVector.getDictionaryIds().putInt(1, 1);
        testVector.getDictionaryIds().putInt(2, 2);
        int $org_scalatest_assert_macro_left = testVector.getInts(0, 3)[0];
        int $org_scalatest_assert_macro_right = 7;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
        int $org_scalatest_assert_macro_left2 = testVector.getInts(0, 3)[1];
        int $org_scalatest_assert_macro_right2 = 8;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 426));
        int $org_scalatest_assert_macro_left3 = testVector.getInts(0, 3)[2];
        int $org_scalatest_assert_macro_right3 = 9;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 427));
    }

    public static final /* synthetic */ void $anonfun$new$61(WritableColumnVector testVector) {
        ColumnDictionary dict = new ColumnDictionary(new int[]{7, 8, 9});
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 0);
        testVector.getDictionaryIds().putInt(1, 1);
        testVector.getDictionaryIds().putInt(2, 2);
        short $org_scalatest_assert_macro_left = testVector.getShorts(0, 3)[0];
        short $org_scalatest_assert_macro_right = 7;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
        short $org_scalatest_assert_macro_left2 = testVector.getShorts(0, 3)[1];
        short $org_scalatest_assert_macro_right2 = 8;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
        short $org_scalatest_assert_macro_left3 = testVector.getShorts(0, 3)[2];
        short $org_scalatest_assert_macro_right3 = 9;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 440));
    }

    public static final /* synthetic */ void $anonfun$new$62(WritableColumnVector testVector) {
        ColumnDictionary dict = new ColumnDictionary(new int[]{7, 8, 9});
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 0);
        testVector.getDictionaryIds().putInt(1, 1);
        testVector.getDictionaryIds().putInt(2, 2);
        byte $org_scalatest_assert_macro_left = testVector.getBytes(0, 3)[0];
        byte $org_scalatest_assert_macro_right = 7;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
        byte $org_scalatest_assert_macro_left2 = testVector.getBytes(0, 3)[1];
        byte $org_scalatest_assert_macro_right2 = 8;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 452));
        byte $org_scalatest_assert_macro_left3 = testVector.getBytes(0, 3)[2];
        byte $org_scalatest_assert_macro_right3 = 9;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 453));
    }

    public static final /* synthetic */ void $anonfun$new$63(WritableColumnVector testVector) {
        ColumnDictionary dict = new ColumnDictionary(new long[]{0x80000000L, 0x80000001L, 0x80000002L});
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 0);
        testVector.getDictionaryIds().putInt(1, 1);
        testVector.getDictionaryIds().putInt(2, 2);
        long $org_scalatest_assert_macro_left = testVector.getLongs(0, 3)[0];
        long $org_scalatest_assert_macro_right = 0x80000000L;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 464));
        long $org_scalatest_assert_macro_left2 = testVector.getLongs(0, 3)[1];
        long $org_scalatest_assert_macro_right2 = 0x80000001L;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 465));
        long $org_scalatest_assert_macro_left3 = testVector.getLongs(0, 3)[2];
        long $org_scalatest_assert_macro_right3 = 0x80000002L;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 466));
    }

    public static final /* synthetic */ void $anonfun$new$64(WritableColumnVector testVector) {
        ColumnDictionary dict = new ColumnDictionary(new float[]{0.1f, 0.2f, 0.3f});
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 0);
        testVector.getDictionaryIds().putInt(1, 1);
        testVector.getDictionaryIds().putInt(2, 2);
        float $org_scalatest_assert_macro_left = testVector.getFloats(0, 3)[0];
        float $org_scalatest_assert_macro_right = 0.1f;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 477));
        float $org_scalatest_assert_macro_left2 = testVector.getFloats(0, 3)[1];
        float $org_scalatest_assert_macro_right2 = 0.2f;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 478));
        float $org_scalatest_assert_macro_left3 = testVector.getFloats(0, 3)[2];
        float $org_scalatest_assert_macro_right3 = 0.3f;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 479));
    }

    public static final /* synthetic */ void $anonfun$new$65(WritableColumnVector testVector) {
        ColumnDictionary dict = new ColumnDictionary(new double[]{1342.17727, 1342.17728, 1342.17729});
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 0);
        testVector.getDictionaryIds().putInt(1, 1);
        testVector.getDictionaryIds().putInt(2, 2);
        double $org_scalatest_assert_macro_left = testVector.getDoubles(0, 3)[0];
        double $org_scalatest_assert_macro_right = 1342.17727;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 490));
        double $org_scalatest_assert_macro_left2 = testVector.getDoubles(0, 3)[1];
        double $org_scalatest_assert_macro_right2 = 1342.17728;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 491));
        double $org_scalatest_assert_macro_left3 = testVector.getDoubles(0, 3)[2];
        double $org_scalatest_assert_macro_right3 = 1342.17729;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
    }

    public static final /* synthetic */ int $anonfun$new$67(WritableColumnVector testVector$16, Object x0$1) {
        int n;
        Object object = x0$1;
        if (object instanceof Integer) {
            Integer n2 = (Integer)object;
            n = testVector$16.appendInt(Predef$.MODULE$.Integer2int(n2));
        } else {
            n = testVector$16.appendNull();
        }
        return n;
    }

    public static final /* synthetic */ int $anonfun$new$68(Object x0$2) {
        int n;
        Object object = x0$2;
        if (object instanceof Integer) {
            Integer n2 = (Integer)object;
            n = Predef$.MODULE$.Integer2int(n2);
        } else {
            n = -1;
        }
        return n;
    }

    public static final /* synthetic */ void $anonfun$new$66(ColumnVectorSuite $this, WritableColumnVector testVector) {
        Seq expected = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null, BoxesRunTime.boxToInteger((int)3)}));
        expected.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)ColumnVectorSuite.$anonfun$new$67(testVector, x0$1)));
        $this.check((Seq<Object>)expected, testVector);
        Seq expectedDictionary = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), null, BoxesRunTime.boxToInteger((int)9)}));
        int[] dictArray = (int[])((IterableOnceOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-1, -1})).$plus$plus((IterableOnce)expectedDictionary.map((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)ColumnVectorSuite.$anonfun$new$68(x0$2))))).toArray((ClassTag)ClassTag$.MODULE$.Int());
        ColumnDictionary dict = new ColumnDictionary(dictArray);
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 2);
        testVector.getDictionaryIds().putInt(1, -1);
        testVector.getDictionaryIds().putInt(2, 4);
        $this.check((Seq<Object>)expectedDictionary, testVector);
    }

    public static final /* synthetic */ int $anonfun$new$70(WritableColumnVector testVector$17, Object x0$3) {
        int n;
        Object object = x0$3;
        if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            n = testVector$17.appendShort(s);
        } else {
            n = testVector$17.appendNull();
        }
        return n;
    }

    public static final /* synthetic */ int $anonfun$new$71(Object x0$4) {
        int n;
        Object object = x0$4;
        if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            n = s;
        } else {
            n = -1;
        }
        return n;
    }

    public static final /* synthetic */ void $anonfun$new$69(ColumnVectorSuite $this, WritableColumnVector testVector) {
        Seq expected = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)((short)1)), null, BoxesRunTime.boxToShort((short)((short)3))}));
        expected.foreach((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToInteger((int)ColumnVectorSuite.$anonfun$new$70(testVector, x0$3)));
        $this.check((Seq<Object>)expected, testVector);
        Seq expectedDictionary = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)((short)7)), null, BoxesRunTime.boxToShort((short)((short)9))}));
        int[] dictArray = (int[])((IterableOnceOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-1, -1})).$plus$plus((IterableOnce)expectedDictionary.map((Function1 & Serializable)x0$4 -> BoxesRunTime.boxToInteger((int)ColumnVectorSuite.$anonfun$new$71(x0$4))))).toArray((ClassTag)ClassTag$.MODULE$.Int());
        ColumnDictionary dict = new ColumnDictionary(dictArray);
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 2);
        testVector.getDictionaryIds().putInt(1, -1);
        testVector.getDictionaryIds().putInt(2, 4);
        $this.check((Seq<Object>)expectedDictionary, testVector);
    }

    public static final /* synthetic */ int $anonfun$new$73(WritableColumnVector testVector$18, Object x0$5) {
        int n;
        Object object = x0$5;
        if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            n = testVector$18.appendByte(by);
        } else {
            n = testVector$18.appendNull();
        }
        return n;
    }

    public static final /* synthetic */ int $anonfun$new$74(Object x0$6) {
        int n;
        Object object = x0$6;
        if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            n = by;
        } else {
            n = -1;
        }
        return n;
    }

    public static final /* synthetic */ void $anonfun$new$72(ColumnVectorSuite $this, WritableColumnVector testVector) {
        Seq expected = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)((byte)1)), null, BoxesRunTime.boxToByte((byte)((byte)3))}));
        expected.foreach((Function1 & Serializable)x0$5 -> BoxesRunTime.boxToInteger((int)ColumnVectorSuite.$anonfun$new$73(testVector, x0$5)));
        $this.check((Seq<Object>)expected, testVector);
        Seq expectedDictionary = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)((byte)7)), null, BoxesRunTime.boxToByte((byte)((byte)9))}));
        int[] dictArray = (int[])((IterableOnceOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-1, -1})).$plus$plus((IterableOnce)expectedDictionary.map((Function1 & Serializable)x0$6 -> BoxesRunTime.boxToInteger((int)ColumnVectorSuite.$anonfun$new$74(x0$6))))).toArray((ClassTag)ClassTag$.MODULE$.Int());
        ColumnDictionary dict = new ColumnDictionary(dictArray);
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 2);
        testVector.getDictionaryIds().putInt(1, -1);
        testVector.getDictionaryIds().putInt(2, 4);
        $this.check((Seq<Object>)expectedDictionary, testVector);
    }

    public static final /* synthetic */ int $anonfun$new$76(WritableColumnVector testVector$19, Object x0$7) {
        int n;
        Object object = x0$7;
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            n = testVector$19.appendLong(l);
        } else {
            n = testVector$19.appendNull();
        }
        return n;
    }

    public static final /* synthetic */ long $anonfun$new$77(Object x0$8) {
        long l;
        Object object = x0$8;
        long l2 = object instanceof Long ? (l = BoxesRunTime.unboxToLong((Object)object)) : -1L;
        return l2;
    }

    public static final /* synthetic */ void $anonfun$new$75(ColumnVectorSuite $this, WritableColumnVector testVector) {
        Seq expected = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2147483L), null, BoxesRunTime.boxToLong((long)2147485L)}));
        expected.foreach((Function1 & Serializable)x0$7 -> BoxesRunTime.boxToInteger((int)ColumnVectorSuite.$anonfun$new$76(testVector, x0$7)));
        $this.check((Seq<Object>)expected, testVector);
        Seq expectedDictionary = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0x80000000L), null, BoxesRunTime.boxToLong((long)0x80000002L)}));
        long[] dictArray = (long[])((IterableOnceOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{-1L, -1L})).$plus$plus((IterableOnce)expectedDictionary.map((Function1 & Serializable)x0$8 -> BoxesRunTime.boxToLong((long)ColumnVectorSuite.$anonfun$new$77(x0$8))))).toArray((ClassTag)ClassTag$.MODULE$.Long());
        ColumnDictionary dict = new ColumnDictionary(dictArray);
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 2);
        testVector.getDictionaryIds().putInt(1, -1);
        testVector.getDictionaryIds().putInt(2, 4);
        $this.check((Seq<Object>)expectedDictionary, testVector);
    }

    public static final /* synthetic */ int $anonfun$new$79(WritableColumnVector testVector$20, Object x0$9) {
        int n;
        Object object = x0$9;
        if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            n = testVector$20.appendFloat(f);
        } else {
            n = testVector$20.appendNull();
        }
        return n;
    }

    public static final /* synthetic */ float $anonfun$new$80(Object x0$10) {
        float f;
        Object object = x0$10;
        float f2 = object instanceof Float ? (f = BoxesRunTime.unboxToFloat((Object)object)) : -1.0f;
        return f2;
    }

    public static final /* synthetic */ void $anonfun$new$78(ColumnVectorSuite $this, WritableColumnVector testVector) {
        Seq expected = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)1.1f), null, BoxesRunTime.boxToFloat((float)3.3f)}));
        expected.foreach((Function1 & Serializable)x0$9 -> BoxesRunTime.boxToInteger((int)ColumnVectorSuite.$anonfun$new$79(testVector, x0$9)));
        $this.check((Seq<Object>)expected, testVector);
        Seq expectedDictionary = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)0.1f), null, BoxesRunTime.boxToFloat((float)0.3f)}));
        float[] dictArray = (float[])((IterableOnceOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapFloatArray(new float[]{-1.0f, -1.0f})).$plus$plus((IterableOnce)expectedDictionary.map((Function1 & Serializable)x0$10 -> BoxesRunTime.boxToFloat((float)ColumnVectorSuite.$anonfun$new$80(x0$10))))).toArray((ClassTag)ClassTag$.MODULE$.Float());
        ColumnDictionary dict = new ColumnDictionary(dictArray);
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 2);
        testVector.getDictionaryIds().putInt(1, -1);
        testVector.getDictionaryIds().putInt(2, 4);
        $this.check((Seq<Object>)expectedDictionary, testVector);
    }

    public static final /* synthetic */ int $anonfun$new$82(WritableColumnVector testVector$21, Object x0$11) {
        int n;
        Object object = x0$11;
        if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            n = testVector$21.appendDouble(d);
        } else {
            n = testVector$21.appendNull();
        }
        return n;
    }

    public static final /* synthetic */ double $anonfun$new$83(Object x0$12) {
        double d;
        Object object = x0$12;
        double d2 = object instanceof Double ? (d = BoxesRunTime.unboxToDouble((Object)object)) : -1.0;
        return d2;
    }

    public static final /* synthetic */ void $anonfun$new$81(ColumnVectorSuite $this, WritableColumnVector testVector) {
        Seq expected = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)1.1), null, BoxesRunTime.boxToDouble((double)3.3)}));
        expected.foreach((Function1 & Serializable)x0$11 -> BoxesRunTime.boxToInteger((int)ColumnVectorSuite.$anonfun$new$82(testVector, x0$11)));
        $this.check((Seq<Object>)expected, testVector);
        Seq expectedDictionary = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)1342.17727), null, BoxesRunTime.boxToDouble((double)1342.17729)}));
        double[] dictArray = (double[])((IterableOnceOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{-1.0, -1.0})).$plus$plus((IterableOnce)expectedDictionary.map((Function1 & Serializable)x0$12 -> BoxesRunTime.boxToDouble((double)ColumnVectorSuite.$anonfun$new$83(x0$12))))).toArray((ClassTag)ClassTag$.MODULE$.Double());
        ColumnDictionary dict = new ColumnDictionary(dictArray);
        testVector.setDictionary((Dictionary)dict);
        testVector.reserveDictionaryIds(3);
        testVector.getDictionaryIds().putInt(0, 2);
        testVector.getDictionaryIds().putInt(1, -1);
        testVector.getDictionaryIds().putInt(2, 4);
        $this.check((Seq<Object>)expectedDictionary, testVector);
    }

    public static final /* synthetic */ Assertion $anonfun$new$88(ColumnVectorSuite $this, WritableColumnVector testVector$22, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(testVector$22.getArray(i).toIntArray());
        int[] $org_scalatest_assert_macro_right = new int[]{i};
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 686));
    }

    public static final /* synthetic */ void $anonfun$new$85(ColumnVectorSuite $this, WritableColumnVector testVector) {
        WritableColumnVector data = testVector.arrayData();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 8).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> data.putInt(i, i));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 8).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> testVector.putArray(i, i, 1));
        testVector.reserve(16);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$88($this, testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$92(WritableColumnVector testVector$23, int i) {
        boolean $org_scalatest_assert_macro_left = testVector$23.isNullAt(i);
        boolean $org_scalatest_assert_macro_right = i % 2 == 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 695));
    }

    public static final /* synthetic */ void $anonfun$new$90(WritableColumnVector testVector) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 8).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            if (i % 2 == 0) {
                testVector.putNull(i);
            } else {
                testVector.putNotNull(i);
            }
        });
        testVector.reserve(16);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$92(testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$96(WritableColumnVector testVector$24, int i) {
        boolean $org_scalatest_assert_macro_left = testVector$24.isNullAt(i);
        boolean $org_scalatest_assert_macro_right = false;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 717));
        boolean $org_scalatest_assert_macro_left2 = testVector$24.getBoolean(i);
        boolean $org_scalatest_assert_macro_right2 = i % 2 == 0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 718));
    }

    public static final /* synthetic */ void $anonfun$new$95(BooleanType$ dataType$1, ColumnBuilder columnBuilder$1, WritableColumnVector testVector) {
        ColumnAccessor columnAccessor = ColumnAccessor$.MODULE$.apply((DataType)dataType$1, columnBuilder$1.build());
        ColumnAccessor$.MODULE$.decompress(columnAccessor, testVector, 16);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(testVector.isNullAt(0), "testVector.isNullAt(0)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 715));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$96(testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$100(WritableColumnVector testVector$25, int i) {
        boolean $org_scalatest_assert_macro_left = testVector$25.isNullAt(i);
        boolean $org_scalatest_assert_macro_right = false;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 741));
        byte $org_scalatest_assert_macro_left2 = testVector$25.getByte(i);
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 742));
    }

    public static final /* synthetic */ void $anonfun$new$99(ByteType$ dataType$2, ColumnBuilder columnBuilder$2, WritableColumnVector testVector) {
        ColumnAccessor columnAccessor = ColumnAccessor$.MODULE$.apply((DataType)dataType$2, columnBuilder$2.build());
        ColumnAccessor$.MODULE$.decompress(columnAccessor, testVector, 16);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(testVector.isNullAt(0), "testVector.isNullAt(0)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 739));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$100(testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$104(WritableColumnVector testVector$26, int i) {
        boolean $org_scalatest_assert_macro_left = testVector$26.isNullAt(i);
        boolean $org_scalatest_assert_macro_right = false;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 765));
        short $org_scalatest_assert_macro_left2 = testVector$26.getShort(i);
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToShort((short)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 766));
    }

    public static final /* synthetic */ void $anonfun$new$103(ShortType$ dataType$3, ColumnBuilder columnBuilder$3, WritableColumnVector testVector) {
        ColumnAccessor columnAccessor = ColumnAccessor$.MODULE$.apply((DataType)dataType$3, columnBuilder$3.build());
        ColumnAccessor$.MODULE$.decompress(columnAccessor, testVector, 16);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(testVector.isNullAt(0), "testVector.isNullAt(0)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 763));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$104(testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$108(WritableColumnVector testVector$27, int i) {
        boolean $org_scalatest_assert_macro_left = testVector$27.isNullAt(i);
        boolean $org_scalatest_assert_macro_right = false;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 789));
        int $org_scalatest_assert_macro_left2 = testVector$27.getInt(i);
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 790));
    }

    public static final /* synthetic */ void $anonfun$new$107(IntegerType$ dataType$4, ColumnBuilder columnBuilder$4, WritableColumnVector testVector) {
        ColumnAccessor columnAccessor = ColumnAccessor$.MODULE$.apply((DataType)dataType$4, columnBuilder$4.build());
        ColumnAccessor$.MODULE$.decompress(columnAccessor, testVector, 16);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(testVector.isNullAt(0), "testVector.isNullAt(0)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 787));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$108(testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$113(WritableColumnVector testVector$28, int i) {
        boolean $org_scalatest_assert_macro_left = testVector$28.isNullAt(i);
        boolean $org_scalatest_assert_macro_right = false;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 813));
        long $org_scalatest_assert_macro_left2 = testVector$28.getLong(i);
        long $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 814));
    }

    public static final /* synthetic */ void $anonfun$new$112(AtomicType dataType$5, ColumnBuilder columnBuilder$5, WritableColumnVector testVector) {
        ColumnAccessor columnAccessor = ColumnAccessor$.MODULE$.apply((DataType)dataType$5, columnBuilder$5.build());
        ColumnAccessor$.MODULE$.decompress(columnAccessor, testVector, 16);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(testVector.isNullAt(0), "testVector.isNullAt(0)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 811));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$113(testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ void $anonfun$new$110(ColumnVectorSuite $this, AtomicType dataType) {
        ColumnBuilder columnBuilder = ColumnBuilderHelper$.MODULE$.apply((DataType)dataType, 1024, "col", true);
        SpecificInternalRow row = new SpecificInternalRow((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)new AtomicType[]{dataType}));
        row.setNullAt(0);
        columnBuilder.appendFrom((InternalRow)row, 0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            row.setLong(0, (long)i);
            columnBuilder.appendFrom((InternalRow)row, 0);
        });
        $this.withVectors(16, (DataType)dataType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$112(dataType, columnBuilder, testVector);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Assertion $anonfun$new$117(WritableColumnVector testVector$29, int i) {
        boolean $org_scalatest_assert_macro_left = testVector$29.isNullAt(i);
        boolean $org_scalatest_assert_macro_right = false;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 838));
        float $org_scalatest_assert_macro_left2 = testVector$29.getFloat(i);
        float $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 839));
    }

    public static final /* synthetic */ void $anonfun$new$116(FloatType$ dataType$6, ColumnBuilder columnBuilder$6, WritableColumnVector testVector) {
        ColumnAccessor columnAccessor = ColumnAccessor$.MODULE$.apply((DataType)dataType$6, columnBuilder$6.build());
        ColumnAccessor$.MODULE$.decompress(columnAccessor, testVector, 16);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(testVector.isNullAt(0), "testVector.isNullAt(0)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 836));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$117(testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$121(WritableColumnVector testVector$30, int i) {
        boolean $org_scalatest_assert_macro_left = testVector$30.isNullAt(i);
        boolean $org_scalatest_assert_macro_right = false;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 862));
        double $org_scalatest_assert_macro_left2 = testVector$30.getDouble(i);
        double $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 863));
    }

    public static final /* synthetic */ void $anonfun$new$120(DoubleType$ dataType$7, ColumnBuilder columnBuilder$7, WritableColumnVector testVector) {
        ColumnAccessor columnAccessor = ColumnAccessor$.MODULE$.apply((DataType)dataType$7, columnBuilder$7.build());
        ColumnAccessor$.MODULE$.decompress(columnAccessor, testVector, 16);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(testVector.isNullAt(0), "testVector.isNullAt(0)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 860));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$121(testVector, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$125(ColumnVectorSuite $this, WritableColumnVector v$1, YearMonthIntervalType dt$4, int i) {
        ColumnarRow row = v$1.getStruct(i);
        InternalRow rowCopy = row.copy();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(row.get(0, (DataType)dt$4));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 878));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(rowCopy.get(0, (DataType)dt$4));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 879));
    }

    public static final /* synthetic */ void $anonfun$new$123(ColumnVectorSuite $this, YearMonthIntervalType dt$4, WritableColumnVector v) {
        WritableColumnVector column = v.getChild(0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> column.putInt(i, i));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$125($this, v, dt$4, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ void $anonfun$new$122(ColumnVectorSuite $this, YearMonthIntervalType dt) {
        StructType structType = new StructType().add(dt.typeName(), (DataType)dt);
        $this.testVectors(new StringBuilder(12).append("ColumnarRow ").append(dt.typeName()).toString(), 10, (DataType)structType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)v -> {
            ColumnVectorSuite.$anonfun$new$123($this, dt, v);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Assertion $anonfun$new$129(ColumnVectorSuite $this, WritableColumnVector v$2, DayTimeIntervalType dt$5, int i) {
        ColumnarRow row = v$2.getStruct(i);
        InternalRow rowCopy = row.copy();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(row.get(0, (DataType)dt$5));
        int $org_scalatest_assert_macro_right = i;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 893));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(rowCopy.get(0, (DataType)dt$5));
        int $org_scalatest_assert_macro_right2 = i;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 894));
    }

    public static final /* synthetic */ void $anonfun$new$127(ColumnVectorSuite $this, DayTimeIntervalType dt$5, WritableColumnVector v) {
        WritableColumnVector column = v.getChild(0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> column.putLong(i, (long)i));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)i -> ColumnVectorSuite.$anonfun$new$129($this, v, dt$5, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ void $anonfun$new$126(ColumnVectorSuite $this, DayTimeIntervalType dt) {
        StructType structType = new StructType().add(dt.typeName(), (DataType)dt);
        $this.testVectors(new StringBuilder(12).append("ColumnarRow ").append(dt.typeName()).toString(), 10, (DataType)structType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)v -> {
            ColumnVectorSuite.$anonfun$new$127($this, dt, v);
            return BoxedUnit.UNIT;
        });
    }

    public ColumnVectorSuite() {
        this.testVectors("boolean", 10, (DataType)BooleanType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$1(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("byte", 10, (DataType)ByteType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$4(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("short", 10, (DataType)ShortType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$7(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("int", 10, (DataType)IntegerType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$10(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("date", 10, (DataType)DateType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$13(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("long", 10, (DataType)LongType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$16(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("timestamp", 10, (DataType)TimestampType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$19(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("timestamp_ntz", 10, (DataType)TimestampNTZType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$22(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("float", 10, (DataType)FloatType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$25(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("double", 10, (DataType)DoubleType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$28(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("string", 10, (DataType)StringType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$31(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("binary", 10, (DataType)BinaryType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$34(this, testVector);
            return BoxedUnit.UNIT;
        });
        DataTypeTestUtils$.MODULE$.yearMonthIntervalTypes().foreach((Function1 & Serializable)dt -> {
            this.testVectors(dt.typeName(), 10, (DataType)dt, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
                ColumnVectorSuite.$anonfun$new$38($this, dt, testVector);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        DataTypeTestUtils$.MODULE$.dayTimeIntervalTypes().foreach((Function1 & Serializable)dt -> {
            this.testVectors(dt.typeName(), 10, (DataType)dt, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
                ColumnVectorSuite.$anonfun$new$42($this, dt, testVector);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.testVectors("mutable ColumnarRow", 10, (DataType)IntegerType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$45(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("mutable ColumnarRow with TimestampNTZType", 10, (DataType)TimestampNTZType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$48(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.arrayType = new ArrayType((DataType)IntegerType$.MODULE$, true);
        this.testVectors("array", 10, (DataType)this.arrayType(), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$51(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("SPARK-35898: array append", 1, (DataType)this.arrayType(), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$52(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.mapType = MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$);
        this.testVectors("SPARK-35898: map", 5, (DataType)this.mapType(), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$53(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("SPARK-35898: map append", 1, (DataType)this.mapType(), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$56(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.structType = new StructType().add("int", (DataType)IntegerType$.MODULE$).add("double", (DataType)DoubleType$.MODULE$).add("ts", (DataType)TimestampNTZType$.MODULE$);
        this.testVectors("struct", 10, (DataType)this.structType(), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$59(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("SPARK-44805: getInts with dictionary", 3, (DataType)IntegerType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$60(testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("SPARK-44805: getShorts with dictionary", 3, (DataType)ShortType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$61(testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("SPARK-44805: getBytes with dictionary", 3, (DataType)ByteType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$62(testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("SPARK-44805: getLongs with dictionary", 3, (DataType)LongType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$63(testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("SPARK-44805: getFloats with dictionary", 3, (DataType)FloatType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$64(testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("SPARK-44805: getDoubles with dictionary", 3, (DataType)DoubleType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$65(testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("getInts with dictionary and nulls", 3, (DataType)IntegerType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$66(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("getShorts with dictionary and nulls", 3, (DataType)ShortType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$69(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("getBytes with dictionary and nulls", 3, (DataType)ByteType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$72(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("getLongs with dictionary and nulls", 3, (DataType)LongType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$75(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("getFloats with dictionary and nulls", 3, (DataType)FloatType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$78(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.testVectors("getDoubles with dictionary and nulls", 3, (DataType)DoubleType$.MODULE$, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$81(this, testVector);
            return BoxedUnit.UNIT;
        });
        this.test("[SPARK-22092] off-heap column vector reallocation corrupts array data", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withVector((WritableColumnVector)new OffHeapColumnVector(8, (DataType)this.arrayType()), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$85(this, testVector);
            return BoxedUnit.UNIT;
        }), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 675));
        this.test("[SPARK-22092] off-heap column vector reallocation corrupts struct nullability", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withVector((WritableColumnVector)new OffHeapColumnVector(8, (DataType)this.structType()), (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
            ColumnVectorSuite.$anonfun$new$90(testVector);
            return BoxedUnit.UNIT;
        }), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 691));
        this.test("CachedBatch boolean Apis", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            BooleanType$ dataType = BooleanType$.MODULE$;
            ColumnBuilder columnBuilder = ColumnBuilderHelper$.MODULE$.apply((DataType)dataType, 1024, "col", true);
            SpecificInternalRow row = new SpecificInternalRow((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)new BooleanType$[]{dataType}));
            row.setNullAt(0);
            columnBuilder.appendFrom((InternalRow)row, 0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                row.setBoolean(0, i % 2 == 0);
                columnBuilder.appendFrom((InternalRow)row, 0);
            });
            this.withVectors(16, (DataType)dataType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
                ColumnVectorSuite.$anonfun$new$95(dataType, columnBuilder, testVector);
                return BoxedUnit.UNIT;
            });
        }, new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 699));
        this.test("CachedBatch byte Apis", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ByteType$ dataType = ByteType$.MODULE$;
            ColumnBuilder columnBuilder = ColumnBuilderHelper$.MODULE$.apply((DataType)dataType, 1024, "col", true);
            SpecificInternalRow row = new SpecificInternalRow((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)new ByteType$[]{dataType}));
            row.setNullAt(0);
            columnBuilder.appendFrom((InternalRow)row, 0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                row.setByte(0, (byte)i);
                columnBuilder.appendFrom((InternalRow)row, 0);
            });
            this.withVectors(16, (DataType)dataType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
                ColumnVectorSuite.$anonfun$new$99(dataType, columnBuilder, testVector);
                return BoxedUnit.UNIT;
            });
        }, new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 723));
        this.test("CachedBatch short Apis", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ShortType$ dataType = ShortType$.MODULE$;
            ColumnBuilder columnBuilder = ColumnBuilderHelper$.MODULE$.apply((DataType)dataType, 1024, "col", true);
            SpecificInternalRow row = new SpecificInternalRow((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)new ShortType$[]{dataType}));
            row.setNullAt(0);
            columnBuilder.appendFrom((InternalRow)row, 0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                row.setShort(0, (short)i);
                columnBuilder.appendFrom((InternalRow)row, 0);
            });
            this.withVectors(16, (DataType)dataType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
                ColumnVectorSuite.$anonfun$new$103(dataType, columnBuilder, testVector);
                return BoxedUnit.UNIT;
            });
        }, new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 747));
        this.test("CachedBatch int Apis", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            IntegerType$ dataType = IntegerType$.MODULE$;
            ColumnBuilder columnBuilder = ColumnBuilderHelper$.MODULE$.apply((DataType)dataType, 1024, "col", true);
            SpecificInternalRow row = new SpecificInternalRow((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)new IntegerType$[]{dataType}));
            row.setNullAt(0);
            columnBuilder.appendFrom((InternalRow)row, 0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                row.setInt(0, i);
                columnBuilder.appendFrom((InternalRow)row, 0);
            });
            this.withVectors(16, (DataType)dataType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
                ColumnVectorSuite.$anonfun$new$107(dataType, columnBuilder, testVector);
                return BoxedUnit.UNIT;
            });
        }, new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 771));
        this.test("CachedBatch long Apis", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{LongType$.MODULE$, TimestampType$.MODULE$, TimestampNTZType$.MODULE$})).foreach((Function1 & Serializable)dataType -> {
            ColumnVectorSuite.$anonfun$new$110(this, dataType);
            return BoxedUnit.UNIT;
        }), new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 795));
        this.test("CachedBatch float Apis", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            FloatType$ dataType = FloatType$.MODULE$;
            ColumnBuilder columnBuilder = ColumnBuilderHelper$.MODULE$.apply((DataType)dataType, 1024, "col", true);
            SpecificInternalRow row = new SpecificInternalRow((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)new FloatType$[]{dataType}));
            row.setNullAt(0);
            columnBuilder.appendFrom((InternalRow)row, 0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                row.setFloat(0, (float)i);
                columnBuilder.appendFrom((InternalRow)row, 0);
            });
            this.withVectors(16, (DataType)dataType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
                ColumnVectorSuite.$anonfun$new$116(dataType, columnBuilder, testVector);
                return BoxedUnit.UNIT;
            });
        }, new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 820));
        this.test("CachedBatch double Apis", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            DoubleType$ dataType = DoubleType$.MODULE$;
            ColumnBuilder columnBuilder = ColumnBuilderHelper$.MODULE$.apply((DataType)dataType, 1024, "col", true);
            SpecificInternalRow row = new SpecificInternalRow((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)new DoubleType$[]{dataType}));
            row.setNullAt(0);
            columnBuilder.appendFrom((InternalRow)row, 0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 16).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                row.setDouble(0, (double)i);
                columnBuilder.appendFrom((InternalRow)row, 0);
            });
            this.withVectors(16, (DataType)dataType, (Function1<WritableColumnVector, BoxedUnit>)(Function1 & Serializable)testVector -> {
                ColumnVectorSuite.$anonfun$new$120(dataType, columnBuilder, testVector);
                return BoxedUnit.UNIT;
            });
        }, new Position("ColumnVectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 844));
        DataTypeTestUtils$.MODULE$.yearMonthIntervalTypes().foreach((Function1 & Serializable)dt -> {
            ColumnVectorSuite.$anonfun$new$122(this, dt);
            return BoxedUnit.UNIT;
        });
        DataTypeTestUtils$.MODULE$.dayTimeIntervalTypes().foreach((Function1 & Serializable)dt -> {
            ColumnVectorSuite.$anonfun$new$126(this, dt);
            return BoxedUnit.UNIT;
        });
    }
}

