/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Observation$;
import org.apache.spark.sql.ObservationBase;
import org.apache.spark.sql.ObservationListener;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.CollectMetrics;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.util.ArrayImplicits$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\rb\u0001B\n\u0015\u0001uA\u0011B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0019\t\u000bE\u0002A\u0011\u0001\u001a\t\u000bE\u0002A\u0011A\u001b\t\u000fY\u0002!\u0019!C\u0005o!11\b\u0001Q\u0001\naBq\u0001\u0010\u0001A\u0002\u0013%Q\bC\u0004L\u0001\u0001\u0007I\u0011\u0002'\t\rI\u0003\u0001\u0015)\u0003?\u0011\u00199\u0006\u0001\"\u0001\u00171\"1A\u000f\u0001C\u0001)UDQ!\u001f\u0001\u0005\niDaa\u001f\u0001\u0005\u0002Ya\b\"DA\u0006\u0001A\u0005\u0019\u0011!A\u0005\n\u00055\u0001gB\u0004\u0002\u0010QA\t!!\u0005\u0007\rM!\u0002\u0012AA\n\u0011\u0019\tt\u0002\"\u0001\u0002\u001c!1\u0011QD\b\u0005\u0002UBq!!\b\u0010\t\u0003\tyBA\u0006PEN,'O^1uS>t'BA\u000b\u0017\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003/a\tQa\u001d9be.T!!\u0007\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0012aA8sO\u000e\u00011C\u0001\u0001\u001f!\ty\u0002%D\u0001\u0015\u0013\t\tCCA\bPEN,'O^1uS>t')Y:f\u0003\u0011q\u0017-\\3\u0011\u0005\u0011jcBA\u0013,!\t1\u0013&D\u0001(\u0015\tAC$\u0001\u0004=e>|GO\u0010\u0006\u0002U\u0005)1oY1mC&\u0011A&K\u0001\u0007!J,G-\u001a4\n\u00059z#AB*ue&twM\u0003\u0002-S%\u0011!\u0005I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005M\"\u0004CA\u0010\u0001\u0011\u0015\u0011#\u00011\u0001$)\u0005\u0019\u0014\u0001\u00037jgR,g.\u001a:\u0016\u0003a\u0002\"aH\u001d\n\u0005i\"\"aE(cg\u0016\u0014h/\u0019;j_:d\u0015n\u001d;f]\u0016\u0014\u0018!\u00037jgR,g.\u001a:!\u0003-!\u0017\r^1ge\u0006lW-\u00133\u0016\u0003y\u00022a\u0010!C\u001b\u0005I\u0013BA!*\u0005\u0019y\u0005\u000f^5p]B!qhQ#I\u0013\t!\u0015F\u0001\u0004UkBdWM\r\t\u0003?\u0019K!a\u0012\u000b\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005}J\u0015B\u0001&*\u0005\u0011auN\\4\u0002\u001f\u0011\fG/\u00194sC6,\u0017\nZ0%KF$\"!\u0014)\u0011\u0005}r\u0015BA(*\u0005\u0011)f.\u001b;\t\u000fE;\u0011\u0011!a\u0001}\u0005\u0019\u0001\u0010J\u0019\u0002\u0019\u0011\fG/\u00194sC6,\u0017\n\u001a\u0011)\u0005!!\u0006CA V\u0013\t1\u0016F\u0001\u0005w_2\fG/\u001b7f\u0003\tyg.\u0006\u0002Z?R!!\f\u001b6p!\ry2,X\u0005\u00039R\u0011q\u0001R1uCN,G\u000f\u0005\u0002_?2\u0001A!\u00021\n\u0005\u0004\t'!\u0001+\u0012\u0005\t,\u0007CA d\u0013\t!\u0017FA\u0004O_RD\u0017N\\4\u0011\u0005}2\u0017BA4*\u0005\r\te.\u001f\u0005\u0006S&\u0001\rAW\u0001\u0003INDQa[\u0005A\u00021\fA!\u001a=qeB\u0011q$\\\u0005\u0003]R\u0011aaQ8mk6t\u0007\"\u00029\n\u0001\u0004\t\u0018!B3yaJ\u001c\bcA sY&\u00111/\u000b\u0002\u000byI,\u0007/Z1uK\u0012t\u0014\u0001\u0003:fO&\u001cH/\u001a:\u0015\u000753\b\u0010C\u0003x\u0015\u0001\u0007Q)\u0001\u0007ta\u0006\u00148nU3tg&|g\u000eC\u0003=\u0015\u0001\u0007\u0001*\u0001\u0006v]J,w-[:uKJ$\u0012!T\u0001\t_:4\u0015N\\5tQR\u0011Q* \u0005\u0006}2\u0001\ra`\u0001\u0003c\u0016\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000b!\u0012!C3yK\u000e,H/[8o\u0013\u0011\tI!a\u0001\u0003\u001dE+XM]=Fq\u0016\u001cW\u000f^5p]\u0006Q1/\u001e9fe\u0012r\u0017-\\3\u0016\u0003\r\n1b\u00142tKJ4\u0018\r^5p]B\u0011qdD\n\u0004\u001f\u0005U\u0001cA \u0002\u0018%\u0019\u0011\u0011D\u0015\u0003\r\u0005s\u0017PU3g)\t\t\t\"A\u0003baBd\u0017\u0010F\u00024\u0003CAQA\t\nA\u0002\r\u0002")
public class Observation
extends ObservationBase {
    private final ObservationListener listener = new ObservationListener(this);
    private volatile Option<Tuple2<SparkSession, Object>> dataframeId = None$.MODULE$;

    public static Observation apply(String name) {
        return Observation$.MODULE$.apply(name);
    }

    public static Observation apply() {
        return Observation$.MODULE$.apply();
    }

    private /* synthetic */ String super$name() {
        return super.name();
    }

    private ObservationListener listener() {
        return this.listener;
    }

    private Option<Tuple2<SparkSession, Object>> dataframeId() {
        return this.dataframeId;
    }

    private void dataframeId_$eq(Option<Tuple2<SparkSession, Object>> x$1) {
        this.dataframeId = x$1;
    }

    public <T> Dataset<T> on(Dataset<T> ds, Column expr, Seq<Column> exprs) {
        if (ds.isStreaming()) {
            throw new IllegalArgumentException("Observation does not support streaming Datasets.This is because there will be multiple observed metrics as microbatches are constructed. Please register a StreamingQueryListener and get the metric for each microbatch in QueryProgressEvent.progress, or use query.lastProgress or query.recentProgress.");
        }
        this.register(ds.sparkSession(), ds.id());
        return ds.observe(super.name(), expr, exprs);
    }

    public void register(SparkSession sparkSession, long dataframeId) {
        Observation observation = this;
        synchronized (observation) {
            if (this.dataframeId().isDefined()) {
                throw new IllegalArgumentException("An Observation can be used with a Dataset only once");
            }
            this.dataframeId_$eq((Option<Tuple2<SparkSession, Object>>)new Some((Object)new Tuple2((Object)sparkSession, (Object)BoxesRunTime.boxToLong((long)dataframeId))));
        }
        sparkSession.listenerManager().register(this.listener());
    }

    private void unregister() {
        this.dataframeId().foreach((Function1 & Serializable)x$1 -> {
            Observation.$anonfun$unregister$1(this, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void onFinish(QueryExecution qe) {
        if (this.metrics().isEmpty() && qe.logical().exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Observation.$anonfun$onFinish$1(this, x0$1)))) {
            Option row = qe.observedMetrics().get((Object)super.name());
            Option metrics = row.map((Function1 & Serializable)r -> r.getValuesMap((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)r.schema().fieldNames()).toImmutableArraySeq()));
            if (this.setMetricsAndNotify(metrics)) {
                this.unregister();
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$unregister$1(Observation $this, Tuple2 x$1) {
        ((SparkSession)x$1._1()).listenerManager().unregister($this.listener());
    }

    public static final /* synthetic */ boolean $anonfun$onFinish$1(Observation $this, LogicalPlan x0$1) {
        LogicalPlan logicalPlan2 = x0$1;
        if (logicalPlan2 instanceof CollectMetrics) {
            CollectMetrics collectMetrics = (CollectMetrics)logicalPlan2;
            String name = collectMetrics.name();
            long dataframeId = collectMetrics.dataframeId();
            String string = name;
            String string2 = $this.super$name();
            return !(string != null ? !string.equals(string2) : string2 != null) && dataframeId == ((Tuple2)$this.dataframeId().get())._2$mcJ$sp();
        }
        return false;
    }

    public Observation(String name) {
        super(name);
    }

    public Observation() {
        this(UUID.randomUUID().toString());
    }
}

