/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.RelationalGroupedDataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAlias;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.util.ArrayImplicits$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class RelationalGroupedDataset$ {
    public static final RelationalGroupedDataset$ MODULE$ = new RelationalGroupedDataset$();

    public RelationalGroupedDataset apply(Dataset<Row> df, Seq<Expression> groupingExprs, RelationalGroupedDataset.GroupType groupType) {
        return new RelationalGroupedDataset(df, groupingExprs, groupType);
    }

    public Tuple2<QueryExecution, Seq<Attribute>> handleGroupingExpression(LogicalPlan logicalPlan2, SparkSession sparkSession, Seq<Expression> groupingExprs) {
        Project dummyPlan = new Project((Seq)groupingExprs.map((Function1 & Serializable)expr -> MODULE$.org$apache$spark$sql$RelationalGroupedDataset$$alias((Expression)expr)), (LogicalPlan)new LocalRelation(logicalPlan2.output(), LocalRelation$.MODULE$.apply$default$2(), LocalRelation$.MODULE$.apply$default$3()));
        Project analyzedPlan = (Project)sparkSession.sessionState().analyzer().execute((LogicalPlan)dummyPlan);
        sparkSession.sessionState().analyzer().checkAnalysis((LogicalPlan)analyzedPlan);
        Seq aliasedGroupings = analyzedPlan.projectList();
        Seq addedCols = (Seq)aliasedGroupings.filter((Function1 & Serializable)g -> BoxesRunTime.boxToBoolean((boolean)RelationalGroupedDataset$.$anonfun$handleGroupingExpression$2(logicalPlan2, g)));
        Project newPlan = new Project((Seq)logicalPlan2.output().$plus$plus((IterableOnce)addedCols), logicalPlan2);
        QueryExecution qe = sparkSession.sessionState().executePlan((LogicalPlan)newPlan, sparkSession.sessionState().executePlan$default$2());
        return new Tuple2((Object)qe, aliasedGroupings.map((Function1 & Serializable)x$11 -> x$11.toAttribute()));
    }

    public NamedExpression org$apache$spark$sql$RelationalGroupedDataset$$alias(Expression expr) {
        Expression expression = expr;
        if (expression instanceof NamedExpression) {
            NamedExpression namedExpression = (NamedExpression)expression;
            return namedExpression;
        }
        if (expression instanceof AggregateExpression) {
            AggregateExpression aggregateExpression = (AggregateExpression)expression;
            return new UnresolvedAlias((Expression)aggregateExpression, (Option)new Some((Function1 & Serializable)e -> Column$.MODULE$.generateAlias((Expression)e)));
        }
        if (!expr.resolved()) {
            return new UnresolvedAlias(expr, (Option)None$.MODULE$);
        }
        if (expression != null) {
            Expression expression2;
            Expression x$1 = expression2 = expression;
            String x$2 = package$.MODULE$.toPrettySQL(expression2);
            ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
            Seq x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
            Option x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
            Seq x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
            return new Alias(x$1, x$2, x$3, x$4, x$5, x$6);
        }
        throw new MatchError((Object)expression);
    }

    public Seq<Object> collectPivotValues(Dataset<Row> df, Column pivotColumn) {
        if (df.isStreaming()) {
            throw new AnalysisException("_LEGACY_ERROR_TEMP_3063", Predef$.MODULE$.Map().empty());
        }
        int maxValues = df.sparkSession().sessionState().conf().dataFramePivotMaxValues();
        ArraySeq values = ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])df.select((Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{pivotColumn})).distinct().limit(maxValues + 1).sort((Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{pivotColumn})).collect()), (Function1 & Serializable)x$12 -> x$12.get(0), ClassTag$.MODULE$.Any())).toImmutableArraySeq();
        if (values.length() > maxValues) {
            throw QueryCompilationErrors$.MODULE$.aggregationFunctionAppliedOnNonNumericColumnError(pivotColumn.toString(), maxValues);
        }
        return values;
    }

    public static final /* synthetic */ boolean $anonfun$handleGroupingExpression$2(LogicalPlan logicalPlan$1, NamedExpression g) {
        return !logicalPlan$1.outputSet().contains((NamedExpression)g.toAttribute());
    }

    private RelationalGroupedDataset$() {
    }
}

