/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.HashMap;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.optimizer.EliminateResolvedHint$;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.HintInfo;
import org.apache.spark.sql.catalyst.plans.logical.IgnoreCachedData;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ResolvedHint;
import org.apache.spark.sql.catalyst.plans.logical.View;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.execution.CacheManager$;
import org.apache.spark.sql.execution.CachedData;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.QueryExecution$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanHelper;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.columnar.InMemoryRelation$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.FileTable;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t=g\u0001\u0002\u0013&\u0001ABQa\u0011\u0001\u0005\u0002\u0011Cqa\u0012\u0001A\u0002\u0013%\u0001\nC\u0004U\u0001\u0001\u0007I\u0011B+\t\rm\u0003\u0001\u0015)\u0003J\u0011\u0015!\u0007\u0001\"\u0001f\u0011\u00151\u0007\u0001\"\u0001h\u0011\u0015Y\u0007\u0001\"\u0001m\u0011\u0015Y\u0007\u0001\"\u0001\u0000\u0011\u0019Y\u0007\u0001\"\u0001\u0002>!9\u00111\r\u0001\u0005\n\u0005\u0015\u0004bBA8\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0003_\u0002A\u0011AAD\u0011\u001d\ty\u0007\u0001C\u0001\u0003/Cq!a\u001c\u0001\t\u0003\t\u0019\u000bC\u0004\u0002,\u0002!I!!,\t\u000f\u0005]\u0006\u0001\"\u0001\u0002:\"9\u0011Q\u001b\u0001\u0005\n\u0005]\u0007bBAv\u0001\u0011%\u0011Q\u001e\u0005\t\u0003\u007f\u0004A\u0011A\u0014\u0003\u0002!9!1\u0004\u0001\u0005\u0002\tu\u0001b\u0002B\u0012\u0001\u0011%!Q\u0005\u0005\b\u0005_\u0001A\u0011\u0001B\u0019\u0011\u001d\u0011y\u0003\u0001C\u0001\u0005\u0003BqA!\u0013\u0001\t\u0013\u0011Y\u0005\u0003\u0005\u0003P\u0001!\ta\nB)\u0011\u001d\u0011)\u0006\u0001C\u0001\u0005/BqA!\u0016\u0001\t\u0003\u0011y\u0006C\u0004\u0003~\u0001!IAa \t\u000f\t%\u0005\u0001\"\u0003\u0003\f\"9!\u0011\u0015\u0001\u0005\u0002\t\r\u0006b\u0002BW\u0001\u0011%!qV\u0004\b\u0005g+\u0003\u0012\u0001B[\r\u0019!S\u0005#\u0001\u00038\"11)\tC\u0001\u0005sCqAa/\"\t\u0003\u0011iL\u0001\u0007DC\u000eDW-T1oC\u001e,'O\u0003\u0002'O\u0005IQ\r_3dkRLwN\u001c\u0006\u0003Q%\n1a]9m\u0015\tQ3&A\u0003ta\u0006\u00148N\u0003\u0002-[\u00051\u0011\r]1dQ\u0016T\u0011AL\u0001\u0004_J<7\u0001A\n\u0005\u0001E:T\b\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0004B]f\u0014VM\u001a\t\u0003qmj\u0011!\u000f\u0006\u0003u%\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003ye\u0012q\u0001T8hO&tw\r\u0005\u0002?\u00036\tqH\u0003\u0002AK\u0005A\u0011\rZ1qi&4X-\u0003\u0002C\u007f\t9\u0012\tZ1qi&4Xm\u00159be.\u0004F.\u00198IK2\u0004XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\u0003\"A\u0012\u0001\u000e\u0003\u0015\n!bY1dQ\u0016$G)\u0019;b+\u0005I\u0005c\u0001&P#6\t1J\u0003\u0002M\u001b\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003\u001dN\n!bY8mY\u0016\u001cG/[8o\u0013\t\u00016J\u0001\u0006J]\u0012,\u00070\u001a3TKF\u0004\"A\u0012*\n\u0005M+#AC\"bG\",G\rR1uC\u0006q1-Y2iK\u0012$\u0015\r^1`I\u0015\fHC\u0001,Z!\t\u0011t+\u0003\u0002Yg\t!QK\\5u\u0011\u001dQ6!!AA\u0002%\u000b1\u0001\u001f\u00132\u0003-\u0019\u0017m\u00195fI\u0012\u000bG/\u0019\u0011)\u0005\u0011i\u0006C\u0001\u001a_\u0013\ty6GA\u0005ue\u0006t7/[3oi\"\u0012A!\u0019\t\u0003e\tL!aY\u001a\u0003\u0011Y|G.\u0019;jY\u0016\f!b\u00197fCJ\u001c\u0015m\u00195f)\u00051\u0016aB5t\u000b6\u0004H/_\u000b\u0002QB\u0011!'[\u0005\u0003UN\u0012qAQ8pY\u0016\fg.\u0001\u0006dC\u000eDW-U;fef$\"AV7\t\u000b9<\u0001\u0019A8\u0002\u000bE,XM]=1\u0005A4\bcA9si6\tq%\u0003\u0002tO\t9A)\u0019;bg\u0016$\bCA;w\u0019\u0001!\u0011b^7\u0002\u0002\u0003\u0005)\u0011\u0001=\u0003\u0007}#\u0013'\u0005\u0002zyB\u0011!G_\u0005\u0003wN\u0012qAT8uQ&tw\r\u0005\u00023{&\u0011ap\r\u0002\u0004\u0003:LHc\u0002,\u0002\u0002\u00055\u0011Q\u0006\u0005\u0007]\"\u0001\r!a\u00011\t\u0005\u0015\u0011\u0011\u0002\t\u0005cJ\f9\u0001E\u0002v\u0003\u0013!1\"a\u0003\u0002\u0002\u0005\u0005\t\u0011!B\u0001q\n\u0019q\f\n\u001a\t\u000f\u0005=\u0001\u00021\u0001\u0002\u0012\u0005IA/\u00192mK:\u000bW.\u001a\t\u0006e\u0005M\u0011qC\u0005\u0004\u0003+\u0019$AB(qi&|g\u000e\u0005\u0003\u0002\u001a\u0005\u001db\u0002BA\u000e\u0003G\u00012!!\b4\u001b\t\tyBC\u0002\u0002\"=\na\u0001\u0010:p_Rt\u0014bAA\u0013g\u00051\u0001K]3eK\u001aLA!!\u000b\u0002,\t11\u000b\u001e:j]\u001eT1!!\n4\u0011\u001d\ty\u0003\u0003a\u0001\u0003c\tAb\u001d;pe\u0006<W\rT3wK2\u0004B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003oI\u0013aB:u_J\fw-Z\u0005\u0005\u0003w\t)D\u0001\u0007Ti>\u0014\u0018mZ3MKZ,G\u000eF\u0005W\u0003\u007f\t9%a\u0018\u0002b!1!&\u0003a\u0001\u0003\u0003\u00022!]A\"\u0013\r\t)e\n\u0002\r'B\f'o[*fgNLwN\u001c\u0005\b\u0003\u0013J\u0001\u0019AA&\u0003-\u0001H.\u00198U_\u000e\u000b7\r[3\u0011\t\u00055\u00131L\u0007\u0003\u0003\u001fRA!!\u0015\u0002T\u00059An\\4jG\u0006d'\u0002BA+\u0003/\nQ\u0001\u001d7b]NT1!!\u0017(\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA/\u0003\u001f\u00121\u0002T8hS\u000e\fG\u000e\u00157b]\"9\u0011qB\u0005A\u0002\u0005E\u0001bBA\u0018\u0013\u0001\u0007\u0011\u0011G\u0001\u0013G\u0006\u001c\u0007.Z)vKJL\u0018J\u001c;fe:\fG\u000eF\u0005W\u0003O\nI'a\u001b\u0002n!1!F\u0003a\u0001\u0003\u0003Bq!!\u0013\u000b\u0001\u0004\tY\u0005C\u0004\u0002\u0010)\u0001\r!!\u0005\t\u000f\u0005=\"\u00021\u0001\u00022\u0005aQO\\2bG\",\u0017+^3ssR9a+a\u001d\u0002\u0000\u0005\r\u0005B\u00028\f\u0001\u0004\t)\b\r\u0003\u0002x\u0005m\u0004\u0003B9s\u0003s\u00022!^A>\t-\ti(a\u001d\u0002\u0002\u0003\u0005)\u0011\u0001=\u0003\u0007}#3\u0007\u0003\u0004\u0002\u0002.\u0001\r\u0001[\u0001\bG\u0006\u001c8-\u00193f\u0011\u0019\t)i\u0003a\u0001Q\u0006A!\r\\8dW&tw\rF\u0003W\u0003\u0013\u000b)\n\u0003\u0004o\u0019\u0001\u0007\u00111\u0012\u0019\u0005\u0003\u001b\u000b\t\n\u0005\u0003re\u0006=\u0005cA;\u0002\u0012\u0012Y\u00111SAE\u0003\u0003\u0005\tQ!\u0001y\u0005\ryF\u0005\u000e\u0005\u0007\u0003\u0003c\u0001\u0019\u00015\u0015\u0013Y\u000bI*a'\u0002 \u0006\u0005\u0006B\u0002\u0016\u000e\u0001\u0004\t\t\u0005C\u0004\u0002\u001e6\u0001\r!a\u0013\u0002\tAd\u0017M\u001c\u0005\u0007\u0003\u0003k\u0001\u0019\u00015\t\r\u0005\u0015U\u00021\u0001i)\u001d1\u0016QUAT\u0003SCaA\u000b\bA\u0002\u0005\u0005\u0003bBAO\u001d\u0001\u0007\u00111\n\u0005\u0007\u0003\u0003s\u0001\u0019\u00015\u0002)Ut7-Y2iKF+XM]=J]R,'O\\1m)%1\u0016qVAY\u0003g\u000b)\f\u0003\u0004+\u001f\u0001\u0007\u0011\u0011\t\u0005\b\u0003;{\u0001\u0019AA&\u0011\u0019\t\ti\u0004a\u0001Q\"1\u0011QQ\bA\u0002!\f!#\u001e8dC\u000eDW\rV1cY\u0016|%OV5foR9a+a/\u0002>\u0006M\u0007B\u0002\u0016\u0011\u0001\u0004\t\t\u0005C\u0004\u0002@B\u0001\r!!1\u0002\t9\fW.\u001a\t\u0007\u0003\u0007\fi-a\u0006\u000f\t\u0005\u0015\u0017\u0011\u001a\b\u0005\u0003;\t9-C\u00015\u0013\r\tYmM\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty-!5\u0003\u0007M+\u0017OC\u0002\u0002LNBa!!!\u0011\u0001\u0004A\u0017\u0001F5t\u001b\u0006$8\r[3e)\u0006\u0014G.Z(s-&,w\u000fF\u0004i\u00033\fY.!8\t\u000f\u0005u\u0015\u00031\u0001\u0002L!9\u0011qX\tA\u0002\u0005\u0005\u0007bBAp#\u0001\u0007\u0011\u0011]\u0001\u0005G>tg\r\u0005\u0003\u0002d\u0006\u001dXBAAs\u0015\tQt%\u0003\u0003\u0002j\u0006\u0015(aB*R\u0019\u000e{gNZ\u0001\u0013k:\u001c\u0017m\u00195f\u0005f\u001cuN\u001c3ji&|g\u000eF\u0005W\u0003_\f\t0a?\u0002~\"1!F\u0005a\u0001\u0003\u0003Bq!a=\u0013\u0001\u0004\t)0A\u0007jg6\u000bGo\u00195fIBc\u0017M\u001c\t\u0007e\u0005]\u00181\n5\n\u0007\u0005e8GA\u0005Gk:\u001cG/[8oc!1\u0011\u0011\u0011\nA\u0002!Da!!\"\u0013\u0001\u0004A\u0017aF1oC2L(0Z\"pYVlgnQ1dQ\u0016\fV/\u001a:z)\u001d1&1\u0001B\u0004\u0005\u0013AqA!\u0002\u0014\u0001\u0004\t\t%\u0001\u0007ta\u0006\u00148nU3tg&|g\u000eC\u0003H'\u0001\u0007\u0011\u000bC\u0004\u0003\fM\u0001\rA!\u0004\u0002\r\r|G.^7o!\u0019\t\u0019-!4\u0003\u0010A!!\u0011\u0003B\f\u001b\t\u0011\u0019B\u0003\u0003\u0003\u0016\u0005]\u0013aC3yaJ,7o]5p]NLAA!\u0007\u0003\u0014\tI\u0011\t\u001e;sS\n,H/Z\u0001\u000ee\u0016\u001c\u0017m\u00195f\u0005f\u0004F.\u00198\u0015\u000bY\u0013yB!\t\t\r)\"\u0002\u0019AA!\u0011\u001d\ti\n\u0006a\u0001\u0003\u0017\n!C]3dC\u000eDWMQ=D_:$\u0017\u000e^5p]R)aKa\n\u0003*!1!&\u0006a\u0001\u0003\u0003BqAa\u000b\u0016\u0001\u0004\u0011i#A\u0005d_:$\u0017\u000e^5p]B)!'a>RQ\u0006\u0001Bn\\8lkB\u001c\u0015m\u00195fI\u0012\u000bG/\u0019\u000b\u0005\u0005g\u0011)\u0004\u0005\u00033\u0003'\t\u0006B\u00028\u0017\u0001\u0004\u00119\u0004\r\u0003\u0003:\tu\u0002\u0003B9s\u0005w\u00012!\u001eB\u001f\t-\u0011yD!\u000e\u0002\u0002\u0003\u0005)\u0011\u0001=\u0003\u0007}#S\u0007\u0006\u0004\u00034\t\r#q\t\u0005\b\u0005\u000b:\u0002\u0019AA!\u0003\u001d\u0019Xm]:j_:Dq!!(\u0018\u0001\u0004\tY%\u0001\rm_>\\W\u000f]\"bG\",G\rR1uC&sG/\u001a:oC2$BAa\r\u0003N!9\u0011Q\u0014\rA\u0002\u0005-\u0013!D;tK\u000e\u000b7\r[3e\t\u0006$\u0018\r\u0006\u0003\u0002L\tM\u0003bBAO3\u0001\u0007\u00111J\u0001\u000ee\u0016\u001c\u0017m\u00195f\u0005f\u0004\u0016\r\u001e5\u0015\u000bY\u0013IFa\u0017\t\r)R\u0002\u0019AA!\u0011\u001d\u0011iF\u0007a\u0001\u0003/\tAB]3t_V\u00148-\u001a)bi\"$rA\u0016B1\u0005G\u0012)\b\u0003\u0004+7\u0001\u0007\u0011\u0011\t\u0005\b\u0005;Z\u0002\u0019\u0001B3!\u0011\u00119G!\u001d\u000e\u0005\t%$\u0002\u0002B6\u0005[\n!AZ:\u000b\u0007\t=4&\u0001\u0004iC\u0012|w\u000e]\u0005\u0005\u0005g\u0012IG\u0001\u0003QCRD\u0007b\u0002B67\u0001\u0007!q\u000f\t\u0005\u0005O\u0012I(\u0003\u0003\u0003|\t%$A\u0003$jY\u0016\u001c\u0016p\u001d;f[\u0006\u0001Bn\\8lkB\fe\u000e\u001a*fMJ,7\u000f\u001b\u000b\bQ\n\u0005%1\u0011BC\u0011\u001d\ti\n\ba\u0001\u0003\u0017BqAa\u001b\u001d\u0001\u0004\u00119\bC\u0004\u0003\br\u0001\rA!\u001a\u0002\u001bE,\u0018\r\\5gS\u0016$\u0007+\u0019;i\u0003m\u0011XM\u001a:fg\"4\u0015\u000e\\3J]\u0012,\u00070\u00134OK\u000e,7o]1ssR9\u0001N!$\u0003\u001e\n}\u0005b\u0002BH;\u0001\u0007!\u0011S\u0001\nM&dW-\u00138eKb\u0004BAa%\u0003\u001a6\u0011!Q\u0013\u0006\u0004\u0005/+\u0013a\u00033bi\u0006\u001cx.\u001e:dKNLAAa'\u0003\u0016\nIa)\u001b7f\u0013:$W\r\u001f\u0005\b\u0005Wj\u0002\u0019\u0001B<\u0011\u001d\u00119)\ba\u0001\u0005K\n\u0001\"[:Tk\n$\u0015N\u001d\u000b\u0006Q\n\u0015&\u0011\u0016\u0005\b\u0005Os\u0002\u0019\u0001B3\u0003M\tX/\u00197jM&,G\rU1uQB\u000b'/\u001a8u\u0011\u001d\u0011YK\ba\u0001\u0005K\n!#];bY&4\u0017.\u001a3QCRD7\t[5mI\u0006yr-\u001a;Pe\u000ecwN\\3TKN\u001c\u0018n\u001c8XSRD7i\u001c8gS\u001e\u001cxJ\u001a4\u0015\t\u0005\u0005#\u0011\u0017\u0005\b\u0005\u000bz\u0002\u0019AA!\u00031\u0019\u0015m\u00195f\u001b\u0006t\u0017mZ3s!\t1\u0015eE\u0002\"c]\"\"A!.\u0002#1|wmQ1dQ\u0016|\u0005/\u001a:bi&|g\u000eF\u0002W\u0005\u007fC\u0001B!1$\t\u0003\u0007!1Y\u0001\u0002MB)!G!2\u0003J&\u0019!qY\u001a\u0003\u0011q\u0012\u0017P\\1nKz\u00022\u0001\u000fBf\u0013\r\u0011i-\u000f\u0002\t\u0019><WI\u001c;ss\u0002")
public class CacheManager
implements Logging,
AdaptiveSparkPlanHelper {
    private volatile transient IndexedSeq<CachedData> cachedData;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void logCacheOperation(Function0<LogEntry> f) {
        CacheManager$.MODULE$.logCacheOperation(f);
    }

    @Override
    public Option<SparkPlan> find(SparkPlan p, Function1<SparkPlan, Object> f) {
        return AdaptiveSparkPlanHelper.find$(this, p, f);
    }

    @Override
    public void foreach(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreach$(this, p, f);
    }

    @Override
    public void foreachUp(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreachUp$(this, p, f);
    }

    @Override
    public <A> Seq<A> mapPlans(SparkPlan p, Function1<SparkPlan, A> f) {
        return AdaptiveSparkPlanHelper.mapPlans$(this, p, f);
    }

    @Override
    public <A> Seq<A> flatMap(SparkPlan p, Function1<SparkPlan, IterableOnce<A>> f) {
        return AdaptiveSparkPlanHelper.flatMap$(this, p, f);
    }

    @Override
    public <B> Seq<B> collect(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collect$(this, p, pf);
    }

    @Override
    public Seq<SparkPlan> collectLeaves(SparkPlan p) {
        return AdaptiveSparkPlanHelper.collectLeaves$(this, p);
    }

    @Override
    public <B> Option<B> collectFirst(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collectFirst$(this, p, pf);
    }

    @Override
    public <B> Seq<B> collectWithSubqueries(SparkPlan p, PartialFunction<SparkPlan, B> f) {
        return AdaptiveSparkPlanHelper.collectWithSubqueries$(this, p, f);
    }

    @Override
    public Seq<SparkPlan> subqueriesAll(SparkPlan p) {
        return AdaptiveSparkPlanHelper.subqueriesAll$(this, p);
    }

    @Override
    public Seq<SparkPlan> allChildren(SparkPlan p) {
        return AdaptiveSparkPlanHelper.allChildren$(this, p);
    }

    @Override
    public SparkPlan stripAQEPlan(SparkPlan p) {
        return AdaptiveSparkPlanHelper.stripAQEPlan$(this, p);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private IndexedSeq<CachedData> cachedData() {
        return this.cachedData;
    }

    private void cachedData_$eq(IndexedSeq<CachedData> x$1) {
        this.cachedData = x$1;
    }

    public synchronized void clearCache() {
        this.cachedData().foreach((Function1 & Serializable)x$1 -> {
            CacheManager.$anonfun$clearCache$1(x$1);
            return BoxedUnit.UNIT;
        });
        this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)Nil$.MODULE$)));
        CacheManager$.MODULE$.logCacheOperation((Function0<LogEntry>)(Function0 & Serializable)() -> LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Cleared all Dataframe cache entries"}))).log((Seq)Nil$.MODULE$)));
    }

    public boolean isEmpty() {
        return this.cachedData().isEmpty();
    }

    public void cacheQuery(Dataset<?> query) {
        this.cacheQuery(query, (Option<String>)None$.MODULE$, StorageLevel$.MODULE$.MEMORY_AND_DISK());
    }

    public void cacheQuery(Dataset<?> query, Option<String> tableName, StorageLevel storageLevel) {
        this.cacheQueryInternal(query.sparkSession(), query.queryExecution().normalized(), tableName, storageLevel);
    }

    public void cacheQuery(SparkSession spark, LogicalPlan planToCache, Option<String> tableName, StorageLevel storageLevel) {
        LogicalPlan normalized = QueryExecution$.MODULE$.normalize(spark, planToCache, QueryExecution$.MODULE$.normalize$default$3());
        this.cacheQueryInternal(spark, normalized, tableName, storageLevel);
    }

    private void cacheQueryInternal(SparkSession spark, LogicalPlan planToCache, Option<String> tableName, StorageLevel storageLevel) {
        StorageLevel storageLevel2 = storageLevel;
        StorageLevel storageLevel3 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel2 != null ? !storageLevel2.equals(storageLevel3) : storageLevel3 != null)) {
            return;
        }
        if (this.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(planToCache).nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Asked to cache already cached data.");
            return;
        }
        SparkSession sessionWithConfigsOff = this.getOrCloneSessionWithConfigsOff(spark);
        InMemoryRelation inMemoryRelation = (InMemoryRelation)sessionWithConfigsOff.withActive((Function0 & Serializable)() -> {
            QueryExecution qe = sessionWithConfigsOff.sessionState().executePlan(planToCache, sessionWithConfigsOff.sessionState().executePlan$default$2());
            return InMemoryRelation$.MODULE$.apply(storageLevel, qe, tableName);
        });
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            if (this.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(planToCache).nonEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Data has already been cached.");
            } else {
                CachedData cd;
                CachedData cachedData = cd = new CachedData(planToCache, inMemoryRelation);
                this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().$plus$colon((Object)cachedData)));
                CacheManager$.MODULE$.logCacheOperation((Function0<LogEntry>)(Function0 & Serializable)() -> LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Added Dataframe cache entry:"}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DATAFRAME_CACHE_ENTRY$.MODULE$, (Object)cd)})))));
            }
        }
    }

    public void uncacheQuery(Dataset<?> query, boolean cascade, boolean blocking) {
        this.uncacheQueryInternal(query.sparkSession(), query.queryExecution().normalized(), cascade, blocking);
    }

    public void uncacheQuery(Dataset<?> query, boolean cascade) {
        this.uncacheQuery(query, cascade, false);
    }

    public void uncacheQuery(SparkSession spark, LogicalPlan plan, boolean cascade, boolean blocking) {
        LogicalPlan normalized = QueryExecution$.MODULE$.normalize(spark, plan, QueryExecution$.MODULE$.normalize$default$3());
        this.uncacheQueryInternal(spark, normalized, cascade, blocking);
    }

    public void uncacheQuery(SparkSession spark, LogicalPlan plan, boolean cascade) {
        this.uncacheQuery(spark, plan, cascade, false);
    }

    private void uncacheQueryInternal(SparkSession spark, LogicalPlan plan, boolean cascade, boolean blocking) {
        this.uncacheByCondition(spark, (Function1<LogicalPlan, Object>)(Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.sameResult((QueryPlan)plan)), cascade, blocking);
    }

    public void uncacheTableOrView(SparkSession spark, Seq<String> name, boolean cascade) {
        this.uncacheByCondition(spark, (Function1<LogicalPlan, Object>)(Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)this.isMatchedTableOrView(x$3, (Seq<String>)name, spark.sessionState().conf())), cascade, false);
    }

    private boolean isMatchedTableOrView(LogicalPlan plan, Seq<String> name, SQLConf conf) {
        LogicalRelation logicalRelation;
        Option<CatalogTable> option;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof LogicalRelation && (option = (logicalRelation = (LogicalRelation)logicalPlan2).catalogTable()) instanceof Some) {
            Some some = (Some)option;
            CatalogTable catalogTable = (CatalogTable)some.value();
            return CacheManager.isSameName$1(catalogTable.identifier().nameParts(), name, conf);
        }
        if (logicalPlan2 instanceof DataSourceV2Relation) {
            DataSourceV2Relation dataSourceV2Relation = (DataSourceV2Relation)logicalPlan2;
            Option option2 = dataSourceV2Relation.catalog();
            Option option3 = dataSourceV2Relation.identifier();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                CatalogPlugin catalog = (CatalogPlugin)some.value();
                if (option3 instanceof Some) {
                    Some some2 = (Some)option3;
                    Identifier v2Ident = (Identifier)some2.value();
                    return CacheManager.isSameName$1(CatalogV2Implicits$.MODULE$.IdentifierHelper(v2Ident).toQualifiedNameParts(catalog), name, conf);
                }
            }
        }
        if (logicalPlan2 instanceof View) {
            View view = (View)logicalPlan2;
            CatalogTable catalogTable = view.desc();
            return CacheManager.isSameName$1(catalogTable.identifier().nameParts(), name, conf);
        }
        if (logicalPlan2 instanceof HiveTableRelation) {
            HiveTableRelation hiveTableRelation = (HiveTableRelation)logicalPlan2;
            CatalogTable catalogTable = hiveTableRelation.tableMeta();
            return CacheManager.isSameName$1(catalogTable.identifier().nameParts(), name, conf);
        }
        return false;
    }

    private void uncacheByCondition(SparkSession spark, Function1<LogicalPlan, Object> isMatchedPlan, boolean cascade, boolean blocking) {
        Function1 & Serializable shouldRemove = cascade ? (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.exists(isMatchedPlan)) : isMatchedPlan;
        IndexedSeq plansToUncache = (IndexedSeq)this.cachedData().filter((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheByCondition$2(shouldRemove, cd)));
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().filterNot((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plansToUncache.exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheByCondition$4(cd, x$5)))))));
        }
        plansToUncache.foreach((Function1 & Serializable)x$6 -> {
            CacheManager.$anonfun$uncacheByCondition$5(blocking, x$6);
            return BoxedUnit.UNIT;
        });
        CacheManager$.MODULE$.logCacheOperation((Function0<LogEntry>)(Function0 & Serializable)() -> LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Removed ", " Dataframe "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SIZE$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)plansToUncache.size()))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"cache entries, with logical plans being "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\\n[", "]"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.QUERY_PLAN$.MODULE$, (Object)((IterableOnceOps)plansToUncache.map((Function1 & Serializable)x$7 -> x$7.plan())).mkString(",\n"))})))));
        if (!cascade) {
            this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheByCondition$9(isMatchedPlan, cd)));
            return;
        }
    }

    public void analyzeColumnCacheQuery(SparkSession sparkSession, CachedData cachedData, Seq<Attribute> column) {
        InMemoryRelation relation = cachedData.cachedRepresentation();
        Tuple2<Object, Map<Attribute, ColumnStat>> tuple2 = CommandUtils$.MODULE$.computeColumnStats(sparkSession, relation, column);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long rowCount = tuple2._1$mcJ$sp();
        Map newColStats = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)rowCount), (Object)newColStats);
        long rowCount2 = tuple22._1$mcJ$sp();
        Map newColStats2 = (Map)tuple22._2();
        relation.updateStats(rowCount2, (Map<Attribute, ColumnStat>)newColStats2);
    }

    public void recacheByPlan(SparkSession spark, LogicalPlan plan) {
        LogicalPlan normalized = QueryExecution$.MODULE$.normalize(spark, plan, QueryExecution$.MODULE$.normalize$default$3());
        this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPlan$1(normalized, x$9)));
    }

    private void recacheByCondition(SparkSession spark, Function1<CachedData, Object> condition) {
        IndexedSeq needToRecache = (IndexedSeq)this.cachedData().filter(condition);
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().filterNot((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)needToRecache.exists((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByCondition$2(cd, x$11)))))));
        }
        needToRecache.foreach((Function1 & Serializable)cd -> {
            CacheManager.$anonfun$recacheByCondition$3(this, spark, cd);
            return BoxedUnit.UNIT;
        });
    }

    public Option<CachedData> lookupCachedData(Dataset<?> query) {
        return this.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(query.queryExecution().normalized());
    }

    public Option<CachedData> lookupCachedData(SparkSession session, LogicalPlan plan) {
        LogicalPlan normalized = QueryExecution$.MODULE$.normalize(session, plan, QueryExecution$.MODULE$.normalize$default$3());
        return this.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(normalized);
    }

    public Option<CachedData> org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(LogicalPlan plan) {
        Option result;
        block0: {
            result = this.cachedData().find((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plan.sameResult((QueryPlan)cd.plan())));
            if (!result.isDefined()) break block0;
            CacheManager$.MODULE$.logCacheOperation((Function0<LogEntry>)(Function0 & Serializable)() -> LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Dataframe cache hit for input plan:"}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\\n", " matched with cache entry:"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.QUERY_PLAN$.MODULE$, (Object)plan)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DATAFRAME_CACHE_ENTRY$.MODULE$, result.get())})))));
        }
        return result;
    }

    public LogicalPlan useCachedData(LogicalPlan plan) {
        LogicalPlan newPlan = (LogicalPlan)plan.transformDown((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof IgnoreCachedData) {
                    IgnoreCachedData ignoreCachedData = (IgnoreCachedData)A1;
                    return (B1)ignoreCachedData;
                }
                return (B1)this.$outer.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(A1).map((Function1 & Serializable)cached -> {
                    Seq hints = (Seq)EliminateResolvedHint$.MODULE$.extractHintsFromPlan(A1)._2();
                    InMemoryRelation cachedPlan = cached.cachedRepresentation().withOutput((Seq<Attribute>)A1.output());
                    return (LogicalPlan)hints.foldRight((Object)cachedPlan, (Function2 & Serializable)(x0$1, x1$1) -> {
                        Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                        if (tuple2 != null) {
                            HintInfo hint = (HintInfo)tuple2._1();
                            LogicalPlan p = (LogicalPlan)tuple2._2();
                            return new ResolvedHint(p, hint);
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }).getOrElse((Function0 & Serializable)() -> A1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                if (logicalPlan2 instanceof IgnoreCachedData) {
                    return true;
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan org.apache.spark.sql.execution.CachedData ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.plans.logical.HintInfo org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$3(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan )}, serializedLambda);
            }
        });
        LogicalPlan result = newPlan.transformAllExpressionsWithPruning((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.containsPattern(TreePattern$.MODULE$.PLAN_EXPRESSION())), newPlan.transformAllExpressionsWithPruning$default$2(), (PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof SubqueryExpression) {
                    SubqueryExpression subqueryExpression = (SubqueryExpression)A1;
                    return (B1)subqueryExpression.withNewPlan(this.$outer.useCachedData((LogicalPlan)subqueryExpression.plan()));
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                return expression instanceof SubqueryExpression;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (result.fastEquals((TreeNode)plan)) {
            CacheManager$.MODULE$.logCacheOperation((Function0<LogEntry>)(Function0 & Serializable)() -> LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Dataframe cache miss for input plan:\\n", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.QUERY_PLAN$.MODULE$, (Object)plan)}))));
            CacheManager$.MODULE$.logCacheOperation((Function0<LogEntry>)(Function0 & Serializable)() -> LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Last 20 Dataframe cache entry logical plans:\\n"}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[", "]"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DATAFRAME_CACHE_ENTRY$.MODULE$, (Object)((IterableOnceOps)((IndexedSeqOps)this.cachedData().take(20)).map((Function1 & Serializable)x$13 -> x$13.plan())).mkString(",\n"))})))));
        } else {
            CacheManager$.MODULE$.logCacheOperation((Function0<LogEntry>)(Function0 & Serializable)() -> LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Dataframe cache hit plan change summary:\\n"}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.QUERY_PLAN_COMPARISON$.MODULE$, (Object)org.apache.spark.sql.catalyst.util.package$.MODULE$.sideBySide(plan.treeString(), result.treeString()).mkString("\n"))})))));
        }
        return result;
    }

    public void recacheByPath(SparkSession spark, String resourcePath) {
        Path path = new Path(resourcePath);
        FileSystem fs = path.getFileSystem(spark.sessionState().newHadoopConf());
        this.recacheByPath(spark, path, fs);
    }

    public void recacheByPath(SparkSession spark, Path resourcePath, FileSystem fs) {
        Path qualifiedPath = fs.makeQualified(resourcePath);
        this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPath$1(this, fs, qualifiedPath, x$14)));
    }

    private boolean lookupAndRefresh(LogicalPlan plan, FileSystem fs, Path qualifiedPath) {
        DataSourceV2Relation dataSourceV2Relation;
        Table fileTable;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof LogicalRelation) {
            LogicalRelation logicalRelation = (LogicalRelation)logicalPlan2;
            BaseRelation baseRelation = logicalRelation.relation();
            if (baseRelation instanceof HadoopFsRelation) {
                HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
                return this.refreshFileIndexIfNecessary(hadoopFsRelation.location(), fs, qualifiedPath);
            }
            return false;
        }
        if (logicalPlan2 instanceof DataSourceV2Relation && (fileTable = (dataSourceV2Relation = (DataSourceV2Relation)logicalPlan2).table()) instanceof FileTable) {
            FileTable fileTable2 = (FileTable)fileTable;
            return this.refreshFileIndexIfNecessary(fileTable2.fileIndex(), fs, qualifiedPath);
        }
        return false;
    }

    private boolean refreshFileIndexIfNecessary(FileIndex fileIndex, FileSystem fs, Path qualifiedPath) {
        boolean needToRefresh;
        block0: {
            needToRefresh = ((IterableOnceOps)fileIndex.rootPaths().map((Function1 & Serializable)x$16 -> x$16.makeQualified(fs.getUri(), fs.getWorkingDirectory()))).exists((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)this.isSubDir(qualifiedPath, x$17)));
            if (!needToRefresh) break block0;
            fileIndex.refresh();
        }
        return needToRefresh;
    }

    public boolean isSubDir(Path qualifiedPathParent, Path qualifiedPathChild) {
        return package$.MODULE$.Iterator().iterate((Object)qualifiedPathChild, (Function1 & Serializable)x$18 -> x$18.getParent()).takeWhile((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$isSubDir$2(x$19))).exists((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)x$20.equals((Object)qualifiedPathParent)));
    }

    private SparkSession getOrCloneSessionWithConfigsOff(SparkSession session) {
        .colon.colon disableConfigs;
        block0: {
            disableConfigs = new .colon.colon((Object)SQLConf$.MODULE$.AUTO_BUCKETED_SCAN_ENABLED(), (List)Nil$.MODULE$);
            if (BoxesRunTime.unboxToBoolean(session.conf().get(SQLConf$.MODULE$.CAN_CHANGE_CACHED_PLAN_OUTPUT_PARTITIONING()))) break block0;
            disableConfigs = (Seq)disableConfigs.$colon$plus((Object)SQLConf$.MODULE$.ADAPTIVE_EXECUTION_APPLY_FINAL_STAGE_SHUFFLE_OPTIMIZATIONS());
        }
        return SparkSession$.MODULE$.getOrCloneSessionWithConfigsOff(session, (Seq<ConfigEntry<Object>>)disableConfigs);
    }

    public static final /* synthetic */ void $anonfun$clearCache$1(CachedData x$1) {
        x$1.cachedRepresentation().cacheBuilder().clearCache(x$1.cachedRepresentation().cacheBuilder().clearCache$default$1());
    }

    private static final boolean isSameName$1(Seq nameInCache, Seq name$2, SQLConf conf$1) {
        return nameInCache.length() == name$2.length() && ((IterableOnceOps)nameInCache.zip((IterableOnce)name$2)).forall(conf$1.resolver().tupled());
    }

    public static final /* synthetic */ boolean $anonfun$uncacheByCondition$2(Function1 shouldRemove$1, CachedData cd) {
        return BoxesRunTime.unboxToBoolean((Object)shouldRemove$1.apply((Object)cd.plan()));
    }

    public static final /* synthetic */ boolean $anonfun$uncacheByCondition$4(CachedData cd$2, CachedData x$5) {
        return x$5 == cd$2;
    }

    public static final /* synthetic */ void $anonfun$uncacheByCondition$5(boolean blocking$1, CachedData x$6) {
        x$6.cachedRepresentation().cacheBuilder().clearCache(blocking$1);
    }

    public static final /* synthetic */ boolean $anonfun$uncacheByCondition$9(Function1 isMatchedPlan$1, CachedData cd) {
        boolean cacheAlreadyLoaded = cd.cachedRepresentation().cacheBuilder().isCachedColumnBuffersLoaded();
        return cd.plan().exists(isMatchedPlan$1) && !cacheAlreadyLoaded;
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPlan$1(LogicalPlan normalized$1, CachedData x$9) {
        return x$9.plan().exists((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.sameResult((QueryPlan)normalized$1)));
    }

    public static final /* synthetic */ boolean $anonfun$recacheByCondition$2(CachedData cd$3, CachedData x$11) {
        return x$11 == cd$3;
    }

    public static final /* synthetic */ void $anonfun$recacheByCondition$3(CacheManager $this, SparkSession spark$2, CachedData cd) {
        InMemoryRelation newCache;
        cd.cachedRepresentation().cacheBuilder().clearCache(cd.cachedRepresentation().cacheBuilder().clearCache$default$1());
        SparkSession sessionWithConfigsOff = $this.getOrCloneSessionWithConfigsOff(spark$2);
        InMemoryRelation x$1 = newCache = (InMemoryRelation)sessionWithConfigsOff.withActive((Function0 & Serializable)() -> {
            QueryExecution qe = sessionWithConfigsOff.sessionState().executePlan(cd.plan(), sessionWithConfigsOff.sessionState().executePlan$default$2());
            return InMemoryRelation$.MODULE$.apply(cd.cachedRepresentation().cacheBuilder(), qe);
        });
        LogicalPlan x$2 = cd.copy$default$1();
        CachedData recomputedPlan = cd.copy(x$2, x$1);
        CacheManager cacheManager = $this;
        synchronized (cacheManager) {
            if ($this.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(recomputedPlan.plan()).nonEmpty()) {
                $this.logWarning((Function0<String>)(Function0 & Serializable)() -> "While recaching, data was already added to cache.");
            } else {
                CachedData cachedData = recomputedPlan;
                $this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)$this.cachedData().$plus$colon((Object)cachedData)));
                CacheManager$.MODULE$.logCacheOperation((Function0<LogEntry>)(Function0 & Serializable)() -> LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Re-cached Dataframe cache entry:"}))).log((Seq)Nil$.MODULE$).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DATAFRAME_CACHE_ENTRY$.MODULE$, (Object)recomputedPlan)})))));
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPath$1(CacheManager $this, FileSystem fs$1, Path qualifiedPath$1, CachedData x$14) {
        return x$14.plan().exists((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)$this.lookupAndRefresh(x$15, fs$1, qualifiedPath$1)));
    }

    public static final /* synthetic */ boolean $anonfun$isSubDir$2(Path x$19) {
        return x$19 != null;
    }

    public CacheManager() {
        Logging.$init$((Logging)this);
        AdaptiveSparkPlanHelper.$init$(this);
        this.cachedData = (IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)Nil$.MODULE$);
    }
}

