/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import org.apache.spark.sql.catalyst.types.PhysicalArrayType;
import org.apache.spark.sql.catalyst.types.PhysicalMapType;
import org.apache.spark.sql.catalyst.types.PhysicalStructType;
import org.apache.spark.sql.errors.ExecutionErrors$;
import org.apache.spark.sql.execution.columnar.ARRAY;
import org.apache.spark.sql.execution.columnar.BINARY$;
import org.apache.spark.sql.execution.columnar.BOOLEAN$;
import org.apache.spark.sql.execution.columnar.BYTE$;
import org.apache.spark.sql.execution.columnar.CALENDAR_INTERVAL$;
import org.apache.spark.sql.execution.columnar.COMPACT_DECIMAL$;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.DOUBLE$;
import org.apache.spark.sql.execution.columnar.FLOAT$;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.LARGE_DECIMAL$;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.MAP;
import org.apache.spark.sql.execution.columnar.NULL$;
import org.apache.spark.sql.execution.columnar.SHORT$;
import org.apache.spark.sql.execution.columnar.STRING$;
import org.apache.spark.sql.execution.columnar.STRUCT;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;

public final class ColumnType$ {
    public static final ColumnType$ MODULE$ = new ColumnType$();

    public ColumnType<?> apply(DataType dataType) {
        while (true) {
            boolean bl = false;
            DecimalType decimalType = null;
            DataType dataType2 = dataType;
            if (NullType$.MODULE$.equals(dataType2)) {
                return NULL$.MODULE$;
            }
            if (BooleanType$.MODULE$.equals(dataType2)) {
                return BOOLEAN$.MODULE$;
            }
            if (ByteType$.MODULE$.equals(dataType2)) {
                return BYTE$.MODULE$;
            }
            if (ShortType$.MODULE$.equals(dataType2)) {
                return SHORT$.MODULE$;
            }
            if (IntegerType$.MODULE$.equals(dataType2) ? true : (DateType$.MODULE$.equals(dataType2) ? true : dataType2 instanceof YearMonthIntervalType)) {
                return INT$.MODULE$;
            }
            if (LongType$.MODULE$.equals(dataType2) ? true : (TimestampType$.MODULE$.equals(dataType2) ? true : (TimestampNTZType$.MODULE$.equals(dataType2) ? true : dataType2 instanceof DayTimeIntervalType))) {
                return LONG$.MODULE$;
            }
            if (FloatType$.MODULE$.equals(dataType2)) {
                return FLOAT$.MODULE$;
            }
            if (DoubleType$.MODULE$.equals(dataType2)) {
                return DOUBLE$.MODULE$;
            }
            if (StringType$.MODULE$.equals(dataType2)) {
                return STRING$.MODULE$;
            }
            if (BinaryType$.MODULE$.equals(dataType2)) {
                return BINARY$.MODULE$;
            }
            if (dataType2 instanceof CalendarIntervalType) {
                return CALENDAR_INTERVAL$.MODULE$;
            }
            if (dataType2 instanceof DecimalType) {
                bl = true;
                decimalType = (DecimalType)dataType2;
                if (decimalType.precision() <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
                    return COMPACT_DECIMAL$.MODULE$.apply(decimalType);
                }
            }
            if (bl) {
                return LARGE_DECIMAL$.MODULE$.apply(decimalType);
            }
            if (dataType2 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType2;
                return new ARRAY(new PhysicalArrayType(arrayType.elementType(), arrayType.containsNull()));
            }
            if (dataType2 instanceof MapType) {
                MapType mapType = (MapType)dataType2;
                return new MAP(new PhysicalMapType(mapType.keyType(), mapType.valueType(), mapType.valueContainsNull()));
            }
            if (dataType2 instanceof StructType) {
                StructType structType = (StructType)dataType2;
                return new STRUCT(new PhysicalStructType(structType.fields()));
            }
            if (!(dataType2 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            dataType = userDefinedType.sqlType();
        }
        throw ExecutionErrors$.MODULE$.unsupportedDataTypeError(dataType);
    }

    private ColumnType$() {
    }
}

