/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.ScanFileListing;
import org.apache.spark.sql.execution.datasources.FilePartition;
import org.apache.spark.sql.execution.datasources.FileStatusWithMetadata;
import org.apache.spark.sql.execution.datasources.PartitionDirectory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.internal.SQLConf$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.math.BigDecimal;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class FilePartition$
implements Logging,
Serializable {
    public static final FilePartition$ MODULE$ = new FilePartition$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Seq<FilePartition> getFilePartitions(Seq<PartitionedFile> partitionedFiles, long maxSplitBytes, long openCostInBytes) {
        ArrayBuffer partitions = new ArrayBuffer();
        ArrayBuffer currentFiles = new ArrayBuffer();
        LongRef currentSize = LongRef.create((long)0L);
        partitionedFiles.foreach((Function1 & Serializable)file -> {
            if (currentSize$1.elem + file.length() > maxSplitBytes) {
                FilePartition$.closePartition$1(currentFiles, partitions, currentSize);
            }
            currentSize$1.elem += file.length() + openCostInBytes;
            return (ArrayBuffer)currentFiles.$plus$eq(file);
        });
        FilePartition$.closePartition$1(currentFiles, partitions, currentSize);
        return partitions.toSeq();
    }

    public Seq<FilePartition> getFilePartitions(SparkSession sparkSession, Seq<PartitionedFile> partitionedFiles, long maxSplitBytes) {
        Seq<FilePartition> partitions;
        long openCostBytes = sparkSession.sessionState().conf().filesOpenCostInBytes();
        Option maxPartNum = sparkSession.sessionState().conf().filesMaxPartitionNum();
        if (maxPartNum.exists((Function1)((JFunction1.mcZI.sp & Serializable)arg_0 -> FilePartition$.$anonfun$getFilePartitions$2(partitions = this.getFilePartitions(partitionedFiles, maxSplitBytes, openCostBytes), arg_0)))) {
            BigDecimal totalSizeInBytes = (BigDecimal)((IterableOnceOps)((IterableOps)partitionedFiles.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)FilePartition$.$anonfun$getFilePartitions$3(openCostBytes, x$3)))).map((Function1 & Serializable)x$4 -> FilePartition$.$anonfun$getFilePartitions$4(BoxesRunTime.unboxToLong((Object)x$4)))).sum((Numeric)Numeric.BigDecimalIsFractional$.MODULE$);
            long desiredSplitBytes = totalSizeInBytes.$div(package$.MODULE$.BigDecimal().apply(BoxesRunTime.unboxToInt((Object)maxPartNum.get()))).setScale(0, BigDecimal.RoundingMode$.MODULE$.UP()).longValue();
            Seq<FilePartition> desiredPartitions = this.getFilePartitions(partitionedFiles, desiredSplitBytes, openCostBytes);
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"The number of partitions is ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_PARTITIONS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)partitions.size()))})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"which exceeds the maximum number configured: "}))).log((Seq)Nil$.MODULE$)).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ". Spark rescales it to "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.MAX_NUM_PARTITIONS$.MODULE$, maxPartNum.get())}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " by ignoring the "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DESIRED_NUM_PARTITIONS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)desiredPartitions.size()))}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"configuration of ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CONFIG$.MODULE$, (Object)SQLConf$.MODULE$.FILES_MAX_PARTITION_BYTES().key())})))));
            return desiredPartitions;
        }
        return partitions;
    }

    public long maxSplitBytes(SparkSession sparkSession, Function0<Object> calculateTotalBytes) {
        long defaultMaxSplitBytes = sparkSession.sessionState().conf().filesMaxPartitionBytes();
        long openCostInBytes = sparkSession.sessionState().conf().filesOpenCostInBytes();
        int minPartitionNum = BoxesRunTime.unboxToInt((Object)sparkSession.sessionState().conf().filesMinPartitionNum().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> sparkSession.leafNodeDefaultParallelism()));
        long totalBytes = calculateTotalBytes.apply$mcJ$sp();
        long bytesPerCore = totalBytes / (long)minPartitionNum;
        return Math.min(defaultMaxSplitBytes, Math.max(openCostInBytes, bytesPerCore));
    }

    public long maxSplitBytes(SparkSession sparkSession, ScanFileListing selectedPartitions) {
        long byteNum = selectedPartitions.calculateTotalPartitionBytes();
        return this.maxSplitBytes(sparkSession, (Function0<Object>)(JFunction0.mcJ.sp & Serializable)() -> byteNum);
    }

    public long maxSplitBytes(SparkSession sparkSession, Seq<PartitionDirectory> selectedPartitions) {
        long openCostInBytes = sparkSession.sessionState().conf().filesOpenCostInBytes();
        long byteNum = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)selectedPartitions.flatMap((Function1 & Serializable)x$5 -> (Seq)x$5.files().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)FilePartition$.$anonfun$maxSplitBytes$4(openCostInBytes, x$6))))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return this.maxSplitBytes(sparkSession, (Function0<Object>)(JFunction0.mcJ.sp & Serializable)() -> byteNum);
    }

    public FilePartition apply(int index, PartitionedFile[] files) {
        return new FilePartition(index, files);
    }

    public Option<Tuple2<Object, PartitionedFile[]>> unapply(FilePartition x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)x$0.index()), (Object)x$0.files()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FilePartition$.class);
    }

    private static final void closePartition$1(ArrayBuffer currentFiles$1, ArrayBuffer partitions$1, LongRef currentSize$1) {
        if (currentFiles$1.nonEmpty()) {
            FilePartition newPartition = new FilePartition(partitions$1.size(), (PartitionedFile[])currentFiles$1.toArray(ClassTag$.MODULE$.apply(PartitionedFile.class)));
            v0 = partitions$1.$plus$eq((Object)newPartition);
        } else {
            v0 = BoxedUnit.UNIT;
        }
        currentFiles$1.clear();
        currentSize$1.elem = 0L;
    }

    public static final /* synthetic */ boolean $anonfun$getFilePartitions$2(Seq partitions$2, int x$2) {
        return partitions$2.size() > x$2;
    }

    public static final /* synthetic */ long $anonfun$getFilePartitions$3(long openCostBytes$1, PartitionedFile x$3) {
        return x$3.length() + openCostBytes$1;
    }

    public static final /* synthetic */ BigDecimal $anonfun$getFilePartitions$4(long x$4) {
        return package$.MODULE$.BigDecimal().apply(x$4);
    }

    public static final /* synthetic */ long $anonfun$maxSplitBytes$4(long openCostInBytes$2, FileStatusWithMetadata x$6) {
        return x$6.getLen() + openCostInBytes$2;
    }

    private FilePartition$() {
    }
}

