/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.metrics.source.HiveCatalogMetrics$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.execution.datasources.PartitioningAwareFileIndex;
import org.apache.spark.sql.execution.streaming.FileStreamSink$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tua\u0001B\u0013'\u0001MB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005}!AA\u000b\u0001B\u0001B\u0003%Q\u000b\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003b\u0011!Y\u0007A!A!\u0002\u0013a\u0007\u0002C8\u0001\u0005\u0003\u0005\u000b\u0011\u00029\t\u0011Q\u0004!Q1A\u0005BUD\u0001B\u001f\u0001\u0003\u0002\u0003\u0006IA\u001e\u0005\u0006w\u0002!\t\u0001 \u0005\n\u0003\u0017\u0001!\u0019!C!\u0003\u001bA\u0001\"!\b\u0001A\u0003%\u0011q\u0002\u0005\f\u0003?\u0001\u0001\u0019!a\u0001\n\u0013\t\t\u0003C\u0006\u00026\u0001\u0001\r\u00111A\u0005\n\u0005]\u0002bCA\"\u0001\u0001\u0007\t\u0011)Q\u0005\u0003GA1\"!\u0014\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002P!Y\u0011\u0011\f\u0001A\u0002\u0003\u0007I\u0011BA.\u0011-\ty\u0006\u0001a\u0001\u0002\u0003\u0006K!!\u0015\t\u0017\u0005\r\u0004\u00011AA\u0002\u0013%\u0011Q\r\u0005\f\u0003O\u0002\u0001\u0019!a\u0001\n\u0013\tI\u0007\u0003\u0006\u0002n\u0001\u0001\r\u0011!Q!\nEDq!!\u001d\u0001\t\u0003\n\u0019\bC\u0004\u0002v\u0001!\t&!\t\t\u000f\u0005]\u0004\u0001\"\u0015\u0002P!9\u0011\u0011\u0010\u0001\u0005B\u0005m\u0004bBA?\u0001\u0011%\u00111\u0010\u0005\b\u0003\u007f\u0002A\u0011IAA\u0011\u001d\t\u0019\n\u0001C!\u0003+Cq!!(\u0001\t\u0003\tyjB\u0004\u0002,\u001aB\t!!,\u0007\r\u00152\u0003\u0012AAX\u0011\u0019Yh\u0004\"\u0001\u0002D\"A\u0011Q\u0019\u0010\u0005\u0002)\n9\r\u0003\u0006\u0002tz\t\n\u0011\"\u0001+\u0003kD\u0011Ba\u0003\u001f#\u0003%\tA!\u0004\t\u0013\tEa$%A\u0005\u0002\tM\u0001\"\u0003B\f=E\u0005I\u0011\u0001B\r\u0005EIe.T3n_JLh)\u001b7f\u0013:$W\r\u001f\u0006\u0003O!\n1\u0002Z1uCN|WO]2fg*\u0011\u0011FK\u0001\nKb,7-\u001e;j_:T!a\u000b\u0017\u0002\u0007M\fHN\u0003\u0002.]\u0005)1\u000f]1sW*\u0011q\u0006M\u0001\u0007CB\f7\r[3\u000b\u0003E\n1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u001b\u0011\u0005U2T\"\u0001\u0014\n\u0005]2#A\u0007)beRLG/[8oS:<\u0017i^1sK\u001aKG.Z%oI\u0016D\u0018\u0001D:qCJ\\7+Z:tS>t\u0007C\u0001\u001e<\u001b\u0005Q\u0013B\u0001\u001f+\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003I\u0011xn\u001c;QCRD7o\u00159fG&4\u0017.\u001a3\u0011\u0007}JEJ\u0004\u0002A\r:\u0011\u0011\tR\u0007\u0002\u0005*\u00111IM\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015\u000bQa]2bY\u0006L!a\u0012%\u0002\u000fA\f7m[1hK*\tQ)\u0003\u0002K\u0017\n\u00191+Z9\u000b\u0005\u001dC\u0005CA'S\u001b\u0005q%BA(Q\u0003\t17O\u0003\u0002R]\u00051\u0001.\u00193p_BL!a\u0015(\u0003\tA\u000bG\u000f[\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\b\u0003\u0002,[;vs!a\u0016-\u0011\u0005\u0005C\u0015BA-I\u0003\u0019\u0001&/\u001a3fM&\u00111\f\u0018\u0002\u0004\u001b\u0006\u0004(BA-I!\t1f,\u0003\u0002`9\n11\u000b\u001e:j]\u001e\f1#^:feN\u0003XmY5gS\u0016$7k\u00195f[\u0006\u00042AY2f\u001b\u0005A\u0015B\u00013I\u0005\u0019y\u0005\u000f^5p]B\u0011a-[\u0007\u0002O*\u0011\u0001NK\u0001\u0006if\u0004Xm]\u0005\u0003U\u001e\u0014!b\u0015;sk\u000e$H+\u001f9f\u0003=1\u0017\u000e\\3Ti\u0006$Xo]\"bG\",\u0007CA\u001bn\u0013\tqgEA\bGS2,7\u000b^1ukN\u001c\u0015m\u00195f\u0003i)8/\u001a:Ta\u0016\u001c\u0017NZ5fIB\u000b'\u000f^5uS>t7\u000b]3d!\r\u00117-\u001d\t\u0003kIL!a\u001d\u0014\u0003\u001bA\u000b'\u000f^5uS>t7\u000b]3d\u0003EiW\r^1eCR\fw\n]:US6,gj]\u000b\u0002mB\u0019!mY<\u0011\u0005\tD\u0018BA=I\u0005\u0011auN\\4\u0002%5,G/\u00193bi\u0006|\u0005o\u001d+j[\u0016t5\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u001butx0!\u0001\u0002\u0004\u0005\u0015\u0011qAA\u0005!\t)\u0004\u0001C\u00039\u0013\u0001\u0007\u0011\bC\u0003>\u0013\u0001\u0007a\bC\u0003U\u0013\u0001\u0007Q\u000bC\u0003a\u0013\u0001\u0007\u0011\rC\u0004l\u0013A\u0005\t\u0019\u00017\t\u000f=L\u0001\u0013!a\u0001a\"9A/\u0003I\u0001\u0002\u00041\u0018!\u0003:p_R\u0004\u0016\r\u001e5t+\t\ty\u0001E\u0003\u0002\u0012\u0005mA*\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003%IW.\\;uC\ndWMC\u0002\u0002\u001a!\u000b!bY8mY\u0016\u001cG/[8o\u0013\rQ\u00151C\u0001\u000be>|G\u000fU1uQN\u0004\u0013aD2bG\",G\rT3bM\u001aKG.Z:\u0016\u0005\u0005\r\u0002cBA\u0013\u0003Wa\u0015qF\u0007\u0003\u0003OQA!!\u000b\u0002\u0018\u00059Q.\u001e;bE2,\u0017\u0002BA\u0017\u0003O\u0011Q\u0002T5oW\u0016$\u0007*Y:i\u001b\u0006\u0004\bcA'\u00022%\u0019\u00111\u0007(\u0003\u0015\u0019KG.Z*uCR,8/A\ndC\u000eDW\r\u001a'fC\u001a4\u0015\u000e\\3t?\u0012*\u0017\u000f\u0006\u0003\u0002:\u0005}\u0002c\u00012\u0002<%\u0019\u0011Q\b%\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u0003j\u0011\u0011!a\u0001\u0003G\t1\u0001\u001f\u00132\u0003A\u0019\u0017m\u00195fI2+\u0017M\u001a$jY\u0016\u001c\b\u0005K\u0002\u000f\u0003\u000f\u00022AYA%\u0013\r\tY\u0005\u0013\u0002\tm>d\u0017\r^5mK\u0006a2-Y2iK\u0012dU-\u00194ESJ$vn\u00115jY\u0012\u0014XM\u001c$jY\u0016\u001cXCAA)!\u00151&\fTA*!\u0015\u0011\u0017QKA\u0018\u0013\r\t9\u0006\u0013\u0002\u0006\u0003J\u0014\u0018-_\u0001!G\u0006\u001c\u0007.\u001a3MK\u00064G)\u001b:U_\u000eC\u0017\u000e\u001c3sK:4\u0015\u000e\\3t?\u0012*\u0017\u000f\u0006\u0003\u0002:\u0005u\u0003\"CA!!\u0005\u0005\t\u0019AA)\u0003u\u0019\u0017m\u00195fI2+\u0017M\u001a#jeR{7\t[5mIJ,gNR5mKN\u0004\u0003fA\t\u0002H\u0005\u00192-Y2iK\u0012\u0004\u0016M\u001d;ji&|gn\u00159fGV\t\u0011/A\fdC\u000eDW\r\u001a)beRLG/[8o'B,7m\u0018\u0013fcR!\u0011\u0011HA6\u0011!\t\teEA\u0001\u0002\u0004\t\u0018\u0001F2bG\",G\rU1si&$\u0018n\u001c8Ta\u0016\u001c\u0007\u0005K\u0002\u0015\u0003\u000f\nQ\u0002]1si&$\u0018n\u001c8Ta\u0016\u001cG#A9\u0002\u00131,\u0017M\u001a$jY\u0016\u001c\u0018A\u00067fC\u001a$\u0015N\u001d+p\u0007\"LG\u000e\u001a:f]\u001aKG.Z:\u0002\u000fI,gM]3tQR\u0011\u0011\u0011H\u0001\te\u00164'/Z:ia\u00051Q-];bYN$B!a!\u0002\nB\u0019!-!\"\n\u0007\u0005\u001d\u0005JA\u0004C_>dW-\u00198\t\u000f\u0005-%\u00041\u0001\u0002\u000e\u0006)q\u000e\u001e5feB\u0019!-a$\n\u0007\u0005E\u0005JA\u0002B]f\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003/\u00032AYAM\u0013\r\tY\n\u0013\u0002\u0004\u0013:$\u0018!\u00047jgRdU-\u00194GS2,7\u000f\u0006\u0003\u0002\"\u0006\u001d\u0006CBA\u0013\u0003G\u000by#\u0003\u0003\u0002&\u0006\u001d\"!\u0004'j].,G\rS1tQN+G\u000f\u0003\u0004\u0002*r\u0001\rAP\u0001\u0006a\u0006$\bn]\u0001\u0012\u0013:lU-\\8ss\u001aKG.Z%oI\u0016D\bCA\u001b\u001f'\u0015q\u0012\u0011WA\\!\r\u0011\u00171W\u0005\u0004\u0003kC%AB!osJ+g\r\u0005\u0003\u0002:\u0006}VBAA^\u0015\r\ti\fL\u0001\tS:$XM\u001d8bY&!\u0011\u0011YA^\u0005\u001daunZ4j]\u001e$\"!!,\u0002#\t,Hn\u001b'jgRdU-\u00194GS2,7\u000f\u0006\u0007\u0002J\u0006M\u0017Q[As\u0003_\f\t\u0010\u0005\u0003@\u0013\u0006-\u0007C\u00022\u0002N2\u000b\t.C\u0002\u0002P\"\u0013a\u0001V;qY\u0016\u0014\u0004\u0003B J\u0003_Aa!!+!\u0001\u0004q\u0004bBAlA\u0001\u0007\u0011\u0011\\\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007\u0003BAn\u0003Cl!!!8\u000b\u0007\u0005}\u0007+\u0001\u0003d_:4\u0017\u0002BAr\u0003;\u0014QbQ8oM&<WO]1uS>t\u0007bBAtA\u0001\u0007\u0011\u0011^\u0001\u0007M&dG/\u001a:\u0011\u00075\u000bY/C\u0002\u0002n:\u0013!\u0002U1uQ\u001aKG\u000e^3s\u0011\u0015A\u0004\u00051\u0001:\u0011\u001d!\u0006\u0005%AA\u0002U\u000b1DY;mW2K7\u000f\u001e'fC\u001a4\u0015\u000e\\3tI\u0011,g-Y;mi\u0012*TCAA|U\r)\u0016\u0011`\u0016\u0003\u0003w\u0004B!!@\u0003\b5\u0011\u0011q \u0006\u0005\u0005\u0003\u0011\u0019!A\u0005v]\u000eDWmY6fI*\u0019!Q\u0001%\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\n\u0005}(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\"Aa\u0004+\u00071\fI0A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEN\u000b\u0003\u0005+Q3\u0001]A}\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!1\u0004\u0016\u0004m\u0006e\b")
public class InMemoryFileIndex
extends PartitioningAwareFileIndex {
    private final SparkSession sparkSession;
    private final Map<String, String> parameters;
    private final FileStatusCache fileStatusCache;
    private final Option<PartitionSpec> userSpecifiedPartitionSpec;
    private final Option<Object> metadataOpsTimeNs;
    private final Seq<Path> rootPaths;
    private volatile LinkedHashMap<Path, FileStatus> cachedLeafFiles;
    private volatile Map<Path, FileStatus[]> cachedLeafDirToChildrenFiles;
    private volatile PartitionSpec cachedPartitionSpec;

    public static Option<Object> $lessinit$greater$default$7() {
        return InMemoryFileIndex$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<PartitionSpec> $lessinit$greater$default$6() {
        return InMemoryFileIndex$.MODULE$.$lessinit$greater$default$6();
    }

    public static FileStatusCache $lessinit$greater$default$5() {
        return InMemoryFileIndex$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public Option<Object> metadataOpsTimeNs() {
        return this.metadataOpsTimeNs;
    }

    @Override
    public Seq<Path> rootPaths() {
        return this.rootPaths;
    }

    private LinkedHashMap<Path, FileStatus> cachedLeafFiles() {
        return this.cachedLeafFiles;
    }

    private void cachedLeafFiles_$eq(LinkedHashMap<Path, FileStatus> x$1) {
        this.cachedLeafFiles = x$1;
    }

    private Map<Path, FileStatus[]> cachedLeafDirToChildrenFiles() {
        return this.cachedLeafDirToChildrenFiles;
    }

    private void cachedLeafDirToChildrenFiles_$eq(Map<Path, FileStatus[]> x$1) {
        this.cachedLeafDirToChildrenFiles = x$1;
    }

    private PartitionSpec cachedPartitionSpec() {
        return this.cachedPartitionSpec;
    }

    private void cachedPartitionSpec_$eq(PartitionSpec x$1) {
        this.cachedPartitionSpec = x$1;
    }

    @Override
    public PartitionSpec partitionSpec() {
        if (this.cachedPartitionSpec() == null) {
            if (this.userSpecifiedPartitionSpec.isDefined()) {
                this.cachedPartitionSpec_$eq((PartitionSpec)this.userSpecifiedPartitionSpec.get());
            } else {
                this.cachedPartitionSpec_$eq(this.inferPartitioning());
            }
        }
        this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Partition spec: " + this.cachedPartitionSpec());
        return this.cachedPartitionSpec();
    }

    @Override
    public LinkedHashMap<Path, FileStatus> leafFiles() {
        return this.cachedLeafFiles();
    }

    @Override
    public Map<Path, FileStatus[]> leafDirToChildrenFiles() {
        return this.cachedLeafDirToChildrenFiles();
    }

    @Override
    public void refresh() {
        this.fileStatusCache.invalidateAll();
        this.refresh0();
    }

    private void refresh0() {
        LinkedHashSet<FileStatus> files = this.listLeafFiles(this.rootPaths());
        this.cachedLeafFiles_$eq((LinkedHashMap<Path, FileStatus>)((LinkedHashMap)new LinkedHashMap().$plus$plus$eq((IterableOnce)files.map((Function1 & Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.getPath()), f)))));
        this.cachedLeafDirToChildrenFiles_$eq((Map<Path, FileStatus[]>)ArrayOps$.MODULE$.groupBy$extension(Predef$.MODULE$.refArrayOps((Object[])files.toArray(ClassTag$.MODULE$.apply(FileStatus.class))), (Function1 & Serializable)x$5 -> x$5.getPath().getParent()));
        this.cachedPartitionSpec_$eq(null);
    }

    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof InMemoryFileIndex) {
            InMemoryFileIndex inMemoryFileIndex = (InMemoryFileIndex)object;
            Set set = this.rootPaths().toSet();
            Set set2 = inMemoryFileIndex.rootPaths().toSet();
            return !(set != null ? !set.equals(set2) : set2 != null);
        }
        return false;
    }

    public int hashCode() {
        return this.rootPaths().toSet().hashCode();
    }

    public LinkedHashSet<FileStatus> listLeafFiles(Seq<Path> paths) {
        long startTime = System.nanoTime();
        LinkedHashSet output = (LinkedHashSet)LinkedHashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer pathsToFetch = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        paths.foreach((Function1 & Serializable)path -> {
            Option<FileStatus[]> option = $this.fileStatusCache.getLeafFiles((Path)path);
            if (option instanceof Some) {
                Some some = (Some)option;
                FileStatus[] files = (FileStatus[])some.value();
                HiveCatalogMetrics$.MODULE$.incrementFileCacheHits(files.length);
                return (AbstractIterable)output.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])files));
            }
            if (None$.MODULE$.equals(option)) {
                return (AbstractIterable)pathsToFetch.$plus$eq(path);
            }
            throw new MatchError(option);
        });
        PathFilter filter = FileInputFormat.getInputPathFilter((JobConf)new JobConf(this.hadoopConf(), this.getClass()));
        Seq<Tuple2<Path, Seq<FileStatus>>> discovered = InMemoryFileIndex$.MODULE$.bulkListLeafFiles((Seq<Path>)pathsToFetch.toSeq(), this.hadoopConf(), filter, this.sparkSession, this.parameters);
        discovered.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Path path = (Path)tuple2._1();
                Seq leafFiles = (Seq)tuple2._2();
                HiveCatalogMetrics$.MODULE$.incrementFilesDiscovered(leafFiles.size());
                $this.fileStatusCache.putLeafFiles(path, (FileStatus[])leafFiles.toArray(ClassTag$.MODULE$.apply(FileStatus.class)));
                return (LinkedHashSet)output.$plus$plus$eq((IterableOnce)leafFiles);
            }
            throw new MatchError((Object)tuple2);
        });
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"It took ", " ms"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.ELAPSED_TIME$.MODULE$, (Object)BoxesRunTime.boxToLong((long)((System.nanoTime() - startTime) / 1000000L)))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" to list leaf files for ", " paths."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.COUNT$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)paths.length()))})))));
        return output;
    }

    public InMemoryFileIndex(SparkSession sparkSession, Seq<Path> rootPathsSpecified, Map<String, String> parameters, Option<StructType> userSpecifiedSchema, FileStatusCache fileStatusCache, Option<PartitionSpec> userSpecifiedPartitionSpec, Option<Object> metadataOpsTimeNs) {
        this.sparkSession = sparkSession;
        this.parameters = parameters;
        this.fileStatusCache = fileStatusCache;
        this.userSpecifiedPartitionSpec = userSpecifiedPartitionSpec;
        this.metadataOpsTimeNs = metadataOpsTimeNs;
        super(sparkSession, parameters, userSpecifiedSchema, fileStatusCache);
        this.rootPaths = (Seq)rootPathsSpecified.filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSink$.MODULE$.ancestorIsMetadataDirectory(x$1, this.hadoopConf())));
        this.refresh0();
    }
}

