/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.Locale;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.PartitionPath;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.execution.datasources.PartitionSpec$;
import org.apache.spark.sql.execution.datasources.PartitioningUtils;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.AnyTimestampType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VariantType;
import org.apache.spark.sql.util.SchemaUtils$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.ArrayImplicits$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class PartitioningUtils$
implements SQLConfHelper {
    public static final PartitioningUtils$ MODULE$ = new PartitioningUtils$();
    private static final String timestampPartitionPattern;
    private static final Function2<DataType, DataType, DataType> findWiderTypeForPartitionColumn;

    static {
        SQLConfHelper.$init$((SQLConfHelper)MODULE$);
        timestampPartitionPattern = "yyyy-MM-dd HH:mm:ss[.S]";
        findWiderTypeForPartitionColumn = PartitioningUtils$::$anonfun$findWiderTypeForPartitionColumn$1;
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    public String timestampPartitionPattern() {
        return timestampPartitionPattern;
    }

    public PartitionSpec parsePartitions(Seq<Path> paths, boolean typeInference, Set<Path> basePaths, Option<StructType> userSpecifiedSchema, boolean caseSensitive, boolean validatePartitionColumns, String timeZoneId) {
        return this.parsePartitions(paths, typeInference, basePaths, userSpecifiedSchema, caseSensitive, validatePartitionColumns, DateTimeUtils$.MODULE$.getZoneId(timeZoneId));
    }

    public PartitionSpec parsePartitions(Seq<Path> paths, boolean typeInference, Set<Path> basePaths, Option<StructType> userSpecifiedSchema, boolean caseSensitive, boolean validatePartitionColumns, ZoneId zoneId) {
        Object object;
        if (userSpecifiedSchema.isDefined()) {
            scala.collection.immutable.Map nameToDataType = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((StructType)userSpecifiedSchema.get()).fields()), (Function1 & Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), (Object)f.dataType()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            object = !caseSensitive ? CaseInsensitiveMap$.MODULE$.apply(nameToDataType) : nameToDataType;
        } else {
            object = Predef$.MODULE$.Map().empty();
        }
        scala.collection.immutable.Map userSpecifiedDataTypes = object;
        scala.collection.immutable.Map userSpecifiedNames = userSpecifiedSchema.isDefined() && !caseSensitive ? CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((StructType)userSpecifiedSchema.get()).fields()), (Function1 & Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), (Object)f.name()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())) : Predef$.MODULE$.Map().empty();
        DateFormatter dateFormatter = DateFormatter$.MODULE$.apply(DateFormatter$.MODULE$.defaultPattern(), DateFormatter$.MODULE$.apply$default$2());
        TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.apply(this.timestampPartitionPattern(), zoneId, true);
        Tuple2 tuple2 = ((IterableOps)paths.map((Function1 & Serializable)path -> MODULE$.parsePartition((Path)path, typeInference, basePaths, (scala.collection.immutable.Map<String, DataType>)userSpecifiedDataTypes, validatePartitionColumns, zoneId, dateFormatter, timestampFormatter))).unzip(Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq partitionValues = (Seq)tuple2._1();
        Seq optDiscoveredBasePaths = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionValues, (Object)optDiscoveredBasePaths);
        Seq partitionValues2 = (Seq)tuple22._1();
        Seq optDiscoveredBasePaths2 = (Seq)tuple22._2();
        Seq pathsWithPartitionValues = (Seq)((IterableOps)paths.zip((IterableOnce)partitionValues2)).flatMap((Function1 & Serializable)x -> ((Option)x._2()).map((Function1 & Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x._1()), x$2)));
        if (pathsWithPartitionValues.isEmpty()) {
            return PartitionSpec$.MODULE$.emptySpec();
        }
        Seq discoveredBasePaths = (Seq)((IterableOps)optDiscoveredBasePaths2.flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x$3 -> x$3.toString().toLowerCase());
        Predef$.MODULE$.assert(((SeqOps)discoveredBasePaths.distinct()).size() == 1, (Function0 & Serializable)() -> "Conflicting directory structures detected. Suspicious paths:\b" + ((IterableOnceOps)discoveredBasePaths.distinct()).mkString("\n\t", "\n\t", "\n\n") + "If provided paths are partition directories, please set \"basePath\" in the options of the data source to specify the root directory of the table. If there are multiple root directories, please load them separately and then union them.");
        Seq<PartitioningUtils.PartitionValues> resolvedPartitionValues = this.resolvePartitions((Seq<Tuple2<Path, PartitioningUtils.PartitionValues>>)pathsWithPartitionValues, caseSensitive);
        PartitioningUtils.PartitionValues partitionValues3 = (PartitioningUtils.PartitionValues)resolvedPartitionValues.head();
        if (partitionValues3 == null) {
            throw new MatchError((Object)partitionValues3);
        }
        Seq<String> columnNames = partitionValues3.columnNames();
        Seq<PartitioningUtils.TypedPartValue> typedValues = partitionValues3.typedValues();
        Tuple2 tuple23 = new Tuple2(columnNames, typedValues);
        Seq columnNames2 = (Seq)tuple23._1();
        Seq typedValues2 = (Seq)tuple23._2();
        Seq fields = (Seq)((IterableOps)columnNames2.zip((IterableOnce)typedValues2)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                PartitioningUtils.TypedPartValue typedPartValue = (PartitioningUtils.TypedPartValue)tuple2._2();
                if (typedPartValue != null) {
                    DataType dataType = typedPartValue.dataType();
                    String resultName = (String)userSpecifiedNames.getOrElse((Object)name, (Function0 & Serializable)() -> name);
                    DataType resultDataType = (DataType)userSpecifiedDataTypes.getOrElse((Object)name, (Function0 & Serializable)() -> dataType);
                    return new StructField(resultName, resultDataType, true, StructField$.MODULE$.apply$default$4());
                }
            }
            throw new MatchError((Object)tuple2);
        });
        Seq partitions = (Seq)((IterableOps)resolvedPartitionValues.zip((IterableOnce)pathsWithPartitionValues)).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                PartitioningUtils.PartitionValues partitionValues = (PartitioningUtils.PartitionValues)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (partitionValues != null) {
                    Seq<String> columnNames = partitionValues.columnNames();
                    Seq<PartitioningUtils.TypedPartValue> typedValues = partitionValues.typedValues();
                    if (tuple22 != null) {
                        Path path = (Path)tuple22._1();
                        Seq rowValues = (Seq)((IterableOps)columnNames.zip(typedValues)).map((Function1 & Serializable)x0$3 -> {
                            Tuple2 tuple2 = x0$3;
                            if (tuple2 != null) {
                                Object object;
                                String columnName = (String)tuple2._1();
                                PartitioningUtils.TypedPartValue typedValue = (PartitioningUtils.TypedPartValue)tuple2._2();
                                try {
                                    object = MODULE$.castPartValueToDesiredType(typedValue.dataType(), typedValue.value(), zoneId);
                                }
                                catch (Throwable throwable) {
                                    Option option;
                                    Throwable throwable2 = throwable;
                                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                        if (validatePartitionColumns) {
                                            throw QueryExecutionErrors$.MODULE$.failedToCastValueToDataTypeForPartitionColumnError(typedValue.value(), typedValue.dataType(), columnName);
                                        }
                                        object = null;
                                    }
                                    throw throwable;
                                }
                                return object;
                            }
                            throw new MatchError((Object)tuple2);
                        });
                        return new PartitionPath(InternalRow$.MODULE$.fromSeq(rowValues), path);
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        return new PartitionSpec(StructType$.MODULE$.apply(fields), (Seq<PartitionPath>)partitions);
    }

    public Tuple2<Option<PartitioningUtils.PartitionValues>, Option<Path>> parsePartition(Path path, boolean typeInference, Set<Path> basePaths, scala.collection.immutable.Map<String, DataType> userSpecifiedDataTypes, boolean validatePartitionColumns, ZoneId zoneId, DateFormatter dateFormatter, TimestampFormatter timestampFormatter) {
        ArrayBuffer columns = ArrayBuffer$.MODULE$.empty();
        boolean finished = path.getParent() == null;
        Path currentPath = path;
        while (!finished) {
            String string = currentPath.getName().toLowerCase(Locale.ROOT);
            String string2 = "_temporary";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
            }
            if (basePaths.contains((Object)currentPath)) {
                finished = true;
                continue;
            }
            Option<Tuple2<String, PartitioningUtils.TypedPartValue>> maybeColumn = this.parsePartitionColumn(currentPath.getName(), typeInference, userSpecifiedDataTypes, zoneId, dateFormatter, timestampFormatter);
            maybeColumn.foreach((Function1 & Serializable)x$5 -> (ArrayBuffer)columns.$plus$eq(x$5));
            finished = maybeColumn.isEmpty() && !columns.isEmpty() || currentPath.getParent() == null;
            if (finished) continue;
            currentPath = currentPath.getParent();
        }
        if (columns.isEmpty()) {
            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)path));
        }
        Tuple2 tuple2 = ((StrictOptimizedIterableOps)columns.reverse()).unzip(Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ArrayBuffer columnNames = (ArrayBuffer)tuple2._1();
        ArrayBuffer values = (ArrayBuffer)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)columnNames, (Object)values);
        ArrayBuffer columnNames2 = (ArrayBuffer)tuple22._1();
        ArrayBuffer values2 = (ArrayBuffer)tuple22._2();
        return new Tuple2((Object)new Some((Object)new PartitioningUtils.PartitionValues((Seq<String>)columnNames2.toSeq(), (Seq<PartitioningUtils.TypedPartValue>)values2.toSeq())), (Object)new Some((Object)currentPath));
    }

    private Option<Tuple2<String, PartitioningUtils.TypedPartValue>> parsePartitionColumn(String columnSpec, boolean typeInference, scala.collection.immutable.Map<String, DataType> userSpecifiedDataTypes, ZoneId zoneId, DateFormatter dateFormatter, TimestampFormatter timestampFormatter) {
        int equalSignIndex = columnSpec.indexOf(61);
        if (equalSignIndex == -1) {
            return None$.MODULE$;
        }
        String columnName = ExternalCatalogUtils$.MODULE$.unescapePathName(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(columnSpec), equalSignIndex));
        Predef$.MODULE$.assert(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(columnName)), (Function0 & Serializable)() -> "Empty partition column name in '" + columnSpec + "'");
        String rawColumnValue = StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(columnSpec), equalSignIndex + 1);
        Predef$.MODULE$.assert(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(rawColumnValue)), (Function0 & Serializable)() -> "Empty partition column value in '" + columnSpec + "'");
        DataType dataType = userSpecifiedDataTypes.contains((Object)columnName) ? (DataType)userSpecifiedDataTypes.apply((Object)columnName) : this.inferPartitionColumnValue(rawColumnValue, typeInference, zoneId, dateFormatter, timestampFormatter);
        return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)columnName), (Object)new PartitioningUtils.TypedPartValue(rawColumnValue, dataType)));
    }

    public scala.collection.immutable.Map<String, String> parsePathFragment(String pathFragment) {
        return this.parsePathFragmentAsSeq(pathFragment).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Seq<Tuple2<String, String>> parsePathFragmentAsSeq(String pathFragment) {
        return ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])pathFragment.split("/")), (Function1 & Serializable)kv -> {
            String[] pair = kv.split("=", 2);
            return new Tuple2((Object)ExternalCatalogUtils$.MODULE$.unescapePathName(pair[0]), (Object)ExternalCatalogUtils$.MODULE$.unescapePathName(pair[1]));
        }, ClassTag$.MODULE$.apply(Tuple2.class))).toImmutableArraySeq();
    }

    public String getPathFragment(scala.collection.immutable.Map<String, String> spec, StructType partitionSchema) {
        return ((IterableOnceOps)partitionSchema.map((Function1 & Serializable)field -> ExternalCatalogUtils$.MODULE$.escapePathName(field.name()) + "=" + ExternalCatalogUtils$.MODULE$.getPartitionValueString(MODULE$.removeLeadingZerosFromNumberTypePartition((String)spec.apply((Object)field.name()), field.dataType())))).mkString("/");
    }

    public String removeLeadingZerosFromNumberTypePartition(String value, DataType dataType) {
        DataType dataType2 = dataType;
        if (ByteType$.MODULE$.equals(dataType2) ? true : (ShortType$.MODULE$.equals(dataType2) ? true : (IntegerType$.MODULE$.equals(dataType2) ? true : (LongType$.MODULE$.equals(dataType2) ? true : (FloatType$.MODULE$.equals(dataType2) ? true : DoubleType$.MODULE$.equals(dataType2)))))) {
            return (String)Option$.MODULE$.apply(this.castPartValueToDesiredType(dataType, value, null)).map((Function1 & Serializable)x$7 -> x$7.toString()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return value;
    }

    public String getPathFragment(scala.collection.immutable.Map<String, String> spec, Seq<Attribute> partitionColumns) {
        return this.getPathFragment(spec, DataTypeUtils$.MODULE$.fromAttributes(partitionColumns));
    }

    public Seq<PartitioningUtils.PartitionValues> resolvePartitions(Seq<Tuple2<Path, PartitioningUtils.PartitionValues>> pathsWithPartitionValues, boolean caseSensitive) {
        if (pathsWithPartitionValues.isEmpty()) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        Seq partColNames = caseSensitive ? (Seq)pathsWithPartitionValues.map((Function1 & Serializable)x$8 -> ((PartitioningUtils.PartitionValues)x$8._2()).columnNames()) : (Seq)pathsWithPartitionValues.map((Function1 & Serializable)x$9 -> (Seq)((PartitioningUtils.PartitionValues)x$9._2()).columnNames().map((Function1 & Serializable)x$10 -> x$10.toLowerCase()));
        Predef$.MODULE$.assert(((SeqOps)partColNames.distinct()).size() == 1, (Function0 & Serializable)() -> MODULE$.listConflictingPartitionColumns(pathsWithPartitionValues));
        Seq values = (Seq)pathsWithPartitionValues.map((Function1 & Serializable)x$11 -> (PartitioningUtils.PartitionValues)x$11._2());
        int columnCount = ((PartitioningUtils.PartitionValues)values.head()).columnNames().size();
        IndexedSeq resolvedValues = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), columnCount).map((Function1 & Serializable)i -> PartitioningUtils$.MODULE$.resolveTypeConflicts((Seq<PartitioningUtils.TypedPartValue>)((Seq)values.map((Function1 & Serializable)x$12 -> (PartitioningUtils.TypedPartValue)x$12.typedValues().apply(i)))));
        return (Seq)((IterableOps)values.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                PartitioningUtils.PartitionValues d = (PartitioningUtils.PartitionValues)tuple2._1();
                int index = tuple2._2$mcI$sp();
                IndexedSeq x$1 = (IndexedSeq)resolvedValues.map((Function1 & Serializable)x$13 -> (PartitioningUtils.TypedPartValue)x$13.apply(index));
                Seq<String> x$2 = d.copy$default$1();
                return d.copy(x$2, (Seq<PartitioningUtils.TypedPartValue>)x$1);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public String listConflictingPartitionColumns(Seq<Tuple2<Path, PartitioningUtils.PartitionValues>> pathWithPartitionValues) {
        Seq distinctPartColNames = (Seq)((SeqOps)pathWithPartitionValues.map((Function1 & Serializable)x$14 -> ((PartitioningUtils.PartitionValues)x$14._2()).columnNames())).distinct();
        scala.collection.immutable.Map partColNamesToPaths = PartitioningUtils$.groupByKey$1((Seq)pathWithPartitionValues.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Path path = (Path)tuple2._1();
                PartitioningUtils.PartitionValues partValues = (PartitioningUtils.PartitionValues)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partValues.columnNames()), (Object)path);
            }
            throw new MatchError((Object)tuple2);
        }));
        Seq distinctPartColLists = (Seq)((IterableOps)((IterableOps)distinctPartColNames.map((Function1 & Serializable)x$16 -> x$16.mkString(", "))).zipWithIndex()).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String names = (String)tuple2._1();
                int index = tuple2._2$mcI$sp();
                return "Partition column name list #" + index + ": " + names;
            }
            throw new MatchError((Object)tuple2);
        });
        Seq suspiciousPaths = (Seq)((IterableOps)distinctPartColNames.sortBy((Function1 & Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.length()), (Ordering)Ordering.Int$.MODULE$)).flatMap((Function1)partColNamesToPaths);
        return "Conflicting partition column names detected:\n" + distinctPartColLists.mkString("\n\t", "\n\t", "\n\n") + "For partitioned table directories, data files should only live in leaf directories.\nAnd directories at the same level should have the same partition column name.\nPlease check the following directories for unexpected files or inconsistent partition column names:\n" + ((IterableOnceOps)suspiciousPaths.map((Function1 & Serializable)x$18 -> "\t" + x$18)).mkString("\n", "\n", "");
    }

    public DataType inferPartitionColumnValue(String raw, boolean typeInference, ZoneId zoneId, DateFormatter dateFormatter, TimestampFormatter timestampFormatter) {
        Try decimalTry = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            BigDecimal bigDecimal = new BigDecimal(raw);
            Predef$.MODULE$.require(bigDecimal.scale() <= 0);
            return DecimalType$.MODULE$.fromDecimal(Decimal$.MODULE$.apply(bigDecimal));
        });
        Try dateTry = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            dateFormatter.parse(raw);
            Cast qual$1 = new Cast((Expression)Literal$.MODULE$.apply((Object)raw), (DataType)DateType$.MODULE$, (Option)new Some((Object)zoneId.getId()), Cast$.MODULE$.apply$default$4());
            InternalRow x$1 = qual$1.eval$default$1();
            Object dateValue = qual$1.eval(x$1);
            Predef$.MODULE$.require(dateValue != null);
            return DateType$.MODULE$;
        });
        Try timestampTry = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            String unescapedRaw = ExternalCatalogUtils$.MODULE$.unescapePathName(raw);
            AtomicType timestampType = MODULE$.conf().timestampType();
            AtomicType atomicType = timestampType;
            if (TimestampType$.MODULE$.equals(atomicType)) {
                timestampFormatter.parse(unescapedRaw);
            } else if (TimestampNTZType$.MODULE$.equals(atomicType)) {
                timestampFormatter.parseWithoutTimeZone(unescapedRaw);
            } else {
                throw new MatchError((Object)atomicType);
            }
            Cast qual$2 = new Cast((Expression)Literal$.MODULE$.apply((Object)unescapedRaw), (DataType)timestampType, (Option)new Some((Object)zoneId.getId()), Cast$.MODULE$.apply$default$4());
            InternalRow x$2 = qual$2.eval$default$1();
            Object timestampValue = qual$2.eval(x$2);
            Predef$.MODULE$.require(timestampValue != null);
            return timestampType;
        });
        if (typeInference) {
            return (DataType)Try$.MODULE$.apply((Function0 & Serializable)() -> {
                Integer.parseInt(raw);
                return IntegerType$.MODULE$;
            }).orElse((Function0 & Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable)() -> {
                Long.parseLong(raw);
                return LongType$.MODULE$;
            })).orElse((Function0 & Serializable)() -> decimalTry).orElse((Function0 & Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable)() -> {
                Double.parseDouble(raw);
                return DoubleType$.MODULE$;
            })).orElse((Function0 & Serializable)() -> timestampTry).orElse((Function0 & Serializable)() -> dateTry).getOrElse((Function0 & Serializable)() -> {
                String string = raw;
                String string2 = ExternalCatalogUtils$.MODULE$.DEFAULT_PARTITION_NAME();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return NullType$.MODULE$;
                }
                return StringType$.MODULE$;
            });
        }
        String string = raw;
        String string2 = ExternalCatalogUtils$.MODULE$.DEFAULT_PARTITION_NAME();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return NullType$.MODULE$;
        }
        return StringType$.MODULE$;
    }

    public Object castPartValueToDesiredType(DataType desiredType, String value, ZoneId zoneId) {
        DataType dataType = desiredType;
        String string = value;
        String string2 = ExternalCatalogUtils$.MODULE$.DEFAULT_PARTITION_NAME();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return null;
        }
        if (NullType$.MODULE$.equals(dataType)) {
            return null;
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return UTF8String.fromString((String)ExternalCatalogUtils$.MODULE$.unescapePathName(value));
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToByte((byte)((byte)Integer.parseInt(value)));
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToShort((short)((short)Integer.parseInt(value)));
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToInteger((int)Integer.parseInt(value));
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToLong((long)Long.parseLong(value));
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToFloat((float)((float)Double.parseDouble(value)));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToDouble((double)Double.parseDouble(value));
        }
        if (dataType instanceof DecimalType) {
            return Literal$.MODULE$.apply((Object)new BigDecimal(value)).value();
        }
        if (DateType$.MODULE$.equals(dataType)) {
            Cast qual$1 = new Cast((Expression)Literal$.MODULE$.apply((Object)value), (DataType)DateType$.MODULE$, (Option)new Some((Object)zoneId.getId()), Cast$.MODULE$.apply$default$4());
            InternalRow x$1 = qual$1.eval$default$1();
            return qual$1.eval(x$1);
        }
        if (AnyTimestampType$.MODULE$.acceptsType(dataType)) {
            return Try$.MODULE$.apply((Function0 & Serializable)() -> {
                Cast qual$2 = new Cast((Expression)Literal$.MODULE$.apply((Object)ExternalCatalogUtils$.MODULE$.unescapePathName(value)), dataType, (Option)new Some((Object)zoneId.getId()), Cast$.MODULE$.apply$default$4());
                InternalRow x$2 = qual$2.eval$default$1();
                return qual$2.eval(x$2);
            }).getOrElse((Function0 & Serializable)() -> {
                Cast qual$3 = new Cast((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)value), (DataType)DateType$.MODULE$, (Option)new Some((Object)zoneId.getId()), Cast$.MODULE$.apply$default$4()), dataType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
                InternalRow x$3 = qual$3.eval$default$1();
                return qual$3.eval(x$3);
            });
        }
        if (dataType instanceof AnsiIntervalType) {
            AnsiIntervalType ansiIntervalType = (AnsiIntervalType)dataType;
            Cast qual$4 = new Cast((Expression)Literal$.MODULE$.apply((Object)ExternalCatalogUtils$.MODULE$.unescapePathName(value)), (DataType)ansiIntervalType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
            InternalRow x$4 = qual$4.eval$default$1();
            return qual$4.eval(x$4);
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return value.getBytes();
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(value)));
        }
        throw QueryExecutionErrors$.MODULE$.typeUnsupportedError(dataType);
    }

    public void validatePartitionColumn(StructType schema, Seq<String> partitionColumns, boolean caseSensitive) {
        SchemaUtils$.MODULE$.checkColumnNameDuplication(partitionColumns, caseSensitive);
        this.partitionColumnsSchema(schema, partitionColumns).foreach((Function1 & Serializable)field -> {
            PartitioningUtils$.$anonfun$validatePartitionColumn$1(field);
            return BoxedUnit.UNIT;
        });
        if (partitionColumns.nonEmpty() && partitionColumns.size() == schema.fields().length) {
            throw QueryCompilationErrors$.MODULE$.cannotUseAllColumnsForPartitionColumnsError();
        }
    }

    public boolean canPartitionOn(DataType dateType) {
        DataType dataType = dateType;
        if (dataType instanceof StringType) {
            StringType stringType = (StringType)dataType;
            return stringType.supportsBinaryOrdering();
        }
        if (dataType instanceof AtomicType) {
            AtomicType atomicType = (AtomicType)dataType;
            return !(atomicType instanceof VariantType);
        }
        return false;
    }

    public StructType partitionColumnsSchema(StructType schema, Seq<String> partitionColumns) {
        return StructType$.MODULE$.apply((Seq)partitionColumns.map((Function1 & Serializable)col -> (StructField)schema.find((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)PartitioningUtils$.$anonfun$partitionColumnsSchema$2(col, f))).getOrElse((Function0 & Serializable)() -> {
            String schemaCatalog = schema.catalogString();
            throw QueryCompilationErrors$.MODULE$.partitionColumnNotFoundInSchemaError(col, schemaCatalog);
        }))).asNullable();
    }

    public Tuple2<StructType, scala.collection.immutable.Map<String, StructField>> mergeDataAndPartitionSchema(StructType dataSchema, StructType partitionSchema, boolean caseSensitive) {
        Map overlappedPartCols = (Map)Map$.MODULE$.empty();
        partitionSchema.foreach((Function1 & Serializable)partitionField -> {
            String partitionFieldName = MODULE$.getColName((StructField)partitionField, caseSensitive);
            if (dataSchema.exists((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)PartitioningUtils$.$anonfun$mergeDataAndPartitionSchema$2(caseSensitive, partitionFieldName, x$19)))) {
                return overlappedPartCols.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionFieldName), partitionField));
            }
            return BoxedUnit.UNIT;
        });
        StructType fullSchema = StructType$.MODULE$.apply((Seq)((IterableOps)dataSchema.map((Function1 & Serializable)f -> (StructField)overlappedPartCols.getOrElse((Object)MODULE$.getColName((StructField)f, caseSensitive), (Function0 & Serializable)() -> f))).$plus$plus((IterableOnce)partitionSchema.filterNot((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)overlappedPartCols.contains((Object)PartitioningUtils$.MODULE$.getColName(f, caseSensitive))))));
        return new Tuple2((Object)fullSchema, (Object)overlappedPartCols.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public String getColName(StructField f, boolean caseSensitive) {
        if (caseSensitive) {
            return f.name();
        }
        return f.name().toLowerCase(Locale.ROOT);
    }

    private Seq<PartitioningUtils.TypedPartValue> resolveTypeConflicts(Seq<PartitioningUtils.TypedPartValue> typedValues) {
        Seq dataTypes = (Seq)typedValues.map((Function1 & Serializable)x$20 -> x$20.dataType());
        DataType desiredType = (DataType)dataTypes.reduce(this.findWiderTypeForPartitionColumn());
        return (Seq)typedValues.map((Function1 & Serializable)tv -> {
            DataType x$1 = desiredType;
            String x$2 = tv.copy$default$1();
            return tv.copy(x$2, x$1);
        });
    }

    private Function2<DataType, DataType, DataType> findWiderTypeForPartitionColumn() {
        return findWiderTypeForPartitionColumn;
    }

    private static final scala.collection.immutable.Map groupByKey$1(Seq seq) {
        return (scala.collection.immutable.Map)seq.groupBy((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object key = tuple2._1();
                return key;
            }
            throw new MatchError((Object)tuple2);
        }).transform((Function2 & Serializable)(x$15, v) -> (Seq)v.map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Object value = tuple2._2();
                return value;
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    public static final /* synthetic */ void $anonfun$validatePartitionColumn$1(StructField field) {
        if (!MODULE$.canPartitionOn(field.dataType())) {
            throw QueryCompilationErrors$.MODULE$.invalidPartitionColumnDataTypeError(field);
        }
    }

    public static final /* synthetic */ boolean $anonfun$partitionColumnsSchema$2(String col$1, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)MODULE$.conf().resolver().apply((Object)f.name(), (Object)col$1));
    }

    public static final /* synthetic */ boolean $anonfun$mergeDataAndPartitionSchema$2(boolean caseSensitive$1, String partitionFieldName$1, StructField x$19) {
        String string = MODULE$.getColName(x$19, caseSensitive$1);
        String string2 = partitionFieldName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ StringType$ $anonfun$findWiderTypeForPartitionColumn$2() {
        return StringType$.MODULE$;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ DataType $anonfun$findWiderTypeForPartitionColumn$1(DataType x0$1, DataType x1$1) {
        block10: {
            block9: {
                block8: {
                    block7: {
                        var5_2 = new Tuple2((Object)x0$1, (Object)x1$1);
                        if (var5_2 == null || !DoubleType$.MODULE$.equals(var6_3 = (DataType)var5_2._1()) || !(var5_2._2() instanceof DecimalType)) break block7;
                        v0 = true;
                        break block8;
                    }
                    if (var5_2 == null) ** GOTO lbl-1000
                    var7_4 = (DataType)var5_2._2();
                    if (var5_2._1() instanceof DecimalType && DoubleType$.MODULE$.equals(var7_4)) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                }
                if (v0) {
                    return StringType$.MODULE$;
                }
                if (var5_2 == null) break block9;
                var8_5 = (DataType)var5_2._1();
                var9_6 = (DataType)var5_2._2();
                if (!DoubleType$.MODULE$.equals(var8_5) || !LongType$.MODULE$.equals(var9_6)) break block9;
                v1 = true;
                break block10;
            }
            if (var5_2 == null) ** GOTO lbl-1000
            var10_7 = (DataType)var5_2._1();
            var11_8 = (DataType)var5_2._2();
            if (LongType$.MODULE$.equals(var10_7) && DoubleType$.MODULE$.equals(var11_8)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
        }
        if (v1) {
            return StringType$.MODULE$;
        }
        if (var5_2 != null) {
            t1 = (DataType)var5_2._1();
            t2 = (DataType)var5_2._2();
            return (DataType)TypeCoercion$.MODULE$.findWiderTypeForTwo(t1, t2).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$findWiderTypeForPartitionColumn$2(), ()Lorg/apache/spark/sql/types/StringType$;)());
        }
        throw new MatchError((Object)var5_2);
    }

    private PartitioningUtils$() {
    }
}

