/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetColumn;
import org.apache.spark.sql.execution.datasources.parquet.ParquetColumn$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VariantType$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\rf\u0001B\u0010!\u0001=B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005o!A1\b\u0001B\u0001B\u0003%q\u0007\u0003\u0005=\u0001\t\u0005\t\u0015!\u00038\u0011!i\u0004A!A!\u0002\u00139\u0004\"\u0002 \u0001\t\u0003y\u0004\"\u0002 \u0001\t\u00039\u0005\"\u0002 \u0001\t\u0003\u0001\u0006\"B-\u0001\t\u0003Q\u0006\"\u00026\u0001\t\u0003Y\u0007bB;\u0001#\u0003%\tA\u001e\u0005\b\u0003\u0007\u0001A\u0011BA\u0003\u0011!\tI\u0002AI\u0001\n\u00131\bbBA\u000e\u0001\u0011%\u0011Q\u0004\u0005\b\u0003s\u0001A\u0011AA\u001e\u0011%\t\u0019\u0006AI\u0001\n\u0003\t)\u0006C\u0004\u0002Z\u0001!I!a\u0017\t\u0013\u0005%\u0004!%A\u0005\n\u0005U\u0003bBA6\u0001\u0011%\u0011Q\u000e\u0005\n\u0003g\u0002\u0011\u0013!C\u0005\u0003+Bq!!\u001e\u0001\t\u0013\t9\b\u0003\u0005\u0002|\u0001!\t\u0001IA?\u000f%\ti\tIA\u0001\u0012\u0003\tyI\u0002\u0005 A\u0005\u0005\t\u0012AAI\u0011\u0019q\u0004\u0004\"\u0001\u0002\u0014\"I\u0011Q\u0013\r\u0012\u0002\u0013\u0005\u0011q\u0013\u0005\n\u00037C\u0012\u0013!C\u0001\u0003/C\u0011\"!(\u0019#\u0003%\t!a&\t\u0013\u0005}\u0005$%A\u0005\u0002\u0005]\u0005\"CAQ1E\u0005I\u0011AAL\u0005u\u0001\u0016M]9vKR$vn\u00159be.\u001c6\r[3nC\u000e{gN^3si\u0016\u0014(BA\u0011#\u0003\u001d\u0001\u0018M]9vKRT!a\t\u0013\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003K\u0019\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u001dB\u0013aA:rY*\u0011\u0011FK\u0001\u0006gB\f'o\u001b\u0006\u0003W1\na!\u00199bG\",'\"A\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0004CA\u00195\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$AB!osJ+g-\u0001\u000bbgN,X.\u001a\"j]\u0006\u0014\u00180S:TiJLgn\u001a\t\u0003caJ!!\u000f\u001a\u0003\u000f\t{w\u000e\\3b]\u00061\u0012m]:v[\u0016Le\u000e^\u001d7\u0013N$\u0016.\\3ti\u0006l\u0007/A\u0007dCN,7+\u001a8tSRLg/Z\u0001\u0012S:4WM\u001d+j[\u0016\u001cH/Y7q\u001dRS\u0016a\u00038b]>\u001c\u0018i\u001d'p]\u001e\fa\u0001P5oSRtDC\u0002!C\u0007\u0012+e\t\u0005\u0002B\u00015\t\u0001\u0005C\u00047\rA\u0005\t\u0019A\u001c\t\u000fi2\u0001\u0013!a\u0001o!91H\u0002I\u0001\u0002\u00049\u0004b\u0002\u001f\u0007!\u0003\u0005\ra\u000e\u0005\b{\u0019\u0001\n\u00111\u00018)\t\u0001\u0005\nC\u0003J\u000f\u0001\u0007!*\u0001\u0003d_:4\u0007CA&O\u001b\u0005a%BA''\u0003!Ig\u000e^3s]\u0006d\u0017BA(M\u0005\u001d\u0019\u0016\u000bT\"p]\u001a$\"\u0001Q)\t\u000b%C\u0001\u0019\u0001*\u0011\u0005M;V\"\u0001+\u000b\u0005%+&B\u0001,+\u0003\u0019A\u0017\rZ8pa&\u0011\u0001\f\u0016\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u000f\r|gN^3siR\u00111,\u0019\t\u00039~k\u0011!\u0018\u0006\u0003=\u001a\nQ\u0001^=qKNL!\u0001Y/\u0003\u0015M#(/^2u)f\u0004X\rC\u0003c\u0013\u0001\u00071-A\u0007qCJ\fX/\u001a;TG\",W.\u0019\t\u0003I\"l\u0011!\u001a\u0006\u0003M\u001e\faa]2iK6\f'BA\u0011+\u0013\tIWMA\u0006NKN\u001c\u0018mZ3UsB,\u0017\u0001F2p]Z,'\u000f\u001e)beF,X\r^\"pYVlg\u000eF\u0002m_B\u0004\"!Q7\n\u00059\u0004#!\u0004)beF,X\r^\"pYVlg\u000eC\u0003c\u0015\u0001\u00071\rC\u0004r\u0015A\u0005\t\u0019\u0001:\u0002\u001fM\u0004\u0018M]6SK\u0006$7k\u00195f[\u0006\u00042!M:\\\u0013\t!(G\u0001\u0004PaRLwN\\\u0001\u001fG>tg/\u001a:u!\u0006\u0014\u0018/^3u\u0007>dW/\u001c8%I\u00164\u0017-\u001e7uII*\u0012a\u001e\u0016\u0003eb\\\u0013!\u001f\t\u0003u~l\u0011a\u001f\u0006\u0003yv\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005y\u0014\u0014AC1o]>$\u0018\r^5p]&\u0019\u0011\u0011A>\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\bd_:4XM\u001d;J]R,'O\\1m)\u0015a\u0017qAA\f\u0011\u001d\tI\u0001\u0004a\u0001\u0003\u0017\t1b\u001a:pkB\u001cu\u000e\\;n]B!\u0011QBA\n\u001b\t\tyAC\u0002\u0002\u0012\u001d\f!![8\n\t\u0005U\u0011q\u0002\u0002\u000e\u000fJ|W\u000f]\"pYVlg.S(\t\u000fEd\u0001\u0013!a\u0001e\u0006I2m\u001c8wKJ$\u0018J\u001c;fe:\fG\u000e\n3fM\u0006,H\u000e\u001e\u00133\u0003IqwN]7bY&TXMR5fY\u0012t\u0015-\\3\u0015\t\u0005}\u0011Q\u0007\t\u0005\u0003C\tyC\u0004\u0003\u0002$\u0005-\u0002cAA\u0013e5\u0011\u0011q\u0005\u0006\u0004\u0003Sq\u0013A\u0002\u001fs_>$h(C\u0002\u0002.I\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0019\u0003g\u0011aa\u0015;sS:<'bAA\u0017e!9\u0011q\u0007\bA\u0002\u0005}\u0011\u0001\u00028b[\u0016\fAbY8om\u0016\u0014HOR5fY\u0012$R\u0001\\A\u001f\u0003\u000fBq!a\u0010\u0010\u0001\u0004\t\t%A\u0003gS\u0016dG\r\u0005\u0003\u0002\u000e\u0005\r\u0013\u0002BA#\u0003\u001f\u0011\u0001bQ8mk6t\u0017j\u0014\u0005\n\u0003\u0013z\u0001\u0013!a\u0001\u0003\u0017\nQb\u001d9be.\u0014V-\u00193UsB,\u0007\u0003B\u0019t\u0003\u001b\u00022\u0001XA(\u0013\r\t\t&\u0018\u0002\t\t\u0006$\u0018\rV=qK\u000612m\u001c8wKJ$h)[3mI\u0012\"WMZ1vYR$#'\u0006\u0002\u0002X)\u001a\u00111\n=\u0002+\r|gN^3siB\u0013\u0018.\\5uSZ,g)[3mIR)A.!\u0018\u0002h!9\u0011qL\tA\u0002\u0005\u0005\u0014a\u00049sS6LG/\u001b<f\u0007>dW/\u001c8\u0011\t\u00055\u00111M\u0005\u0005\u0003K\nyAA\tQe&l\u0017\u000e^5wK\u000e{G.^7o\u0013>C\u0011\"!\u0013\u0012!\u0003\u0005\r!a\u0013\u0002?\r|gN^3siB\u0013\u0018.\\5uSZ,g)[3mI\u0012\"WMZ1vYR$#'A\td_:4XM\u001d;He>,\bOR5fY\u0012$R\u0001\\A8\u0003cBq!!\u0003\u0014\u0001\u0004\tY\u0001C\u0005\u0002JM\u0001\n\u00111\u0001\u0002L\u0005Y2m\u001c8wKJ$xI]8va\u001aKW\r\u001c3%I\u00164\u0017-\u001e7uII\n1cY8om\u0016\u0014HOV1sS\u0006tGOR5fY\u0012$2\u0001\\A=\u0011\u001d\tI!\u0006a\u0001\u0003\u0017\tQ\"[:FY\u0016lWM\u001c;UsB,G#B\u001c\u0002\u0000\u0005%\u0005bBAA-\u0001\u0007\u00111Q\u0001\re\u0016\u0004X-\u0019;fIRK\b/\u001a\t\u0004I\u0006\u0015\u0015bAADK\n!A+\u001f9f\u0011\u001d\tYI\u0006a\u0001\u0003?\t!\u0002]1sK:$h*Y7f\u0003u\u0001\u0016M]9vKR$vn\u00159be.\u001c6\r[3nC\u000e{gN^3si\u0016\u0014\bCA!\u0019'\tA\u0002\u0007\u0006\u0002\u0002\u0010\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*\"!!'+\u0005]B\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0001")
public class ParquetToSparkSchemaConverter {
    private final boolean assumeBinaryIsString;
    private final boolean assumeInt96IsTimestamp;
    private final boolean caseSensitive;
    private final boolean inferTimestampNTZ;
    private final boolean nanosAsLong;

    public static boolean $lessinit$greater$default$5() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$5();
    }

    public static boolean $lessinit$greater$default$4() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$4();
    }

    public static boolean $lessinit$greater$default$3() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean $lessinit$greater$default$2() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$1() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$1();
    }

    public StructType convert(MessageType parquetSchema) {
        MessageColumnIO column = new ColumnIOFactory().getColumnIO(parquetSchema);
        ParquetColumn converted = this.convertInternal((GroupColumnIO)column, this.convertInternal$default$2());
        return (StructType)converted.sparkType();
    }

    public ParquetColumn convertParquetColumn(MessageType parquetSchema, Option<StructType> sparkReadSchema) {
        MessageColumnIO column = new ColumnIOFactory().getColumnIO(parquetSchema);
        return this.convertInternal((GroupColumnIO)column, sparkReadSchema);
    }

    public Option<StructType> convertParquetColumn$default$2() {
        return None$.MODULE$;
    }

    private ParquetColumn convertInternal(GroupColumnIO groupColumn, Option<StructType> sparkReadSchema) {
        Option schemaMapOpt = sparkReadSchema.map((Function1 & Serializable)schema -> ((IterableOnceOps)schema.map((Function1 & Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.normalizeFieldName(f.name())), f))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        IndexedSeq converted = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), groupColumn.getChildrenCount()).map((Function1 & Serializable)i -> ParquetToSparkSchemaConverter.$anonfun$convertInternal$3(this, groupColumn, schemaMapOpt, BoxesRunTime.unboxToInt((Object)i)));
        return ParquetColumn$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)converted.map((Function1 & Serializable)x$3 -> (StructField)x$3._1())), groupColumn, (Seq<ParquetColumn>)((Seq)converted.map((Function1 & Serializable)x$4 -> (ParquetColumn)x$4._2())));
    }

    private Option<StructType> convertInternal$default$2() {
        return None$.MODULE$;
    }

    private String normalizeFieldName(String name) {
        if (this.caseSensitive) {
            return name;
        }
        return name.toLowerCase(Locale.ROOT);
    }

    public ParquetColumn convertField(ColumnIO field, Option<DataType> sparkReadType) {
        Option targetType = sparkReadType.map((Function1 & Serializable)x0$1 -> {
            DataType dataType = x0$1;
            if (dataType instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType;
                return userDefinedType.sqlType();
            }
            return dataType;
        });
        boolean bl = false;
        GroupColumnIO groupColumnIO = null;
        ColumnIO columnIO = field;
        if (columnIO instanceof PrimitiveColumnIO) {
            PrimitiveColumnIO primitiveColumnIO = (PrimitiveColumnIO)columnIO;
            return this.convertPrimitiveField(primitiveColumnIO, (Option<DataType>)targetType);
        }
        if (columnIO instanceof GroupColumnIO) {
            bl = true;
            groupColumnIO = (GroupColumnIO)columnIO;
            if (targetType.contains((Object)VariantType$.MODULE$)) {
                return this.convertVariantField(groupColumnIO);
            }
        }
        if (bl) {
            return this.convertGroupField(groupColumnIO, (Option<DataType>)targetType);
        }
        throw new MatchError((Object)columnIO);
    }

    public Option<DataType> convertField$default$2() {
        return None$.MODULE$;
    }

    private ParquetColumn convertPrimitiveField(PrimitiveColumnIO primitiveColumn, Option<DataType> sparkReadType) {
        PrimitiveType parquetType = primitiveColumn.getType().asPrimitiveType();
        LogicalTypeAnnotation typeAnnotation = primitiveColumn.getType().getLogicalTypeAnnotation();
        PrimitiveType.PrimitiveTypeName typeName = primitiveColumn.getPrimitive();
        DataType sparkType = (DataType)sparkReadType.getOrElse((Function0 & Serializable)() -> {
            PrimitiveType.PrimitiveTypeName primitiveTypeName;
            block51: {
                LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalTypeAnnotation;
                boolean bl;
                block52: {
                    block53: {
                        primitiveTypeName = typeName;
                        if (PrimitiveType.PrimitiveTypeName.BOOLEAN.equals(primitiveTypeName)) {
                            return BooleanType$.MODULE$;
                        }
                        if (PrimitiveType.PrimitiveTypeName.FLOAT.equals(primitiveTypeName)) {
                            return FloatType$.MODULE$;
                        }
                        if (PrimitiveType.PrimitiveTypeName.DOUBLE.equals(primitiveTypeName)) {
                            return DoubleType$.MODULE$;
                        }
                        if (PrimitiveType.PrimitiveTypeName.INT32.equals(primitiveTypeName)) {
                            boolean bl2 = false;
                            LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalTypeAnnotation = null;
                            LogicalTypeAnnotation logicalTypeAnnotation = typeAnnotation;
                            if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
                                bl2 = true;
                                intLogicalTypeAnnotation = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalTypeAnnotation;
                                if (intLogicalTypeAnnotation.isSigned()) {
                                    int n = intLogicalTypeAnnotation.getBitWidth();
                                    switch (n) {
                                        case 8: {
                                            return ByteType$.MODULE$;
                                        }
                                        case 16: {
                                            return ShortType$.MODULE$;
                                        }
                                        case 32: {
                                            return IntegerType$.MODULE$;
                                        }
                                    }
                                    throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                                }
                            }
                            if (logicalTypeAnnotation == null) {
                                return IntegerType$.MODULE$;
                            }
                            if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) {
                                return DateType$.MODULE$;
                            }
                            if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                                return ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_INT_DIGITS(), typeAnnotation, typeName);
                            }
                            if (bl2 && !intLogicalTypeAnnotation.isSigned()) {
                                int n = intLogicalTypeAnnotation.getBitWidth();
                                switch (n) {
                                    case 8: {
                                        return ShortType$.MODULE$;
                                    }
                                    case 16: {
                                        return IntegerType$.MODULE$;
                                    }
                                    case 32: {
                                        return LongType$.MODULE$;
                                    }
                                }
                                throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                            }
                            if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
                                LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalTypeAnnotation2 = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalTypeAnnotation;
                                LogicalTypeAnnotation.TimeUnit timeUnit = timestampLogicalTypeAnnotation2.getUnit();
                                LogicalTypeAnnotation.TimeUnit timeUnit2 = LogicalTypeAnnotation.TimeUnit.MILLIS;
                                if (!(timeUnit != null ? !timeUnit.equals(timeUnit2) : timeUnit2 != null)) {
                                    throw ParquetToSparkSchemaConverter.typeNotImplemented$1(typeAnnotation, typeName);
                                }
                            }
                            throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                        }
                        if (!PrimitiveType.PrimitiveTypeName.INT64.equals(primitiveTypeName)) break block51;
                        boolean bl3 = false;
                        LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalTypeAnnotation = null;
                        bl = false;
                        timestampLogicalTypeAnnotation = null;
                        LogicalTypeAnnotation logicalTypeAnnotation = typeAnnotation;
                        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
                            bl3 = true;
                            intLogicalTypeAnnotation = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalTypeAnnotation;
                            if (intLogicalTypeAnnotation.isSigned()) {
                                int n = intLogicalTypeAnnotation.getBitWidth();
                                switch (n) {
                                    case 64: {
                                        return LongType$.MODULE$;
                                    }
                                }
                                throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                            }
                        }
                        if (logicalTypeAnnotation == null) {
                            return LongType$.MODULE$;
                        }
                        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                            return ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_LONG_DIGITS(), typeAnnotation, typeName);
                        }
                        if (bl3 && !intLogicalTypeAnnotation.isSigned()) {
                            int n = intLogicalTypeAnnotation.getBitWidth();
                            switch (n) {
                                case 64: {
                                    return new DecimalType(20, 0);
                                }
                            }
                            throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
                        }
                        if (!(logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)) break block52;
                        bl = true;
                        timestampLogicalTypeAnnotation = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalTypeAnnotation;
                        LogicalTypeAnnotation.TimeUnit timeUnit = timestampLogicalTypeAnnotation.getUnit();
                        LogicalTypeAnnotation.TimeUnit timeUnit3 = LogicalTypeAnnotation.TimeUnit.MICROS;
                        if (!(timeUnit == null ? timeUnit3 != null : !timeUnit.equals(timeUnit3))) break block53;
                        LogicalTypeAnnotation.TimeUnit timeUnit4 = timestampLogicalTypeAnnotation.getUnit();
                        LogicalTypeAnnotation.TimeUnit timeUnit5 = LogicalTypeAnnotation.TimeUnit.MILLIS;
                        if (timeUnit4 != null ? !timeUnit4.equals(timeUnit5) : timeUnit5 != null) break block52;
                    }
                    if (timestampLogicalTypeAnnotation.isAdjustedToUTC() || !$this.inferTimestampNTZ) {
                        return TimestampType$.MODULE$;
                    }
                    return TimestampNTZType$.MODULE$;
                }
                if (bl) {
                    LogicalTypeAnnotation.TimeUnit timeUnit = timestampLogicalTypeAnnotation.getUnit();
                    LogicalTypeAnnotation.TimeUnit timeUnit6 = LogicalTypeAnnotation.TimeUnit.NANOS;
                    if (!(timeUnit != null ? !timeUnit.equals(timeUnit6) : timeUnit6 != null) && $this.nanosAsLong) {
                        return LongType$.MODULE$;
                    }
                }
                throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
            }
            if (PrimitiveType.PrimitiveTypeName.INT96.equals(primitiveTypeName)) {
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> $this.assumeInt96IsTimestamp, "INT96 is not supported unless it's interpreted as timestamp. Please try to set " + SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key() + " to true.");
                return TimestampType$.MODULE$;
            }
            if (PrimitiveType.PrimitiveTypeName.BINARY.equals(primitiveTypeName)) {
                boolean bl = false;
                LogicalTypeAnnotation logicalTypeAnnotation = null;
                LogicalTypeAnnotation logicalTypeAnnotation2 = typeAnnotation;
                if (logicalTypeAnnotation2 instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation ? true : (logicalTypeAnnotation2 instanceof LogicalTypeAnnotation.EnumLogicalTypeAnnotation ? true : logicalTypeAnnotation2 instanceof LogicalTypeAnnotation.JsonLogicalTypeAnnotation)) {
                    return StringType$.MODULE$;
                }
                if (logicalTypeAnnotation2 == null) {
                    bl = true;
                    logicalTypeAnnotation = logicalTypeAnnotation2;
                    if ($this.assumeBinaryIsString) {
                        return StringType$.MODULE$;
                    }
                }
                if (bl) {
                    return BinaryType$.MODULE$;
                }
                if (logicalTypeAnnotation2 instanceof LogicalTypeAnnotation.BsonLogicalTypeAnnotation) {
                    return BinaryType$.MODULE$;
                }
                if (logicalTypeAnnotation2 instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                    return ParquetToSparkSchemaConverter.makeDecimalType$1(ParquetToSparkSchemaConverter.makeDecimalType$default$1$1(), typeAnnotation, typeName);
                }
                throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
            }
            if (PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY.equals(primitiveTypeName)) {
                LogicalTypeAnnotation logicalTypeAnnotation = typeAnnotation;
                if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                    return ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.maxPrecisionForBytes(parquetType.getTypeLength()), typeAnnotation, typeName);
                }
                if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.IntervalLogicalTypeAnnotation) {
                    throw ParquetToSparkSchemaConverter.typeNotImplemented$1(typeAnnotation, typeName);
                }
                if (logicalTypeAnnotation == null) {
                    return BinaryType$.MODULE$;
                }
                throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
            }
            throw ParquetToSparkSchemaConverter.illegalType$1(typeAnnotation, typeName);
        });
        return ParquetColumn$.MODULE$.apply(sparkType, primitiveColumn);
    }

    private Option<DataType> convertPrimitiveField$default$2() {
        return None$.MODULE$;
    }

    private ParquetColumn convertGroupField(GroupColumnIO groupColumn, Option<DataType> sparkReadType) {
        GroupType field = groupColumn.getType().asGroupType();
        return (ParquetColumn)Option$.MODULE$.apply((Object)field.getLogicalTypeAnnotation()).fold((Function0 & Serializable)() -> this.convertInternal(groupColumn, (Option<StructType>)sparkReadType.map((Function1 & Serializable)x$5 -> (StructType)x$5)), (Function1 & Serializable)x0$1 -> {
            LogicalTypeAnnotation logicalTypeAnnotation = x0$1;
            if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.ListLogicalTypeAnnotation) {
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> field.getFieldCount() == 1, "Invalid list type " + field);
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> sparkReadType.forall((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ParquetToSparkSchemaConverter.$anonfun$convertGroupField$6(x$6))), "Invalid Spark read type: expected " + field + " to be list type but found " + sparkReadType);
                ColumnIO repeated = groupColumn.getChild(0);
                Type repeatedType = repeated.getType();
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> repeatedType.isRepetition(Type.Repetition.REPEATED), "Invalid list type " + field);
                Option sparkReadElementType = sparkReadType.map((Function1 & Serializable)x$7 -> ((ArrayType)x$7).elementType());
                if (this.isElementType(repeatedType, field.getName())) {
                    ObjectRef converted = ObjectRef.create((Object)this.convertField(repeated, (Option<DataType>)sparkReadElementType));
                    DataType convertedType = (DataType)sparkReadElementType.getOrElse((Function0 & Serializable)() -> ((ParquetColumn)converted$1.elem).sparkType());
                    if (repeatedType.isPrimitive()) {
                        ParquetColumn qual$1 = (ParquetColumn)converted.elem;
                        boolean x$1 = true;
                        DataType x$2 = qual$1.copy$default$1();
                        Option<ColumnDescriptor> x$3 = qual$1.copy$default$2();
                        int x$4 = qual$1.copy$default$3();
                        int x$5 = qual$1.copy$default$4();
                        Seq<String> x$6 = qual$1.copy$default$6();
                        Seq<ParquetColumn> x$72 = qual$1.copy$default$7();
                        converted.elem = qual$1.copy(x$2, x$3, x$4, x$5, true, x$6, x$72);
                    }
                    return ParquetColumn$.MODULE$.apply((DataType)new ArrayType(convertedType, false), groupColumn, (Seq<ParquetColumn>)new .colon.colon((Object)((ParquetColumn)converted.elem), (List)Nil$.MODULE$));
                }
                ColumnIO element = ((GroupColumnIO)repeated).getChild(0);
                ParquetColumn converted = this.convertField(element, (Option<DataType>)sparkReadElementType);
                DataType convertedType = (DataType)sparkReadElementType.getOrElse((Function0 & Serializable)() -> converted.sparkType());
                boolean optional = element.getType().isRepetition(Type.Repetition.OPTIONAL);
                return ParquetColumn$.MODULE$.apply((DataType)new ArrayType(convertedType, optional), groupColumn, (Seq<ParquetColumn>)new .colon.colon((Object)converted, (List)Nil$.MODULE$));
            }
            if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.MapLogicalTypeAnnotation ? true : logicalTypeAnnotation instanceof LogicalTypeAnnotation.MapKeyValueTypeAnnotation) {
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> field.getFieldCount() == 1 && !field.getType(0).isPrimitive(), "Invalid map type: " + field);
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> sparkReadType.forall((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ParquetToSparkSchemaConverter.$anonfun$convertGroupField$13(x$8))), "Invalid Spark read type: expected " + field + " to be map type but found " + sparkReadType);
                GroupColumnIO keyValue = (GroupColumnIO)groupColumn.getChild(0);
                GroupType keyValueType = keyValue.getType().asGroupType();
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> keyValueType.isRepetition(Type.Repetition.REPEATED) && keyValueType.getFieldCount() == 2, "Invalid map type: " + field);
                ColumnIO key = keyValue.getChild(0);
                ColumnIO value = keyValue.getChild(1);
                Option sparkReadKeyType = sparkReadType.map((Function1 & Serializable)x$9 -> ((MapType)x$9).keyType());
                Option sparkReadValueType = sparkReadType.map((Function1 & Serializable)x$10 -> ((MapType)x$10).valueType());
                ParquetColumn convertedKey = this.convertField(key, (Option<DataType>)sparkReadKeyType);
                ParquetColumn convertedValue = this.convertField(value, (Option<DataType>)sparkReadValueType);
                DataType convertedKeyType = (DataType)sparkReadKeyType.getOrElse((Function0 & Serializable)() -> convertedKey.sparkType());
                DataType convertedValueType = (DataType)sparkReadValueType.getOrElse((Function0 & Serializable)() -> convertedValue.sparkType());
                boolean valueOptional = value.getType().isRepetition(Type.Repetition.OPTIONAL);
                return ParquetColumn$.MODULE$.apply((DataType)new MapType(convertedKeyType, convertedValueType, valueOptional), groupColumn, (Seq<ParquetColumn>)new .colon.colon((Object)convertedKey, (List)new .colon.colon((Object)convertedValue, (List)Nil$.MODULE$)));
            }
            throw QueryCompilationErrors$.MODULE$.unrecognizedParquetTypeError(field.toString());
        });
    }

    private Option<DataType> convertGroupField$default$2() {
        return None$.MODULE$;
    }

    private ParquetColumn convertVariantField(GroupColumnIO groupColumn) {
        if (groupColumn.getChildrenCount() != 2) {
            throw QueryCompilationErrors$.MODULE$.parquetTypeUnsupportedYetError("variant with more than two fields");
        }
        Seq valueAndMetadata = (Seq)new .colon.colon((Object)"value", (List)new .colon.colon((Object)"metadata", (List)Nil$.MODULE$)).map((Function1 & Serializable)colName -> {
            ColumnIO child;
            block5: {
                block4: {
                    Option idx = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), groupColumn.getChildrenCount()).find((Function1)(JFunction1.mcZI.sp & Serializable)x$11 -> {
                        String string = groupColumn.getChild(x$11).getName();
                        String string2 = colName;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    });
                    if (idx.isEmpty()) {
                        throw QueryCompilationErrors$.MODULE$.illegalParquetTypeError("variant missing " + colName + " field");
                    }
                    child = groupColumn.getChild(BoxesRunTime.unboxToInt((Object)idx.get()));
                    Type.Repetition repetition = child.getType().getRepetition();
                    Type.Repetition repetition2 = Type.Repetition.REQUIRED;
                    if ((repetition != null ? !repetition.equals(repetition2) : repetition2 != null) || !(child instanceof PrimitiveColumnIO)) break block4;
                    PrimitiveType.PrimitiveTypeName primitiveTypeName = ((PrimitiveColumnIO)child).getPrimitive();
                    PrimitiveType.PrimitiveTypeName primitiveTypeName2 = PrimitiveType.PrimitiveTypeName.BINARY;
                    if (!(primitiveTypeName == null ? primitiveTypeName2 != null : !primitiveTypeName.equals(primitiveTypeName2))) break block5;
                }
                throw QueryCompilationErrors$.MODULE$.illegalParquetTypeError("variant " + colName + " must be a non-nullable binary");
            }
            return child;
        });
        return ParquetColumn$.MODULE$.apply((DataType)VariantType$.MODULE$, groupColumn, (Seq<ParquetColumn>)new .colon.colon((Object)this.convertField((ColumnIO)valueAndMetadata.apply(0), (Option<DataType>)new Some((Object)BinaryType$.MODULE$)), (List)new .colon.colon((Object)this.convertField((ColumnIO)valueAndMetadata.apply(1), (Option<DataType>)new Some((Object)BinaryType$.MODULE$)), (List)Nil$.MODULE$)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isElementType(Type repeatedType, String parentName) {
        if (repeatedType.isPrimitive()) return true;
        if (repeatedType.asGroupType().getFieldCount() > 1) return true;
        String string = repeatedType.getName();
        String string2 = "array";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = repeatedType.getName();
        String string4 = parentName + "_tuple";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ Tuple2 $anonfun$convertInternal$3(ParquetToSparkSchemaConverter $this, GroupColumnIO groupColumn$1, Option schemaMapOpt$1, int i) {
        ColumnIO field = groupColumn$1.getChild(i);
        Option fieldFromReadSchema = schemaMapOpt$1.flatMap((Function1 & Serializable)schemaMap -> schemaMap.get((Object)$this.normalizeFieldName(field.getName())));
        Option fieldReadType = fieldFromReadSchema.map((Function1 & Serializable)x$1 -> x$1.dataType());
        Type.Repetition repetition = field.getType().getRepetition();
        Type.Repetition repetition2 = Type.Repetition.REPEATED;
        if (!(repetition != null ? !repetition.equals(repetition2) : repetition2 != null)) {
            fieldReadType = fieldReadType.flatMap((Function1 & Serializable)x0$1 -> {
                DataType dataType = x0$1;
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    return new Some((Object)arrayType.elementType());
                }
                throw QueryCompilationErrors$.MODULE$.illegalParquetTypeError(groupColumn$1.toString());
            });
        }
        ParquetColumn convertedField = $this.convertField(field, (Option<DataType>)fieldReadType);
        String fieldName = (String)fieldFromReadSchema.map((Function1 & Serializable)x$2 -> x$2.name()).getOrElse((Function0 & Serializable)() -> field.getType().getName());
        Type.Repetition repetition3 = field.getType().getRepetition();
        if (Type.Repetition.OPTIONAL.equals(repetition3) ? true : Type.Repetition.REQUIRED.equals(repetition3)) {
            Type.Repetition repetition4 = field.getType().getRepetition();
            Type.Repetition repetition5 = Type.Repetition.OPTIONAL;
            boolean nullable = !(repetition4 != null ? !repetition4.equals(repetition5) : repetition5 != null);
            return new Tuple2((Object)new StructField(fieldName, convertedField.sparkType(), nullable, StructField$.MODULE$.apply$default$4()), (Object)convertedField);
        }
        if (Type.Repetition.REPEATED.equals(repetition3)) {
            ArrayType arrayType = new ArrayType(convertedField.sparkType(), false);
            boolean x$12 = true;
            DataType x$22 = convertedField.copy$default$1();
            Option<ColumnDescriptor> x$3 = convertedField.copy$default$2();
            int x$4 = convertedField.copy$default$3();
            int x$5 = convertedField.copy$default$4();
            Seq<String> x$6 = convertedField.copy$default$6();
            Seq<ParquetColumn> x$7 = convertedField.copy$default$7();
            return new Tuple2((Object)new StructField(fieldName, (DataType)arrayType, false, StructField$.MODULE$.apply$default$4()), (Object)new ParquetColumn((DataType)arrayType, (Option<ColumnDescriptor>)None$.MODULE$, convertedField.repetitionLevel() - 1, convertedField.definitionLevel() - 1, true, convertedField.path(), (Seq<ParquetColumn>)new .colon.colon((Object)convertedField.copy(x$22, x$3, x$4, x$5, true, x$6, x$7), (List)Nil$.MODULE$)));
        }
        throw new MatchError((Object)repetition3);
    }

    private static final String typeString$1(LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        if (typeAnnotation$1 == null) {
            return String.valueOf(typeName$1);
        }
        return typeName$1 + " (" + typeAnnotation$1 + ")";
    }

    private static final Nothing$ typeNotImplemented$1(LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw QueryCompilationErrors$.MODULE$.parquetTypeUnsupportedYetError(ParquetToSparkSchemaConverter.typeString$1(typeAnnotation$1, typeName$1));
    }

    private static final Nothing$ illegalType$1(LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw QueryCompilationErrors$.MODULE$.illegalParquetTypeError(ParquetToSparkSchemaConverter.typeString$1(typeAnnotation$1, typeName$1));
    }

    private static final DecimalType makeDecimalType$1(int maxPrecision, LogicalTypeAnnotation typeAnnotation$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalTypeAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)typeAnnotation$1;
        int precision = decimalLogicalTypeAnnotation.getPrecision();
        int scale = decimalLogicalTypeAnnotation.getScale();
        ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> maxPrecision == -1 || 1 <= precision && precision <= maxPrecision, "Invalid decimal precision: " + typeName$1 + " cannot store " + precision + " digits (max " + maxPrecision + ")");
        return new DecimalType(precision, scale);
    }

    private static final int makeDecimalType$default$1$1() {
        return -1;
    }

    public static final /* synthetic */ boolean $anonfun$convertGroupField$6(DataType x$6) {
        return x$6 instanceof ArrayType;
    }

    public static final /* synthetic */ boolean $anonfun$convertGroupField$13(DataType x$8) {
        return x$8 instanceof MapType;
    }

    public ParquetToSparkSchemaConverter(boolean assumeBinaryIsString, boolean assumeInt96IsTimestamp, boolean caseSensitive, boolean inferTimestampNTZ, boolean nanosAsLong) {
        this.assumeBinaryIsString = assumeBinaryIsString;
        this.assumeInt96IsTimestamp = assumeInt96IsTimestamp;
        this.caseSensitive = caseSensitive;
        this.inferTimestampNTZ = inferTimestampNTZ;
        this.nanosAsLong = nanosAsLong;
    }

    public ParquetToSparkSchemaConverter(SQLConf conf) {
        this(conf.isParquetBinaryAsString(), conf.isParquetINT96AsTimestamp(), conf.caseSensitiveAnalysis(), conf.parquetInferTimestampNTZEnabled(), conf.legacyParquetNanosAsLong());
    }

    public ParquetToSparkSchemaConverter(Configuration conf) {
        this(StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key()))), StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()))), StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.CASE_SENSITIVE().key()))), StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_INFER_TIMESTAMP_NTZ_ENABLED().key()))), StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key()))));
    }
}

