/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.FileNotFoundException;
import org.apache.spark.SparkException;
import org.apache.spark.SparkUpgradeException;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.SchemaColumnConvertNotSupportedException;
import scala.Function0;
import scala.MatchError;
import scala.collection.immutable.Seq;
import scala.util.control.NonFatal$;

public final class FileDataSourceV2$ {
    public static final FileDataSourceV2$ MODULE$ = new FileDataSourceV2$();
    private static ObjectMapper objectMapper;
    private static volatile boolean bitmap$0;

    private ObjectMapper objectMapper$lzycompute() {
        FileDataSourceV2$ fileDataSourceV2$ = this;
        synchronized (fileDataSourceV2$) {
            if (!bitmap$0) {
                objectMapper = new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$);
                bitmap$0 = true;
            }
        }
        return objectMapper;
    }

    private ObjectMapper objectMapper() {
        if (!bitmap$0) {
            return this.objectMapper$lzycompute();
        }
        return objectMapper;
    }

    public Seq<String> org$apache$spark$sql$execution$datasources$v2$FileDataSourceV2$$readPathsToSeq(String paths) {
        return (Seq)this.objectMapper().readValue(paths, Seq.class);
    }

    public Throwable attachFilePath(Function0<String> filePath, Throwable ex) {
        Throwable throwable = ex;
        if (throwable instanceof SparkUpgradeException) {
            SparkUpgradeException sparkUpgradeException = (SparkUpgradeException)throwable;
            throw sparkUpgradeException;
        }
        if (throwable instanceof SparkException) {
            SparkException sparkException = (SparkException)throwable;
            String string = sparkException.getErrorClass();
            String string2 = "FAILED_READ_FILE.CANNOT_READ_FILE_FOOTER";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw sparkException;
            }
        }
        if (throwable instanceof SchemaColumnConvertNotSupportedException) {
            SchemaColumnConvertNotSupportedException schemaColumnConvertNotSupportedException = (SchemaColumnConvertNotSupportedException)throwable;
            throw QueryExecutionErrors$.MODULE$.parquetColumnDataTypeMismatchError((String)filePath.apply(), schemaColumnConvertNotSupportedException.getColumn(), schemaColumnConvertNotSupportedException.getLogicalType(), schemaColumnConvertNotSupportedException.getPhysicalType(), (Exception)schemaColumnConvertNotSupportedException);
        }
        if (throwable instanceof FileNotFoundException) {
            FileNotFoundException fileNotFoundException = (FileNotFoundException)throwable;
            throw QueryExecutionErrors$.MODULE$.fileNotExistError((String)filePath.apply(), (Exception)fileNotFoundException);
        }
        if (NonFatal$.MODULE$.apply(throwable)) {
            throw QueryExecutionErrors$.MODULE$.cannotReadFilesError(throwable, (String)filePath.apply());
        }
        throw new MatchError((Object)throwable);
    }

    private FileDataSourceV2$() {
    }
}

